//
//  PPBarView.m
//  
//
//  Created by Mike on 13/5/22.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPBarView.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
static NSMutableDictionary *staticBarStyleDictionary = nil;

static NSString *BarStyleKey_BackgroundColor = @"BarStyleKey_BackgroundColor";
static NSString *BarStyleKey_IgnoreEdgeInset = @"BarStyleKey_IgnoreEdgeInset";
static NSString *BarStyleKey_TitleTextColor = @"BarStyleKey_TitleTextColor";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Resource

NSString *ImageNamePPBarViewBackgroundForNavigationBar  = @"PPBarViewBackgroundForNavigationBar";
NSString *ImageNamePPBarViewBackgroundForTabBar         = @"PPBarViewBackgroundForTabBar";
NSString *ImageNamePPBarViewBackgroundForToolBar        = @"PPBarViewBackgroundForToolBar";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPBarView()

@interface PPBarView()
@property(nonatomic,retain) NSMutableDictionary *blockModels;
@property(nonatomic,retain,readwrite)   UIView *bottomLineView;
- (id)keyForBlockType:(PPBarViewBlockType)blockType;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPBarView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize	blockModels         = blockModels_;
@synthesize	tintColor           = tintColor_;
@synthesize	backgroundImageView = backgroundImageView_;
@synthesize	style               = style_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects


//==============================================================================
//
//==============================================================================
- (id)initWithFrame:(CGRect)frame
{
	if((self = [super initWithFrame:frame]))
	{
		self.userInteractionEnabled = YES;
        
        UIColor *defaultColor = [PPBarView barBackgroundColor];
        if (defaultColor==nil)
        {
            defaultColor = [UIColor clearColor];
        }
        
        self.backgroundColor = defaultColor;
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        blockModels_ = [[NSMutableDictionary alloc] init];
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        backgroundImageView_ = [[UIImageView alloc] initWithFrame:self.bounds];
        if(self.backgroundImageView!=nil)
        {
            [self addSubview:self.backgroundImageView];
        }
        
        _bottomLineView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, self.bounds.size.width, 1)];
        [self.bottomLineView setBackgroundColor:[UIColor clearColor]];
        [self addSubview:self.bottomLineView];
        //////////////////////////////////////////////////
        _ignoreEdgeInset = [PPBarView ignoreEdgeInset];
	}
	
	return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    for(PPBarViewBlockType blockType=PPBarViewBlockType_Left; blockType<=PPBarViewBlockType_Bottom; blockType++)
    {
        [self setItemModels:nil forBlockType:blockType];
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    [self.backgroundImageView removeFromSuperview];
    [backgroundImageView_ release];
    backgroundImageView_ = nil;
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    // ios 8要call這個，不然可能會有leak
    [blockModels_ removeAllObjects];
    [blockModels_ release];
    blockModels_ = nil;
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    [tintColor_ release];
    tintColor_ = nil;
    
    [self.bottomLineView removeFromSuperview];
    self.bottomLineView = nil;
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Laying out Subviews


//==============================================================================
//
//==============================================================================
- (void)layoutSubviews
{
	[super layoutSubviews];
	
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    if(CGRectIsEmpty(self.bounds)==NO)
    {
        self.backgroundImageView.frame = self.bounds;
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if(self.bounds.size.width>=self.bounds.size.height)
        {
            switch(self.style)
            {
                case PPBarViewStyle_Average:
                {
                    CGFloat     remainingWidth  = self.bounds.size.width;
                    NSUInteger  itemCount       = 0;
                    
                    ////////////////////////////////////////////////////////////////////////////////////////////////////
                    
                    for(PPBarViewBlockType blockType=PPBarViewBlockType_Left; blockType<=PPBarViewBlockType_Right; blockType++)
                    {
                        PPBarViewBlockModel *blockModel = [self blockModelForType:blockType];
                        if(blockModel!=nil)
                        {
                            itemCount += [blockModel.itemModels count];
                            
                            UIEdgeInsets edgeInsetsForBlock = self.ignoreEdgeInset?UIEdgeInsetsZero:[blockModel edgeInsetsForNormalBar];
                            
                            edgeInsetsForBlock = UIEdgeInsetsMake(
                                                                  edgeInsetsForBlock.top+self.addtionBlockEdgeInsets.top, edgeInsetsForBlock.left+self.addtionBlockEdgeInsets.left, edgeInsetsForBlock.bottom+self.addtionBlockEdgeInsets.bottom, edgeInsetsForBlock.right+self.addtionBlockEdgeInsets.right
                                                                  );
                            
                            remainingWidth -= (edgeInsetsForBlock.left+edgeInsetsForBlock.right);
                            
                            for(PPBarViewItemModel *itemModel in blockModel.itemModels)
                            {
                                UIEdgeInsets edgeInsetsForItem = self.ignoreEdgeInset?UIEdgeInsetsZero:[itemModel edgeInsetsForNormalBar];
                                
                                remainingWidth -= (edgeInsetsForItem.left+edgeInsetsForItem.right);
                            }
                        }
                    }
                    
                    ////////////////////////////////////////////////////////////////////////////////////////////////////
                    
                    CGFloat averageWidth    = (remainingWidth/itemCount);
                    CGFloat marginLeft      = 0;
                    
                    ////////////////////////////////////////////////////////////////////////////////////////////////////
                    
                    for(PPBarViewBlockType blockType=PPBarViewBlockType_Left; blockType<=PPBarViewBlockType_Right; blockType++)
                    {
                        PPBarViewBlockModel *blockModel = [self blockModelForType:blockType];
                        if(blockModel!=nil)
                        {
                            UIEdgeInsets edgeInsetsForBlock = self.ignoreEdgeInset?UIEdgeInsetsZero:[blockModel edgeInsetsForNormalBar];
                            
                            edgeInsetsForBlock = UIEdgeInsetsMake(
                                                                  edgeInsetsForBlock.top+self.addtionBlockEdgeInsets.top, edgeInsetsForBlock.left+self.addtionBlockEdgeInsets.left, edgeInsetsForBlock.bottom+self.addtionBlockEdgeInsets.bottom, edgeInsetsForBlock.right+self.addtionBlockEdgeInsets.right
                                                                  );
                            
                            marginLeft += edgeInsetsForBlock.left;
                            
                            for(PPBarViewItemModel *itemModel in blockModel.itemModels)
                            {
                                UIEdgeInsets edgeInsetsForItem = self.ignoreEdgeInset?UIEdgeInsetsZero:[itemModel edgeInsetsForNormalBar];
                                
                                CGRect frame = itemModel.view.frame;
                                
                                frame.size.width    = averageWidth;
                                frame.size.height   = self.bounds.size.height-(edgeInsetsForBlock.top+edgeInsetsForBlock.bottom)-(edgeInsetsForItem.top+edgeInsetsForItem.bottom);
                                frame.origin.x      = marginLeft+edgeInsetsForItem.left;
                                frame.origin.y      = edgeInsetsForBlock.top+edgeInsetsForItem.top;
                                itemModel.view.frame = frame;
                                
                                marginLeft = (frame.origin.x+frame.size.width+edgeInsetsForItem.right);
                            }
                            
                            marginLeft += edgeInsetsForBlock.right;
                        }
                    }
                    
                    break;
                }
                case PPBarViewStyle_CenteredAbsolute:
                case PPBarViewStyle_CenteredRelative:
                {
                    CGFloat marginLeft  = 0;
                    CGFloat	marginRight = self.bounds.size.width;
                    
                    ////////////////////////////////////////////////////////////////////////////////////////////////////
                    //排左邊
                    
                    PPBarViewBlockModel *blockModelLeft = [self blockModelForType:PPBarViewBlockType_Left];
                    if(blockModelLeft!=nil)
                    {
                        UIEdgeInsets edgeInsetsForBlock = self.ignoreEdgeInset?UIEdgeInsetsZero:[blockModelLeft edgeInsetsForNormalBar];
                        
                        edgeInsetsForBlock = UIEdgeInsetsMake(
                                                              edgeInsetsForBlock.top+self.addtionBlockEdgeInsets.top, edgeInsetsForBlock.left+self.addtionBlockEdgeInsets.left, edgeInsetsForBlock.bottom+self.addtionBlockEdgeInsets.bottom, edgeInsetsForBlock.right+self.addtionBlockEdgeInsets.right
                                                              );
                        marginLeft += edgeInsetsForBlock.left;
                        
                        for(PPBarViewItemModel *itemModel in blockModelLeft.itemModels)
                        {
                            UIEdgeInsets edgeInsetsForItem = self.ignoreEdgeInset?UIEdgeInsetsZero:[itemModel edgeInsetsForNormalBar];
                            
                            CGRect frame = itemModel.view.frame;
                            frame.size.height   = self.bounds.size.height-(edgeInsetsForBlock.top+edgeInsetsForBlock.bottom)-(edgeInsetsForItem.top+edgeInsetsForItem.bottom);
                            frame.origin.x      = marginLeft+edgeInsetsForItem.left;
                            frame.origin.y      = edgeInsetsForBlock.top+edgeInsetsForItem.top;
                            itemModel.view.frame = frame;
                            
                            marginLeft = (frame.origin.x+frame.size.width+edgeInsetsForItem.right);
                        }
                        
                        marginLeft += edgeInsetsForBlock.right;
                    }
                    
                    ////////////////////////////////////////////////////////////////////////////////////////////////////
                    //排右邊
                    
                    PPBarViewBlockModel *blockModelRight = [self blockModelForType:PPBarViewBlockType_Right];
                    if(blockModelRight!=nil)
                    {
                        UIEdgeInsets edgeInsetsForBlock = self.ignoreEdgeInset?UIEdgeInsetsZero:[blockModelRight edgeInsetsForNormalBar];
                        
                        edgeInsetsForBlock = UIEdgeInsetsMake(
                                                              edgeInsetsForBlock.top+self.addtionBlockEdgeInsets.top, edgeInsetsForBlock.left+self.addtionBlockEdgeInsets.left, edgeInsetsForBlock.bottom+self.addtionBlockEdgeInsets.bottom, edgeInsetsForBlock.right+self.addtionBlockEdgeInsets.right
                                                              );
                        marginRight -= edgeInsetsForBlock.right;
                        
                        for(NSInteger itemModelIndex=[blockModelRight.itemModels count]-1; itemModelIndex>=0; itemModelIndex--)
                        {
                            PPBarViewItemModel *itemModel = [blockModelRight.itemModels objectAtIndex:itemModelIndex];
                            
                            if(itemModel!=nil)
                            {
                                UIEdgeInsets edgeInsetsForItem = self.ignoreEdgeInset?UIEdgeInsetsZero:[itemModel edgeInsetsForNormalBar];
                                
                                CGRect frame = itemModel.view.frame;
                                frame.size.height   = self.bounds.size.height-(edgeInsetsForBlock.top+edgeInsetsForBlock.bottom)-(edgeInsetsForItem.top+edgeInsetsForItem.bottom);
                                frame.origin.x      = marginRight-(edgeInsetsForItem.right+frame.size.width);
                                frame.origin.y      = edgeInsetsForBlock.top+edgeInsetsForItem.top;
                                itemModel.view.frame = frame;
                                
                                marginRight = frame.origin.x-edgeInsetsForItem.left;
                            }
                        }
                        
                        marginRight -= edgeInsetsForBlock.left;
                    }
                    
                    ////////////////////////////////////////////////////////////////////////////////////////////////////
                    //排中間
                    
                    PPBarViewBlockModel *blockModelCenter = [self blockModelForType:PPBarViewBlockType_Center];
                    if(blockModelCenter!=nil)
                    {
                        UIEdgeInsets edgeInsetsForBlock = self.ignoreEdgeInset?UIEdgeInsetsZero:[blockModelCenter edgeInsetsForNormalBar];
                        
                        edgeInsetsForBlock = UIEdgeInsetsMake(
                                                              edgeInsetsForBlock.top+self.addtionBlockEdgeInsets.top, edgeInsetsForBlock.left+self.addtionBlockEdgeInsets.left, edgeInsetsForBlock.bottom+self.addtionBlockEdgeInsets.bottom, edgeInsetsForBlock.right+self.addtionBlockEdgeInsets.right
                                                              );
                        ////////////////////////////////////////////////////////////////////////////////////////////////////
                        //計算中央Block有多寬(含EdgeInsets)
                        
                        CGFloat centerBlockWidth = (edgeInsetsForBlock.left+edgeInsetsForBlock.right);
                        
                        for(PPBarViewItemModel *itemModel in blockModelCenter.itemModels)
                        {
                            UIEdgeInsets edgeInsetsForItem = self.ignoreEdgeInset?UIEdgeInsetsZero:[itemModel edgeInsetsForNormalBar];
                            
                            centerBlockWidth += (edgeInsetsForItem.left+itemModel.view.bounds.size.width+edgeInsetsForItem.right);
                        }
                        
                        ////////////////////////////////////////////////////////////////////////////////////////////////////
                        
                        //重新計算marginLeft
                        if(self.style==PPBarViewStyle_CenteredAbsolute)
                        {
//                            marginLeft = (self.bounds.size.width-centerBlockWidth)/2;
                            
                            CGFloat marginAverage = (self.bounds.size.width-centerBlockWidth)/2;
                            
                            if(marginAverage > marginLeft)
                            {
                                marginLeft = marginAverage;
                            }
                        }
                        else
                        {
                            if(marginRight-marginLeft>centerBlockWidth)
                            {
                                marginLeft = (marginLeft+marginRight-centerBlockWidth)/2;
                            }
                        }
                        
                        ////////////////////////////////////////////////////////////////////////////////////////////////////
                        
                        for(PPBarViewItemModel *itemModel in blockModelCenter.itemModels)
                        {
                            UIEdgeInsets edgeInsetsForItem = self.ignoreEdgeInset?UIEdgeInsetsZero:[itemModel edgeInsetsForNormalBar];
                            
                            CGRect frame = itemModel.view.frame;
                            frame.size.height   = self.bounds.size.height-(edgeInsetsForBlock.top+edgeInsetsForBlock.bottom)-(edgeInsetsForItem.top+edgeInsetsForItem.bottom);
                            frame.origin.x      = marginLeft+edgeInsetsForItem.left;
                            frame.origin.y      = edgeInsetsForBlock.top+edgeInsetsForItem.top;
                            
                            if(frame.origin.x+frame.size.width>marginRight)
                            {
                                frame.size.width = marginRight-frame.origin.x;
                            }
                            
                            itemModel.view.frame = frame;
                            
                            ////////////////////////////////////////////////////////////////////////////////////////////////////
                            
                            marginLeft = (frame.origin.x+frame.size.width+edgeInsetsForItem.right);
                        }
                    }
                    
                    break;
                }
                case PPBarViewStyle_Default:
                default:
                {
                    break;
                }
            }
            
            self.bottomLineView.frame = CGRectMake(0, self.bounds.size.height-1, self.bounds.size.width, 1);
            [self bringSubviewToFront:self.bottomLineView];
        }
        else
        {
            switch(self.style)
            {
                case PPBarViewStyle_Average:
                {
                    CGFloat     remainingHeight = self.bounds.size.height;
                    NSUInteger  itemCount       = 0;
                    
                    ////////////////////////////////////////////////////////////////////////////////////////////////////
                    
                    for(PPBarViewBlockType blockType=PPBarViewBlockType_Top; blockType<=PPBarViewBlockType_Bottom; blockType++)
                    {
                        PPBarViewBlockModel *blockModel = [self blockModelForType:blockType];
                        if(blockModel!=nil)
                        {
                            itemCount += [blockModel.itemModels count];
                            
                            UIEdgeInsets edgeInsetsForBlock =self.ignoreEdgeInset?UIEdgeInsetsZero: [blockModel edgeInsetsForNormalBar];
                            
                            remainingHeight -= (edgeInsetsForBlock.top+edgeInsetsForBlock.bottom);
                            
                            for(PPBarViewItemModel *itemModel in blockModel.itemModels)
                            {
                                UIEdgeInsets edgeInsetsForItem = self.ignoreEdgeInset?UIEdgeInsetsZero:[itemModel edgeInsetsForNormalBar];
                                
                                remainingHeight -= (edgeInsetsForItem.top+edgeInsetsForItem.bottom);
                            }
                        }
                    }
                    
                    ////////////////////////////////////////////////////////////////////////////////////////////////////
                    
                    CGFloat averageHeight   = (remainingHeight/itemCount);
                    CGFloat marginTop       = 0;
                    
                    ////////////////////////////////////////////////////////////////////////////////////////////////////
                    
                    for(PPBarViewBlockType blockType=PPBarViewBlockType_Left; blockType<=PPBarViewBlockType_Right; blockType++)
                    {
                        PPBarViewBlockModel *blockModel = [self blockModelForType:blockType];
                        if(blockModel!=nil)
                        {
                            UIEdgeInsets edgeInsetsForBlock = self.ignoreEdgeInset?UIEdgeInsetsZero:[blockModel edgeInsetsForNormalBar];
                            
                            edgeInsetsForBlock = UIEdgeInsetsMake(
                                                                  edgeInsetsForBlock.top+self.addtionBlockEdgeInsets.top, edgeInsetsForBlock.left+self.addtionBlockEdgeInsets.left, edgeInsetsForBlock.bottom+self.addtionBlockEdgeInsets.bottom, edgeInsetsForBlock.right+self.addtionBlockEdgeInsets.right
                                                                  );
                            marginTop += edgeInsetsForBlock.left;
                            
                            for(PPBarViewItemModel *itemModel in blockModel.itemModels)
                            {
                                UIEdgeInsets edgeInsetsForItem = self.ignoreEdgeInset?UIEdgeInsetsZero:[itemModel edgeInsetsForNormalBar];
                                
                                CGRect frame = itemModel.view.frame;
                                
                                frame.size.width    = self.bounds.size.width-(edgeInsetsForBlock.left+edgeInsetsForBlock.right)-(edgeInsetsForItem.left+edgeInsetsForItem.right);
                                frame.size.height   = averageHeight;
                                frame.origin.x      = edgeInsetsForBlock.left+edgeInsetsForItem.left;
                                frame.origin.y      = marginTop+edgeInsetsForItem.top;
                                itemModel.view.frame = frame;
                                
                                marginTop = (frame.origin.y+frame.size.height+edgeInsetsForItem.bottom);
                            }
                            
                            marginTop += edgeInsetsForBlock.right;
                        }
                    }
                    
                    break;
                }
                case PPBarViewStyle_CenteredAbsolute:
                case PPBarViewStyle_CenteredRelative:
                {
                    CGFloat marginTop       = 0;
                    CGFloat marginBottom    = self.bounds.size.height;
                    
                    ////////////////////////////////////////////////////////////////////////////////////////////////////
                    //排上面
                    
                    PPBarViewBlockModel *blockModelTop = [self blockModelForType:PPBarViewBlockType_Top];
                    if(blockModelTop!=nil)
                    {
                        UIEdgeInsets edgeInsetsForBlock = self.ignoreEdgeInset?UIEdgeInsetsZero:[blockModelTop edgeInsetsForNormalBar];
                        
                        edgeInsetsForBlock = UIEdgeInsetsMake(
                                                              edgeInsetsForBlock.top+self.addtionBlockEdgeInsets.top, edgeInsetsForBlock.left+self.addtionBlockEdgeInsets.left, edgeInsetsForBlock.bottom+self.addtionBlockEdgeInsets.bottom, edgeInsetsForBlock.right+self.addtionBlockEdgeInsets.right
                                                              );
                        marginTop += edgeInsetsForBlock.top;
                        
                        for(PPBarViewItemModel *itemModel in blockModelTop.itemModels)
                        {
                            UIEdgeInsets edgeInsetsForItem = self.ignoreEdgeInset?UIEdgeInsetsZero:[itemModel edgeInsetsForNormalBar];
                            
                            CGRect frame = itemModel.view.frame;
                            frame.size.width    = self.bounds.size.width-(edgeInsetsForBlock.left+edgeInsetsForBlock.right)-(edgeInsetsForItem.left+edgeInsetsForItem.right);
                            frame.origin.x      = edgeInsetsForBlock.left+edgeInsetsForItem.left;
                            frame.origin.y      = marginTop+edgeInsetsForItem.top;
                            itemModel.view.frame = frame;
                            
                            marginTop = (frame.origin.y+frame.size.height+edgeInsetsForItem.bottom);
                        }
                        
                        marginTop += edgeInsetsForBlock.bottom;
                    }
                    
                    ////////////////////////////////////////////////////////////////////////////////////////////////////
                    //排下面
                    
                    PPBarViewBlockModel *blockModelBottom = [self blockModelForType:PPBarViewBlockType_Bottom];
                    if(blockModelBottom!=nil)
                    {
                        UIEdgeInsets edgeInsetsForBlock = self.ignoreEdgeInset?UIEdgeInsetsZero:[blockModelBottom edgeInsetsForNormalBar];
                        
                        edgeInsetsForBlock = UIEdgeInsetsMake(
                                                              edgeInsetsForBlock.top+self.addtionBlockEdgeInsets.top, edgeInsetsForBlock.left+self.addtionBlockEdgeInsets.left, edgeInsetsForBlock.bottom+self.addtionBlockEdgeInsets.bottom, edgeInsetsForBlock.right+self.addtionBlockEdgeInsets.right
                                                              );
                        marginBottom -= edgeInsetsForBlock.bottom;
                        
                        for(NSInteger itemModelIndex=[blockModelBottom.itemModels count]-1; itemModelIndex>=0; itemModelIndex--)
                        {
                            PPBarViewItemModel *itemModel = [blockModelBottom.itemModels objectAtIndex:itemModelIndex];
                            
                            if(itemModel!=nil)
                            {
                                UIEdgeInsets edgeInsetsForItem = self.ignoreEdgeInset?UIEdgeInsetsZero:[itemModel edgeInsetsForNormalBar];
                                
                                CGRect frame = itemModel.view.frame;
                                frame.size.width    = self.bounds.size.width-(edgeInsetsForBlock.left+edgeInsetsForBlock.right)-(edgeInsetsForItem.left+edgeInsetsForItem.right);
                                frame.origin.x      = edgeInsetsForBlock.left+edgeInsetsForItem.left;
                                frame.origin.y      = marginBottom-(edgeInsetsForItem.bottom+frame.size.height);
                                itemModel.view.frame = frame;
                                
                                marginBottom = frame.origin.y-edgeInsetsForItem.top;
                            }
                        }
                        
                        marginBottom -= edgeInsetsForBlock.top;
                    }
                    
                    ////////////////////////////////////////////////////////////////////////////////////////////////////
                    //排中間
                    
                    PPBarViewBlockModel *blockModelCenter = [self blockModelForType:PPBarViewBlockType_Center];
                    if(blockModelCenter!=nil)
                    {
                        UIEdgeInsets edgeInsetsForBlock = self.ignoreEdgeInset?UIEdgeInsetsZero:[blockModelCenter edgeInsetsForNormalBar];
                        
                        edgeInsetsForBlock = UIEdgeInsetsMake(
                                                              edgeInsetsForBlock.top+self.addtionBlockEdgeInsets.top, edgeInsetsForBlock.left+self.addtionBlockEdgeInsets.left, edgeInsetsForBlock.bottom+self.addtionBlockEdgeInsets.bottom, edgeInsetsForBlock.right+self.addtionBlockEdgeInsets.right
                                                              );
                        
                        ////////////////////////////////////////////////////////////////////////////////////////////////////
                        //計算中央Block有多寬(含EdgeInsets)
                        
                        CGFloat centerBlockHeight = (edgeInsetsForBlock.top+edgeInsetsForBlock.bottom);
                        
                        for(PPBarViewItemModel *itemModel in blockModelCenter.itemModels)
                        {
                            UIEdgeInsets edgeInsetsForItem = self.ignoreEdgeInset?UIEdgeInsetsZero:[itemModel edgeInsetsForNormalBar];
                            
                            centerBlockHeight += (edgeInsetsForItem.top+itemModel.view.bounds.size.height+edgeInsetsForItem.bottom);
                        }
                        
                        ////////////////////////////////////////////////////////////////////////////////////////////////////
                        
                        //重新計算marginTop
                        if(self.style==PPBarViewStyle_CenteredAbsolute)
                        {
                            if(marginBottom-marginTop>centerBlockHeight)
                            {
                                marginTop = (self.bounds.size.height-centerBlockHeight)/2;
                            }
                        }
                        else
                        {
                            if(marginBottom-marginTop>centerBlockHeight)
                            {
                                marginTop = (marginTop+marginBottom-centerBlockHeight)/2;
                            }
                        }
                        
                        ////////////////////////////////////////////////////////////////////////////////////////////////////
                        
                        for(PPBarViewItemModel *itemModel in blockModelCenter.itemModels)
                        {
                            UIEdgeInsets edgeInsetsForItem = self.ignoreEdgeInset?UIEdgeInsetsZero:[itemModel edgeInsetsForNormalBar];
                            
                            CGRect frame = itemModel.view.frame;
                            frame.size.width    = self.bounds.size.width-(edgeInsetsForBlock.left+edgeInsetsForBlock.right)-(edgeInsetsForItem.left+edgeInsetsForItem.right);
                            frame.origin.x      = edgeInsetsForBlock.left+edgeInsetsForItem.left;
                            frame.origin.y      = marginTop+edgeInsetsForItem.top;
                            
                            if(frame.origin.y+frame.size.height>marginBottom)
                            {
                                frame.size.height = marginBottom-frame.origin.y;
                            }
                            
                            itemModel.view.frame = frame;
                            
                            marginTop = (frame.origin.y+frame.size.height+edgeInsetsForItem.bottom);
                        }
                    }
                    
                    ////////////////////////////////////////////////////////////////////////////////////////////////////
                    
                    break;
                }
                case PPBarViewStyle_Default:
                default:
                {
                    break;
                }
            }
        }
        
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods


//==============================================================================
//
//==============================================================================
- (PPBarViewBlockModel *)blockModelForType:(PPBarViewBlockType)type
{
    return [self.blockModels objectForKey:[self keyForBlockType:type]];
}


//==============================================================================
//
//==============================================================================
- (BOOL)setBlockModel:(PPBarViewBlockModel *)blockModel forType:(PPBarViewBlockType)type
{
    BOOL result = YES;
    
    @autoreleasepool
    {
        //移除舊的View
        
        PPBarViewBlockModel *oldBlockModel = [self blockModelForType:type];
        
        for(PPBarViewItemModel *oldItemModel in oldBlockModel.itemModels)
        {
            [oldItemModel.view removeFromSuperview];
        }
        
        [oldBlockModel.itemModels removeAllObjects];
        
        [self.blockModels removeObjectForKey:[self keyForBlockType:type]];
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        for(PPBarViewItemModel *itemModel in blockModel.itemModels)
        {
            //檢查是否有不合法的ItemModel
            
            if(itemModel.view==nil)
            {
                result = NO;
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            //檢查新增的view是否已存在於其他Block
            
            for(PPBarViewBlockType otherblockType=PPBarViewBlockType_Left; otherblockType<=PPBarViewBlockType_Bottom; otherblockType++)
            {
                PPBarViewBlockModel *otherBlockModel =[self blockModelForType:otherblockType];
                if(otherBlockModel!=nil)
                {
                    for(PPBarViewItemModel *otherItemModel in otherBlockModel.itemModels)
                    {
                        if(otherItemModel.view==itemModel.view)
                        {
                            [otherItemModel.view removeFromSuperview];
                            
                            [otherBlockModel.itemModels removeObject:otherItemModel];
                            
                            if([otherBlockModel.itemModels count]==0)
                            {
                                [self.blockModels removeObjectForKey:[self keyForBlockType:otherblockType]];
                            }
                            
                            break;
                        }
                    }
                }
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            //增加新的View
            
            [self addSubview:itemModel.view];
            
            [itemModel setTintColor:self.tintColor];
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if(result==YES)
        {
            [self.blockModels setObject:blockModel forKey:[self keyForBlockType:type]];
        }
    }
    
    return result;
}


//==============================================================================
//
//==============================================================================
- (BOOL)setItemModels:(NSArray *)itemModels forBlockType:(PPBarViewBlockType)blockType
{
    BOOL result = NO;
    
    PPBarViewBlockModel *blockModel = [[PPBarViewBlockModel alloc] init];
    if(blockModel!=nil)
    {
        if(itemModels==nil)
        {
            [blockModel.itemModels removeAllObjects];
        }
        else
        {
            [blockModel.itemModels addObjectsFromArray:itemModels];
        }
        
        result = [self setBlockModel:blockModel forType:blockType];
        
        [blockModel release];
    }
    
    return result;
}


//==============================================================================
//
//==============================================================================
- (BOOL)setViews:(NSArray *)views forBlockType:(PPBarViewBlockType)blockType
{
    BOOL result = NO;
    
    @autoreleasepool
    {
        do
        {
            NSMutableArray *itemModels = nil;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////

            NSUInteger viewCount = [views count];
            if(viewCount!=0)
            {
                itemModels = [[[NSMutableArray alloc] initWithCapacity:viewCount] autorelease];
                if(itemModels==nil)
                {
                    break;
                }
                
                ////////////////////////////////////////////////////////////////////////////////////////////////////
                
                for(UIView *view in views)
                {
                    [itemModels addObject:[PPBarViewItemModel ppBarViewItemModelWithView:view]];
                }
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self setItemModels:itemModels forBlockType:blockType];
            
        }while(0);
    }
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property Methods


//==============================================================================
//
//==============================================================================
- (void)setTintColor:(UIColor *)tintColor
{
    [tintColor retain];
    [tintColor_ release];
    tintColor_ = tintColor;
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    for(PPBarViewBlockType blockType=PPBarViewBlockType_Left; blockType<=PPBarViewBlockType_Right; blockType++)
    {
        PPBarViewBlockModel *blockModel = [self blockModelForType:blockType];
        if(blockModel!=nil)
        {
            for(PPBarViewItemModel *itemModel in blockModel.itemModels)
            {
                [itemModel setTintColor:self.tintColor];
            }
        }
    }
}


//==============================================================================
//
//==============================================================================
- (void)setStyle:(PPBarViewStyle)style
{
    if(self.style!=style)
    {
        style_ = style;
        
        [self layoutSubviews];
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Methods


//==============================================================================
//
//==============================================================================
- (id)keyForBlockType:(PPBarViewBlockType)blockType
{
    return [NSNumber numberWithUnsignedInteger:blockType];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - class methods


//==============================================================================
//
//==============================================================================
+ (void)setBarBackgroundColor:(UIColor *)color
{
    if (staticBarStyleDictionary == nil)
    {
        staticBarStyleDictionary = [[NSMutableDictionary alloc] init];
    }

    if (color)
    {
        [staticBarStyleDictionary setObject:color forKey:BarStyleKey_BackgroundColor];
    }
}


//==============================================================================
//
//==============================================================================
+ (UIColor *)barBackgroundColor
{
    if (staticBarStyleDictionary)
    {
        return [staticBarStyleDictionary objectForKey:BarStyleKey_BackgroundColor];
    }
    return nil;
}


//==============================================================================
//
//==============================================================================
+ (void)setIgnoreEdgeInset:(BOOL)ignoreEdgeInset
{
    if (staticBarStyleDictionary == nil)
    {
        staticBarStyleDictionary = [[NSMutableDictionary alloc] init];
    }
    

    [staticBarStyleDictionary setObject:@(ignoreEdgeInset) forKey:BarStyleKey_IgnoreEdgeInset];
}


//==============================================================================
//
//==============================================================================
+ (BOOL)ignoreEdgeInset
{
    if (staticBarStyleDictionary)
    {
        return [[staticBarStyleDictionary objectForKey:BarStyleKey_IgnoreEdgeInset] boolValue];
    }
    
    return NO;
}


//================================================================================
//
//================================================================================
+ (void)setTitleTextColor:(UIColor *)titleTextColor
{
    if (staticBarStyleDictionary == nil)
    {
        staticBarStyleDictionary = [[NSMutableDictionary alloc] init];
    }
    
    if (titleTextColor)
    {
        [staticBarStyleDictionary setObject:titleTextColor forKey:BarStyleKey_TitleTextColor];
    }
}


//================================================================================
//
//================================================================================
+ (UIColor *)titleTextColor
{
    if (staticBarStyleDictionary)
    {
        return [staticBarStyleDictionary objectForKey:BarStyleKey_TitleTextColor];
    }
    return nil;
}
@end
