//
//  PPCollectionView.h
//  
//  Created by howard.lin on 13/3/11.
//  Copyright (c) 2013年 penpower. All rights reserved.


#import <UIKit/UIKit.h>
#import "AlbumCollectionViewCell.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@class PPCollectionView;

#pragma mark - PPCollectionViewDelegate

@protocol PPCollectionViewDelegate <NSObject>

@optional
- (BOOL)collectionView:(PPCollectionView *)collectionView shouldAddSelectedCell:(AlbumCollectionViewCell *)cell atIndexPath:(NSIndexPath *)indexPath;
- (void)collectionView:(PPCollectionView *)collectionView didSelectCell:(AlbumCollectionViewCell *)cell atIndexPath:(NSIndexPath *)indexPath;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCollectionViewDataSource

@protocol PPCollectionViewDataSource <NSObject>

@required

- (NSInteger)numberOfSectionInPPCollectionView:(PPCollectionView *)collectionView;
- (NSInteger)collectionView:(PPCollectionView *)collectionView
        numberOfRowsInSection:(NSUInteger)section;
- (AlbumCollectionViewCell *)collectionView:(PPCollectionView *)collectionView cellForRowAtIndexPath:(NSIndexPath *)indexPath;
- (CGFloat)collectionView:(PPCollectionView *)collectionView heightForRowAtIndex:(NSInteger)index;
- (void)collectionView:(PPCollectionView *)collectionView cellWidth:(CGFloat)width atIndex:(NSInteger)index;

@optional
- (NSString *)collectionView:(PPCollectionView *)collectionView titleForHeaderInSection:(NSInteger)section;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCollectionView

@interface PPCollectionView : UIScrollView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Properties

////////////////////////////////////////////////////////////////////////////////////////////////////

@property (nonatomic,assign) id <PPCollectionViewDelegate>   collectionViewDelegate;
@property (nonatomic,assign) id <PPCollectionViewDataSource> collectionViewDataSource;
@property (nonatomic,retain) UIView                          *headerView;
@property (nonatomic,retain) UIView                          *footerView;
@property (nonatomic,assign,readonly) CGFloat                columnWidth;
@property (nonatomic,assign,readonly) NSInteger              numColumns;
@property (nonatomic,assign) NSInteger                       numColumnsLandscape;
@property (nonatomic,assign) NSInteger                       numColumnsPortrait;
@property (nonatomic,assign) BOOL                            editMode;
@property (nonatomic,assign) BOOL                            scrollToEnd;
@property (nonatomic,retain) UIColor                         *headerViewBackgroundColor;
@property (nonatomic,retain) UIColor                         *headerTitleColor;
////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

- (void)reloadData;
- (void)resetAllVisibieView;
- (UIView *)dequeueReusableViewForClass:(Class)viewClass;

////////////////////////////////////////////////////////////////////////////////////////////////////

@end

