//
//  AlbumContentNavigationBarView.m
//
//  Created by Howard on 13/6/5.
//  Copyright (c) 2013年 penpower. All rights reserved.
//

#import <QuartzCore/QuartzCore.h>

// Define
#import "PPAlbumContentViewController+ResourceDefine.h"

// View
#import "AlbumContentNavigationBarView.h"

// Category
#import "NSString+Additions.h"
#import "PPAutoResizedLabel+Factory.h"
#import "PPButton+Factory.h"


////////////////////////////////////////////////////////////////////////////////////////////////////

@interface AlbumContentNavigationBarView()

@property (nonatomic,retain) PPAutoResizedLabel *autoResizedLabel;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - AlbumContentNavigationBarView

@implementation AlbumContentNavigationBarView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, Dellocaing Object

//================================================================================
//
//================================================================================
- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    
    if (self)
    {
        self.style = PPBarViewStyle_CenteredAbsolute;

        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        _backButton = [[PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                       tag:AlbumContentNavigationBarViewTag_Back
                                                  delegate:self
                                     normalBackgroundColor:nil
                                highlightedBackgroundColor:nil
                                           imageEdgeInsets:UIEdgeInsetsZero] retain];
    
        
        if(_backButton!=nil)
        {
            if(_backButton.imageView.image==nil)
            {
                [_backButton setTitle:[@"MLS_Back" localizedFromTable:NSStringFromClass([_backButton class])] maxWidth:0.0];
            }
            
            [_backButton addControlEvents:UIControlEventTouchUpInside];

            //////////////////////////////////////////////////

            PPBarViewItemModel *backItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:_backButton];
            
            if(backItemModel!=nil)
            {
                backItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                
                [self setItemModels:@[backItemModel] forBlockType:PPBarViewBlockType_Left];
            }
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        _doneButton = [[PPButton ppButtonWithIconImageName:ImageNamePPAlbumContentViewControllerButtonImport
                                                       tag:AlbumContentNavigationBarViewTag_Done
                                                  delegate:self
                                     normalBackgroundColor:nil
                                highlightedBackgroundColor:nil
                                           imageEdgeInsets:UIEdgeInsetsZero] retain];
        
        if(_doneButton!=nil)
        {
            _doneButton.delegate = self;
            _doneButton.clipsToBounds = NO;
            
            [_doneButton addControlEvents:UIControlEventTouchUpInside];
        }
        
        //////////////////////////////////////////////////

        _allSelectButton = [[PPButton ppButtonWithIconImageName:ImageNamePPAlbumContentViewControllerButtonAllSelect
                                                       tag:AlbumContentNavigationBarViewTag_AllSelect
                                                  delegate:self
                                     normalBackgroundColor:nil
                                highlightedBackgroundColor:nil
                                           imageEdgeInsets:UIEdgeInsetsZero] retain];
        
        if(_allSelectButton!=nil)
        {
            _allSelectButton.delegate = self;
            _allSelectButton.clipsToBounds = NO;
            
            [_allSelectButton addControlEvents:UIControlEventTouchUpInside];
        }
        
        //////////////////////////////////////////////////

        _autoResizedLabel = [[PPAutoResizedLabel counterStyleLableWithFont:AlbumContentNavigationBarView_CaptureCountLabelFont
                                                                 textColor:AlbumContentNavigationBarView_CaptureCountLabelTextColor
                                                           backgroundColor:AlbumContentNavigationBarView_CaptureCountLabelBGColor] retain];

        if(_autoResizedLabel!=nil)
        {
            _autoResizedLabel.contentInsets = UIEdgeInsetsMake(0, 4, 0, 4);
            _autoResizedLabel.widthMustLargerThenHeight = YES;
            _autoResizedLabel.textAlignment = NSTextAlignmentCenter;
            _autoResizedLabel.layer.masksToBounds = YES;
            _autoResizedLabel.hidden = YES;

            [_doneButton addSubview:_autoResizedLabel];
        }
    }

    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_backButton removeFromSuperview];
    [_backButton release];
    _backButton = nil;
    
    //////////////////////////////////////////////////

    [_doneButton removeFromSuperview];
    [_doneButton release];
    _doneButton = nil;
    
    //////////////////////////////////////////////////

    [self.allSelectButton removeFromSuperview];
    self.allSelectButton = nil;
    
    //////////////////////////////////////////////////

    [_autoResizedLabel removeFromSuperview];
    [_autoResizedLabel release];
    _autoResizedLabel = nil;

    //////////////////////////////////////////////////

    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate Method

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    if([self.delegate respondsToSelector:@selector(albumContentNavigationBarView:didClickButton:withControlEvent:)]==YES)
    {
        [self.delegate albumContentNavigationBarView:self didClickButton:ppButton withControlEvent:controlEvent];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)updateCaptureCountLabelWithCount:(NSInteger)count
{
    self.autoResizedLabel.hidden = (count <= 0);
    self.autoResizedLabel.text = [NSString stringWithInteger:count];
    [self.autoResizedLabel sizeToFit];
    self.autoResizedLabel.layer.cornerRadius = self.autoResizedLabel.bounds.size.height/2;
    
    self.autoResizedLabel.center = CGPointMake(self.doneButton.bounds.size.width/2-12, self.doneButton.bounds.size.height/2-8);
}


@end
