//
//  PPAlbumContentViewController.m
//
//  Created by howard.lin on 13/3/11.
//  Copyright (c) 2013年 penpower. All rights reserved.
//

#import "PPAlbumContentViewController.h"

// Define
#import "PPAlbumContentViewController+ParameterDefine.h"
#import "PPAlbumContentViewController+ResourceDefine.h"

// View
#import "PPButton.h"
#import "PPBusyView.h"

// Controller
#import "AlbumImageFileController.h"
#import "AlbumContentSectionController.h"
#import "PPAlertController.h"

// Category
#import "UIImage+Additions.h"
#import "NSError+Custom.h"
#import "NSString+Additions.h"
#import "UIViewController+ShareApplication.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPAlbumContentViewController ()<AlbumContentNavigationBarViewDelegate,PPCollectionViewDelegate,PPCollectionViewDataSource>

@property (nonatomic,retain) AlbumContentSectionController *albumContentSectionController;
@property (nonatomic,assign) BOOL                          isNeedReloadData;
@property (nonatomic,assign) CGFloat                       widthOfCell;
@property (nonatomic,retain) NSMutableDictionary           *selectedImageIndexDictionarys;
@property (nonatomic,retain) PPBusyView                    *ppBusyView;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPAlbumContentViewController

@implementation PPAlbumContentViewController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
    if(self=[super init])
    {
        _selectedMaximumCount = NSUIntegerMax;
        
        //////////////////////////////////////////////////

        _tableViewSectionTitleColor = [PPAlbumContentViewController_TableViewSectionTitleColor retain];
        
        //////////////////////////////////////////////////

        _tableViewSectionHeaderViewBackgroundColor = [PPAlbumContentViewController_TableViewSectionHeaderViewBackgroundColor retain];
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    _delegate = nil;

    self.albumContentSectionController = nil;
    
    [_selectedImageIndexDictionarys removeAllObjects];
    [_selectedImageIndexDictionarys release];
    _selectedImageIndexDictionarys = nil;
    
    [_ppBusyView removeFromSuperview];
    [_ppBusyView release];
    _ppBusyView = nil;
    
    [_albumContentView removeFromSuperview];
    [_albumContentView release];
    _albumContentView = nil;
    
    [_albumContentNavigationBarView removeFromSuperview];
    [_albumContentNavigationBarView release];
    _albumContentNavigationBarView = nil;
    
    [_navigationBarViewButtonHighlightedBackgroundColor release];
    _navigationBarViewButtonHighlightedBackgroundColor = nil;
    
    [_tableViewSectionHeaderViewBackgroundColor release];
    _tableViewSectionHeaderViewBackgroundColor = nil;
    
    [_tableViewSectionTitleColor release];
    _tableViewSectionTitleColor = nil;
    
    [_titleString release];
    _titleString = nil;
    
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to ViewEvents

//================================================================================
//
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    if(self.selectedImageIndexDictionarys==nil)
    {
        _selectedImageIndexDictionarys = [[NSMutableDictionary alloc] init];
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    if(self.albumContentNavigationBarView==nil)
    {
        _albumContentNavigationBarView = [[AlbumContentNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
    }
    
    if(self.albumContentNavigationBarView!=nil)
    {
        self.albumContentNavigationBarView.delegate = self;

        [self.albumContentNavigationBarView layoutIfNeeded];
        
        //////////////////////////////////////////////////
        
        if(self.navigationBarViewButtonHighlightedBackgroundColor!=nil)
        {
            [self.albumContentNavigationBarView.backButton setBackgroundImage:[UIImage imageWithColor:self.navigationBarViewButtonHighlightedBackgroundColor]
                                                                     forState:UIControlStateHighlighted];
            
            [self.albumContentNavigationBarView.doneButton setBackgroundImage:[UIImage imageWithColor:self.navigationBarViewButtonHighlightedBackgroundColor]
                                                                    forState:UIControlStateHighlighted];
        }
        
        //////////////////////////////////////////////////
        
        self.albumContentNavigationBarView.backButton.imageEdgeInsets = self.navigationBarViewButtonImageEdgeInset;
        self.albumContentNavigationBarView.doneButton.imageEdgeInsets = self.navigationBarViewButtonImageEdgeInset;
        
        //////////////////////////////////////////////////

        if(self.multiSelection==YES)
        {
            PPBarViewItemModel *doneItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.albumContentNavigationBarView.doneButton];
            
            doneItemModel.edgeInsetsForNormalBar = UIEdgeInsetsMake(0, PPBarViewItemModelDefaultEdgeInsertsForNormalBar.left, 0, PPBarViewItemModelDefaultEdgeInsertsForNormalBar.right);
          
            //////////////////////////////////////////////////
            
            PPBarViewItemModel *allSelectItemModel = nil;
            
            if(self.allSelect==YES)
            {
                allSelectItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.albumContentNavigationBarView.allSelectButton];
                
                allSelectItemModel.edgeInsetsForNormalBar = UIEdgeInsetsMake(0, PPBarViewItemModelDefaultEdgeInsertsForNormalBar.left, 0, PPBarViewItemModelDefaultEdgeInsertsForNormalBar.right);
            }
            
            if(doneItemModel!=nil)
            {
                if(allSelectItemModel!=nil)
                {
                   [self.albumContentNavigationBarView setItemModels:@[allSelectItemModel,doneItemModel] forBlockType:PPBarViewBlockType_Right];
                }
                else
                {
                    [self.albumContentNavigationBarView setItemModels:@[doneItemModel] forBlockType:PPBarViewBlockType_Right];
                }
            }
        }
        else
        {
            [self.albumContentNavigationBarView setViews:nil forBlockType:PPBarViewBlockType_Right];
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    if(self.albumContentView==nil)
    {
        _albumContentView = [[AlbumContentView alloc] initWithFrame:self.view.bounds];
    }
    
    if(self.albumContentView!=nil)
    {
        self.albumContentView.backgroundColor = [UIColor clearColor];
        
        self.albumContentView.editMode = NO;
        self.albumContentView.collectionViewDataSource = self;
        self.albumContentView.collectionViewDelegate   = self;
        self.albumContentView.scrollToEnd = self.scrollToEnd;
        
        //////////////////////////////////////////////////

        self.albumContentView.headerViewBackgroundColor = self.tableViewSectionHeaderViewBackgroundColor;
        self.albumContentView.headerTitleColor = self.tableViewSectionTitleColor;
        
        //////////////////////////////////////////////////

        [self.view addSubview:self.albumContentView];
        
        //////////////////////////////////////////////////

        if(self.multiSelection==YES)
        {
            self.albumContentView.editMode = YES;
        }
        else
        {
            self.albumContentView.editMode = NO;
        }
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    if(self.albumContentNavigationBarView!=nil && self.albumContentView!=nil)
    {
        [self renewImageCount];
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    //第一次呼叫，不用reloadData
    if(self.isNeedReloadData)
    {
        //切進又切出，重新讀取所有相簿資料
        [self.albumContentView reloadData];
    }
    else
    {
        self.isNeedReloadData = YES;
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    //覆蓋NavigationBarView上方列
    if(self.navigationController!=nil)
    {
        UIBarButtonItem *leftBarButtonItem = [[UIBarButtonItem alloc] initWithCustomView:self.albumContentNavigationBarView];
        if(leftBarButtonItem!=nil)
        {
            self.navigationItem.leftBarButtonItem = leftBarButtonItem;
            [leftBarButtonItem release];
        }
    }

}


//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    
    CGRect frame = [self layoutFrame];
    
    self.albumContentView.frame = frame;
}





//================================================================================
//
//================================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [super viewDidDisappear:animated];
    
    //////////////////////////////////////////////////
    
    //視圖退出，清除所有點擊狀態
    [self.selectedImageIndexDictionarys removeAllObjects];
    self.selectedImageIndexDictionarys = nil;
    
    [self.albumContentNavigationBarView removeFromSuperview];

    [_albumContentNavigationBarView removeFromSuperview];
    [_albumContentNavigationBarView release];
    _albumContentNavigationBarView = nil;
    
    [self.albumContentView removeFromSuperview];
    [_albumContentView release];
    _albumContentView = nil;
    
    //////////////////////////////////////////////////
    
    if(self.navigationItem!=nil)
    {
        self.navigationItem.leftBarButtonItem = nil;
    }
    
    //////////////////////////////////////////////////

    self.avoidAgainSendResult = NO;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - AlbumContentNavigationBarViewDelegate Method

//================================================================================
//
//================================================================================
- (void)albumContentNavigationBarView:(AlbumContentNavigationBarView *)albumContentNavigationBarView
                       didClickButton:(PPButton *)button
                     withControlEvent:(UIControlEvents)event
{
    switch (button.tag)
    {
        case AlbumContentNavigationBarViewTag_Back:
        {
            if([self.delegate respondsToSelector:@selector(albumContentViewControllerDidCancel:)])
            {
                [self.delegate albumContentViewControllerDidCancel:self];
            }
            break;
        }
        case AlbumContentNavigationBarViewTag_Done:
        {
            [self performSelectorOnMainThread:@selector(mainThreadSendFinishImagePathDictionary)
                                       withObject:nil
                                    waitUntilDone:NO];
            
            break;
        }
        case AlbumContentNavigationBarViewTag_AllSelect:
        {
            // MARK: 全選按鈕
            
            if([self.selectedImageIndexDictionarys allKeys].count<[self.albumContentSectionController rowObjectsCountForSearching:NO])
            {
                // 全選
                NSUInteger numberOfSection = [self.albumContentSectionController numberOfSectionsForSearching:NO];
                
                for(NSUInteger section=0; section<numberOfSection; section++)
                {
                    @autoreleasepool
                    {
                        PPSectionModel *sectionModel = [self.albumContentSectionController.sectionModelsForDefault objectAtIndex:section];
                        
                        //////////////////////////////////////////////////
                        
                        for(NSUInteger row=0; row<sectionModel.rowModels.count; row++)
                        {
                            PPRowModel *rowModel = [sectionModel.rowModels objectAtIndex:row];
                            
                            [self.selectedImageIndexDictionarys setObject:rowModel.object forKey:[NSString stringWithFormat:@"%zd-%zd",section,row]];
                        }
                    }
                }
            }
            else
            {
                // 不選
                [self.selectedImageIndexDictionarys removeAllObjects];
            }
            
            //////////////////////////////////////////////////
            
            [self renewImageCount];
            
            //////////////////////////////////////////////////

            [self.albumContentView reloadData];
            
            break;
        }
        default:
        {
            break;
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCollectionViewDataSource Method

//================================================================================
//
//================================================================================
- (NSInteger)numberOfSectionInPPCollectionView:(PPCollectionView *)collectionView
{
    return [self.albumContentSectionController numberOfSectionsForSearching:NO];
}


//================================================================================
//
//================================================================================
- (NSInteger)collectionView:(PPCollectionView *)collectionView
      numberOfRowsInSection:(NSUInteger)section
{
    return [self.albumContentSectionController numberOfRowsInSection:section forSearching:NO];
}


//================================================================================
//
//================================================================================
- (AlbumCollectionViewCell *)collectionView:(PPCollectionView *)collectionView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    AlbumCollectionViewCell *cell = (AlbumCollectionViewCell *)[collectionView dequeueReusableViewForClass:[AlbumCollectionViewCell class]];
    
    if(cell==nil)
    {
        cell = [[[AlbumCollectionViewCell alloc] init] autorelease];
    }
    
    //////////////////////////////////////////////////

    cell.tag = indexPath.row;

    //////////////////////////////////////////////////

    @autoreleasepool
    {
        PPRowModel *rowModel = [self.albumContentSectionController rowModelAtIndexPath:indexPath forSearching:NO];
        
        if(rowModel!=nil)
        {
            BOOL    fullImage = NO;
            
            __block UIImage *image = nil;
            
            if([[rowModel object] isKindOfClass:[PHAsset class]]==YES)
            {
                [cell retain];
                [AlbumImageFileController fetchThumbnailImageWithPHAsset:rowModel.object completeHandler:^(UIImage *result) {
                    
                    image = [result imageRotatedByDegrees:0 scalingMaxLength:0];
                    
                    //////////////////////////////////////////////////
                    
                    cell.cellImage = image;
                    [cell refresh];
                    [cell release];
                }];
            }
            else if([[rowModel object] isKindOfClass:[NSString class]]==YES)
            {
                image = [AlbumImageFileController imageWithAbsolutePath:rowModel.object];
                
                if(image!=nil)
                {
                    image = [image imageRotatedByDegrees:0 scalingMaxLength:0];
                    
                    //////////////////////////////////////////////////
                    
                    cell.cellImage = image;
                }
            }
        }
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    if(self.multiSelection==NO)
    {
        [cell.selectImageView setStatus:PPSelectStatus_None];
    }
    else
    {
        if(self.selectedImageIndexDictionarys!=nil &&
           [self.selectedImageIndexDictionarys objectForKey:[NSString stringWithFormat:@"%td-%zd",indexPath.section,indexPath.row]]!=nil)
        {
            [cell.selectImageView setStatus:PPSelectStatus_Select];
        }
        else
        {
            [cell.selectImageView setStatus:PPSelectStatus_Unselect];
        }
    }


    //////////////////////////////////////////////////

    [cell performSelectorOnMainThread:@selector(refresh) withObject:nil waitUntilDone:NO];
    
    //////////////////////////////////////////////////

    return cell;
}


//================================================================================
//
//================================================================================
- (CGFloat)collectionView:(PPCollectionView *)collectionView heightForRowAtIndex:(NSInteger)index
{
    return [self cellHeight];
}


//================================================================================
//
//================================================================================
- (void)collectionView:(PPCollectionView *)collectionView cellWidth:(CGFloat)width atIndex:(NSInteger)index
{
    self.widthOfCell = width;
}


//================================================================================
//
//================================================================================
- (NSString *)collectionView:(PPCollectionView *)collectionView titleForHeaderInSection:(NSInteger)section
{
    NSString *title = nil;
    
    do
    {
        if(self.enableMultiSectionTitle==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        NSArray *sectionModels = [self.albumContentSectionController sectionModelsForSearching:NO];
        
        if(sectionModels==nil || sectionModels.count<=section)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        PPSectionModel *sectionModel = [sectionModels objectAtIndex:section];
        
        if(sectionModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        title = sectionModel.title;
    }
    while (0);
    
    return title;
}


//================================================================================
//
//================================================================================
- (UIColor *)collectionView:(PPCollectionView *)collectionView sectionHeaderViewBackgroundColorInSection:(NSUInteger)section
{
    return self.tableViewSectionHeaderViewBackgroundColor;
}


//================================================================================
//
//================================================================================
- (UIColor *)collectionView:(PPCollectionView *)collectionView sectionHeaderViewTitleColorInSection:(NSUInteger)section
{
    return self.tableViewSectionTitleColor;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCollectionViewDelegate Method

//================================================================================
//
//================================================================================
- (BOOL)collectionView:(PPCollectionView *)collectionView shouldAddSelectedCell:(AlbumCollectionViewCell *)cell atIndexPath:(NSIndexPath *)indexPath
{
    BOOL result = YES;
    
    do
    {
        BOOL isCancelCell = NO;
        
        for(id key in [self.selectedImageIndexDictionarys allKeys])
        {
            if([key compare:[NSString stringWithFormat:@"%zd-%zd",indexPath.section,indexPath.row]]==NSOrderedSame)
            {
                isCancelCell = YES;
                break;
            }
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if(isCancelCell==YES)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        if(self.selectedImageIndexDictionarys.count<self.selectedMaximumCount)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        result = NO;
    
        //////////////////////////////////////////////////

        NSError *error = [NSError errorWithDomain:PAVC
                                             code:AlbumViewContentViewController_Error_ReachMaxNewCardCount
                                       lineNumber:(__LINE__)
                           localizedFailureReason:PAVC_MLS_ReachMaxNewCardCount
                                           object:nil];
        
        if(error==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        BOOL showAlert = YES;
        
        if([self.delegate respondsToSelector:@selector(albumContentViewControllerShouldShowAlertViewForError:)]==YES)
        {
            showAlert = [self.delegate albumContentViewControllerShouldShowAlertViewForError:error];
        }
        
        if(showAlert==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        NSString *title = @"";
        
        if([self.delegate respondsToSelector:@selector(albumContentViewController:titleForError:)]==YES)
        {
            title = [self.delegate albumContentViewController:self
                                                titleForError:error];
        }
        //////////////////////////////////////////////////

        NSString *errorMessage = [error alertMessage];
        
        if([self.delegate respondsToSelector:@selector(albumContentViewController:messageForError:)]==YES)
        {
            errorMessage = [self.delegate albumContentViewController:self
                                                     messageForError:error];
        }
        
        //////////////////////////////////////////////////
        
        // show alert
        [PPAlertController showWithAlertControllerStyle:UIAlertControllerStyleAlert
                                                  title:title
                                                message:errorMessage
                                 showFromViewController:self
                                               animated:YES
                                            alertAction:[UIAlertAction
                                                         actionWithTitle:PAVC_MLS_OK style:UIAlertActionStyleCancel
                                                         handler:nil], nil];

    } while (0);
    
    return result;
}


//================================================================================
//
//================================================================================
- (void)collectionView:(PPCollectionView *)collectionView didSelectCell:(AlbumCollectionViewCell *)cell atIndexPath:(NSIndexPath *)indexPath
{
    // 單選
    if(self.albumContentView.editMode == NO)
    {
        do
        {
            PPRowModel *rowModel = [self.albumContentSectionController rowModelAtIndexPath:indexPath forSearching:NO];
        
            if(rowModel==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////

            [self.selectedImageIndexDictionarys removeAllObjects];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////

            [self.selectedImageIndexDictionarys setObject:rowModel.object forKey:[NSString stringWithFormat:@"%zd-%zd",indexPath.section,indexPath.row]];
            
            //////////////////////////////////////////////////
            
            [self performSelectorOnMainThread:@selector(mainThreadSendFinishImagePathDictionary)
                                   withObject:nil
                                waitUntilDone:NO];
        }
        while (0);
    }
    // 多選
    else
    {
        do
        {
            BOOL isCancelCell = NO;
            
            for(id key in [self.selectedImageIndexDictionarys allKeys])
            {
                if([key compare:[NSString stringWithFormat:@"%zd-%zd",indexPath.section,indexPath.row]]==NSOrderedSame)
                {
                    [self.selectedImageIndexDictionarys removeObjectForKey:key];
                    isCancelCell = YES;
                    break;
                }
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            if(isCancelCell==YES)
            {
                break;
            }
            
            //////////////////////////////////////////////////

            PPRowModel *rowModel = [self.albumContentSectionController rowModelAtIndexPath:indexPath forSearching:NO];
            
            if(rowModel==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////

            [self.selectedImageIndexDictionarys setObject:rowModel.object forKey:[NSString stringWithFormat:@"%zd-%zd",indexPath.section,indexPath.row]];
            
        } while (0);
        
        //////////////////////////////////////////////////
        
        [self renewImageCount];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (CGFloat)cellHeight
{
    CGFloat cellHeight = PPAlbumContentViewController_IPhoneCellHeight;
    
    if(UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad)
    {
        cellHeight = PPAlbumContentViewController_IPadCellHeight;
    }
    
    return cellHeight;
}


//================================================================================
//
//================================================================================
- (void)renewImageCount
{
    if(self.multiSelection==YES)
    {
        [self.albumContentNavigationBarView updateCaptureCountLabelWithCount:[self.selectedImageIndexDictionarys count]];
    }
    else
    {
        self.albumContentNavigationBarView.titleLabel.text = self.titleString;
    }
}


//================================================================================
//
//================================================================================
- (void)mainThreadSendFinishImagePathDictionary
{
    if([self.delegate respondsToSelector:@selector(albumContentViewController:didFinishAssetImageDictionary:)]==YES &&
       self.avoidAgainSendResult==NO)
    {
        self.avoidAgainSendResult = YES;
        
        //////////////////////////////////////////////////

        [self.delegate albumContentViewController:self didFinishAssetImageDictionary:self.selectedImageIndexDictionarys];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//===============================================================================
//
//===============================================================================
- (void)showBusyView:(BOOL)show withSuperView:(UIView *)superView
{
    if(show==YES)
    {
        if(self.ppBusyView==nil)
        {
            _ppBusyView = [[PPBusyView alloc] initWithSuperView:superView];
        }
        
        if(self.ppBusyView!=nil)
        {
            self.ppBusyView.style = PPBusyViewStyle_Border;
        }
    }
    else
    {
        [self.ppBusyView removeFromSuperview];
        self.ppBusyView = nil;
    }
}


//================================================================================
//
//================================================================================
- (void)assignAppSanboxToContentProviderWithFileDirectory:(NSString *)fileDirectory
{
    do
    {
        if(fileDirectory==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        AlbumContentSectionController *albumContentSectionController = [[AlbumContentSectionController alloc] init];
        
        if(albumContentSectionController==nil)
        {
            break;
        }
        
        self.enableMultiSectionTitle = NO;
        
        [albumContentSectionController fetchImageFileNames:[AlbumImageFileController itemArrayWithAppSandboxDirectory:fileDirectory] inFileDirectory:fileDirectory];
        
        self.albumContentSectionController = albumContentSectionController;
        
        [albumContentSectionController release];
    }
    while (0);
}
    

//================================================================================
//
//================================================================================
- (void)assignSytemAlbumToContentProviderWithAssertCollection:(PHAssetCollection *)assetCollection enableMultiSection:(BOOL)enableMultiSection
{
    do
    {
        if(assetCollection==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        AlbumContentSectionController *albumContentSectionController = [[AlbumContentSectionController alloc] init];
        
        if(albumContentSectionController==nil)
        {
            break;
        }
        
        self.enableMultiSectionTitle = enableMultiSection;
        
        [albumContentSectionController fetchAssetArray:[AlbumImageFileController itemArrayWithAssetCollection:assetCollection] enableMultiSection:enableMultiSection];
        
        self.albumContentSectionController = albumContentSectionController;
        
        [albumContentSectionController release];
    }
    while (0);
}
@end
