//
//  AlbumContentSectionController.m
//
//  Created by Howard on 2015/2/25.
//
//

#import "AlbumContentSectionController.h"

// Controller
#import "PPLogController.h"

// Extension
#import "PPSectionModel+AlbumContent.h"

// Define
#import <Photos/Photos.h>
#import <CoreLocation/CoreLocation.h>
#import "PPAlbumContentViewController+ResourceDefine.h"



////////////////////////////////////////////////////////////////////////////////////////////////////


@implementation AlbumContentSectionController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (NSString *)titleForImageDate:(NSDate *)imageDate
{
    NSString *title = [NSDateFormatter localizedStringFromDate:imageDate
                                                     dateStyle:NSDateFormatterShortStyle
                                                     timeStyle:NSDateFormatterNoStyle];

    do
    {
        //取得今天年月日
        NSDateComponents *nowComponents = [[NSCalendar currentCalendar] components:NSCalendarUnitYear|NSCalendarUnitMonth|NSCalendarUnitDay|NSCalendarUnitWeekdayOrdinal
                                                                          fromDate:[NSDate date]];
        if(nowComponents==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSDateComponents *imageDateComponents = [[NSCalendar currentCalendar] components:NSCalendarUnitYear|NSCalendarUnitMonth|NSCalendarUnitDay|NSCalendarUnitWeekdayOrdinal
                                                                                fromDate:imageDate];
        if(imageDateComponents==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
        
        if(nowComponents.year==imageDateComponents.year &&
           nowComponents.month==imageDateComponents.month &&
           nowComponents.weekdayOrdinal==imageDateComponents.weekdayOrdinal)
        {
            [dateFormatter setDateFormat:@"yyyy.MM.dd"];
            
            title = [dateFormatter stringFromDate:imageDate];
        }
        else if(nowComponents.year==imageDateComponents.year &&
                nowComponents.month==imageDateComponents.month)
        {
            title = PAVC_MLS_ThisMonth;
        }
        else
        {
            [dateFormatter setDateFormat:@"yyyy.MM"];
            
            title = [dateFormatter stringFromDate:imageDate];
        }
 
        
        [dateFormatter release];
    }
    while (0);
    
    return title;
}


//================================================================================
//
//================================================================================
- (void)fecthLocationInfoForAsset:(PHAsset *)asset
{
    CLGeocoder *geocoder = [[CLGeocoder alloc] init];

    [geocoder reverseGeocodeLocation:asset.location
                   completionHandler:^(NSArray *placemarks, NSError *error){
                       
                    CLPlacemark *place = [placemarks lastObject];
                       
                    // 情報表示
                    NSLog(@"%@,%@\n",place.locality,place.country);
     }];
    
    [geocoder release];
}


//================================================================================
// 時間比對 (for 是否新增一個SectionModel)
//================================================================================
- (BOOL)sameLocationDayCompareDate:(NSDate *)date withOtherDate:(NSDate *)otherDate
{
    BOOL result = NO;
    
    do
    {
        if(date==nil || otherDate==nil)
        {
            break;
        }

        //////////////////////////////////////////////////

        /**
         *  weekdayordinal:一個月裡面第幾個週未
         *  unitweekday: 星期日:1，星期一:2，. . .，星期六:7
         */

        NSDateComponents *components = [[NSCalendar currentCalendar] components:NSCalendarUnitDay|kCFCalendarUnitMonth|kCFCalendarUnitYear|NSCalendarUnitWeekdayOrdinal
                                                                       fromDate:date];
   
        if(components==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        NSDateComponents *lastComponent = [[NSCalendar currentCalendar] components:NSCalendarUnitDay|kCFCalendarUnitMonth| kCFCalendarUnitYear|NSCalendarUnitWeekdayOrdinal fromDate:otherDate];
        
        if(lastComponent==nil)
        {
            break;
        }

        //////////////////////////////////////////////////
        
        if([components year]!=[lastComponent year] ||
           [components month]!=[lastComponent month] ||
           [components day]!=[lastComponent day])
        {
            //取得今天年月日
            NSDateComponents *nowComponents = [[NSCalendar currentCalendar] components:NSCalendarUnitYear|NSCalendarUnitMonth|NSCalendarUnitDay|NSCalendarUnitWeekdayOrdinal
                                                                              fromDate:[NSDate date]];
            if(nowComponents==nil)
            {
                break;
            }
        
            //////////////////////////////////////////////////

            //和現在時間同年同月同個星期，用日來計算
            if(components.year==nowComponents.year &&
               components.month==nowComponents.month&&
               components.weekdayOrdinal==nowComponents.weekdayOrdinal)
            {
                break;
            }
            //每月
            else if(components.year!=lastComponent.year||
                    components.month!=lastComponent.month)
            {
                break;
            }
        }
        
        result = YES;
    }
    while (0);

    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (BOOL)fetchImageFileNames:(NSArray *)imageFiles inFileDirectory:(NSString *)filePath
{
    BOOL result = YES;
    
    do
    {
        if(imageFiles==nil || imageFiles.count<=0)
        {
            result = NO;
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPSectionModel *sectionModel = nil;
        
        sectionModel = [[[PPSectionModel alloc] init] autorelease];
        
        if(sectionModel==nil)
        {
            result = NO;
            break;
        }
        
        //////////////////////////////////////////////////
        
        // 加到 SectionController
        [[self sectionModelsForDefault] addObject:sectionModel];
        
        //////////////////////////////////////////////////

        for(id object in imageFiles)
        {
            if([object isKindOfClass:[NSString class]]==NO)
            {
                result = NO;
                break;
            }
            
            //////////////////////////////////////////////////
            
            //建立 rowModel
            PPRowModel *rowModel = [[[PPRowModel alloc] init] autorelease];
            
            if(rowModel==nil)
            {
                result = NO;
                break;
            }
            
            rowModel.object = [filePath stringByAppendingString:[NSString stringWithFormat:@"/%@",object]];
            rowModel.row    = [sectionModel.rowModels count];
            rowModel.text   = filePath;
            
            [sectionModel.rowModels addObject:rowModel];
            
        }
    }
    while (0);
    
    return result;
}


//================================================================================
//
//================================================================================
- (BOOL)fetchAssetArray:(NSArray *)assetArray enableMultiSection:(BOOL)enableMultiSection
{
    BOOL result = NO;
    
    do
    {
        if(assetArray==nil)
        {
            break;
        }

        //////////////////////////////////////////////////
        
        NSSortDescriptor *sort = [NSSortDescriptor sortDescriptorWithKey:@"creationDate" ascending:YES];
        assetArray = [assetArray sortedArrayUsingDescriptors:@[sort]];
        
        //////////////////////////////////////////////////

        PPSectionModel *sectionModel = nil;
        NSDate         *lastDate = nil;
        
        //////////////////////////////////////////////////

        for(id object in assetArray)
        {
            if([object isKindOfClass:[PHAsset class]]==NO)
            {
                result = NO;
                break;
            }
            
            //////////////////////////////////////////////////
            
            PHAsset *asset = object;
            
            //用時間來排序
            NSDate *date = [asset creationDate];

            //建立 sectionModel
            if(lastDate==nil ||
                (enableMultiSection==YES &&
                [self sameLocationDayCompareDate:date withOtherDate:lastDate]==NO))
            {
                sectionModel = [[PPSectionModel alloc] init];
                
                if(sectionModel==nil)
                {
                    break;
                }
                
                sectionModel.title = [self titleForImageDate:date];
                
                //////////////////////////////////////////////////
                
                // 加到 SectionController
                [[self sectionModelsForDefault] insertObject:sectionModel atIndex:0];
                
                [sectionModel release];
                
                //////////////////////////////////////////////////

                lastDate = date;
            }
            
            //////////////////////////////////////////////////
            
            //建立 rowModel
            PPRowModel *rowModel = [[PPRowModel alloc] init];
            
            if(rowModel==nil)
            {
                break;
            }
            
            rowModel.object = asset;
            rowModel.row    = [sectionModel.rowModels count];
            
            [[[[self sectionModelsForDefault] firstObject] rowModels] addObject:rowModel];
            
            [rowModel release];
            
            //////////////////////////////////////////////////
            
            result = YES;
            
            //////////////////////////////////////////////////

            PPLog(@"%@,%@",NSStringFromClass([date class]),date);
            
        }
    }
    while (0);
    
    return result;
}

@end
