//
//  PP3rdPartyLoginModel.m
//  
//
//  Created by Howard on 2019/6/11.
//

#import "PP3rdPartyLoginModel.h"

@implementation PP3rdPartyLoginModel

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copyig, and Dellocating Object

//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.userGuid = nil;
    self.userName = nil;
    self.email = nil;
    self.accessToken = nil;
    self.refreshToken = nil;
    self.sourceObject = nil;
    self.idToken = nil;
    
    //////////////////////////////////////////////////

    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{userGuid:%@\n,userName:%@\n,email:%@\n,accessToken:%@\n,refreshToken:%@\n,sourceObject:%@\n,idToken:%@\n}",[super description],self.userGuid,self.userName,self.email,self.accessToken,self.refreshToken,self.sourceObject,self.idToken];
}



////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Constructor Method

//================================================================================
//
//================================================================================
+ (PP3rdPartyLoginModel *)loginModelWithUserGuid:(NSString *)userGuid
                                        userName:(NSString *)userName
                                           email:(NSString *)email
                                     accessToken:(NSString *)accessToken
                                    refreshToken:(NSString *)refreshToken
                                         idToken:(NSString *)idToken
                                    sourceObject:(id)sourceObject
{
    PP3rdPartyLoginModel *loginModel = [[[PP3rdPartyLoginModel alloc] init] autorelease];
    
    loginModel.userGuid = ([userGuid length]>0)?[NSString stringWithString:userGuid]:nil;
    
    loginModel.userName = ([userName length]>0)?[NSString stringWithString:userName]:nil;
    
    loginModel.email = ([email length]>0)?[NSString stringWithString:email]:nil;
    
    loginModel.accessToken = ([accessToken length]>0)?[NSString stringWithString:accessToken]:nil;
    
    loginModel.refreshToken = ([refreshToken length]>0)?[NSString stringWithString:refreshToken]:nil;
    
    loginModel.idToken = ([idToken length]>0)?[NSString stringWithString:idToken]:nil;
    
    loginModel.sourceObject = sourceObject;
    
    return loginModel;
}
@end
