//
//  PP3rdPartyLoginFlowController.m
//  
//
//  Created by Howard on 2019/6/4.
//

#import "PP3rdPartyLoginFlowController.h"

#import <WebKit/WebKit.h>

// Category
#import "NSError+Custom.h"

// Controller
#import "PPAppleLoginController.h"
#import "PPGoogleAuthenticationController.h"
#import "PPWeChatController.h"

#if  TARGET_OS_IOS

// FB
#import <FBSDKLoginKit/FBSDKLoginManager.h>

// WeChat
#import "WXApi.h"

// ViewController
#import "PPMicrosoftLoginViewController.h"

// Category
#import "FBSDKLoginManagerLoginResult+PP3rdPartLoginModel.h"

#elif TARGET_OS_MAC

#import "PPFBLoginWindowController.h"
#import "PPWeChatLoginWindowController.h"
#import "PPMicrosoftWindowController.h"

#endif


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Interface

@interface PP3rdPartyLoginFlowController()
#if  TARGET_OS_IOS
<
WXApiDelegate
>

@property (nonatomic,retain) PPMicrosoftLoginViewController *msLoginViewController;
#endif
@property (nonatomic,retain) PPAppleLoginController *appleLoginController;
@property (nonatomic,retain) PPWeChatController *weChatController;
@property (nonatomic,copy) SignInCompleteHandler signInCompleteHandler;

@end

@implementation PP3rdPartyLoginFlowController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)init
{
    if(self = [super init])
    {
        //#if TARGET_OS_MAC
        //                    [[NSAppleEventManager sharedAppleEventManager] setEventHandler:self
        //                                                                       andSelector:@selector(handleAppleEvent:withReplyEvent:)
        //                                                                     forEventClass:kInternetEventClass
        //                                                                        andEventID:kAEGetURL];
        //#endif
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.signInCompleteHandler = nil;
    
#if  TARGET_OS_IOS
    self.msLoginViewController = nil;
    self.appleLoginController = nil;
#endif
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Model Releated Method

//================================================================================
//
//================================================================================
- (PP3rdPartyLoginModel *)loginModelFromAuth:(id<GTMFetcherAuthorizationProtocol>)auth
{
    GTMAppAuthFetcherAuthorization *authorization = nil;
    
    if([auth isKindOfClass:[GTMAppAuthFetcherAuthorization class]]==YES)
    {
        authorization = (GTMAppAuthFetcherAuthorization *)auth;
    }
    
    return [PP3rdPartyLoginModel loginModelWithUserGuid:authorization.userID
                                               userName:nil
                                                  email:authorization.userEmail
                                            accessToken:authorization.authState.lastTokenResponse.accessToken
                                           refreshToken:authorization.authState.lastTokenResponse.refreshToken
                                                idToken:authorization.authState.lastTokenResponse.idToken
                                           sourceObject:auth];
}





//================================================================================
//
//================================================================================
- (PP3rdPartyLoginModel *)loginModelFromDictionary:(NSDictionary *)dictionary
{
    NSString *accessToken = ([[dictionary objectForKey:@"accessToken"] length]<=0)?[dictionary objectForKey:@"access_token"]:[dictionary objectForKey:@"accessToken"];
    
    NSString *refreshToken = ([[dictionary objectForKey:@"refreshToken"] length]<=0)?[dictionary objectForKey:@"refresh_token"]:[dictionary objectForKey:@"refreshToken"];
    
    return [PP3rdPartyLoginModel loginModelWithUserGuid:[dictionary objectForKey:@"id"]
                                               userName:[dictionary objectForKey:@"name"]
                                                  email:[dictionary objectForKey:@"email"]
                                            accessToken:accessToken
                                           refreshToken:refreshToken
                                                idToken:nil
                                           sourceObject:dictionary];
}





#if  TARGET_OS_IOS

#pragma mark - WXApiDelegate Method

//================================================================================
//
//================================================================================
- (void)onResp:(BaseResp *)resp
{

    if(self.signInCompleteHandler!=nil)
    {
        if(resp.errCode==0)
        {
            // 登入成功，透過 code 取得 accessToken & openid

            if([resp isKindOfClass:[SendAuthResp class]]==YES)
            {
                SendAuthResp *sendAuthResp = (SendAuthResp *)resp;
                
                [self.weChatController loadModelFromWeixiWithCode:sendAuthResp.code completion:^(PP3rdPartyLoginModel *model) {
                     self.signInCompleteHandler(model,nil);
                }];
            }
            else
            {
                NSError *returnError = PPErrorMake(resp.errCode,@"微信登入失敗 ，資料轉換失敗",nil);
                
                self.signInCompleteHandler(nil,returnError);
            }
        }
        else
        {
            NSString *failureReason = [NSString stringWithFormat:@"微信登入失敗 (%d)",resp.errCode];
            
            NSError *returnError = PPErrorMake(resp.errCode,failureReason,nil);
            
            self.signInCompleteHandler(nil,returnError);
        }
    }
}


//================================================================================
//
//================================================================================
- (void)onReq:(BaseReq*)req
{
    
}
#endif




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

//================================================================================
//
//================================================================================
+ (PP3rdPartyLoginFlowController *)sharePartyLoginFlowController
{
    static PP3rdPartyLoginFlowController *sharedPartyLoginFlowController = nil;
    
    static dispatch_once_t onceToken;
    
    dispatch_once(&onceToken, ^{
        sharedPartyLoginFlowController = [[PP3rdPartyLoginFlowController alloc] init];
    });
    
    return sharedPartyLoginFlowController;
}





//================================================================================
//
//================================================================================
+ (void)isLoginWithType:(P3PLFC_LoginType)loginWithType
      completionHandler:(P3PLFCBOOLCompleteHandler)completionHandler
{
     NSAssert(loginWithType==P3PLFC_LoginType_Apple,@"Only support Apple Login");
    
    if (@available(macOS 10.15, *))
    {
        [PPAppleLoginController isLoginCompletionHandler:completionHandler];
    }
    else if (@available(iOS 13.0, *)) {
        [PPAppleLoginController isLoginCompletionHandler:completionHandler];
    }
    else
    {
        completionHandler(NO);
    }
}


//================================================================================
//
//================================================================================
+ (void)logoutWithType:(P3PLFC_LoginType)loginWithType
{
    switch (loginWithType)
    {
        case P3PLFC_LoginType_FB:
        {
#if  TARGET_OS_IOS
            FBSDKLoginManager *facebookLogin = [[FBSDKLoginManager alloc] init];
            
            [facebookLogin logOut];
            
            [facebookLogin release];
#endif
            break;
        }
        case P3PLFC_LoginType_Google:
        {
            [PPGoogleAuthenticationController removeGoogleAuthentication];
            
            break;
        }
        case P3PLFC_LoginType_Apple:
        {
            [PPAppleLoginController logout];
            break;
        }
        default:
        {
            
            break;
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Login Method

//================================================================================
//
//================================================================================
- (void)loginWithType:(P3PLFC_LoginType)loginWithType
                appID:(NSString *)appID
             secretID:(NSString *)secretID
          redirectURL:(NSString *)redirectURL
  superViewController:(CPViewController *)viewController
    completionHandler:(SignInCompleteHandler)completionHandler
{
    if(loginWithType!=P3PLFC_LoginType_Apple)
     {
         NSAssert([appID length]>0, @"appID is nil");
     }
    
    switch (loginWithType)
    {
        case P3PLFC_LoginType_Google:
        {
            NSString *keyChainName = [NSBundle mainBundle].bundleIdentifier;
            
            [PPGoogleAuthenticationController initializeWithKeychainName:keyChainName
                                                                clientID:appID clientSecret:secretID];
            
            //////////////////////////////////////////////////
            
#if  TARGET_OS_IOS
            [PPGoogleAuthenticationController showSignInWithScopes:nil viewController:viewController completeHandler:^(id<GTMFetcherAuthorizationProtocol> auth, NSError *error) {
                
                if(completionHandler!=nil)
                {
                    completionHandler([self loginModelFromAuth:auth],error);
                }
            }];
#elif TARGET_OS_MAC
            [PPGoogleAuthenticationController showSignInWithScopes:nil completeHandler:^(id<GTMFetcherAuthorizationProtocol> auth, NSError *error) {
                if(completionHandler!=nil)
                {
                    completionHandler([self loginModelFromAuth:auth],error);
                }
            }];
#endif
            break;
        }
        case P3PLFC_LoginType_FB:
        {
#if  TARGET_OS_IOS
            
            FBSDKLoginManager *facebookLogin = [[[FBSDKLoginManager alloc] init] autorelease];
            
            [facebookLogin logInWithPermissions:@[@"public_profile", @"email"] fromViewController:viewController handler:^(FBSDKLoginManagerLoginResult *result, NSError *error) {
                
                if(completionHandler!=nil)
                {
                    completionHandler([result thirdPartyLoginModel],error);
                }
            }];
    
#elif TARGET_OS_MAC
            
            //            [[NSWorkspace sharedWorkspace] openURL:[NSURL URLWithString:@"https://www.facebook.com/v3.3/dialog/oauth?client_id=174240959415873&redirect_uri=https://www.facebook.com/connect/login_success.html&scope=public_profile,email"]];
            
            PPFBLoginWindowController *windowController = [[[PPFBLoginWindowController alloc] initWithWindowNibName:NSStringFromClass([PP3rdPartyLoginWindowController class])] autorelease];
            
            [windowController.window makeKeyAndOrderFront:viewController];
            
            
            //////////////////////////////////////////////////
            
            [windowController showAuthFlowFromClientID:appID secretID:secretID
                                            completion:^(id object, NSError *returnError) {
                
                [windowController.window orderOut:viewController];
                [windowController.window close];
                
                if(completionHandler!=nil)
                { completionHandler([self loginModelFromDictionary:object],returnError);
                }
            }];
#endif
            break;
        }
        case P3PLFC_LoginType_WeChat:
        {
            #if  TARGET_OS_IOS
            
            //MARK: IOS 微信登入
            
            if([WXApi isWXAppInstalled]==NO &&
               completionHandler!=nil)
            {
                self.signInCompleteHandler = nil;
                
                completionHandler(nil,PPErrorMake(0, @"请安装微信App", nil));
                
                break;
            }
            
            
            self.signInCompleteHandler = completionHandler;
            self.weChatController = [[[PPWeChatController alloc] init] autorelease];
            
            self.weChatController.clientID = appID;
            self.weChatController.secretID = secretID;
            
            //////////////////////////////////////////////////

            SendAuthReq *req = [[[SendAuthReq alloc] init] autorelease];
     
            req.scope = @"snsapi_userinfo";
            
            [WXApi sendAuthReq:req
                viewController:viewController
                      delegate:self
                    completion:^(BOOL success) {
                if(completionHandler!=nil)
                {
                    if(success==NO)
                    {
                        completionHandler(nil,PPErrorMake(0, @"無法開啟微信", nil));
                    }
                }
            }];
            
            
            #elif TARGET_OS_MAC
            //            PPWeChatLoginWindowController *windowController = [[[PPWeChatLoginWindowController alloc] initWithWindowNibName:NSStringFromClass([PP3rdPartyLoginWindowController class])] autorelease];
            //
            //            [windowController.window makeKeyAndOrderFront:viewController];
            //
            //            [windowController showAuthFlowFromClientID:@"174240959415873" secretID:@"2ec34728eedf201dc0ac6628ec0d13df"
            //                                            completion:^(id object, NSError *returnError) {
            //
            //                                                [windowController.window orderOut:viewController];
            //                                                [windowController.window close];
            //
            //                                                if(completionHandler!=nil)
            //                                                { completionHandler(object,returnError);
            //                                                }
            //                                            }];
            #endif
            break;
        }
        case P3PLFC_LoginType_Microsoft:
        {
#if  TARGET_OS_IOS
            self.msLoginViewController = [[[PPMicrosoftLoginViewController alloc] init] autorelease];
            
            self.msLoginViewController.isLaunchPage = self.isLaunchPage;
            
            [self.msLoginViewController showAuthWithClientID:appID
                                                    secretID:secretID
                                                 redirectURL:redirectURL
                                         superViewController:viewController
                                                  completion:^(id object, NSError *returnError)
             {
                
                if(completionHandler!=nil)
                {
                    completionHandler([self loginModelFromDictionary:object],returnError);
                }
            }];
            
#elif TARGET_OS_MAC
            PPMicrosoftWindowController *windowController = [[[PPMicrosoftWindowController alloc] initWithWindowNibName:NSStringFromClass([PP3rdPartyLoginWindowController class])] autorelease];
            
            [windowController.window center];
            [windowController.window makeKeyAndOrderFront:viewController];
            
            [windowController runModelSessionForShowingAuthFlowFromClientID:appID redirectURL:redirectURL completion:^(id object, NSError *returnError) {
                
                [windowController.window orderOut:viewController];
                [windowController.window close];
                
                if(completionHandler!=nil)
                { completionHandler((returnError==nil)?[self loginModelFromDictionary:object]:nil,returnError);
                }
            }];
            
#endif
            break;
        }
        case P3PLFC_LoginType_Apple:
        {
#if  TARGET_OS_IOS
            [self loginByAppleIDFromSuperViewController:viewController completionHandler:completionHandler];
#endif
            break;
        }
        default:
        {
            break;
        }
    }
}


//================================================================================
//
//================================================================================
- (void)loginWithType:(P3PLFC_LoginType)loginWithType
                appID:(NSString *)appID
             secretID:(NSString *)secretID
          redirectURL:(NSString *)redirectURL
  superViewController:(CPViewController *)viewController
    permissionHandler:(CheckPermissionCompleteHandler)permissionHandler
    completionHandler:(SignInCompleteHandler)completionHandler
{
    if(loginWithType!=P3PLFC_LoginType_Apple)
    {
        NSAssert([appID length]>0, @"appID is nil");
    }
    else
    {
        NSAssert(loginWithType!=P3PLFC_LoginType_Apple,@"No support AppleID Login");
    }
    
    switch (loginWithType)
    {
        case P3PLFC_LoginType_Google:
        {
            NSString *keyChainName = [NSBundle mainBundle].bundleIdentifier;
            
            [PPGoogleAuthenticationController initializeWithKeychainName:keyChainName
                                                                clientID:appID clientSecret:secretID];
            
            //////////////////////////////////////////////////
            
#if  TARGET_OS_IOS
            [PPGoogleAuthenticationController showSignInWithScopes:nil viewController:viewController completeHandler:^(id<GTMFetcherAuthorizationProtocol> auth, NSError *error) {
                
                if(completionHandler!=nil)
                {
                    completionHandler([self loginModelFromAuth:auth],error);
                }
            }];
#elif TARGET_OS_MAC
            [PPGoogleAuthenticationController showSignInWithScopes:nil completeHandler:^(id<GTMFetcherAuthorizationProtocol> auth, NSError *error) {
                if(completionHandler!=nil)
                {
                    completionHandler([self loginModelFromAuth:auth],error);
                }
            }];
#endif
            break;
        }
        case P3PLFC_LoginType_FB:
        {
#if  TARGET_OS_IOS
            
            FBSDKLoginManager *facebookLogin = [[[FBSDKLoginManager alloc] init] autorelease];
            
            [facebookLogin logInWithPermissions:@[@"public_profile", @"email"]
                             fromViewController:viewController
                                        handler:^(FBSDKLoginManagerLoginResult *result, NSError *error) {
                
                if(completionHandler!=nil)
                {
                    completionHandler([result thirdPartyLoginModel],error);
                }
            }];
#elif TARGET_OS_MAC
            
            //            [[NSWorkspace sharedWorkspace] openURL:[NSURL URLWithString:@"https://www.facebook.com/v3.3/dialog/oauth?client_id=174240959415873&redirect_uri=https://www.facebook.com/connect/login_success.html&scope=public_profile,email"]];
            
            PPFBLoginWindowController *windowController = [[[PPFBLoginWindowController alloc] initWithWindowNibName:NSStringFromClass([PP3rdPartyLoginWindowController class])] autorelease];
            
            [windowController.window makeKeyAndOrderFront:viewController];
            
            
            //////////////////////////////////////////////////
            
            [windowController showAuthFlowFromClientID:appID secretID:secretID
                                            completion:^(id object, NSError *returnError) {
                
                [windowController.window orderOut:viewController];
                [windowController.window close];
                
                if(completionHandler!=nil)
                { completionHandler([self loginModelFromDictionary:object],returnError);
                }
            }];
#endif
            break;
        }
        case P3PLFC_LoginType_WeChat:
        {
            
            break;
        }
        case P3PLFC_LoginType_Microsoft:
        {
#if  TARGET_OS_IOS
            self.msLoginViewController = [[[PPMicrosoftLoginViewController alloc] init] autorelease];
            
            self.msLoginViewController.isLaunchPage = self.isLaunchPage;
            
            __block typeof(self) blockself = self;
            
            [self.msLoginViewController showAuthWithClientID:appID
                                                    secretID:secretID
                                                 redirectURL:redirectURL
                                         superViewController:viewController
                                                  completion:^(id object, NSError *returnError)
             {
                do
                {
                    // 登入成功
                    if(returnError==nil)
                    {
                        // 檢查權限
                        if(permissionHandler!=nil)
                        {
                            NSError *permissionError = permissionHandler([self loginModelFromDictionary:object]);
                            
                            // 權限失敗，直接顯示錯誤
                            if(permissionError!=nil)
                            {
                                [blockself.msLoginViewController showRetryAlertWithError:permissionError];
                                
                                break;
                            }
                        }
                    }
                    
                    //////////////////////////////////////////////////
                    
                    if(completionHandler!=nil)
                    {
                        completionHandler([self loginModelFromDictionary:object],returnError);
                    }
                    
                    [blockself.msLoginViewController goBackAnimated:YES];
                }
                while (0);
            }];
            
#elif TARGET_OS_MAC
            PPMicrosoftWindowController *windowController = [[[PPMicrosoftWindowController alloc] initWithWindowNibName:NSStringFromClass([PP3rdPartyLoginWindowController class])] autorelease];
            
            [windowController.window center];
            [windowController.window makeKeyAndOrderFront:viewController];
            
            [windowController runModelSessionForShowingAuthFlowFromClientID:appID redirectURL:redirectURL completion:^(id object, NSError *returnError) {
                
                [windowController.window orderOut:viewController];
                [windowController.window close];
                
                if(completionHandler!=nil)
                { completionHandler((returnError==nil)?[self loginModelFromDictionary:object]:nil,returnError);
                }
            }];
            
#endif
            break;
        }
        default:
        {
            break;
        }
    }
}


//================================================================================
//
//================================================================================
- (void)loginByAppleIDFromSuperViewController:(CPViewController *)superViewController
                            completionHandler:(SignInCompleteHandler)completionHandler
{
    self.appleLoginController = [[[PPAppleLoginController alloc] init] autorelease];
    
    if (@available(macOS 10.15, *)) {
        
        [self.appleLoginController loginFromSuperViewController:superViewController
                                              completionHandler:completionHandler];
    }
    else if (@available(iOS 13.0, *)) {
        [self.appleLoginController loginFromSuperViewController:superViewController
                                              completionHandler:completionHandler];
    }
    else {
        completionHandler(nil,PPErrorOperationFailed(@"need to ios 13 or macOS 10.15"));
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Weixi Method
#if  TARGET_OS_IOS
//================================================================================
//
//================================================================================
- (BOOL)weixiHandleOpenUniversalLink:(NSUserActivity *)userActivity
{
    return [WXApi handleOpenUniversalLink:userActivity delegate:self];
}


//================================================================================
//
//================================================================================
- (BOOL)weixihandleOpenURL:(NSURL *)url
{
    return [WXApi handleOpenURL:url delegate:self];
}
#endif
@end
