//
//  PPMicrosoftLoginView.m
//  Pods
//
//  Created by Howard on 2019/6/24.
//

#import "PPMicrosoftLoginView.h"

// Category
#import "NSError+Custom.h"

/**
 https://login.microsoftonline.com/common/oauth2/v2.0/authorize?x-client-Ver=0.4.3&state=RTQ0Qzk5NzQtNUMxNC00MkMxLUIwRTUtNTkyNkI5RDExQzFE&client_info=1&prompt=select_account&response_type=code&x-app-name=Example&code_challenge_method=S256&x-app-ver=1.0&scope=Contacts.ReadWrite%20User.ReadWrite%20Files.ReadWrite.All%20openid%20profile%20offline_access&x-client-SKU=MSAL.OSX&x-client-OS=10.14.4&code_challenge=Mg1TzoQZwj0nsi35XPeF7Xr-Yj0OIBQ5xNIDR2htI4c&x-client-CPU=32&redirect_uri=msauth.com.penpower.worldcardteammac%3A%2F%2Fauth&client-request-id=8D5C3C75-C661-4B5D-A2D1-A6B88113B189&client_id=df5fa9a6-88ba-464b-8a9e-c9ef2291c65f&haschrome=1&return-client-request-id=true

 */

static NSString *  const PPMicrosoftLoginViewAPI_OAuth = @"https://login.microsoftonline.com/common/oauth2/v2.0/authorize?prompt=select_account&response_type=code";
static NSString *  const PPMicrosoftLoginViewAPI_AccessToken = @"https://login.microsoftonline.com/common/oauth2/v2.0/token";


@interface PPMicrosoftLoginView ()

@property (nonatomic,retain) NSString *redirectURL;

@end


@implementation PPMicrosoftLoginView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.redirectURL = nil;
    //////////////////////////////////////////////////

    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Private url methods


//==============================================================================
//
//==============================================================================
- (NSURLRequest *)oauthRequestWithClientID:(NSString *)clientID redirectURL:(NSString *)redirectURL
{
    // https://login.microsoftonline.com/common/oauth2/v2.0/authorize?prompt=select_account&response_type=code&scope=Contacts.ReadWrite%20User.ReadWrite%20Files.ReadWrite.All%20openid%20profile%20offline_access&client_id=df5fa9a6-88ba-464b-8a9e-c9ef2291c65f&redirect_uri=msauth.com.penpower.worldcardmac://auth
    NSString *url = [NSString stringWithFormat:@"%@&scope=%@&client_id=%@&redirect_uri=%@",PPMicrosoftLoginViewAPI_OAuth,[self scopes],clientID,redirectURL];

    NSMutableURLRequest *request = [NSMutableURLRequest requestWithURL:[NSURL URLWithString:url]];
    NSString *userAgentContent = @"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36";// [NSString stringWithFormat:@"Mozilla/5.0 (%@; %@ %@)", hardware, platform, os];

    [request setValue:userAgentContent forHTTPHeaderField:@"User-Agent"];
    
    return request;
}







////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Scopes Method

//================================================================================
//
//================================================================================
- (NSString *)scopes
{
    return @"Contacts.ReadWrite%20User.ReadWrite%20Files.ReadWrite.All%20openid%20profile%20offline_access";
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private token Method


//==============================================================================
//
//==============================================================================
- (NSDictionary *)fetchAccountInfoWithAccessToken:(NSString *)accessToken error:(NSError **)error
{
    NSError *returnError = nil;
    
    id object = nil;
    
    do
    {
        if([accessToken length]<=0)
        {
            returnError = PPErrorParameterInvalidity(nil);
            
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSString *requestUserInfoString = @"https://graph.microsoft.com/v1.0/me";
        
        NSURLResponse *response = nil;
        
        NSMutableURLRequest *urlRequest = [NSMutableURLRequest requestWithURL:[NSURL URLWithString:requestUserInfoString]];
        
        if(urlRequest==nil)
        {
            returnError = PPErrorParameterInvalidity(nil);
            break;
        }
        
        [urlRequest setHTTPMethod:@"GET"];
        [urlRequest setAllHTTPHeaderFields:@{@"Authorization":[NSString stringWithFormat:@"Bearer %@", accessToken]}];
        
//        //////////////////////////////////////////////////
//
//        NSString *bodyString = [NSString stringWithFormat:@"client_id=%@&redirect_uri=%@&code=%@&grant_type=authorization_code&scope=%@%@",self.clientID,self.redirectURL,code,[self scopes], (self.secretID?[NSString stringWithFormat:@"&client_secret=%@", self.secretID]:@"")];
//
//        NSData *bodyData = [bodyString dataUsingEncoding:NSUTF8StringEncoding];
//
//        if(bodyData==nil)
//        {
//            break;
//        }
//
//        [urlRequest setHTTPBody:bodyData];
//
        //////////////////////////////////////////////////
        
        NSData *downloadedData = [NSURLConnection sendSynchronousRequest:urlRequest returningResponse:&response error:&returnError];
        
        if(returnError!=nil)
        {
            NSString *errorString = [NSString stringWithCString:downloadedData.bytes encoding:NSUTF8StringEncoding];
            NSLog(@"errorString:%@", errorString);
            break;
        }
        
        object = [NSJSONSerialization JSONObjectWithData:downloadedData options:NSJSONReadingMutableLeaves error:&returnError];
        
        if(returnError!=nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
    }
    while (0);
    
    if(error)
    {
        *error = returnError;
    }
    return object;
}

//================================================================================
//
//================================================================================
- (id)fetchTokenWithCode:(NSString *)code error:(NSError **)error
{
    // Line breaks for legibility only
    
    //        POST /common/oauth2/v2.0/token HTTP/1.1
    //    Host: https://login.microsoftonline.com
    //        Content-Type: application/x-www-form-urlencoded
    //
    //        client_id=6731de76-14a6-49ae-97bc-6eba6914391e
    //        &scope=user.read%20mail.read
    //        &code=OAAABAAAAiL9Kn2Z27UubvWFPbm0gLWQJVzCTE9UkP3pSx1aXxUjq3n8b2JRLk4OxVXr...
    //        &redirect_uri=http%3A%2F%2Flocalhost%2Fmyapp%2F
    //        &grant_type=authorization_code
    //        &client_secret=JqQX2PNo9bpM0uEihUPzyrh    // NOTE: Only required for web apps
    
    NSError *returnError = nil;
    
    id object = nil;
    
    do
    {
        if([code length]<=0)
        {
            returnError = PPErrorParameterInvalidity(nil);
            
            break;
        }
        
        //////////////////////////////////////////////////

        NSString *requestTokenString = PPMicrosoftLoginViewAPI_AccessToken;
        
        if(requestTokenString==nil)
        {
            break;
        }

        //////////////////////////////////////////////////
  
        NSURLResponse *response = nil;
        
        NSMutableURLRequest *urlRequest = [NSMutableURLRequest requestWithURL:[NSURL URLWithString:requestTokenString]];
        
        if(urlRequest==nil)
        {
            returnError = PPErrorParameterInvalidity(nil);
            break;
        }
        
        [urlRequest setHTTPMethod:@"POST"];
        
        [urlRequest setAllHTTPHeaderFields:@{@"Content-Type":@"application/x-www-form-urlencoded"}];
        
//        client_info=1&scope=Contacts.ReadWrite+User.ReadWrite+Files.ReadWrite.All+openid+profile+offline_access&code=M73d36b8e-fd2f-c36c-4977-daed9746e709&grant_type=authorization_code&code_verifier=FRug3FB7FQP43EAIWvFQlgfHzSQeMcbjwo2_IdBjFyg&redirect_uri=msauth.com.penpower.worldcardmac%3A%2F%2Fauth&client_id=df5fa9a6-88ba-464b-8a9e-c9ef2291c65f

        //////////////////////////////////////////////////
        
        NSString *bodyString = [NSString stringWithFormat:@"client_id=%@&redirect_uri=%@&code=%@&grant_type=authorization_code&scope=%@%@",self.clientID,self.redirectURL,code,[self scopes], (self.secretID?[NSString stringWithFormat:@"&client_secret=%@", self.secretID]:@"")];
         
        NSData *bodyData = [bodyString dataUsingEncoding:NSUTF8StringEncoding];
        
        if(bodyData==nil)
        {
            break;
        }
        
        [urlRequest setHTTPBody:bodyData];
        
        //////////////////////////////////////////////////
        
        NSData *downloadedData = [NSURLConnection sendSynchronousRequest:urlRequest returningResponse:&response error:&returnError];
        
        if(returnError!=nil)
        {
            NSString *errorString = [NSString stringWithCString:downloadedData.bytes encoding:NSUTF8StringEncoding];
            NSLog(@"errorString:%@", errorString);
            break;
        }
        
        object = [NSJSONSerialization JSONObjectWithData:downloadedData options:NSJSONReadingMutableLeaves error:&returnError];
        
        if(returnError!=nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
    }
    while (0);
    
    if(error)
    {
        *error = returnError;
    }
    
    return object;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Override Method


//================================================================================
//
//================================================================================
- (BOOL)isRedirectURL:(NSString *)requestUrlString
{
    return [[requestUrlString lowercaseString] hasPrefix:[self.redirectURL lowercaseString]];
}


//================================================================================
// 連結範例:
//   密碼頁按<-，帳號鎖定頁按back，授權使用頁按否
//     msauth.com.penpower.worldcardmac://auth?error=access_denied&error_description=The%20user%20has%20denied%20access%20to%20the%20scope%20requested%20by%20the%20client%20application.
//
//   帳號頁按Back
//     msauth.com.penpower.worldcardmac://auth/?error=access_denied&error_subcode=cancel
//================================================================================
- (void)handleUserAgentResponse:(NSURL *)url
{
    id object = nil;
    NSError *returnError = nil;
    
    do
    {
        NSRange errorRange = [[url absoluteString] rangeOfString:@"error="];
        
        if(errorRange.location!=NSNotFound)
        {
            returnError = PPErrorOperationCancel([[url absoluteString] substringFromIndex:errorRange.location]);
            
            break;
        }
        
        //////////////////////////////////////////////////

        // 取得 accessToken
        NSRange range = [[url absoluteString] rangeOfString:@"code="];
        
        if(range.location==NSNotFound)
        {
            returnError = PPErrorParameterInvalidity(@"accessToken request parameter not found");
            
            break;
        }
        
        NSString *code = [[url absoluteString] substringFromIndex:range.location+range.length];
     
        //////////////////////////////////////////////////
        
        object = [self fetchTokenWithCode:code error:&returnError];
        
        // MARK: 取得帳號資訊
        if(object!=nil && object[@"access_token"]!=nil)
        {
            NSDictionary * accountInfo = [self fetchAccountInfoWithAccessToken:object[@"access_token"] error:&returnError];
            
            NSMutableDictionary *loginInfo = [NSMutableDictionary dictionaryWithDictionary:object];
            [loginInfo setObject:accountInfo[@"id"] forKey:@"id"];
            [loginInfo setObject:accountInfo[@"displayName"] forKey:@"name"];
            [loginInfo setObject:accountInfo[@"userPrincipalName"] forKey:@"email"];
            
            object = loginInfo;
        }
    }
    while (0);
    
    if(self.authCompletion!=nil)
    {
        self.authCompletion(object,returnError);
    }
}

//==============================================================================
//
//==============================================================================
- (void)reloadOriginalUrl
{
    NSURLRequest *request = [self oauthRequestWithClientID:self.clientID redirectURL:self.redirectURL];
    [self loadRequest:request];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - override delegate


//==============================================================================
//
//==============================================================================
- (void)webView:(WKWebView *)webView didFailProvisionalNavigation:(WKNavigation *)navigation withError:(NSError *)error
{
#ifdef DEBUG
    NSLog(@"%s = %@", __PRETTY_FUNCTION__, error);
#endif
    // !! Howard, Microsoft 會在視窗強制關閉時
    // !! ios在密碼頁按下返回會收到這個錯誤
    // 這時不需要發出completion
    if ([error.domain isEqualToString:@"WebKitErrorDomain"] && error.code == 102)
    {
        return;
    }
    
    [super webView:webView didFailProvisionalNavigation:navigation withError:error];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method


//==============================================================================
//
//==============================================================================
- (void)showAuthFlowFromClientID:(NSString *)clientID
                        secretID:(NSString *)secretID
                     redirectURL:(NSString *)redirectURL
                      completion:(AuthCompletion)completion
{
    NSAssert([redirectURL length]>0, @"redirectURL length is zero");
    
    self.redirectURL = redirectURL;
    
    //////////////////////////////////////////////////
    
    NSURLRequest *request = [self oauthRequestWithClientID:clientID redirectURL:redirectURL];
    
    //    NSLog(@"%s in, url:%@",__func__,request.URL.absoluteString);
    
    //////////////////////////////////////////////////
    
    [super showAuthFlowFromRequest:request
                          clientID:clientID
                          secretID:secretID
                        completion:completion];
    
    //////////////////////////////////////////////////
    
    //    NSLog(@"%s, out",__func__);
}

@end
