///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBUSERSFileLockingValue;
@class DBUSERSPaperAsFilesValue;
@class DBUSERSUserFeatureValue;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `UserFeatureValue` union.
///
/// Values that correspond to entries in UserFeature.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBUSERSUserFeatureValue : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBUSERSUserFeatureValueTag` enum type represents the possible tag
/// states with which the `DBUSERSUserFeatureValue` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBUSERSUserFeatureValueTag){
    /// (no description).
    DBUSERSUserFeatureValuePaperAsFiles,

    /// (no description).
    DBUSERSUserFeatureValueFileLocking,

    /// (no description).
    DBUSERSUserFeatureValueOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBUSERSUserFeatureValueTag tag;

/// (no description). @note Ensure the `isPaperAsFiles` method returns true
/// before accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBUSERSPaperAsFilesValue *paperAsFiles;

/// (no description). @note Ensure the `isFileLocking` method returns true
/// before accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBUSERSFileLockingValue *fileLocking;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "paper_as_files".
///
/// @param paperAsFiles (no description).
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperAsFiles:(DBUSERSPaperAsFilesValue *)paperAsFiles;

///
/// Initializes union class with tag state of "file_locking".
///
/// @param fileLocking (no description).
///
/// @return An initialized instance.
///
- (instancetype)initWithFileLocking:(DBUSERSFileLockingValue *)fileLocking;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "paper_as_files".
///
/// @note Call this method and ensure it returns true before accessing the
/// `paperAsFiles` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "paper_as_files".
///
- (BOOL)isPaperAsFiles;

///
/// Retrieves whether the union's current tag state has value "file_locking".
///
/// @note Call this method and ensure it returns true before accessing the
/// `fileLocking` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "file_locking".
///
- (BOOL)isFileLocking;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBUSERSUserFeatureValue` union.
///
@interface DBUSERSUserFeatureValueSerializer : NSObject

///
/// Serializes `DBUSERSUserFeatureValue` instances.
///
/// @param instance An instance of the `DBUSERSUserFeatureValue` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBUSERSUserFeatureValue` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBUSERSUserFeatureValue *)instance;

///
/// Deserializes `DBUSERSUserFeatureValue` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBUSERSUserFeatureValue` API object.
///
/// @return An instantiation of the `DBUSERSUserFeatureValue` object.
///
+ (DBUSERSUserFeatureValue *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
