///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGTrustedNonTeamMemberType;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `TrustedNonTeamMemberType` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGTrustedNonTeamMemberType : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMLOGTrustedNonTeamMemberTypeTag` enum type represents the possible
/// tag states with which the `DBTEAMLOGTrustedNonTeamMemberType` union can
/// exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMLOGTrustedNonTeamMemberTypeTag){
    /// (no description).
    DBTEAMLOGTrustedNonTeamMemberTypeEnterpriseAdmin,

    /// (no description).
    DBTEAMLOGTrustedNonTeamMemberTypeMultiInstanceAdmin,

    /// (no description).
    DBTEAMLOGTrustedNonTeamMemberTypeOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMLOGTrustedNonTeamMemberTypeTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "enterprise_admin".
///
/// @return An initialized instance.
///
- (instancetype)initWithEnterpriseAdmin;

///
/// Initializes union class with tag state of "multi_instance_admin".
///
/// @return An initialized instance.
///
- (instancetype)initWithMultiInstanceAdmin;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value
/// "enterprise_admin".
///
/// @return Whether the union's current tag state has value "enterprise_admin".
///
- (BOOL)isEnterpriseAdmin;

///
/// Retrieves whether the union's current tag state has value
/// "multi_instance_admin".
///
/// @return Whether the union's current tag state has value
/// "multi_instance_admin".
///
- (BOOL)isMultiInstanceAdmin;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMLOGTrustedNonTeamMemberType` union.
///
@interface DBTEAMLOGTrustedNonTeamMemberTypeSerializer : NSObject

///
/// Serializes `DBTEAMLOGTrustedNonTeamMemberType` instances.
///
/// @param instance An instance of the `DBTEAMLOGTrustedNonTeamMemberType` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGTrustedNonTeamMemberType` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGTrustedNonTeamMemberType *)instance;

///
/// Deserializes `DBTEAMLOGTrustedNonTeamMemberType` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGTrustedNonTeamMemberType` API object.
///
/// @return An instantiation of the `DBTEAMLOGTrustedNonTeamMemberType` object.
///
+ (DBTEAMLOGTrustedNonTeamMemberType *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
