///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGTeamSharingWhitelistSubjectsChangedDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `TeamSharingWhitelistSubjectsChangedDetails` struct.
///
/// Edited the approved list for sharing externally.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGTeamSharingWhitelistSubjectsChangedDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Domains or emails added to the approved list for sharing externally.
@property (nonatomic, readonly) NSArray<NSString *> *addedWhitelistSubjects;

/// Domains or emails removed from the approved list for sharing externally.
@property (nonatomic, readonly) NSArray<NSString *> *removedWhitelistSubjects;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param addedWhitelistSubjects Domains or emails added to the approved list
/// for sharing externally.
/// @param removedWhitelistSubjects Domains or emails removed from the approved
/// list for sharing externally.
///
/// @return An initialized instance.
///
- (instancetype)initWithAddedWhitelistSubjects:(NSArray<NSString *> *)addedWhitelistSubjects
                      removedWhitelistSubjects:(NSArray<NSString *> *)removedWhitelistSubjects;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `TeamSharingWhitelistSubjectsChangedDetails`
/// struct.
///
@interface DBTEAMLOGTeamSharingWhitelistSubjectsChangedDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGTeamSharingWhitelistSubjectsChangedDetails` instances.
///
/// @param instance An instance of the
/// `DBTEAMLOGTeamSharingWhitelistSubjectsChangedDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGTeamSharingWhitelistSubjectsChangedDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGTeamSharingWhitelistSubjectsChangedDetails *)instance;

///
/// Deserializes `DBTEAMLOGTeamSharingWhitelistSubjectsChangedDetails`
/// instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGTeamSharingWhitelistSubjectsChangedDetails` API object.
///
/// @return An instantiation of the
/// `DBTEAMLOGTeamSharingWhitelistSubjectsChangedDetails` object.
///
+ (DBTEAMLOGTeamSharingWhitelistSubjectsChangedDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
