///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGSsoRemoveLoginUrlDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `SsoRemoveLoginUrlDetails` struct.
///
/// Removed sign-in URL for SSO.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGSsoRemoveLoginUrlDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Previous single sign-on login URL.
@property (nonatomic, readonly, copy) NSString *previousValue;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param previousValue Previous single sign-on login URL.
///
/// @return An initialized instance.
///
- (instancetype)initWithPreviousValue:(NSString *)previousValue;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `SsoRemoveLoginUrlDetails` struct.
///
@interface DBTEAMLOGSsoRemoveLoginUrlDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGSsoRemoveLoginUrlDetails` instances.
///
/// @param instance An instance of the `DBTEAMLOGSsoRemoveLoginUrlDetails` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGSsoRemoveLoginUrlDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGSsoRemoveLoginUrlDetails *)instance;

///
/// Deserializes `DBTEAMLOGSsoRemoveLoginUrlDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGSsoRemoveLoginUrlDetails` API object.
///
/// @return An instantiation of the `DBTEAMLOGSsoRemoveLoginUrlDetails` object.
///
+ (DBTEAMLOGSsoRemoveLoginUrlDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
