///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGSpaceCapsType;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `SpaceCapsType` union.
///
/// Space limit alert policy
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGSpaceCapsType : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMLOGSpaceCapsTypeTag` enum type represents the possible tag states
/// with which the `DBTEAMLOGSpaceCapsType` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMLOGSpaceCapsTypeTag){
    /// (no description).
    DBTEAMLOGSpaceCapsTypeHard,

    /// (no description).
    DBTEAMLOGSpaceCapsTypeOff,

    /// (no description).
    DBTEAMLOGSpaceCapsTypeSoft,

    /// (no description).
    DBTEAMLOGSpaceCapsTypeOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMLOGSpaceCapsTypeTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "hard".
///
/// @return An initialized instance.
///
- (instancetype)initWithHard;

///
/// Initializes union class with tag state of "off".
///
/// @return An initialized instance.
///
- (instancetype)initWithOff;

///
/// Initializes union class with tag state of "soft".
///
/// @return An initialized instance.
///
- (instancetype)initWithSoft;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "hard".
///
/// @return Whether the union's current tag state has value "hard".
///
- (BOOL)isHard;

///
/// Retrieves whether the union's current tag state has value "off".
///
/// @return Whether the union's current tag state has value "off".
///
- (BOOL)isOff;

///
/// Retrieves whether the union's current tag state has value "soft".
///
/// @return Whether the union's current tag state has value "soft".
///
- (BOOL)isSoft;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMLOGSpaceCapsType` union.
///
@interface DBTEAMLOGSpaceCapsTypeSerializer : NSObject

///
/// Serializes `DBTEAMLOGSpaceCapsType` instances.
///
/// @param instance An instance of the `DBTEAMLOGSpaceCapsType` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGSpaceCapsType` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGSpaceCapsType *)instance;

///
/// Deserializes `DBTEAMLOGSpaceCapsType` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGSpaceCapsType` API object.
///
/// @return An instantiation of the `DBTEAMLOGSpaceCapsType` object.
///
+ (DBTEAMLOGSpaceCapsType *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
