///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBSHARINGAccessLevel;
@class DBTEAMLOGSharedContentDownloadDetails;
@class DBTEAMLOGUserLogInfo;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `SharedContentDownloadDetails` struct.
///
/// Downloaded shared file/folder.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGSharedContentDownloadDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Shared content link.
@property (nonatomic, readonly, copy) NSString *sharedContentLink;

/// The shared content owner.
@property (nonatomic, readonly, nullable) DBTEAMLOGUserLogInfo *sharedContentOwner;

/// Shared content access level.
@property (nonatomic, readonly) DBSHARINGAccessLevel *sharedContentAccessLevel;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param sharedContentLink Shared content link.
/// @param sharedContentAccessLevel Shared content access level.
/// @param sharedContentOwner The shared content owner.
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedContentLink:(NSString *)sharedContentLink
                 sharedContentAccessLevel:(DBSHARINGAccessLevel *)sharedContentAccessLevel
                       sharedContentOwner:(nullable DBTEAMLOGUserLogInfo *)sharedContentOwner;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param sharedContentLink Shared content link.
/// @param sharedContentAccessLevel Shared content access level.
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedContentLink:(NSString *)sharedContentLink
                 sharedContentAccessLevel:(DBSHARINGAccessLevel *)sharedContentAccessLevel;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `SharedContentDownloadDetails` struct.
///
@interface DBTEAMLOGSharedContentDownloadDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGSharedContentDownloadDetails` instances.
///
/// @param instance An instance of the `DBTEAMLOGSharedContentDownloadDetails`
/// API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGSharedContentDownloadDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGSharedContentDownloadDetails *)instance;

///
/// Deserializes `DBTEAMLOGSharedContentDownloadDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGSharedContentDownloadDetails` API object.
///
/// @return An instantiation of the `DBTEAMLOGSharedContentDownloadDetails`
/// object.
///
+ (DBTEAMLOGSharedContentDownloadDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
