///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGSharedContentChangeLinkExpiryDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `SharedContentChangeLinkExpiryDetails` struct.
///
/// Changed link expiration of shared file/folder.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGSharedContentChangeLinkExpiryDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// New shared content link expiration date. Might be missing due to historical
/// data gap.
@property (nonatomic, readonly, nullable) NSDate *dNewValue;

/// Previous shared content link expiration date. Might be missing due to
/// historical data gap.
@property (nonatomic, readonly, nullable) NSDate *previousValue;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param dNewValue New shared content link expiration date. Might be missing
/// due to historical data gap.
/// @param previousValue Previous shared content link expiration date. Might be
/// missing due to historical data gap.
///
/// @return An initialized instance.
///
- (instancetype)initWithDNewValue:(nullable NSDate *)dNewValue previousValue:(nullable NSDate *)previousValue;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
///
/// @return An initialized instance.
///
- (instancetype)initDefault;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `SharedContentChangeLinkExpiryDetails`
/// struct.
///
@interface DBTEAMLOGSharedContentChangeLinkExpiryDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGSharedContentChangeLinkExpiryDetails` instances.
///
/// @param instance An instance of the
/// `DBTEAMLOGSharedContentChangeLinkExpiryDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGSharedContentChangeLinkExpiryDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGSharedContentChangeLinkExpiryDetails *)instance;

///
/// Deserializes `DBTEAMLOGSharedContentChangeLinkExpiryDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGSharedContentChangeLinkExpiryDetails` API object.
///
/// @return An instantiation of the
/// `DBTEAMLOGSharedContentChangeLinkExpiryDetails` object.
///
+ (DBTEAMLOGSharedContentChangeLinkExpiryDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
