///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGPaperContentRemoveFromFolderDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `PaperContentRemoveFromFolderDetails` struct.
///
/// Removed Paper doc/folder from folder.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGPaperContentRemoveFromFolderDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Event unique identifier.
@property (nonatomic, readonly, copy) NSString *eventUuid;

/// Target asset position in the Assets list.
@property (nonatomic, readonly, nullable) NSNumber *targetAssetIndex;

/// Parent asset position in the Assets list.
@property (nonatomic, readonly, nullable) NSNumber *parentAssetIndex;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param eventUuid Event unique identifier.
/// @param targetAssetIndex Target asset position in the Assets list.
/// @param parentAssetIndex Parent asset position in the Assets list.
///
/// @return An initialized instance.
///
- (instancetype)initWithEventUuid:(NSString *)eventUuid
                 targetAssetIndex:(nullable NSNumber *)targetAssetIndex
                 parentAssetIndex:(nullable NSNumber *)parentAssetIndex;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param eventUuid Event unique identifier.
///
/// @return An initialized instance.
///
- (instancetype)initWithEventUuid:(NSString *)eventUuid;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `PaperContentRemoveFromFolderDetails`
/// struct.
///
@interface DBTEAMLOGPaperContentRemoveFromFolderDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGPaperContentRemoveFromFolderDetails` instances.
///
/// @param instance An instance of the
/// `DBTEAMLOGPaperContentRemoveFromFolderDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGPaperContentRemoveFromFolderDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGPaperContentRemoveFromFolderDetails *)instance;

///
/// Deserializes `DBTEAMLOGPaperContentRemoveFromFolderDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGPaperContentRemoveFromFolderDetails` API object.
///
/// @return An instantiation of the
/// `DBTEAMLOGPaperContentRemoveFromFolderDetails` object.
///
+ (DBTEAMLOGPaperContentRemoveFromFolderDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
