///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGIntegrationConnectedDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `IntegrationConnectedDetails` struct.
///
/// Connected integration for member.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGIntegrationConnectedDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Name of the third-party integration.
@property (nonatomic, readonly, copy) NSString *integrationName;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param integrationName Name of the third-party integration.
///
/// @return An initialized instance.
///
- (instancetype)initWithIntegrationName:(NSString *)integrationName;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `IntegrationConnectedDetails` struct.
///
@interface DBTEAMLOGIntegrationConnectedDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGIntegrationConnectedDetails` instances.
///
/// @param instance An instance of the `DBTEAMLOGIntegrationConnectedDetails`
/// API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGIntegrationConnectedDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGIntegrationConnectedDetails *)instance;

///
/// Deserializes `DBTEAMLOGIntegrationConnectedDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGIntegrationConnectedDetails` API object.
///
/// @return An instantiation of the `DBTEAMLOGIntegrationConnectedDetails`
/// object.
///
+ (DBTEAMLOGIntegrationConnectedDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
