///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGIdentifierType;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `IdentifierType` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGIdentifierType : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMLOGIdentifierTypeTag` enum type represents the possible tag
/// states with which the `DBTEAMLOGIdentifierType` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMLOGIdentifierTypeTag){
    /// (no description).
    DBTEAMLOGIdentifierTypeEmail,

    /// (no description).
    DBTEAMLOGIdentifierTypeFacebookProfileName,

    /// (no description).
    DBTEAMLOGIdentifierTypeOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMLOGIdentifierTypeTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "email".
///
/// @return An initialized instance.
///
- (instancetype)initWithEmail;

///
/// Initializes union class with tag state of "facebook_profile_name".
///
/// @return An initialized instance.
///
- (instancetype)initWithFacebookProfileName;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "email".
///
/// @return Whether the union's current tag state has value "email".
///
- (BOOL)isEmail;

///
/// Retrieves whether the union's current tag state has value
/// "facebook_profile_name".
///
/// @return Whether the union's current tag state has value
/// "facebook_profile_name".
///
- (BOOL)isFacebookProfileName;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMLOGIdentifierType` union.
///
@interface DBTEAMLOGIdentifierTypeSerializer : NSObject

///
/// Serializes `DBTEAMLOGIdentifierType` instances.
///
/// @param instance An instance of the `DBTEAMLOGIdentifierType` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGIdentifierType` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGIdentifierType *)instance;

///
/// Deserializes `DBTEAMLOGIdentifierType` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGIdentifierType` API object.
///
/// @return An instantiation of the `DBTEAMLOGIdentifierType` object.
///
+ (DBTEAMLOGIdentifierType *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
