///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGGovernancePolicyExportRemovedDetails;
@class DBTEAMLOGPolicyType;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `GovernancePolicyExportRemovedDetails` struct.
///
/// Removed a policy download.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGGovernancePolicyExportRemovedDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Policy ID.
@property (nonatomic, readonly, copy) NSString *governancePolicyId;

/// Policy name.
@property (nonatomic, readonly, copy) NSString *name;

/// Policy type.
@property (nonatomic, readonly, nullable) DBTEAMLOGPolicyType *policyType;

/// Export name.
@property (nonatomic, readonly, copy) NSString *exportName;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param governancePolicyId Policy ID.
/// @param name Policy name.
/// @param exportName Export name.
/// @param policyType Policy type.
///
/// @return An initialized instance.
///
- (instancetype)initWithGovernancePolicyId:(NSString *)governancePolicyId
                                      name:(NSString *)name
                                exportName:(NSString *)exportName
                                policyType:(nullable DBTEAMLOGPolicyType *)policyType;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param governancePolicyId Policy ID.
/// @param name Policy name.
/// @param exportName Export name.
///
/// @return An initialized instance.
///
- (instancetype)initWithGovernancePolicyId:(NSString *)governancePolicyId
                                      name:(NSString *)name
                                exportName:(NSString *)exportName;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `GovernancePolicyExportRemovedDetails`
/// struct.
///
@interface DBTEAMLOGGovernancePolicyExportRemovedDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGGovernancePolicyExportRemovedDetails` instances.
///
/// @param instance An instance of the
/// `DBTEAMLOGGovernancePolicyExportRemovedDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGGovernancePolicyExportRemovedDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGGovernancePolicyExportRemovedDetails *)instance;

///
/// Deserializes `DBTEAMLOGGovernancePolicyExportRemovedDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGGovernancePolicyExportRemovedDetails` API object.
///
/// @return An instantiation of the
/// `DBTEAMLOGGovernancePolicyExportRemovedDetails` object.
///
+ (DBTEAMLOGGovernancePolicyExportRemovedDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
