///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGEmmChangePolicyDetails;
@class DBTEAMPOLICIESEmmState;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `EmmChangePolicyDetails` struct.
///
/// Enabled/disabled enterprise mobility management for members.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGEmmChangePolicyDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// New enterprise mobility management policy.
@property (nonatomic, readonly) DBTEAMPOLICIESEmmState *dNewValue;

/// Previous enterprise mobility management policy. Might be missing due to
/// historical data gap.
@property (nonatomic, readonly, nullable) DBTEAMPOLICIESEmmState *previousValue;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param dNewValue New enterprise mobility management policy.
/// @param previousValue Previous enterprise mobility management policy. Might
/// be missing due to historical data gap.
///
/// @return An initialized instance.
///
- (instancetype)initWithDNewValue:(DBTEAMPOLICIESEmmState *)dNewValue
                    previousValue:(nullable DBTEAMPOLICIESEmmState *)previousValue;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param dNewValue New enterprise mobility management policy.
///
/// @return An initialized instance.
///
- (instancetype)initWithDNewValue:(DBTEAMPOLICIESEmmState *)dNewValue;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `EmmChangePolicyDetails` struct.
///
@interface DBTEAMLOGEmmChangePolicyDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGEmmChangePolicyDetails` instances.
///
/// @param instance An instance of the `DBTEAMLOGEmmChangePolicyDetails` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGEmmChangePolicyDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGEmmChangePolicyDetails *)instance;

///
/// Deserializes `DBTEAMLOGEmmChangePolicyDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGEmmChangePolicyDetails` API object.
///
/// @return An instantiation of the `DBTEAMLOGEmmChangePolicyDetails` object.
///
+ (DBTEAMLOGEmmChangePolicyDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
