///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGDeleteTeamInviteLinkDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `DeleteTeamInviteLinkDetails` struct.
///
/// Deleted team invite link.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGDeleteTeamInviteLinkDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The invite link url that was deleted.
@property (nonatomic, readonly, copy) NSString *linkUrl;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param linkUrl The invite link url that was deleted.
///
/// @return An initialized instance.
///
- (instancetype)initWithLinkUrl:(NSString *)linkUrl;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DeleteTeamInviteLinkDetails` struct.
///
@interface DBTEAMLOGDeleteTeamInviteLinkDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGDeleteTeamInviteLinkDetails` instances.
///
/// @param instance An instance of the `DBTEAMLOGDeleteTeamInviteLinkDetails`
/// API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGDeleteTeamInviteLinkDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeleteTeamInviteLinkDetails *)instance;

///
/// Deserializes `DBTEAMLOGDeleteTeamInviteLinkDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGDeleteTeamInviteLinkDetails` API object.
///
/// @return An instantiation of the `DBTEAMLOGDeleteTeamInviteLinkDetails`
/// object.
///
+ (DBTEAMLOGDeleteTeamInviteLinkDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
