///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMGroupsSelector;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `GroupsSelector` union.
///
/// Argument for selecting a list of groups, either by group_ids, or external
/// group IDs.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMGroupsSelector : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMGroupsSelectorTag` enum type represents the possible tag states
/// with which the `DBTEAMGroupsSelector` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMGroupsSelectorTag){
    /// List of group IDs.
    DBTEAMGroupsSelectorGroupIds,

    /// List of external IDs of groups.
    DBTEAMGroupsSelectorGroupExternalIds,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMGroupsSelectorTag tag;

/// List of group IDs. @note Ensure the `isGroupIds` method returns true before
/// accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) NSArray<NSString *> *groupIds;

/// List of external IDs of groups. @note Ensure the `isGroupExternalIds` method
/// returns true before accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) NSArray<NSString *> *groupExternalIds;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "group_ids".
///
/// Description of the "group_ids" tag state: List of group IDs.
///
/// @param groupIds List of group IDs.
///
/// @return An initialized instance.
///
- (instancetype)initWithGroupIds:(NSArray<NSString *> *)groupIds;

///
/// Initializes union class with tag state of "group_external_ids".
///
/// Description of the "group_external_ids" tag state: List of external IDs of
/// groups.
///
/// @param groupExternalIds List of external IDs of groups.
///
/// @return An initialized instance.
///
- (instancetype)initWithGroupExternalIds:(NSArray<NSString *> *)groupExternalIds;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "group_ids".
///
/// @note Call this method and ensure it returns true before accessing the
/// `groupIds` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "group_ids".
///
- (BOOL)isGroupIds;

///
/// Retrieves whether the union's current tag state has value
/// "group_external_ids".
///
/// @note Call this method and ensure it returns true before accessing the
/// `groupExternalIds` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value
/// "group_external_ids".
///
- (BOOL)isGroupExternalIds;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMGroupsSelector` union.
///
@interface DBTEAMGroupsSelectorSerializer : NSObject

///
/// Serializes `DBTEAMGroupsSelector` instances.
///
/// @param instance An instance of the `DBTEAMGroupsSelector` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMGroupsSelector` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupsSelector *)instance;

///
/// Deserializes `DBTEAMGroupsSelector` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMGroupsSelector` API object.
///
/// @return An instantiation of the `DBTEAMGroupsSelector` object.
///
+ (DBTEAMGroupsSelector *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
