///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

/// Arguments, results, and errors for the `Team` namespace.

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMDeviceSession.h"

#pragma mark - API Object

@implementation DBTEAMDeviceSession

#pragma mark - Constructors

- (instancetype)initWithSessionId:(NSString *)sessionId
                        ipAddress:(NSString *)ipAddress
                          country:(NSString *)country
                          created:(NSDate *)created
                          updated:(NSDate *)updated {
  [DBStoneValidators nonnullValidator:nil](sessionId);

  self = [super init];
  if (self) {
    _sessionId = sessionId;
    _ipAddress = ipAddress;
    _country = country;
    _created = created;
    _updated = updated;
  }
  return self;
}

- (instancetype)initWithSessionId:(NSString *)sessionId {
  return [self initWithSessionId:sessionId ipAddress:nil country:nil created:nil updated:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMDeviceSessionSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMDeviceSessionSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMDeviceSessionSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.sessionId hash];
  if (self.ipAddress != nil) {
    result = prime * result + [self.ipAddress hash];
  }
  if (self.country != nil) {
    result = prime * result + [self.country hash];
  }
  if (self.created != nil) {
    result = prime * result + [self.created hash];
  }
  if (self.updated != nil) {
    result = prime * result + [self.updated hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceSession:other];
}

- (BOOL)isEqualToDeviceSession:(DBTEAMDeviceSession *)aDeviceSession {
  if (self == aDeviceSession) {
    return YES;
  }
  if (![self.sessionId isEqual:aDeviceSession.sessionId]) {
    return NO;
  }
  if (self.ipAddress) {
    if (![self.ipAddress isEqual:aDeviceSession.ipAddress]) {
      return NO;
    }
  }
  if (self.country) {
    if (![self.country isEqual:aDeviceSession.country]) {
      return NO;
    }
  }
  if (self.created) {
    if (![self.created isEqual:aDeviceSession.created]) {
      return NO;
    }
  }
  if (self.updated) {
    if (![self.updated isEqual:aDeviceSession.updated]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMDeviceSessionSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMDeviceSession *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"session_id"] = valueObj.sessionId;
  if (valueObj.ipAddress) {
    jsonDict[@"ip_address"] = valueObj.ipAddress;
  }
  if (valueObj.country) {
    jsonDict[@"country"] = valueObj.country;
  }
  if (valueObj.created) {
    jsonDict[@"created"] = [DBNSDateSerializer serialize:valueObj.created dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }
  if (valueObj.updated) {
    jsonDict[@"updated"] = [DBNSDateSerializer serialize:valueObj.updated dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMDeviceSession *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *sessionId = valueDict[@"session_id"];
  NSString *ipAddress = valueDict[@"ip_address"] ?: nil;
  NSString *country = valueDict[@"country"] ?: nil;
  NSDate *created = valueDict[@"created"]
                        ? [DBNSDateSerializer deserialize:valueDict[@"created"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                        : nil;
  NSDate *updated = valueDict[@"updated"]
                        ? [DBNSDateSerializer deserialize:valueDict[@"updated"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                        : nil;

  return [[DBTEAMDeviceSession alloc] initWithSessionId:sessionId
                                              ipAddress:ipAddress
                                                country:country
                                                created:created
                                                updated:updated];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMActiveWebSession.h"
#import "DBTEAMDeviceSession.h"

#pragma mark - API Object

@implementation DBTEAMActiveWebSession

#pragma mark - Constructors

- (instancetype)initWithSessionId:(NSString *)sessionId
                        userAgent:(NSString *)userAgent
                               os:(NSString *)os
                          browser:(NSString *)browser
                        ipAddress:(NSString *)ipAddress
                          country:(NSString *)country
                          created:(NSDate *)created
                          updated:(NSDate *)updated
                          expires:(NSDate *)expires {
  [DBStoneValidators nonnullValidator:nil](sessionId);
  [DBStoneValidators nonnullValidator:nil](userAgent);
  [DBStoneValidators nonnullValidator:nil](os);
  [DBStoneValidators nonnullValidator:nil](browser);

  self = [super initWithSessionId:sessionId ipAddress:ipAddress country:country created:created updated:updated];
  if (self) {
    _userAgent = userAgent;
    _os = os;
    _browser = browser;
    _expires = expires;
  }
  return self;
}

- (instancetype)initWithSessionId:(NSString *)sessionId
                        userAgent:(NSString *)userAgent
                               os:(NSString *)os
                          browser:(NSString *)browser {
  return [self initWithSessionId:sessionId
                       userAgent:userAgent
                              os:os
                         browser:browser
                       ipAddress:nil
                         country:nil
                         created:nil
                         updated:nil
                         expires:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMActiveWebSessionSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMActiveWebSessionSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMActiveWebSessionSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.sessionId hash];
  result = prime * result + [self.userAgent hash];
  result = prime * result + [self.os hash];
  result = prime * result + [self.browser hash];
  if (self.ipAddress != nil) {
    result = prime * result + [self.ipAddress hash];
  }
  if (self.country != nil) {
    result = prime * result + [self.country hash];
  }
  if (self.created != nil) {
    result = prime * result + [self.created hash];
  }
  if (self.updated != nil) {
    result = prime * result + [self.updated hash];
  }
  if (self.expires != nil) {
    result = prime * result + [self.expires hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToActiveWebSession:other];
}

- (BOOL)isEqualToActiveWebSession:(DBTEAMActiveWebSession *)anActiveWebSession {
  if (self == anActiveWebSession) {
    return YES;
  }
  if (![self.sessionId isEqual:anActiveWebSession.sessionId]) {
    return NO;
  }
  if (![self.userAgent isEqual:anActiveWebSession.userAgent]) {
    return NO;
  }
  if (![self.os isEqual:anActiveWebSession.os]) {
    return NO;
  }
  if (![self.browser isEqual:anActiveWebSession.browser]) {
    return NO;
  }
  if (self.ipAddress) {
    if (![self.ipAddress isEqual:anActiveWebSession.ipAddress]) {
      return NO;
    }
  }
  if (self.country) {
    if (![self.country isEqual:anActiveWebSession.country]) {
      return NO;
    }
  }
  if (self.created) {
    if (![self.created isEqual:anActiveWebSession.created]) {
      return NO;
    }
  }
  if (self.updated) {
    if (![self.updated isEqual:anActiveWebSession.updated]) {
      return NO;
    }
  }
  if (self.expires) {
    if (![self.expires isEqual:anActiveWebSession.expires]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMActiveWebSessionSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMActiveWebSession *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"session_id"] = valueObj.sessionId;
  jsonDict[@"user_agent"] = valueObj.userAgent;
  jsonDict[@"os"] = valueObj.os;
  jsonDict[@"browser"] = valueObj.browser;
  if (valueObj.ipAddress) {
    jsonDict[@"ip_address"] = valueObj.ipAddress;
  }
  if (valueObj.country) {
    jsonDict[@"country"] = valueObj.country;
  }
  if (valueObj.created) {
    jsonDict[@"created"] = [DBNSDateSerializer serialize:valueObj.created dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }
  if (valueObj.updated) {
    jsonDict[@"updated"] = [DBNSDateSerializer serialize:valueObj.updated dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }
  if (valueObj.expires) {
    jsonDict[@"expires"] = [DBNSDateSerializer serialize:valueObj.expires dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMActiveWebSession *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *sessionId = valueDict[@"session_id"];
  NSString *userAgent = valueDict[@"user_agent"];
  NSString *os = valueDict[@"os"];
  NSString *browser = valueDict[@"browser"];
  NSString *ipAddress = valueDict[@"ip_address"] ?: nil;
  NSString *country = valueDict[@"country"] ?: nil;
  NSDate *created = valueDict[@"created"]
                        ? [DBNSDateSerializer deserialize:valueDict[@"created"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                        : nil;
  NSDate *updated = valueDict[@"updated"]
                        ? [DBNSDateSerializer deserialize:valueDict[@"updated"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                        : nil;
  NSDate *expires = valueDict[@"expires"]
                        ? [DBNSDateSerializer deserialize:valueDict[@"expires"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                        : nil;

  return [[DBTEAMActiveWebSession alloc] initWithSessionId:sessionId
                                                 userAgent:userAgent
                                                        os:os
                                                   browser:browser
                                                 ipAddress:ipAddress
                                                   country:country
                                                   created:created
                                                   updated:updated
                                                   expires:expires];
}

@end

#import "DBSECONDARYEMAILSSecondaryEmail.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMAddSecondaryEmailResult.h"

#pragma mark - API Object

@implementation DBTEAMAddSecondaryEmailResult

@synthesize success = _success;
@synthesize unavailable = _unavailable;
@synthesize alreadyPending = _alreadyPending;
@synthesize alreadyOwnedByUser = _alreadyOwnedByUser;
@synthesize reachedLimit = _reachedLimit;
@synthesize transientError = _transientError;
@synthesize tooManyUpdates = _tooManyUpdates;
@synthesize unknownError = _unknownError;
@synthesize rateLimited = _rateLimited;

#pragma mark - Constructors

- (instancetype)initWithSuccess:(DBSECONDARYEMAILSSecondaryEmail *)success {
  self = [super init];
  if (self) {
    _tag = DBTEAMAddSecondaryEmailResultSuccess;
    _success = success;
  }
  return self;
}

- (instancetype)initWithUnavailable:(NSString *)unavailable {
  self = [super init];
  if (self) {
    _tag = DBTEAMAddSecondaryEmailResultUnavailable;
    _unavailable = unavailable;
  }
  return self;
}

- (instancetype)initWithAlreadyPending:(NSString *)alreadyPending {
  self = [super init];
  if (self) {
    _tag = DBTEAMAddSecondaryEmailResultAlreadyPending;
    _alreadyPending = alreadyPending;
  }
  return self;
}

- (instancetype)initWithAlreadyOwnedByUser:(NSString *)alreadyOwnedByUser {
  self = [super init];
  if (self) {
    _tag = DBTEAMAddSecondaryEmailResultAlreadyOwnedByUser;
    _alreadyOwnedByUser = alreadyOwnedByUser;
  }
  return self;
}

- (instancetype)initWithReachedLimit:(NSString *)reachedLimit {
  self = [super init];
  if (self) {
    _tag = DBTEAMAddSecondaryEmailResultReachedLimit;
    _reachedLimit = reachedLimit;
  }
  return self;
}

- (instancetype)initWithTransientError:(NSString *)transientError {
  self = [super init];
  if (self) {
    _tag = DBTEAMAddSecondaryEmailResultTransientError;
    _transientError = transientError;
  }
  return self;
}

- (instancetype)initWithTooManyUpdates:(NSString *)tooManyUpdates {
  self = [super init];
  if (self) {
    _tag = DBTEAMAddSecondaryEmailResultTooManyUpdates;
    _tooManyUpdates = tooManyUpdates;
  }
  return self;
}

- (instancetype)initWithUnknownError:(NSString *)unknownError {
  self = [super init];
  if (self) {
    _tag = DBTEAMAddSecondaryEmailResultUnknownError;
    _unknownError = unknownError;
  }
  return self;
}

- (instancetype)initWithRateLimited:(NSString *)rateLimited {
  self = [super init];
  if (self) {
    _tag = DBTEAMAddSecondaryEmailResultRateLimited;
    _rateLimited = rateLimited;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMAddSecondaryEmailResultOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSECONDARYEMAILSSecondaryEmail *)success {
  if (![self isSuccess]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMAddSecondaryEmailResultSuccess, but was %@.", [self tagName]];
  }
  return _success;
}

- (NSString *)unavailable {
  if (![self isUnavailable]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMAddSecondaryEmailResultUnavailable, but was %@.", [self tagName]];
  }
  return _unavailable;
}

- (NSString *)alreadyPending {
  if (![self isAlreadyPending]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMAddSecondaryEmailResultAlreadyPending, but was %@.", [self tagName]];
  }
  return _alreadyPending;
}

- (NSString *)alreadyOwnedByUser {
  if (![self isAlreadyOwnedByUser]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMAddSecondaryEmailResultAlreadyOwnedByUser, but was %@.", [self tagName]];
  }
  return _alreadyOwnedByUser;
}

- (NSString *)reachedLimit {
  if (![self isReachedLimit]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMAddSecondaryEmailResultReachedLimit, but was %@.", [self tagName]];
  }
  return _reachedLimit;
}

- (NSString *)transientError {
  if (![self isTransientError]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMAddSecondaryEmailResultTransientError, but was %@.", [self tagName]];
  }
  return _transientError;
}

- (NSString *)tooManyUpdates {
  if (![self isTooManyUpdates]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMAddSecondaryEmailResultTooManyUpdates, but was %@.", [self tagName]];
  }
  return _tooManyUpdates;
}

- (NSString *)unknownError {
  if (![self isUnknownError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMAddSecondaryEmailResultUnknownError, but was %@.", [self tagName]];
  }
  return _unknownError;
}

- (NSString *)rateLimited {
  if (![self isRateLimited]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMAddSecondaryEmailResultRateLimited, but was %@.", [self tagName]];
  }
  return _rateLimited;
}

#pragma mark - Tag state methods

- (BOOL)isSuccess {
  return _tag == DBTEAMAddSecondaryEmailResultSuccess;
}

- (BOOL)isUnavailable {
  return _tag == DBTEAMAddSecondaryEmailResultUnavailable;
}

- (BOOL)isAlreadyPending {
  return _tag == DBTEAMAddSecondaryEmailResultAlreadyPending;
}

- (BOOL)isAlreadyOwnedByUser {
  return _tag == DBTEAMAddSecondaryEmailResultAlreadyOwnedByUser;
}

- (BOOL)isReachedLimit {
  return _tag == DBTEAMAddSecondaryEmailResultReachedLimit;
}

- (BOOL)isTransientError {
  return _tag == DBTEAMAddSecondaryEmailResultTransientError;
}

- (BOOL)isTooManyUpdates {
  return _tag == DBTEAMAddSecondaryEmailResultTooManyUpdates;
}

- (BOOL)isUnknownError {
  return _tag == DBTEAMAddSecondaryEmailResultUnknownError;
}

- (BOOL)isRateLimited {
  return _tag == DBTEAMAddSecondaryEmailResultRateLimited;
}

- (BOOL)isOther {
  return _tag == DBTEAMAddSecondaryEmailResultOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMAddSecondaryEmailResultSuccess:
    return @"DBTEAMAddSecondaryEmailResultSuccess";
  case DBTEAMAddSecondaryEmailResultUnavailable:
    return @"DBTEAMAddSecondaryEmailResultUnavailable";
  case DBTEAMAddSecondaryEmailResultAlreadyPending:
    return @"DBTEAMAddSecondaryEmailResultAlreadyPending";
  case DBTEAMAddSecondaryEmailResultAlreadyOwnedByUser:
    return @"DBTEAMAddSecondaryEmailResultAlreadyOwnedByUser";
  case DBTEAMAddSecondaryEmailResultReachedLimit:
    return @"DBTEAMAddSecondaryEmailResultReachedLimit";
  case DBTEAMAddSecondaryEmailResultTransientError:
    return @"DBTEAMAddSecondaryEmailResultTransientError";
  case DBTEAMAddSecondaryEmailResultTooManyUpdates:
    return @"DBTEAMAddSecondaryEmailResultTooManyUpdates";
  case DBTEAMAddSecondaryEmailResultUnknownError:
    return @"DBTEAMAddSecondaryEmailResultUnknownError";
  case DBTEAMAddSecondaryEmailResultRateLimited:
    return @"DBTEAMAddSecondaryEmailResultRateLimited";
  case DBTEAMAddSecondaryEmailResultOther:
    return @"DBTEAMAddSecondaryEmailResultOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMAddSecondaryEmailResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMAddSecondaryEmailResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMAddSecondaryEmailResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMAddSecondaryEmailResultSuccess:
    result = prime * result + [self.success hash];
    break;
  case DBTEAMAddSecondaryEmailResultUnavailable:
    result = prime * result + [self.unavailable hash];
    break;
  case DBTEAMAddSecondaryEmailResultAlreadyPending:
    result = prime * result + [self.alreadyPending hash];
    break;
  case DBTEAMAddSecondaryEmailResultAlreadyOwnedByUser:
    result = prime * result + [self.alreadyOwnedByUser hash];
    break;
  case DBTEAMAddSecondaryEmailResultReachedLimit:
    result = prime * result + [self.reachedLimit hash];
    break;
  case DBTEAMAddSecondaryEmailResultTransientError:
    result = prime * result + [self.transientError hash];
    break;
  case DBTEAMAddSecondaryEmailResultTooManyUpdates:
    result = prime * result + [self.tooManyUpdates hash];
    break;
  case DBTEAMAddSecondaryEmailResultUnknownError:
    result = prime * result + [self.unknownError hash];
    break;
  case DBTEAMAddSecondaryEmailResultRateLimited:
    result = prime * result + [self.rateLimited hash];
    break;
  case DBTEAMAddSecondaryEmailResultOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAddSecondaryEmailResult:other];
}

- (BOOL)isEqualToAddSecondaryEmailResult:(DBTEAMAddSecondaryEmailResult *)anAddSecondaryEmailResult {
  if (self == anAddSecondaryEmailResult) {
    return YES;
  }
  if (self.tag != anAddSecondaryEmailResult.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMAddSecondaryEmailResultSuccess:
    return [self.success isEqual:anAddSecondaryEmailResult.success];
  case DBTEAMAddSecondaryEmailResultUnavailable:
    return [self.unavailable isEqual:anAddSecondaryEmailResult.unavailable];
  case DBTEAMAddSecondaryEmailResultAlreadyPending:
    return [self.alreadyPending isEqual:anAddSecondaryEmailResult.alreadyPending];
  case DBTEAMAddSecondaryEmailResultAlreadyOwnedByUser:
    return [self.alreadyOwnedByUser isEqual:anAddSecondaryEmailResult.alreadyOwnedByUser];
  case DBTEAMAddSecondaryEmailResultReachedLimit:
    return [self.reachedLimit isEqual:anAddSecondaryEmailResult.reachedLimit];
  case DBTEAMAddSecondaryEmailResultTransientError:
    return [self.transientError isEqual:anAddSecondaryEmailResult.transientError];
  case DBTEAMAddSecondaryEmailResultTooManyUpdates:
    return [self.tooManyUpdates isEqual:anAddSecondaryEmailResult.tooManyUpdates];
  case DBTEAMAddSecondaryEmailResultUnknownError:
    return [self.unknownError isEqual:anAddSecondaryEmailResult.unknownError];
  case DBTEAMAddSecondaryEmailResultRateLimited:
    return [self.rateLimited isEqual:anAddSecondaryEmailResult.rateLimited];
  case DBTEAMAddSecondaryEmailResultOther:
    return [[self tagName] isEqual:[anAddSecondaryEmailResult tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMAddSecondaryEmailResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMAddSecondaryEmailResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isSuccess]) {
    jsonDict = [[DBSECONDARYEMAILSSecondaryEmailSerializer serialize:valueObj.success] mutableCopy];
    jsonDict[@".tag"] = @"success";
  } else if ([valueObj isUnavailable]) {
    jsonDict[@"unavailable"] = valueObj.unavailable;
    jsonDict[@".tag"] = @"unavailable";
  } else if ([valueObj isAlreadyPending]) {
    jsonDict[@"already_pending"] = valueObj.alreadyPending;
    jsonDict[@".tag"] = @"already_pending";
  } else if ([valueObj isAlreadyOwnedByUser]) {
    jsonDict[@"already_owned_by_user"] = valueObj.alreadyOwnedByUser;
    jsonDict[@".tag"] = @"already_owned_by_user";
  } else if ([valueObj isReachedLimit]) {
    jsonDict[@"reached_limit"] = valueObj.reachedLimit;
    jsonDict[@".tag"] = @"reached_limit";
  } else if ([valueObj isTransientError]) {
    jsonDict[@"transient_error"] = valueObj.transientError;
    jsonDict[@".tag"] = @"transient_error";
  } else if ([valueObj isTooManyUpdates]) {
    jsonDict[@"too_many_updates"] = valueObj.tooManyUpdates;
    jsonDict[@".tag"] = @"too_many_updates";
  } else if ([valueObj isUnknownError]) {
    jsonDict[@"unknown_error"] = valueObj.unknownError;
    jsonDict[@".tag"] = @"unknown_error";
  } else if ([valueObj isRateLimited]) {
    jsonDict[@"rate_limited"] = valueObj.rateLimited;
    jsonDict[@".tag"] = @"rate_limited";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMAddSecondaryEmailResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"success"]) {
    DBSECONDARYEMAILSSecondaryEmail *success = [DBSECONDARYEMAILSSecondaryEmailSerializer deserialize:valueDict];
    return [[DBTEAMAddSecondaryEmailResult alloc] initWithSuccess:success];
  } else if ([tag isEqualToString:@"unavailable"]) {
    NSString *unavailable = valueDict[@"unavailable"];
    return [[DBTEAMAddSecondaryEmailResult alloc] initWithUnavailable:unavailable];
  } else if ([tag isEqualToString:@"already_pending"]) {
    NSString *alreadyPending = valueDict[@"already_pending"];
    return [[DBTEAMAddSecondaryEmailResult alloc] initWithAlreadyPending:alreadyPending];
  } else if ([tag isEqualToString:@"already_owned_by_user"]) {
    NSString *alreadyOwnedByUser = valueDict[@"already_owned_by_user"];
    return [[DBTEAMAddSecondaryEmailResult alloc] initWithAlreadyOwnedByUser:alreadyOwnedByUser];
  } else if ([tag isEqualToString:@"reached_limit"]) {
    NSString *reachedLimit = valueDict[@"reached_limit"];
    return [[DBTEAMAddSecondaryEmailResult alloc] initWithReachedLimit:reachedLimit];
  } else if ([tag isEqualToString:@"transient_error"]) {
    NSString *transientError = valueDict[@"transient_error"];
    return [[DBTEAMAddSecondaryEmailResult alloc] initWithTransientError:transientError];
  } else if ([tag isEqualToString:@"too_many_updates"]) {
    NSString *tooManyUpdates = valueDict[@"too_many_updates"];
    return [[DBTEAMAddSecondaryEmailResult alloc] initWithTooManyUpdates:tooManyUpdates];
  } else if ([tag isEqualToString:@"unknown_error"]) {
    NSString *unknownError = valueDict[@"unknown_error"];
    return [[DBTEAMAddSecondaryEmailResult alloc] initWithUnknownError:unknownError];
  } else if ([tag isEqualToString:@"rate_limited"]) {
    NSString *rateLimited = valueDict[@"rate_limited"];
    return [[DBTEAMAddSecondaryEmailResult alloc] initWithRateLimited:rateLimited];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMAddSecondaryEmailResult alloc] initWithOther];
  } else {
    return [[DBTEAMAddSecondaryEmailResult alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMAddSecondaryEmailsArg.h"
#import "DBTEAMUserSecondaryEmailsArg.h"

#pragma mark - API Object

@implementation DBTEAMAddSecondaryEmailsArg

#pragma mark - Constructors

- (instancetype)initWithDNewSecondaryEmails:(NSArray<DBTEAMUserSecondaryEmailsArg *> *)dNewSecondaryEmails {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](dNewSecondaryEmails);

  self = [super init];
  if (self) {
    _dNewSecondaryEmails = dNewSecondaryEmails;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMAddSecondaryEmailsArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMAddSecondaryEmailsArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMAddSecondaryEmailsArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.dNewSecondaryEmails hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAddSecondaryEmailsArg:other];
}

- (BOOL)isEqualToAddSecondaryEmailsArg:(DBTEAMAddSecondaryEmailsArg *)anAddSecondaryEmailsArg {
  if (self == anAddSecondaryEmailsArg) {
    return YES;
  }
  if (![self.dNewSecondaryEmails isEqual:anAddSecondaryEmailsArg.dNewSecondaryEmails]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMAddSecondaryEmailsArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMAddSecondaryEmailsArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"new_secondary_emails"] =
      [DBArraySerializer serialize:valueObj.dNewSecondaryEmails
                         withBlock:^id(id elem0) {
                           return [DBTEAMUserSecondaryEmailsArgSerializer serialize:elem0];
                         }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMAddSecondaryEmailsArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBTEAMUserSecondaryEmailsArg *> *dNewSecondaryEmails =
      [DBArraySerializer deserialize:valueDict[@"new_secondary_emails"]
                           withBlock:^id(id elem0) {
                             return [DBTEAMUserSecondaryEmailsArgSerializer deserialize:elem0];
                           }];

  return [[DBTEAMAddSecondaryEmailsArg alloc] initWithDNewSecondaryEmails:dNewSecondaryEmails];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMAddSecondaryEmailsError.h"

#pragma mark - API Object

@implementation DBTEAMAddSecondaryEmailsError

#pragma mark - Constructors

- (instancetype)initWithSecondaryEmailsDisabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMAddSecondaryEmailsErrorSecondaryEmailsDisabled;
  }
  return self;
}

- (instancetype)initWithTooManyEmails {
  self = [super init];
  if (self) {
    _tag = DBTEAMAddSecondaryEmailsErrorTooManyEmails;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMAddSecondaryEmailsErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isSecondaryEmailsDisabled {
  return _tag == DBTEAMAddSecondaryEmailsErrorSecondaryEmailsDisabled;
}

- (BOOL)isTooManyEmails {
  return _tag == DBTEAMAddSecondaryEmailsErrorTooManyEmails;
}

- (BOOL)isOther {
  return _tag == DBTEAMAddSecondaryEmailsErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMAddSecondaryEmailsErrorSecondaryEmailsDisabled:
    return @"DBTEAMAddSecondaryEmailsErrorSecondaryEmailsDisabled";
  case DBTEAMAddSecondaryEmailsErrorTooManyEmails:
    return @"DBTEAMAddSecondaryEmailsErrorTooManyEmails";
  case DBTEAMAddSecondaryEmailsErrorOther:
    return @"DBTEAMAddSecondaryEmailsErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMAddSecondaryEmailsErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMAddSecondaryEmailsErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMAddSecondaryEmailsErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMAddSecondaryEmailsErrorSecondaryEmailsDisabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMAddSecondaryEmailsErrorTooManyEmails:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMAddSecondaryEmailsErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAddSecondaryEmailsError:other];
}

- (BOOL)isEqualToAddSecondaryEmailsError:(DBTEAMAddSecondaryEmailsError *)anAddSecondaryEmailsError {
  if (self == anAddSecondaryEmailsError) {
    return YES;
  }
  if (self.tag != anAddSecondaryEmailsError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMAddSecondaryEmailsErrorSecondaryEmailsDisabled:
    return [[self tagName] isEqual:[anAddSecondaryEmailsError tagName]];
  case DBTEAMAddSecondaryEmailsErrorTooManyEmails:
    return [[self tagName] isEqual:[anAddSecondaryEmailsError tagName]];
  case DBTEAMAddSecondaryEmailsErrorOther:
    return [[self tagName] isEqual:[anAddSecondaryEmailsError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMAddSecondaryEmailsErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMAddSecondaryEmailsError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isSecondaryEmailsDisabled]) {
    jsonDict[@".tag"] = @"secondary_emails_disabled";
  } else if ([valueObj isTooManyEmails]) {
    jsonDict[@".tag"] = @"too_many_emails";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMAddSecondaryEmailsError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"secondary_emails_disabled"]) {
    return [[DBTEAMAddSecondaryEmailsError alloc] initWithSecondaryEmailsDisabled];
  } else if ([tag isEqualToString:@"too_many_emails"]) {
    return [[DBTEAMAddSecondaryEmailsError alloc] initWithTooManyEmails];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMAddSecondaryEmailsError alloc] initWithOther];
  } else {
    return [[DBTEAMAddSecondaryEmailsError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMAddSecondaryEmailsResult.h"
#import "DBTEAMUserAddResult.h"

#pragma mark - API Object

@implementation DBTEAMAddSecondaryEmailsResult

#pragma mark - Constructors

- (instancetype)initWithResults:(NSArray<DBTEAMUserAddResult *> *)results {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](results);

  self = [super init];
  if (self) {
    _results = results;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMAddSecondaryEmailsResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMAddSecondaryEmailsResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMAddSecondaryEmailsResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.results hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAddSecondaryEmailsResult:other];
}

- (BOOL)isEqualToAddSecondaryEmailsResult:(DBTEAMAddSecondaryEmailsResult *)anAddSecondaryEmailsResult {
  if (self == anAddSecondaryEmailsResult) {
    return YES;
  }
  if (![self.results isEqual:anAddSecondaryEmailsResult.results]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMAddSecondaryEmailsResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMAddSecondaryEmailsResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"results"] = [DBArraySerializer serialize:valueObj.results
                                            withBlock:^id(id elem0) {
                                              return [DBTEAMUserAddResultSerializer serialize:elem0];
                                            }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMAddSecondaryEmailsResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBTEAMUserAddResult *> *results =
      [DBArraySerializer deserialize:valueDict[@"results"]
                           withBlock:^id(id elem0) {
                             return [DBTEAMUserAddResultSerializer deserialize:elem0];
                           }];

  return [[DBTEAMAddSecondaryEmailsResult alloc] initWithResults:results];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMAdminTier.h"

#pragma mark - API Object

@implementation DBTEAMAdminTier

#pragma mark - Constructors

- (instancetype)initWithTeamAdmin {
  self = [super init];
  if (self) {
    _tag = DBTEAMAdminTierTeamAdmin;
  }
  return self;
}

- (instancetype)initWithUserManagementAdmin {
  self = [super init];
  if (self) {
    _tag = DBTEAMAdminTierUserManagementAdmin;
  }
  return self;
}

- (instancetype)initWithSupportAdmin {
  self = [super init];
  if (self) {
    _tag = DBTEAMAdminTierSupportAdmin;
  }
  return self;
}

- (instancetype)initWithMemberOnly {
  self = [super init];
  if (self) {
    _tag = DBTEAMAdminTierMemberOnly;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isTeamAdmin {
  return _tag == DBTEAMAdminTierTeamAdmin;
}

- (BOOL)isUserManagementAdmin {
  return _tag == DBTEAMAdminTierUserManagementAdmin;
}

- (BOOL)isSupportAdmin {
  return _tag == DBTEAMAdminTierSupportAdmin;
}

- (BOOL)isMemberOnly {
  return _tag == DBTEAMAdminTierMemberOnly;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMAdminTierTeamAdmin:
    return @"DBTEAMAdminTierTeamAdmin";
  case DBTEAMAdminTierUserManagementAdmin:
    return @"DBTEAMAdminTierUserManagementAdmin";
  case DBTEAMAdminTierSupportAdmin:
    return @"DBTEAMAdminTierSupportAdmin";
  case DBTEAMAdminTierMemberOnly:
    return @"DBTEAMAdminTierMemberOnly";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMAdminTierSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMAdminTierSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMAdminTierSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMAdminTierTeamAdmin:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMAdminTierUserManagementAdmin:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMAdminTierSupportAdmin:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMAdminTierMemberOnly:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAdminTier:other];
}

- (BOOL)isEqualToAdminTier:(DBTEAMAdminTier *)anAdminTier {
  if (self == anAdminTier) {
    return YES;
  }
  if (self.tag != anAdminTier.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMAdminTierTeamAdmin:
    return [[self tagName] isEqual:[anAdminTier tagName]];
  case DBTEAMAdminTierUserManagementAdmin:
    return [[self tagName] isEqual:[anAdminTier tagName]];
  case DBTEAMAdminTierSupportAdmin:
    return [[self tagName] isEqual:[anAdminTier tagName]];
  case DBTEAMAdminTierMemberOnly:
    return [[self tagName] isEqual:[anAdminTier tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMAdminTierSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMAdminTier *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isTeamAdmin]) {
    jsonDict[@".tag"] = @"team_admin";
  } else if ([valueObj isUserManagementAdmin]) {
    jsonDict[@".tag"] = @"user_management_admin";
  } else if ([valueObj isSupportAdmin]) {
    jsonDict[@".tag"] = @"support_admin";
  } else if ([valueObj isMemberOnly]) {
    jsonDict[@".tag"] = @"member_only";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMAdminTier *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"team_admin"]) {
    return [[DBTEAMAdminTier alloc] initWithTeamAdmin];
  } else if ([tag isEqualToString:@"user_management_admin"]) {
    return [[DBTEAMAdminTier alloc] initWithUserManagementAdmin];
  } else if ([tag isEqualToString:@"support_admin"]) {
    return [[DBTEAMAdminTier alloc] initWithSupportAdmin];
  } else if ([tag isEqualToString:@"member_only"]) {
    return [[DBTEAMAdminTier alloc] initWithMemberOnly];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMApiApp.h"

#pragma mark - API Object

@implementation DBTEAMApiApp

#pragma mark - Constructors

- (instancetype)initWithAppId:(NSString *)appId
                      appName:(NSString *)appName
                  isAppFolder:(NSNumber *)isAppFolder
                    publisher:(NSString *)publisher
                 publisherUrl:(NSString *)publisherUrl
                       linked:(NSDate *)linked {
  [DBStoneValidators nonnullValidator:nil](appId);
  [DBStoneValidators nonnullValidator:nil](appName);
  [DBStoneValidators nonnullValidator:nil](isAppFolder);

  self = [super init];
  if (self) {
    _appId = appId;
    _appName = appName;
    _publisher = publisher;
    _publisherUrl = publisherUrl;
    _linked = linked;
    _isAppFolder = isAppFolder;
  }
  return self;
}

- (instancetype)initWithAppId:(NSString *)appId appName:(NSString *)appName isAppFolder:(NSNumber *)isAppFolder {
  return [self initWithAppId:appId appName:appName isAppFolder:isAppFolder publisher:nil publisherUrl:nil linked:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMApiAppSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMApiAppSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMApiAppSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.appId hash];
  result = prime * result + [self.appName hash];
  result = prime * result + [self.isAppFolder hash];
  if (self.publisher != nil) {
    result = prime * result + [self.publisher hash];
  }
  if (self.publisherUrl != nil) {
    result = prime * result + [self.publisherUrl hash];
  }
  if (self.linked != nil) {
    result = prime * result + [self.linked hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToApiApp:other];
}

- (BOOL)isEqualToApiApp:(DBTEAMApiApp *)anApiApp {
  if (self == anApiApp) {
    return YES;
  }
  if (![self.appId isEqual:anApiApp.appId]) {
    return NO;
  }
  if (![self.appName isEqual:anApiApp.appName]) {
    return NO;
  }
  if (![self.isAppFolder isEqual:anApiApp.isAppFolder]) {
    return NO;
  }
  if (self.publisher) {
    if (![self.publisher isEqual:anApiApp.publisher]) {
      return NO;
    }
  }
  if (self.publisherUrl) {
    if (![self.publisherUrl isEqual:anApiApp.publisherUrl]) {
      return NO;
    }
  }
  if (self.linked) {
    if (![self.linked isEqual:anApiApp.linked]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMApiAppSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMApiApp *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"app_id"] = valueObj.appId;
  jsonDict[@"app_name"] = valueObj.appName;
  jsonDict[@"is_app_folder"] = valueObj.isAppFolder;
  if (valueObj.publisher) {
    jsonDict[@"publisher"] = valueObj.publisher;
  }
  if (valueObj.publisherUrl) {
    jsonDict[@"publisher_url"] = valueObj.publisherUrl;
  }
  if (valueObj.linked) {
    jsonDict[@"linked"] = [DBNSDateSerializer serialize:valueObj.linked dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMApiApp *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *appId = valueDict[@"app_id"];
  NSString *appName = valueDict[@"app_name"];
  NSNumber *isAppFolder = valueDict[@"is_app_folder"];
  NSString *publisher = valueDict[@"publisher"] ?: nil;
  NSString *publisherUrl = valueDict[@"publisher_url"] ?: nil;
  NSDate *linked = valueDict[@"linked"]
                       ? [DBNSDateSerializer deserialize:valueDict[@"linked"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                       : nil;

  return [[DBTEAMApiApp alloc] initWithAppId:appId
                                     appName:appName
                                 isAppFolder:isAppFolder
                                   publisher:publisher
                                publisherUrl:publisherUrl
                                      linked:linked];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMBaseDfbReport.h"

#pragma mark - API Object

@implementation DBTEAMBaseDfbReport

#pragma mark - Constructors

- (instancetype)initWithStartDate:(NSString *)startDate {
  [DBStoneValidators nonnullValidator:nil](startDate);

  self = [super init];
  if (self) {
    _startDate = startDate;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMBaseDfbReportSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMBaseDfbReportSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMBaseDfbReportSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.startDate hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToBaseDfbReport:other];
}

- (BOOL)isEqualToBaseDfbReport:(DBTEAMBaseDfbReport *)aBaseDfbReport {
  if (self == aBaseDfbReport) {
    return YES;
  }
  if (![self.startDate isEqual:aBaseDfbReport.startDate]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMBaseDfbReportSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMBaseDfbReport *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"start_date"] = valueObj.startDate;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMBaseDfbReport *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *startDate = valueDict[@"start_date"];

  return [[DBTEAMBaseDfbReport alloc] initWithStartDate:startDate];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMBaseTeamFolderError.h"
#import "DBTEAMTeamFolderAccessError.h"
#import "DBTEAMTeamFolderInvalidStatusError.h"
#import "DBTEAMTeamFolderTeamSharedDropboxError.h"

#pragma mark - API Object

@implementation DBTEAMBaseTeamFolderError

@synthesize accessError = _accessError;
@synthesize statusError = _statusError;
@synthesize teamSharedDropboxError = _teamSharedDropboxError;

#pragma mark - Constructors

- (instancetype)initWithAccessError:(DBTEAMTeamFolderAccessError *)accessError {
  self = [super init];
  if (self) {
    _tag = DBTEAMBaseTeamFolderErrorAccessError;
    _accessError = accessError;
  }
  return self;
}

- (instancetype)initWithStatusError:(DBTEAMTeamFolderInvalidStatusError *)statusError {
  self = [super init];
  if (self) {
    _tag = DBTEAMBaseTeamFolderErrorStatusError;
    _statusError = statusError;
  }
  return self;
}

- (instancetype)initWithTeamSharedDropboxError:(DBTEAMTeamFolderTeamSharedDropboxError *)teamSharedDropboxError {
  self = [super init];
  if (self) {
    _tag = DBTEAMBaseTeamFolderErrorTeamSharedDropboxError;
    _teamSharedDropboxError = teamSharedDropboxError;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMBaseTeamFolderErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBTEAMTeamFolderAccessError *)accessError {
  if (![self isAccessError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMBaseTeamFolderErrorAccessError, but was %@.", [self tagName]];
  }
  return _accessError;
}

- (DBTEAMTeamFolderInvalidStatusError *)statusError {
  if (![self isStatusError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMBaseTeamFolderErrorStatusError, but was %@.", [self tagName]];
  }
  return _statusError;
}

- (DBTEAMTeamFolderTeamSharedDropboxError *)teamSharedDropboxError {
  if (![self isTeamSharedDropboxError]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMBaseTeamFolderErrorTeamSharedDropboxError, but was %@.", [self tagName]];
  }
  return _teamSharedDropboxError;
}

#pragma mark - Tag state methods

- (BOOL)isAccessError {
  return _tag == DBTEAMBaseTeamFolderErrorAccessError;
}

- (BOOL)isStatusError {
  return _tag == DBTEAMBaseTeamFolderErrorStatusError;
}

- (BOOL)isTeamSharedDropboxError {
  return _tag == DBTEAMBaseTeamFolderErrorTeamSharedDropboxError;
}

- (BOOL)isOther {
  return _tag == DBTEAMBaseTeamFolderErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMBaseTeamFolderErrorAccessError:
    return @"DBTEAMBaseTeamFolderErrorAccessError";
  case DBTEAMBaseTeamFolderErrorStatusError:
    return @"DBTEAMBaseTeamFolderErrorStatusError";
  case DBTEAMBaseTeamFolderErrorTeamSharedDropboxError:
    return @"DBTEAMBaseTeamFolderErrorTeamSharedDropboxError";
  case DBTEAMBaseTeamFolderErrorOther:
    return @"DBTEAMBaseTeamFolderErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMBaseTeamFolderErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMBaseTeamFolderErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMBaseTeamFolderErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMBaseTeamFolderErrorAccessError:
    result = prime * result + [self.accessError hash];
    break;
  case DBTEAMBaseTeamFolderErrorStatusError:
    result = prime * result + [self.statusError hash];
    break;
  case DBTEAMBaseTeamFolderErrorTeamSharedDropboxError:
    result = prime * result + [self.teamSharedDropboxError hash];
    break;
  case DBTEAMBaseTeamFolderErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToBaseTeamFolderError:other];
}

- (BOOL)isEqualToBaseTeamFolderError:(DBTEAMBaseTeamFolderError *)aBaseTeamFolderError {
  if (self == aBaseTeamFolderError) {
    return YES;
  }
  if (self.tag != aBaseTeamFolderError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMBaseTeamFolderErrorAccessError:
    return [self.accessError isEqual:aBaseTeamFolderError.accessError];
  case DBTEAMBaseTeamFolderErrorStatusError:
    return [self.statusError isEqual:aBaseTeamFolderError.statusError];
  case DBTEAMBaseTeamFolderErrorTeamSharedDropboxError:
    return [self.teamSharedDropboxError isEqual:aBaseTeamFolderError.teamSharedDropboxError];
  case DBTEAMBaseTeamFolderErrorOther:
    return [[self tagName] isEqual:[aBaseTeamFolderError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMBaseTeamFolderErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMBaseTeamFolderError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAccessError]) {
    jsonDict[@"access_error"] = [[DBTEAMTeamFolderAccessErrorSerializer serialize:valueObj.accessError] mutableCopy];
    jsonDict[@".tag"] = @"access_error";
  } else if ([valueObj isStatusError]) {
    jsonDict[@"status_error"] =
        [[DBTEAMTeamFolderInvalidStatusErrorSerializer serialize:valueObj.statusError] mutableCopy];
    jsonDict[@".tag"] = @"status_error";
  } else if ([valueObj isTeamSharedDropboxError]) {
    jsonDict[@"team_shared_dropbox_error"] =
        [[DBTEAMTeamFolderTeamSharedDropboxErrorSerializer serialize:valueObj.teamSharedDropboxError] mutableCopy];
    jsonDict[@".tag"] = @"team_shared_dropbox_error";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMBaseTeamFolderError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"access_error"]) {
    DBTEAMTeamFolderAccessError *accessError =
        [DBTEAMTeamFolderAccessErrorSerializer deserialize:valueDict[@"access_error"]];
    return [[DBTEAMBaseTeamFolderError alloc] initWithAccessError:accessError];
  } else if ([tag isEqualToString:@"status_error"]) {
    DBTEAMTeamFolderInvalidStatusError *statusError =
        [DBTEAMTeamFolderInvalidStatusErrorSerializer deserialize:valueDict[@"status_error"]];
    return [[DBTEAMBaseTeamFolderError alloc] initWithStatusError:statusError];
  } else if ([tag isEqualToString:@"team_shared_dropbox_error"]) {
    DBTEAMTeamFolderTeamSharedDropboxError *teamSharedDropboxError =
        [DBTEAMTeamFolderTeamSharedDropboxErrorSerializer deserialize:valueDict[@"team_shared_dropbox_error"]];
    return [[DBTEAMBaseTeamFolderError alloc] initWithTeamSharedDropboxError:teamSharedDropboxError];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMBaseTeamFolderError alloc] initWithOther];
  } else {
    return [[DBTEAMBaseTeamFolderError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMCustomQuotaError.h"

#pragma mark - API Object

@implementation DBTEAMCustomQuotaError

#pragma mark - Constructors

- (instancetype)initWithTooManyUsers {
  self = [super init];
  if (self) {
    _tag = DBTEAMCustomQuotaErrorTooManyUsers;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMCustomQuotaErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isTooManyUsers {
  return _tag == DBTEAMCustomQuotaErrorTooManyUsers;
}

- (BOOL)isOther {
  return _tag == DBTEAMCustomQuotaErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMCustomQuotaErrorTooManyUsers:
    return @"DBTEAMCustomQuotaErrorTooManyUsers";
  case DBTEAMCustomQuotaErrorOther:
    return @"DBTEAMCustomQuotaErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMCustomQuotaErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMCustomQuotaErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMCustomQuotaErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMCustomQuotaErrorTooManyUsers:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMCustomQuotaErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCustomQuotaError:other];
}

- (BOOL)isEqualToCustomQuotaError:(DBTEAMCustomQuotaError *)aCustomQuotaError {
  if (self == aCustomQuotaError) {
    return YES;
  }
  if (self.tag != aCustomQuotaError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMCustomQuotaErrorTooManyUsers:
    return [[self tagName] isEqual:[aCustomQuotaError tagName]];
  case DBTEAMCustomQuotaErrorOther:
    return [[self tagName] isEqual:[aCustomQuotaError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMCustomQuotaErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMCustomQuotaError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isTooManyUsers]) {
    jsonDict[@".tag"] = @"too_many_users";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMCustomQuotaError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"too_many_users"]) {
    return [[DBTEAMCustomQuotaError alloc] initWithTooManyUsers];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMCustomQuotaError alloc] initWithOther];
  } else {
    return [[DBTEAMCustomQuotaError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMCustomQuotaResult.h"
#import "DBTEAMUserCustomQuotaResult.h"
#import "DBTEAMUserSelectorArg.h"

#pragma mark - API Object

@implementation DBTEAMCustomQuotaResult

@synthesize success = _success;
@synthesize invalidUser = _invalidUser;

#pragma mark - Constructors

- (instancetype)initWithSuccess:(DBTEAMUserCustomQuotaResult *)success {
  self = [super init];
  if (self) {
    _tag = DBTEAMCustomQuotaResultSuccess;
    _success = success;
  }
  return self;
}

- (instancetype)initWithInvalidUser:(DBTEAMUserSelectorArg *)invalidUser {
  self = [super init];
  if (self) {
    _tag = DBTEAMCustomQuotaResultInvalidUser;
    _invalidUser = invalidUser;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMCustomQuotaResultOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBTEAMUserCustomQuotaResult *)success {
  if (![self isSuccess]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMCustomQuotaResultSuccess, but was %@.", [self tagName]];
  }
  return _success;
}

- (DBTEAMUserSelectorArg *)invalidUser {
  if (![self isInvalidUser]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMCustomQuotaResultInvalidUser, but was %@.", [self tagName]];
  }
  return _invalidUser;
}

#pragma mark - Tag state methods

- (BOOL)isSuccess {
  return _tag == DBTEAMCustomQuotaResultSuccess;
}

- (BOOL)isInvalidUser {
  return _tag == DBTEAMCustomQuotaResultInvalidUser;
}

- (BOOL)isOther {
  return _tag == DBTEAMCustomQuotaResultOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMCustomQuotaResultSuccess:
    return @"DBTEAMCustomQuotaResultSuccess";
  case DBTEAMCustomQuotaResultInvalidUser:
    return @"DBTEAMCustomQuotaResultInvalidUser";
  case DBTEAMCustomQuotaResultOther:
    return @"DBTEAMCustomQuotaResultOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMCustomQuotaResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMCustomQuotaResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMCustomQuotaResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMCustomQuotaResultSuccess:
    result = prime * result + [self.success hash];
    break;
  case DBTEAMCustomQuotaResultInvalidUser:
    result = prime * result + [self.invalidUser hash];
    break;
  case DBTEAMCustomQuotaResultOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCustomQuotaResult:other];
}

- (BOOL)isEqualToCustomQuotaResult:(DBTEAMCustomQuotaResult *)aCustomQuotaResult {
  if (self == aCustomQuotaResult) {
    return YES;
  }
  if (self.tag != aCustomQuotaResult.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMCustomQuotaResultSuccess:
    return [self.success isEqual:aCustomQuotaResult.success];
  case DBTEAMCustomQuotaResultInvalidUser:
    return [self.invalidUser isEqual:aCustomQuotaResult.invalidUser];
  case DBTEAMCustomQuotaResultOther:
    return [[self tagName] isEqual:[aCustomQuotaResult tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMCustomQuotaResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMCustomQuotaResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isSuccess]) {
    jsonDict = [[DBTEAMUserCustomQuotaResultSerializer serialize:valueObj.success] mutableCopy];
    jsonDict[@".tag"] = @"success";
  } else if ([valueObj isInvalidUser]) {
    jsonDict[@"invalid_user"] = [[DBTEAMUserSelectorArgSerializer serialize:valueObj.invalidUser] mutableCopy];
    jsonDict[@".tag"] = @"invalid_user";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMCustomQuotaResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"success"]) {
    DBTEAMUserCustomQuotaResult *success = [DBTEAMUserCustomQuotaResultSerializer deserialize:valueDict];
    return [[DBTEAMCustomQuotaResult alloc] initWithSuccess:success];
  } else if ([tag isEqualToString:@"invalid_user"]) {
    DBTEAMUserSelectorArg *invalidUser = [DBTEAMUserSelectorArgSerializer deserialize:valueDict[@"invalid_user"]];
    return [[DBTEAMCustomQuotaResult alloc] initWithInvalidUser:invalidUser];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMCustomQuotaResult alloc] initWithOther];
  } else {
    return [[DBTEAMCustomQuotaResult alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMCustomQuotaUsersArg.h"
#import "DBTEAMUserSelectorArg.h"

#pragma mark - API Object

@implementation DBTEAMCustomQuotaUsersArg

#pragma mark - Constructors

- (instancetype)initWithUsers:(NSArray<DBTEAMUserSelectorArg *> *)users {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](users);

  self = [super init];
  if (self) {
    _users = users;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMCustomQuotaUsersArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMCustomQuotaUsersArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMCustomQuotaUsersArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.users hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCustomQuotaUsersArg:other];
}

- (BOOL)isEqualToCustomQuotaUsersArg:(DBTEAMCustomQuotaUsersArg *)aCustomQuotaUsersArg {
  if (self == aCustomQuotaUsersArg) {
    return YES;
  }
  if (![self.users isEqual:aCustomQuotaUsersArg.users]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMCustomQuotaUsersArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMCustomQuotaUsersArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"users"] = [DBArraySerializer serialize:valueObj.users
                                          withBlock:^id(id elem0) {
                                            return [DBTEAMUserSelectorArgSerializer serialize:elem0];
                                          }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMCustomQuotaUsersArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBTEAMUserSelectorArg *> *users =
      [DBArraySerializer deserialize:valueDict[@"users"]
                           withBlock:^id(id elem0) {
                             return [DBTEAMUserSelectorArgSerializer deserialize:elem0];
                           }];

  return [[DBTEAMCustomQuotaUsersArg alloc] initWithUsers:users];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMDateRange.h"

#pragma mark - API Object

@implementation DBTEAMDateRange

#pragma mark - Constructors

- (instancetype)initWithStartDate:(NSDate *)startDate endDate:(NSDate *)endDate {

  self = [super init];
  if (self) {
    _startDate = startDate;
    _endDate = endDate;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithStartDate:nil endDate:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMDateRangeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMDateRangeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMDateRangeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.startDate != nil) {
    result = prime * result + [self.startDate hash];
  }
  if (self.endDate != nil) {
    result = prime * result + [self.endDate hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDateRange:other];
}

- (BOOL)isEqualToDateRange:(DBTEAMDateRange *)aDateRange {
  if (self == aDateRange) {
    return YES;
  }
  if (self.startDate) {
    if (![self.startDate isEqual:aDateRange.startDate]) {
      return NO;
    }
  }
  if (self.endDate) {
    if (![self.endDate isEqual:aDateRange.endDate]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMDateRangeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMDateRange *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.startDate) {
    jsonDict[@"start_date"] = [DBNSDateSerializer serialize:valueObj.startDate dateFormat:@"%Y-%m-%d"];
  }
  if (valueObj.endDate) {
    jsonDict[@"end_date"] = [DBNSDateSerializer serialize:valueObj.endDate dateFormat:@"%Y-%m-%d"];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMDateRange *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSDate *startDate =
      valueDict[@"start_date"] ? [DBNSDateSerializer deserialize:valueDict[@"start_date"] dateFormat:@"%Y-%m-%d"] : nil;
  NSDate *endDate =
      valueDict[@"end_date"] ? [DBNSDateSerializer deserialize:valueDict[@"end_date"] dateFormat:@"%Y-%m-%d"] : nil;

  return [[DBTEAMDateRange alloc] initWithStartDate:startDate endDate:endDate];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMDateRangeError.h"

#pragma mark - API Object

@implementation DBTEAMDateRangeError

#pragma mark - Constructors

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMDateRangeErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isOther {
  return _tag == DBTEAMDateRangeErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMDateRangeErrorOther:
    return @"DBTEAMDateRangeErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMDateRangeErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMDateRangeErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMDateRangeErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMDateRangeErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDateRangeError:other];
}

- (BOOL)isEqualToDateRangeError:(DBTEAMDateRangeError *)aDateRangeError {
  if (self == aDateRangeError) {
    return YES;
  }
  if (self.tag != aDateRangeError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMDateRangeErrorOther:
    return [[self tagName] isEqual:[aDateRangeError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMDateRangeErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMDateRangeError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMDateRangeError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMDateRangeError alloc] initWithOther];
  } else {
    return [[DBTEAMDateRangeError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMDeleteSecondaryEmailResult.h"

#pragma mark - API Object

@implementation DBTEAMDeleteSecondaryEmailResult

@synthesize success = _success;
@synthesize notFound = _notFound;
@synthesize cannotRemovePrimary = _cannotRemovePrimary;

#pragma mark - Constructors

- (instancetype)initWithSuccess:(NSString *)success {
  self = [super init];
  if (self) {
    _tag = DBTEAMDeleteSecondaryEmailResultSuccess;
    _success = success;
  }
  return self;
}

- (instancetype)initWithNotFound:(NSString *)notFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMDeleteSecondaryEmailResultNotFound;
    _notFound = notFound;
  }
  return self;
}

- (instancetype)initWithCannotRemovePrimary:(NSString *)cannotRemovePrimary {
  self = [super init];
  if (self) {
    _tag = DBTEAMDeleteSecondaryEmailResultCannotRemovePrimary;
    _cannotRemovePrimary = cannotRemovePrimary;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMDeleteSecondaryEmailResultOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSString *)success {
  if (![self isSuccess]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMDeleteSecondaryEmailResultSuccess, but was %@.", [self tagName]];
  }
  return _success;
}

- (NSString *)notFound {
  if (![self isNotFound]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMDeleteSecondaryEmailResultNotFound, but was %@.", [self tagName]];
  }
  return _notFound;
}

- (NSString *)cannotRemovePrimary {
  if (![self isCannotRemovePrimary]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMDeleteSecondaryEmailResultCannotRemovePrimary, but was %@.",
                       [self tagName]];
  }
  return _cannotRemovePrimary;
}

#pragma mark - Tag state methods

- (BOOL)isSuccess {
  return _tag == DBTEAMDeleteSecondaryEmailResultSuccess;
}

- (BOOL)isNotFound {
  return _tag == DBTEAMDeleteSecondaryEmailResultNotFound;
}

- (BOOL)isCannotRemovePrimary {
  return _tag == DBTEAMDeleteSecondaryEmailResultCannotRemovePrimary;
}

- (BOOL)isOther {
  return _tag == DBTEAMDeleteSecondaryEmailResultOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMDeleteSecondaryEmailResultSuccess:
    return @"DBTEAMDeleteSecondaryEmailResultSuccess";
  case DBTEAMDeleteSecondaryEmailResultNotFound:
    return @"DBTEAMDeleteSecondaryEmailResultNotFound";
  case DBTEAMDeleteSecondaryEmailResultCannotRemovePrimary:
    return @"DBTEAMDeleteSecondaryEmailResultCannotRemovePrimary";
  case DBTEAMDeleteSecondaryEmailResultOther:
    return @"DBTEAMDeleteSecondaryEmailResultOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMDeleteSecondaryEmailResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMDeleteSecondaryEmailResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMDeleteSecondaryEmailResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMDeleteSecondaryEmailResultSuccess:
    result = prime * result + [self.success hash];
    break;
  case DBTEAMDeleteSecondaryEmailResultNotFound:
    result = prime * result + [self.notFound hash];
    break;
  case DBTEAMDeleteSecondaryEmailResultCannotRemovePrimary:
    result = prime * result + [self.cannotRemovePrimary hash];
    break;
  case DBTEAMDeleteSecondaryEmailResultOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeleteSecondaryEmailResult:other];
}

- (BOOL)isEqualToDeleteSecondaryEmailResult:(DBTEAMDeleteSecondaryEmailResult *)aDeleteSecondaryEmailResult {
  if (self == aDeleteSecondaryEmailResult) {
    return YES;
  }
  if (self.tag != aDeleteSecondaryEmailResult.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMDeleteSecondaryEmailResultSuccess:
    return [self.success isEqual:aDeleteSecondaryEmailResult.success];
  case DBTEAMDeleteSecondaryEmailResultNotFound:
    return [self.notFound isEqual:aDeleteSecondaryEmailResult.notFound];
  case DBTEAMDeleteSecondaryEmailResultCannotRemovePrimary:
    return [self.cannotRemovePrimary isEqual:aDeleteSecondaryEmailResult.cannotRemovePrimary];
  case DBTEAMDeleteSecondaryEmailResultOther:
    return [[self tagName] isEqual:[aDeleteSecondaryEmailResult tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMDeleteSecondaryEmailResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMDeleteSecondaryEmailResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isSuccess]) {
    jsonDict[@"success"] = valueObj.success;
    jsonDict[@".tag"] = @"success";
  } else if ([valueObj isNotFound]) {
    jsonDict[@"not_found"] = valueObj.notFound;
    jsonDict[@".tag"] = @"not_found";
  } else if ([valueObj isCannotRemovePrimary]) {
    jsonDict[@"cannot_remove_primary"] = valueObj.cannotRemovePrimary;
    jsonDict[@".tag"] = @"cannot_remove_primary";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMDeleteSecondaryEmailResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"success"]) {
    NSString *success = valueDict[@"success"];
    return [[DBTEAMDeleteSecondaryEmailResult alloc] initWithSuccess:success];
  } else if ([tag isEqualToString:@"not_found"]) {
    NSString *notFound = valueDict[@"not_found"];
    return [[DBTEAMDeleteSecondaryEmailResult alloc] initWithNotFound:notFound];
  } else if ([tag isEqualToString:@"cannot_remove_primary"]) {
    NSString *cannotRemovePrimary = valueDict[@"cannot_remove_primary"];
    return [[DBTEAMDeleteSecondaryEmailResult alloc] initWithCannotRemovePrimary:cannotRemovePrimary];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMDeleteSecondaryEmailResult alloc] initWithOther];
  } else {
    return [[DBTEAMDeleteSecondaryEmailResult alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMDeleteSecondaryEmailsArg.h"
#import "DBTEAMUserSecondaryEmailsArg.h"

#pragma mark - API Object

@implementation DBTEAMDeleteSecondaryEmailsArg

#pragma mark - Constructors

- (instancetype)initWithEmailsToDelete:(NSArray<DBTEAMUserSecondaryEmailsArg *> *)emailsToDelete {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](emailsToDelete);

  self = [super init];
  if (self) {
    _emailsToDelete = emailsToDelete;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMDeleteSecondaryEmailsArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMDeleteSecondaryEmailsArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMDeleteSecondaryEmailsArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.emailsToDelete hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeleteSecondaryEmailsArg:other];
}

- (BOOL)isEqualToDeleteSecondaryEmailsArg:(DBTEAMDeleteSecondaryEmailsArg *)aDeleteSecondaryEmailsArg {
  if (self == aDeleteSecondaryEmailsArg) {
    return YES;
  }
  if (![self.emailsToDelete isEqual:aDeleteSecondaryEmailsArg.emailsToDelete]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMDeleteSecondaryEmailsArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMDeleteSecondaryEmailsArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"emails_to_delete"] = [DBArraySerializer serialize:valueObj.emailsToDelete
                                                     withBlock:^id(id elem0) {
                                                       return [DBTEAMUserSecondaryEmailsArgSerializer serialize:elem0];
                                                     }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMDeleteSecondaryEmailsArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBTEAMUserSecondaryEmailsArg *> *emailsToDelete =
      [DBArraySerializer deserialize:valueDict[@"emails_to_delete"]
                           withBlock:^id(id elem0) {
                             return [DBTEAMUserSecondaryEmailsArgSerializer deserialize:elem0];
                           }];

  return [[DBTEAMDeleteSecondaryEmailsArg alloc] initWithEmailsToDelete:emailsToDelete];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMDeleteSecondaryEmailsResult.h"
#import "DBTEAMUserDeleteResult.h"

#pragma mark - API Object

@implementation DBTEAMDeleteSecondaryEmailsResult

#pragma mark - Constructors

- (instancetype)initWithResults:(NSArray<DBTEAMUserDeleteResult *> *)results {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](results);

  self = [super init];
  if (self) {
    _results = results;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMDeleteSecondaryEmailsResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMDeleteSecondaryEmailsResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMDeleteSecondaryEmailsResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.results hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeleteSecondaryEmailsResult:other];
}

- (BOOL)isEqualToDeleteSecondaryEmailsResult:(DBTEAMDeleteSecondaryEmailsResult *)aDeleteSecondaryEmailsResult {
  if (self == aDeleteSecondaryEmailsResult) {
    return YES;
  }
  if (![self.results isEqual:aDeleteSecondaryEmailsResult.results]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMDeleteSecondaryEmailsResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMDeleteSecondaryEmailsResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"results"] = [DBArraySerializer serialize:valueObj.results
                                            withBlock:^id(id elem0) {
                                              return [DBTEAMUserDeleteResultSerializer serialize:elem0];
                                            }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMDeleteSecondaryEmailsResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBTEAMUserDeleteResult *> *results =
      [DBArraySerializer deserialize:valueDict[@"results"]
                           withBlock:^id(id elem0) {
                             return [DBTEAMUserDeleteResultSerializer deserialize:elem0];
                           }];

  return [[DBTEAMDeleteSecondaryEmailsResult alloc] initWithResults:results];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMDesktopClientSession.h"
#import "DBTEAMDesktopPlatform.h"
#import "DBTEAMDeviceSession.h"

#pragma mark - API Object

@implementation DBTEAMDesktopClientSession

#pragma mark - Constructors

- (instancetype)initWithSessionId:(NSString *)sessionId
                         hostName:(NSString *)hostName
                       clientType:(DBTEAMDesktopPlatform *)clientType
                    clientVersion:(NSString *)clientVersion
                         platform:(NSString *)platform
        isDeleteOnUnlinkSupported:(NSNumber *)isDeleteOnUnlinkSupported
                        ipAddress:(NSString *)ipAddress
                          country:(NSString *)country
                          created:(NSDate *)created
                          updated:(NSDate *)updated {
  [DBStoneValidators nonnullValidator:nil](sessionId);
  [DBStoneValidators nonnullValidator:nil](hostName);
  [DBStoneValidators nonnullValidator:nil](clientType);
  [DBStoneValidators nonnullValidator:nil](clientVersion);
  [DBStoneValidators nonnullValidator:nil](platform);
  [DBStoneValidators nonnullValidator:nil](isDeleteOnUnlinkSupported);

  self = [super initWithSessionId:sessionId ipAddress:ipAddress country:country created:created updated:updated];
  if (self) {
    _hostName = hostName;
    _clientType = clientType;
    _clientVersion = clientVersion;
    _platform = platform;
    _isDeleteOnUnlinkSupported = isDeleteOnUnlinkSupported;
  }
  return self;
}

- (instancetype)initWithSessionId:(NSString *)sessionId
                         hostName:(NSString *)hostName
                       clientType:(DBTEAMDesktopPlatform *)clientType
                    clientVersion:(NSString *)clientVersion
                         platform:(NSString *)platform
        isDeleteOnUnlinkSupported:(NSNumber *)isDeleteOnUnlinkSupported {
  return [self initWithSessionId:sessionId
                        hostName:hostName
                      clientType:clientType
                   clientVersion:clientVersion
                        platform:platform
       isDeleteOnUnlinkSupported:isDeleteOnUnlinkSupported
                       ipAddress:nil
                         country:nil
                         created:nil
                         updated:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMDesktopClientSessionSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMDesktopClientSessionSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMDesktopClientSessionSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.sessionId hash];
  result = prime * result + [self.hostName hash];
  result = prime * result + [self.clientType hash];
  result = prime * result + [self.clientVersion hash];
  result = prime * result + [self.platform hash];
  result = prime * result + [self.isDeleteOnUnlinkSupported hash];
  if (self.ipAddress != nil) {
    result = prime * result + [self.ipAddress hash];
  }
  if (self.country != nil) {
    result = prime * result + [self.country hash];
  }
  if (self.created != nil) {
    result = prime * result + [self.created hash];
  }
  if (self.updated != nil) {
    result = prime * result + [self.updated hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDesktopClientSession:other];
}

- (BOOL)isEqualToDesktopClientSession:(DBTEAMDesktopClientSession *)aDesktopClientSession {
  if (self == aDesktopClientSession) {
    return YES;
  }
  if (![self.sessionId isEqual:aDesktopClientSession.sessionId]) {
    return NO;
  }
  if (![self.hostName isEqual:aDesktopClientSession.hostName]) {
    return NO;
  }
  if (![self.clientType isEqual:aDesktopClientSession.clientType]) {
    return NO;
  }
  if (![self.clientVersion isEqual:aDesktopClientSession.clientVersion]) {
    return NO;
  }
  if (![self.platform isEqual:aDesktopClientSession.platform]) {
    return NO;
  }
  if (![self.isDeleteOnUnlinkSupported isEqual:aDesktopClientSession.isDeleteOnUnlinkSupported]) {
    return NO;
  }
  if (self.ipAddress) {
    if (![self.ipAddress isEqual:aDesktopClientSession.ipAddress]) {
      return NO;
    }
  }
  if (self.country) {
    if (![self.country isEqual:aDesktopClientSession.country]) {
      return NO;
    }
  }
  if (self.created) {
    if (![self.created isEqual:aDesktopClientSession.created]) {
      return NO;
    }
  }
  if (self.updated) {
    if (![self.updated isEqual:aDesktopClientSession.updated]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMDesktopClientSessionSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMDesktopClientSession *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"session_id"] = valueObj.sessionId;
  jsonDict[@"host_name"] = valueObj.hostName;
  jsonDict[@"client_type"] = [DBTEAMDesktopPlatformSerializer serialize:valueObj.clientType];
  jsonDict[@"client_version"] = valueObj.clientVersion;
  jsonDict[@"platform"] = valueObj.platform;
  jsonDict[@"is_delete_on_unlink_supported"] = valueObj.isDeleteOnUnlinkSupported;
  if (valueObj.ipAddress) {
    jsonDict[@"ip_address"] = valueObj.ipAddress;
  }
  if (valueObj.country) {
    jsonDict[@"country"] = valueObj.country;
  }
  if (valueObj.created) {
    jsonDict[@"created"] = [DBNSDateSerializer serialize:valueObj.created dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }
  if (valueObj.updated) {
    jsonDict[@"updated"] = [DBNSDateSerializer serialize:valueObj.updated dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMDesktopClientSession *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *sessionId = valueDict[@"session_id"];
  NSString *hostName = valueDict[@"host_name"];
  DBTEAMDesktopPlatform *clientType = [DBTEAMDesktopPlatformSerializer deserialize:valueDict[@"client_type"]];
  NSString *clientVersion = valueDict[@"client_version"];
  NSString *platform = valueDict[@"platform"];
  NSNumber *isDeleteOnUnlinkSupported = valueDict[@"is_delete_on_unlink_supported"];
  NSString *ipAddress = valueDict[@"ip_address"] ?: nil;
  NSString *country = valueDict[@"country"] ?: nil;
  NSDate *created = valueDict[@"created"]
                        ? [DBNSDateSerializer deserialize:valueDict[@"created"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                        : nil;
  NSDate *updated = valueDict[@"updated"]
                        ? [DBNSDateSerializer deserialize:valueDict[@"updated"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                        : nil;

  return [[DBTEAMDesktopClientSession alloc] initWithSessionId:sessionId
                                                      hostName:hostName
                                                    clientType:clientType
                                                 clientVersion:clientVersion
                                                      platform:platform
                                     isDeleteOnUnlinkSupported:isDeleteOnUnlinkSupported
                                                     ipAddress:ipAddress
                                                       country:country
                                                       created:created
                                                       updated:updated];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMDesktopPlatform.h"

#pragma mark - API Object

@implementation DBTEAMDesktopPlatform

#pragma mark - Constructors

- (instancetype)initWithWindows {
  self = [super init];
  if (self) {
    _tag = DBTEAMDesktopPlatformWindows;
  }
  return self;
}

- (instancetype)initWithMac {
  self = [super init];
  if (self) {
    _tag = DBTEAMDesktopPlatformMac;
  }
  return self;
}

- (instancetype)initWithLinux {
  self = [super init];
  if (self) {
    _tag = DBTEAMDesktopPlatformLinux;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMDesktopPlatformOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isWindows {
  return _tag == DBTEAMDesktopPlatformWindows;
}

- (BOOL)isMac {
  return _tag == DBTEAMDesktopPlatformMac;
}

- (BOOL)isLinux {
  return _tag == DBTEAMDesktopPlatformLinux;
}

- (BOOL)isOther {
  return _tag == DBTEAMDesktopPlatformOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMDesktopPlatformWindows:
    return @"DBTEAMDesktopPlatformWindows";
  case DBTEAMDesktopPlatformMac:
    return @"DBTEAMDesktopPlatformMac";
  case DBTEAMDesktopPlatformLinux:
    return @"DBTEAMDesktopPlatformLinux";
  case DBTEAMDesktopPlatformOther:
    return @"DBTEAMDesktopPlatformOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMDesktopPlatformSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMDesktopPlatformSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMDesktopPlatformSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMDesktopPlatformWindows:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMDesktopPlatformMac:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMDesktopPlatformLinux:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMDesktopPlatformOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDesktopPlatform:other];
}

- (BOOL)isEqualToDesktopPlatform:(DBTEAMDesktopPlatform *)aDesktopPlatform {
  if (self == aDesktopPlatform) {
    return YES;
  }
  if (self.tag != aDesktopPlatform.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMDesktopPlatformWindows:
    return [[self tagName] isEqual:[aDesktopPlatform tagName]];
  case DBTEAMDesktopPlatformMac:
    return [[self tagName] isEqual:[aDesktopPlatform tagName]];
  case DBTEAMDesktopPlatformLinux:
    return [[self tagName] isEqual:[aDesktopPlatform tagName]];
  case DBTEAMDesktopPlatformOther:
    return [[self tagName] isEqual:[aDesktopPlatform tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMDesktopPlatformSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMDesktopPlatform *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isWindows]) {
    jsonDict[@".tag"] = @"windows";
  } else if ([valueObj isMac]) {
    jsonDict[@".tag"] = @"mac";
  } else if ([valueObj isLinux]) {
    jsonDict[@".tag"] = @"linux";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMDesktopPlatform *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"windows"]) {
    return [[DBTEAMDesktopPlatform alloc] initWithWindows];
  } else if ([tag isEqualToString:@"mac"]) {
    return [[DBTEAMDesktopPlatform alloc] initWithMac];
  } else if ([tag isEqualToString:@"linux"]) {
    return [[DBTEAMDesktopPlatform alloc] initWithLinux];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMDesktopPlatform alloc] initWithOther];
  } else {
    return [[DBTEAMDesktopPlatform alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMDeviceSessionArg.h"

#pragma mark - API Object

@implementation DBTEAMDeviceSessionArg

#pragma mark - Constructors

- (instancetype)initWithSessionId:(NSString *)sessionId teamMemberId:(NSString *)teamMemberId {
  [DBStoneValidators nonnullValidator:nil](sessionId);
  [DBStoneValidators nonnullValidator:nil](teamMemberId);

  self = [super init];
  if (self) {
    _sessionId = sessionId;
    _teamMemberId = teamMemberId;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMDeviceSessionArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMDeviceSessionArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMDeviceSessionArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.sessionId hash];
  result = prime * result + [self.teamMemberId hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceSessionArg:other];
}

- (BOOL)isEqualToDeviceSessionArg:(DBTEAMDeviceSessionArg *)aDeviceSessionArg {
  if (self == aDeviceSessionArg) {
    return YES;
  }
  if (![self.sessionId isEqual:aDeviceSessionArg.sessionId]) {
    return NO;
  }
  if (![self.teamMemberId isEqual:aDeviceSessionArg.teamMemberId]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMDeviceSessionArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMDeviceSessionArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"session_id"] = valueObj.sessionId;
  jsonDict[@"team_member_id"] = valueObj.teamMemberId;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMDeviceSessionArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *sessionId = valueDict[@"session_id"];
  NSString *teamMemberId = valueDict[@"team_member_id"];

  return [[DBTEAMDeviceSessionArg alloc] initWithSessionId:sessionId teamMemberId:teamMemberId];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMDevicesActive.h"

#pragma mark - API Object

@implementation DBTEAMDevicesActive

#pragma mark - Constructors

- (instancetype)initWithWindows:(NSArray<NSNumber *> *)windows
                          macos:(NSArray<NSNumber *> *)macos
                          linux:(NSArray<NSNumber *> *)linux
                            ios:(NSArray<NSNumber *> *)ios
                        android:(NSArray<NSNumber *> *)android
                          other:(NSArray<NSNumber *> *)other
                          total:(NSArray<NSNumber *> *)total {
  [DBStoneValidators nonnullValidator:[DBStoneValidators arrayValidator:nil maxItems:nil itemValidator:nil]](windows);
  [DBStoneValidators nonnullValidator:[DBStoneValidators arrayValidator:nil maxItems:nil itemValidator:nil]](macos);
  [DBStoneValidators nonnullValidator:[DBStoneValidators arrayValidator:nil maxItems:nil itemValidator:nil]](linux);
  [DBStoneValidators nonnullValidator:[DBStoneValidators arrayValidator:nil maxItems:nil itemValidator:nil]](ios);
  [DBStoneValidators nonnullValidator:[DBStoneValidators arrayValidator:nil maxItems:nil itemValidator:nil]](android);
  [DBStoneValidators nonnullValidator:[DBStoneValidators arrayValidator:nil maxItems:nil itemValidator:nil]](other);
  [DBStoneValidators nonnullValidator:[DBStoneValidators arrayValidator:nil maxItems:nil itemValidator:nil]](total);

  self = [super init];
  if (self) {
    _windows = windows;
    _macos = macos;
    _linux = linux;
    _ios = ios;
    _android = android;
    _other = other;
    _total = total;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMDevicesActiveSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMDevicesActiveSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMDevicesActiveSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.windows hash];
  result = prime * result + [self.macos hash];
  result = prime * result + [self.linux hash];
  result = prime * result + [self.ios hash];
  result = prime * result + [self.android hash];
  result = prime * result + [self.other hash];
  result = prime * result + [self.total hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDevicesActive:other];
}

- (BOOL)isEqualToDevicesActive:(DBTEAMDevicesActive *)aDevicesActive {
  if (self == aDevicesActive) {
    return YES;
  }
  if (![self.windows isEqual:aDevicesActive.windows]) {
    return NO;
  }
  if (![self.macos isEqual:aDevicesActive.macos]) {
    return NO;
  }
  if (![self.linux isEqual:aDevicesActive.linux]) {
    return NO;
  }
  if (![self.ios isEqual:aDevicesActive.ios]) {
    return NO;
  }
  if (![self.android isEqual:aDevicesActive.android]) {
    return NO;
  }
  if (![self.other isEqual:aDevicesActive.other]) {
    return NO;
  }
  if (![self.total isEqual:aDevicesActive.total]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMDevicesActiveSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMDevicesActive *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"windows"] = [DBArraySerializer serialize:valueObj.windows
                                            withBlock:^id(id elem0) {
                                              return elem0;
                                            }];
  jsonDict[@"macos"] = [DBArraySerializer serialize:valueObj.macos
                                          withBlock:^id(id elem0) {
                                            return elem0;
                                          }];
  jsonDict[@"linux"] = [DBArraySerializer serialize:valueObj.linux
                                          withBlock:^id(id elem0) {
                                            return elem0;
                                          }];
  jsonDict[@"ios"] = [DBArraySerializer serialize:valueObj.ios
                                        withBlock:^id(id elem0) {
                                          return elem0;
                                        }];
  jsonDict[@"android"] = [DBArraySerializer serialize:valueObj.android
                                            withBlock:^id(id elem0) {
                                              return elem0;
                                            }];
  jsonDict[@"other"] = [DBArraySerializer serialize:valueObj.other
                                          withBlock:^id(id elem0) {
                                            return elem0;
                                          }];
  jsonDict[@"total"] = [DBArraySerializer serialize:valueObj.total
                                          withBlock:^id(id elem0) {
                                            return elem0;
                                          }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMDevicesActive *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<NSNumber *> *windows = [DBArraySerializer deserialize:valueDict[@"windows"]
                                                      withBlock:^id(id elem0) {
                                                        return elem0;
                                                      }];
  NSArray<NSNumber *> *macos = [DBArraySerializer deserialize:valueDict[@"macos"]
                                                    withBlock:^id(id elem0) {
                                                      return elem0;
                                                    }];
  NSArray<NSNumber *> *linux = [DBArraySerializer deserialize:valueDict[@"linux"]
                                                    withBlock:^id(id elem0) {
                                                      return elem0;
                                                    }];
  NSArray<NSNumber *> *ios = [DBArraySerializer deserialize:valueDict[@"ios"]
                                                  withBlock:^id(id elem0) {
                                                    return elem0;
                                                  }];
  NSArray<NSNumber *> *android = [DBArraySerializer deserialize:valueDict[@"android"]
                                                      withBlock:^id(id elem0) {
                                                        return elem0;
                                                      }];
  NSArray<NSNumber *> *other = [DBArraySerializer deserialize:valueDict[@"other"]
                                                    withBlock:^id(id elem0) {
                                                      return elem0;
                                                    }];
  NSArray<NSNumber *> *total = [DBArraySerializer deserialize:valueDict[@"total"]
                                                    withBlock:^id(id elem0) {
                                                      return elem0;
                                                    }];

  return [[DBTEAMDevicesActive alloc] initWithWindows:windows
                                                macos:macos
                                                linux:linux
                                                  ios:ios
                                              android:android
                                                other:other
                                                total:total];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMExcludedUsersListArg.h"

#pragma mark - API Object

@implementation DBTEAMExcludedUsersListArg

#pragma mark - Constructors

- (instancetype)initWithLimit:(NSNumber *)limit {

  self = [super init];
  if (self) {
    _limit = limit ?: @(1000);
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithLimit:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMExcludedUsersListArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMExcludedUsersListArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMExcludedUsersListArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.limit hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToExcludedUsersListArg:other];
}

- (BOOL)isEqualToExcludedUsersListArg:(DBTEAMExcludedUsersListArg *)anExcludedUsersListArg {
  if (self == anExcludedUsersListArg) {
    return YES;
  }
  if (![self.limit isEqual:anExcludedUsersListArg.limit]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMExcludedUsersListArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMExcludedUsersListArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"limit"] = valueObj.limit;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMExcludedUsersListArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSNumber *limit = valueDict[@"limit"] ?: @(1000);

  return [[DBTEAMExcludedUsersListArg alloc] initWithLimit:limit];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMExcludedUsersListContinueArg.h"

#pragma mark - API Object

@implementation DBTEAMExcludedUsersListContinueArg

#pragma mark - Constructors

- (instancetype)initWithCursor:(NSString *)cursor {
  [DBStoneValidators nonnullValidator:nil](cursor);

  self = [super init];
  if (self) {
    _cursor = cursor;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMExcludedUsersListContinueArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMExcludedUsersListContinueArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMExcludedUsersListContinueArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.cursor hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToExcludedUsersListContinueArg:other];
}

- (BOOL)isEqualToExcludedUsersListContinueArg:(DBTEAMExcludedUsersListContinueArg *)anExcludedUsersListContinueArg {
  if (self == anExcludedUsersListContinueArg) {
    return YES;
  }
  if (![self.cursor isEqual:anExcludedUsersListContinueArg.cursor]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMExcludedUsersListContinueArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMExcludedUsersListContinueArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"cursor"] = valueObj.cursor;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMExcludedUsersListContinueArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *cursor = valueDict[@"cursor"];

  return [[DBTEAMExcludedUsersListContinueArg alloc] initWithCursor:cursor];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMExcludedUsersListContinueError.h"

#pragma mark - API Object

@implementation DBTEAMExcludedUsersListContinueError

#pragma mark - Constructors

- (instancetype)initWithInvalidCursor {
  self = [super init];
  if (self) {
    _tag = DBTEAMExcludedUsersListContinueErrorInvalidCursor;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMExcludedUsersListContinueErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isInvalidCursor {
  return _tag == DBTEAMExcludedUsersListContinueErrorInvalidCursor;
}

- (BOOL)isOther {
  return _tag == DBTEAMExcludedUsersListContinueErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMExcludedUsersListContinueErrorInvalidCursor:
    return @"DBTEAMExcludedUsersListContinueErrorInvalidCursor";
  case DBTEAMExcludedUsersListContinueErrorOther:
    return @"DBTEAMExcludedUsersListContinueErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMExcludedUsersListContinueErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMExcludedUsersListContinueErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMExcludedUsersListContinueErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMExcludedUsersListContinueErrorInvalidCursor:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMExcludedUsersListContinueErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToExcludedUsersListContinueError:other];
}

- (BOOL)isEqualToExcludedUsersListContinueError:
    (DBTEAMExcludedUsersListContinueError *)anExcludedUsersListContinueError {
  if (self == anExcludedUsersListContinueError) {
    return YES;
  }
  if (self.tag != anExcludedUsersListContinueError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMExcludedUsersListContinueErrorInvalidCursor:
    return [[self tagName] isEqual:[anExcludedUsersListContinueError tagName]];
  case DBTEAMExcludedUsersListContinueErrorOther:
    return [[self tagName] isEqual:[anExcludedUsersListContinueError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMExcludedUsersListContinueErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMExcludedUsersListContinueError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isInvalidCursor]) {
    jsonDict[@".tag"] = @"invalid_cursor";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMExcludedUsersListContinueError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"invalid_cursor"]) {
    return [[DBTEAMExcludedUsersListContinueError alloc] initWithInvalidCursor];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMExcludedUsersListContinueError alloc] initWithOther];
  } else {
    return [[DBTEAMExcludedUsersListContinueError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMExcludedUsersListError.h"

#pragma mark - API Object

@implementation DBTEAMExcludedUsersListError

#pragma mark - Constructors

- (instancetype)initWithListError {
  self = [super init];
  if (self) {
    _tag = DBTEAMExcludedUsersListErrorListError;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMExcludedUsersListErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isListError {
  return _tag == DBTEAMExcludedUsersListErrorListError;
}

- (BOOL)isOther {
  return _tag == DBTEAMExcludedUsersListErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMExcludedUsersListErrorListError:
    return @"DBTEAMExcludedUsersListErrorListError";
  case DBTEAMExcludedUsersListErrorOther:
    return @"DBTEAMExcludedUsersListErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMExcludedUsersListErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMExcludedUsersListErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMExcludedUsersListErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMExcludedUsersListErrorListError:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMExcludedUsersListErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToExcludedUsersListError:other];
}

- (BOOL)isEqualToExcludedUsersListError:(DBTEAMExcludedUsersListError *)anExcludedUsersListError {
  if (self == anExcludedUsersListError) {
    return YES;
  }
  if (self.tag != anExcludedUsersListError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMExcludedUsersListErrorListError:
    return [[self tagName] isEqual:[anExcludedUsersListError tagName]];
  case DBTEAMExcludedUsersListErrorOther:
    return [[self tagName] isEqual:[anExcludedUsersListError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMExcludedUsersListErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMExcludedUsersListError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isListError]) {
    jsonDict[@".tag"] = @"list_error";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMExcludedUsersListError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"list_error"]) {
    return [[DBTEAMExcludedUsersListError alloc] initWithListError];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMExcludedUsersListError alloc] initWithOther];
  } else {
    return [[DBTEAMExcludedUsersListError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMExcludedUsersListResult.h"
#import "DBTEAMMemberProfile.h"

#pragma mark - API Object

@implementation DBTEAMExcludedUsersListResult

#pragma mark - Constructors

- (instancetype)initWithUsers:(NSArray<DBTEAMMemberProfile *> *)users
                      hasMore:(NSNumber *)hasMore
                       cursor:(NSString *)cursor {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](users);
  [DBStoneValidators nonnullValidator:nil](hasMore);

  self = [super init];
  if (self) {
    _users = users;
    _cursor = cursor;
    _hasMore = hasMore;
  }
  return self;
}

- (instancetype)initWithUsers:(NSArray<DBTEAMMemberProfile *> *)users hasMore:(NSNumber *)hasMore {
  return [self initWithUsers:users hasMore:hasMore cursor:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMExcludedUsersListResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMExcludedUsersListResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMExcludedUsersListResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.users hash];
  result = prime * result + [self.hasMore hash];
  if (self.cursor != nil) {
    result = prime * result + [self.cursor hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToExcludedUsersListResult:other];
}

- (BOOL)isEqualToExcludedUsersListResult:(DBTEAMExcludedUsersListResult *)anExcludedUsersListResult {
  if (self == anExcludedUsersListResult) {
    return YES;
  }
  if (![self.users isEqual:anExcludedUsersListResult.users]) {
    return NO;
  }
  if (![self.hasMore isEqual:anExcludedUsersListResult.hasMore]) {
    return NO;
  }
  if (self.cursor) {
    if (![self.cursor isEqual:anExcludedUsersListResult.cursor]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMExcludedUsersListResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMExcludedUsersListResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"users"] = [DBArraySerializer serialize:valueObj.users
                                          withBlock:^id(id elem0) {
                                            return [DBTEAMMemberProfileSerializer serialize:elem0];
                                          }];
  jsonDict[@"has_more"] = valueObj.hasMore;
  if (valueObj.cursor) {
    jsonDict[@"cursor"] = valueObj.cursor;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMExcludedUsersListResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBTEAMMemberProfile *> *users =
      [DBArraySerializer deserialize:valueDict[@"users"]
                           withBlock:^id(id elem0) {
                             return [DBTEAMMemberProfileSerializer deserialize:elem0];
                           }];
  NSNumber *hasMore = valueDict[@"has_more"];
  NSString *cursor = valueDict[@"cursor"] ?: nil;

  return [[DBTEAMExcludedUsersListResult alloc] initWithUsers:users hasMore:hasMore cursor:cursor];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMExcludedUsersUpdateArg.h"
#import "DBTEAMUserSelectorArg.h"

#pragma mark - API Object

@implementation DBTEAMExcludedUsersUpdateArg

#pragma mark - Constructors

- (instancetype)initWithUsers:(NSArray<DBTEAMUserSelectorArg *> *)users {
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](users);

  self = [super init];
  if (self) {
    _users = users;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithUsers:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMExcludedUsersUpdateArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMExcludedUsersUpdateArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMExcludedUsersUpdateArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.users != nil) {
    result = prime * result + [self.users hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToExcludedUsersUpdateArg:other];
}

- (BOOL)isEqualToExcludedUsersUpdateArg:(DBTEAMExcludedUsersUpdateArg *)anExcludedUsersUpdateArg {
  if (self == anExcludedUsersUpdateArg) {
    return YES;
  }
  if (self.users) {
    if (![self.users isEqual:anExcludedUsersUpdateArg.users]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMExcludedUsersUpdateArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMExcludedUsersUpdateArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.users) {
    jsonDict[@"users"] = [DBArraySerializer serialize:valueObj.users
                                            withBlock:^id(id elem0) {
                                              return [DBTEAMUserSelectorArgSerializer serialize:elem0];
                                            }];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMExcludedUsersUpdateArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBTEAMUserSelectorArg *> *users =
      valueDict[@"users"] ? [DBArraySerializer deserialize:valueDict[@"users"]
                                                 withBlock:^id(id elem0) {
                                                   return [DBTEAMUserSelectorArgSerializer deserialize:elem0];
                                                 }]
                          : nil;

  return [[DBTEAMExcludedUsersUpdateArg alloc] initWithUsers:users];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMExcludedUsersUpdateError.h"

#pragma mark - API Object

@implementation DBTEAMExcludedUsersUpdateError

#pragma mark - Constructors

- (instancetype)initWithUsersNotInTeam {
  self = [super init];
  if (self) {
    _tag = DBTEAMExcludedUsersUpdateErrorUsersNotInTeam;
  }
  return self;
}

- (instancetype)initWithTooManyUsers {
  self = [super init];
  if (self) {
    _tag = DBTEAMExcludedUsersUpdateErrorTooManyUsers;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMExcludedUsersUpdateErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isUsersNotInTeam {
  return _tag == DBTEAMExcludedUsersUpdateErrorUsersNotInTeam;
}

- (BOOL)isTooManyUsers {
  return _tag == DBTEAMExcludedUsersUpdateErrorTooManyUsers;
}

- (BOOL)isOther {
  return _tag == DBTEAMExcludedUsersUpdateErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMExcludedUsersUpdateErrorUsersNotInTeam:
    return @"DBTEAMExcludedUsersUpdateErrorUsersNotInTeam";
  case DBTEAMExcludedUsersUpdateErrorTooManyUsers:
    return @"DBTEAMExcludedUsersUpdateErrorTooManyUsers";
  case DBTEAMExcludedUsersUpdateErrorOther:
    return @"DBTEAMExcludedUsersUpdateErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMExcludedUsersUpdateErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMExcludedUsersUpdateErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMExcludedUsersUpdateErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMExcludedUsersUpdateErrorUsersNotInTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMExcludedUsersUpdateErrorTooManyUsers:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMExcludedUsersUpdateErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToExcludedUsersUpdateError:other];
}

- (BOOL)isEqualToExcludedUsersUpdateError:(DBTEAMExcludedUsersUpdateError *)anExcludedUsersUpdateError {
  if (self == anExcludedUsersUpdateError) {
    return YES;
  }
  if (self.tag != anExcludedUsersUpdateError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMExcludedUsersUpdateErrorUsersNotInTeam:
    return [[self tagName] isEqual:[anExcludedUsersUpdateError tagName]];
  case DBTEAMExcludedUsersUpdateErrorTooManyUsers:
    return [[self tagName] isEqual:[anExcludedUsersUpdateError tagName]];
  case DBTEAMExcludedUsersUpdateErrorOther:
    return [[self tagName] isEqual:[anExcludedUsersUpdateError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMExcludedUsersUpdateErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMExcludedUsersUpdateError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUsersNotInTeam]) {
    jsonDict[@".tag"] = @"users_not_in_team";
  } else if ([valueObj isTooManyUsers]) {
    jsonDict[@".tag"] = @"too_many_users";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMExcludedUsersUpdateError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"users_not_in_team"]) {
    return [[DBTEAMExcludedUsersUpdateError alloc] initWithUsersNotInTeam];
  } else if ([tag isEqualToString:@"too_many_users"]) {
    return [[DBTEAMExcludedUsersUpdateError alloc] initWithTooManyUsers];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMExcludedUsersUpdateError alloc] initWithOther];
  } else {
    return [[DBTEAMExcludedUsersUpdateError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMExcludedUsersUpdateResult.h"
#import "DBTEAMExcludedUsersUpdateStatus.h"

#pragma mark - API Object

@implementation DBTEAMExcludedUsersUpdateResult

#pragma mark - Constructors

- (instancetype)initWithStatus:(DBTEAMExcludedUsersUpdateStatus *)status {
  [DBStoneValidators nonnullValidator:nil](status);

  self = [super init];
  if (self) {
    _status = status;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMExcludedUsersUpdateResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMExcludedUsersUpdateResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMExcludedUsersUpdateResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.status hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToExcludedUsersUpdateResult:other];
}

- (BOOL)isEqualToExcludedUsersUpdateResult:(DBTEAMExcludedUsersUpdateResult *)anExcludedUsersUpdateResult {
  if (self == anExcludedUsersUpdateResult) {
    return YES;
  }
  if (![self.status isEqual:anExcludedUsersUpdateResult.status]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMExcludedUsersUpdateResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMExcludedUsersUpdateResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"status"] = [DBTEAMExcludedUsersUpdateStatusSerializer serialize:valueObj.status];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMExcludedUsersUpdateResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMExcludedUsersUpdateStatus *status =
      [DBTEAMExcludedUsersUpdateStatusSerializer deserialize:valueDict[@"status"]];

  return [[DBTEAMExcludedUsersUpdateResult alloc] initWithStatus:status];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMExcludedUsersUpdateStatus.h"

#pragma mark - API Object

@implementation DBTEAMExcludedUsersUpdateStatus

#pragma mark - Constructors

- (instancetype)initWithSuccess {
  self = [super init];
  if (self) {
    _tag = DBTEAMExcludedUsersUpdateStatusSuccess;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMExcludedUsersUpdateStatusOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isSuccess {
  return _tag == DBTEAMExcludedUsersUpdateStatusSuccess;
}

- (BOOL)isOther {
  return _tag == DBTEAMExcludedUsersUpdateStatusOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMExcludedUsersUpdateStatusSuccess:
    return @"DBTEAMExcludedUsersUpdateStatusSuccess";
  case DBTEAMExcludedUsersUpdateStatusOther:
    return @"DBTEAMExcludedUsersUpdateStatusOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMExcludedUsersUpdateStatusSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMExcludedUsersUpdateStatusSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMExcludedUsersUpdateStatusSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMExcludedUsersUpdateStatusSuccess:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMExcludedUsersUpdateStatusOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToExcludedUsersUpdateStatus:other];
}

- (BOOL)isEqualToExcludedUsersUpdateStatus:(DBTEAMExcludedUsersUpdateStatus *)anExcludedUsersUpdateStatus {
  if (self == anExcludedUsersUpdateStatus) {
    return YES;
  }
  if (self.tag != anExcludedUsersUpdateStatus.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMExcludedUsersUpdateStatusSuccess:
    return [[self tagName] isEqual:[anExcludedUsersUpdateStatus tagName]];
  case DBTEAMExcludedUsersUpdateStatusOther:
    return [[self tagName] isEqual:[anExcludedUsersUpdateStatus tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMExcludedUsersUpdateStatusSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMExcludedUsersUpdateStatus *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isSuccess]) {
    jsonDict[@".tag"] = @"success";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMExcludedUsersUpdateStatus *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"success"]) {
    return [[DBTEAMExcludedUsersUpdateStatus alloc] initWithSuccess];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMExcludedUsersUpdateStatus alloc] initWithOther];
  } else {
    return [[DBTEAMExcludedUsersUpdateStatus alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMFeature.h"

#pragma mark - API Object

@implementation DBTEAMFeature

#pragma mark - Constructors

- (instancetype)initWithUploadApiRateLimit {
  self = [super init];
  if (self) {
    _tag = DBTEAMFeatureUploadApiRateLimit;
  }
  return self;
}

- (instancetype)initWithHasTeamSharedDropbox {
  self = [super init];
  if (self) {
    _tag = DBTEAMFeatureHasTeamSharedDropbox;
  }
  return self;
}

- (instancetype)initWithHasTeamFileEvents {
  self = [super init];
  if (self) {
    _tag = DBTEAMFeatureHasTeamFileEvents;
  }
  return self;
}

- (instancetype)initWithHasTeamSelectiveSync {
  self = [super init];
  if (self) {
    _tag = DBTEAMFeatureHasTeamSelectiveSync;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMFeatureOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isUploadApiRateLimit {
  return _tag == DBTEAMFeatureUploadApiRateLimit;
}

- (BOOL)isHasTeamSharedDropbox {
  return _tag == DBTEAMFeatureHasTeamSharedDropbox;
}

- (BOOL)isHasTeamFileEvents {
  return _tag == DBTEAMFeatureHasTeamFileEvents;
}

- (BOOL)isHasTeamSelectiveSync {
  return _tag == DBTEAMFeatureHasTeamSelectiveSync;
}

- (BOOL)isOther {
  return _tag == DBTEAMFeatureOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMFeatureUploadApiRateLimit:
    return @"DBTEAMFeatureUploadApiRateLimit";
  case DBTEAMFeatureHasTeamSharedDropbox:
    return @"DBTEAMFeatureHasTeamSharedDropbox";
  case DBTEAMFeatureHasTeamFileEvents:
    return @"DBTEAMFeatureHasTeamFileEvents";
  case DBTEAMFeatureHasTeamSelectiveSync:
    return @"DBTEAMFeatureHasTeamSelectiveSync";
  case DBTEAMFeatureOther:
    return @"DBTEAMFeatureOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMFeatureSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMFeatureSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMFeatureSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMFeatureUploadApiRateLimit:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMFeatureHasTeamSharedDropbox:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMFeatureHasTeamFileEvents:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMFeatureHasTeamSelectiveSync:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMFeatureOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFeature:other];
}

- (BOOL)isEqualToFeature:(DBTEAMFeature *)aFeature {
  if (self == aFeature) {
    return YES;
  }
  if (self.tag != aFeature.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMFeatureUploadApiRateLimit:
    return [[self tagName] isEqual:[aFeature tagName]];
  case DBTEAMFeatureHasTeamSharedDropbox:
    return [[self tagName] isEqual:[aFeature tagName]];
  case DBTEAMFeatureHasTeamFileEvents:
    return [[self tagName] isEqual:[aFeature tagName]];
  case DBTEAMFeatureHasTeamSelectiveSync:
    return [[self tagName] isEqual:[aFeature tagName]];
  case DBTEAMFeatureOther:
    return [[self tagName] isEqual:[aFeature tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMFeatureSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMFeature *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUploadApiRateLimit]) {
    jsonDict[@".tag"] = @"upload_api_rate_limit";
  } else if ([valueObj isHasTeamSharedDropbox]) {
    jsonDict[@".tag"] = @"has_team_shared_dropbox";
  } else if ([valueObj isHasTeamFileEvents]) {
    jsonDict[@".tag"] = @"has_team_file_events";
  } else if ([valueObj isHasTeamSelectiveSync]) {
    jsonDict[@".tag"] = @"has_team_selective_sync";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMFeature *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"upload_api_rate_limit"]) {
    return [[DBTEAMFeature alloc] initWithUploadApiRateLimit];
  } else if ([tag isEqualToString:@"has_team_shared_dropbox"]) {
    return [[DBTEAMFeature alloc] initWithHasTeamSharedDropbox];
  } else if ([tag isEqualToString:@"has_team_file_events"]) {
    return [[DBTEAMFeature alloc] initWithHasTeamFileEvents];
  } else if ([tag isEqualToString:@"has_team_selective_sync"]) {
    return [[DBTEAMFeature alloc] initWithHasTeamSelectiveSync];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMFeature alloc] initWithOther];
  } else {
    return [[DBTEAMFeature alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMFeatureValue.h"
#import "DBTEAMHasTeamFileEventsValue.h"
#import "DBTEAMHasTeamSelectiveSyncValue.h"
#import "DBTEAMHasTeamSharedDropboxValue.h"
#import "DBTEAMUploadApiRateLimitValue.h"

#pragma mark - API Object

@implementation DBTEAMFeatureValue

@synthesize uploadApiRateLimit = _uploadApiRateLimit;
@synthesize hasTeamSharedDropbox = _hasTeamSharedDropbox;
@synthesize hasTeamFileEvents = _hasTeamFileEvents;
@synthesize hasTeamSelectiveSync = _hasTeamSelectiveSync;

#pragma mark - Constructors

- (instancetype)initWithUploadApiRateLimit:(DBTEAMUploadApiRateLimitValue *)uploadApiRateLimit {
  self = [super init];
  if (self) {
    _tag = DBTEAMFeatureValueUploadApiRateLimit;
    _uploadApiRateLimit = uploadApiRateLimit;
  }
  return self;
}

- (instancetype)initWithHasTeamSharedDropbox:(DBTEAMHasTeamSharedDropboxValue *)hasTeamSharedDropbox {
  self = [super init];
  if (self) {
    _tag = DBTEAMFeatureValueHasTeamSharedDropbox;
    _hasTeamSharedDropbox = hasTeamSharedDropbox;
  }
  return self;
}

- (instancetype)initWithHasTeamFileEvents:(DBTEAMHasTeamFileEventsValue *)hasTeamFileEvents {
  self = [super init];
  if (self) {
    _tag = DBTEAMFeatureValueHasTeamFileEvents;
    _hasTeamFileEvents = hasTeamFileEvents;
  }
  return self;
}

- (instancetype)initWithHasTeamSelectiveSync:(DBTEAMHasTeamSelectiveSyncValue *)hasTeamSelectiveSync {
  self = [super init];
  if (self) {
    _tag = DBTEAMFeatureValueHasTeamSelectiveSync;
    _hasTeamSelectiveSync = hasTeamSelectiveSync;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMFeatureValueOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBTEAMUploadApiRateLimitValue *)uploadApiRateLimit {
  if (![self isUploadApiRateLimit]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMFeatureValueUploadApiRateLimit, but was %@.", [self tagName]];
  }
  return _uploadApiRateLimit;
}

- (DBTEAMHasTeamSharedDropboxValue *)hasTeamSharedDropbox {
  if (![self isHasTeamSharedDropbox]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMFeatureValueHasTeamSharedDropbox, but was %@.", [self tagName]];
  }
  return _hasTeamSharedDropbox;
}

- (DBTEAMHasTeamFileEventsValue *)hasTeamFileEvents {
  if (![self isHasTeamFileEvents]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMFeatureValueHasTeamFileEvents, but was %@.", [self tagName]];
  }
  return _hasTeamFileEvents;
}

- (DBTEAMHasTeamSelectiveSyncValue *)hasTeamSelectiveSync {
  if (![self isHasTeamSelectiveSync]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMFeatureValueHasTeamSelectiveSync, but was %@.", [self tagName]];
  }
  return _hasTeamSelectiveSync;
}

#pragma mark - Tag state methods

- (BOOL)isUploadApiRateLimit {
  return _tag == DBTEAMFeatureValueUploadApiRateLimit;
}

- (BOOL)isHasTeamSharedDropbox {
  return _tag == DBTEAMFeatureValueHasTeamSharedDropbox;
}

- (BOOL)isHasTeamFileEvents {
  return _tag == DBTEAMFeatureValueHasTeamFileEvents;
}

- (BOOL)isHasTeamSelectiveSync {
  return _tag == DBTEAMFeatureValueHasTeamSelectiveSync;
}

- (BOOL)isOther {
  return _tag == DBTEAMFeatureValueOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMFeatureValueUploadApiRateLimit:
    return @"DBTEAMFeatureValueUploadApiRateLimit";
  case DBTEAMFeatureValueHasTeamSharedDropbox:
    return @"DBTEAMFeatureValueHasTeamSharedDropbox";
  case DBTEAMFeatureValueHasTeamFileEvents:
    return @"DBTEAMFeatureValueHasTeamFileEvents";
  case DBTEAMFeatureValueHasTeamSelectiveSync:
    return @"DBTEAMFeatureValueHasTeamSelectiveSync";
  case DBTEAMFeatureValueOther:
    return @"DBTEAMFeatureValueOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMFeatureValueSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMFeatureValueSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMFeatureValueSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMFeatureValueUploadApiRateLimit:
    result = prime * result + [self.uploadApiRateLimit hash];
    break;
  case DBTEAMFeatureValueHasTeamSharedDropbox:
    result = prime * result + [self.hasTeamSharedDropbox hash];
    break;
  case DBTEAMFeatureValueHasTeamFileEvents:
    result = prime * result + [self.hasTeamFileEvents hash];
    break;
  case DBTEAMFeatureValueHasTeamSelectiveSync:
    result = prime * result + [self.hasTeamSelectiveSync hash];
    break;
  case DBTEAMFeatureValueOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFeatureValue:other];
}

- (BOOL)isEqualToFeatureValue:(DBTEAMFeatureValue *)aFeatureValue {
  if (self == aFeatureValue) {
    return YES;
  }
  if (self.tag != aFeatureValue.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMFeatureValueUploadApiRateLimit:
    return [self.uploadApiRateLimit isEqual:aFeatureValue.uploadApiRateLimit];
  case DBTEAMFeatureValueHasTeamSharedDropbox:
    return [self.hasTeamSharedDropbox isEqual:aFeatureValue.hasTeamSharedDropbox];
  case DBTEAMFeatureValueHasTeamFileEvents:
    return [self.hasTeamFileEvents isEqual:aFeatureValue.hasTeamFileEvents];
  case DBTEAMFeatureValueHasTeamSelectiveSync:
    return [self.hasTeamSelectiveSync isEqual:aFeatureValue.hasTeamSelectiveSync];
  case DBTEAMFeatureValueOther:
    return [[self tagName] isEqual:[aFeatureValue tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMFeatureValueSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMFeatureValue *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUploadApiRateLimit]) {
    jsonDict[@"upload_api_rate_limit"] =
        [[DBTEAMUploadApiRateLimitValueSerializer serialize:valueObj.uploadApiRateLimit] mutableCopy];
    jsonDict[@".tag"] = @"upload_api_rate_limit";
  } else if ([valueObj isHasTeamSharedDropbox]) {
    jsonDict[@"has_team_shared_dropbox"] =
        [[DBTEAMHasTeamSharedDropboxValueSerializer serialize:valueObj.hasTeamSharedDropbox] mutableCopy];
    jsonDict[@".tag"] = @"has_team_shared_dropbox";
  } else if ([valueObj isHasTeamFileEvents]) {
    jsonDict[@"has_team_file_events"] =
        [[DBTEAMHasTeamFileEventsValueSerializer serialize:valueObj.hasTeamFileEvents] mutableCopy];
    jsonDict[@".tag"] = @"has_team_file_events";
  } else if ([valueObj isHasTeamSelectiveSync]) {
    jsonDict[@"has_team_selective_sync"] =
        [[DBTEAMHasTeamSelectiveSyncValueSerializer serialize:valueObj.hasTeamSelectiveSync] mutableCopy];
    jsonDict[@".tag"] = @"has_team_selective_sync";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMFeatureValue *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"upload_api_rate_limit"]) {
    DBTEAMUploadApiRateLimitValue *uploadApiRateLimit =
        [DBTEAMUploadApiRateLimitValueSerializer deserialize:valueDict[@"upload_api_rate_limit"]];
    return [[DBTEAMFeatureValue alloc] initWithUploadApiRateLimit:uploadApiRateLimit];
  } else if ([tag isEqualToString:@"has_team_shared_dropbox"]) {
    DBTEAMHasTeamSharedDropboxValue *hasTeamSharedDropbox =
        [DBTEAMHasTeamSharedDropboxValueSerializer deserialize:valueDict[@"has_team_shared_dropbox"]];
    return [[DBTEAMFeatureValue alloc] initWithHasTeamSharedDropbox:hasTeamSharedDropbox];
  } else if ([tag isEqualToString:@"has_team_file_events"]) {
    DBTEAMHasTeamFileEventsValue *hasTeamFileEvents =
        [DBTEAMHasTeamFileEventsValueSerializer deserialize:valueDict[@"has_team_file_events"]];
    return [[DBTEAMFeatureValue alloc] initWithHasTeamFileEvents:hasTeamFileEvents];
  } else if ([tag isEqualToString:@"has_team_selective_sync"]) {
    DBTEAMHasTeamSelectiveSyncValue *hasTeamSelectiveSync =
        [DBTEAMHasTeamSelectiveSyncValueSerializer deserialize:valueDict[@"has_team_selective_sync"]];
    return [[DBTEAMFeatureValue alloc] initWithHasTeamSelectiveSync:hasTeamSelectiveSync];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMFeatureValue alloc] initWithOther];
  } else {
    return [[DBTEAMFeatureValue alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMFeature.h"
#import "DBTEAMFeaturesGetValuesBatchArg.h"

#pragma mark - API Object

@implementation DBTEAMFeaturesGetValuesBatchArg

#pragma mark - Constructors

- (instancetype)initWithFeatures:(NSArray<DBTEAMFeature *> *)features {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](features);

  self = [super init];
  if (self) {
    _features = features;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMFeaturesGetValuesBatchArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMFeaturesGetValuesBatchArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMFeaturesGetValuesBatchArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.features hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFeaturesGetValuesBatchArg:other];
}

- (BOOL)isEqualToFeaturesGetValuesBatchArg:(DBTEAMFeaturesGetValuesBatchArg *)aFeaturesGetValuesBatchArg {
  if (self == aFeaturesGetValuesBatchArg) {
    return YES;
  }
  if (![self.features isEqual:aFeaturesGetValuesBatchArg.features]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMFeaturesGetValuesBatchArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMFeaturesGetValuesBatchArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"features"] = [DBArraySerializer serialize:valueObj.features
                                             withBlock:^id(id elem0) {
                                               return [DBTEAMFeatureSerializer serialize:elem0];
                                             }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMFeaturesGetValuesBatchArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBTEAMFeature *> *features = [DBArraySerializer deserialize:valueDict[@"features"]
                                                            withBlock:^id(id elem0) {
                                                              return [DBTEAMFeatureSerializer deserialize:elem0];
                                                            }];

  return [[DBTEAMFeaturesGetValuesBatchArg alloc] initWithFeatures:features];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMFeaturesGetValuesBatchError.h"

#pragma mark - API Object

@implementation DBTEAMFeaturesGetValuesBatchError

#pragma mark - Constructors

- (instancetype)initWithEmptyFeaturesList {
  self = [super init];
  if (self) {
    _tag = DBTEAMFeaturesGetValuesBatchErrorEmptyFeaturesList;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMFeaturesGetValuesBatchErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isEmptyFeaturesList {
  return _tag == DBTEAMFeaturesGetValuesBatchErrorEmptyFeaturesList;
}

- (BOOL)isOther {
  return _tag == DBTEAMFeaturesGetValuesBatchErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMFeaturesGetValuesBatchErrorEmptyFeaturesList:
    return @"DBTEAMFeaturesGetValuesBatchErrorEmptyFeaturesList";
  case DBTEAMFeaturesGetValuesBatchErrorOther:
    return @"DBTEAMFeaturesGetValuesBatchErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMFeaturesGetValuesBatchErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMFeaturesGetValuesBatchErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMFeaturesGetValuesBatchErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMFeaturesGetValuesBatchErrorEmptyFeaturesList:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMFeaturesGetValuesBatchErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFeaturesGetValuesBatchError:other];
}

- (BOOL)isEqualToFeaturesGetValuesBatchError:(DBTEAMFeaturesGetValuesBatchError *)aFeaturesGetValuesBatchError {
  if (self == aFeaturesGetValuesBatchError) {
    return YES;
  }
  if (self.tag != aFeaturesGetValuesBatchError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMFeaturesGetValuesBatchErrorEmptyFeaturesList:
    return [[self tagName] isEqual:[aFeaturesGetValuesBatchError tagName]];
  case DBTEAMFeaturesGetValuesBatchErrorOther:
    return [[self tagName] isEqual:[aFeaturesGetValuesBatchError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMFeaturesGetValuesBatchErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMFeaturesGetValuesBatchError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isEmptyFeaturesList]) {
    jsonDict[@".tag"] = @"empty_features_list";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMFeaturesGetValuesBatchError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"empty_features_list"]) {
    return [[DBTEAMFeaturesGetValuesBatchError alloc] initWithEmptyFeaturesList];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMFeaturesGetValuesBatchError alloc] initWithOther];
  } else {
    return [[DBTEAMFeaturesGetValuesBatchError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMFeatureValue.h"
#import "DBTEAMFeaturesGetValuesBatchResult.h"

#pragma mark - API Object

@implementation DBTEAMFeaturesGetValuesBatchResult

#pragma mark - Constructors

- (instancetype)initWithValues:(NSArray<DBTEAMFeatureValue *> *)values {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](values);

  self = [super init];
  if (self) {
    _values = values;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMFeaturesGetValuesBatchResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMFeaturesGetValuesBatchResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMFeaturesGetValuesBatchResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.values hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFeaturesGetValuesBatchResult:other];
}

- (BOOL)isEqualToFeaturesGetValuesBatchResult:(DBTEAMFeaturesGetValuesBatchResult *)aFeaturesGetValuesBatchResult {
  if (self == aFeaturesGetValuesBatchResult) {
    return YES;
  }
  if (![self.values isEqual:aFeaturesGetValuesBatchResult.values]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMFeaturesGetValuesBatchResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMFeaturesGetValuesBatchResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"values"] = [DBArraySerializer serialize:valueObj.values
                                           withBlock:^id(id elem0) {
                                             return [DBTEAMFeatureValueSerializer serialize:elem0];
                                           }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMFeaturesGetValuesBatchResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBTEAMFeatureValue *> *values =
      [DBArraySerializer deserialize:valueDict[@"values"]
                           withBlock:^id(id elem0) {
                             return [DBTEAMFeatureValueSerializer deserialize:elem0];
                           }];

  return [[DBTEAMFeaturesGetValuesBatchResult alloc] initWithValues:values];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMBaseDfbReport.h"
#import "DBTEAMGetActivityReport.h"

#pragma mark - API Object

@implementation DBTEAMGetActivityReport

#pragma mark - Constructors

- (instancetype)initWithStartDate:(NSString *)startDate
                              adds:(NSArray<NSNumber *> *)adds
                             edits:(NSArray<NSNumber *> *)edits
                           deletes:(NSArray<NSNumber *> *)deletes
                  activeUsers28Day:(NSArray<NSNumber *> *)activeUsers28Day
                   activeUsers7Day:(NSArray<NSNumber *> *)activeUsers7Day
                   activeUsers1Day:(NSArray<NSNumber *> *)activeUsers1Day
          activeSharedFolders28Day:(NSArray<NSNumber *> *)activeSharedFolders28Day
           activeSharedFolders7Day:(NSArray<NSNumber *> *)activeSharedFolders7Day
           activeSharedFolders1Day:(NSArray<NSNumber *> *)activeSharedFolders1Day
                sharedLinksCreated:(NSArray<NSNumber *> *)sharedLinksCreated
           sharedLinksViewedByTeam:(NSArray<NSNumber *> *)sharedLinksViewedByTeam
    sharedLinksViewedByOutsideUser:(NSArray<NSNumber *> *)sharedLinksViewedByOutsideUser
    sharedLinksViewedByNotLoggedIn:(NSArray<NSNumber *> *)sharedLinksViewedByNotLoggedIn
            sharedLinksViewedTotal:(NSArray<NSNumber *> *)sharedLinksViewedTotal {
  [DBStoneValidators nonnullValidator:nil](startDate);
  [DBStoneValidators nonnullValidator:[DBStoneValidators arrayValidator:nil maxItems:nil itemValidator:nil]](adds);
  [DBStoneValidators nonnullValidator:[DBStoneValidators arrayValidator:nil maxItems:nil itemValidator:nil]](edits);
  [DBStoneValidators nonnullValidator:[DBStoneValidators arrayValidator:nil maxItems:nil itemValidator:nil]](deletes);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil maxItems:nil itemValidator:nil]](activeUsers28Day);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil maxItems:nil itemValidator:nil]](activeUsers7Day);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil maxItems:nil itemValidator:nil]](activeUsers1Day);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil maxItems:nil itemValidator:nil]](activeSharedFolders28Day);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil maxItems:nil itemValidator:nil]](activeSharedFolders7Day);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil maxItems:nil itemValidator:nil]](activeSharedFolders1Day);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil maxItems:nil itemValidator:nil]](sharedLinksCreated);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil maxItems:nil itemValidator:nil]](sharedLinksViewedByTeam);
  [DBStoneValidators nonnullValidator:[DBStoneValidators arrayValidator:nil maxItems:nil itemValidator:nil]](
      sharedLinksViewedByOutsideUser);
  [DBStoneValidators nonnullValidator:[DBStoneValidators arrayValidator:nil maxItems:nil itemValidator:nil]](
      sharedLinksViewedByNotLoggedIn);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil maxItems:nil itemValidator:nil]](sharedLinksViewedTotal);

  self = [super initWithStartDate:startDate];
  if (self) {
    _adds = adds;
    _edits = edits;
    _deletes = deletes;
    _activeUsers28Day = activeUsers28Day;
    _activeUsers7Day = activeUsers7Day;
    _activeUsers1Day = activeUsers1Day;
    _activeSharedFolders28Day = activeSharedFolders28Day;
    _activeSharedFolders7Day = activeSharedFolders7Day;
    _activeSharedFolders1Day = activeSharedFolders1Day;
    _sharedLinksCreated = sharedLinksCreated;
    _sharedLinksViewedByTeam = sharedLinksViewedByTeam;
    _sharedLinksViewedByOutsideUser = sharedLinksViewedByOutsideUser;
    _sharedLinksViewedByNotLoggedIn = sharedLinksViewedByNotLoggedIn;
    _sharedLinksViewedTotal = sharedLinksViewedTotal;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGetActivityReportSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGetActivityReportSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGetActivityReportSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.startDate hash];
  result = prime * result + [self.adds hash];
  result = prime * result + [self.edits hash];
  result = prime * result + [self.deletes hash];
  result = prime * result + [self.activeUsers28Day hash];
  result = prime * result + [self.activeUsers7Day hash];
  result = prime * result + [self.activeUsers1Day hash];
  result = prime * result + [self.activeSharedFolders28Day hash];
  result = prime * result + [self.activeSharedFolders7Day hash];
  result = prime * result + [self.activeSharedFolders1Day hash];
  result = prime * result + [self.sharedLinksCreated hash];
  result = prime * result + [self.sharedLinksViewedByTeam hash];
  result = prime * result + [self.sharedLinksViewedByOutsideUser hash];
  result = prime * result + [self.sharedLinksViewedByNotLoggedIn hash];
  result = prime * result + [self.sharedLinksViewedTotal hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetActivityReport:other];
}

- (BOOL)isEqualToGetActivityReport:(DBTEAMGetActivityReport *)aGetActivityReport {
  if (self == aGetActivityReport) {
    return YES;
  }
  if (![self.startDate isEqual:aGetActivityReport.startDate]) {
    return NO;
  }
  if (![self.adds isEqual:aGetActivityReport.adds]) {
    return NO;
  }
  if (![self.edits isEqual:aGetActivityReport.edits]) {
    return NO;
  }
  if (![self.deletes isEqual:aGetActivityReport.deletes]) {
    return NO;
  }
  if (![self.activeUsers28Day isEqual:aGetActivityReport.activeUsers28Day]) {
    return NO;
  }
  if (![self.activeUsers7Day isEqual:aGetActivityReport.activeUsers7Day]) {
    return NO;
  }
  if (![self.activeUsers1Day isEqual:aGetActivityReport.activeUsers1Day]) {
    return NO;
  }
  if (![self.activeSharedFolders28Day isEqual:aGetActivityReport.activeSharedFolders28Day]) {
    return NO;
  }
  if (![self.activeSharedFolders7Day isEqual:aGetActivityReport.activeSharedFolders7Day]) {
    return NO;
  }
  if (![self.activeSharedFolders1Day isEqual:aGetActivityReport.activeSharedFolders1Day]) {
    return NO;
  }
  if (![self.sharedLinksCreated isEqual:aGetActivityReport.sharedLinksCreated]) {
    return NO;
  }
  if (![self.sharedLinksViewedByTeam isEqual:aGetActivityReport.sharedLinksViewedByTeam]) {
    return NO;
  }
  if (![self.sharedLinksViewedByOutsideUser isEqual:aGetActivityReport.sharedLinksViewedByOutsideUser]) {
    return NO;
  }
  if (![self.sharedLinksViewedByNotLoggedIn isEqual:aGetActivityReport.sharedLinksViewedByNotLoggedIn]) {
    return NO;
  }
  if (![self.sharedLinksViewedTotal isEqual:aGetActivityReport.sharedLinksViewedTotal]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGetActivityReportSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGetActivityReport *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"start_date"] = valueObj.startDate;
  jsonDict[@"adds"] = [DBArraySerializer serialize:valueObj.adds
                                         withBlock:^id(id elem0) {
                                           return elem0;
                                         }];
  jsonDict[@"edits"] = [DBArraySerializer serialize:valueObj.edits
                                          withBlock:^id(id elem0) {
                                            return elem0;
                                          }];
  jsonDict[@"deletes"] = [DBArraySerializer serialize:valueObj.deletes
                                            withBlock:^id(id elem0) {
                                              return elem0;
                                            }];
  jsonDict[@"active_users_28_day"] = [DBArraySerializer serialize:valueObj.activeUsers28Day
                                                        withBlock:^id(id elem0) {
                                                          return elem0;
                                                        }];
  jsonDict[@"active_users_7_day"] = [DBArraySerializer serialize:valueObj.activeUsers7Day
                                                       withBlock:^id(id elem0) {
                                                         return elem0;
                                                       }];
  jsonDict[@"active_users_1_day"] = [DBArraySerializer serialize:valueObj.activeUsers1Day
                                                       withBlock:^id(id elem0) {
                                                         return elem0;
                                                       }];
  jsonDict[@"active_shared_folders_28_day"] = [DBArraySerializer serialize:valueObj.activeSharedFolders28Day
                                                                 withBlock:^id(id elem0) {
                                                                   return elem0;
                                                                 }];
  jsonDict[@"active_shared_folders_7_day"] = [DBArraySerializer serialize:valueObj.activeSharedFolders7Day
                                                                withBlock:^id(id elem0) {
                                                                  return elem0;
                                                                }];
  jsonDict[@"active_shared_folders_1_day"] = [DBArraySerializer serialize:valueObj.activeSharedFolders1Day
                                                                withBlock:^id(id elem0) {
                                                                  return elem0;
                                                                }];
  jsonDict[@"shared_links_created"] = [DBArraySerializer serialize:valueObj.sharedLinksCreated
                                                         withBlock:^id(id elem0) {
                                                           return elem0;
                                                         }];
  jsonDict[@"shared_links_viewed_by_team"] = [DBArraySerializer serialize:valueObj.sharedLinksViewedByTeam
                                                                withBlock:^id(id elem0) {
                                                                  return elem0;
                                                                }];
  jsonDict[@"shared_links_viewed_by_outside_user"] =
      [DBArraySerializer serialize:valueObj.sharedLinksViewedByOutsideUser
                         withBlock:^id(id elem0) {
                           return elem0;
                         }];
  jsonDict[@"shared_links_viewed_by_not_logged_in"] =
      [DBArraySerializer serialize:valueObj.sharedLinksViewedByNotLoggedIn
                         withBlock:^id(id elem0) {
                           return elem0;
                         }];
  jsonDict[@"shared_links_viewed_total"] = [DBArraySerializer serialize:valueObj.sharedLinksViewedTotal
                                                              withBlock:^id(id elem0) {
                                                                return elem0;
                                                              }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGetActivityReport *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *startDate = valueDict[@"start_date"];
  NSArray<NSNumber *> *adds = [DBArraySerializer deserialize:valueDict[@"adds"]
                                                   withBlock:^id(id elem0) {
                                                     return elem0;
                                                   }];
  NSArray<NSNumber *> *edits = [DBArraySerializer deserialize:valueDict[@"edits"]
                                                    withBlock:^id(id elem0) {
                                                      return elem0;
                                                    }];
  NSArray<NSNumber *> *deletes = [DBArraySerializer deserialize:valueDict[@"deletes"]
                                                      withBlock:^id(id elem0) {
                                                        return elem0;
                                                      }];
  NSArray<NSNumber *> *activeUsers28Day = [DBArraySerializer deserialize:valueDict[@"active_users_28_day"]
                                                               withBlock:^id(id elem0) {
                                                                 return elem0;
                                                               }];
  NSArray<NSNumber *> *activeUsers7Day = [DBArraySerializer deserialize:valueDict[@"active_users_7_day"]
                                                              withBlock:^id(id elem0) {
                                                                return elem0;
                                                              }];
  NSArray<NSNumber *> *activeUsers1Day = [DBArraySerializer deserialize:valueDict[@"active_users_1_day"]
                                                              withBlock:^id(id elem0) {
                                                                return elem0;
                                                              }];
  NSArray<NSNumber *> *activeSharedFolders28Day =
      [DBArraySerializer deserialize:valueDict[@"active_shared_folders_28_day"]
                           withBlock:^id(id elem0) {
                             return elem0;
                           }];
  NSArray<NSNumber *> *activeSharedFolders7Day =
      [DBArraySerializer deserialize:valueDict[@"active_shared_folders_7_day"]
                           withBlock:^id(id elem0) {
                             return elem0;
                           }];
  NSArray<NSNumber *> *activeSharedFolders1Day =
      [DBArraySerializer deserialize:valueDict[@"active_shared_folders_1_day"]
                           withBlock:^id(id elem0) {
                             return elem0;
                           }];
  NSArray<NSNumber *> *sharedLinksCreated = [DBArraySerializer deserialize:valueDict[@"shared_links_created"]
                                                                 withBlock:^id(id elem0) {
                                                                   return elem0;
                                                                 }];
  NSArray<NSNumber *> *sharedLinksViewedByTeam =
      [DBArraySerializer deserialize:valueDict[@"shared_links_viewed_by_team"]
                           withBlock:^id(id elem0) {
                             return elem0;
                           }];
  NSArray<NSNumber *> *sharedLinksViewedByOutsideUser =
      [DBArraySerializer deserialize:valueDict[@"shared_links_viewed_by_outside_user"]
                           withBlock:^id(id elem0) {
                             return elem0;
                           }];
  NSArray<NSNumber *> *sharedLinksViewedByNotLoggedIn =
      [DBArraySerializer deserialize:valueDict[@"shared_links_viewed_by_not_logged_in"]
                           withBlock:^id(id elem0) {
                             return elem0;
                           }];
  NSArray<NSNumber *> *sharedLinksViewedTotal = [DBArraySerializer deserialize:valueDict[@"shared_links_viewed_total"]
                                                                     withBlock:^id(id elem0) {
                                                                       return elem0;
                                                                     }];

  return [[DBTEAMGetActivityReport alloc] initWithStartDate:startDate
                                                       adds:adds
                                                      edits:edits
                                                    deletes:deletes
                                           activeUsers28Day:activeUsers28Day
                                            activeUsers7Day:activeUsers7Day
                                            activeUsers1Day:activeUsers1Day
                                   activeSharedFolders28Day:activeSharedFolders28Day
                                    activeSharedFolders7Day:activeSharedFolders7Day
                                    activeSharedFolders1Day:activeSharedFolders1Day
                                         sharedLinksCreated:sharedLinksCreated
                                    sharedLinksViewedByTeam:sharedLinksViewedByTeam
                             sharedLinksViewedByOutsideUser:sharedLinksViewedByOutsideUser
                             sharedLinksViewedByNotLoggedIn:sharedLinksViewedByNotLoggedIn
                                     sharedLinksViewedTotal:sharedLinksViewedTotal];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMBaseDfbReport.h"
#import "DBTEAMDevicesActive.h"
#import "DBTEAMGetDevicesReport.h"

#pragma mark - API Object

@implementation DBTEAMGetDevicesReport

#pragma mark - Constructors

- (instancetype)initWithStartDate:(NSString *)startDate
                       active1Day:(DBTEAMDevicesActive *)active1Day
                       active7Day:(DBTEAMDevicesActive *)active7Day
                      active28Day:(DBTEAMDevicesActive *)active28Day {
  [DBStoneValidators nonnullValidator:nil](startDate);
  [DBStoneValidators nonnullValidator:nil](active1Day);
  [DBStoneValidators nonnullValidator:nil](active7Day);
  [DBStoneValidators nonnullValidator:nil](active28Day);

  self = [super initWithStartDate:startDate];
  if (self) {
    _active1Day = active1Day;
    _active7Day = active7Day;
    _active28Day = active28Day;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGetDevicesReportSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGetDevicesReportSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGetDevicesReportSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.startDate hash];
  result = prime * result + [self.active1Day hash];
  result = prime * result + [self.active7Day hash];
  result = prime * result + [self.active28Day hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetDevicesReport:other];
}

- (BOOL)isEqualToGetDevicesReport:(DBTEAMGetDevicesReport *)aGetDevicesReport {
  if (self == aGetDevicesReport) {
    return YES;
  }
  if (![self.startDate isEqual:aGetDevicesReport.startDate]) {
    return NO;
  }
  if (![self.active1Day isEqual:aGetDevicesReport.active1Day]) {
    return NO;
  }
  if (![self.active7Day isEqual:aGetDevicesReport.active7Day]) {
    return NO;
  }
  if (![self.active28Day isEqual:aGetDevicesReport.active28Day]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGetDevicesReportSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGetDevicesReport *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"start_date"] = valueObj.startDate;
  jsonDict[@"active_1_day"] = [DBTEAMDevicesActiveSerializer serialize:valueObj.active1Day];
  jsonDict[@"active_7_day"] = [DBTEAMDevicesActiveSerializer serialize:valueObj.active7Day];
  jsonDict[@"active_28_day"] = [DBTEAMDevicesActiveSerializer serialize:valueObj.active28Day];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGetDevicesReport *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *startDate = valueDict[@"start_date"];
  DBTEAMDevicesActive *active1Day = [DBTEAMDevicesActiveSerializer deserialize:valueDict[@"active_1_day"]];
  DBTEAMDevicesActive *active7Day = [DBTEAMDevicesActiveSerializer deserialize:valueDict[@"active_7_day"]];
  DBTEAMDevicesActive *active28Day = [DBTEAMDevicesActiveSerializer deserialize:valueDict[@"active_28_day"]];

  return [[DBTEAMGetDevicesReport alloc] initWithStartDate:startDate
                                                active1Day:active1Day
                                                active7Day:active7Day
                                               active28Day:active28Day];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMBaseDfbReport.h"
#import "DBTEAMGetMembershipReport.h"

#pragma mark - API Object

@implementation DBTEAMGetMembershipReport

#pragma mark - Constructors

- (instancetype)initWithStartDate:(NSString *)startDate
                         teamSize:(NSArray<NSNumber *> *)teamSize
                   pendingInvites:(NSArray<NSNumber *> *)pendingInvites
                    membersJoined:(NSArray<NSNumber *> *)membersJoined
                 suspendedMembers:(NSArray<NSNumber *> *)suspendedMembers
                         licenses:(NSArray<NSNumber *> *)licenses {
  [DBStoneValidators nonnullValidator:nil](startDate);
  [DBStoneValidators nonnullValidator:[DBStoneValidators arrayValidator:nil maxItems:nil itemValidator:nil]](teamSize);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil maxItems:nil itemValidator:nil]](pendingInvites);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil maxItems:nil itemValidator:nil]](membersJoined);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil maxItems:nil itemValidator:nil]](suspendedMembers);
  [DBStoneValidators nonnullValidator:[DBStoneValidators arrayValidator:nil maxItems:nil itemValidator:nil]](licenses);

  self = [super initWithStartDate:startDate];
  if (self) {
    _teamSize = teamSize;
    _pendingInvites = pendingInvites;
    _membersJoined = membersJoined;
    _suspendedMembers = suspendedMembers;
    _licenses = licenses;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGetMembershipReportSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGetMembershipReportSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGetMembershipReportSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.startDate hash];
  result = prime * result + [self.teamSize hash];
  result = prime * result + [self.pendingInvites hash];
  result = prime * result + [self.membersJoined hash];
  result = prime * result + [self.suspendedMembers hash];
  result = prime * result + [self.licenses hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetMembershipReport:other];
}

- (BOOL)isEqualToGetMembershipReport:(DBTEAMGetMembershipReport *)aGetMembershipReport {
  if (self == aGetMembershipReport) {
    return YES;
  }
  if (![self.startDate isEqual:aGetMembershipReport.startDate]) {
    return NO;
  }
  if (![self.teamSize isEqual:aGetMembershipReport.teamSize]) {
    return NO;
  }
  if (![self.pendingInvites isEqual:aGetMembershipReport.pendingInvites]) {
    return NO;
  }
  if (![self.membersJoined isEqual:aGetMembershipReport.membersJoined]) {
    return NO;
  }
  if (![self.suspendedMembers isEqual:aGetMembershipReport.suspendedMembers]) {
    return NO;
  }
  if (![self.licenses isEqual:aGetMembershipReport.licenses]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGetMembershipReportSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGetMembershipReport *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"start_date"] = valueObj.startDate;
  jsonDict[@"team_size"] = [DBArraySerializer serialize:valueObj.teamSize
                                              withBlock:^id(id elem0) {
                                                return elem0;
                                              }];
  jsonDict[@"pending_invites"] = [DBArraySerializer serialize:valueObj.pendingInvites
                                                    withBlock:^id(id elem0) {
                                                      return elem0;
                                                    }];
  jsonDict[@"members_joined"] = [DBArraySerializer serialize:valueObj.membersJoined
                                                   withBlock:^id(id elem0) {
                                                     return elem0;
                                                   }];
  jsonDict[@"suspended_members"] = [DBArraySerializer serialize:valueObj.suspendedMembers
                                                      withBlock:^id(id elem0) {
                                                        return elem0;
                                                      }];
  jsonDict[@"licenses"] = [DBArraySerializer serialize:valueObj.licenses
                                             withBlock:^id(id elem0) {
                                               return elem0;
                                             }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGetMembershipReport *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *startDate = valueDict[@"start_date"];
  NSArray<NSNumber *> *teamSize = [DBArraySerializer deserialize:valueDict[@"team_size"]
                                                       withBlock:^id(id elem0) {
                                                         return elem0;
                                                       }];
  NSArray<NSNumber *> *pendingInvites = [DBArraySerializer deserialize:valueDict[@"pending_invites"]
                                                             withBlock:^id(id elem0) {
                                                               return elem0;
                                                             }];
  NSArray<NSNumber *> *membersJoined = [DBArraySerializer deserialize:valueDict[@"members_joined"]
                                                            withBlock:^id(id elem0) {
                                                              return elem0;
                                                            }];
  NSArray<NSNumber *> *suspendedMembers = [DBArraySerializer deserialize:valueDict[@"suspended_members"]
                                                               withBlock:^id(id elem0) {
                                                                 return elem0;
                                                               }];
  NSArray<NSNumber *> *licenses = [DBArraySerializer deserialize:valueDict[@"licenses"]
                                                       withBlock:^id(id elem0) {
                                                         return elem0;
                                                       }];

  return [[DBTEAMGetMembershipReport alloc] initWithStartDate:startDate
                                                     teamSize:teamSize
                                               pendingInvites:pendingInvites
                                                membersJoined:membersJoined
                                             suspendedMembers:suspendedMembers
                                                     licenses:licenses];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMBaseDfbReport.h"
#import "DBTEAMGetStorageReport.h"
#import "DBTEAMStorageBucket.h"

#pragma mark - API Object

@implementation DBTEAMGetStorageReport

#pragma mark - Constructors

- (instancetype)initWithStartDate:(NSString *)startDate
                       totalUsage:(NSArray<NSNumber *> *)totalUsage
                      sharedUsage:(NSArray<NSNumber *> *)sharedUsage
                    unsharedUsage:(NSArray<NSNumber *> *)unsharedUsage
                    sharedFolders:(NSArray<NSNumber *> *)sharedFolders
                 memberStorageMap:(NSArray<NSArray<DBTEAMStorageBucket *> *> *)memberStorageMap {
  [DBStoneValidators nonnullValidator:nil](startDate);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil maxItems:nil itemValidator:nil]](totalUsage);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil maxItems:nil itemValidator:nil]](sharedUsage);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil maxItems:nil itemValidator:nil]](unsharedUsage);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil maxItems:nil itemValidator:nil]](sharedFolders);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators
                        arrayValidator:nil
                              maxItems:nil
                         itemValidator:[DBStoneValidators
                                           nonnullValidator:[DBStoneValidators
                                                                arrayValidator:nil
                                                                      maxItems:nil
                                                                 itemValidator:[DBStoneValidators
                                                                                   nonnullValidator:nil]]]]](
      memberStorageMap);

  self = [super initWithStartDate:startDate];
  if (self) {
    _totalUsage = totalUsage;
    _sharedUsage = sharedUsage;
    _unsharedUsage = unsharedUsage;
    _sharedFolders = sharedFolders;
    _memberStorageMap = memberStorageMap;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGetStorageReportSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGetStorageReportSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGetStorageReportSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.startDate hash];
  result = prime * result + [self.totalUsage hash];
  result = prime * result + [self.sharedUsage hash];
  result = prime * result + [self.unsharedUsage hash];
  result = prime * result + [self.sharedFolders hash];
  result = prime * result + [self.memberStorageMap hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetStorageReport:other];
}

- (BOOL)isEqualToGetStorageReport:(DBTEAMGetStorageReport *)aGetStorageReport {
  if (self == aGetStorageReport) {
    return YES;
  }
  if (![self.startDate isEqual:aGetStorageReport.startDate]) {
    return NO;
  }
  if (![self.totalUsage isEqual:aGetStorageReport.totalUsage]) {
    return NO;
  }
  if (![self.sharedUsage isEqual:aGetStorageReport.sharedUsage]) {
    return NO;
  }
  if (![self.unsharedUsage isEqual:aGetStorageReport.unsharedUsage]) {
    return NO;
  }
  if (![self.sharedFolders isEqual:aGetStorageReport.sharedFolders]) {
    return NO;
  }
  if (![self.memberStorageMap isEqual:aGetStorageReport.memberStorageMap]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGetStorageReportSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGetStorageReport *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"start_date"] = valueObj.startDate;
  jsonDict[@"total_usage"] = [DBArraySerializer serialize:valueObj.totalUsage
                                                withBlock:^id(id elem0) {
                                                  return elem0;
                                                }];
  jsonDict[@"shared_usage"] = [DBArraySerializer serialize:valueObj.sharedUsage
                                                 withBlock:^id(id elem0) {
                                                   return elem0;
                                                 }];
  jsonDict[@"unshared_usage"] = [DBArraySerializer serialize:valueObj.unsharedUsage
                                                   withBlock:^id(id elem0) {
                                                     return elem0;
                                                   }];
  jsonDict[@"shared_folders"] = [DBArraySerializer serialize:valueObj.sharedFolders
                                                   withBlock:^id(id elem0) {
                                                     return elem0;
                                                   }];
  jsonDict[@"member_storage_map"] =
      [DBArraySerializer serialize:valueObj.memberStorageMap
                         withBlock:^id(id elem0) {
                           return [DBArraySerializer serialize:elem0
                                                     withBlock:^id(id elem1) {
                                                       return [DBTEAMStorageBucketSerializer serialize:elem1];
                                                     }];
                         }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGetStorageReport *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *startDate = valueDict[@"start_date"];
  NSArray<NSNumber *> *totalUsage = [DBArraySerializer deserialize:valueDict[@"total_usage"]
                                                         withBlock:^id(id elem0) {
                                                           return elem0;
                                                         }];
  NSArray<NSNumber *> *sharedUsage = [DBArraySerializer deserialize:valueDict[@"shared_usage"]
                                                          withBlock:^id(id elem0) {
                                                            return elem0;
                                                          }];
  NSArray<NSNumber *> *unsharedUsage = [DBArraySerializer deserialize:valueDict[@"unshared_usage"]
                                                            withBlock:^id(id elem0) {
                                                              return elem0;
                                                            }];
  NSArray<NSNumber *> *sharedFolders = [DBArraySerializer deserialize:valueDict[@"shared_folders"]
                                                            withBlock:^id(id elem0) {
                                                              return elem0;
                                                            }];
  NSArray<NSArray<DBTEAMStorageBucket *> *> *memberStorageMap =
      [DBArraySerializer deserialize:valueDict[@"member_storage_map"]
                           withBlock:^id(id elem0) {
                             return [DBArraySerializer deserialize:elem0
                                                         withBlock:^id(id elem1) {
                                                           return [DBTEAMStorageBucketSerializer deserialize:elem1];
                                                         }];
                           }];

  return [[DBTEAMGetStorageReport alloc] initWithStartDate:startDate
                                                totalUsage:totalUsage
                                               sharedUsage:sharedUsage
                                             unsharedUsage:unsharedUsage
                                             sharedFolders:sharedFolders
                                          memberStorageMap:memberStorageMap];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMGroupAccessType.h"

#pragma mark - API Object

@implementation DBTEAMGroupAccessType

#pragma mark - Constructors

- (instancetype)initWithMember {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupAccessTypeMember;
  }
  return self;
}

- (instancetype)initWithOwner {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupAccessTypeOwner;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isMember {
  return _tag == DBTEAMGroupAccessTypeMember;
}

- (BOOL)isOwner {
  return _tag == DBTEAMGroupAccessTypeOwner;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMGroupAccessTypeMember:
    return @"DBTEAMGroupAccessTypeMember";
  case DBTEAMGroupAccessTypeOwner:
    return @"DBTEAMGroupAccessTypeOwner";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGroupAccessTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGroupAccessTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGroupAccessTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMGroupAccessTypeMember:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupAccessTypeOwner:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupAccessType:other];
}

- (BOOL)isEqualToGroupAccessType:(DBTEAMGroupAccessType *)aGroupAccessType {
  if (self == aGroupAccessType) {
    return YES;
  }
  if (self.tag != aGroupAccessType.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMGroupAccessTypeMember:
    return [[self tagName] isEqual:[aGroupAccessType tagName]];
  case DBTEAMGroupAccessTypeOwner:
    return [[self tagName] isEqual:[aGroupAccessType tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGroupAccessTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupAccessType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isMember]) {
    jsonDict[@".tag"] = @"member";
  } else if ([valueObj isOwner]) {
    jsonDict[@".tag"] = @"owner";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGroupAccessType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"member"]) {
    return [[DBTEAMGroupAccessType alloc] initWithMember];
  } else if ([tag isEqualToString:@"owner"]) {
    return [[DBTEAMGroupAccessType alloc] initWithOwner];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMCOMMONGroupManagementType.h"
#import "DBTEAMGroupCreateArg.h"

#pragma mark - API Object

@implementation DBTEAMGroupCreateArg

#pragma mark - Constructors

- (instancetype)initWithGroupName:(NSString *)groupName
                addCreatorAsOwner:(NSNumber *)addCreatorAsOwner
                  groupExternalId:(NSString *)groupExternalId
              groupManagementType:(DBTEAMCOMMONGroupManagementType *)groupManagementType {
  [DBStoneValidators nonnullValidator:nil](groupName);

  self = [super init];
  if (self) {
    _groupName = groupName;
    _addCreatorAsOwner = addCreatorAsOwner ?: @NO;
    _groupExternalId = groupExternalId;
    _groupManagementType = groupManagementType;
  }
  return self;
}

- (instancetype)initWithGroupName:(NSString *)groupName {
  return [self initWithGroupName:groupName addCreatorAsOwner:nil groupExternalId:nil groupManagementType:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGroupCreateArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGroupCreateArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGroupCreateArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.groupName hash];
  result = prime * result + [self.addCreatorAsOwner hash];
  if (self.groupExternalId != nil) {
    result = prime * result + [self.groupExternalId hash];
  }
  if (self.groupManagementType != nil) {
    result = prime * result + [self.groupManagementType hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupCreateArg:other];
}

- (BOOL)isEqualToGroupCreateArg:(DBTEAMGroupCreateArg *)aGroupCreateArg {
  if (self == aGroupCreateArg) {
    return YES;
  }
  if (![self.groupName isEqual:aGroupCreateArg.groupName]) {
    return NO;
  }
  if (![self.addCreatorAsOwner isEqual:aGroupCreateArg.addCreatorAsOwner]) {
    return NO;
  }
  if (self.groupExternalId) {
    if (![self.groupExternalId isEqual:aGroupCreateArg.groupExternalId]) {
      return NO;
    }
  }
  if (self.groupManagementType) {
    if (![self.groupManagementType isEqual:aGroupCreateArg.groupManagementType]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGroupCreateArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupCreateArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"group_name"] = valueObj.groupName;
  jsonDict[@"add_creator_as_owner"] = valueObj.addCreatorAsOwner;
  if (valueObj.groupExternalId) {
    jsonDict[@"group_external_id"] = valueObj.groupExternalId;
  }
  if (valueObj.groupManagementType) {
    jsonDict[@"group_management_type"] =
        [DBTEAMCOMMONGroupManagementTypeSerializer serialize:valueObj.groupManagementType];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGroupCreateArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *groupName = valueDict[@"group_name"];
  NSNumber *addCreatorAsOwner = valueDict[@"add_creator_as_owner"] ?: @NO;
  NSString *groupExternalId = valueDict[@"group_external_id"] ?: nil;
  DBTEAMCOMMONGroupManagementType *groupManagementType =
      valueDict[@"group_management_type"]
          ? [DBTEAMCOMMONGroupManagementTypeSerializer deserialize:valueDict[@"group_management_type"]]
          : nil;

  return [[DBTEAMGroupCreateArg alloc] initWithGroupName:groupName
                                       addCreatorAsOwner:addCreatorAsOwner
                                         groupExternalId:groupExternalId
                                     groupManagementType:groupManagementType];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMGroupCreateError.h"

#pragma mark - API Object

@implementation DBTEAMGroupCreateError

#pragma mark - Constructors

- (instancetype)initWithGroupNameAlreadyUsed {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupCreateErrorGroupNameAlreadyUsed;
  }
  return self;
}

- (instancetype)initWithGroupNameInvalid {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupCreateErrorGroupNameInvalid;
  }
  return self;
}

- (instancetype)initWithExternalIdAlreadyInUse {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupCreateErrorExternalIdAlreadyInUse;
  }
  return self;
}

- (instancetype)initWithSystemManagedGroupDisallowed {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupCreateErrorSystemManagedGroupDisallowed;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupCreateErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isGroupNameAlreadyUsed {
  return _tag == DBTEAMGroupCreateErrorGroupNameAlreadyUsed;
}

- (BOOL)isGroupNameInvalid {
  return _tag == DBTEAMGroupCreateErrorGroupNameInvalid;
}

- (BOOL)isExternalIdAlreadyInUse {
  return _tag == DBTEAMGroupCreateErrorExternalIdAlreadyInUse;
}

- (BOOL)isSystemManagedGroupDisallowed {
  return _tag == DBTEAMGroupCreateErrorSystemManagedGroupDisallowed;
}

- (BOOL)isOther {
  return _tag == DBTEAMGroupCreateErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMGroupCreateErrorGroupNameAlreadyUsed:
    return @"DBTEAMGroupCreateErrorGroupNameAlreadyUsed";
  case DBTEAMGroupCreateErrorGroupNameInvalid:
    return @"DBTEAMGroupCreateErrorGroupNameInvalid";
  case DBTEAMGroupCreateErrorExternalIdAlreadyInUse:
    return @"DBTEAMGroupCreateErrorExternalIdAlreadyInUse";
  case DBTEAMGroupCreateErrorSystemManagedGroupDisallowed:
    return @"DBTEAMGroupCreateErrorSystemManagedGroupDisallowed";
  case DBTEAMGroupCreateErrorOther:
    return @"DBTEAMGroupCreateErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGroupCreateErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGroupCreateErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGroupCreateErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMGroupCreateErrorGroupNameAlreadyUsed:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupCreateErrorGroupNameInvalid:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupCreateErrorExternalIdAlreadyInUse:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupCreateErrorSystemManagedGroupDisallowed:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupCreateErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupCreateError:other];
}

- (BOOL)isEqualToGroupCreateError:(DBTEAMGroupCreateError *)aGroupCreateError {
  if (self == aGroupCreateError) {
    return YES;
  }
  if (self.tag != aGroupCreateError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMGroupCreateErrorGroupNameAlreadyUsed:
    return [[self tagName] isEqual:[aGroupCreateError tagName]];
  case DBTEAMGroupCreateErrorGroupNameInvalid:
    return [[self tagName] isEqual:[aGroupCreateError tagName]];
  case DBTEAMGroupCreateErrorExternalIdAlreadyInUse:
    return [[self tagName] isEqual:[aGroupCreateError tagName]];
  case DBTEAMGroupCreateErrorSystemManagedGroupDisallowed:
    return [[self tagName] isEqual:[aGroupCreateError tagName]];
  case DBTEAMGroupCreateErrorOther:
    return [[self tagName] isEqual:[aGroupCreateError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGroupCreateErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupCreateError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isGroupNameAlreadyUsed]) {
    jsonDict[@".tag"] = @"group_name_already_used";
  } else if ([valueObj isGroupNameInvalid]) {
    jsonDict[@".tag"] = @"group_name_invalid";
  } else if ([valueObj isExternalIdAlreadyInUse]) {
    jsonDict[@".tag"] = @"external_id_already_in_use";
  } else if ([valueObj isSystemManagedGroupDisallowed]) {
    jsonDict[@".tag"] = @"system_managed_group_disallowed";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGroupCreateError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"group_name_already_used"]) {
    return [[DBTEAMGroupCreateError alloc] initWithGroupNameAlreadyUsed];
  } else if ([tag isEqualToString:@"group_name_invalid"]) {
    return [[DBTEAMGroupCreateError alloc] initWithGroupNameInvalid];
  } else if ([tag isEqualToString:@"external_id_already_in_use"]) {
    return [[DBTEAMGroupCreateError alloc] initWithExternalIdAlreadyInUse];
  } else if ([tag isEqualToString:@"system_managed_group_disallowed"]) {
    return [[DBTEAMGroupCreateError alloc] initWithSystemManagedGroupDisallowed];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMGroupCreateError alloc] initWithOther];
  } else {
    return [[DBTEAMGroupCreateError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMGroupSelectorError.h"

#pragma mark - API Object

@implementation DBTEAMGroupSelectorError

#pragma mark - Constructors

- (instancetype)initWithGroupNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupSelectorErrorGroupNotFound;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupSelectorErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isGroupNotFound {
  return _tag == DBTEAMGroupSelectorErrorGroupNotFound;
}

- (BOOL)isOther {
  return _tag == DBTEAMGroupSelectorErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMGroupSelectorErrorGroupNotFound:
    return @"DBTEAMGroupSelectorErrorGroupNotFound";
  case DBTEAMGroupSelectorErrorOther:
    return @"DBTEAMGroupSelectorErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGroupSelectorErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGroupSelectorErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGroupSelectorErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMGroupSelectorErrorGroupNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupSelectorErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupSelectorError:other];
}

- (BOOL)isEqualToGroupSelectorError:(DBTEAMGroupSelectorError *)aGroupSelectorError {
  if (self == aGroupSelectorError) {
    return YES;
  }
  if (self.tag != aGroupSelectorError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMGroupSelectorErrorGroupNotFound:
    return [[self tagName] isEqual:[aGroupSelectorError tagName]];
  case DBTEAMGroupSelectorErrorOther:
    return [[self tagName] isEqual:[aGroupSelectorError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGroupSelectorErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupSelectorError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isGroupNotFound]) {
    jsonDict[@".tag"] = @"group_not_found";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGroupSelectorError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"group_not_found"]) {
    return [[DBTEAMGroupSelectorError alloc] initWithGroupNotFound];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMGroupSelectorError alloc] initWithOther];
  } else {
    return [[DBTEAMGroupSelectorError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMGroupSelectorError.h"
#import "DBTEAMGroupSelectorWithTeamGroupError.h"

#pragma mark - API Object

@implementation DBTEAMGroupSelectorWithTeamGroupError

#pragma mark - Constructors

- (instancetype)initWithGroupNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupSelectorWithTeamGroupErrorGroupNotFound;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupSelectorWithTeamGroupErrorOther;
  }
  return self;
}

- (instancetype)initWithSystemManagedGroupDisallowed {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupSelectorWithTeamGroupErrorSystemManagedGroupDisallowed;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isGroupNotFound {
  return _tag == DBTEAMGroupSelectorWithTeamGroupErrorGroupNotFound;
}

- (BOOL)isOther {
  return _tag == DBTEAMGroupSelectorWithTeamGroupErrorOther;
}

- (BOOL)isSystemManagedGroupDisallowed {
  return _tag == DBTEAMGroupSelectorWithTeamGroupErrorSystemManagedGroupDisallowed;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMGroupSelectorWithTeamGroupErrorGroupNotFound:
    return @"DBTEAMGroupSelectorWithTeamGroupErrorGroupNotFound";
  case DBTEAMGroupSelectorWithTeamGroupErrorOther:
    return @"DBTEAMGroupSelectorWithTeamGroupErrorOther";
  case DBTEAMGroupSelectorWithTeamGroupErrorSystemManagedGroupDisallowed:
    return @"DBTEAMGroupSelectorWithTeamGroupErrorSystemManagedGroupDisallowed";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGroupSelectorWithTeamGroupErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGroupSelectorWithTeamGroupErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGroupSelectorWithTeamGroupErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMGroupSelectorWithTeamGroupErrorGroupNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupSelectorWithTeamGroupErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupSelectorWithTeamGroupErrorSystemManagedGroupDisallowed:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupSelectorWithTeamGroupError:other];
}

- (BOOL)isEqualToGroupSelectorWithTeamGroupError:
    (DBTEAMGroupSelectorWithTeamGroupError *)aGroupSelectorWithTeamGroupError {
  if (self == aGroupSelectorWithTeamGroupError) {
    return YES;
  }
  if (self.tag != aGroupSelectorWithTeamGroupError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMGroupSelectorWithTeamGroupErrorGroupNotFound:
    return [[self tagName] isEqual:[aGroupSelectorWithTeamGroupError tagName]];
  case DBTEAMGroupSelectorWithTeamGroupErrorOther:
    return [[self tagName] isEqual:[aGroupSelectorWithTeamGroupError tagName]];
  case DBTEAMGroupSelectorWithTeamGroupErrorSystemManagedGroupDisallowed:
    return [[self tagName] isEqual:[aGroupSelectorWithTeamGroupError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGroupSelectorWithTeamGroupErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupSelectorWithTeamGroupError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isGroupNotFound]) {
    jsonDict[@".tag"] = @"group_not_found";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isSystemManagedGroupDisallowed]) {
    jsonDict[@".tag"] = @"system_managed_group_disallowed";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGroupSelectorWithTeamGroupError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"group_not_found"]) {
    return [[DBTEAMGroupSelectorWithTeamGroupError alloc] initWithGroupNotFound];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMGroupSelectorWithTeamGroupError alloc] initWithOther];
  } else if ([tag isEqualToString:@"system_managed_group_disallowed"]) {
    return [[DBTEAMGroupSelectorWithTeamGroupError alloc] initWithSystemManagedGroupDisallowed];
  } else {
    return [[DBTEAMGroupSelectorWithTeamGroupError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMGroupDeleteError.h"
#import "DBTEAMGroupSelectorWithTeamGroupError.h"

#pragma mark - API Object

@implementation DBTEAMGroupDeleteError

#pragma mark - Constructors

- (instancetype)initWithGroupNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupDeleteErrorGroupNotFound;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupDeleteErrorOther;
  }
  return self;
}

- (instancetype)initWithSystemManagedGroupDisallowed {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupDeleteErrorSystemManagedGroupDisallowed;
  }
  return self;
}

- (instancetype)initWithGroupAlreadyDeleted {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupDeleteErrorGroupAlreadyDeleted;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isGroupNotFound {
  return _tag == DBTEAMGroupDeleteErrorGroupNotFound;
}

- (BOOL)isOther {
  return _tag == DBTEAMGroupDeleteErrorOther;
}

- (BOOL)isSystemManagedGroupDisallowed {
  return _tag == DBTEAMGroupDeleteErrorSystemManagedGroupDisallowed;
}

- (BOOL)isGroupAlreadyDeleted {
  return _tag == DBTEAMGroupDeleteErrorGroupAlreadyDeleted;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMGroupDeleteErrorGroupNotFound:
    return @"DBTEAMGroupDeleteErrorGroupNotFound";
  case DBTEAMGroupDeleteErrorOther:
    return @"DBTEAMGroupDeleteErrorOther";
  case DBTEAMGroupDeleteErrorSystemManagedGroupDisallowed:
    return @"DBTEAMGroupDeleteErrorSystemManagedGroupDisallowed";
  case DBTEAMGroupDeleteErrorGroupAlreadyDeleted:
    return @"DBTEAMGroupDeleteErrorGroupAlreadyDeleted";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGroupDeleteErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGroupDeleteErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGroupDeleteErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMGroupDeleteErrorGroupNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupDeleteErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupDeleteErrorSystemManagedGroupDisallowed:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupDeleteErrorGroupAlreadyDeleted:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupDeleteError:other];
}

- (BOOL)isEqualToGroupDeleteError:(DBTEAMGroupDeleteError *)aGroupDeleteError {
  if (self == aGroupDeleteError) {
    return YES;
  }
  if (self.tag != aGroupDeleteError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMGroupDeleteErrorGroupNotFound:
    return [[self tagName] isEqual:[aGroupDeleteError tagName]];
  case DBTEAMGroupDeleteErrorOther:
    return [[self tagName] isEqual:[aGroupDeleteError tagName]];
  case DBTEAMGroupDeleteErrorSystemManagedGroupDisallowed:
    return [[self tagName] isEqual:[aGroupDeleteError tagName]];
  case DBTEAMGroupDeleteErrorGroupAlreadyDeleted:
    return [[self tagName] isEqual:[aGroupDeleteError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGroupDeleteErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupDeleteError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isGroupNotFound]) {
    jsonDict[@".tag"] = @"group_not_found";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isSystemManagedGroupDisallowed]) {
    jsonDict[@".tag"] = @"system_managed_group_disallowed";
  } else if ([valueObj isGroupAlreadyDeleted]) {
    jsonDict[@".tag"] = @"group_already_deleted";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGroupDeleteError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"group_not_found"]) {
    return [[DBTEAMGroupDeleteError alloc] initWithGroupNotFound];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMGroupDeleteError alloc] initWithOther];
  } else if ([tag isEqualToString:@"system_managed_group_disallowed"]) {
    return [[DBTEAMGroupDeleteError alloc] initWithSystemManagedGroupDisallowed];
  } else if ([tag isEqualToString:@"group_already_deleted"]) {
    return [[DBTEAMGroupDeleteError alloc] initWithGroupAlreadyDeleted];
  } else {
    return [[DBTEAMGroupDeleteError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMCOMMONGroupManagementType.h"
#import "DBTEAMCOMMONGroupSummary.h"
#import "DBTEAMGroupFullInfo.h"
#import "DBTEAMGroupMemberInfo.h"

#pragma mark - API Object

@implementation DBTEAMGroupFullInfo

#pragma mark - Constructors

- (instancetype)initWithGroupName:(NSString *)groupName
                          groupId:(NSString *)groupId
              groupManagementType:(DBTEAMCOMMONGroupManagementType *)groupManagementType
                          created:(NSNumber *)created
                  groupExternalId:(NSString *)groupExternalId
                      memberCount:(NSNumber *)memberCount
                          members:(NSArray<DBTEAMGroupMemberInfo *> *)members {
  [DBStoneValidators nonnullValidator:nil](groupName);
  [DBStoneValidators nonnullValidator:nil](groupId);
  [DBStoneValidators nonnullValidator:nil](groupManagementType);
  [DBStoneValidators nonnullValidator:nil](created);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](members);

  self = [super initWithGroupName:groupName
                          groupId:groupId
              groupManagementType:groupManagementType
                  groupExternalId:groupExternalId
                      memberCount:memberCount];
  if (self) {
    _members = members;
    _created = created;
  }
  return self;
}

- (instancetype)initWithGroupName:(NSString *)groupName
                          groupId:(NSString *)groupId
              groupManagementType:(DBTEAMCOMMONGroupManagementType *)groupManagementType
                          created:(NSNumber *)created {
  return [self initWithGroupName:groupName
                         groupId:groupId
             groupManagementType:groupManagementType
                         created:created
                 groupExternalId:nil
                     memberCount:nil
                         members:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGroupFullInfoSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGroupFullInfoSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGroupFullInfoSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.groupName hash];
  result = prime * result + [self.groupId hash];
  result = prime * result + [self.groupManagementType hash];
  result = prime * result + [self.created hash];
  if (self.groupExternalId != nil) {
    result = prime * result + [self.groupExternalId hash];
  }
  if (self.memberCount != nil) {
    result = prime * result + [self.memberCount hash];
  }
  if (self.members != nil) {
    result = prime * result + [self.members hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupFullInfo:other];
}

- (BOOL)isEqualToGroupFullInfo:(DBTEAMGroupFullInfo *)aGroupFullInfo {
  if (self == aGroupFullInfo) {
    return YES;
  }
  if (![self.groupName isEqual:aGroupFullInfo.groupName]) {
    return NO;
  }
  if (![self.groupId isEqual:aGroupFullInfo.groupId]) {
    return NO;
  }
  if (![self.groupManagementType isEqual:aGroupFullInfo.groupManagementType]) {
    return NO;
  }
  if (![self.created isEqual:aGroupFullInfo.created]) {
    return NO;
  }
  if (self.groupExternalId) {
    if (![self.groupExternalId isEqual:aGroupFullInfo.groupExternalId]) {
      return NO;
    }
  }
  if (self.memberCount) {
    if (![self.memberCount isEqual:aGroupFullInfo.memberCount]) {
      return NO;
    }
  }
  if (self.members) {
    if (![self.members isEqual:aGroupFullInfo.members]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGroupFullInfoSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupFullInfo *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"group_name"] = valueObj.groupName;
  jsonDict[@"group_id"] = valueObj.groupId;
  jsonDict[@"group_management_type"] =
      [DBTEAMCOMMONGroupManagementTypeSerializer serialize:valueObj.groupManagementType];
  jsonDict[@"created"] = valueObj.created;
  if (valueObj.groupExternalId) {
    jsonDict[@"group_external_id"] = valueObj.groupExternalId;
  }
  if (valueObj.memberCount) {
    jsonDict[@"member_count"] = valueObj.memberCount;
  }
  if (valueObj.members) {
    jsonDict[@"members"] = [DBArraySerializer serialize:valueObj.members
                                              withBlock:^id(id elem0) {
                                                return [DBTEAMGroupMemberInfoSerializer serialize:elem0];
                                              }];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGroupFullInfo *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *groupName = valueDict[@"group_name"];
  NSString *groupId = valueDict[@"group_id"];
  DBTEAMCOMMONGroupManagementType *groupManagementType =
      [DBTEAMCOMMONGroupManagementTypeSerializer deserialize:valueDict[@"group_management_type"]];
  NSNumber *created = valueDict[@"created"];
  NSString *groupExternalId = valueDict[@"group_external_id"] ?: nil;
  NSNumber *memberCount = valueDict[@"member_count"] ?: nil;
  NSArray<DBTEAMGroupMemberInfo *> *members =
      valueDict[@"members"] ? [DBArraySerializer deserialize:valueDict[@"members"]
                                                   withBlock:^id(id elem0) {
                                                     return [DBTEAMGroupMemberInfoSerializer deserialize:elem0];
                                                   }]
                            : nil;

  return [[DBTEAMGroupFullInfo alloc] initWithGroupName:groupName
                                                groupId:groupId
                                    groupManagementType:groupManagementType
                                                created:created
                                        groupExternalId:groupExternalId
                                            memberCount:memberCount
                                                members:members];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMGroupAccessType.h"
#import "DBTEAMGroupMemberInfo.h"
#import "DBTEAMMemberProfile.h"

#pragma mark - API Object

@implementation DBTEAMGroupMemberInfo

#pragma mark - Constructors

- (instancetype)initWithProfile:(DBTEAMMemberProfile *)profile accessType:(DBTEAMGroupAccessType *)accessType {
  [DBStoneValidators nonnullValidator:nil](profile);
  [DBStoneValidators nonnullValidator:nil](accessType);

  self = [super init];
  if (self) {
    _profile = profile;
    _accessType = accessType;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGroupMemberInfoSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGroupMemberInfoSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGroupMemberInfoSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.profile hash];
  result = prime * result + [self.accessType hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupMemberInfo:other];
}

- (BOOL)isEqualToGroupMemberInfo:(DBTEAMGroupMemberInfo *)aGroupMemberInfo {
  if (self == aGroupMemberInfo) {
    return YES;
  }
  if (![self.profile isEqual:aGroupMemberInfo.profile]) {
    return NO;
  }
  if (![self.accessType isEqual:aGroupMemberInfo.accessType]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGroupMemberInfoSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupMemberInfo *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"profile"] = [DBTEAMMemberProfileSerializer serialize:valueObj.profile];
  jsonDict[@"access_type"] = [DBTEAMGroupAccessTypeSerializer serialize:valueObj.accessType];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGroupMemberInfo *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMMemberProfile *profile = [DBTEAMMemberProfileSerializer deserialize:valueDict[@"profile"]];
  DBTEAMGroupAccessType *accessType = [DBTEAMGroupAccessTypeSerializer deserialize:valueDict[@"access_type"]];

  return [[DBTEAMGroupMemberInfo alloc] initWithProfile:profile accessType:accessType];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMGroupMemberSelector.h"
#import "DBTEAMGroupSelector.h"
#import "DBTEAMUserSelectorArg.h"

#pragma mark - API Object

@implementation DBTEAMGroupMemberSelector

#pragma mark - Constructors

- (instancetype)initWithGroup:(DBTEAMGroupSelector *)group user:(DBTEAMUserSelectorArg *)user {
  [DBStoneValidators nonnullValidator:nil](group);
  [DBStoneValidators nonnullValidator:nil](user);

  self = [super init];
  if (self) {
    _group = group;
    _user = user;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGroupMemberSelectorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGroupMemberSelectorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGroupMemberSelectorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.group hash];
  result = prime * result + [self.user hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupMemberSelector:other];
}

- (BOOL)isEqualToGroupMemberSelector:(DBTEAMGroupMemberSelector *)aGroupMemberSelector {
  if (self == aGroupMemberSelector) {
    return YES;
  }
  if (![self.group isEqual:aGroupMemberSelector.group]) {
    return NO;
  }
  if (![self.user isEqual:aGroupMemberSelector.user]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGroupMemberSelectorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupMemberSelector *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"group"] = [DBTEAMGroupSelectorSerializer serialize:valueObj.group];
  jsonDict[@"user"] = [DBTEAMUserSelectorArgSerializer serialize:valueObj.user];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGroupMemberSelector *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMGroupSelector *group = [DBTEAMGroupSelectorSerializer deserialize:valueDict[@"group"]];
  DBTEAMUserSelectorArg *user = [DBTEAMUserSelectorArgSerializer deserialize:valueDict[@"user"]];

  return [[DBTEAMGroupMemberSelector alloc] initWithGroup:group user:user];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMGroupMemberSelectorError.h"
#import "DBTEAMGroupSelectorWithTeamGroupError.h"

#pragma mark - API Object

@implementation DBTEAMGroupMemberSelectorError

#pragma mark - Constructors

- (instancetype)initWithGroupNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupMemberSelectorErrorGroupNotFound;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupMemberSelectorErrorOther;
  }
  return self;
}

- (instancetype)initWithSystemManagedGroupDisallowed {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupMemberSelectorErrorSystemManagedGroupDisallowed;
  }
  return self;
}

- (instancetype)initWithMemberNotInGroup {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupMemberSelectorErrorMemberNotInGroup;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isGroupNotFound {
  return _tag == DBTEAMGroupMemberSelectorErrorGroupNotFound;
}

- (BOOL)isOther {
  return _tag == DBTEAMGroupMemberSelectorErrorOther;
}

- (BOOL)isSystemManagedGroupDisallowed {
  return _tag == DBTEAMGroupMemberSelectorErrorSystemManagedGroupDisallowed;
}

- (BOOL)isMemberNotInGroup {
  return _tag == DBTEAMGroupMemberSelectorErrorMemberNotInGroup;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMGroupMemberSelectorErrorGroupNotFound:
    return @"DBTEAMGroupMemberSelectorErrorGroupNotFound";
  case DBTEAMGroupMemberSelectorErrorOther:
    return @"DBTEAMGroupMemberSelectorErrorOther";
  case DBTEAMGroupMemberSelectorErrorSystemManagedGroupDisallowed:
    return @"DBTEAMGroupMemberSelectorErrorSystemManagedGroupDisallowed";
  case DBTEAMGroupMemberSelectorErrorMemberNotInGroup:
    return @"DBTEAMGroupMemberSelectorErrorMemberNotInGroup";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGroupMemberSelectorErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGroupMemberSelectorErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGroupMemberSelectorErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMGroupMemberSelectorErrorGroupNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupMemberSelectorErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupMemberSelectorErrorSystemManagedGroupDisallowed:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupMemberSelectorErrorMemberNotInGroup:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupMemberSelectorError:other];
}

- (BOOL)isEqualToGroupMemberSelectorError:(DBTEAMGroupMemberSelectorError *)aGroupMemberSelectorError {
  if (self == aGroupMemberSelectorError) {
    return YES;
  }
  if (self.tag != aGroupMemberSelectorError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMGroupMemberSelectorErrorGroupNotFound:
    return [[self tagName] isEqual:[aGroupMemberSelectorError tagName]];
  case DBTEAMGroupMemberSelectorErrorOther:
    return [[self tagName] isEqual:[aGroupMemberSelectorError tagName]];
  case DBTEAMGroupMemberSelectorErrorSystemManagedGroupDisallowed:
    return [[self tagName] isEqual:[aGroupMemberSelectorError tagName]];
  case DBTEAMGroupMemberSelectorErrorMemberNotInGroup:
    return [[self tagName] isEqual:[aGroupMemberSelectorError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGroupMemberSelectorErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupMemberSelectorError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isGroupNotFound]) {
    jsonDict[@".tag"] = @"group_not_found";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isSystemManagedGroupDisallowed]) {
    jsonDict[@".tag"] = @"system_managed_group_disallowed";
  } else if ([valueObj isMemberNotInGroup]) {
    jsonDict[@".tag"] = @"member_not_in_group";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGroupMemberSelectorError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"group_not_found"]) {
    return [[DBTEAMGroupMemberSelectorError alloc] initWithGroupNotFound];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMGroupMemberSelectorError alloc] initWithOther];
  } else if ([tag isEqualToString:@"system_managed_group_disallowed"]) {
    return [[DBTEAMGroupMemberSelectorError alloc] initWithSystemManagedGroupDisallowed];
  } else if ([tag isEqualToString:@"member_not_in_group"]) {
    return [[DBTEAMGroupMemberSelectorError alloc] initWithMemberNotInGroup];
  } else {
    return [[DBTEAMGroupMemberSelectorError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMGroupMemberSelectorError.h"
#import "DBTEAMGroupMemberSetAccessTypeError.h"

#pragma mark - API Object

@implementation DBTEAMGroupMemberSetAccessTypeError

#pragma mark - Constructors

- (instancetype)initWithGroupNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupMemberSetAccessTypeErrorGroupNotFound;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupMemberSetAccessTypeErrorOther;
  }
  return self;
}

- (instancetype)initWithSystemManagedGroupDisallowed {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupMemberSetAccessTypeErrorSystemManagedGroupDisallowed;
  }
  return self;
}

- (instancetype)initWithMemberNotInGroup {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupMemberSetAccessTypeErrorMemberNotInGroup;
  }
  return self;
}

- (instancetype)initWithUserCannotBeManagerOfCompanyManagedGroup {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupMemberSetAccessTypeErrorUserCannotBeManagerOfCompanyManagedGroup;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isGroupNotFound {
  return _tag == DBTEAMGroupMemberSetAccessTypeErrorGroupNotFound;
}

- (BOOL)isOther {
  return _tag == DBTEAMGroupMemberSetAccessTypeErrorOther;
}

- (BOOL)isSystemManagedGroupDisallowed {
  return _tag == DBTEAMGroupMemberSetAccessTypeErrorSystemManagedGroupDisallowed;
}

- (BOOL)isMemberNotInGroup {
  return _tag == DBTEAMGroupMemberSetAccessTypeErrorMemberNotInGroup;
}

- (BOOL)isUserCannotBeManagerOfCompanyManagedGroup {
  return _tag == DBTEAMGroupMemberSetAccessTypeErrorUserCannotBeManagerOfCompanyManagedGroup;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMGroupMemberSetAccessTypeErrorGroupNotFound:
    return @"DBTEAMGroupMemberSetAccessTypeErrorGroupNotFound";
  case DBTEAMGroupMemberSetAccessTypeErrorOther:
    return @"DBTEAMGroupMemberSetAccessTypeErrorOther";
  case DBTEAMGroupMemberSetAccessTypeErrorSystemManagedGroupDisallowed:
    return @"DBTEAMGroupMemberSetAccessTypeErrorSystemManagedGroupDisallowed";
  case DBTEAMGroupMemberSetAccessTypeErrorMemberNotInGroup:
    return @"DBTEAMGroupMemberSetAccessTypeErrorMemberNotInGroup";
  case DBTEAMGroupMemberSetAccessTypeErrorUserCannotBeManagerOfCompanyManagedGroup:
    return @"DBTEAMGroupMemberSetAccessTypeErrorUserCannotBeManagerOfCompanyManagedGroup";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGroupMemberSetAccessTypeErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGroupMemberSetAccessTypeErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGroupMemberSetAccessTypeErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMGroupMemberSetAccessTypeErrorGroupNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupMemberSetAccessTypeErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupMemberSetAccessTypeErrorSystemManagedGroupDisallowed:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupMemberSetAccessTypeErrorMemberNotInGroup:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupMemberSetAccessTypeErrorUserCannotBeManagerOfCompanyManagedGroup:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupMemberSetAccessTypeError:other];
}

- (BOOL)isEqualToGroupMemberSetAccessTypeError:(DBTEAMGroupMemberSetAccessTypeError *)aGroupMemberSetAccessTypeError {
  if (self == aGroupMemberSetAccessTypeError) {
    return YES;
  }
  if (self.tag != aGroupMemberSetAccessTypeError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMGroupMemberSetAccessTypeErrorGroupNotFound:
    return [[self tagName] isEqual:[aGroupMemberSetAccessTypeError tagName]];
  case DBTEAMGroupMemberSetAccessTypeErrorOther:
    return [[self tagName] isEqual:[aGroupMemberSetAccessTypeError tagName]];
  case DBTEAMGroupMemberSetAccessTypeErrorSystemManagedGroupDisallowed:
    return [[self tagName] isEqual:[aGroupMemberSetAccessTypeError tagName]];
  case DBTEAMGroupMemberSetAccessTypeErrorMemberNotInGroup:
    return [[self tagName] isEqual:[aGroupMemberSetAccessTypeError tagName]];
  case DBTEAMGroupMemberSetAccessTypeErrorUserCannotBeManagerOfCompanyManagedGroup:
    return [[self tagName] isEqual:[aGroupMemberSetAccessTypeError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGroupMemberSetAccessTypeErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupMemberSetAccessTypeError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isGroupNotFound]) {
    jsonDict[@".tag"] = @"group_not_found";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isSystemManagedGroupDisallowed]) {
    jsonDict[@".tag"] = @"system_managed_group_disallowed";
  } else if ([valueObj isMemberNotInGroup]) {
    jsonDict[@".tag"] = @"member_not_in_group";
  } else if ([valueObj isUserCannotBeManagerOfCompanyManagedGroup]) {
    jsonDict[@".tag"] = @"user_cannot_be_manager_of_company_managed_group";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGroupMemberSetAccessTypeError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"group_not_found"]) {
    return [[DBTEAMGroupMemberSetAccessTypeError alloc] initWithGroupNotFound];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMGroupMemberSetAccessTypeError alloc] initWithOther];
  } else if ([tag isEqualToString:@"system_managed_group_disallowed"]) {
    return [[DBTEAMGroupMemberSetAccessTypeError alloc] initWithSystemManagedGroupDisallowed];
  } else if ([tag isEqualToString:@"member_not_in_group"]) {
    return [[DBTEAMGroupMemberSetAccessTypeError alloc] initWithMemberNotInGroup];
  } else if ([tag isEqualToString:@"user_cannot_be_manager_of_company_managed_group"]) {
    return [[DBTEAMGroupMemberSetAccessTypeError alloc] initWithUserCannotBeManagerOfCompanyManagedGroup];
  } else {
    return [[DBTEAMGroupMemberSetAccessTypeError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMIncludeMembersArg.h"

#pragma mark - API Object

@implementation DBTEAMIncludeMembersArg

#pragma mark - Constructors

- (instancetype)initWithReturnMembers:(NSNumber *)returnMembers {

  self = [super init];
  if (self) {
    _returnMembers = returnMembers ?: @YES;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithReturnMembers:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMIncludeMembersArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMIncludeMembersArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMIncludeMembersArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.returnMembers hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToIncludeMembersArg:other];
}

- (BOOL)isEqualToIncludeMembersArg:(DBTEAMIncludeMembersArg *)anIncludeMembersArg {
  if (self == anIncludeMembersArg) {
    return YES;
  }
  if (![self.returnMembers isEqual:anIncludeMembersArg.returnMembers]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMIncludeMembersArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMIncludeMembersArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"return_members"] = valueObj.returnMembers;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMIncludeMembersArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSNumber *returnMembers = valueDict[@"return_members"] ?: @YES;

  return [[DBTEAMIncludeMembersArg alloc] initWithReturnMembers:returnMembers];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMGroupMembersAddArg.h"
#import "DBTEAMGroupSelector.h"
#import "DBTEAMIncludeMembersArg.h"
#import "DBTEAMMemberAccess.h"

#pragma mark - API Object

@implementation DBTEAMGroupMembersAddArg

#pragma mark - Constructors

- (instancetype)initWithGroup:(DBTEAMGroupSelector *)group
                      members:(NSArray<DBTEAMMemberAccess *> *)members
                returnMembers:(NSNumber *)returnMembers {
  [DBStoneValidators nonnullValidator:nil](group);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](members);

  self = [super initWithReturnMembers:returnMembers];
  if (self) {
    _group = group;
    _members = members;
  }
  return self;
}

- (instancetype)initWithGroup:(DBTEAMGroupSelector *)group members:(NSArray<DBTEAMMemberAccess *> *)members {
  return [self initWithGroup:group members:members returnMembers:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGroupMembersAddArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGroupMembersAddArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGroupMembersAddArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.group hash];
  result = prime * result + [self.members hash];
  result = prime * result + [self.returnMembers hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupMembersAddArg:other];
}

- (BOOL)isEqualToGroupMembersAddArg:(DBTEAMGroupMembersAddArg *)aGroupMembersAddArg {
  if (self == aGroupMembersAddArg) {
    return YES;
  }
  if (![self.group isEqual:aGroupMembersAddArg.group]) {
    return NO;
  }
  if (![self.members isEqual:aGroupMembersAddArg.members]) {
    return NO;
  }
  if (![self.returnMembers isEqual:aGroupMembersAddArg.returnMembers]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGroupMembersAddArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupMembersAddArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"group"] = [DBTEAMGroupSelectorSerializer serialize:valueObj.group];
  jsonDict[@"members"] = [DBArraySerializer serialize:valueObj.members
                                            withBlock:^id(id elem0) {
                                              return [DBTEAMMemberAccessSerializer serialize:elem0];
                                            }];
  jsonDict[@"return_members"] = valueObj.returnMembers;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGroupMembersAddArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMGroupSelector *group = [DBTEAMGroupSelectorSerializer deserialize:valueDict[@"group"]];
  NSArray<DBTEAMMemberAccess *> *members =
      [DBArraySerializer deserialize:valueDict[@"members"]
                           withBlock:^id(id elem0) {
                             return [DBTEAMMemberAccessSerializer deserialize:elem0];
                           }];
  NSNumber *returnMembers = valueDict[@"return_members"] ?: @YES;

  return [[DBTEAMGroupMembersAddArg alloc] initWithGroup:group members:members returnMembers:returnMembers];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMGroupMembersAddError.h"
#import "DBTEAMGroupSelectorWithTeamGroupError.h"

#pragma mark - API Object

@implementation DBTEAMGroupMembersAddError

@synthesize membersNotInTeam = _membersNotInTeam;
@synthesize usersNotFound = _usersNotFound;
@synthesize userCannotBeManagerOfCompanyManagedGroup = _userCannotBeManagerOfCompanyManagedGroup;

#pragma mark - Constructors

- (instancetype)initWithGroupNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupMembersAddErrorGroupNotFound;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupMembersAddErrorOther;
  }
  return self;
}

- (instancetype)initWithSystemManagedGroupDisallowed {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupMembersAddErrorSystemManagedGroupDisallowed;
  }
  return self;
}

- (instancetype)initWithDuplicateUser {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupMembersAddErrorDuplicateUser;
  }
  return self;
}

- (instancetype)initWithGroupNotInTeam {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupMembersAddErrorGroupNotInTeam;
  }
  return self;
}

- (instancetype)initWithMembersNotInTeam:(NSArray<NSString *> *)membersNotInTeam {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupMembersAddErrorMembersNotInTeam;
    _membersNotInTeam = membersNotInTeam;
  }
  return self;
}

- (instancetype)initWithUsersNotFound:(NSArray<NSString *> *)usersNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupMembersAddErrorUsersNotFound;
    _usersNotFound = usersNotFound;
  }
  return self;
}

- (instancetype)initWithUserMustBeActiveToBeOwner {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupMembersAddErrorUserMustBeActiveToBeOwner;
  }
  return self;
}

- (instancetype)initWithUserCannotBeManagerOfCompanyManagedGroup:
    (NSArray<NSString *> *)userCannotBeManagerOfCompanyManagedGroup {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupMembersAddErrorUserCannotBeManagerOfCompanyManagedGroup;
    _userCannotBeManagerOfCompanyManagedGroup = userCannotBeManagerOfCompanyManagedGroup;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSArray<NSString *> *)membersNotInTeam {
  if (![self isMembersNotInTeam]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMGroupMembersAddErrorMembersNotInTeam, but was %@.", [self tagName]];
  }
  return _membersNotInTeam;
}

- (NSArray<NSString *> *)usersNotFound {
  if (![self isUsersNotFound]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMGroupMembersAddErrorUsersNotFound, but was %@.", [self tagName]];
  }
  return _usersNotFound;
}

- (NSArray<NSString *> *)userCannotBeManagerOfCompanyManagedGroup {
  if (![self isUserCannotBeManagerOfCompanyManagedGroup]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMGroupMembersAddErrorUserCannotBeManagerOfCompanyManagedGroup, but was %@.",
               [self tagName]];
  }
  return _userCannotBeManagerOfCompanyManagedGroup;
}

#pragma mark - Tag state methods

- (BOOL)isGroupNotFound {
  return _tag == DBTEAMGroupMembersAddErrorGroupNotFound;
}

- (BOOL)isOther {
  return _tag == DBTEAMGroupMembersAddErrorOther;
}

- (BOOL)isSystemManagedGroupDisallowed {
  return _tag == DBTEAMGroupMembersAddErrorSystemManagedGroupDisallowed;
}

- (BOOL)isDuplicateUser {
  return _tag == DBTEAMGroupMembersAddErrorDuplicateUser;
}

- (BOOL)isGroupNotInTeam {
  return _tag == DBTEAMGroupMembersAddErrorGroupNotInTeam;
}

- (BOOL)isMembersNotInTeam {
  return _tag == DBTEAMGroupMembersAddErrorMembersNotInTeam;
}

- (BOOL)isUsersNotFound {
  return _tag == DBTEAMGroupMembersAddErrorUsersNotFound;
}

- (BOOL)isUserMustBeActiveToBeOwner {
  return _tag == DBTEAMGroupMembersAddErrorUserMustBeActiveToBeOwner;
}

- (BOOL)isUserCannotBeManagerOfCompanyManagedGroup {
  return _tag == DBTEAMGroupMembersAddErrorUserCannotBeManagerOfCompanyManagedGroup;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMGroupMembersAddErrorGroupNotFound:
    return @"DBTEAMGroupMembersAddErrorGroupNotFound";
  case DBTEAMGroupMembersAddErrorOther:
    return @"DBTEAMGroupMembersAddErrorOther";
  case DBTEAMGroupMembersAddErrorSystemManagedGroupDisallowed:
    return @"DBTEAMGroupMembersAddErrorSystemManagedGroupDisallowed";
  case DBTEAMGroupMembersAddErrorDuplicateUser:
    return @"DBTEAMGroupMembersAddErrorDuplicateUser";
  case DBTEAMGroupMembersAddErrorGroupNotInTeam:
    return @"DBTEAMGroupMembersAddErrorGroupNotInTeam";
  case DBTEAMGroupMembersAddErrorMembersNotInTeam:
    return @"DBTEAMGroupMembersAddErrorMembersNotInTeam";
  case DBTEAMGroupMembersAddErrorUsersNotFound:
    return @"DBTEAMGroupMembersAddErrorUsersNotFound";
  case DBTEAMGroupMembersAddErrorUserMustBeActiveToBeOwner:
    return @"DBTEAMGroupMembersAddErrorUserMustBeActiveToBeOwner";
  case DBTEAMGroupMembersAddErrorUserCannotBeManagerOfCompanyManagedGroup:
    return @"DBTEAMGroupMembersAddErrorUserCannotBeManagerOfCompanyManagedGroup";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGroupMembersAddErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGroupMembersAddErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGroupMembersAddErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMGroupMembersAddErrorGroupNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupMembersAddErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupMembersAddErrorSystemManagedGroupDisallowed:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupMembersAddErrorDuplicateUser:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupMembersAddErrorGroupNotInTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupMembersAddErrorMembersNotInTeam:
    result = prime * result + [self.membersNotInTeam hash];
    break;
  case DBTEAMGroupMembersAddErrorUsersNotFound:
    result = prime * result + [self.usersNotFound hash];
    break;
  case DBTEAMGroupMembersAddErrorUserMustBeActiveToBeOwner:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupMembersAddErrorUserCannotBeManagerOfCompanyManagedGroup:
    result = prime * result + [self.userCannotBeManagerOfCompanyManagedGroup hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupMembersAddError:other];
}

- (BOOL)isEqualToGroupMembersAddError:(DBTEAMGroupMembersAddError *)aGroupMembersAddError {
  if (self == aGroupMembersAddError) {
    return YES;
  }
  if (self.tag != aGroupMembersAddError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMGroupMembersAddErrorGroupNotFound:
    return [[self tagName] isEqual:[aGroupMembersAddError tagName]];
  case DBTEAMGroupMembersAddErrorOther:
    return [[self tagName] isEqual:[aGroupMembersAddError tagName]];
  case DBTEAMGroupMembersAddErrorSystemManagedGroupDisallowed:
    return [[self tagName] isEqual:[aGroupMembersAddError tagName]];
  case DBTEAMGroupMembersAddErrorDuplicateUser:
    return [[self tagName] isEqual:[aGroupMembersAddError tagName]];
  case DBTEAMGroupMembersAddErrorGroupNotInTeam:
    return [[self tagName] isEqual:[aGroupMembersAddError tagName]];
  case DBTEAMGroupMembersAddErrorMembersNotInTeam:
    return [self.membersNotInTeam isEqual:aGroupMembersAddError.membersNotInTeam];
  case DBTEAMGroupMembersAddErrorUsersNotFound:
    return [self.usersNotFound isEqual:aGroupMembersAddError.usersNotFound];
  case DBTEAMGroupMembersAddErrorUserMustBeActiveToBeOwner:
    return [[self tagName] isEqual:[aGroupMembersAddError tagName]];
  case DBTEAMGroupMembersAddErrorUserCannotBeManagerOfCompanyManagedGroup:
    return [self.userCannotBeManagerOfCompanyManagedGroup
        isEqual:aGroupMembersAddError.userCannotBeManagerOfCompanyManagedGroup];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGroupMembersAddErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupMembersAddError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isGroupNotFound]) {
    jsonDict[@".tag"] = @"group_not_found";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isSystemManagedGroupDisallowed]) {
    jsonDict[@".tag"] = @"system_managed_group_disallowed";
  } else if ([valueObj isDuplicateUser]) {
    jsonDict[@".tag"] = @"duplicate_user";
  } else if ([valueObj isGroupNotInTeam]) {
    jsonDict[@".tag"] = @"group_not_in_team";
  } else if ([valueObj isMembersNotInTeam]) {
    jsonDict[@"members_not_in_team"] = [DBArraySerializer serialize:valueObj.membersNotInTeam
                                                          withBlock:^id(id elem0) {
                                                            return elem0;
                                                          }];
    jsonDict[@".tag"] = @"members_not_in_team";
  } else if ([valueObj isUsersNotFound]) {
    jsonDict[@"users_not_found"] = [DBArraySerializer serialize:valueObj.usersNotFound
                                                      withBlock:^id(id elem0) {
                                                        return elem0;
                                                      }];
    jsonDict[@".tag"] = @"users_not_found";
  } else if ([valueObj isUserMustBeActiveToBeOwner]) {
    jsonDict[@".tag"] = @"user_must_be_active_to_be_owner";
  } else if ([valueObj isUserCannotBeManagerOfCompanyManagedGroup]) {
    jsonDict[@"user_cannot_be_manager_of_company_managed_group"] =
        [DBArraySerializer serialize:valueObj.userCannotBeManagerOfCompanyManagedGroup
                           withBlock:^id(id elem0) {
                             return elem0;
                           }];
    jsonDict[@".tag"] = @"user_cannot_be_manager_of_company_managed_group";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGroupMembersAddError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"group_not_found"]) {
    return [[DBTEAMGroupMembersAddError alloc] initWithGroupNotFound];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMGroupMembersAddError alloc] initWithOther];
  } else if ([tag isEqualToString:@"system_managed_group_disallowed"]) {
    return [[DBTEAMGroupMembersAddError alloc] initWithSystemManagedGroupDisallowed];
  } else if ([tag isEqualToString:@"duplicate_user"]) {
    return [[DBTEAMGroupMembersAddError alloc] initWithDuplicateUser];
  } else if ([tag isEqualToString:@"group_not_in_team"]) {
    return [[DBTEAMGroupMembersAddError alloc] initWithGroupNotInTeam];
  } else if ([tag isEqualToString:@"members_not_in_team"]) {
    NSArray<NSString *> *membersNotInTeam = [DBArraySerializer deserialize:valueDict[@"members_not_in_team"]
                                                                 withBlock:^id(id elem0) {
                                                                   return elem0;
                                                                 }];
    return [[DBTEAMGroupMembersAddError alloc] initWithMembersNotInTeam:membersNotInTeam];
  } else if ([tag isEqualToString:@"users_not_found"]) {
    NSArray<NSString *> *usersNotFound = [DBArraySerializer deserialize:valueDict[@"users_not_found"]
                                                              withBlock:^id(id elem0) {
                                                                return elem0;
                                                              }];
    return [[DBTEAMGroupMembersAddError alloc] initWithUsersNotFound:usersNotFound];
  } else if ([tag isEqualToString:@"user_must_be_active_to_be_owner"]) {
    return [[DBTEAMGroupMembersAddError alloc] initWithUserMustBeActiveToBeOwner];
  } else if ([tag isEqualToString:@"user_cannot_be_manager_of_company_managed_group"]) {
    NSArray<NSString *> *userCannotBeManagerOfCompanyManagedGroup =
        [DBArraySerializer deserialize:valueDict[@"user_cannot_be_manager_of_company_managed_group"]
                             withBlock:^id(id elem0) {
                               return elem0;
                             }];
    return [[DBTEAMGroupMembersAddError alloc]
        initWithUserCannotBeManagerOfCompanyManagedGroup:userCannotBeManagerOfCompanyManagedGroup];
  } else {
    return [[DBTEAMGroupMembersAddError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMGroupFullInfo.h"
#import "DBTEAMGroupMembersChangeResult.h"

#pragma mark - API Object

@implementation DBTEAMGroupMembersChangeResult

#pragma mark - Constructors

- (instancetype)initWithGroupInfo:(DBTEAMGroupFullInfo *)groupInfo asyncJobId:(NSString *)asyncJobId {
  [DBStoneValidators nonnullValidator:nil](groupInfo);
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:@(1) maxLength:nil pattern:nil]](asyncJobId);

  self = [super init];
  if (self) {
    _groupInfo = groupInfo;
    _asyncJobId = asyncJobId;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGroupMembersChangeResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGroupMembersChangeResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGroupMembersChangeResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.groupInfo hash];
  result = prime * result + [self.asyncJobId hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupMembersChangeResult:other];
}

- (BOOL)isEqualToGroupMembersChangeResult:(DBTEAMGroupMembersChangeResult *)aGroupMembersChangeResult {
  if (self == aGroupMembersChangeResult) {
    return YES;
  }
  if (![self.groupInfo isEqual:aGroupMembersChangeResult.groupInfo]) {
    return NO;
  }
  if (![self.asyncJobId isEqual:aGroupMembersChangeResult.asyncJobId]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGroupMembersChangeResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupMembersChangeResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"group_info"] = [DBTEAMGroupFullInfoSerializer serialize:valueObj.groupInfo];
  jsonDict[@"async_job_id"] = valueObj.asyncJobId;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGroupMembersChangeResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMGroupFullInfo *groupInfo = [DBTEAMGroupFullInfoSerializer deserialize:valueDict[@"group_info"]];
  NSString *asyncJobId = valueDict[@"async_job_id"];

  return [[DBTEAMGroupMembersChangeResult alloc] initWithGroupInfo:groupInfo asyncJobId:asyncJobId];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMGroupMembersRemoveArg.h"
#import "DBTEAMGroupSelector.h"
#import "DBTEAMIncludeMembersArg.h"
#import "DBTEAMUserSelectorArg.h"

#pragma mark - API Object

@implementation DBTEAMGroupMembersRemoveArg

#pragma mark - Constructors

- (instancetype)initWithGroup:(DBTEAMGroupSelector *)group
                        users:(NSArray<DBTEAMUserSelectorArg *> *)users
                returnMembers:(NSNumber *)returnMembers {
  [DBStoneValidators nonnullValidator:nil](group);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](users);

  self = [super initWithReturnMembers:returnMembers];
  if (self) {
    _group = group;
    _users = users;
  }
  return self;
}

- (instancetype)initWithGroup:(DBTEAMGroupSelector *)group users:(NSArray<DBTEAMUserSelectorArg *> *)users {
  return [self initWithGroup:group users:users returnMembers:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGroupMembersRemoveArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGroupMembersRemoveArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGroupMembersRemoveArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.group hash];
  result = prime * result + [self.users hash];
  result = prime * result + [self.returnMembers hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupMembersRemoveArg:other];
}

- (BOOL)isEqualToGroupMembersRemoveArg:(DBTEAMGroupMembersRemoveArg *)aGroupMembersRemoveArg {
  if (self == aGroupMembersRemoveArg) {
    return YES;
  }
  if (![self.group isEqual:aGroupMembersRemoveArg.group]) {
    return NO;
  }
  if (![self.users isEqual:aGroupMembersRemoveArg.users]) {
    return NO;
  }
  if (![self.returnMembers isEqual:aGroupMembersRemoveArg.returnMembers]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGroupMembersRemoveArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupMembersRemoveArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"group"] = [DBTEAMGroupSelectorSerializer serialize:valueObj.group];
  jsonDict[@"users"] = [DBArraySerializer serialize:valueObj.users
                                          withBlock:^id(id elem0) {
                                            return [DBTEAMUserSelectorArgSerializer serialize:elem0];
                                          }];
  jsonDict[@"return_members"] = valueObj.returnMembers;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGroupMembersRemoveArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMGroupSelector *group = [DBTEAMGroupSelectorSerializer deserialize:valueDict[@"group"]];
  NSArray<DBTEAMUserSelectorArg *> *users =
      [DBArraySerializer deserialize:valueDict[@"users"]
                           withBlock:^id(id elem0) {
                             return [DBTEAMUserSelectorArgSerializer deserialize:elem0];
                           }];
  NSNumber *returnMembers = valueDict[@"return_members"] ?: @YES;

  return [[DBTEAMGroupMembersRemoveArg alloc] initWithGroup:group users:users returnMembers:returnMembers];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMGroupMembersSelectorError.h"
#import "DBTEAMGroupSelectorWithTeamGroupError.h"

#pragma mark - API Object

@implementation DBTEAMGroupMembersSelectorError

#pragma mark - Constructors

- (instancetype)initWithGroupNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupMembersSelectorErrorGroupNotFound;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupMembersSelectorErrorOther;
  }
  return self;
}

- (instancetype)initWithSystemManagedGroupDisallowed {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupMembersSelectorErrorSystemManagedGroupDisallowed;
  }
  return self;
}

- (instancetype)initWithMemberNotInGroup {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupMembersSelectorErrorMemberNotInGroup;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isGroupNotFound {
  return _tag == DBTEAMGroupMembersSelectorErrorGroupNotFound;
}

- (BOOL)isOther {
  return _tag == DBTEAMGroupMembersSelectorErrorOther;
}

- (BOOL)isSystemManagedGroupDisallowed {
  return _tag == DBTEAMGroupMembersSelectorErrorSystemManagedGroupDisallowed;
}

- (BOOL)isMemberNotInGroup {
  return _tag == DBTEAMGroupMembersSelectorErrorMemberNotInGroup;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMGroupMembersSelectorErrorGroupNotFound:
    return @"DBTEAMGroupMembersSelectorErrorGroupNotFound";
  case DBTEAMGroupMembersSelectorErrorOther:
    return @"DBTEAMGroupMembersSelectorErrorOther";
  case DBTEAMGroupMembersSelectorErrorSystemManagedGroupDisallowed:
    return @"DBTEAMGroupMembersSelectorErrorSystemManagedGroupDisallowed";
  case DBTEAMGroupMembersSelectorErrorMemberNotInGroup:
    return @"DBTEAMGroupMembersSelectorErrorMemberNotInGroup";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGroupMembersSelectorErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGroupMembersSelectorErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGroupMembersSelectorErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMGroupMembersSelectorErrorGroupNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupMembersSelectorErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupMembersSelectorErrorSystemManagedGroupDisallowed:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupMembersSelectorErrorMemberNotInGroup:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupMembersSelectorError:other];
}

- (BOOL)isEqualToGroupMembersSelectorError:(DBTEAMGroupMembersSelectorError *)aGroupMembersSelectorError {
  if (self == aGroupMembersSelectorError) {
    return YES;
  }
  if (self.tag != aGroupMembersSelectorError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMGroupMembersSelectorErrorGroupNotFound:
    return [[self tagName] isEqual:[aGroupMembersSelectorError tagName]];
  case DBTEAMGroupMembersSelectorErrorOther:
    return [[self tagName] isEqual:[aGroupMembersSelectorError tagName]];
  case DBTEAMGroupMembersSelectorErrorSystemManagedGroupDisallowed:
    return [[self tagName] isEqual:[aGroupMembersSelectorError tagName]];
  case DBTEAMGroupMembersSelectorErrorMemberNotInGroup:
    return [[self tagName] isEqual:[aGroupMembersSelectorError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGroupMembersSelectorErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupMembersSelectorError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isGroupNotFound]) {
    jsonDict[@".tag"] = @"group_not_found";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isSystemManagedGroupDisallowed]) {
    jsonDict[@".tag"] = @"system_managed_group_disallowed";
  } else if ([valueObj isMemberNotInGroup]) {
    jsonDict[@".tag"] = @"member_not_in_group";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGroupMembersSelectorError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"group_not_found"]) {
    return [[DBTEAMGroupMembersSelectorError alloc] initWithGroupNotFound];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMGroupMembersSelectorError alloc] initWithOther];
  } else if ([tag isEqualToString:@"system_managed_group_disallowed"]) {
    return [[DBTEAMGroupMembersSelectorError alloc] initWithSystemManagedGroupDisallowed];
  } else if ([tag isEqualToString:@"member_not_in_group"]) {
    return [[DBTEAMGroupMembersSelectorError alloc] initWithMemberNotInGroup];
  } else {
    return [[DBTEAMGroupMembersSelectorError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMGroupMembersRemoveError.h"
#import "DBTEAMGroupMembersSelectorError.h"

#pragma mark - API Object

@implementation DBTEAMGroupMembersRemoveError

@synthesize membersNotInTeam = _membersNotInTeam;
@synthesize usersNotFound = _usersNotFound;

#pragma mark - Constructors

- (instancetype)initWithGroupNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupMembersRemoveErrorGroupNotFound;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupMembersRemoveErrorOther;
  }
  return self;
}

- (instancetype)initWithSystemManagedGroupDisallowed {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupMembersRemoveErrorSystemManagedGroupDisallowed;
  }
  return self;
}

- (instancetype)initWithMemberNotInGroup {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupMembersRemoveErrorMemberNotInGroup;
  }
  return self;
}

- (instancetype)initWithGroupNotInTeam {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupMembersRemoveErrorGroupNotInTeam;
  }
  return self;
}

- (instancetype)initWithMembersNotInTeam:(NSArray<NSString *> *)membersNotInTeam {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupMembersRemoveErrorMembersNotInTeam;
    _membersNotInTeam = membersNotInTeam;
  }
  return self;
}

- (instancetype)initWithUsersNotFound:(NSArray<NSString *> *)usersNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupMembersRemoveErrorUsersNotFound;
    _usersNotFound = usersNotFound;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSArray<NSString *> *)membersNotInTeam {
  if (![self isMembersNotInTeam]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMGroupMembersRemoveErrorMembersNotInTeam, but was %@.", [self tagName]];
  }
  return _membersNotInTeam;
}

- (NSArray<NSString *> *)usersNotFound {
  if (![self isUsersNotFound]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMGroupMembersRemoveErrorUsersNotFound, but was %@.", [self tagName]];
  }
  return _usersNotFound;
}

#pragma mark - Tag state methods

- (BOOL)isGroupNotFound {
  return _tag == DBTEAMGroupMembersRemoveErrorGroupNotFound;
}

- (BOOL)isOther {
  return _tag == DBTEAMGroupMembersRemoveErrorOther;
}

- (BOOL)isSystemManagedGroupDisallowed {
  return _tag == DBTEAMGroupMembersRemoveErrorSystemManagedGroupDisallowed;
}

- (BOOL)isMemberNotInGroup {
  return _tag == DBTEAMGroupMembersRemoveErrorMemberNotInGroup;
}

- (BOOL)isGroupNotInTeam {
  return _tag == DBTEAMGroupMembersRemoveErrorGroupNotInTeam;
}

- (BOOL)isMembersNotInTeam {
  return _tag == DBTEAMGroupMembersRemoveErrorMembersNotInTeam;
}

- (BOOL)isUsersNotFound {
  return _tag == DBTEAMGroupMembersRemoveErrorUsersNotFound;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMGroupMembersRemoveErrorGroupNotFound:
    return @"DBTEAMGroupMembersRemoveErrorGroupNotFound";
  case DBTEAMGroupMembersRemoveErrorOther:
    return @"DBTEAMGroupMembersRemoveErrorOther";
  case DBTEAMGroupMembersRemoveErrorSystemManagedGroupDisallowed:
    return @"DBTEAMGroupMembersRemoveErrorSystemManagedGroupDisallowed";
  case DBTEAMGroupMembersRemoveErrorMemberNotInGroup:
    return @"DBTEAMGroupMembersRemoveErrorMemberNotInGroup";
  case DBTEAMGroupMembersRemoveErrorGroupNotInTeam:
    return @"DBTEAMGroupMembersRemoveErrorGroupNotInTeam";
  case DBTEAMGroupMembersRemoveErrorMembersNotInTeam:
    return @"DBTEAMGroupMembersRemoveErrorMembersNotInTeam";
  case DBTEAMGroupMembersRemoveErrorUsersNotFound:
    return @"DBTEAMGroupMembersRemoveErrorUsersNotFound";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGroupMembersRemoveErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGroupMembersRemoveErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGroupMembersRemoveErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMGroupMembersRemoveErrorGroupNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupMembersRemoveErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupMembersRemoveErrorSystemManagedGroupDisallowed:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupMembersRemoveErrorMemberNotInGroup:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupMembersRemoveErrorGroupNotInTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupMembersRemoveErrorMembersNotInTeam:
    result = prime * result + [self.membersNotInTeam hash];
    break;
  case DBTEAMGroupMembersRemoveErrorUsersNotFound:
    result = prime * result + [self.usersNotFound hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupMembersRemoveError:other];
}

- (BOOL)isEqualToGroupMembersRemoveError:(DBTEAMGroupMembersRemoveError *)aGroupMembersRemoveError {
  if (self == aGroupMembersRemoveError) {
    return YES;
  }
  if (self.tag != aGroupMembersRemoveError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMGroupMembersRemoveErrorGroupNotFound:
    return [[self tagName] isEqual:[aGroupMembersRemoveError tagName]];
  case DBTEAMGroupMembersRemoveErrorOther:
    return [[self tagName] isEqual:[aGroupMembersRemoveError tagName]];
  case DBTEAMGroupMembersRemoveErrorSystemManagedGroupDisallowed:
    return [[self tagName] isEqual:[aGroupMembersRemoveError tagName]];
  case DBTEAMGroupMembersRemoveErrorMemberNotInGroup:
    return [[self tagName] isEqual:[aGroupMembersRemoveError tagName]];
  case DBTEAMGroupMembersRemoveErrorGroupNotInTeam:
    return [[self tagName] isEqual:[aGroupMembersRemoveError tagName]];
  case DBTEAMGroupMembersRemoveErrorMembersNotInTeam:
    return [self.membersNotInTeam isEqual:aGroupMembersRemoveError.membersNotInTeam];
  case DBTEAMGroupMembersRemoveErrorUsersNotFound:
    return [self.usersNotFound isEqual:aGroupMembersRemoveError.usersNotFound];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGroupMembersRemoveErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupMembersRemoveError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isGroupNotFound]) {
    jsonDict[@".tag"] = @"group_not_found";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isSystemManagedGroupDisallowed]) {
    jsonDict[@".tag"] = @"system_managed_group_disallowed";
  } else if ([valueObj isMemberNotInGroup]) {
    jsonDict[@".tag"] = @"member_not_in_group";
  } else if ([valueObj isGroupNotInTeam]) {
    jsonDict[@".tag"] = @"group_not_in_team";
  } else if ([valueObj isMembersNotInTeam]) {
    jsonDict[@"members_not_in_team"] = [DBArraySerializer serialize:valueObj.membersNotInTeam
                                                          withBlock:^id(id elem0) {
                                                            return elem0;
                                                          }];
    jsonDict[@".tag"] = @"members_not_in_team";
  } else if ([valueObj isUsersNotFound]) {
    jsonDict[@"users_not_found"] = [DBArraySerializer serialize:valueObj.usersNotFound
                                                      withBlock:^id(id elem0) {
                                                        return elem0;
                                                      }];
    jsonDict[@".tag"] = @"users_not_found";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGroupMembersRemoveError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"group_not_found"]) {
    return [[DBTEAMGroupMembersRemoveError alloc] initWithGroupNotFound];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMGroupMembersRemoveError alloc] initWithOther];
  } else if ([tag isEqualToString:@"system_managed_group_disallowed"]) {
    return [[DBTEAMGroupMembersRemoveError alloc] initWithSystemManagedGroupDisallowed];
  } else if ([tag isEqualToString:@"member_not_in_group"]) {
    return [[DBTEAMGroupMembersRemoveError alloc] initWithMemberNotInGroup];
  } else if ([tag isEqualToString:@"group_not_in_team"]) {
    return [[DBTEAMGroupMembersRemoveError alloc] initWithGroupNotInTeam];
  } else if ([tag isEqualToString:@"members_not_in_team"]) {
    NSArray<NSString *> *membersNotInTeam = [DBArraySerializer deserialize:valueDict[@"members_not_in_team"]
                                                                 withBlock:^id(id elem0) {
                                                                   return elem0;
                                                                 }];
    return [[DBTEAMGroupMembersRemoveError alloc] initWithMembersNotInTeam:membersNotInTeam];
  } else if ([tag isEqualToString:@"users_not_found"]) {
    NSArray<NSString *> *usersNotFound = [DBArraySerializer deserialize:valueDict[@"users_not_found"]
                                                              withBlock:^id(id elem0) {
                                                                return elem0;
                                                              }];
    return [[DBTEAMGroupMembersRemoveError alloc] initWithUsersNotFound:usersNotFound];
  } else {
    return [[DBTEAMGroupMembersRemoveError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMGroupMembersSelector.h"
#import "DBTEAMGroupSelector.h"
#import "DBTEAMUsersSelectorArg.h"

#pragma mark - API Object

@implementation DBTEAMGroupMembersSelector

#pragma mark - Constructors

- (instancetype)initWithGroup:(DBTEAMGroupSelector *)group users:(DBTEAMUsersSelectorArg *)users {
  [DBStoneValidators nonnullValidator:nil](group);
  [DBStoneValidators nonnullValidator:nil](users);

  self = [super init];
  if (self) {
    _group = group;
    _users = users;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGroupMembersSelectorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGroupMembersSelectorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGroupMembersSelectorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.group hash];
  result = prime * result + [self.users hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupMembersSelector:other];
}

- (BOOL)isEqualToGroupMembersSelector:(DBTEAMGroupMembersSelector *)aGroupMembersSelector {
  if (self == aGroupMembersSelector) {
    return YES;
  }
  if (![self.group isEqual:aGroupMembersSelector.group]) {
    return NO;
  }
  if (![self.users isEqual:aGroupMembersSelector.users]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGroupMembersSelectorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupMembersSelector *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"group"] = [DBTEAMGroupSelectorSerializer serialize:valueObj.group];
  jsonDict[@"users"] = [DBTEAMUsersSelectorArgSerializer serialize:valueObj.users];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGroupMembersSelector *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMGroupSelector *group = [DBTEAMGroupSelectorSerializer deserialize:valueDict[@"group"]];
  DBTEAMUsersSelectorArg *users = [DBTEAMUsersSelectorArgSerializer deserialize:valueDict[@"users"]];

  return [[DBTEAMGroupMembersSelector alloc] initWithGroup:group users:users];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMGroupAccessType.h"
#import "DBTEAMGroupMemberSelector.h"
#import "DBTEAMGroupMembersSetAccessTypeArg.h"
#import "DBTEAMGroupSelector.h"
#import "DBTEAMUserSelectorArg.h"

#pragma mark - API Object

@implementation DBTEAMGroupMembersSetAccessTypeArg

#pragma mark - Constructors

- (instancetype)initWithGroup:(DBTEAMGroupSelector *)group
                         user:(DBTEAMUserSelectorArg *)user
                   accessType:(DBTEAMGroupAccessType *)accessType
                returnMembers:(NSNumber *)returnMembers {
  [DBStoneValidators nonnullValidator:nil](group);
  [DBStoneValidators nonnullValidator:nil](user);
  [DBStoneValidators nonnullValidator:nil](accessType);

  self = [super initWithGroup:group user:user];
  if (self) {
    _accessType = accessType;
    _returnMembers = returnMembers ?: @YES;
  }
  return self;
}

- (instancetype)initWithGroup:(DBTEAMGroupSelector *)group
                         user:(DBTEAMUserSelectorArg *)user
                   accessType:(DBTEAMGroupAccessType *)accessType {
  return [self initWithGroup:group user:user accessType:accessType returnMembers:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGroupMembersSetAccessTypeArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGroupMembersSetAccessTypeArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGroupMembersSetAccessTypeArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.group hash];
  result = prime * result + [self.user hash];
  result = prime * result + [self.accessType hash];
  result = prime * result + [self.returnMembers hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupMembersSetAccessTypeArg:other];
}

- (BOOL)isEqualToGroupMembersSetAccessTypeArg:(DBTEAMGroupMembersSetAccessTypeArg *)aGroupMembersSetAccessTypeArg {
  if (self == aGroupMembersSetAccessTypeArg) {
    return YES;
  }
  if (![self.group isEqual:aGroupMembersSetAccessTypeArg.group]) {
    return NO;
  }
  if (![self.user isEqual:aGroupMembersSetAccessTypeArg.user]) {
    return NO;
  }
  if (![self.accessType isEqual:aGroupMembersSetAccessTypeArg.accessType]) {
    return NO;
  }
  if (![self.returnMembers isEqual:aGroupMembersSetAccessTypeArg.returnMembers]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGroupMembersSetAccessTypeArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupMembersSetAccessTypeArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"group"] = [DBTEAMGroupSelectorSerializer serialize:valueObj.group];
  jsonDict[@"user"] = [DBTEAMUserSelectorArgSerializer serialize:valueObj.user];
  jsonDict[@"access_type"] = [DBTEAMGroupAccessTypeSerializer serialize:valueObj.accessType];
  jsonDict[@"return_members"] = valueObj.returnMembers;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGroupMembersSetAccessTypeArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMGroupSelector *group = [DBTEAMGroupSelectorSerializer deserialize:valueDict[@"group"]];
  DBTEAMUserSelectorArg *user = [DBTEAMUserSelectorArgSerializer deserialize:valueDict[@"user"]];
  DBTEAMGroupAccessType *accessType = [DBTEAMGroupAccessTypeSerializer deserialize:valueDict[@"access_type"]];
  NSNumber *returnMembers = valueDict[@"return_members"] ?: @YES;

  return [[DBTEAMGroupMembersSetAccessTypeArg alloc] initWithGroup:group
                                                              user:user
                                                        accessType:accessType
                                                     returnMembers:returnMembers];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMGroupSelector.h"

#pragma mark - API Object

@implementation DBTEAMGroupSelector

@synthesize groupId = _groupId;
@synthesize groupExternalId = _groupExternalId;

#pragma mark - Constructors

- (instancetype)initWithGroupId:(NSString *)groupId {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupSelectorGroupId;
    _groupId = groupId;
  }
  return self;
}

- (instancetype)initWithGroupExternalId:(NSString *)groupExternalId {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupSelectorGroupExternalId;
    _groupExternalId = groupExternalId;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSString *)groupId {
  if (![self isGroupId]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMGroupSelectorGroupId, but was %@.", [self tagName]];
  }
  return _groupId;
}

- (NSString *)groupExternalId {
  if (![self isGroupExternalId]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMGroupSelectorGroupExternalId, but was %@.", [self tagName]];
  }
  return _groupExternalId;
}

#pragma mark - Tag state methods

- (BOOL)isGroupId {
  return _tag == DBTEAMGroupSelectorGroupId;
}

- (BOOL)isGroupExternalId {
  return _tag == DBTEAMGroupSelectorGroupExternalId;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMGroupSelectorGroupId:
    return @"DBTEAMGroupSelectorGroupId";
  case DBTEAMGroupSelectorGroupExternalId:
    return @"DBTEAMGroupSelectorGroupExternalId";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGroupSelectorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGroupSelectorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGroupSelectorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMGroupSelectorGroupId:
    result = prime * result + [self.groupId hash];
    break;
  case DBTEAMGroupSelectorGroupExternalId:
    result = prime * result + [self.groupExternalId hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupSelector:other];
}

- (BOOL)isEqualToGroupSelector:(DBTEAMGroupSelector *)aGroupSelector {
  if (self == aGroupSelector) {
    return YES;
  }
  if (self.tag != aGroupSelector.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMGroupSelectorGroupId:
    return [self.groupId isEqual:aGroupSelector.groupId];
  case DBTEAMGroupSelectorGroupExternalId:
    return [self.groupExternalId isEqual:aGroupSelector.groupExternalId];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGroupSelectorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupSelector *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isGroupId]) {
    jsonDict[@"group_id"] = valueObj.groupId;
    jsonDict[@".tag"] = @"group_id";
  } else if ([valueObj isGroupExternalId]) {
    jsonDict[@"group_external_id"] = valueObj.groupExternalId;
    jsonDict[@".tag"] = @"group_external_id";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGroupSelector *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"group_id"]) {
    NSString *groupId = valueDict[@"group_id"];
    return [[DBTEAMGroupSelector alloc] initWithGroupId:groupId];
  } else if ([tag isEqualToString:@"group_external_id"]) {
    NSString *groupExternalId = valueDict[@"group_external_id"];
    return [[DBTEAMGroupSelector alloc] initWithGroupExternalId:groupExternalId];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMCOMMONGroupManagementType.h"
#import "DBTEAMGroupSelector.h"
#import "DBTEAMGroupUpdateArgs.h"
#import "DBTEAMIncludeMembersArg.h"

#pragma mark - API Object

@implementation DBTEAMGroupUpdateArgs

#pragma mark - Constructors

- (instancetype)initWithGroup:(DBTEAMGroupSelector *)group
                returnMembers:(NSNumber *)returnMembers
                dNewGroupName:(NSString *)dNewGroupName
          dNewGroupExternalId:(NSString *)dNewGroupExternalId
      dNewGroupManagementType:(DBTEAMCOMMONGroupManagementType *)dNewGroupManagementType {
  [DBStoneValidators nonnullValidator:nil](group);

  self = [super initWithReturnMembers:returnMembers];
  if (self) {
    _group = group;
    _dNewGroupName = dNewGroupName;
    _dNewGroupExternalId = dNewGroupExternalId;
    _dNewGroupManagementType = dNewGroupManagementType;
  }
  return self;
}

- (instancetype)initWithGroup:(DBTEAMGroupSelector *)group {
  return [self initWithGroup:group
                returnMembers:nil
                dNewGroupName:nil
          dNewGroupExternalId:nil
      dNewGroupManagementType:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGroupUpdateArgsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGroupUpdateArgsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGroupUpdateArgsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.group hash];
  result = prime * result + [self.returnMembers hash];
  if (self.dNewGroupName != nil) {
    result = prime * result + [self.dNewGroupName hash];
  }
  if (self.dNewGroupExternalId != nil) {
    result = prime * result + [self.dNewGroupExternalId hash];
  }
  if (self.dNewGroupManagementType != nil) {
    result = prime * result + [self.dNewGroupManagementType hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupUpdateArgs:other];
}

- (BOOL)isEqualToGroupUpdateArgs:(DBTEAMGroupUpdateArgs *)aGroupUpdateArgs {
  if (self == aGroupUpdateArgs) {
    return YES;
  }
  if (![self.group isEqual:aGroupUpdateArgs.group]) {
    return NO;
  }
  if (![self.returnMembers isEqual:aGroupUpdateArgs.returnMembers]) {
    return NO;
  }
  if (self.dNewGroupName) {
    if (![self.dNewGroupName isEqual:aGroupUpdateArgs.dNewGroupName]) {
      return NO;
    }
  }
  if (self.dNewGroupExternalId) {
    if (![self.dNewGroupExternalId isEqual:aGroupUpdateArgs.dNewGroupExternalId]) {
      return NO;
    }
  }
  if (self.dNewGroupManagementType) {
    if (![self.dNewGroupManagementType isEqual:aGroupUpdateArgs.dNewGroupManagementType]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGroupUpdateArgsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupUpdateArgs *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"group"] = [DBTEAMGroupSelectorSerializer serialize:valueObj.group];
  jsonDict[@"return_members"] = valueObj.returnMembers;
  if (valueObj.dNewGroupName) {
    jsonDict[@"new_group_name"] = valueObj.dNewGroupName;
  }
  if (valueObj.dNewGroupExternalId) {
    jsonDict[@"new_group_external_id"] = valueObj.dNewGroupExternalId;
  }
  if (valueObj.dNewGroupManagementType) {
    jsonDict[@"new_group_management_type"] =
        [DBTEAMCOMMONGroupManagementTypeSerializer serialize:valueObj.dNewGroupManagementType];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGroupUpdateArgs *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMGroupSelector *group = [DBTEAMGroupSelectorSerializer deserialize:valueDict[@"group"]];
  NSNumber *returnMembers = valueDict[@"return_members"] ?: @YES;
  NSString *dNewGroupName = valueDict[@"new_group_name"] ?: nil;
  NSString *dNewGroupExternalId = valueDict[@"new_group_external_id"] ?: nil;
  DBTEAMCOMMONGroupManagementType *dNewGroupManagementType =
      valueDict[@"new_group_management_type"]
          ? [DBTEAMCOMMONGroupManagementTypeSerializer deserialize:valueDict[@"new_group_management_type"]]
          : nil;

  return [[DBTEAMGroupUpdateArgs alloc] initWithGroup:group
                                        returnMembers:returnMembers
                                        dNewGroupName:dNewGroupName
                                  dNewGroupExternalId:dNewGroupExternalId
                              dNewGroupManagementType:dNewGroupManagementType];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMGroupSelectorWithTeamGroupError.h"
#import "DBTEAMGroupUpdateError.h"

#pragma mark - API Object

@implementation DBTEAMGroupUpdateError

#pragma mark - Constructors

- (instancetype)initWithGroupNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupUpdateErrorGroupNotFound;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupUpdateErrorOther;
  }
  return self;
}

- (instancetype)initWithSystemManagedGroupDisallowed {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupUpdateErrorSystemManagedGroupDisallowed;
  }
  return self;
}

- (instancetype)initWithGroupNameAlreadyUsed {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupUpdateErrorGroupNameAlreadyUsed;
  }
  return self;
}

- (instancetype)initWithGroupNameInvalid {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupUpdateErrorGroupNameInvalid;
  }
  return self;
}

- (instancetype)initWithExternalIdAlreadyInUse {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupUpdateErrorExternalIdAlreadyInUse;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isGroupNotFound {
  return _tag == DBTEAMGroupUpdateErrorGroupNotFound;
}

- (BOOL)isOther {
  return _tag == DBTEAMGroupUpdateErrorOther;
}

- (BOOL)isSystemManagedGroupDisallowed {
  return _tag == DBTEAMGroupUpdateErrorSystemManagedGroupDisallowed;
}

- (BOOL)isGroupNameAlreadyUsed {
  return _tag == DBTEAMGroupUpdateErrorGroupNameAlreadyUsed;
}

- (BOOL)isGroupNameInvalid {
  return _tag == DBTEAMGroupUpdateErrorGroupNameInvalid;
}

- (BOOL)isExternalIdAlreadyInUse {
  return _tag == DBTEAMGroupUpdateErrorExternalIdAlreadyInUse;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMGroupUpdateErrorGroupNotFound:
    return @"DBTEAMGroupUpdateErrorGroupNotFound";
  case DBTEAMGroupUpdateErrorOther:
    return @"DBTEAMGroupUpdateErrorOther";
  case DBTEAMGroupUpdateErrorSystemManagedGroupDisallowed:
    return @"DBTEAMGroupUpdateErrorSystemManagedGroupDisallowed";
  case DBTEAMGroupUpdateErrorGroupNameAlreadyUsed:
    return @"DBTEAMGroupUpdateErrorGroupNameAlreadyUsed";
  case DBTEAMGroupUpdateErrorGroupNameInvalid:
    return @"DBTEAMGroupUpdateErrorGroupNameInvalid";
  case DBTEAMGroupUpdateErrorExternalIdAlreadyInUse:
    return @"DBTEAMGroupUpdateErrorExternalIdAlreadyInUse";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGroupUpdateErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGroupUpdateErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGroupUpdateErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMGroupUpdateErrorGroupNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupUpdateErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupUpdateErrorSystemManagedGroupDisallowed:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupUpdateErrorGroupNameAlreadyUsed:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupUpdateErrorGroupNameInvalid:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupUpdateErrorExternalIdAlreadyInUse:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupUpdateError:other];
}

- (BOOL)isEqualToGroupUpdateError:(DBTEAMGroupUpdateError *)aGroupUpdateError {
  if (self == aGroupUpdateError) {
    return YES;
  }
  if (self.tag != aGroupUpdateError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMGroupUpdateErrorGroupNotFound:
    return [[self tagName] isEqual:[aGroupUpdateError tagName]];
  case DBTEAMGroupUpdateErrorOther:
    return [[self tagName] isEqual:[aGroupUpdateError tagName]];
  case DBTEAMGroupUpdateErrorSystemManagedGroupDisallowed:
    return [[self tagName] isEqual:[aGroupUpdateError tagName]];
  case DBTEAMGroupUpdateErrorGroupNameAlreadyUsed:
    return [[self tagName] isEqual:[aGroupUpdateError tagName]];
  case DBTEAMGroupUpdateErrorGroupNameInvalid:
    return [[self tagName] isEqual:[aGroupUpdateError tagName]];
  case DBTEAMGroupUpdateErrorExternalIdAlreadyInUse:
    return [[self tagName] isEqual:[aGroupUpdateError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGroupUpdateErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupUpdateError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isGroupNotFound]) {
    jsonDict[@".tag"] = @"group_not_found";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isSystemManagedGroupDisallowed]) {
    jsonDict[@".tag"] = @"system_managed_group_disallowed";
  } else if ([valueObj isGroupNameAlreadyUsed]) {
    jsonDict[@".tag"] = @"group_name_already_used";
  } else if ([valueObj isGroupNameInvalid]) {
    jsonDict[@".tag"] = @"group_name_invalid";
  } else if ([valueObj isExternalIdAlreadyInUse]) {
    jsonDict[@".tag"] = @"external_id_already_in_use";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGroupUpdateError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"group_not_found"]) {
    return [[DBTEAMGroupUpdateError alloc] initWithGroupNotFound];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMGroupUpdateError alloc] initWithOther];
  } else if ([tag isEqualToString:@"system_managed_group_disallowed"]) {
    return [[DBTEAMGroupUpdateError alloc] initWithSystemManagedGroupDisallowed];
  } else if ([tag isEqualToString:@"group_name_already_used"]) {
    return [[DBTEAMGroupUpdateError alloc] initWithGroupNameAlreadyUsed];
  } else if ([tag isEqualToString:@"group_name_invalid"]) {
    return [[DBTEAMGroupUpdateError alloc] initWithGroupNameInvalid];
  } else if ([tag isEqualToString:@"external_id_already_in_use"]) {
    return [[DBTEAMGroupUpdateError alloc] initWithExternalIdAlreadyInUse];
  } else {
    return [[DBTEAMGroupUpdateError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMGroupsGetInfoError.h"

#pragma mark - API Object

@implementation DBTEAMGroupsGetInfoError

#pragma mark - Constructors

- (instancetype)initWithGroupNotOnTeam {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupsGetInfoErrorGroupNotOnTeam;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupsGetInfoErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isGroupNotOnTeam {
  return _tag == DBTEAMGroupsGetInfoErrorGroupNotOnTeam;
}

- (BOOL)isOther {
  return _tag == DBTEAMGroupsGetInfoErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMGroupsGetInfoErrorGroupNotOnTeam:
    return @"DBTEAMGroupsGetInfoErrorGroupNotOnTeam";
  case DBTEAMGroupsGetInfoErrorOther:
    return @"DBTEAMGroupsGetInfoErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGroupsGetInfoErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGroupsGetInfoErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGroupsGetInfoErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMGroupsGetInfoErrorGroupNotOnTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupsGetInfoErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupsGetInfoError:other];
}

- (BOOL)isEqualToGroupsGetInfoError:(DBTEAMGroupsGetInfoError *)aGroupsGetInfoError {
  if (self == aGroupsGetInfoError) {
    return YES;
  }
  if (self.tag != aGroupsGetInfoError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMGroupsGetInfoErrorGroupNotOnTeam:
    return [[self tagName] isEqual:[aGroupsGetInfoError tagName]];
  case DBTEAMGroupsGetInfoErrorOther:
    return [[self tagName] isEqual:[aGroupsGetInfoError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGroupsGetInfoErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupsGetInfoError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isGroupNotOnTeam]) {
    jsonDict[@".tag"] = @"group_not_on_team";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGroupsGetInfoError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"group_not_on_team"]) {
    return [[DBTEAMGroupsGetInfoError alloc] initWithGroupNotOnTeam];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMGroupsGetInfoError alloc] initWithOther];
  } else {
    return [[DBTEAMGroupsGetInfoError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMGroupFullInfo.h"
#import "DBTEAMGroupsGetInfoItem.h"

#pragma mark - API Object

@implementation DBTEAMGroupsGetInfoItem

@synthesize idNotFound = _idNotFound;
@synthesize groupInfo = _groupInfo;

#pragma mark - Constructors

- (instancetype)initWithIdNotFound:(NSString *)idNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupsGetInfoItemIdNotFound;
    _idNotFound = idNotFound;
  }
  return self;
}

- (instancetype)initWithGroupInfo:(DBTEAMGroupFullInfo *)groupInfo {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupsGetInfoItemGroupInfo;
    _groupInfo = groupInfo;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSString *)idNotFound {
  if (![self isIdNotFound]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMGroupsGetInfoItemIdNotFound, but was %@.", [self tagName]];
  }
  return _idNotFound;
}

- (DBTEAMGroupFullInfo *)groupInfo {
  if (![self isGroupInfo]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMGroupsGetInfoItemGroupInfo, but was %@.", [self tagName]];
  }
  return _groupInfo;
}

#pragma mark - Tag state methods

- (BOOL)isIdNotFound {
  return _tag == DBTEAMGroupsGetInfoItemIdNotFound;
}

- (BOOL)isGroupInfo {
  return _tag == DBTEAMGroupsGetInfoItemGroupInfo;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMGroupsGetInfoItemIdNotFound:
    return @"DBTEAMGroupsGetInfoItemIdNotFound";
  case DBTEAMGroupsGetInfoItemGroupInfo:
    return @"DBTEAMGroupsGetInfoItemGroupInfo";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGroupsGetInfoItemSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGroupsGetInfoItemSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGroupsGetInfoItemSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMGroupsGetInfoItemIdNotFound:
    result = prime * result + [self.idNotFound hash];
    break;
  case DBTEAMGroupsGetInfoItemGroupInfo:
    result = prime * result + [self.groupInfo hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupsGetInfoItem:other];
}

- (BOOL)isEqualToGroupsGetInfoItem:(DBTEAMGroupsGetInfoItem *)aGroupsGetInfoItem {
  if (self == aGroupsGetInfoItem) {
    return YES;
  }
  if (self.tag != aGroupsGetInfoItem.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMGroupsGetInfoItemIdNotFound:
    return [self.idNotFound isEqual:aGroupsGetInfoItem.idNotFound];
  case DBTEAMGroupsGetInfoItemGroupInfo:
    return [self.groupInfo isEqual:aGroupsGetInfoItem.groupInfo];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGroupsGetInfoItemSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupsGetInfoItem *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isIdNotFound]) {
    jsonDict[@"id_not_found"] = valueObj.idNotFound;
    jsonDict[@".tag"] = @"id_not_found";
  } else if ([valueObj isGroupInfo]) {
    jsonDict = [[DBTEAMGroupFullInfoSerializer serialize:valueObj.groupInfo] mutableCopy];
    jsonDict[@".tag"] = @"group_info";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGroupsGetInfoItem *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"id_not_found"]) {
    NSString *idNotFound = valueDict[@"id_not_found"];
    return [[DBTEAMGroupsGetInfoItem alloc] initWithIdNotFound:idNotFound];
  } else if ([tag isEqualToString:@"group_info"]) {
    DBTEAMGroupFullInfo *groupInfo = [DBTEAMGroupFullInfoSerializer deserialize:valueDict];
    return [[DBTEAMGroupsGetInfoItem alloc] initWithGroupInfo:groupInfo];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMGroupsListArg.h"

#pragma mark - API Object

@implementation DBTEAMGroupsListArg

#pragma mark - Constructors

- (instancetype)initWithLimit:(NSNumber *)limit {

  self = [super init];
  if (self) {
    _limit = limit ?: @(1000);
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithLimit:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGroupsListArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGroupsListArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGroupsListArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.limit hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupsListArg:other];
}

- (BOOL)isEqualToGroupsListArg:(DBTEAMGroupsListArg *)aGroupsListArg {
  if (self == aGroupsListArg) {
    return YES;
  }
  if (![self.limit isEqual:aGroupsListArg.limit]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGroupsListArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupsListArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"limit"] = valueObj.limit;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGroupsListArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSNumber *limit = valueDict[@"limit"] ?: @(1000);

  return [[DBTEAMGroupsListArg alloc] initWithLimit:limit];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMGroupsListContinueArg.h"

#pragma mark - API Object

@implementation DBTEAMGroupsListContinueArg

#pragma mark - Constructors

- (instancetype)initWithCursor:(NSString *)cursor {
  [DBStoneValidators nonnullValidator:nil](cursor);

  self = [super init];
  if (self) {
    _cursor = cursor;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGroupsListContinueArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGroupsListContinueArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGroupsListContinueArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.cursor hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupsListContinueArg:other];
}

- (BOOL)isEqualToGroupsListContinueArg:(DBTEAMGroupsListContinueArg *)aGroupsListContinueArg {
  if (self == aGroupsListContinueArg) {
    return YES;
  }
  if (![self.cursor isEqual:aGroupsListContinueArg.cursor]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGroupsListContinueArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupsListContinueArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"cursor"] = valueObj.cursor;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGroupsListContinueArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *cursor = valueDict[@"cursor"];

  return [[DBTEAMGroupsListContinueArg alloc] initWithCursor:cursor];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMGroupsListContinueError.h"

#pragma mark - API Object

@implementation DBTEAMGroupsListContinueError

#pragma mark - Constructors

- (instancetype)initWithInvalidCursor {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupsListContinueErrorInvalidCursor;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupsListContinueErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isInvalidCursor {
  return _tag == DBTEAMGroupsListContinueErrorInvalidCursor;
}

- (BOOL)isOther {
  return _tag == DBTEAMGroupsListContinueErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMGroupsListContinueErrorInvalidCursor:
    return @"DBTEAMGroupsListContinueErrorInvalidCursor";
  case DBTEAMGroupsListContinueErrorOther:
    return @"DBTEAMGroupsListContinueErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGroupsListContinueErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGroupsListContinueErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGroupsListContinueErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMGroupsListContinueErrorInvalidCursor:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupsListContinueErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupsListContinueError:other];
}

- (BOOL)isEqualToGroupsListContinueError:(DBTEAMGroupsListContinueError *)aGroupsListContinueError {
  if (self == aGroupsListContinueError) {
    return YES;
  }
  if (self.tag != aGroupsListContinueError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMGroupsListContinueErrorInvalidCursor:
    return [[self tagName] isEqual:[aGroupsListContinueError tagName]];
  case DBTEAMGroupsListContinueErrorOther:
    return [[self tagName] isEqual:[aGroupsListContinueError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGroupsListContinueErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupsListContinueError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isInvalidCursor]) {
    jsonDict[@".tag"] = @"invalid_cursor";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGroupsListContinueError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"invalid_cursor"]) {
    return [[DBTEAMGroupsListContinueError alloc] initWithInvalidCursor];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMGroupsListContinueError alloc] initWithOther];
  } else {
    return [[DBTEAMGroupsListContinueError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMCOMMONGroupSummary.h"
#import "DBTEAMGroupsListResult.h"

#pragma mark - API Object

@implementation DBTEAMGroupsListResult

#pragma mark - Constructors

- (instancetype)initWithGroups:(NSArray<DBTEAMCOMMONGroupSummary *> *)groups
                        cursor:(NSString *)cursor
                       hasMore:(NSNumber *)hasMore {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](groups);
  [DBStoneValidators nonnullValidator:nil](cursor);
  [DBStoneValidators nonnullValidator:nil](hasMore);

  self = [super init];
  if (self) {
    _groups = groups;
    _cursor = cursor;
    _hasMore = hasMore;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGroupsListResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGroupsListResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGroupsListResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.groups hash];
  result = prime * result + [self.cursor hash];
  result = prime * result + [self.hasMore hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupsListResult:other];
}

- (BOOL)isEqualToGroupsListResult:(DBTEAMGroupsListResult *)aGroupsListResult {
  if (self == aGroupsListResult) {
    return YES;
  }
  if (![self.groups isEqual:aGroupsListResult.groups]) {
    return NO;
  }
  if (![self.cursor isEqual:aGroupsListResult.cursor]) {
    return NO;
  }
  if (![self.hasMore isEqual:aGroupsListResult.hasMore]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGroupsListResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupsListResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"groups"] = [DBArraySerializer serialize:valueObj.groups
                                           withBlock:^id(id elem0) {
                                             return [DBTEAMCOMMONGroupSummarySerializer serialize:elem0];
                                           }];
  jsonDict[@"cursor"] = valueObj.cursor;
  jsonDict[@"has_more"] = valueObj.hasMore;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGroupsListResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBTEAMCOMMONGroupSummary *> *groups =
      [DBArraySerializer deserialize:valueDict[@"groups"]
                           withBlock:^id(id elem0) {
                             return [DBTEAMCOMMONGroupSummarySerializer deserialize:elem0];
                           }];
  NSString *cursor = valueDict[@"cursor"];
  NSNumber *hasMore = valueDict[@"has_more"];

  return [[DBTEAMGroupsListResult alloc] initWithGroups:groups cursor:cursor hasMore:hasMore];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMGroupSelector.h"
#import "DBTEAMGroupsMembersListArg.h"

#pragma mark - API Object

@implementation DBTEAMGroupsMembersListArg

#pragma mark - Constructors

- (instancetype)initWithGroup:(DBTEAMGroupSelector *)group limit:(NSNumber *)limit {
  [DBStoneValidators nonnullValidator:nil](group);

  self = [super init];
  if (self) {
    _group = group;
    _limit = limit ?: @(1000);
  }
  return self;
}

- (instancetype)initWithGroup:(DBTEAMGroupSelector *)group {
  return [self initWithGroup:group limit:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGroupsMembersListArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGroupsMembersListArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGroupsMembersListArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.group hash];
  result = prime * result + [self.limit hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupsMembersListArg:other];
}

- (BOOL)isEqualToGroupsMembersListArg:(DBTEAMGroupsMembersListArg *)aGroupsMembersListArg {
  if (self == aGroupsMembersListArg) {
    return YES;
  }
  if (![self.group isEqual:aGroupsMembersListArg.group]) {
    return NO;
  }
  if (![self.limit isEqual:aGroupsMembersListArg.limit]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGroupsMembersListArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupsMembersListArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"group"] = [DBTEAMGroupSelectorSerializer serialize:valueObj.group];
  jsonDict[@"limit"] = valueObj.limit;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGroupsMembersListArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMGroupSelector *group = [DBTEAMGroupSelectorSerializer deserialize:valueDict[@"group"]];
  NSNumber *limit = valueDict[@"limit"] ?: @(1000);

  return [[DBTEAMGroupsMembersListArg alloc] initWithGroup:group limit:limit];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMGroupsMembersListContinueArg.h"

#pragma mark - API Object

@implementation DBTEAMGroupsMembersListContinueArg

#pragma mark - Constructors

- (instancetype)initWithCursor:(NSString *)cursor {
  [DBStoneValidators nonnullValidator:nil](cursor);

  self = [super init];
  if (self) {
    _cursor = cursor;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGroupsMembersListContinueArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGroupsMembersListContinueArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGroupsMembersListContinueArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.cursor hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupsMembersListContinueArg:other];
}

- (BOOL)isEqualToGroupsMembersListContinueArg:(DBTEAMGroupsMembersListContinueArg *)aGroupsMembersListContinueArg {
  if (self == aGroupsMembersListContinueArg) {
    return YES;
  }
  if (![self.cursor isEqual:aGroupsMembersListContinueArg.cursor]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGroupsMembersListContinueArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupsMembersListContinueArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"cursor"] = valueObj.cursor;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGroupsMembersListContinueArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *cursor = valueDict[@"cursor"];

  return [[DBTEAMGroupsMembersListContinueArg alloc] initWithCursor:cursor];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMGroupsMembersListContinueError.h"

#pragma mark - API Object

@implementation DBTEAMGroupsMembersListContinueError

#pragma mark - Constructors

- (instancetype)initWithInvalidCursor {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupsMembersListContinueErrorInvalidCursor;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupsMembersListContinueErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isInvalidCursor {
  return _tag == DBTEAMGroupsMembersListContinueErrorInvalidCursor;
}

- (BOOL)isOther {
  return _tag == DBTEAMGroupsMembersListContinueErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMGroupsMembersListContinueErrorInvalidCursor:
    return @"DBTEAMGroupsMembersListContinueErrorInvalidCursor";
  case DBTEAMGroupsMembersListContinueErrorOther:
    return @"DBTEAMGroupsMembersListContinueErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGroupsMembersListContinueErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGroupsMembersListContinueErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGroupsMembersListContinueErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMGroupsMembersListContinueErrorInvalidCursor:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupsMembersListContinueErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupsMembersListContinueError:other];
}

- (BOOL)isEqualToGroupsMembersListContinueError:
    (DBTEAMGroupsMembersListContinueError *)aGroupsMembersListContinueError {
  if (self == aGroupsMembersListContinueError) {
    return YES;
  }
  if (self.tag != aGroupsMembersListContinueError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMGroupsMembersListContinueErrorInvalidCursor:
    return [[self tagName] isEqual:[aGroupsMembersListContinueError tagName]];
  case DBTEAMGroupsMembersListContinueErrorOther:
    return [[self tagName] isEqual:[aGroupsMembersListContinueError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGroupsMembersListContinueErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupsMembersListContinueError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isInvalidCursor]) {
    jsonDict[@".tag"] = @"invalid_cursor";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGroupsMembersListContinueError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"invalid_cursor"]) {
    return [[DBTEAMGroupsMembersListContinueError alloc] initWithInvalidCursor];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMGroupsMembersListContinueError alloc] initWithOther];
  } else {
    return [[DBTEAMGroupsMembersListContinueError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMGroupMemberInfo.h"
#import "DBTEAMGroupsMembersListResult.h"

#pragma mark - API Object

@implementation DBTEAMGroupsMembersListResult

#pragma mark - Constructors

- (instancetype)initWithMembers:(NSArray<DBTEAMGroupMemberInfo *> *)members
                         cursor:(NSString *)cursor
                        hasMore:(NSNumber *)hasMore {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](members);
  [DBStoneValidators nonnullValidator:nil](cursor);
  [DBStoneValidators nonnullValidator:nil](hasMore);

  self = [super init];
  if (self) {
    _members = members;
    _cursor = cursor;
    _hasMore = hasMore;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGroupsMembersListResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGroupsMembersListResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGroupsMembersListResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.members hash];
  result = prime * result + [self.cursor hash];
  result = prime * result + [self.hasMore hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupsMembersListResult:other];
}

- (BOOL)isEqualToGroupsMembersListResult:(DBTEAMGroupsMembersListResult *)aGroupsMembersListResult {
  if (self == aGroupsMembersListResult) {
    return YES;
  }
  if (![self.members isEqual:aGroupsMembersListResult.members]) {
    return NO;
  }
  if (![self.cursor isEqual:aGroupsMembersListResult.cursor]) {
    return NO;
  }
  if (![self.hasMore isEqual:aGroupsMembersListResult.hasMore]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGroupsMembersListResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupsMembersListResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"members"] = [DBArraySerializer serialize:valueObj.members
                                            withBlock:^id(id elem0) {
                                              return [DBTEAMGroupMemberInfoSerializer serialize:elem0];
                                            }];
  jsonDict[@"cursor"] = valueObj.cursor;
  jsonDict[@"has_more"] = valueObj.hasMore;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGroupsMembersListResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBTEAMGroupMemberInfo *> *members =
      [DBArraySerializer deserialize:valueDict[@"members"]
                           withBlock:^id(id elem0) {
                             return [DBTEAMGroupMemberInfoSerializer deserialize:elem0];
                           }];
  NSString *cursor = valueDict[@"cursor"];
  NSNumber *hasMore = valueDict[@"has_more"];

  return [[DBTEAMGroupsMembersListResult alloc] initWithMembers:members cursor:cursor hasMore:hasMore];
}

@end

#import "DBASYNCPollError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMGroupsPollError.h"

#pragma mark - API Object

@implementation DBTEAMGroupsPollError

#pragma mark - Constructors

- (instancetype)initWithInvalidAsyncJobId {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupsPollErrorInvalidAsyncJobId;
  }
  return self;
}

- (instancetype)initWithInternalError {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupsPollErrorInternalError;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupsPollErrorOther;
  }
  return self;
}

- (instancetype)initWithAccessDenied {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupsPollErrorAccessDenied;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isInvalidAsyncJobId {
  return _tag == DBTEAMGroupsPollErrorInvalidAsyncJobId;
}

- (BOOL)isInternalError {
  return _tag == DBTEAMGroupsPollErrorInternalError;
}

- (BOOL)isOther {
  return _tag == DBTEAMGroupsPollErrorOther;
}

- (BOOL)isAccessDenied {
  return _tag == DBTEAMGroupsPollErrorAccessDenied;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMGroupsPollErrorInvalidAsyncJobId:
    return @"DBTEAMGroupsPollErrorInvalidAsyncJobId";
  case DBTEAMGroupsPollErrorInternalError:
    return @"DBTEAMGroupsPollErrorInternalError";
  case DBTEAMGroupsPollErrorOther:
    return @"DBTEAMGroupsPollErrorOther";
  case DBTEAMGroupsPollErrorAccessDenied:
    return @"DBTEAMGroupsPollErrorAccessDenied";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGroupsPollErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGroupsPollErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGroupsPollErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMGroupsPollErrorInvalidAsyncJobId:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupsPollErrorInternalError:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupsPollErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMGroupsPollErrorAccessDenied:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupsPollError:other];
}

- (BOOL)isEqualToGroupsPollError:(DBTEAMGroupsPollError *)aGroupsPollError {
  if (self == aGroupsPollError) {
    return YES;
  }
  if (self.tag != aGroupsPollError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMGroupsPollErrorInvalidAsyncJobId:
    return [[self tagName] isEqual:[aGroupsPollError tagName]];
  case DBTEAMGroupsPollErrorInternalError:
    return [[self tagName] isEqual:[aGroupsPollError tagName]];
  case DBTEAMGroupsPollErrorOther:
    return [[self tagName] isEqual:[aGroupsPollError tagName]];
  case DBTEAMGroupsPollErrorAccessDenied:
    return [[self tagName] isEqual:[aGroupsPollError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGroupsPollErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupsPollError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isInvalidAsyncJobId]) {
    jsonDict[@".tag"] = @"invalid_async_job_id";
  } else if ([valueObj isInternalError]) {
    jsonDict[@".tag"] = @"internal_error";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isAccessDenied]) {
    jsonDict[@".tag"] = @"access_denied";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGroupsPollError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"invalid_async_job_id"]) {
    return [[DBTEAMGroupsPollError alloc] initWithInvalidAsyncJobId];
  } else if ([tag isEqualToString:@"internal_error"]) {
    return [[DBTEAMGroupsPollError alloc] initWithInternalError];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMGroupsPollError alloc] initWithOther];
  } else if ([tag isEqualToString:@"access_denied"]) {
    return [[DBTEAMGroupsPollError alloc] initWithAccessDenied];
  } else {
    return [[DBTEAMGroupsPollError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMGroupsSelector.h"

#pragma mark - API Object

@implementation DBTEAMGroupsSelector

@synthesize groupIds = _groupIds;
@synthesize groupExternalIds = _groupExternalIds;

#pragma mark - Constructors

- (instancetype)initWithGroupIds:(NSArray<NSString *> *)groupIds {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupsSelectorGroupIds;
    _groupIds = groupIds;
  }
  return self;
}

- (instancetype)initWithGroupExternalIds:(NSArray<NSString *> *)groupExternalIds {
  self = [super init];
  if (self) {
    _tag = DBTEAMGroupsSelectorGroupExternalIds;
    _groupExternalIds = groupExternalIds;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSArray<NSString *> *)groupIds {
  if (![self isGroupIds]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMGroupsSelectorGroupIds, but was %@.", [self tagName]];
  }
  return _groupIds;
}

- (NSArray<NSString *> *)groupExternalIds {
  if (![self isGroupExternalIds]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMGroupsSelectorGroupExternalIds, but was %@.", [self tagName]];
  }
  return _groupExternalIds;
}

#pragma mark - Tag state methods

- (BOOL)isGroupIds {
  return _tag == DBTEAMGroupsSelectorGroupIds;
}

- (BOOL)isGroupExternalIds {
  return _tag == DBTEAMGroupsSelectorGroupExternalIds;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMGroupsSelectorGroupIds:
    return @"DBTEAMGroupsSelectorGroupIds";
  case DBTEAMGroupsSelectorGroupExternalIds:
    return @"DBTEAMGroupsSelectorGroupExternalIds";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMGroupsSelectorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMGroupsSelectorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMGroupsSelectorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMGroupsSelectorGroupIds:
    result = prime * result + [self.groupIds hash];
    break;
  case DBTEAMGroupsSelectorGroupExternalIds:
    result = prime * result + [self.groupExternalIds hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupsSelector:other];
}

- (BOOL)isEqualToGroupsSelector:(DBTEAMGroupsSelector *)aGroupsSelector {
  if (self == aGroupsSelector) {
    return YES;
  }
  if (self.tag != aGroupsSelector.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMGroupsSelectorGroupIds:
    return [self.groupIds isEqual:aGroupsSelector.groupIds];
  case DBTEAMGroupsSelectorGroupExternalIds:
    return [self.groupExternalIds isEqual:aGroupsSelector.groupExternalIds];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMGroupsSelectorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMGroupsSelector *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isGroupIds]) {
    jsonDict[@"group_ids"] = [DBArraySerializer serialize:valueObj.groupIds
                                                withBlock:^id(id elem0) {
                                                  return elem0;
                                                }];
    jsonDict[@".tag"] = @"group_ids";
  } else if ([valueObj isGroupExternalIds]) {
    jsonDict[@"group_external_ids"] = [DBArraySerializer serialize:valueObj.groupExternalIds
                                                         withBlock:^id(id elem0) {
                                                           return elem0;
                                                         }];
    jsonDict[@".tag"] = @"group_external_ids";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMGroupsSelector *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"group_ids"]) {
    NSArray<NSString *> *groupIds = [DBArraySerializer deserialize:valueDict[@"group_ids"]
                                                         withBlock:^id(id elem0) {
                                                           return elem0;
                                                         }];
    return [[DBTEAMGroupsSelector alloc] initWithGroupIds:groupIds];
  } else if ([tag isEqualToString:@"group_external_ids"]) {
    NSArray<NSString *> *groupExternalIds = [DBArraySerializer deserialize:valueDict[@"group_external_ids"]
                                                                 withBlock:^id(id elem0) {
                                                                   return elem0;
                                                                 }];
    return [[DBTEAMGroupsSelector alloc] initWithGroupExternalIds:groupExternalIds];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMHasTeamFileEventsValue.h"

#pragma mark - API Object

@implementation DBTEAMHasTeamFileEventsValue

@synthesize enabled = _enabled;

#pragma mark - Constructors

- (instancetype)initWithEnabled:(NSNumber *)enabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMHasTeamFileEventsValueEnabled;
    _enabled = enabled;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMHasTeamFileEventsValueOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSNumber *)enabled {
  if (![self isEnabled]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMHasTeamFileEventsValueEnabled, but was %@.", [self tagName]];
  }
  return _enabled;
}

#pragma mark - Tag state methods

- (BOOL)isEnabled {
  return _tag == DBTEAMHasTeamFileEventsValueEnabled;
}

- (BOOL)isOther {
  return _tag == DBTEAMHasTeamFileEventsValueOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMHasTeamFileEventsValueEnabled:
    return @"DBTEAMHasTeamFileEventsValueEnabled";
  case DBTEAMHasTeamFileEventsValueOther:
    return @"DBTEAMHasTeamFileEventsValueOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMHasTeamFileEventsValueSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMHasTeamFileEventsValueSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMHasTeamFileEventsValueSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMHasTeamFileEventsValueEnabled:
    result = prime * result + [self.enabled hash];
    break;
  case DBTEAMHasTeamFileEventsValueOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToHasTeamFileEventsValue:other];
}

- (BOOL)isEqualToHasTeamFileEventsValue:(DBTEAMHasTeamFileEventsValue *)aHasTeamFileEventsValue {
  if (self == aHasTeamFileEventsValue) {
    return YES;
  }
  if (self.tag != aHasTeamFileEventsValue.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMHasTeamFileEventsValueEnabled:
    return [self.enabled isEqual:aHasTeamFileEventsValue.enabled];
  case DBTEAMHasTeamFileEventsValueOther:
    return [[self tagName] isEqual:[aHasTeamFileEventsValue tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMHasTeamFileEventsValueSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMHasTeamFileEventsValue *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isEnabled]) {
    jsonDict[@"enabled"] = valueObj.enabled;
    jsonDict[@".tag"] = @"enabled";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMHasTeamFileEventsValue *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"enabled"]) {
    NSNumber *enabled = valueDict[@"enabled"];
    return [[DBTEAMHasTeamFileEventsValue alloc] initWithEnabled:enabled];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMHasTeamFileEventsValue alloc] initWithOther];
  } else {
    return [[DBTEAMHasTeamFileEventsValue alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMHasTeamSelectiveSyncValue.h"

#pragma mark - API Object

@implementation DBTEAMHasTeamSelectiveSyncValue

@synthesize hasTeamSelectiveSync = _hasTeamSelectiveSync;

#pragma mark - Constructors

- (instancetype)initWithHasTeamSelectiveSync:(NSNumber *)hasTeamSelectiveSync {
  self = [super init];
  if (self) {
    _tag = DBTEAMHasTeamSelectiveSyncValueHasTeamSelectiveSync;
    _hasTeamSelectiveSync = hasTeamSelectiveSync;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMHasTeamSelectiveSyncValueOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSNumber *)hasTeamSelectiveSync {
  if (![self isHasTeamSelectiveSync]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMHasTeamSelectiveSyncValueHasTeamSelectiveSync, but was %@.",
                       [self tagName]];
  }
  return _hasTeamSelectiveSync;
}

#pragma mark - Tag state methods

- (BOOL)isHasTeamSelectiveSync {
  return _tag == DBTEAMHasTeamSelectiveSyncValueHasTeamSelectiveSync;
}

- (BOOL)isOther {
  return _tag == DBTEAMHasTeamSelectiveSyncValueOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMHasTeamSelectiveSyncValueHasTeamSelectiveSync:
    return @"DBTEAMHasTeamSelectiveSyncValueHasTeamSelectiveSync";
  case DBTEAMHasTeamSelectiveSyncValueOther:
    return @"DBTEAMHasTeamSelectiveSyncValueOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMHasTeamSelectiveSyncValueSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMHasTeamSelectiveSyncValueSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMHasTeamSelectiveSyncValueSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMHasTeamSelectiveSyncValueHasTeamSelectiveSync:
    result = prime * result + [self.hasTeamSelectiveSync hash];
    break;
  case DBTEAMHasTeamSelectiveSyncValueOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToHasTeamSelectiveSyncValue:other];
}

- (BOOL)isEqualToHasTeamSelectiveSyncValue:(DBTEAMHasTeamSelectiveSyncValue *)aHasTeamSelectiveSyncValue {
  if (self == aHasTeamSelectiveSyncValue) {
    return YES;
  }
  if (self.tag != aHasTeamSelectiveSyncValue.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMHasTeamSelectiveSyncValueHasTeamSelectiveSync:
    return [self.hasTeamSelectiveSync isEqual:aHasTeamSelectiveSyncValue.hasTeamSelectiveSync];
  case DBTEAMHasTeamSelectiveSyncValueOther:
    return [[self tagName] isEqual:[aHasTeamSelectiveSyncValue tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMHasTeamSelectiveSyncValueSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMHasTeamSelectiveSyncValue *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isHasTeamSelectiveSync]) {
    jsonDict[@"has_team_selective_sync"] = valueObj.hasTeamSelectiveSync;
    jsonDict[@".tag"] = @"has_team_selective_sync";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMHasTeamSelectiveSyncValue *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"has_team_selective_sync"]) {
    NSNumber *hasTeamSelectiveSync = valueDict[@"has_team_selective_sync"];
    return [[DBTEAMHasTeamSelectiveSyncValue alloc] initWithHasTeamSelectiveSync:hasTeamSelectiveSync];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMHasTeamSelectiveSyncValue alloc] initWithOther];
  } else {
    return [[DBTEAMHasTeamSelectiveSyncValue alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMHasTeamSharedDropboxValue.h"

#pragma mark - API Object

@implementation DBTEAMHasTeamSharedDropboxValue

@synthesize hasTeamSharedDropbox = _hasTeamSharedDropbox;

#pragma mark - Constructors

- (instancetype)initWithHasTeamSharedDropbox:(NSNumber *)hasTeamSharedDropbox {
  self = [super init];
  if (self) {
    _tag = DBTEAMHasTeamSharedDropboxValueHasTeamSharedDropbox;
    _hasTeamSharedDropbox = hasTeamSharedDropbox;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMHasTeamSharedDropboxValueOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSNumber *)hasTeamSharedDropbox {
  if (![self isHasTeamSharedDropbox]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMHasTeamSharedDropboxValueHasTeamSharedDropbox, but was %@.",
                       [self tagName]];
  }
  return _hasTeamSharedDropbox;
}

#pragma mark - Tag state methods

- (BOOL)isHasTeamSharedDropbox {
  return _tag == DBTEAMHasTeamSharedDropboxValueHasTeamSharedDropbox;
}

- (BOOL)isOther {
  return _tag == DBTEAMHasTeamSharedDropboxValueOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMHasTeamSharedDropboxValueHasTeamSharedDropbox:
    return @"DBTEAMHasTeamSharedDropboxValueHasTeamSharedDropbox";
  case DBTEAMHasTeamSharedDropboxValueOther:
    return @"DBTEAMHasTeamSharedDropboxValueOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMHasTeamSharedDropboxValueSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMHasTeamSharedDropboxValueSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMHasTeamSharedDropboxValueSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMHasTeamSharedDropboxValueHasTeamSharedDropbox:
    result = prime * result + [self.hasTeamSharedDropbox hash];
    break;
  case DBTEAMHasTeamSharedDropboxValueOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToHasTeamSharedDropboxValue:other];
}

- (BOOL)isEqualToHasTeamSharedDropboxValue:(DBTEAMHasTeamSharedDropboxValue *)aHasTeamSharedDropboxValue {
  if (self == aHasTeamSharedDropboxValue) {
    return YES;
  }
  if (self.tag != aHasTeamSharedDropboxValue.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMHasTeamSharedDropboxValueHasTeamSharedDropbox:
    return [self.hasTeamSharedDropbox isEqual:aHasTeamSharedDropboxValue.hasTeamSharedDropbox];
  case DBTEAMHasTeamSharedDropboxValueOther:
    return [[self tagName] isEqual:[aHasTeamSharedDropboxValue tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMHasTeamSharedDropboxValueSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMHasTeamSharedDropboxValue *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isHasTeamSharedDropbox]) {
    jsonDict[@"has_team_shared_dropbox"] = valueObj.hasTeamSharedDropbox;
    jsonDict[@".tag"] = @"has_team_shared_dropbox";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMHasTeamSharedDropboxValue *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"has_team_shared_dropbox"]) {
    NSNumber *hasTeamSharedDropbox = valueDict[@"has_team_shared_dropbox"];
    return [[DBTEAMHasTeamSharedDropboxValue alloc] initWithHasTeamSharedDropbox:hasTeamSharedDropbox];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMHasTeamSharedDropboxValue alloc] initWithOther];
  } else {
    return [[DBTEAMHasTeamSharedDropboxValue alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLegalHoldHeldRevisionMetadata.h"
#import "DBTEAMTeamMemberStatus.h"

#pragma mark - API Object

@implementation DBTEAMLegalHoldHeldRevisionMetadata

#pragma mark - Constructors

- (instancetype)initWithDNewFilename:(NSString *)dNewFilename
                  originalRevisionId:(NSString *)originalRevisionId
                    originalFilePath:(NSString *)originalFilePath
                      serverModified:(NSDate *)serverModified
                      authorMemberId:(NSString *)authorMemberId
                  authorMemberStatus:(DBTEAMTeamMemberStatus *)authorMemberStatus
                         authorEmail:(NSString *)authorEmail
                            fileType:(NSString *)fileType
                                size:(NSNumber *)size
                         contentHash:(NSString *)contentHash {
  [DBStoneValidators nonnullValidator:nil](dNewFilename);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:@(9) maxLength:nil pattern:@"[0-9a-f]+"]](originalRevisionId);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"(/(.|[\\r\\n])*)?"]](
      originalFilePath);
  [DBStoneValidators nonnullValidator:nil](serverModified);
  [DBStoneValidators nonnullValidator:nil](authorMemberId);
  [DBStoneValidators nonnullValidator:nil](authorMemberStatus);
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:nil
                                                               maxLength:@(255)
                                                                 pattern:@"^['&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9."
                                                                         @"-]*\\.[A-Za-z]{2,15}$"]](authorEmail);
  [DBStoneValidators nonnullValidator:nil](fileType);
  [DBStoneValidators nonnullValidator:nil](size);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:@(64) maxLength:@(64) pattern:nil]](contentHash);

  self = [super init];
  if (self) {
    _dNewFilename = dNewFilename;
    _originalRevisionId = originalRevisionId;
    _originalFilePath = originalFilePath;
    _serverModified = serverModified;
    _authorMemberId = authorMemberId;
    _authorMemberStatus = authorMemberStatus;
    _authorEmail = authorEmail;
    _fileType = fileType;
    _size = size;
    _contentHash = contentHash;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLegalHoldHeldRevisionMetadataSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLegalHoldHeldRevisionMetadataSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLegalHoldHeldRevisionMetadataSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.dNewFilename hash];
  result = prime * result + [self.originalRevisionId hash];
  result = prime * result + [self.originalFilePath hash];
  result = prime * result + [self.serverModified hash];
  result = prime * result + [self.authorMemberId hash];
  result = prime * result + [self.authorMemberStatus hash];
  result = prime * result + [self.authorEmail hash];
  result = prime * result + [self.fileType hash];
  result = prime * result + [self.size hash];
  result = prime * result + [self.contentHash hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLegalHoldHeldRevisionMetadata:other];
}

- (BOOL)isEqualToLegalHoldHeldRevisionMetadata:(DBTEAMLegalHoldHeldRevisionMetadata *)aLegalHoldHeldRevisionMetadata {
  if (self == aLegalHoldHeldRevisionMetadata) {
    return YES;
  }
  if (![self.dNewFilename isEqual:aLegalHoldHeldRevisionMetadata.dNewFilename]) {
    return NO;
  }
  if (![self.originalRevisionId isEqual:aLegalHoldHeldRevisionMetadata.originalRevisionId]) {
    return NO;
  }
  if (![self.originalFilePath isEqual:aLegalHoldHeldRevisionMetadata.originalFilePath]) {
    return NO;
  }
  if (![self.serverModified isEqual:aLegalHoldHeldRevisionMetadata.serverModified]) {
    return NO;
  }
  if (![self.authorMemberId isEqual:aLegalHoldHeldRevisionMetadata.authorMemberId]) {
    return NO;
  }
  if (![self.authorMemberStatus isEqual:aLegalHoldHeldRevisionMetadata.authorMemberStatus]) {
    return NO;
  }
  if (![self.authorEmail isEqual:aLegalHoldHeldRevisionMetadata.authorEmail]) {
    return NO;
  }
  if (![self.fileType isEqual:aLegalHoldHeldRevisionMetadata.fileType]) {
    return NO;
  }
  if (![self.size isEqual:aLegalHoldHeldRevisionMetadata.size]) {
    return NO;
  }
  if (![self.contentHash isEqual:aLegalHoldHeldRevisionMetadata.contentHash]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLegalHoldHeldRevisionMetadataSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLegalHoldHeldRevisionMetadata *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"new_filename"] = valueObj.dNewFilename;
  jsonDict[@"original_revision_id"] = valueObj.originalRevisionId;
  jsonDict[@"original_file_path"] = valueObj.originalFilePath;
  jsonDict[@"server_modified"] =
      [DBNSDateSerializer serialize:valueObj.serverModified dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  jsonDict[@"author_member_id"] = valueObj.authorMemberId;
  jsonDict[@"author_member_status"] = [DBTEAMTeamMemberStatusSerializer serialize:valueObj.authorMemberStatus];
  jsonDict[@"author_email"] = valueObj.authorEmail;
  jsonDict[@"file_type"] = valueObj.fileType;
  jsonDict[@"size"] = valueObj.size;
  jsonDict[@"content_hash"] = valueObj.contentHash;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLegalHoldHeldRevisionMetadata *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *dNewFilename = valueDict[@"new_filename"];
  NSString *originalRevisionId = valueDict[@"original_revision_id"];
  NSString *originalFilePath = valueDict[@"original_file_path"];
  NSDate *serverModified =
      [DBNSDateSerializer deserialize:valueDict[@"server_modified"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  NSString *authorMemberId = valueDict[@"author_member_id"];
  DBTEAMTeamMemberStatus *authorMemberStatus =
      [DBTEAMTeamMemberStatusSerializer deserialize:valueDict[@"author_member_status"]];
  NSString *authorEmail = valueDict[@"author_email"];
  NSString *fileType = valueDict[@"file_type"];
  NSNumber *size = valueDict[@"size"];
  NSString *contentHash = valueDict[@"content_hash"];

  return [[DBTEAMLegalHoldHeldRevisionMetadata alloc] initWithDNewFilename:dNewFilename
                                                        originalRevisionId:originalRevisionId
                                                          originalFilePath:originalFilePath
                                                            serverModified:serverModified
                                                            authorMemberId:authorMemberId
                                                        authorMemberStatus:authorMemberStatus
                                                               authorEmail:authorEmail
                                                                  fileType:fileType
                                                                      size:size
                                                               contentHash:contentHash];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLegalHoldPolicy.h"
#import "DBTEAMLegalHoldStatus.h"
#import "DBTEAMMembersInfo.h"

#pragma mark - API Object

@implementation DBTEAMLegalHoldPolicy

#pragma mark - Constructors

- (instancetype)initWithId_:(NSString *)id_
                       name:(NSString *)name
                    members:(DBTEAMMembersInfo *)members
                     status:(DBTEAMLegalHoldStatus *)status
                  startDate:(NSDate *)startDate
               description_:(NSString *)description_
             activationTime:(NSDate *)activationTime
                    endDate:(NSDate *)endDate {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"^pid_dbhid:.+"]](id_);
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:nil maxLength:@(140) pattern:nil]](name);
  [DBStoneValidators nonnullValidator:nil](members);
  [DBStoneValidators nonnullValidator:nil](status);
  [DBStoneValidators nonnullValidator:nil](startDate);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators stringValidator:nil maxLength:@(501) pattern:nil]](description_);

  self = [super init];
  if (self) {
    _id_ = id_;
    _name = name;
    _description_ = description_;
    _activationTime = activationTime;
    _members = members;
    _status = status;
    _startDate = startDate;
    _endDate = endDate;
  }
  return self;
}

- (instancetype)initWithId_:(NSString *)id_
                       name:(NSString *)name
                    members:(DBTEAMMembersInfo *)members
                     status:(DBTEAMLegalHoldStatus *)status
                  startDate:(NSDate *)startDate {
  return [self initWithId_:id_
                      name:name
                   members:members
                    status:status
                 startDate:startDate
              description_:nil
            activationTime:nil
                   endDate:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLegalHoldPolicySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLegalHoldPolicySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLegalHoldPolicySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.id_ hash];
  result = prime * result + [self.name hash];
  result = prime * result + [self.members hash];
  result = prime * result + [self.status hash];
  result = prime * result + [self.startDate hash];
  if (self.description_ != nil) {
    result = prime * result + [self.description_ hash];
  }
  if (self.activationTime != nil) {
    result = prime * result + [self.activationTime hash];
  }
  if (self.endDate != nil) {
    result = prime * result + [self.endDate hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLegalHoldPolicy:other];
}

- (BOOL)isEqualToLegalHoldPolicy:(DBTEAMLegalHoldPolicy *)aLegalHoldPolicy {
  if (self == aLegalHoldPolicy) {
    return YES;
  }
  if (![self.id_ isEqual:aLegalHoldPolicy.id_]) {
    return NO;
  }
  if (![self.name isEqual:aLegalHoldPolicy.name]) {
    return NO;
  }
  if (![self.members isEqual:aLegalHoldPolicy.members]) {
    return NO;
  }
  if (![self.status isEqual:aLegalHoldPolicy.status]) {
    return NO;
  }
  if (![self.startDate isEqual:aLegalHoldPolicy.startDate]) {
    return NO;
  }
  if (self.description_) {
    if (![self.description_ isEqual:aLegalHoldPolicy.description_]) {
      return NO;
    }
  }
  if (self.activationTime) {
    if (![self.activationTime isEqual:aLegalHoldPolicy.activationTime]) {
      return NO;
    }
  }
  if (self.endDate) {
    if (![self.endDate isEqual:aLegalHoldPolicy.endDate]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLegalHoldPolicySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLegalHoldPolicy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"id"] = valueObj.id_;
  jsonDict[@"name"] = valueObj.name;
  jsonDict[@"members"] = [DBTEAMMembersInfoSerializer serialize:valueObj.members];
  jsonDict[@"status"] = [DBTEAMLegalHoldStatusSerializer serialize:valueObj.status];
  jsonDict[@"start_date"] = [DBNSDateSerializer serialize:valueObj.startDate dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  if (valueObj.description_) {
    jsonDict[@"description"] = valueObj.description_;
  }
  if (valueObj.activationTime) {
    jsonDict[@"activation_time"] =
        [DBNSDateSerializer serialize:valueObj.activationTime dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }
  if (valueObj.endDate) {
    jsonDict[@"end_date"] = [DBNSDateSerializer serialize:valueObj.endDate dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLegalHoldPolicy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *id_ = valueDict[@"id"];
  NSString *name = valueDict[@"name"];
  DBTEAMMembersInfo *members = [DBTEAMMembersInfoSerializer deserialize:valueDict[@"members"]];
  DBTEAMLegalHoldStatus *status = [DBTEAMLegalHoldStatusSerializer deserialize:valueDict[@"status"]];
  NSDate *startDate = [DBNSDateSerializer deserialize:valueDict[@"start_date"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  NSString *description_ = valueDict[@"description"] ?: nil;
  NSDate *activationTime = valueDict[@"activation_time"] ? [DBNSDateSerializer deserialize:valueDict[@"activation_time"]
                                                                                dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                                                         : nil;
  NSDate *endDate = valueDict[@"end_date"]
                        ? [DBNSDateSerializer deserialize:valueDict[@"end_date"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                        : nil;

  return [[DBTEAMLegalHoldPolicy alloc] initWithId_:id_
                                               name:name
                                            members:members
                                             status:status
                                          startDate:startDate
                                       description_:description_
                                     activationTime:activationTime
                                            endDate:endDate];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLegalHoldStatus.h"

#pragma mark - API Object

@implementation DBTEAMLegalHoldStatus

#pragma mark - Constructors

- (instancetype)initWithActive {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldStatusActive;
  }
  return self;
}

- (instancetype)initWithReleased {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldStatusReleased;
  }
  return self;
}

- (instancetype)initWithActivating {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldStatusActivating;
  }
  return self;
}

- (instancetype)initWithUpdating {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldStatusUpdating;
  }
  return self;
}

- (instancetype)initWithExporting {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldStatusExporting;
  }
  return self;
}

- (instancetype)initWithReleasing {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldStatusReleasing;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldStatusOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isActive {
  return _tag == DBTEAMLegalHoldStatusActive;
}

- (BOOL)isReleased {
  return _tag == DBTEAMLegalHoldStatusReleased;
}

- (BOOL)isActivating {
  return _tag == DBTEAMLegalHoldStatusActivating;
}

- (BOOL)isUpdating {
  return _tag == DBTEAMLegalHoldStatusUpdating;
}

- (BOOL)isExporting {
  return _tag == DBTEAMLegalHoldStatusExporting;
}

- (BOOL)isReleasing {
  return _tag == DBTEAMLegalHoldStatusReleasing;
}

- (BOOL)isOther {
  return _tag == DBTEAMLegalHoldStatusOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLegalHoldStatusActive:
    return @"DBTEAMLegalHoldStatusActive";
  case DBTEAMLegalHoldStatusReleased:
    return @"DBTEAMLegalHoldStatusReleased";
  case DBTEAMLegalHoldStatusActivating:
    return @"DBTEAMLegalHoldStatusActivating";
  case DBTEAMLegalHoldStatusUpdating:
    return @"DBTEAMLegalHoldStatusUpdating";
  case DBTEAMLegalHoldStatusExporting:
    return @"DBTEAMLegalHoldStatusExporting";
  case DBTEAMLegalHoldStatusReleasing:
    return @"DBTEAMLegalHoldStatusReleasing";
  case DBTEAMLegalHoldStatusOther:
    return @"DBTEAMLegalHoldStatusOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLegalHoldStatusSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLegalHoldStatusSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLegalHoldStatusSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLegalHoldStatusActive:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldStatusReleased:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldStatusActivating:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldStatusUpdating:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldStatusExporting:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldStatusReleasing:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldStatusOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLegalHoldStatus:other];
}

- (BOOL)isEqualToLegalHoldStatus:(DBTEAMLegalHoldStatus *)aLegalHoldStatus {
  if (self == aLegalHoldStatus) {
    return YES;
  }
  if (self.tag != aLegalHoldStatus.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLegalHoldStatusActive:
    return [[self tagName] isEqual:[aLegalHoldStatus tagName]];
  case DBTEAMLegalHoldStatusReleased:
    return [[self tagName] isEqual:[aLegalHoldStatus tagName]];
  case DBTEAMLegalHoldStatusActivating:
    return [[self tagName] isEqual:[aLegalHoldStatus tagName]];
  case DBTEAMLegalHoldStatusUpdating:
    return [[self tagName] isEqual:[aLegalHoldStatus tagName]];
  case DBTEAMLegalHoldStatusExporting:
    return [[self tagName] isEqual:[aLegalHoldStatus tagName]];
  case DBTEAMLegalHoldStatusReleasing:
    return [[self tagName] isEqual:[aLegalHoldStatus tagName]];
  case DBTEAMLegalHoldStatusOther:
    return [[self tagName] isEqual:[aLegalHoldStatus tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLegalHoldStatusSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLegalHoldStatus *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isActive]) {
    jsonDict[@".tag"] = @"active";
  } else if ([valueObj isReleased]) {
    jsonDict[@".tag"] = @"released";
  } else if ([valueObj isActivating]) {
    jsonDict[@".tag"] = @"activating";
  } else if ([valueObj isUpdating]) {
    jsonDict[@".tag"] = @"updating";
  } else if ([valueObj isExporting]) {
    jsonDict[@".tag"] = @"exporting";
  } else if ([valueObj isReleasing]) {
    jsonDict[@".tag"] = @"releasing";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLegalHoldStatus *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"active"]) {
    return [[DBTEAMLegalHoldStatus alloc] initWithActive];
  } else if ([tag isEqualToString:@"released"]) {
    return [[DBTEAMLegalHoldStatus alloc] initWithReleased];
  } else if ([tag isEqualToString:@"activating"]) {
    return [[DBTEAMLegalHoldStatus alloc] initWithActivating];
  } else if ([tag isEqualToString:@"updating"]) {
    return [[DBTEAMLegalHoldStatus alloc] initWithUpdating];
  } else if ([tag isEqualToString:@"exporting"]) {
    return [[DBTEAMLegalHoldStatus alloc] initWithExporting];
  } else if ([tag isEqualToString:@"releasing"]) {
    return [[DBTEAMLegalHoldStatus alloc] initWithReleasing];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLegalHoldStatus alloc] initWithOther];
  } else {
    return [[DBTEAMLegalHoldStatus alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLegalHoldsError.h"

#pragma mark - API Object

@implementation DBTEAMLegalHoldsError

#pragma mark - Constructors

- (instancetype)initWithUnknownLegalHoldError {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsErrorUnknownLegalHoldError;
  }
  return self;
}

- (instancetype)initWithInsufficientPermissions {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsErrorInsufficientPermissions;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isUnknownLegalHoldError {
  return _tag == DBTEAMLegalHoldsErrorUnknownLegalHoldError;
}

- (BOOL)isInsufficientPermissions {
  return _tag == DBTEAMLegalHoldsErrorInsufficientPermissions;
}

- (BOOL)isOther {
  return _tag == DBTEAMLegalHoldsErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLegalHoldsErrorUnknownLegalHoldError:
    return @"DBTEAMLegalHoldsErrorUnknownLegalHoldError";
  case DBTEAMLegalHoldsErrorInsufficientPermissions:
    return @"DBTEAMLegalHoldsErrorInsufficientPermissions";
  case DBTEAMLegalHoldsErrorOther:
    return @"DBTEAMLegalHoldsErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLegalHoldsErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLegalHoldsErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLegalHoldsErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLegalHoldsErrorUnknownLegalHoldError:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsErrorInsufficientPermissions:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLegalHoldsError:other];
}

- (BOOL)isEqualToLegalHoldsError:(DBTEAMLegalHoldsError *)aLegalHoldsError {
  if (self == aLegalHoldsError) {
    return YES;
  }
  if (self.tag != aLegalHoldsError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLegalHoldsErrorUnknownLegalHoldError:
    return [[self tagName] isEqual:[aLegalHoldsError tagName]];
  case DBTEAMLegalHoldsErrorInsufficientPermissions:
    return [[self tagName] isEqual:[aLegalHoldsError tagName]];
  case DBTEAMLegalHoldsErrorOther:
    return [[self tagName] isEqual:[aLegalHoldsError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLegalHoldsErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLegalHoldsError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUnknownLegalHoldError]) {
    jsonDict[@".tag"] = @"unknown_legal_hold_error";
  } else if ([valueObj isInsufficientPermissions]) {
    jsonDict[@".tag"] = @"insufficient_permissions";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLegalHoldsError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"unknown_legal_hold_error"]) {
    return [[DBTEAMLegalHoldsError alloc] initWithUnknownLegalHoldError];
  } else if ([tag isEqualToString:@"insufficient_permissions"]) {
    return [[DBTEAMLegalHoldsError alloc] initWithInsufficientPermissions];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLegalHoldsError alloc] initWithOther];
  } else {
    return [[DBTEAMLegalHoldsError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLegalHoldsGetPolicyArg.h"

#pragma mark - API Object

@implementation DBTEAMLegalHoldsGetPolicyArg

#pragma mark - Constructors

- (instancetype)initWithId_:(NSString *)id_ {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"^pid_dbhid:.+"]](id_);

  self = [super init];
  if (self) {
    _id_ = id_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLegalHoldsGetPolicyArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLegalHoldsGetPolicyArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLegalHoldsGetPolicyArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.id_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLegalHoldsGetPolicyArg:other];
}

- (BOOL)isEqualToLegalHoldsGetPolicyArg:(DBTEAMLegalHoldsGetPolicyArg *)aLegalHoldsGetPolicyArg {
  if (self == aLegalHoldsGetPolicyArg) {
    return YES;
  }
  if (![self.id_ isEqual:aLegalHoldsGetPolicyArg.id_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLegalHoldsGetPolicyArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLegalHoldsGetPolicyArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"id"] = valueObj.id_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLegalHoldsGetPolicyArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *id_ = valueDict[@"id"];

  return [[DBTEAMLegalHoldsGetPolicyArg alloc] initWithId_:id_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLegalHoldsError.h"
#import "DBTEAMLegalHoldsGetPolicyError.h"

#pragma mark - API Object

@implementation DBTEAMLegalHoldsGetPolicyError

#pragma mark - Constructors

- (instancetype)initWithUnknownLegalHoldError {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsGetPolicyErrorUnknownLegalHoldError;
  }
  return self;
}

- (instancetype)initWithInsufficientPermissions {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsGetPolicyErrorInsufficientPermissions;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsGetPolicyErrorOther;
  }
  return self;
}

- (instancetype)initWithLegalHoldPolicyNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsGetPolicyErrorLegalHoldPolicyNotFound;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isUnknownLegalHoldError {
  return _tag == DBTEAMLegalHoldsGetPolicyErrorUnknownLegalHoldError;
}

- (BOOL)isInsufficientPermissions {
  return _tag == DBTEAMLegalHoldsGetPolicyErrorInsufficientPermissions;
}

- (BOOL)isOther {
  return _tag == DBTEAMLegalHoldsGetPolicyErrorOther;
}

- (BOOL)isLegalHoldPolicyNotFound {
  return _tag == DBTEAMLegalHoldsGetPolicyErrorLegalHoldPolicyNotFound;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLegalHoldsGetPolicyErrorUnknownLegalHoldError:
    return @"DBTEAMLegalHoldsGetPolicyErrorUnknownLegalHoldError";
  case DBTEAMLegalHoldsGetPolicyErrorInsufficientPermissions:
    return @"DBTEAMLegalHoldsGetPolicyErrorInsufficientPermissions";
  case DBTEAMLegalHoldsGetPolicyErrorOther:
    return @"DBTEAMLegalHoldsGetPolicyErrorOther";
  case DBTEAMLegalHoldsGetPolicyErrorLegalHoldPolicyNotFound:
    return @"DBTEAMLegalHoldsGetPolicyErrorLegalHoldPolicyNotFound";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLegalHoldsGetPolicyErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLegalHoldsGetPolicyErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLegalHoldsGetPolicyErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLegalHoldsGetPolicyErrorUnknownLegalHoldError:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsGetPolicyErrorInsufficientPermissions:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsGetPolicyErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsGetPolicyErrorLegalHoldPolicyNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLegalHoldsGetPolicyError:other];
}

- (BOOL)isEqualToLegalHoldsGetPolicyError:(DBTEAMLegalHoldsGetPolicyError *)aLegalHoldsGetPolicyError {
  if (self == aLegalHoldsGetPolicyError) {
    return YES;
  }
  if (self.tag != aLegalHoldsGetPolicyError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLegalHoldsGetPolicyErrorUnknownLegalHoldError:
    return [[self tagName] isEqual:[aLegalHoldsGetPolicyError tagName]];
  case DBTEAMLegalHoldsGetPolicyErrorInsufficientPermissions:
    return [[self tagName] isEqual:[aLegalHoldsGetPolicyError tagName]];
  case DBTEAMLegalHoldsGetPolicyErrorOther:
    return [[self tagName] isEqual:[aLegalHoldsGetPolicyError tagName]];
  case DBTEAMLegalHoldsGetPolicyErrorLegalHoldPolicyNotFound:
    return [[self tagName] isEqual:[aLegalHoldsGetPolicyError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLegalHoldsGetPolicyErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLegalHoldsGetPolicyError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUnknownLegalHoldError]) {
    jsonDict[@".tag"] = @"unknown_legal_hold_error";
  } else if ([valueObj isInsufficientPermissions]) {
    jsonDict[@".tag"] = @"insufficient_permissions";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isLegalHoldPolicyNotFound]) {
    jsonDict[@".tag"] = @"legal_hold_policy_not_found";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLegalHoldsGetPolicyError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"unknown_legal_hold_error"]) {
    return [[DBTEAMLegalHoldsGetPolicyError alloc] initWithUnknownLegalHoldError];
  } else if ([tag isEqualToString:@"insufficient_permissions"]) {
    return [[DBTEAMLegalHoldsGetPolicyError alloc] initWithInsufficientPermissions];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLegalHoldsGetPolicyError alloc] initWithOther];
  } else if ([tag isEqualToString:@"legal_hold_policy_not_found"]) {
    return [[DBTEAMLegalHoldsGetPolicyError alloc] initWithLegalHoldPolicyNotFound];
  } else {
    return [[DBTEAMLegalHoldsGetPolicyError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLegalHoldHeldRevisionMetadata.h"
#import "DBTEAMLegalHoldsListHeldRevisionResult.h"

#pragma mark - API Object

@implementation DBTEAMLegalHoldsListHeldRevisionResult

#pragma mark - Constructors

- (instancetype)initWithEntries:(NSArray<DBTEAMLegalHoldHeldRevisionMetadata *> *)entries
                        hasMore:(NSNumber *)hasMore
                         cursor:(NSString *)cursor {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](entries);
  [DBStoneValidators nonnullValidator:nil](hasMore);
  [DBStoneValidators nullableValidator:[DBStoneValidators stringValidator:@(1) maxLength:nil pattern:nil]](cursor);

  self = [super init];
  if (self) {
    _entries = entries;
    _cursor = cursor;
    _hasMore = hasMore;
  }
  return self;
}

- (instancetype)initWithEntries:(NSArray<DBTEAMLegalHoldHeldRevisionMetadata *> *)entries hasMore:(NSNumber *)hasMore {
  return [self initWithEntries:entries hasMore:hasMore cursor:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLegalHoldsListHeldRevisionResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLegalHoldsListHeldRevisionResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLegalHoldsListHeldRevisionResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.entries hash];
  result = prime * result + [self.hasMore hash];
  if (self.cursor != nil) {
    result = prime * result + [self.cursor hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLegalHoldsListHeldRevisionResult:other];
}

- (BOOL)isEqualToLegalHoldsListHeldRevisionResult:
    (DBTEAMLegalHoldsListHeldRevisionResult *)aLegalHoldsListHeldRevisionResult {
  if (self == aLegalHoldsListHeldRevisionResult) {
    return YES;
  }
  if (![self.entries isEqual:aLegalHoldsListHeldRevisionResult.entries]) {
    return NO;
  }
  if (![self.hasMore isEqual:aLegalHoldsListHeldRevisionResult.hasMore]) {
    return NO;
  }
  if (self.cursor) {
    if (![self.cursor isEqual:aLegalHoldsListHeldRevisionResult.cursor]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLegalHoldsListHeldRevisionResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLegalHoldsListHeldRevisionResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"entries"] = [DBArraySerializer serialize:valueObj.entries
                                            withBlock:^id(id elem0) {
                                              return [DBTEAMLegalHoldHeldRevisionMetadataSerializer serialize:elem0];
                                            }];
  jsonDict[@"has_more"] = valueObj.hasMore;
  if (valueObj.cursor) {
    jsonDict[@"cursor"] = valueObj.cursor;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLegalHoldsListHeldRevisionResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBTEAMLegalHoldHeldRevisionMetadata *> *entries =
      [DBArraySerializer deserialize:valueDict[@"entries"]
                           withBlock:^id(id elem0) {
                             return [DBTEAMLegalHoldHeldRevisionMetadataSerializer deserialize:elem0];
                           }];
  NSNumber *hasMore = valueDict[@"has_more"];
  NSString *cursor = valueDict[@"cursor"] ?: nil;

  return [[DBTEAMLegalHoldsListHeldRevisionResult alloc] initWithEntries:entries hasMore:hasMore cursor:cursor];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLegalHoldsListHeldRevisionsArg.h"

#pragma mark - API Object

@implementation DBTEAMLegalHoldsListHeldRevisionsArg

#pragma mark - Constructors

- (instancetype)initWithId_:(NSString *)id_ {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"^pid_dbhid:.+"]](id_);

  self = [super init];
  if (self) {
    _id_ = id_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLegalHoldsListHeldRevisionsArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLegalHoldsListHeldRevisionsArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLegalHoldsListHeldRevisionsArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.id_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLegalHoldsListHeldRevisionsArg:other];
}

- (BOOL)isEqualToLegalHoldsListHeldRevisionsArg:
    (DBTEAMLegalHoldsListHeldRevisionsArg *)aLegalHoldsListHeldRevisionsArg {
  if (self == aLegalHoldsListHeldRevisionsArg) {
    return YES;
  }
  if (![self.id_ isEqual:aLegalHoldsListHeldRevisionsArg.id_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLegalHoldsListHeldRevisionsArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLegalHoldsListHeldRevisionsArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"id"] = valueObj.id_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLegalHoldsListHeldRevisionsArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *id_ = valueDict[@"id"];

  return [[DBTEAMLegalHoldsListHeldRevisionsArg alloc] initWithId_:id_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLegalHoldsListHeldRevisionsContinueArg.h"

#pragma mark - API Object

@implementation DBTEAMLegalHoldsListHeldRevisionsContinueArg

#pragma mark - Constructors

- (instancetype)initWithId_:(NSString *)id_ cursor:(NSString *)cursor {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"^pid_dbhid:.+"]](id_);
  [DBStoneValidators nullableValidator:[DBStoneValidators stringValidator:@(1) maxLength:nil pattern:nil]](cursor);

  self = [super init];
  if (self) {
    _id_ = id_;
    _cursor = cursor;
  }
  return self;
}

- (instancetype)initWithId_:(NSString *)id_ {
  return [self initWithId_:id_ cursor:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLegalHoldsListHeldRevisionsContinueArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLegalHoldsListHeldRevisionsContinueArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLegalHoldsListHeldRevisionsContinueArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.id_ hash];
  if (self.cursor != nil) {
    result = prime * result + [self.cursor hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLegalHoldsListHeldRevisionsContinueArg:other];
}

- (BOOL)isEqualToLegalHoldsListHeldRevisionsContinueArg:
    (DBTEAMLegalHoldsListHeldRevisionsContinueArg *)aLegalHoldsListHeldRevisionsContinueArg {
  if (self == aLegalHoldsListHeldRevisionsContinueArg) {
    return YES;
  }
  if (![self.id_ isEqual:aLegalHoldsListHeldRevisionsContinueArg.id_]) {
    return NO;
  }
  if (self.cursor) {
    if (![self.cursor isEqual:aLegalHoldsListHeldRevisionsContinueArg.cursor]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLegalHoldsListHeldRevisionsContinueArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLegalHoldsListHeldRevisionsContinueArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"id"] = valueObj.id_;
  if (valueObj.cursor) {
    jsonDict[@"cursor"] = valueObj.cursor;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLegalHoldsListHeldRevisionsContinueArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *id_ = valueDict[@"id"];
  NSString *cursor = valueDict[@"cursor"] ?: nil;

  return [[DBTEAMLegalHoldsListHeldRevisionsContinueArg alloc] initWithId_:id_ cursor:cursor];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLegalHoldsListHeldRevisionsContinueError.h"

#pragma mark - API Object

@implementation DBTEAMLegalHoldsListHeldRevisionsContinueError

#pragma mark - Constructors

- (instancetype)initWithUnknownLegalHoldError {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsListHeldRevisionsContinueErrorUnknownLegalHoldError;
  }
  return self;
}

- (instancetype)initWithTransientError {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsListHeldRevisionsContinueErrorTransientError;
  }
  return self;
}

- (instancetype)initWithReset {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsListHeldRevisionsContinueErrorReset;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsListHeldRevisionsContinueErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isUnknownLegalHoldError {
  return _tag == DBTEAMLegalHoldsListHeldRevisionsContinueErrorUnknownLegalHoldError;
}

- (BOOL)isTransientError {
  return _tag == DBTEAMLegalHoldsListHeldRevisionsContinueErrorTransientError;
}

- (BOOL)isReset {
  return _tag == DBTEAMLegalHoldsListHeldRevisionsContinueErrorReset;
}

- (BOOL)isOther {
  return _tag == DBTEAMLegalHoldsListHeldRevisionsContinueErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLegalHoldsListHeldRevisionsContinueErrorUnknownLegalHoldError:
    return @"DBTEAMLegalHoldsListHeldRevisionsContinueErrorUnknownLegalHoldError";
  case DBTEAMLegalHoldsListHeldRevisionsContinueErrorTransientError:
    return @"DBTEAMLegalHoldsListHeldRevisionsContinueErrorTransientError";
  case DBTEAMLegalHoldsListHeldRevisionsContinueErrorReset:
    return @"DBTEAMLegalHoldsListHeldRevisionsContinueErrorReset";
  case DBTEAMLegalHoldsListHeldRevisionsContinueErrorOther:
    return @"DBTEAMLegalHoldsListHeldRevisionsContinueErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLegalHoldsListHeldRevisionsContinueErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLegalHoldsListHeldRevisionsContinueErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLegalHoldsListHeldRevisionsContinueErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLegalHoldsListHeldRevisionsContinueErrorUnknownLegalHoldError:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsListHeldRevisionsContinueErrorTransientError:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsListHeldRevisionsContinueErrorReset:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsListHeldRevisionsContinueErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLegalHoldsListHeldRevisionsContinueError:other];
}

- (BOOL)isEqualToLegalHoldsListHeldRevisionsContinueError:
    (DBTEAMLegalHoldsListHeldRevisionsContinueError *)aLegalHoldsListHeldRevisionsContinueError {
  if (self == aLegalHoldsListHeldRevisionsContinueError) {
    return YES;
  }
  if (self.tag != aLegalHoldsListHeldRevisionsContinueError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLegalHoldsListHeldRevisionsContinueErrorUnknownLegalHoldError:
    return [[self tagName] isEqual:[aLegalHoldsListHeldRevisionsContinueError tagName]];
  case DBTEAMLegalHoldsListHeldRevisionsContinueErrorTransientError:
    return [[self tagName] isEqual:[aLegalHoldsListHeldRevisionsContinueError tagName]];
  case DBTEAMLegalHoldsListHeldRevisionsContinueErrorReset:
    return [[self tagName] isEqual:[aLegalHoldsListHeldRevisionsContinueError tagName]];
  case DBTEAMLegalHoldsListHeldRevisionsContinueErrorOther:
    return [[self tagName] isEqual:[aLegalHoldsListHeldRevisionsContinueError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLegalHoldsListHeldRevisionsContinueErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLegalHoldsListHeldRevisionsContinueError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUnknownLegalHoldError]) {
    jsonDict[@".tag"] = @"unknown_legal_hold_error";
  } else if ([valueObj isTransientError]) {
    jsonDict[@".tag"] = @"transient_error";
  } else if ([valueObj isReset]) {
    jsonDict[@".tag"] = @"reset";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLegalHoldsListHeldRevisionsContinueError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"unknown_legal_hold_error"]) {
    return [[DBTEAMLegalHoldsListHeldRevisionsContinueError alloc] initWithUnknownLegalHoldError];
  } else if ([tag isEqualToString:@"transient_error"]) {
    return [[DBTEAMLegalHoldsListHeldRevisionsContinueError alloc] initWithTransientError];
  } else if ([tag isEqualToString:@"reset"]) {
    return [[DBTEAMLegalHoldsListHeldRevisionsContinueError alloc] initWithReset];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLegalHoldsListHeldRevisionsContinueError alloc] initWithOther];
  } else {
    return [[DBTEAMLegalHoldsListHeldRevisionsContinueError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLegalHoldsError.h"
#import "DBTEAMLegalHoldsListHeldRevisionsError.h"

#pragma mark - API Object

@implementation DBTEAMLegalHoldsListHeldRevisionsError

#pragma mark - Constructors

- (instancetype)initWithUnknownLegalHoldError {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsListHeldRevisionsErrorUnknownLegalHoldError;
  }
  return self;
}

- (instancetype)initWithInsufficientPermissions {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsListHeldRevisionsErrorInsufficientPermissions;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsListHeldRevisionsErrorOther;
  }
  return self;
}

- (instancetype)initWithTransientError {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsListHeldRevisionsErrorTransientError;
  }
  return self;
}

- (instancetype)initWithLegalHoldStillEmpty {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsListHeldRevisionsErrorLegalHoldStillEmpty;
  }
  return self;
}

- (instancetype)initWithInactiveLegalHold {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsListHeldRevisionsErrorInactiveLegalHold;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isUnknownLegalHoldError {
  return _tag == DBTEAMLegalHoldsListHeldRevisionsErrorUnknownLegalHoldError;
}

- (BOOL)isInsufficientPermissions {
  return _tag == DBTEAMLegalHoldsListHeldRevisionsErrorInsufficientPermissions;
}

- (BOOL)isOther {
  return _tag == DBTEAMLegalHoldsListHeldRevisionsErrorOther;
}

- (BOOL)isTransientError {
  return _tag == DBTEAMLegalHoldsListHeldRevisionsErrorTransientError;
}

- (BOOL)isLegalHoldStillEmpty {
  return _tag == DBTEAMLegalHoldsListHeldRevisionsErrorLegalHoldStillEmpty;
}

- (BOOL)isInactiveLegalHold {
  return _tag == DBTEAMLegalHoldsListHeldRevisionsErrorInactiveLegalHold;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLegalHoldsListHeldRevisionsErrorUnknownLegalHoldError:
    return @"DBTEAMLegalHoldsListHeldRevisionsErrorUnknownLegalHoldError";
  case DBTEAMLegalHoldsListHeldRevisionsErrorInsufficientPermissions:
    return @"DBTEAMLegalHoldsListHeldRevisionsErrorInsufficientPermissions";
  case DBTEAMLegalHoldsListHeldRevisionsErrorOther:
    return @"DBTEAMLegalHoldsListHeldRevisionsErrorOther";
  case DBTEAMLegalHoldsListHeldRevisionsErrorTransientError:
    return @"DBTEAMLegalHoldsListHeldRevisionsErrorTransientError";
  case DBTEAMLegalHoldsListHeldRevisionsErrorLegalHoldStillEmpty:
    return @"DBTEAMLegalHoldsListHeldRevisionsErrorLegalHoldStillEmpty";
  case DBTEAMLegalHoldsListHeldRevisionsErrorInactiveLegalHold:
    return @"DBTEAMLegalHoldsListHeldRevisionsErrorInactiveLegalHold";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLegalHoldsListHeldRevisionsErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLegalHoldsListHeldRevisionsErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLegalHoldsListHeldRevisionsErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLegalHoldsListHeldRevisionsErrorUnknownLegalHoldError:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsListHeldRevisionsErrorInsufficientPermissions:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsListHeldRevisionsErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsListHeldRevisionsErrorTransientError:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsListHeldRevisionsErrorLegalHoldStillEmpty:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsListHeldRevisionsErrorInactiveLegalHold:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLegalHoldsListHeldRevisionsError:other];
}

- (BOOL)isEqualToLegalHoldsListHeldRevisionsError:
    (DBTEAMLegalHoldsListHeldRevisionsError *)aLegalHoldsListHeldRevisionsError {
  if (self == aLegalHoldsListHeldRevisionsError) {
    return YES;
  }
  if (self.tag != aLegalHoldsListHeldRevisionsError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLegalHoldsListHeldRevisionsErrorUnknownLegalHoldError:
    return [[self tagName] isEqual:[aLegalHoldsListHeldRevisionsError tagName]];
  case DBTEAMLegalHoldsListHeldRevisionsErrorInsufficientPermissions:
    return [[self tagName] isEqual:[aLegalHoldsListHeldRevisionsError tagName]];
  case DBTEAMLegalHoldsListHeldRevisionsErrorOther:
    return [[self tagName] isEqual:[aLegalHoldsListHeldRevisionsError tagName]];
  case DBTEAMLegalHoldsListHeldRevisionsErrorTransientError:
    return [[self tagName] isEqual:[aLegalHoldsListHeldRevisionsError tagName]];
  case DBTEAMLegalHoldsListHeldRevisionsErrorLegalHoldStillEmpty:
    return [[self tagName] isEqual:[aLegalHoldsListHeldRevisionsError tagName]];
  case DBTEAMLegalHoldsListHeldRevisionsErrorInactiveLegalHold:
    return [[self tagName] isEqual:[aLegalHoldsListHeldRevisionsError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLegalHoldsListHeldRevisionsErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLegalHoldsListHeldRevisionsError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUnknownLegalHoldError]) {
    jsonDict[@".tag"] = @"unknown_legal_hold_error";
  } else if ([valueObj isInsufficientPermissions]) {
    jsonDict[@".tag"] = @"insufficient_permissions";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isTransientError]) {
    jsonDict[@".tag"] = @"transient_error";
  } else if ([valueObj isLegalHoldStillEmpty]) {
    jsonDict[@".tag"] = @"legal_hold_still_empty";
  } else if ([valueObj isInactiveLegalHold]) {
    jsonDict[@".tag"] = @"inactive_legal_hold";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLegalHoldsListHeldRevisionsError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"unknown_legal_hold_error"]) {
    return [[DBTEAMLegalHoldsListHeldRevisionsError alloc] initWithUnknownLegalHoldError];
  } else if ([tag isEqualToString:@"insufficient_permissions"]) {
    return [[DBTEAMLegalHoldsListHeldRevisionsError alloc] initWithInsufficientPermissions];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLegalHoldsListHeldRevisionsError alloc] initWithOther];
  } else if ([tag isEqualToString:@"transient_error"]) {
    return [[DBTEAMLegalHoldsListHeldRevisionsError alloc] initWithTransientError];
  } else if ([tag isEqualToString:@"legal_hold_still_empty"]) {
    return [[DBTEAMLegalHoldsListHeldRevisionsError alloc] initWithLegalHoldStillEmpty];
  } else if ([tag isEqualToString:@"inactive_legal_hold"]) {
    return [[DBTEAMLegalHoldsListHeldRevisionsError alloc] initWithInactiveLegalHold];
  } else {
    return [[DBTEAMLegalHoldsListHeldRevisionsError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLegalHoldsListPoliciesArg.h"

#pragma mark - API Object

@implementation DBTEAMLegalHoldsListPoliciesArg

#pragma mark - Constructors

- (instancetype)initWithIncludeReleased:(NSNumber *)includeReleased {

  self = [super init];
  if (self) {
    _includeReleased = includeReleased ?: @NO;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithIncludeReleased:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLegalHoldsListPoliciesArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLegalHoldsListPoliciesArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLegalHoldsListPoliciesArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.includeReleased hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLegalHoldsListPoliciesArg:other];
}

- (BOOL)isEqualToLegalHoldsListPoliciesArg:(DBTEAMLegalHoldsListPoliciesArg *)aLegalHoldsListPoliciesArg {
  if (self == aLegalHoldsListPoliciesArg) {
    return YES;
  }
  if (![self.includeReleased isEqual:aLegalHoldsListPoliciesArg.includeReleased]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLegalHoldsListPoliciesArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLegalHoldsListPoliciesArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"include_released"] = valueObj.includeReleased;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLegalHoldsListPoliciesArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSNumber *includeReleased = valueDict[@"include_released"] ?: @NO;

  return [[DBTEAMLegalHoldsListPoliciesArg alloc] initWithIncludeReleased:includeReleased];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLegalHoldsError.h"
#import "DBTEAMLegalHoldsListPoliciesError.h"

#pragma mark - API Object

@implementation DBTEAMLegalHoldsListPoliciesError

#pragma mark - Constructors

- (instancetype)initWithUnknownLegalHoldError {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsListPoliciesErrorUnknownLegalHoldError;
  }
  return self;
}

- (instancetype)initWithInsufficientPermissions {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsListPoliciesErrorInsufficientPermissions;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsListPoliciesErrorOther;
  }
  return self;
}

- (instancetype)initWithTransientError {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsListPoliciesErrorTransientError;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isUnknownLegalHoldError {
  return _tag == DBTEAMLegalHoldsListPoliciesErrorUnknownLegalHoldError;
}

- (BOOL)isInsufficientPermissions {
  return _tag == DBTEAMLegalHoldsListPoliciesErrorInsufficientPermissions;
}

- (BOOL)isOther {
  return _tag == DBTEAMLegalHoldsListPoliciesErrorOther;
}

- (BOOL)isTransientError {
  return _tag == DBTEAMLegalHoldsListPoliciesErrorTransientError;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLegalHoldsListPoliciesErrorUnknownLegalHoldError:
    return @"DBTEAMLegalHoldsListPoliciesErrorUnknownLegalHoldError";
  case DBTEAMLegalHoldsListPoliciesErrorInsufficientPermissions:
    return @"DBTEAMLegalHoldsListPoliciesErrorInsufficientPermissions";
  case DBTEAMLegalHoldsListPoliciesErrorOther:
    return @"DBTEAMLegalHoldsListPoliciesErrorOther";
  case DBTEAMLegalHoldsListPoliciesErrorTransientError:
    return @"DBTEAMLegalHoldsListPoliciesErrorTransientError";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLegalHoldsListPoliciesErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLegalHoldsListPoliciesErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLegalHoldsListPoliciesErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLegalHoldsListPoliciesErrorUnknownLegalHoldError:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsListPoliciesErrorInsufficientPermissions:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsListPoliciesErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsListPoliciesErrorTransientError:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLegalHoldsListPoliciesError:other];
}

- (BOOL)isEqualToLegalHoldsListPoliciesError:(DBTEAMLegalHoldsListPoliciesError *)aLegalHoldsListPoliciesError {
  if (self == aLegalHoldsListPoliciesError) {
    return YES;
  }
  if (self.tag != aLegalHoldsListPoliciesError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLegalHoldsListPoliciesErrorUnknownLegalHoldError:
    return [[self tagName] isEqual:[aLegalHoldsListPoliciesError tagName]];
  case DBTEAMLegalHoldsListPoliciesErrorInsufficientPermissions:
    return [[self tagName] isEqual:[aLegalHoldsListPoliciesError tagName]];
  case DBTEAMLegalHoldsListPoliciesErrorOther:
    return [[self tagName] isEqual:[aLegalHoldsListPoliciesError tagName]];
  case DBTEAMLegalHoldsListPoliciesErrorTransientError:
    return [[self tagName] isEqual:[aLegalHoldsListPoliciesError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLegalHoldsListPoliciesErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLegalHoldsListPoliciesError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUnknownLegalHoldError]) {
    jsonDict[@".tag"] = @"unknown_legal_hold_error";
  } else if ([valueObj isInsufficientPermissions]) {
    jsonDict[@".tag"] = @"insufficient_permissions";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isTransientError]) {
    jsonDict[@".tag"] = @"transient_error";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLegalHoldsListPoliciesError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"unknown_legal_hold_error"]) {
    return [[DBTEAMLegalHoldsListPoliciesError alloc] initWithUnknownLegalHoldError];
  } else if ([tag isEqualToString:@"insufficient_permissions"]) {
    return [[DBTEAMLegalHoldsListPoliciesError alloc] initWithInsufficientPermissions];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLegalHoldsListPoliciesError alloc] initWithOther];
  } else if ([tag isEqualToString:@"transient_error"]) {
    return [[DBTEAMLegalHoldsListPoliciesError alloc] initWithTransientError];
  } else {
    return [[DBTEAMLegalHoldsListPoliciesError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLegalHoldPolicy.h"
#import "DBTEAMLegalHoldsListPoliciesResult.h"

#pragma mark - API Object

@implementation DBTEAMLegalHoldsListPoliciesResult

#pragma mark - Constructors

- (instancetype)initWithPolicies:(NSArray<DBTEAMLegalHoldPolicy *> *)policies {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](policies);

  self = [super init];
  if (self) {
    _policies = policies;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLegalHoldsListPoliciesResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLegalHoldsListPoliciesResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLegalHoldsListPoliciesResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.policies hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLegalHoldsListPoliciesResult:other];
}

- (BOOL)isEqualToLegalHoldsListPoliciesResult:(DBTEAMLegalHoldsListPoliciesResult *)aLegalHoldsListPoliciesResult {
  if (self == aLegalHoldsListPoliciesResult) {
    return YES;
  }
  if (![self.policies isEqual:aLegalHoldsListPoliciesResult.policies]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLegalHoldsListPoliciesResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLegalHoldsListPoliciesResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"policies"] = [DBArraySerializer serialize:valueObj.policies
                                             withBlock:^id(id elem0) {
                                               return [DBTEAMLegalHoldPolicySerializer serialize:elem0];
                                             }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLegalHoldsListPoliciesResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBTEAMLegalHoldPolicy *> *policies =
      [DBArraySerializer deserialize:valueDict[@"policies"]
                           withBlock:^id(id elem0) {
                             return [DBTEAMLegalHoldPolicySerializer deserialize:elem0];
                           }];

  return [[DBTEAMLegalHoldsListPoliciesResult alloc] initWithPolicies:policies];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLegalHoldsPolicyCreateArg.h"

#pragma mark - API Object

@implementation DBTEAMLegalHoldsPolicyCreateArg

#pragma mark - Constructors

- (instancetype)initWithName:(NSString *)name
                     members:(NSArray<NSString *> *)members
                description_:(NSString *)description_
                   startDate:(NSDate *)startDate
                     endDate:(NSDate *)endDate {
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:nil maxLength:@(140) pattern:nil]](name);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](members);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators stringValidator:nil maxLength:@(501) pattern:nil]](description_);

  self = [super init];
  if (self) {
    _name = name;
    _description_ = description_;
    _members = members;
    _startDate = startDate;
    _endDate = endDate;
  }
  return self;
}

- (instancetype)initWithName:(NSString *)name members:(NSArray<NSString *> *)members {
  return [self initWithName:name members:members description_:nil startDate:nil endDate:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLegalHoldsPolicyCreateArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLegalHoldsPolicyCreateArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLegalHoldsPolicyCreateArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.name hash];
  result = prime * result + [self.members hash];
  if (self.description_ != nil) {
    result = prime * result + [self.description_ hash];
  }
  if (self.startDate != nil) {
    result = prime * result + [self.startDate hash];
  }
  if (self.endDate != nil) {
    result = prime * result + [self.endDate hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLegalHoldsPolicyCreateArg:other];
}

- (BOOL)isEqualToLegalHoldsPolicyCreateArg:(DBTEAMLegalHoldsPolicyCreateArg *)aLegalHoldsPolicyCreateArg {
  if (self == aLegalHoldsPolicyCreateArg) {
    return YES;
  }
  if (![self.name isEqual:aLegalHoldsPolicyCreateArg.name]) {
    return NO;
  }
  if (![self.members isEqual:aLegalHoldsPolicyCreateArg.members]) {
    return NO;
  }
  if (self.description_) {
    if (![self.description_ isEqual:aLegalHoldsPolicyCreateArg.description_]) {
      return NO;
    }
  }
  if (self.startDate) {
    if (![self.startDate isEqual:aLegalHoldsPolicyCreateArg.startDate]) {
      return NO;
    }
  }
  if (self.endDate) {
    if (![self.endDate isEqual:aLegalHoldsPolicyCreateArg.endDate]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLegalHoldsPolicyCreateArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLegalHoldsPolicyCreateArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"name"] = valueObj.name;
  jsonDict[@"members"] = [DBArraySerializer serialize:valueObj.members
                                            withBlock:^id(id elem0) {
                                              return elem0;
                                            }];
  if (valueObj.description_) {
    jsonDict[@"description"] = valueObj.description_;
  }
  if (valueObj.startDate) {
    jsonDict[@"start_date"] = [DBNSDateSerializer serialize:valueObj.startDate dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }
  if (valueObj.endDate) {
    jsonDict[@"end_date"] = [DBNSDateSerializer serialize:valueObj.endDate dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLegalHoldsPolicyCreateArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *name = valueDict[@"name"];
  NSArray<NSString *> *members = [DBArraySerializer deserialize:valueDict[@"members"]
                                                      withBlock:^id(id elem0) {
                                                        return elem0;
                                                      }];
  NSString *description_ = valueDict[@"description"] ?: nil;
  NSDate *startDate = valueDict[@"start_date"]
                          ? [DBNSDateSerializer deserialize:valueDict[@"start_date"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                          : nil;
  NSDate *endDate = valueDict[@"end_date"]
                        ? [DBNSDateSerializer deserialize:valueDict[@"end_date"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                        : nil;

  return [[DBTEAMLegalHoldsPolicyCreateArg alloc] initWithName:name
                                                       members:members
                                                  description_:description_
                                                     startDate:startDate
                                                       endDate:endDate];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLegalHoldsError.h"
#import "DBTEAMLegalHoldsPolicyCreateError.h"

#pragma mark - API Object

@implementation DBTEAMLegalHoldsPolicyCreateError

#pragma mark - Constructors

- (instancetype)initWithUnknownLegalHoldError {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsPolicyCreateErrorUnknownLegalHoldError;
  }
  return self;
}

- (instancetype)initWithInsufficientPermissions {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsPolicyCreateErrorInsufficientPermissions;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsPolicyCreateErrorOther;
  }
  return self;
}

- (instancetype)initWithStartDateIsLaterThanEndDate {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsPolicyCreateErrorStartDateIsLaterThanEndDate;
  }
  return self;
}

- (instancetype)initWithEmptyMembersList {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsPolicyCreateErrorEmptyMembersList;
  }
  return self;
}

- (instancetype)initWithInvalidMembers {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsPolicyCreateErrorInvalidMembers;
  }
  return self;
}

- (instancetype)initWithNumberOfUsersOnHoldIsGreaterThanHoldLimitation {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsPolicyCreateErrorNumberOfUsersOnHoldIsGreaterThanHoldLimitation;
  }
  return self;
}

- (instancetype)initWithTransientError {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsPolicyCreateErrorTransientError;
  }
  return self;
}

- (instancetype)initWithNameMustBeUnique {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsPolicyCreateErrorNameMustBeUnique;
  }
  return self;
}

- (instancetype)initWithTeamExceededLegalHoldQuota {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsPolicyCreateErrorTeamExceededLegalHoldQuota;
  }
  return self;
}

- (instancetype)initWithInvalidDate {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsPolicyCreateErrorInvalidDate;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isUnknownLegalHoldError {
  return _tag == DBTEAMLegalHoldsPolicyCreateErrorUnknownLegalHoldError;
}

- (BOOL)isInsufficientPermissions {
  return _tag == DBTEAMLegalHoldsPolicyCreateErrorInsufficientPermissions;
}

- (BOOL)isOther {
  return _tag == DBTEAMLegalHoldsPolicyCreateErrorOther;
}

- (BOOL)isStartDateIsLaterThanEndDate {
  return _tag == DBTEAMLegalHoldsPolicyCreateErrorStartDateIsLaterThanEndDate;
}

- (BOOL)isEmptyMembersList {
  return _tag == DBTEAMLegalHoldsPolicyCreateErrorEmptyMembersList;
}

- (BOOL)isInvalidMembers {
  return _tag == DBTEAMLegalHoldsPolicyCreateErrorInvalidMembers;
}

- (BOOL)isNumberOfUsersOnHoldIsGreaterThanHoldLimitation {
  return _tag == DBTEAMLegalHoldsPolicyCreateErrorNumberOfUsersOnHoldIsGreaterThanHoldLimitation;
}

- (BOOL)isTransientError {
  return _tag == DBTEAMLegalHoldsPolicyCreateErrorTransientError;
}

- (BOOL)isNameMustBeUnique {
  return _tag == DBTEAMLegalHoldsPolicyCreateErrorNameMustBeUnique;
}

- (BOOL)isTeamExceededLegalHoldQuota {
  return _tag == DBTEAMLegalHoldsPolicyCreateErrorTeamExceededLegalHoldQuota;
}

- (BOOL)isInvalidDate {
  return _tag == DBTEAMLegalHoldsPolicyCreateErrorInvalidDate;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLegalHoldsPolicyCreateErrorUnknownLegalHoldError:
    return @"DBTEAMLegalHoldsPolicyCreateErrorUnknownLegalHoldError";
  case DBTEAMLegalHoldsPolicyCreateErrorInsufficientPermissions:
    return @"DBTEAMLegalHoldsPolicyCreateErrorInsufficientPermissions";
  case DBTEAMLegalHoldsPolicyCreateErrorOther:
    return @"DBTEAMLegalHoldsPolicyCreateErrorOther";
  case DBTEAMLegalHoldsPolicyCreateErrorStartDateIsLaterThanEndDate:
    return @"DBTEAMLegalHoldsPolicyCreateErrorStartDateIsLaterThanEndDate";
  case DBTEAMLegalHoldsPolicyCreateErrorEmptyMembersList:
    return @"DBTEAMLegalHoldsPolicyCreateErrorEmptyMembersList";
  case DBTEAMLegalHoldsPolicyCreateErrorInvalidMembers:
    return @"DBTEAMLegalHoldsPolicyCreateErrorInvalidMembers";
  case DBTEAMLegalHoldsPolicyCreateErrorNumberOfUsersOnHoldIsGreaterThanHoldLimitation:
    return @"DBTEAMLegalHoldsPolicyCreateErrorNumberOfUsersOnHoldIsGreaterThanHoldLimitation";
  case DBTEAMLegalHoldsPolicyCreateErrorTransientError:
    return @"DBTEAMLegalHoldsPolicyCreateErrorTransientError";
  case DBTEAMLegalHoldsPolicyCreateErrorNameMustBeUnique:
    return @"DBTEAMLegalHoldsPolicyCreateErrorNameMustBeUnique";
  case DBTEAMLegalHoldsPolicyCreateErrorTeamExceededLegalHoldQuota:
    return @"DBTEAMLegalHoldsPolicyCreateErrorTeamExceededLegalHoldQuota";
  case DBTEAMLegalHoldsPolicyCreateErrorInvalidDate:
    return @"DBTEAMLegalHoldsPolicyCreateErrorInvalidDate";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLegalHoldsPolicyCreateErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLegalHoldsPolicyCreateErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLegalHoldsPolicyCreateErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLegalHoldsPolicyCreateErrorUnknownLegalHoldError:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsPolicyCreateErrorInsufficientPermissions:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsPolicyCreateErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsPolicyCreateErrorStartDateIsLaterThanEndDate:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsPolicyCreateErrorEmptyMembersList:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsPolicyCreateErrorInvalidMembers:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsPolicyCreateErrorNumberOfUsersOnHoldIsGreaterThanHoldLimitation:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsPolicyCreateErrorTransientError:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsPolicyCreateErrorNameMustBeUnique:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsPolicyCreateErrorTeamExceededLegalHoldQuota:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsPolicyCreateErrorInvalidDate:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLegalHoldsPolicyCreateError:other];
}

- (BOOL)isEqualToLegalHoldsPolicyCreateError:(DBTEAMLegalHoldsPolicyCreateError *)aLegalHoldsPolicyCreateError {
  if (self == aLegalHoldsPolicyCreateError) {
    return YES;
  }
  if (self.tag != aLegalHoldsPolicyCreateError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLegalHoldsPolicyCreateErrorUnknownLegalHoldError:
    return [[self tagName] isEqual:[aLegalHoldsPolicyCreateError tagName]];
  case DBTEAMLegalHoldsPolicyCreateErrorInsufficientPermissions:
    return [[self tagName] isEqual:[aLegalHoldsPolicyCreateError tagName]];
  case DBTEAMLegalHoldsPolicyCreateErrorOther:
    return [[self tagName] isEqual:[aLegalHoldsPolicyCreateError tagName]];
  case DBTEAMLegalHoldsPolicyCreateErrorStartDateIsLaterThanEndDate:
    return [[self tagName] isEqual:[aLegalHoldsPolicyCreateError tagName]];
  case DBTEAMLegalHoldsPolicyCreateErrorEmptyMembersList:
    return [[self tagName] isEqual:[aLegalHoldsPolicyCreateError tagName]];
  case DBTEAMLegalHoldsPolicyCreateErrorInvalidMembers:
    return [[self tagName] isEqual:[aLegalHoldsPolicyCreateError tagName]];
  case DBTEAMLegalHoldsPolicyCreateErrorNumberOfUsersOnHoldIsGreaterThanHoldLimitation:
    return [[self tagName] isEqual:[aLegalHoldsPolicyCreateError tagName]];
  case DBTEAMLegalHoldsPolicyCreateErrorTransientError:
    return [[self tagName] isEqual:[aLegalHoldsPolicyCreateError tagName]];
  case DBTEAMLegalHoldsPolicyCreateErrorNameMustBeUnique:
    return [[self tagName] isEqual:[aLegalHoldsPolicyCreateError tagName]];
  case DBTEAMLegalHoldsPolicyCreateErrorTeamExceededLegalHoldQuota:
    return [[self tagName] isEqual:[aLegalHoldsPolicyCreateError tagName]];
  case DBTEAMLegalHoldsPolicyCreateErrorInvalidDate:
    return [[self tagName] isEqual:[aLegalHoldsPolicyCreateError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLegalHoldsPolicyCreateErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLegalHoldsPolicyCreateError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUnknownLegalHoldError]) {
    jsonDict[@".tag"] = @"unknown_legal_hold_error";
  } else if ([valueObj isInsufficientPermissions]) {
    jsonDict[@".tag"] = @"insufficient_permissions";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isStartDateIsLaterThanEndDate]) {
    jsonDict[@".tag"] = @"start_date_is_later_than_end_date";
  } else if ([valueObj isEmptyMembersList]) {
    jsonDict[@".tag"] = @"empty_members_list";
  } else if ([valueObj isInvalidMembers]) {
    jsonDict[@".tag"] = @"invalid_members";
  } else if ([valueObj isNumberOfUsersOnHoldIsGreaterThanHoldLimitation]) {
    jsonDict[@".tag"] = @"number_of_users_on_hold_is_greater_than_hold_limitation";
  } else if ([valueObj isTransientError]) {
    jsonDict[@".tag"] = @"transient_error";
  } else if ([valueObj isNameMustBeUnique]) {
    jsonDict[@".tag"] = @"name_must_be_unique";
  } else if ([valueObj isTeamExceededLegalHoldQuota]) {
    jsonDict[@".tag"] = @"team_exceeded_legal_hold_quota";
  } else if ([valueObj isInvalidDate]) {
    jsonDict[@".tag"] = @"invalid_date";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLegalHoldsPolicyCreateError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"unknown_legal_hold_error"]) {
    return [[DBTEAMLegalHoldsPolicyCreateError alloc] initWithUnknownLegalHoldError];
  } else if ([tag isEqualToString:@"insufficient_permissions"]) {
    return [[DBTEAMLegalHoldsPolicyCreateError alloc] initWithInsufficientPermissions];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLegalHoldsPolicyCreateError alloc] initWithOther];
  } else if ([tag isEqualToString:@"start_date_is_later_than_end_date"]) {
    return [[DBTEAMLegalHoldsPolicyCreateError alloc] initWithStartDateIsLaterThanEndDate];
  } else if ([tag isEqualToString:@"empty_members_list"]) {
    return [[DBTEAMLegalHoldsPolicyCreateError alloc] initWithEmptyMembersList];
  } else if ([tag isEqualToString:@"invalid_members"]) {
    return [[DBTEAMLegalHoldsPolicyCreateError alloc] initWithInvalidMembers];
  } else if ([tag isEqualToString:@"number_of_users_on_hold_is_greater_than_hold_limitation"]) {
    return [[DBTEAMLegalHoldsPolicyCreateError alloc] initWithNumberOfUsersOnHoldIsGreaterThanHoldLimitation];
  } else if ([tag isEqualToString:@"transient_error"]) {
    return [[DBTEAMLegalHoldsPolicyCreateError alloc] initWithTransientError];
  } else if ([tag isEqualToString:@"name_must_be_unique"]) {
    return [[DBTEAMLegalHoldsPolicyCreateError alloc] initWithNameMustBeUnique];
  } else if ([tag isEqualToString:@"team_exceeded_legal_hold_quota"]) {
    return [[DBTEAMLegalHoldsPolicyCreateError alloc] initWithTeamExceededLegalHoldQuota];
  } else if ([tag isEqualToString:@"invalid_date"]) {
    return [[DBTEAMLegalHoldsPolicyCreateError alloc] initWithInvalidDate];
  } else {
    return [[DBTEAMLegalHoldsPolicyCreateError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLegalHoldsPolicyReleaseArg.h"

#pragma mark - API Object

@implementation DBTEAMLegalHoldsPolicyReleaseArg

#pragma mark - Constructors

- (instancetype)initWithId_:(NSString *)id_ {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"^pid_dbhid:.+"]](id_);

  self = [super init];
  if (self) {
    _id_ = id_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLegalHoldsPolicyReleaseArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLegalHoldsPolicyReleaseArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLegalHoldsPolicyReleaseArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.id_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLegalHoldsPolicyReleaseArg:other];
}

- (BOOL)isEqualToLegalHoldsPolicyReleaseArg:(DBTEAMLegalHoldsPolicyReleaseArg *)aLegalHoldsPolicyReleaseArg {
  if (self == aLegalHoldsPolicyReleaseArg) {
    return YES;
  }
  if (![self.id_ isEqual:aLegalHoldsPolicyReleaseArg.id_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLegalHoldsPolicyReleaseArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLegalHoldsPolicyReleaseArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"id"] = valueObj.id_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLegalHoldsPolicyReleaseArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *id_ = valueDict[@"id"];

  return [[DBTEAMLegalHoldsPolicyReleaseArg alloc] initWithId_:id_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLegalHoldsError.h"
#import "DBTEAMLegalHoldsPolicyReleaseError.h"

#pragma mark - API Object

@implementation DBTEAMLegalHoldsPolicyReleaseError

#pragma mark - Constructors

- (instancetype)initWithUnknownLegalHoldError {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsPolicyReleaseErrorUnknownLegalHoldError;
  }
  return self;
}

- (instancetype)initWithInsufficientPermissions {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsPolicyReleaseErrorInsufficientPermissions;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsPolicyReleaseErrorOther;
  }
  return self;
}

- (instancetype)initWithLegalHoldPerformingAnotherOperation {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsPolicyReleaseErrorLegalHoldPerformingAnotherOperation;
  }
  return self;
}

- (instancetype)initWithLegalHoldAlreadyReleasing {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsPolicyReleaseErrorLegalHoldAlreadyReleasing;
  }
  return self;
}

- (instancetype)initWithLegalHoldPolicyNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsPolicyReleaseErrorLegalHoldPolicyNotFound;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isUnknownLegalHoldError {
  return _tag == DBTEAMLegalHoldsPolicyReleaseErrorUnknownLegalHoldError;
}

- (BOOL)isInsufficientPermissions {
  return _tag == DBTEAMLegalHoldsPolicyReleaseErrorInsufficientPermissions;
}

- (BOOL)isOther {
  return _tag == DBTEAMLegalHoldsPolicyReleaseErrorOther;
}

- (BOOL)isLegalHoldPerformingAnotherOperation {
  return _tag == DBTEAMLegalHoldsPolicyReleaseErrorLegalHoldPerformingAnotherOperation;
}

- (BOOL)isLegalHoldAlreadyReleasing {
  return _tag == DBTEAMLegalHoldsPolicyReleaseErrorLegalHoldAlreadyReleasing;
}

- (BOOL)isLegalHoldPolicyNotFound {
  return _tag == DBTEAMLegalHoldsPolicyReleaseErrorLegalHoldPolicyNotFound;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLegalHoldsPolicyReleaseErrorUnknownLegalHoldError:
    return @"DBTEAMLegalHoldsPolicyReleaseErrorUnknownLegalHoldError";
  case DBTEAMLegalHoldsPolicyReleaseErrorInsufficientPermissions:
    return @"DBTEAMLegalHoldsPolicyReleaseErrorInsufficientPermissions";
  case DBTEAMLegalHoldsPolicyReleaseErrorOther:
    return @"DBTEAMLegalHoldsPolicyReleaseErrorOther";
  case DBTEAMLegalHoldsPolicyReleaseErrorLegalHoldPerformingAnotherOperation:
    return @"DBTEAMLegalHoldsPolicyReleaseErrorLegalHoldPerformingAnotherOperation";
  case DBTEAMLegalHoldsPolicyReleaseErrorLegalHoldAlreadyReleasing:
    return @"DBTEAMLegalHoldsPolicyReleaseErrorLegalHoldAlreadyReleasing";
  case DBTEAMLegalHoldsPolicyReleaseErrorLegalHoldPolicyNotFound:
    return @"DBTEAMLegalHoldsPolicyReleaseErrorLegalHoldPolicyNotFound";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLegalHoldsPolicyReleaseErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLegalHoldsPolicyReleaseErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLegalHoldsPolicyReleaseErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLegalHoldsPolicyReleaseErrorUnknownLegalHoldError:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsPolicyReleaseErrorInsufficientPermissions:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsPolicyReleaseErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsPolicyReleaseErrorLegalHoldPerformingAnotherOperation:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsPolicyReleaseErrorLegalHoldAlreadyReleasing:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsPolicyReleaseErrorLegalHoldPolicyNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLegalHoldsPolicyReleaseError:other];
}

- (BOOL)isEqualToLegalHoldsPolicyReleaseError:(DBTEAMLegalHoldsPolicyReleaseError *)aLegalHoldsPolicyReleaseError {
  if (self == aLegalHoldsPolicyReleaseError) {
    return YES;
  }
  if (self.tag != aLegalHoldsPolicyReleaseError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLegalHoldsPolicyReleaseErrorUnknownLegalHoldError:
    return [[self tagName] isEqual:[aLegalHoldsPolicyReleaseError tagName]];
  case DBTEAMLegalHoldsPolicyReleaseErrorInsufficientPermissions:
    return [[self tagName] isEqual:[aLegalHoldsPolicyReleaseError tagName]];
  case DBTEAMLegalHoldsPolicyReleaseErrorOther:
    return [[self tagName] isEqual:[aLegalHoldsPolicyReleaseError tagName]];
  case DBTEAMLegalHoldsPolicyReleaseErrorLegalHoldPerformingAnotherOperation:
    return [[self tagName] isEqual:[aLegalHoldsPolicyReleaseError tagName]];
  case DBTEAMLegalHoldsPolicyReleaseErrorLegalHoldAlreadyReleasing:
    return [[self tagName] isEqual:[aLegalHoldsPolicyReleaseError tagName]];
  case DBTEAMLegalHoldsPolicyReleaseErrorLegalHoldPolicyNotFound:
    return [[self tagName] isEqual:[aLegalHoldsPolicyReleaseError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLegalHoldsPolicyReleaseErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLegalHoldsPolicyReleaseError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUnknownLegalHoldError]) {
    jsonDict[@".tag"] = @"unknown_legal_hold_error";
  } else if ([valueObj isInsufficientPermissions]) {
    jsonDict[@".tag"] = @"insufficient_permissions";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isLegalHoldPerformingAnotherOperation]) {
    jsonDict[@".tag"] = @"legal_hold_performing_another_operation";
  } else if ([valueObj isLegalHoldAlreadyReleasing]) {
    jsonDict[@".tag"] = @"legal_hold_already_releasing";
  } else if ([valueObj isLegalHoldPolicyNotFound]) {
    jsonDict[@".tag"] = @"legal_hold_policy_not_found";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLegalHoldsPolicyReleaseError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"unknown_legal_hold_error"]) {
    return [[DBTEAMLegalHoldsPolicyReleaseError alloc] initWithUnknownLegalHoldError];
  } else if ([tag isEqualToString:@"insufficient_permissions"]) {
    return [[DBTEAMLegalHoldsPolicyReleaseError alloc] initWithInsufficientPermissions];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLegalHoldsPolicyReleaseError alloc] initWithOther];
  } else if ([tag isEqualToString:@"legal_hold_performing_another_operation"]) {
    return [[DBTEAMLegalHoldsPolicyReleaseError alloc] initWithLegalHoldPerformingAnotherOperation];
  } else if ([tag isEqualToString:@"legal_hold_already_releasing"]) {
    return [[DBTEAMLegalHoldsPolicyReleaseError alloc] initWithLegalHoldAlreadyReleasing];
  } else if ([tag isEqualToString:@"legal_hold_policy_not_found"]) {
    return [[DBTEAMLegalHoldsPolicyReleaseError alloc] initWithLegalHoldPolicyNotFound];
  } else {
    return [[DBTEAMLegalHoldsPolicyReleaseError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLegalHoldsPolicyUpdateArg.h"

#pragma mark - API Object

@implementation DBTEAMLegalHoldsPolicyUpdateArg

#pragma mark - Constructors

- (instancetype)initWithId_:(NSString *)id_
                       name:(NSString *)name
               description_:(NSString *)description_
                    members:(NSArray<NSString *> *)members {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"^pid_dbhid:.+"]](id_);
  [DBStoneValidators nullableValidator:[DBStoneValidators stringValidator:nil maxLength:@(140) pattern:nil]](name);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators stringValidator:nil maxLength:@(501) pattern:nil]](description_);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](members);

  self = [super init];
  if (self) {
    _id_ = id_;
    _name = name;
    _description_ = description_;
    _members = members;
  }
  return self;
}

- (instancetype)initWithId_:(NSString *)id_ {
  return [self initWithId_:id_ name:nil description_:nil members:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLegalHoldsPolicyUpdateArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLegalHoldsPolicyUpdateArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLegalHoldsPolicyUpdateArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.id_ hash];
  if (self.name != nil) {
    result = prime * result + [self.name hash];
  }
  if (self.description_ != nil) {
    result = prime * result + [self.description_ hash];
  }
  if (self.members != nil) {
    result = prime * result + [self.members hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLegalHoldsPolicyUpdateArg:other];
}

- (BOOL)isEqualToLegalHoldsPolicyUpdateArg:(DBTEAMLegalHoldsPolicyUpdateArg *)aLegalHoldsPolicyUpdateArg {
  if (self == aLegalHoldsPolicyUpdateArg) {
    return YES;
  }
  if (![self.id_ isEqual:aLegalHoldsPolicyUpdateArg.id_]) {
    return NO;
  }
  if (self.name) {
    if (![self.name isEqual:aLegalHoldsPolicyUpdateArg.name]) {
      return NO;
    }
  }
  if (self.description_) {
    if (![self.description_ isEqual:aLegalHoldsPolicyUpdateArg.description_]) {
      return NO;
    }
  }
  if (self.members) {
    if (![self.members isEqual:aLegalHoldsPolicyUpdateArg.members]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLegalHoldsPolicyUpdateArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLegalHoldsPolicyUpdateArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"id"] = valueObj.id_;
  if (valueObj.name) {
    jsonDict[@"name"] = valueObj.name;
  }
  if (valueObj.description_) {
    jsonDict[@"description"] = valueObj.description_;
  }
  if (valueObj.members) {
    jsonDict[@"members"] = [DBArraySerializer serialize:valueObj.members
                                              withBlock:^id(id elem0) {
                                                return elem0;
                                              }];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLegalHoldsPolicyUpdateArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *id_ = valueDict[@"id"];
  NSString *name = valueDict[@"name"] ?: nil;
  NSString *description_ = valueDict[@"description"] ?: nil;
  NSArray<NSString *> *members = valueDict[@"members"] ? [DBArraySerializer deserialize:valueDict[@"members"]
                                                                              withBlock:^id(id elem0) {
                                                                                return elem0;
                                                                              }]
                                                       : nil;

  return [[DBTEAMLegalHoldsPolicyUpdateArg alloc] initWithId_:id_ name:name description_:description_ members:members];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLegalHoldsError.h"
#import "DBTEAMLegalHoldsPolicyUpdateError.h"

#pragma mark - API Object

@implementation DBTEAMLegalHoldsPolicyUpdateError

#pragma mark - Constructors

- (instancetype)initWithUnknownLegalHoldError {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsPolicyUpdateErrorUnknownLegalHoldError;
  }
  return self;
}

- (instancetype)initWithInsufficientPermissions {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsPolicyUpdateErrorInsufficientPermissions;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsPolicyUpdateErrorOther;
  }
  return self;
}

- (instancetype)initWithTransientError {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsPolicyUpdateErrorTransientError;
  }
  return self;
}

- (instancetype)initWithInactiveLegalHold {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsPolicyUpdateErrorInactiveLegalHold;
  }
  return self;
}

- (instancetype)initWithLegalHoldPerformingAnotherOperation {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsPolicyUpdateErrorLegalHoldPerformingAnotherOperation;
  }
  return self;
}

- (instancetype)initWithInvalidMembers {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsPolicyUpdateErrorInvalidMembers;
  }
  return self;
}

- (instancetype)initWithNumberOfUsersOnHoldIsGreaterThanHoldLimitation {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsPolicyUpdateErrorNumberOfUsersOnHoldIsGreaterThanHoldLimitation;
  }
  return self;
}

- (instancetype)initWithEmptyMembersList {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsPolicyUpdateErrorEmptyMembersList;
  }
  return self;
}

- (instancetype)initWithNameMustBeUnique {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsPolicyUpdateErrorNameMustBeUnique;
  }
  return self;
}

- (instancetype)initWithLegalHoldPolicyNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMLegalHoldsPolicyUpdateErrorLegalHoldPolicyNotFound;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isUnknownLegalHoldError {
  return _tag == DBTEAMLegalHoldsPolicyUpdateErrorUnknownLegalHoldError;
}

- (BOOL)isInsufficientPermissions {
  return _tag == DBTEAMLegalHoldsPolicyUpdateErrorInsufficientPermissions;
}

- (BOOL)isOther {
  return _tag == DBTEAMLegalHoldsPolicyUpdateErrorOther;
}

- (BOOL)isTransientError {
  return _tag == DBTEAMLegalHoldsPolicyUpdateErrorTransientError;
}

- (BOOL)isInactiveLegalHold {
  return _tag == DBTEAMLegalHoldsPolicyUpdateErrorInactiveLegalHold;
}

- (BOOL)isLegalHoldPerformingAnotherOperation {
  return _tag == DBTEAMLegalHoldsPolicyUpdateErrorLegalHoldPerformingAnotherOperation;
}

- (BOOL)isInvalidMembers {
  return _tag == DBTEAMLegalHoldsPolicyUpdateErrorInvalidMembers;
}

- (BOOL)isNumberOfUsersOnHoldIsGreaterThanHoldLimitation {
  return _tag == DBTEAMLegalHoldsPolicyUpdateErrorNumberOfUsersOnHoldIsGreaterThanHoldLimitation;
}

- (BOOL)isEmptyMembersList {
  return _tag == DBTEAMLegalHoldsPolicyUpdateErrorEmptyMembersList;
}

- (BOOL)isNameMustBeUnique {
  return _tag == DBTEAMLegalHoldsPolicyUpdateErrorNameMustBeUnique;
}

- (BOOL)isLegalHoldPolicyNotFound {
  return _tag == DBTEAMLegalHoldsPolicyUpdateErrorLegalHoldPolicyNotFound;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLegalHoldsPolicyUpdateErrorUnknownLegalHoldError:
    return @"DBTEAMLegalHoldsPolicyUpdateErrorUnknownLegalHoldError";
  case DBTEAMLegalHoldsPolicyUpdateErrorInsufficientPermissions:
    return @"DBTEAMLegalHoldsPolicyUpdateErrorInsufficientPermissions";
  case DBTEAMLegalHoldsPolicyUpdateErrorOther:
    return @"DBTEAMLegalHoldsPolicyUpdateErrorOther";
  case DBTEAMLegalHoldsPolicyUpdateErrorTransientError:
    return @"DBTEAMLegalHoldsPolicyUpdateErrorTransientError";
  case DBTEAMLegalHoldsPolicyUpdateErrorInactiveLegalHold:
    return @"DBTEAMLegalHoldsPolicyUpdateErrorInactiveLegalHold";
  case DBTEAMLegalHoldsPolicyUpdateErrorLegalHoldPerformingAnotherOperation:
    return @"DBTEAMLegalHoldsPolicyUpdateErrorLegalHoldPerformingAnotherOperation";
  case DBTEAMLegalHoldsPolicyUpdateErrorInvalidMembers:
    return @"DBTEAMLegalHoldsPolicyUpdateErrorInvalidMembers";
  case DBTEAMLegalHoldsPolicyUpdateErrorNumberOfUsersOnHoldIsGreaterThanHoldLimitation:
    return @"DBTEAMLegalHoldsPolicyUpdateErrorNumberOfUsersOnHoldIsGreaterThanHoldLimitation";
  case DBTEAMLegalHoldsPolicyUpdateErrorEmptyMembersList:
    return @"DBTEAMLegalHoldsPolicyUpdateErrorEmptyMembersList";
  case DBTEAMLegalHoldsPolicyUpdateErrorNameMustBeUnique:
    return @"DBTEAMLegalHoldsPolicyUpdateErrorNameMustBeUnique";
  case DBTEAMLegalHoldsPolicyUpdateErrorLegalHoldPolicyNotFound:
    return @"DBTEAMLegalHoldsPolicyUpdateErrorLegalHoldPolicyNotFound";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLegalHoldsPolicyUpdateErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLegalHoldsPolicyUpdateErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLegalHoldsPolicyUpdateErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLegalHoldsPolicyUpdateErrorUnknownLegalHoldError:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsPolicyUpdateErrorInsufficientPermissions:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsPolicyUpdateErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsPolicyUpdateErrorTransientError:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsPolicyUpdateErrorInactiveLegalHold:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsPolicyUpdateErrorLegalHoldPerformingAnotherOperation:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsPolicyUpdateErrorInvalidMembers:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsPolicyUpdateErrorNumberOfUsersOnHoldIsGreaterThanHoldLimitation:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsPolicyUpdateErrorEmptyMembersList:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsPolicyUpdateErrorNameMustBeUnique:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLegalHoldsPolicyUpdateErrorLegalHoldPolicyNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLegalHoldsPolicyUpdateError:other];
}

- (BOOL)isEqualToLegalHoldsPolicyUpdateError:(DBTEAMLegalHoldsPolicyUpdateError *)aLegalHoldsPolicyUpdateError {
  if (self == aLegalHoldsPolicyUpdateError) {
    return YES;
  }
  if (self.tag != aLegalHoldsPolicyUpdateError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLegalHoldsPolicyUpdateErrorUnknownLegalHoldError:
    return [[self tagName] isEqual:[aLegalHoldsPolicyUpdateError tagName]];
  case DBTEAMLegalHoldsPolicyUpdateErrorInsufficientPermissions:
    return [[self tagName] isEqual:[aLegalHoldsPolicyUpdateError tagName]];
  case DBTEAMLegalHoldsPolicyUpdateErrorOther:
    return [[self tagName] isEqual:[aLegalHoldsPolicyUpdateError tagName]];
  case DBTEAMLegalHoldsPolicyUpdateErrorTransientError:
    return [[self tagName] isEqual:[aLegalHoldsPolicyUpdateError tagName]];
  case DBTEAMLegalHoldsPolicyUpdateErrorInactiveLegalHold:
    return [[self tagName] isEqual:[aLegalHoldsPolicyUpdateError tagName]];
  case DBTEAMLegalHoldsPolicyUpdateErrorLegalHoldPerformingAnotherOperation:
    return [[self tagName] isEqual:[aLegalHoldsPolicyUpdateError tagName]];
  case DBTEAMLegalHoldsPolicyUpdateErrorInvalidMembers:
    return [[self tagName] isEqual:[aLegalHoldsPolicyUpdateError tagName]];
  case DBTEAMLegalHoldsPolicyUpdateErrorNumberOfUsersOnHoldIsGreaterThanHoldLimitation:
    return [[self tagName] isEqual:[aLegalHoldsPolicyUpdateError tagName]];
  case DBTEAMLegalHoldsPolicyUpdateErrorEmptyMembersList:
    return [[self tagName] isEqual:[aLegalHoldsPolicyUpdateError tagName]];
  case DBTEAMLegalHoldsPolicyUpdateErrorNameMustBeUnique:
    return [[self tagName] isEqual:[aLegalHoldsPolicyUpdateError tagName]];
  case DBTEAMLegalHoldsPolicyUpdateErrorLegalHoldPolicyNotFound:
    return [[self tagName] isEqual:[aLegalHoldsPolicyUpdateError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLegalHoldsPolicyUpdateErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLegalHoldsPolicyUpdateError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUnknownLegalHoldError]) {
    jsonDict[@".tag"] = @"unknown_legal_hold_error";
  } else if ([valueObj isInsufficientPermissions]) {
    jsonDict[@".tag"] = @"insufficient_permissions";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isTransientError]) {
    jsonDict[@".tag"] = @"transient_error";
  } else if ([valueObj isInactiveLegalHold]) {
    jsonDict[@".tag"] = @"inactive_legal_hold";
  } else if ([valueObj isLegalHoldPerformingAnotherOperation]) {
    jsonDict[@".tag"] = @"legal_hold_performing_another_operation";
  } else if ([valueObj isInvalidMembers]) {
    jsonDict[@".tag"] = @"invalid_members";
  } else if ([valueObj isNumberOfUsersOnHoldIsGreaterThanHoldLimitation]) {
    jsonDict[@".tag"] = @"number_of_users_on_hold_is_greater_than_hold_limitation";
  } else if ([valueObj isEmptyMembersList]) {
    jsonDict[@".tag"] = @"empty_members_list";
  } else if ([valueObj isNameMustBeUnique]) {
    jsonDict[@".tag"] = @"name_must_be_unique";
  } else if ([valueObj isLegalHoldPolicyNotFound]) {
    jsonDict[@".tag"] = @"legal_hold_policy_not_found";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLegalHoldsPolicyUpdateError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"unknown_legal_hold_error"]) {
    return [[DBTEAMLegalHoldsPolicyUpdateError alloc] initWithUnknownLegalHoldError];
  } else if ([tag isEqualToString:@"insufficient_permissions"]) {
    return [[DBTEAMLegalHoldsPolicyUpdateError alloc] initWithInsufficientPermissions];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLegalHoldsPolicyUpdateError alloc] initWithOther];
  } else if ([tag isEqualToString:@"transient_error"]) {
    return [[DBTEAMLegalHoldsPolicyUpdateError alloc] initWithTransientError];
  } else if ([tag isEqualToString:@"inactive_legal_hold"]) {
    return [[DBTEAMLegalHoldsPolicyUpdateError alloc] initWithInactiveLegalHold];
  } else if ([tag isEqualToString:@"legal_hold_performing_another_operation"]) {
    return [[DBTEAMLegalHoldsPolicyUpdateError alloc] initWithLegalHoldPerformingAnotherOperation];
  } else if ([tag isEqualToString:@"invalid_members"]) {
    return [[DBTEAMLegalHoldsPolicyUpdateError alloc] initWithInvalidMembers];
  } else if ([tag isEqualToString:@"number_of_users_on_hold_is_greater_than_hold_limitation"]) {
    return [[DBTEAMLegalHoldsPolicyUpdateError alloc] initWithNumberOfUsersOnHoldIsGreaterThanHoldLimitation];
  } else if ([tag isEqualToString:@"empty_members_list"]) {
    return [[DBTEAMLegalHoldsPolicyUpdateError alloc] initWithEmptyMembersList];
  } else if ([tag isEqualToString:@"name_must_be_unique"]) {
    return [[DBTEAMLegalHoldsPolicyUpdateError alloc] initWithNameMustBeUnique];
  } else if ([tag isEqualToString:@"legal_hold_policy_not_found"]) {
    return [[DBTEAMLegalHoldsPolicyUpdateError alloc] initWithLegalHoldPolicyNotFound];
  } else {
    return [[DBTEAMLegalHoldsPolicyUpdateError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMListMemberAppsArg.h"

#pragma mark - API Object

@implementation DBTEAMListMemberAppsArg

#pragma mark - Constructors

- (instancetype)initWithTeamMemberId:(NSString *)teamMemberId {
  [DBStoneValidators nonnullValidator:nil](teamMemberId);

  self = [super init];
  if (self) {
    _teamMemberId = teamMemberId;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMListMemberAppsArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMListMemberAppsArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMListMemberAppsArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.teamMemberId hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListMemberAppsArg:other];
}

- (BOOL)isEqualToListMemberAppsArg:(DBTEAMListMemberAppsArg *)aListMemberAppsArg {
  if (self == aListMemberAppsArg) {
    return YES;
  }
  if (![self.teamMemberId isEqual:aListMemberAppsArg.teamMemberId]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMListMemberAppsArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMListMemberAppsArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"team_member_id"] = valueObj.teamMemberId;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMListMemberAppsArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *teamMemberId = valueDict[@"team_member_id"];

  return [[DBTEAMListMemberAppsArg alloc] initWithTeamMemberId:teamMemberId];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMListMemberAppsError.h"

#pragma mark - API Object

@implementation DBTEAMListMemberAppsError

#pragma mark - Constructors

- (instancetype)initWithMemberNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMListMemberAppsErrorMemberNotFound;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMListMemberAppsErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isMemberNotFound {
  return _tag == DBTEAMListMemberAppsErrorMemberNotFound;
}

- (BOOL)isOther {
  return _tag == DBTEAMListMemberAppsErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMListMemberAppsErrorMemberNotFound:
    return @"DBTEAMListMemberAppsErrorMemberNotFound";
  case DBTEAMListMemberAppsErrorOther:
    return @"DBTEAMListMemberAppsErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMListMemberAppsErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMListMemberAppsErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMListMemberAppsErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMListMemberAppsErrorMemberNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMListMemberAppsErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListMemberAppsError:other];
}

- (BOOL)isEqualToListMemberAppsError:(DBTEAMListMemberAppsError *)aListMemberAppsError {
  if (self == aListMemberAppsError) {
    return YES;
  }
  if (self.tag != aListMemberAppsError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMListMemberAppsErrorMemberNotFound:
    return [[self tagName] isEqual:[aListMemberAppsError tagName]];
  case DBTEAMListMemberAppsErrorOther:
    return [[self tagName] isEqual:[aListMemberAppsError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMListMemberAppsErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMListMemberAppsError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isMemberNotFound]) {
    jsonDict[@".tag"] = @"member_not_found";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMListMemberAppsError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"member_not_found"]) {
    return [[DBTEAMListMemberAppsError alloc] initWithMemberNotFound];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMListMemberAppsError alloc] initWithOther];
  } else {
    return [[DBTEAMListMemberAppsError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMApiApp.h"
#import "DBTEAMListMemberAppsResult.h"

#pragma mark - API Object

@implementation DBTEAMListMemberAppsResult

#pragma mark - Constructors

- (instancetype)initWithLinkedApiApps:(NSArray<DBTEAMApiApp *> *)linkedApiApps {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](linkedApiApps);

  self = [super init];
  if (self) {
    _linkedApiApps = linkedApiApps;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMListMemberAppsResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMListMemberAppsResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMListMemberAppsResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.linkedApiApps hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListMemberAppsResult:other];
}

- (BOOL)isEqualToListMemberAppsResult:(DBTEAMListMemberAppsResult *)aListMemberAppsResult {
  if (self == aListMemberAppsResult) {
    return YES;
  }
  if (![self.linkedApiApps isEqual:aListMemberAppsResult.linkedApiApps]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMListMemberAppsResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMListMemberAppsResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"linked_api_apps"] = [DBArraySerializer serialize:valueObj.linkedApiApps
                                                    withBlock:^id(id elem0) {
                                                      return [DBTEAMApiAppSerializer serialize:elem0];
                                                    }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMListMemberAppsResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBTEAMApiApp *> *linkedApiApps = [DBArraySerializer deserialize:valueDict[@"linked_api_apps"]
                                                                withBlock:^id(id elem0) {
                                                                  return [DBTEAMApiAppSerializer deserialize:elem0];
                                                                }];

  return [[DBTEAMListMemberAppsResult alloc] initWithLinkedApiApps:linkedApiApps];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMListMemberDevicesArg.h"

#pragma mark - API Object

@implementation DBTEAMListMemberDevicesArg

#pragma mark - Constructors

- (instancetype)initWithTeamMemberId:(NSString *)teamMemberId
                  includeWebSessions:(NSNumber *)includeWebSessions
               includeDesktopClients:(NSNumber *)includeDesktopClients
                includeMobileClients:(NSNumber *)includeMobileClients {
  [DBStoneValidators nonnullValidator:nil](teamMemberId);

  self = [super init];
  if (self) {
    _teamMemberId = teamMemberId;
    _includeWebSessions = includeWebSessions ?: @YES;
    _includeDesktopClients = includeDesktopClients ?: @YES;
    _includeMobileClients = includeMobileClients ?: @YES;
  }
  return self;
}

- (instancetype)initWithTeamMemberId:(NSString *)teamMemberId {
  return [self initWithTeamMemberId:teamMemberId
                 includeWebSessions:nil
              includeDesktopClients:nil
               includeMobileClients:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMListMemberDevicesArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMListMemberDevicesArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMListMemberDevicesArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.teamMemberId hash];
  result = prime * result + [self.includeWebSessions hash];
  result = prime * result + [self.includeDesktopClients hash];
  result = prime * result + [self.includeMobileClients hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListMemberDevicesArg:other];
}

- (BOOL)isEqualToListMemberDevicesArg:(DBTEAMListMemberDevicesArg *)aListMemberDevicesArg {
  if (self == aListMemberDevicesArg) {
    return YES;
  }
  if (![self.teamMemberId isEqual:aListMemberDevicesArg.teamMemberId]) {
    return NO;
  }
  if (![self.includeWebSessions isEqual:aListMemberDevicesArg.includeWebSessions]) {
    return NO;
  }
  if (![self.includeDesktopClients isEqual:aListMemberDevicesArg.includeDesktopClients]) {
    return NO;
  }
  if (![self.includeMobileClients isEqual:aListMemberDevicesArg.includeMobileClients]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMListMemberDevicesArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMListMemberDevicesArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"team_member_id"] = valueObj.teamMemberId;
  jsonDict[@"include_web_sessions"] = valueObj.includeWebSessions;
  jsonDict[@"include_desktop_clients"] = valueObj.includeDesktopClients;
  jsonDict[@"include_mobile_clients"] = valueObj.includeMobileClients;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMListMemberDevicesArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *teamMemberId = valueDict[@"team_member_id"];
  NSNumber *includeWebSessions = valueDict[@"include_web_sessions"] ?: @YES;
  NSNumber *includeDesktopClients = valueDict[@"include_desktop_clients"] ?: @YES;
  NSNumber *includeMobileClients = valueDict[@"include_mobile_clients"] ?: @YES;

  return [[DBTEAMListMemberDevicesArg alloc] initWithTeamMemberId:teamMemberId
                                               includeWebSessions:includeWebSessions
                                            includeDesktopClients:includeDesktopClients
                                             includeMobileClients:includeMobileClients];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMListMemberDevicesError.h"

#pragma mark - API Object

@implementation DBTEAMListMemberDevicesError

#pragma mark - Constructors

- (instancetype)initWithMemberNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMListMemberDevicesErrorMemberNotFound;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMListMemberDevicesErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isMemberNotFound {
  return _tag == DBTEAMListMemberDevicesErrorMemberNotFound;
}

- (BOOL)isOther {
  return _tag == DBTEAMListMemberDevicesErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMListMemberDevicesErrorMemberNotFound:
    return @"DBTEAMListMemberDevicesErrorMemberNotFound";
  case DBTEAMListMemberDevicesErrorOther:
    return @"DBTEAMListMemberDevicesErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMListMemberDevicesErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMListMemberDevicesErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMListMemberDevicesErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMListMemberDevicesErrorMemberNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMListMemberDevicesErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListMemberDevicesError:other];
}

- (BOOL)isEqualToListMemberDevicesError:(DBTEAMListMemberDevicesError *)aListMemberDevicesError {
  if (self == aListMemberDevicesError) {
    return YES;
  }
  if (self.tag != aListMemberDevicesError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMListMemberDevicesErrorMemberNotFound:
    return [[self tagName] isEqual:[aListMemberDevicesError tagName]];
  case DBTEAMListMemberDevicesErrorOther:
    return [[self tagName] isEqual:[aListMemberDevicesError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMListMemberDevicesErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMListMemberDevicesError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isMemberNotFound]) {
    jsonDict[@".tag"] = @"member_not_found";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMListMemberDevicesError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"member_not_found"]) {
    return [[DBTEAMListMemberDevicesError alloc] initWithMemberNotFound];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMListMemberDevicesError alloc] initWithOther];
  } else {
    return [[DBTEAMListMemberDevicesError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMActiveWebSession.h"
#import "DBTEAMDesktopClientSession.h"
#import "DBTEAMListMemberDevicesResult.h"
#import "DBTEAMMobileClientSession.h"

#pragma mark - API Object

@implementation DBTEAMListMemberDevicesResult

#pragma mark - Constructors

- (instancetype)initWithActiveWebSessions:(NSArray<DBTEAMActiveWebSession *> *)activeWebSessions
                    desktopClientSessions:(NSArray<DBTEAMDesktopClientSession *> *)desktopClientSessions
                     mobileClientSessions:(NSArray<DBTEAMMobileClientSession *> *)mobileClientSessions {
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](activeWebSessions);
  [DBStoneValidators nullableValidator:[DBStoneValidators arrayValidator:nil
                                                                maxItems:nil
                                                           itemValidator:[DBStoneValidators nonnullValidator:nil]]](
      desktopClientSessions);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](mobileClientSessions);

  self = [super init];
  if (self) {
    _activeWebSessions = activeWebSessions;
    _desktopClientSessions = desktopClientSessions;
    _mobileClientSessions = mobileClientSessions;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithActiveWebSessions:nil desktopClientSessions:nil mobileClientSessions:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMListMemberDevicesResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMListMemberDevicesResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMListMemberDevicesResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.activeWebSessions != nil) {
    result = prime * result + [self.activeWebSessions hash];
  }
  if (self.desktopClientSessions != nil) {
    result = prime * result + [self.desktopClientSessions hash];
  }
  if (self.mobileClientSessions != nil) {
    result = prime * result + [self.mobileClientSessions hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListMemberDevicesResult:other];
}

- (BOOL)isEqualToListMemberDevicesResult:(DBTEAMListMemberDevicesResult *)aListMemberDevicesResult {
  if (self == aListMemberDevicesResult) {
    return YES;
  }
  if (self.activeWebSessions) {
    if (![self.activeWebSessions isEqual:aListMemberDevicesResult.activeWebSessions]) {
      return NO;
    }
  }
  if (self.desktopClientSessions) {
    if (![self.desktopClientSessions isEqual:aListMemberDevicesResult.desktopClientSessions]) {
      return NO;
    }
  }
  if (self.mobileClientSessions) {
    if (![self.mobileClientSessions isEqual:aListMemberDevicesResult.mobileClientSessions]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMListMemberDevicesResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMListMemberDevicesResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.activeWebSessions) {
    jsonDict[@"active_web_sessions"] = [DBArraySerializer serialize:valueObj.activeWebSessions
                                                          withBlock:^id(id elem0) {
                                                            return [DBTEAMActiveWebSessionSerializer serialize:elem0];
                                                          }];
  }
  if (valueObj.desktopClientSessions) {
    jsonDict[@"desktop_client_sessions"] =
        [DBArraySerializer serialize:valueObj.desktopClientSessions
                           withBlock:^id(id elem0) {
                             return [DBTEAMDesktopClientSessionSerializer serialize:elem0];
                           }];
  }
  if (valueObj.mobileClientSessions) {
    jsonDict[@"mobile_client_sessions"] =
        [DBArraySerializer serialize:valueObj.mobileClientSessions
                           withBlock:^id(id elem0) {
                             return [DBTEAMMobileClientSessionSerializer serialize:elem0];
                           }];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMListMemberDevicesResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBTEAMActiveWebSession *> *activeWebSessions =
      valueDict[@"active_web_sessions"]
          ? [DBArraySerializer deserialize:valueDict[@"active_web_sessions"]
                                 withBlock:^id(id elem0) {
                                   return [DBTEAMActiveWebSessionSerializer deserialize:elem0];
                                 }]
          : nil;
  NSArray<DBTEAMDesktopClientSession *> *desktopClientSessions =
      valueDict[@"desktop_client_sessions"]
          ? [DBArraySerializer deserialize:valueDict[@"desktop_client_sessions"]
                                 withBlock:^id(id elem0) {
                                   return [DBTEAMDesktopClientSessionSerializer deserialize:elem0];
                                 }]
          : nil;
  NSArray<DBTEAMMobileClientSession *> *mobileClientSessions =
      valueDict[@"mobile_client_sessions"]
          ? [DBArraySerializer deserialize:valueDict[@"mobile_client_sessions"]
                                 withBlock:^id(id elem0) {
                                   return [DBTEAMMobileClientSessionSerializer deserialize:elem0];
                                 }]
          : nil;

  return [[DBTEAMListMemberDevicesResult alloc] initWithActiveWebSessions:activeWebSessions
                                                    desktopClientSessions:desktopClientSessions
                                                     mobileClientSessions:mobileClientSessions];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMListMembersAppsArg.h"

#pragma mark - API Object

@implementation DBTEAMListMembersAppsArg

#pragma mark - Constructors

- (instancetype)initWithCursor:(NSString *)cursor {

  self = [super init];
  if (self) {
    _cursor = cursor;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithCursor:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMListMembersAppsArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMListMembersAppsArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMListMembersAppsArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.cursor != nil) {
    result = prime * result + [self.cursor hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListMembersAppsArg:other];
}

- (BOOL)isEqualToListMembersAppsArg:(DBTEAMListMembersAppsArg *)aListMembersAppsArg {
  if (self == aListMembersAppsArg) {
    return YES;
  }
  if (self.cursor) {
    if (![self.cursor isEqual:aListMembersAppsArg.cursor]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMListMembersAppsArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMListMembersAppsArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.cursor) {
    jsonDict[@"cursor"] = valueObj.cursor;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMListMembersAppsArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *cursor = valueDict[@"cursor"] ?: nil;

  return [[DBTEAMListMembersAppsArg alloc] initWithCursor:cursor];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMListMembersAppsError.h"

#pragma mark - API Object

@implementation DBTEAMListMembersAppsError

#pragma mark - Constructors

- (instancetype)initWithReset {
  self = [super init];
  if (self) {
    _tag = DBTEAMListMembersAppsErrorReset;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMListMembersAppsErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isReset {
  return _tag == DBTEAMListMembersAppsErrorReset;
}

- (BOOL)isOther {
  return _tag == DBTEAMListMembersAppsErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMListMembersAppsErrorReset:
    return @"DBTEAMListMembersAppsErrorReset";
  case DBTEAMListMembersAppsErrorOther:
    return @"DBTEAMListMembersAppsErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMListMembersAppsErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMListMembersAppsErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMListMembersAppsErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMListMembersAppsErrorReset:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMListMembersAppsErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListMembersAppsError:other];
}

- (BOOL)isEqualToListMembersAppsError:(DBTEAMListMembersAppsError *)aListMembersAppsError {
  if (self == aListMembersAppsError) {
    return YES;
  }
  if (self.tag != aListMembersAppsError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMListMembersAppsErrorReset:
    return [[self tagName] isEqual:[aListMembersAppsError tagName]];
  case DBTEAMListMembersAppsErrorOther:
    return [[self tagName] isEqual:[aListMembersAppsError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMListMembersAppsErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMListMembersAppsError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isReset]) {
    jsonDict[@".tag"] = @"reset";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMListMembersAppsError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"reset"]) {
    return [[DBTEAMListMembersAppsError alloc] initWithReset];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMListMembersAppsError alloc] initWithOther];
  } else {
    return [[DBTEAMListMembersAppsError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMListMembersAppsResult.h"
#import "DBTEAMMemberLinkedApps.h"

#pragma mark - API Object

@implementation DBTEAMListMembersAppsResult

#pragma mark - Constructors

- (instancetype)initWithApps:(NSArray<DBTEAMMemberLinkedApps *> *)apps
                     hasMore:(NSNumber *)hasMore
                      cursor:(NSString *)cursor {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](apps);
  [DBStoneValidators nonnullValidator:nil](hasMore);

  self = [super init];
  if (self) {
    _apps = apps;
    _hasMore = hasMore;
    _cursor = cursor;
  }
  return self;
}

- (instancetype)initWithApps:(NSArray<DBTEAMMemberLinkedApps *> *)apps hasMore:(NSNumber *)hasMore {
  return [self initWithApps:apps hasMore:hasMore cursor:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMListMembersAppsResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMListMembersAppsResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMListMembersAppsResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.apps hash];
  result = prime * result + [self.hasMore hash];
  if (self.cursor != nil) {
    result = prime * result + [self.cursor hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListMembersAppsResult:other];
}

- (BOOL)isEqualToListMembersAppsResult:(DBTEAMListMembersAppsResult *)aListMembersAppsResult {
  if (self == aListMembersAppsResult) {
    return YES;
  }
  if (![self.apps isEqual:aListMembersAppsResult.apps]) {
    return NO;
  }
  if (![self.hasMore isEqual:aListMembersAppsResult.hasMore]) {
    return NO;
  }
  if (self.cursor) {
    if (![self.cursor isEqual:aListMembersAppsResult.cursor]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMListMembersAppsResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMListMembersAppsResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"apps"] = [DBArraySerializer serialize:valueObj.apps
                                         withBlock:^id(id elem0) {
                                           return [DBTEAMMemberLinkedAppsSerializer serialize:elem0];
                                         }];
  jsonDict[@"has_more"] = valueObj.hasMore;
  if (valueObj.cursor) {
    jsonDict[@"cursor"] = valueObj.cursor;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMListMembersAppsResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBTEAMMemberLinkedApps *> *apps =
      [DBArraySerializer deserialize:valueDict[@"apps"]
                           withBlock:^id(id elem0) {
                             return [DBTEAMMemberLinkedAppsSerializer deserialize:elem0];
                           }];
  NSNumber *hasMore = valueDict[@"has_more"];
  NSString *cursor = valueDict[@"cursor"] ?: nil;

  return [[DBTEAMListMembersAppsResult alloc] initWithApps:apps hasMore:hasMore cursor:cursor];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMListMembersDevicesArg.h"

#pragma mark - API Object

@implementation DBTEAMListMembersDevicesArg

#pragma mark - Constructors

- (instancetype)initWithCursor:(NSString *)cursor
            includeWebSessions:(NSNumber *)includeWebSessions
         includeDesktopClients:(NSNumber *)includeDesktopClients
          includeMobileClients:(NSNumber *)includeMobileClients {

  self = [super init];
  if (self) {
    _cursor = cursor;
    _includeWebSessions = includeWebSessions ?: @YES;
    _includeDesktopClients = includeDesktopClients ?: @YES;
    _includeMobileClients = includeMobileClients ?: @YES;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithCursor:nil includeWebSessions:nil includeDesktopClients:nil includeMobileClients:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMListMembersDevicesArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMListMembersDevicesArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMListMembersDevicesArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.cursor != nil) {
    result = prime * result + [self.cursor hash];
  }
  result = prime * result + [self.includeWebSessions hash];
  result = prime * result + [self.includeDesktopClients hash];
  result = prime * result + [self.includeMobileClients hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListMembersDevicesArg:other];
}

- (BOOL)isEqualToListMembersDevicesArg:(DBTEAMListMembersDevicesArg *)aListMembersDevicesArg {
  if (self == aListMembersDevicesArg) {
    return YES;
  }
  if (self.cursor) {
    if (![self.cursor isEqual:aListMembersDevicesArg.cursor]) {
      return NO;
    }
  }
  if (![self.includeWebSessions isEqual:aListMembersDevicesArg.includeWebSessions]) {
    return NO;
  }
  if (![self.includeDesktopClients isEqual:aListMembersDevicesArg.includeDesktopClients]) {
    return NO;
  }
  if (![self.includeMobileClients isEqual:aListMembersDevicesArg.includeMobileClients]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMListMembersDevicesArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMListMembersDevicesArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.cursor) {
    jsonDict[@"cursor"] = valueObj.cursor;
  }
  jsonDict[@"include_web_sessions"] = valueObj.includeWebSessions;
  jsonDict[@"include_desktop_clients"] = valueObj.includeDesktopClients;
  jsonDict[@"include_mobile_clients"] = valueObj.includeMobileClients;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMListMembersDevicesArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *cursor = valueDict[@"cursor"] ?: nil;
  NSNumber *includeWebSessions = valueDict[@"include_web_sessions"] ?: @YES;
  NSNumber *includeDesktopClients = valueDict[@"include_desktop_clients"] ?: @YES;
  NSNumber *includeMobileClients = valueDict[@"include_mobile_clients"] ?: @YES;

  return [[DBTEAMListMembersDevicesArg alloc] initWithCursor:cursor
                                          includeWebSessions:includeWebSessions
                                       includeDesktopClients:includeDesktopClients
                                        includeMobileClients:includeMobileClients];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMListMembersDevicesError.h"

#pragma mark - API Object

@implementation DBTEAMListMembersDevicesError

#pragma mark - Constructors

- (instancetype)initWithReset {
  self = [super init];
  if (self) {
    _tag = DBTEAMListMembersDevicesErrorReset;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMListMembersDevicesErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isReset {
  return _tag == DBTEAMListMembersDevicesErrorReset;
}

- (BOOL)isOther {
  return _tag == DBTEAMListMembersDevicesErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMListMembersDevicesErrorReset:
    return @"DBTEAMListMembersDevicesErrorReset";
  case DBTEAMListMembersDevicesErrorOther:
    return @"DBTEAMListMembersDevicesErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMListMembersDevicesErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMListMembersDevicesErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMListMembersDevicesErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMListMembersDevicesErrorReset:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMListMembersDevicesErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListMembersDevicesError:other];
}

- (BOOL)isEqualToListMembersDevicesError:(DBTEAMListMembersDevicesError *)aListMembersDevicesError {
  if (self == aListMembersDevicesError) {
    return YES;
  }
  if (self.tag != aListMembersDevicesError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMListMembersDevicesErrorReset:
    return [[self tagName] isEqual:[aListMembersDevicesError tagName]];
  case DBTEAMListMembersDevicesErrorOther:
    return [[self tagName] isEqual:[aListMembersDevicesError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMListMembersDevicesErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMListMembersDevicesError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isReset]) {
    jsonDict[@".tag"] = @"reset";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMListMembersDevicesError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"reset"]) {
    return [[DBTEAMListMembersDevicesError alloc] initWithReset];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMListMembersDevicesError alloc] initWithOther];
  } else {
    return [[DBTEAMListMembersDevicesError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMListMembersDevicesResult.h"
#import "DBTEAMMemberDevices.h"

#pragma mark - API Object

@implementation DBTEAMListMembersDevicesResult

#pragma mark - Constructors

- (instancetype)initWithDevices:(NSArray<DBTEAMMemberDevices *> *)devices
                        hasMore:(NSNumber *)hasMore
                         cursor:(NSString *)cursor {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](devices);
  [DBStoneValidators nonnullValidator:nil](hasMore);

  self = [super init];
  if (self) {
    _devices = devices;
    _hasMore = hasMore;
    _cursor = cursor;
  }
  return self;
}

- (instancetype)initWithDevices:(NSArray<DBTEAMMemberDevices *> *)devices hasMore:(NSNumber *)hasMore {
  return [self initWithDevices:devices hasMore:hasMore cursor:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMListMembersDevicesResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMListMembersDevicesResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMListMembersDevicesResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.devices hash];
  result = prime * result + [self.hasMore hash];
  if (self.cursor != nil) {
    result = prime * result + [self.cursor hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListMembersDevicesResult:other];
}

- (BOOL)isEqualToListMembersDevicesResult:(DBTEAMListMembersDevicesResult *)aListMembersDevicesResult {
  if (self == aListMembersDevicesResult) {
    return YES;
  }
  if (![self.devices isEqual:aListMembersDevicesResult.devices]) {
    return NO;
  }
  if (![self.hasMore isEqual:aListMembersDevicesResult.hasMore]) {
    return NO;
  }
  if (self.cursor) {
    if (![self.cursor isEqual:aListMembersDevicesResult.cursor]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMListMembersDevicesResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMListMembersDevicesResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"devices"] = [DBArraySerializer serialize:valueObj.devices
                                            withBlock:^id(id elem0) {
                                              return [DBTEAMMemberDevicesSerializer serialize:elem0];
                                            }];
  jsonDict[@"has_more"] = valueObj.hasMore;
  if (valueObj.cursor) {
    jsonDict[@"cursor"] = valueObj.cursor;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMListMembersDevicesResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBTEAMMemberDevices *> *devices =
      [DBArraySerializer deserialize:valueDict[@"devices"]
                           withBlock:^id(id elem0) {
                             return [DBTEAMMemberDevicesSerializer deserialize:elem0];
                           }];
  NSNumber *hasMore = valueDict[@"has_more"];
  NSString *cursor = valueDict[@"cursor"] ?: nil;

  return [[DBTEAMListMembersDevicesResult alloc] initWithDevices:devices hasMore:hasMore cursor:cursor];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMListTeamAppsArg.h"

#pragma mark - API Object

@implementation DBTEAMListTeamAppsArg

#pragma mark - Constructors

- (instancetype)initWithCursor:(NSString *)cursor {

  self = [super init];
  if (self) {
    _cursor = cursor;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithCursor:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMListTeamAppsArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMListTeamAppsArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMListTeamAppsArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.cursor != nil) {
    result = prime * result + [self.cursor hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListTeamAppsArg:other];
}

- (BOOL)isEqualToListTeamAppsArg:(DBTEAMListTeamAppsArg *)aListTeamAppsArg {
  if (self == aListTeamAppsArg) {
    return YES;
  }
  if (self.cursor) {
    if (![self.cursor isEqual:aListTeamAppsArg.cursor]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMListTeamAppsArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMListTeamAppsArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.cursor) {
    jsonDict[@"cursor"] = valueObj.cursor;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMListTeamAppsArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *cursor = valueDict[@"cursor"] ?: nil;

  return [[DBTEAMListTeamAppsArg alloc] initWithCursor:cursor];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMListTeamAppsError.h"

#pragma mark - API Object

@implementation DBTEAMListTeamAppsError

#pragma mark - Constructors

- (instancetype)initWithReset {
  self = [super init];
  if (self) {
    _tag = DBTEAMListTeamAppsErrorReset;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMListTeamAppsErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isReset {
  return _tag == DBTEAMListTeamAppsErrorReset;
}

- (BOOL)isOther {
  return _tag == DBTEAMListTeamAppsErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMListTeamAppsErrorReset:
    return @"DBTEAMListTeamAppsErrorReset";
  case DBTEAMListTeamAppsErrorOther:
    return @"DBTEAMListTeamAppsErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMListTeamAppsErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMListTeamAppsErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMListTeamAppsErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMListTeamAppsErrorReset:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMListTeamAppsErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListTeamAppsError:other];
}

- (BOOL)isEqualToListTeamAppsError:(DBTEAMListTeamAppsError *)aListTeamAppsError {
  if (self == aListTeamAppsError) {
    return YES;
  }
  if (self.tag != aListTeamAppsError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMListTeamAppsErrorReset:
    return [[self tagName] isEqual:[aListTeamAppsError tagName]];
  case DBTEAMListTeamAppsErrorOther:
    return [[self tagName] isEqual:[aListTeamAppsError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMListTeamAppsErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMListTeamAppsError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isReset]) {
    jsonDict[@".tag"] = @"reset";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMListTeamAppsError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"reset"]) {
    return [[DBTEAMListTeamAppsError alloc] initWithReset];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMListTeamAppsError alloc] initWithOther];
  } else {
    return [[DBTEAMListTeamAppsError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMListTeamAppsResult.h"
#import "DBTEAMMemberLinkedApps.h"

#pragma mark - API Object

@implementation DBTEAMListTeamAppsResult

#pragma mark - Constructors

- (instancetype)initWithApps:(NSArray<DBTEAMMemberLinkedApps *> *)apps
                     hasMore:(NSNumber *)hasMore
                      cursor:(NSString *)cursor {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](apps);
  [DBStoneValidators nonnullValidator:nil](hasMore);

  self = [super init];
  if (self) {
    _apps = apps;
    _hasMore = hasMore;
    _cursor = cursor;
  }
  return self;
}

- (instancetype)initWithApps:(NSArray<DBTEAMMemberLinkedApps *> *)apps hasMore:(NSNumber *)hasMore {
  return [self initWithApps:apps hasMore:hasMore cursor:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMListTeamAppsResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMListTeamAppsResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMListTeamAppsResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.apps hash];
  result = prime * result + [self.hasMore hash];
  if (self.cursor != nil) {
    result = prime * result + [self.cursor hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListTeamAppsResult:other];
}

- (BOOL)isEqualToListTeamAppsResult:(DBTEAMListTeamAppsResult *)aListTeamAppsResult {
  if (self == aListTeamAppsResult) {
    return YES;
  }
  if (![self.apps isEqual:aListTeamAppsResult.apps]) {
    return NO;
  }
  if (![self.hasMore isEqual:aListTeamAppsResult.hasMore]) {
    return NO;
  }
  if (self.cursor) {
    if (![self.cursor isEqual:aListTeamAppsResult.cursor]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMListTeamAppsResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMListTeamAppsResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"apps"] = [DBArraySerializer serialize:valueObj.apps
                                         withBlock:^id(id elem0) {
                                           return [DBTEAMMemberLinkedAppsSerializer serialize:elem0];
                                         }];
  jsonDict[@"has_more"] = valueObj.hasMore;
  if (valueObj.cursor) {
    jsonDict[@"cursor"] = valueObj.cursor;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMListTeamAppsResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBTEAMMemberLinkedApps *> *apps =
      [DBArraySerializer deserialize:valueDict[@"apps"]
                           withBlock:^id(id elem0) {
                             return [DBTEAMMemberLinkedAppsSerializer deserialize:elem0];
                           }];
  NSNumber *hasMore = valueDict[@"has_more"];
  NSString *cursor = valueDict[@"cursor"] ?: nil;

  return [[DBTEAMListTeamAppsResult alloc] initWithApps:apps hasMore:hasMore cursor:cursor];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMListTeamDevicesArg.h"

#pragma mark - API Object

@implementation DBTEAMListTeamDevicesArg

#pragma mark - Constructors

- (instancetype)initWithCursor:(NSString *)cursor
            includeWebSessions:(NSNumber *)includeWebSessions
         includeDesktopClients:(NSNumber *)includeDesktopClients
          includeMobileClients:(NSNumber *)includeMobileClients {

  self = [super init];
  if (self) {
    _cursor = cursor;
    _includeWebSessions = includeWebSessions ?: @YES;
    _includeDesktopClients = includeDesktopClients ?: @YES;
    _includeMobileClients = includeMobileClients ?: @YES;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithCursor:nil includeWebSessions:nil includeDesktopClients:nil includeMobileClients:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMListTeamDevicesArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMListTeamDevicesArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMListTeamDevicesArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.cursor != nil) {
    result = prime * result + [self.cursor hash];
  }
  result = prime * result + [self.includeWebSessions hash];
  result = prime * result + [self.includeDesktopClients hash];
  result = prime * result + [self.includeMobileClients hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListTeamDevicesArg:other];
}

- (BOOL)isEqualToListTeamDevicesArg:(DBTEAMListTeamDevicesArg *)aListTeamDevicesArg {
  if (self == aListTeamDevicesArg) {
    return YES;
  }
  if (self.cursor) {
    if (![self.cursor isEqual:aListTeamDevicesArg.cursor]) {
      return NO;
    }
  }
  if (![self.includeWebSessions isEqual:aListTeamDevicesArg.includeWebSessions]) {
    return NO;
  }
  if (![self.includeDesktopClients isEqual:aListTeamDevicesArg.includeDesktopClients]) {
    return NO;
  }
  if (![self.includeMobileClients isEqual:aListTeamDevicesArg.includeMobileClients]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMListTeamDevicesArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMListTeamDevicesArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.cursor) {
    jsonDict[@"cursor"] = valueObj.cursor;
  }
  jsonDict[@"include_web_sessions"] = valueObj.includeWebSessions;
  jsonDict[@"include_desktop_clients"] = valueObj.includeDesktopClients;
  jsonDict[@"include_mobile_clients"] = valueObj.includeMobileClients;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMListTeamDevicesArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *cursor = valueDict[@"cursor"] ?: nil;
  NSNumber *includeWebSessions = valueDict[@"include_web_sessions"] ?: @YES;
  NSNumber *includeDesktopClients = valueDict[@"include_desktop_clients"] ?: @YES;
  NSNumber *includeMobileClients = valueDict[@"include_mobile_clients"] ?: @YES;

  return [[DBTEAMListTeamDevicesArg alloc] initWithCursor:cursor
                                       includeWebSessions:includeWebSessions
                                    includeDesktopClients:includeDesktopClients
                                     includeMobileClients:includeMobileClients];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMListTeamDevicesError.h"

#pragma mark - API Object

@implementation DBTEAMListTeamDevicesError

#pragma mark - Constructors

- (instancetype)initWithReset {
  self = [super init];
  if (self) {
    _tag = DBTEAMListTeamDevicesErrorReset;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMListTeamDevicesErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isReset {
  return _tag == DBTEAMListTeamDevicesErrorReset;
}

- (BOOL)isOther {
  return _tag == DBTEAMListTeamDevicesErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMListTeamDevicesErrorReset:
    return @"DBTEAMListTeamDevicesErrorReset";
  case DBTEAMListTeamDevicesErrorOther:
    return @"DBTEAMListTeamDevicesErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMListTeamDevicesErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMListTeamDevicesErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMListTeamDevicesErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMListTeamDevicesErrorReset:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMListTeamDevicesErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListTeamDevicesError:other];
}

- (BOOL)isEqualToListTeamDevicesError:(DBTEAMListTeamDevicesError *)aListTeamDevicesError {
  if (self == aListTeamDevicesError) {
    return YES;
  }
  if (self.tag != aListTeamDevicesError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMListTeamDevicesErrorReset:
    return [[self tagName] isEqual:[aListTeamDevicesError tagName]];
  case DBTEAMListTeamDevicesErrorOther:
    return [[self tagName] isEqual:[aListTeamDevicesError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMListTeamDevicesErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMListTeamDevicesError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isReset]) {
    jsonDict[@".tag"] = @"reset";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMListTeamDevicesError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"reset"]) {
    return [[DBTEAMListTeamDevicesError alloc] initWithReset];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMListTeamDevicesError alloc] initWithOther];
  } else {
    return [[DBTEAMListTeamDevicesError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMListTeamDevicesResult.h"
#import "DBTEAMMemberDevices.h"

#pragma mark - API Object

@implementation DBTEAMListTeamDevicesResult

#pragma mark - Constructors

- (instancetype)initWithDevices:(NSArray<DBTEAMMemberDevices *> *)devices
                        hasMore:(NSNumber *)hasMore
                         cursor:(NSString *)cursor {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](devices);
  [DBStoneValidators nonnullValidator:nil](hasMore);

  self = [super init];
  if (self) {
    _devices = devices;
    _hasMore = hasMore;
    _cursor = cursor;
  }
  return self;
}

- (instancetype)initWithDevices:(NSArray<DBTEAMMemberDevices *> *)devices hasMore:(NSNumber *)hasMore {
  return [self initWithDevices:devices hasMore:hasMore cursor:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMListTeamDevicesResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMListTeamDevicesResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMListTeamDevicesResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.devices hash];
  result = prime * result + [self.hasMore hash];
  if (self.cursor != nil) {
    result = prime * result + [self.cursor hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListTeamDevicesResult:other];
}

- (BOOL)isEqualToListTeamDevicesResult:(DBTEAMListTeamDevicesResult *)aListTeamDevicesResult {
  if (self == aListTeamDevicesResult) {
    return YES;
  }
  if (![self.devices isEqual:aListTeamDevicesResult.devices]) {
    return NO;
  }
  if (![self.hasMore isEqual:aListTeamDevicesResult.hasMore]) {
    return NO;
  }
  if (self.cursor) {
    if (![self.cursor isEqual:aListTeamDevicesResult.cursor]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMListTeamDevicesResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMListTeamDevicesResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"devices"] = [DBArraySerializer serialize:valueObj.devices
                                            withBlock:^id(id elem0) {
                                              return [DBTEAMMemberDevicesSerializer serialize:elem0];
                                            }];
  jsonDict[@"has_more"] = valueObj.hasMore;
  if (valueObj.cursor) {
    jsonDict[@"cursor"] = valueObj.cursor;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMListTeamDevicesResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBTEAMMemberDevices *> *devices =
      [DBArraySerializer deserialize:valueDict[@"devices"]
                           withBlock:^id(id elem0) {
                             return [DBTEAMMemberDevicesSerializer deserialize:elem0];
                           }];
  NSNumber *hasMore = valueDict[@"has_more"];
  NSString *cursor = valueDict[@"cursor"] ?: nil;

  return [[DBTEAMListTeamDevicesResult alloc] initWithDevices:devices hasMore:hasMore cursor:cursor];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMGroupAccessType.h"
#import "DBTEAMMemberAccess.h"
#import "DBTEAMUserSelectorArg.h"

#pragma mark - API Object

@implementation DBTEAMMemberAccess

#pragma mark - Constructors

- (instancetype)initWithUser:(DBTEAMUserSelectorArg *)user accessType:(DBTEAMGroupAccessType *)accessType {
  [DBStoneValidators nonnullValidator:nil](user);
  [DBStoneValidators nonnullValidator:nil](accessType);

  self = [super init];
  if (self) {
    _user = user;
    _accessType = accessType;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMemberAccessSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMemberAccessSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMemberAccessSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.user hash];
  result = prime * result + [self.accessType hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMemberAccess:other];
}

- (BOOL)isEqualToMemberAccess:(DBTEAMMemberAccess *)aMemberAccess {
  if (self == aMemberAccess) {
    return YES;
  }
  if (![self.user isEqual:aMemberAccess.user]) {
    return NO;
  }
  if (![self.accessType isEqual:aMemberAccess.accessType]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMemberAccessSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMemberAccess *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"user"] = [DBTEAMUserSelectorArgSerializer serialize:valueObj.user];
  jsonDict[@"access_type"] = [DBTEAMGroupAccessTypeSerializer serialize:valueObj.accessType];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMemberAccess *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMUserSelectorArg *user = [DBTEAMUserSelectorArgSerializer deserialize:valueDict[@"user"]];
  DBTEAMGroupAccessType *accessType = [DBTEAMGroupAccessTypeSerializer deserialize:valueDict[@"access_type"]];

  return [[DBTEAMMemberAccess alloc] initWithUser:user accessType:accessType];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMAdminTier.h"
#import "DBTEAMMemberAddArg.h"

#pragma mark - API Object

@implementation DBTEAMMemberAddArg

#pragma mark - Constructors

- (instancetype)initWithMemberEmail:(NSString *)memberEmail
                    memberGivenName:(NSString *)memberGivenName
                      memberSurname:(NSString *)memberSurname
                   memberExternalId:(NSString *)memberExternalId
                 memberPersistentId:(NSString *)memberPersistentId
                   sendWelcomeEmail:(NSNumber *)sendWelcomeEmail
                               role:(DBTEAMAdminTier *)role
              isDirectoryRestricted:(NSNumber *)isDirectoryRestricted {
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:nil
                                                               maxLength:@(255)
                                                                 pattern:@"^['&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9."
                                                                         @"-]*\\.[A-Za-z]{2,15}$"]](memberEmail);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators stringValidator:nil maxLength:@(100) pattern:@"[^/:?*<>\"|]*"]](
      memberGivenName);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators stringValidator:nil maxLength:@(100) pattern:@"[^/:?*<>\"|]*"]](memberSurname);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators stringValidator:nil maxLength:@(64) pattern:nil]](memberExternalId);

  self = [super init];
  if (self) {
    _memberEmail = memberEmail;
    _memberGivenName = memberGivenName;
    _memberSurname = memberSurname;
    _memberExternalId = memberExternalId;
    _memberPersistentId = memberPersistentId;
    _sendWelcomeEmail = sendWelcomeEmail ?: @YES;
    _role = role ?: [[DBTEAMAdminTier alloc] initWithMemberOnly];
    _isDirectoryRestricted = isDirectoryRestricted;
  }
  return self;
}

- (instancetype)initWithMemberEmail:(NSString *)memberEmail {
  return [self initWithMemberEmail:memberEmail
                   memberGivenName:nil
                     memberSurname:nil
                  memberExternalId:nil
                memberPersistentId:nil
                  sendWelcomeEmail:nil
                              role:nil
             isDirectoryRestricted:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMemberAddArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMemberAddArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMemberAddArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.memberEmail hash];
  if (self.memberGivenName != nil) {
    result = prime * result + [self.memberGivenName hash];
  }
  if (self.memberSurname != nil) {
    result = prime * result + [self.memberSurname hash];
  }
  if (self.memberExternalId != nil) {
    result = prime * result + [self.memberExternalId hash];
  }
  if (self.memberPersistentId != nil) {
    result = prime * result + [self.memberPersistentId hash];
  }
  result = prime * result + [self.sendWelcomeEmail hash];
  result = prime * result + [self.role hash];
  if (self.isDirectoryRestricted != nil) {
    result = prime * result + [self.isDirectoryRestricted hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMemberAddArg:other];
}

- (BOOL)isEqualToMemberAddArg:(DBTEAMMemberAddArg *)aMemberAddArg {
  if (self == aMemberAddArg) {
    return YES;
  }
  if (![self.memberEmail isEqual:aMemberAddArg.memberEmail]) {
    return NO;
  }
  if (self.memberGivenName) {
    if (![self.memberGivenName isEqual:aMemberAddArg.memberGivenName]) {
      return NO;
    }
  }
  if (self.memberSurname) {
    if (![self.memberSurname isEqual:aMemberAddArg.memberSurname]) {
      return NO;
    }
  }
  if (self.memberExternalId) {
    if (![self.memberExternalId isEqual:aMemberAddArg.memberExternalId]) {
      return NO;
    }
  }
  if (self.memberPersistentId) {
    if (![self.memberPersistentId isEqual:aMemberAddArg.memberPersistentId]) {
      return NO;
    }
  }
  if (![self.sendWelcomeEmail isEqual:aMemberAddArg.sendWelcomeEmail]) {
    return NO;
  }
  if (![self.role isEqual:aMemberAddArg.role]) {
    return NO;
  }
  if (self.isDirectoryRestricted) {
    if (![self.isDirectoryRestricted isEqual:aMemberAddArg.isDirectoryRestricted]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMemberAddArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMemberAddArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"member_email"] = valueObj.memberEmail;
  if (valueObj.memberGivenName) {
    jsonDict[@"member_given_name"] = valueObj.memberGivenName;
  }
  if (valueObj.memberSurname) {
    jsonDict[@"member_surname"] = valueObj.memberSurname;
  }
  if (valueObj.memberExternalId) {
    jsonDict[@"member_external_id"] = valueObj.memberExternalId;
  }
  if (valueObj.memberPersistentId) {
    jsonDict[@"member_persistent_id"] = valueObj.memberPersistentId;
  }
  jsonDict[@"send_welcome_email"] = valueObj.sendWelcomeEmail;
  jsonDict[@"role"] = [DBTEAMAdminTierSerializer serialize:valueObj.role];
  if (valueObj.isDirectoryRestricted) {
    jsonDict[@"is_directory_restricted"] = valueObj.isDirectoryRestricted;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMemberAddArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *memberEmail = valueDict[@"member_email"];
  NSString *memberGivenName = valueDict[@"member_given_name"] ?: nil;
  NSString *memberSurname = valueDict[@"member_surname"] ?: nil;
  NSString *memberExternalId = valueDict[@"member_external_id"] ?: nil;
  NSString *memberPersistentId = valueDict[@"member_persistent_id"] ?: nil;
  NSNumber *sendWelcomeEmail = valueDict[@"send_welcome_email"] ?: @YES;
  DBTEAMAdminTier *role = valueDict[@"role"] ? [DBTEAMAdminTierSerializer deserialize:valueDict[@"role"]]
                                             : [[DBTEAMAdminTier alloc] initWithMemberOnly];
  NSNumber *isDirectoryRestricted = valueDict[@"is_directory_restricted"] ?: nil;

  return [[DBTEAMMemberAddArg alloc] initWithMemberEmail:memberEmail
                                         memberGivenName:memberGivenName
                                           memberSurname:memberSurname
                                        memberExternalId:memberExternalId
                                      memberPersistentId:memberPersistentId
                                        sendWelcomeEmail:sendWelcomeEmail
                                                    role:role
                                   isDirectoryRestricted:isDirectoryRestricted];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMemberAddResult.h"
#import "DBTEAMTeamMemberInfo.h"

#pragma mark - API Object

@implementation DBTEAMMemberAddResult

@synthesize success = _success;
@synthesize teamLicenseLimit = _teamLicenseLimit;
@synthesize freeTeamMemberLimitReached = _freeTeamMemberLimitReached;
@synthesize userAlreadyOnTeam = _userAlreadyOnTeam;
@synthesize userOnAnotherTeam = _userOnAnotherTeam;
@synthesize userAlreadyPaired = _userAlreadyPaired;
@synthesize userMigrationFailed = _userMigrationFailed;
@synthesize duplicateExternalMemberId = _duplicateExternalMemberId;
@synthesize duplicateMemberPersistentId = _duplicateMemberPersistentId;
@synthesize persistentIdDisabled = _persistentIdDisabled;
@synthesize userCreationFailed = _userCreationFailed;

#pragma mark - Constructors

- (instancetype)initWithSuccess:(DBTEAMTeamMemberInfo *)success {
  self = [super init];
  if (self) {
    _tag = DBTEAMMemberAddResultSuccess;
    _success = success;
  }
  return self;
}

- (instancetype)initWithTeamLicenseLimit:(NSString *)teamLicenseLimit {
  self = [super init];
  if (self) {
    _tag = DBTEAMMemberAddResultTeamLicenseLimit;
    _teamLicenseLimit = teamLicenseLimit;
  }
  return self;
}

- (instancetype)initWithFreeTeamMemberLimitReached:(NSString *)freeTeamMemberLimitReached {
  self = [super init];
  if (self) {
    _tag = DBTEAMMemberAddResultFreeTeamMemberLimitReached;
    _freeTeamMemberLimitReached = freeTeamMemberLimitReached;
  }
  return self;
}

- (instancetype)initWithUserAlreadyOnTeam:(NSString *)userAlreadyOnTeam {
  self = [super init];
  if (self) {
    _tag = DBTEAMMemberAddResultUserAlreadyOnTeam;
    _userAlreadyOnTeam = userAlreadyOnTeam;
  }
  return self;
}

- (instancetype)initWithUserOnAnotherTeam:(NSString *)userOnAnotherTeam {
  self = [super init];
  if (self) {
    _tag = DBTEAMMemberAddResultUserOnAnotherTeam;
    _userOnAnotherTeam = userOnAnotherTeam;
  }
  return self;
}

- (instancetype)initWithUserAlreadyPaired:(NSString *)userAlreadyPaired {
  self = [super init];
  if (self) {
    _tag = DBTEAMMemberAddResultUserAlreadyPaired;
    _userAlreadyPaired = userAlreadyPaired;
  }
  return self;
}

- (instancetype)initWithUserMigrationFailed:(NSString *)userMigrationFailed {
  self = [super init];
  if (self) {
    _tag = DBTEAMMemberAddResultUserMigrationFailed;
    _userMigrationFailed = userMigrationFailed;
  }
  return self;
}

- (instancetype)initWithDuplicateExternalMemberId:(NSString *)duplicateExternalMemberId {
  self = [super init];
  if (self) {
    _tag = DBTEAMMemberAddResultDuplicateExternalMemberId;
    _duplicateExternalMemberId = duplicateExternalMemberId;
  }
  return self;
}

- (instancetype)initWithDuplicateMemberPersistentId:(NSString *)duplicateMemberPersistentId {
  self = [super init];
  if (self) {
    _tag = DBTEAMMemberAddResultDuplicateMemberPersistentId;
    _duplicateMemberPersistentId = duplicateMemberPersistentId;
  }
  return self;
}

- (instancetype)initWithPersistentIdDisabled:(NSString *)persistentIdDisabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMMemberAddResultPersistentIdDisabled;
    _persistentIdDisabled = persistentIdDisabled;
  }
  return self;
}

- (instancetype)initWithUserCreationFailed:(NSString *)userCreationFailed {
  self = [super init];
  if (self) {
    _tag = DBTEAMMemberAddResultUserCreationFailed;
    _userCreationFailed = userCreationFailed;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBTEAMTeamMemberInfo *)success {
  if (![self isSuccess]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMMemberAddResultSuccess, but was %@.", [self tagName]];
  }
  return _success;
}

- (NSString *)teamLicenseLimit {
  if (![self isTeamLicenseLimit]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMMemberAddResultTeamLicenseLimit, but was %@.", [self tagName]];
  }
  return _teamLicenseLimit;
}

- (NSString *)freeTeamMemberLimitReached {
  if (![self isFreeTeamMemberLimitReached]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMMemberAddResultFreeTeamMemberLimitReached, but was %@.", [self tagName]];
  }
  return _freeTeamMemberLimitReached;
}

- (NSString *)userAlreadyOnTeam {
  if (![self isUserAlreadyOnTeam]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMMemberAddResultUserAlreadyOnTeam, but was %@.", [self tagName]];
  }
  return _userAlreadyOnTeam;
}

- (NSString *)userOnAnotherTeam {
  if (![self isUserOnAnotherTeam]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMMemberAddResultUserOnAnotherTeam, but was %@.", [self tagName]];
  }
  return _userOnAnotherTeam;
}

- (NSString *)userAlreadyPaired {
  if (![self isUserAlreadyPaired]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMMemberAddResultUserAlreadyPaired, but was %@.", [self tagName]];
  }
  return _userAlreadyPaired;
}

- (NSString *)userMigrationFailed {
  if (![self isUserMigrationFailed]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMMemberAddResultUserMigrationFailed, but was %@.", [self tagName]];
  }
  return _userMigrationFailed;
}

- (NSString *)duplicateExternalMemberId {
  if (![self isDuplicateExternalMemberId]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMMemberAddResultDuplicateExternalMemberId, but was %@.", [self tagName]];
  }
  return _duplicateExternalMemberId;
}

- (NSString *)duplicateMemberPersistentId {
  if (![self isDuplicateMemberPersistentId]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMMemberAddResultDuplicateMemberPersistentId, but was %@.", [self tagName]];
  }
  return _duplicateMemberPersistentId;
}

- (NSString *)persistentIdDisabled {
  if (![self isPersistentIdDisabled]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMMemberAddResultPersistentIdDisabled, but was %@.", [self tagName]];
  }
  return _persistentIdDisabled;
}

- (NSString *)userCreationFailed {
  if (![self isUserCreationFailed]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMMemberAddResultUserCreationFailed, but was %@.", [self tagName]];
  }
  return _userCreationFailed;
}

#pragma mark - Tag state methods

- (BOOL)isSuccess {
  return _tag == DBTEAMMemberAddResultSuccess;
}

- (BOOL)isTeamLicenseLimit {
  return _tag == DBTEAMMemberAddResultTeamLicenseLimit;
}

- (BOOL)isFreeTeamMemberLimitReached {
  return _tag == DBTEAMMemberAddResultFreeTeamMemberLimitReached;
}

- (BOOL)isUserAlreadyOnTeam {
  return _tag == DBTEAMMemberAddResultUserAlreadyOnTeam;
}

- (BOOL)isUserOnAnotherTeam {
  return _tag == DBTEAMMemberAddResultUserOnAnotherTeam;
}

- (BOOL)isUserAlreadyPaired {
  return _tag == DBTEAMMemberAddResultUserAlreadyPaired;
}

- (BOOL)isUserMigrationFailed {
  return _tag == DBTEAMMemberAddResultUserMigrationFailed;
}

- (BOOL)isDuplicateExternalMemberId {
  return _tag == DBTEAMMemberAddResultDuplicateExternalMemberId;
}

- (BOOL)isDuplicateMemberPersistentId {
  return _tag == DBTEAMMemberAddResultDuplicateMemberPersistentId;
}

- (BOOL)isPersistentIdDisabled {
  return _tag == DBTEAMMemberAddResultPersistentIdDisabled;
}

- (BOOL)isUserCreationFailed {
  return _tag == DBTEAMMemberAddResultUserCreationFailed;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMMemberAddResultSuccess:
    return @"DBTEAMMemberAddResultSuccess";
  case DBTEAMMemberAddResultTeamLicenseLimit:
    return @"DBTEAMMemberAddResultTeamLicenseLimit";
  case DBTEAMMemberAddResultFreeTeamMemberLimitReached:
    return @"DBTEAMMemberAddResultFreeTeamMemberLimitReached";
  case DBTEAMMemberAddResultUserAlreadyOnTeam:
    return @"DBTEAMMemberAddResultUserAlreadyOnTeam";
  case DBTEAMMemberAddResultUserOnAnotherTeam:
    return @"DBTEAMMemberAddResultUserOnAnotherTeam";
  case DBTEAMMemberAddResultUserAlreadyPaired:
    return @"DBTEAMMemberAddResultUserAlreadyPaired";
  case DBTEAMMemberAddResultUserMigrationFailed:
    return @"DBTEAMMemberAddResultUserMigrationFailed";
  case DBTEAMMemberAddResultDuplicateExternalMemberId:
    return @"DBTEAMMemberAddResultDuplicateExternalMemberId";
  case DBTEAMMemberAddResultDuplicateMemberPersistentId:
    return @"DBTEAMMemberAddResultDuplicateMemberPersistentId";
  case DBTEAMMemberAddResultPersistentIdDisabled:
    return @"DBTEAMMemberAddResultPersistentIdDisabled";
  case DBTEAMMemberAddResultUserCreationFailed:
    return @"DBTEAMMemberAddResultUserCreationFailed";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMemberAddResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMemberAddResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMemberAddResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMMemberAddResultSuccess:
    result = prime * result + [self.success hash];
    break;
  case DBTEAMMemberAddResultTeamLicenseLimit:
    result = prime * result + [self.teamLicenseLimit hash];
    break;
  case DBTEAMMemberAddResultFreeTeamMemberLimitReached:
    result = prime * result + [self.freeTeamMemberLimitReached hash];
    break;
  case DBTEAMMemberAddResultUserAlreadyOnTeam:
    result = prime * result + [self.userAlreadyOnTeam hash];
    break;
  case DBTEAMMemberAddResultUserOnAnotherTeam:
    result = prime * result + [self.userOnAnotherTeam hash];
    break;
  case DBTEAMMemberAddResultUserAlreadyPaired:
    result = prime * result + [self.userAlreadyPaired hash];
    break;
  case DBTEAMMemberAddResultUserMigrationFailed:
    result = prime * result + [self.userMigrationFailed hash];
    break;
  case DBTEAMMemberAddResultDuplicateExternalMemberId:
    result = prime * result + [self.duplicateExternalMemberId hash];
    break;
  case DBTEAMMemberAddResultDuplicateMemberPersistentId:
    result = prime * result + [self.duplicateMemberPersistentId hash];
    break;
  case DBTEAMMemberAddResultPersistentIdDisabled:
    result = prime * result + [self.persistentIdDisabled hash];
    break;
  case DBTEAMMemberAddResultUserCreationFailed:
    result = prime * result + [self.userCreationFailed hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMemberAddResult:other];
}

- (BOOL)isEqualToMemberAddResult:(DBTEAMMemberAddResult *)aMemberAddResult {
  if (self == aMemberAddResult) {
    return YES;
  }
  if (self.tag != aMemberAddResult.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMMemberAddResultSuccess:
    return [self.success isEqual:aMemberAddResult.success];
  case DBTEAMMemberAddResultTeamLicenseLimit:
    return [self.teamLicenseLimit isEqual:aMemberAddResult.teamLicenseLimit];
  case DBTEAMMemberAddResultFreeTeamMemberLimitReached:
    return [self.freeTeamMemberLimitReached isEqual:aMemberAddResult.freeTeamMemberLimitReached];
  case DBTEAMMemberAddResultUserAlreadyOnTeam:
    return [self.userAlreadyOnTeam isEqual:aMemberAddResult.userAlreadyOnTeam];
  case DBTEAMMemberAddResultUserOnAnotherTeam:
    return [self.userOnAnotherTeam isEqual:aMemberAddResult.userOnAnotherTeam];
  case DBTEAMMemberAddResultUserAlreadyPaired:
    return [self.userAlreadyPaired isEqual:aMemberAddResult.userAlreadyPaired];
  case DBTEAMMemberAddResultUserMigrationFailed:
    return [self.userMigrationFailed isEqual:aMemberAddResult.userMigrationFailed];
  case DBTEAMMemberAddResultDuplicateExternalMemberId:
    return [self.duplicateExternalMemberId isEqual:aMemberAddResult.duplicateExternalMemberId];
  case DBTEAMMemberAddResultDuplicateMemberPersistentId:
    return [self.duplicateMemberPersistentId isEqual:aMemberAddResult.duplicateMemberPersistentId];
  case DBTEAMMemberAddResultPersistentIdDisabled:
    return [self.persistentIdDisabled isEqual:aMemberAddResult.persistentIdDisabled];
  case DBTEAMMemberAddResultUserCreationFailed:
    return [self.userCreationFailed isEqual:aMemberAddResult.userCreationFailed];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMemberAddResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMemberAddResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isSuccess]) {
    jsonDict = [[DBTEAMTeamMemberInfoSerializer serialize:valueObj.success] mutableCopy];
    jsonDict[@".tag"] = @"success";
  } else if ([valueObj isTeamLicenseLimit]) {
    jsonDict[@"team_license_limit"] = valueObj.teamLicenseLimit;
    jsonDict[@".tag"] = @"team_license_limit";
  } else if ([valueObj isFreeTeamMemberLimitReached]) {
    jsonDict[@"free_team_member_limit_reached"] = valueObj.freeTeamMemberLimitReached;
    jsonDict[@".tag"] = @"free_team_member_limit_reached";
  } else if ([valueObj isUserAlreadyOnTeam]) {
    jsonDict[@"user_already_on_team"] = valueObj.userAlreadyOnTeam;
    jsonDict[@".tag"] = @"user_already_on_team";
  } else if ([valueObj isUserOnAnotherTeam]) {
    jsonDict[@"user_on_another_team"] = valueObj.userOnAnotherTeam;
    jsonDict[@".tag"] = @"user_on_another_team";
  } else if ([valueObj isUserAlreadyPaired]) {
    jsonDict[@"user_already_paired"] = valueObj.userAlreadyPaired;
    jsonDict[@".tag"] = @"user_already_paired";
  } else if ([valueObj isUserMigrationFailed]) {
    jsonDict[@"user_migration_failed"] = valueObj.userMigrationFailed;
    jsonDict[@".tag"] = @"user_migration_failed";
  } else if ([valueObj isDuplicateExternalMemberId]) {
    jsonDict[@"duplicate_external_member_id"] = valueObj.duplicateExternalMemberId;
    jsonDict[@".tag"] = @"duplicate_external_member_id";
  } else if ([valueObj isDuplicateMemberPersistentId]) {
    jsonDict[@"duplicate_member_persistent_id"] = valueObj.duplicateMemberPersistentId;
    jsonDict[@".tag"] = @"duplicate_member_persistent_id";
  } else if ([valueObj isPersistentIdDisabled]) {
    jsonDict[@"persistent_id_disabled"] = valueObj.persistentIdDisabled;
    jsonDict[@".tag"] = @"persistent_id_disabled";
  } else if ([valueObj isUserCreationFailed]) {
    jsonDict[@"user_creation_failed"] = valueObj.userCreationFailed;
    jsonDict[@".tag"] = @"user_creation_failed";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMemberAddResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"success"]) {
    DBTEAMTeamMemberInfo *success = [DBTEAMTeamMemberInfoSerializer deserialize:valueDict];
    return [[DBTEAMMemberAddResult alloc] initWithSuccess:success];
  } else if ([tag isEqualToString:@"team_license_limit"]) {
    NSString *teamLicenseLimit = valueDict[@"team_license_limit"];
    return [[DBTEAMMemberAddResult alloc] initWithTeamLicenseLimit:teamLicenseLimit];
  } else if ([tag isEqualToString:@"free_team_member_limit_reached"]) {
    NSString *freeTeamMemberLimitReached = valueDict[@"free_team_member_limit_reached"];
    return [[DBTEAMMemberAddResult alloc] initWithFreeTeamMemberLimitReached:freeTeamMemberLimitReached];
  } else if ([tag isEqualToString:@"user_already_on_team"]) {
    NSString *userAlreadyOnTeam = valueDict[@"user_already_on_team"];
    return [[DBTEAMMemberAddResult alloc] initWithUserAlreadyOnTeam:userAlreadyOnTeam];
  } else if ([tag isEqualToString:@"user_on_another_team"]) {
    NSString *userOnAnotherTeam = valueDict[@"user_on_another_team"];
    return [[DBTEAMMemberAddResult alloc] initWithUserOnAnotherTeam:userOnAnotherTeam];
  } else if ([tag isEqualToString:@"user_already_paired"]) {
    NSString *userAlreadyPaired = valueDict[@"user_already_paired"];
    return [[DBTEAMMemberAddResult alloc] initWithUserAlreadyPaired:userAlreadyPaired];
  } else if ([tag isEqualToString:@"user_migration_failed"]) {
    NSString *userMigrationFailed = valueDict[@"user_migration_failed"];
    return [[DBTEAMMemberAddResult alloc] initWithUserMigrationFailed:userMigrationFailed];
  } else if ([tag isEqualToString:@"duplicate_external_member_id"]) {
    NSString *duplicateExternalMemberId = valueDict[@"duplicate_external_member_id"];
    return [[DBTEAMMemberAddResult alloc] initWithDuplicateExternalMemberId:duplicateExternalMemberId];
  } else if ([tag isEqualToString:@"duplicate_member_persistent_id"]) {
    NSString *duplicateMemberPersistentId = valueDict[@"duplicate_member_persistent_id"];
    return [[DBTEAMMemberAddResult alloc] initWithDuplicateMemberPersistentId:duplicateMemberPersistentId];
  } else if ([tag isEqualToString:@"persistent_id_disabled"]) {
    NSString *persistentIdDisabled = valueDict[@"persistent_id_disabled"];
    return [[DBTEAMMemberAddResult alloc] initWithPersistentIdDisabled:persistentIdDisabled];
  } else if ([tag isEqualToString:@"user_creation_failed"]) {
    NSString *userCreationFailed = valueDict[@"user_creation_failed"];
    return [[DBTEAMMemberAddResult alloc] initWithUserCreationFailed:userCreationFailed];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMActiveWebSession.h"
#import "DBTEAMDesktopClientSession.h"
#import "DBTEAMMemberDevices.h"
#import "DBTEAMMobileClientSession.h"

#pragma mark - API Object

@implementation DBTEAMMemberDevices

#pragma mark - Constructors

- (instancetype)initWithTeamMemberId:(NSString *)teamMemberId
                         webSessions:(NSArray<DBTEAMActiveWebSession *> *)webSessions
                      desktopClients:(NSArray<DBTEAMDesktopClientSession *> *)desktopClients
                       mobileClients:(NSArray<DBTEAMMobileClientSession *> *)mobileClients {
  [DBStoneValidators nonnullValidator:nil](teamMemberId);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](webSessions);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](desktopClients);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](mobileClients);

  self = [super init];
  if (self) {
    _teamMemberId = teamMemberId;
    _webSessions = webSessions;
    _desktopClients = desktopClients;
    _mobileClients = mobileClients;
  }
  return self;
}

- (instancetype)initWithTeamMemberId:(NSString *)teamMemberId {
  return [self initWithTeamMemberId:teamMemberId webSessions:nil desktopClients:nil mobileClients:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMemberDevicesSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMemberDevicesSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMemberDevicesSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.teamMemberId hash];
  if (self.webSessions != nil) {
    result = prime * result + [self.webSessions hash];
  }
  if (self.desktopClients != nil) {
    result = prime * result + [self.desktopClients hash];
  }
  if (self.mobileClients != nil) {
    result = prime * result + [self.mobileClients hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMemberDevices:other];
}

- (BOOL)isEqualToMemberDevices:(DBTEAMMemberDevices *)aMemberDevices {
  if (self == aMemberDevices) {
    return YES;
  }
  if (![self.teamMemberId isEqual:aMemberDevices.teamMemberId]) {
    return NO;
  }
  if (self.webSessions) {
    if (![self.webSessions isEqual:aMemberDevices.webSessions]) {
      return NO;
    }
  }
  if (self.desktopClients) {
    if (![self.desktopClients isEqual:aMemberDevices.desktopClients]) {
      return NO;
    }
  }
  if (self.mobileClients) {
    if (![self.mobileClients isEqual:aMemberDevices.mobileClients]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMemberDevicesSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMemberDevices *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"team_member_id"] = valueObj.teamMemberId;
  if (valueObj.webSessions) {
    jsonDict[@"web_sessions"] = [DBArraySerializer serialize:valueObj.webSessions
                                                   withBlock:^id(id elem0) {
                                                     return [DBTEAMActiveWebSessionSerializer serialize:elem0];
                                                   }];
  }
  if (valueObj.desktopClients) {
    jsonDict[@"desktop_clients"] = [DBArraySerializer serialize:valueObj.desktopClients
                                                      withBlock:^id(id elem0) {
                                                        return [DBTEAMDesktopClientSessionSerializer serialize:elem0];
                                                      }];
  }
  if (valueObj.mobileClients) {
    jsonDict[@"mobile_clients"] = [DBArraySerializer serialize:valueObj.mobileClients
                                                     withBlock:^id(id elem0) {
                                                       return [DBTEAMMobileClientSessionSerializer serialize:elem0];
                                                     }];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMemberDevices *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *teamMemberId = valueDict[@"team_member_id"];
  NSArray<DBTEAMActiveWebSession *> *webSessions =
      valueDict[@"web_sessions"] ? [DBArraySerializer deserialize:valueDict[@"web_sessions"]
                                                        withBlock:^id(id elem0) {
                                                          return [DBTEAMActiveWebSessionSerializer deserialize:elem0];
                                                        }]
                                 : nil;
  NSArray<DBTEAMDesktopClientSession *> *desktopClients =
      valueDict[@"desktop_clients"]
          ? [DBArraySerializer deserialize:valueDict[@"desktop_clients"]
                                 withBlock:^id(id elem0) {
                                   return [DBTEAMDesktopClientSessionSerializer deserialize:elem0];
                                 }]
          : nil;
  NSArray<DBTEAMMobileClientSession *> *mobileClients =
      valueDict[@"mobile_clients"]
          ? [DBArraySerializer deserialize:valueDict[@"mobile_clients"]
                                 withBlock:^id(id elem0) {
                                   return [DBTEAMMobileClientSessionSerializer deserialize:elem0];
                                 }]
          : nil;

  return [[DBTEAMMemberDevices alloc] initWithTeamMemberId:teamMemberId
                                               webSessions:webSessions
                                            desktopClients:desktopClients
                                             mobileClients:mobileClients];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMApiApp.h"
#import "DBTEAMMemberLinkedApps.h"

#pragma mark - API Object

@implementation DBTEAMMemberLinkedApps

#pragma mark - Constructors

- (instancetype)initWithTeamMemberId:(NSString *)teamMemberId linkedApiApps:(NSArray<DBTEAMApiApp *> *)linkedApiApps {
  [DBStoneValidators nonnullValidator:nil](teamMemberId);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](linkedApiApps);

  self = [super init];
  if (self) {
    _teamMemberId = teamMemberId;
    _linkedApiApps = linkedApiApps;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMemberLinkedAppsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMemberLinkedAppsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMemberLinkedAppsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.teamMemberId hash];
  result = prime * result + [self.linkedApiApps hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMemberLinkedApps:other];
}

- (BOOL)isEqualToMemberLinkedApps:(DBTEAMMemberLinkedApps *)aMemberLinkedApps {
  if (self == aMemberLinkedApps) {
    return YES;
  }
  if (![self.teamMemberId isEqual:aMemberLinkedApps.teamMemberId]) {
    return NO;
  }
  if (![self.linkedApiApps isEqual:aMemberLinkedApps.linkedApiApps]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMemberLinkedAppsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMemberLinkedApps *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"team_member_id"] = valueObj.teamMemberId;
  jsonDict[@"linked_api_apps"] = [DBArraySerializer serialize:valueObj.linkedApiApps
                                                    withBlock:^id(id elem0) {
                                                      return [DBTEAMApiAppSerializer serialize:elem0];
                                                    }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMemberLinkedApps *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *teamMemberId = valueDict[@"team_member_id"];
  NSArray<DBTEAMApiApp *> *linkedApiApps = [DBArraySerializer deserialize:valueDict[@"linked_api_apps"]
                                                                withBlock:^id(id elem0) {
                                                                  return [DBTEAMApiAppSerializer deserialize:elem0];
                                                                }];

  return [[DBTEAMMemberLinkedApps alloc] initWithTeamMemberId:teamMemberId linkedApiApps:linkedApiApps];
}

@end

#import "DBSECONDARYEMAILSSecondaryEmail.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMemberProfile.h"
#import "DBTEAMTeamMemberStatus.h"
#import "DBTEAMTeamMembershipType.h"
#import "DBUSERSName.h"

#pragma mark - API Object

@implementation DBTEAMMemberProfile

#pragma mark - Constructors

- (instancetype)initWithTeamMemberId:(NSString *)teamMemberId
                               email:(NSString *)email
                       emailVerified:(NSNumber *)emailVerified
                              status:(DBTEAMTeamMemberStatus *)status
                                name:(DBUSERSName *)name
                      membershipType:(DBTEAMTeamMembershipType *)membershipType
                          externalId:(NSString *)externalId
                           accountId:(NSString *)accountId
                     secondaryEmails:(NSArray<DBSECONDARYEMAILSSecondaryEmail *> *)secondaryEmails
                           invitedOn:(NSDate *)invitedOn
                            joinedOn:(NSDate *)joinedOn
                         suspendedOn:(NSDate *)suspendedOn
                        persistentId:(NSString *)persistentId
               isDirectoryRestricted:(NSNumber *)isDirectoryRestricted
                     profilePhotoUrl:(NSString *)profilePhotoUrl {
  [DBStoneValidators nonnullValidator:nil](teamMemberId);
  [DBStoneValidators nonnullValidator:nil](email);
  [DBStoneValidators nonnullValidator:nil](emailVerified);
  [DBStoneValidators nonnullValidator:nil](status);
  [DBStoneValidators nonnullValidator:nil](name);
  [DBStoneValidators nonnullValidator:nil](membershipType);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators stringValidator:@(40) maxLength:@(40) pattern:nil]](accountId);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](secondaryEmails);

  self = [super init];
  if (self) {
    _teamMemberId = teamMemberId;
    _externalId = externalId;
    _accountId = accountId;
    _email = email;
    _emailVerified = emailVerified;
    _secondaryEmails = secondaryEmails;
    _status = status;
    _name = name;
    _membershipType = membershipType;
    _invitedOn = invitedOn;
    _joinedOn = joinedOn;
    _suspendedOn = suspendedOn;
    _persistentId = persistentId;
    _isDirectoryRestricted = isDirectoryRestricted;
    _profilePhotoUrl = profilePhotoUrl;
  }
  return self;
}

- (instancetype)initWithTeamMemberId:(NSString *)teamMemberId
                               email:(NSString *)email
                       emailVerified:(NSNumber *)emailVerified
                              status:(DBTEAMTeamMemberStatus *)status
                                name:(DBUSERSName *)name
                      membershipType:(DBTEAMTeamMembershipType *)membershipType {
  return [self initWithTeamMemberId:teamMemberId
                              email:email
                      emailVerified:emailVerified
                             status:status
                               name:name
                     membershipType:membershipType
                         externalId:nil
                          accountId:nil
                    secondaryEmails:nil
                          invitedOn:nil
                           joinedOn:nil
                        suspendedOn:nil
                       persistentId:nil
              isDirectoryRestricted:nil
                    profilePhotoUrl:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMemberProfileSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMemberProfileSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMemberProfileSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.teamMemberId hash];
  result = prime * result + [self.email hash];
  result = prime * result + [self.emailVerified hash];
  result = prime * result + [self.status hash];
  result = prime * result + [self.name hash];
  result = prime * result + [self.membershipType hash];
  if (self.externalId != nil) {
    result = prime * result + [self.externalId hash];
  }
  if (self.accountId != nil) {
    result = prime * result + [self.accountId hash];
  }
  if (self.secondaryEmails != nil) {
    result = prime * result + [self.secondaryEmails hash];
  }
  if (self.invitedOn != nil) {
    result = prime * result + [self.invitedOn hash];
  }
  if (self.joinedOn != nil) {
    result = prime * result + [self.joinedOn hash];
  }
  if (self.suspendedOn != nil) {
    result = prime * result + [self.suspendedOn hash];
  }
  if (self.persistentId != nil) {
    result = prime * result + [self.persistentId hash];
  }
  if (self.isDirectoryRestricted != nil) {
    result = prime * result + [self.isDirectoryRestricted hash];
  }
  if (self.profilePhotoUrl != nil) {
    result = prime * result + [self.profilePhotoUrl hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMemberProfile:other];
}

- (BOOL)isEqualToMemberProfile:(DBTEAMMemberProfile *)aMemberProfile {
  if (self == aMemberProfile) {
    return YES;
  }
  if (![self.teamMemberId isEqual:aMemberProfile.teamMemberId]) {
    return NO;
  }
  if (![self.email isEqual:aMemberProfile.email]) {
    return NO;
  }
  if (![self.emailVerified isEqual:aMemberProfile.emailVerified]) {
    return NO;
  }
  if (![self.status isEqual:aMemberProfile.status]) {
    return NO;
  }
  if (![self.name isEqual:aMemberProfile.name]) {
    return NO;
  }
  if (![self.membershipType isEqual:aMemberProfile.membershipType]) {
    return NO;
  }
  if (self.externalId) {
    if (![self.externalId isEqual:aMemberProfile.externalId]) {
      return NO;
    }
  }
  if (self.accountId) {
    if (![self.accountId isEqual:aMemberProfile.accountId]) {
      return NO;
    }
  }
  if (self.secondaryEmails) {
    if (![self.secondaryEmails isEqual:aMemberProfile.secondaryEmails]) {
      return NO;
    }
  }
  if (self.invitedOn) {
    if (![self.invitedOn isEqual:aMemberProfile.invitedOn]) {
      return NO;
    }
  }
  if (self.joinedOn) {
    if (![self.joinedOn isEqual:aMemberProfile.joinedOn]) {
      return NO;
    }
  }
  if (self.suspendedOn) {
    if (![self.suspendedOn isEqual:aMemberProfile.suspendedOn]) {
      return NO;
    }
  }
  if (self.persistentId) {
    if (![self.persistentId isEqual:aMemberProfile.persistentId]) {
      return NO;
    }
  }
  if (self.isDirectoryRestricted) {
    if (![self.isDirectoryRestricted isEqual:aMemberProfile.isDirectoryRestricted]) {
      return NO;
    }
  }
  if (self.profilePhotoUrl) {
    if (![self.profilePhotoUrl isEqual:aMemberProfile.profilePhotoUrl]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMemberProfileSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMemberProfile *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"team_member_id"] = valueObj.teamMemberId;
  jsonDict[@"email"] = valueObj.email;
  jsonDict[@"email_verified"] = valueObj.emailVerified;
  jsonDict[@"status"] = [DBTEAMTeamMemberStatusSerializer serialize:valueObj.status];
  jsonDict[@"name"] = [DBUSERSNameSerializer serialize:valueObj.name];
  jsonDict[@"membership_type"] = [DBTEAMTeamMembershipTypeSerializer serialize:valueObj.membershipType];
  if (valueObj.externalId) {
    jsonDict[@"external_id"] = valueObj.externalId;
  }
  if (valueObj.accountId) {
    jsonDict[@"account_id"] = valueObj.accountId;
  }
  if (valueObj.secondaryEmails) {
    jsonDict[@"secondary_emails"] =
        [DBArraySerializer serialize:valueObj.secondaryEmails
                           withBlock:^id(id elem0) {
                             return [DBSECONDARYEMAILSSecondaryEmailSerializer serialize:elem0];
                           }];
  }
  if (valueObj.invitedOn) {
    jsonDict[@"invited_on"] = [DBNSDateSerializer serialize:valueObj.invitedOn dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }
  if (valueObj.joinedOn) {
    jsonDict[@"joined_on"] = [DBNSDateSerializer serialize:valueObj.joinedOn dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }
  if (valueObj.suspendedOn) {
    jsonDict[@"suspended_on"] = [DBNSDateSerializer serialize:valueObj.suspendedOn dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }
  if (valueObj.persistentId) {
    jsonDict[@"persistent_id"] = valueObj.persistentId;
  }
  if (valueObj.isDirectoryRestricted) {
    jsonDict[@"is_directory_restricted"] = valueObj.isDirectoryRestricted;
  }
  if (valueObj.profilePhotoUrl) {
    jsonDict[@"profile_photo_url"] = valueObj.profilePhotoUrl;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMemberProfile *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *teamMemberId = valueDict[@"team_member_id"];
  NSString *email = valueDict[@"email"];
  NSNumber *emailVerified = valueDict[@"email_verified"];
  DBTEAMTeamMemberStatus *status = [DBTEAMTeamMemberStatusSerializer deserialize:valueDict[@"status"]];
  DBUSERSName *name = [DBUSERSNameSerializer deserialize:valueDict[@"name"]];
  DBTEAMTeamMembershipType *membershipType =
      [DBTEAMTeamMembershipTypeSerializer deserialize:valueDict[@"membership_type"]];
  NSString *externalId = valueDict[@"external_id"] ?: nil;
  NSString *accountId = valueDict[@"account_id"] ?: nil;
  NSArray<DBSECONDARYEMAILSSecondaryEmail *> *secondaryEmails =
      valueDict[@"secondary_emails"]
          ? [DBArraySerializer deserialize:valueDict[@"secondary_emails"]
                                 withBlock:^id(id elem0) {
                                   return [DBSECONDARYEMAILSSecondaryEmailSerializer deserialize:elem0];
                                 }]
          : nil;
  NSDate *invitedOn = valueDict[@"invited_on"]
                          ? [DBNSDateSerializer deserialize:valueDict[@"invited_on"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                          : nil;
  NSDate *joinedOn = valueDict[@"joined_on"]
                         ? [DBNSDateSerializer deserialize:valueDict[@"joined_on"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                         : nil;
  NSDate *suspendedOn = valueDict[@"suspended_on"] ? [DBNSDateSerializer deserialize:valueDict[@"suspended_on"]
                                                                          dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                                                   : nil;
  NSString *persistentId = valueDict[@"persistent_id"] ?: nil;
  NSNumber *isDirectoryRestricted = valueDict[@"is_directory_restricted"] ?: nil;
  NSString *profilePhotoUrl = valueDict[@"profile_photo_url"] ?: nil;

  return [[DBTEAMMemberProfile alloc] initWithTeamMemberId:teamMemberId
                                                     email:email
                                             emailVerified:emailVerified
                                                    status:status
                                                      name:name
                                            membershipType:membershipType
                                                externalId:externalId
                                                 accountId:accountId
                                           secondaryEmails:secondaryEmails
                                                 invitedOn:invitedOn
                                                  joinedOn:joinedOn
                                               suspendedOn:suspendedOn
                                              persistentId:persistentId
                                     isDirectoryRestricted:isDirectoryRestricted
                                           profilePhotoUrl:profilePhotoUrl];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMUserSelectorError.h"

#pragma mark - API Object

@implementation DBTEAMUserSelectorError

#pragma mark - Constructors

- (instancetype)initWithUserNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMUserSelectorErrorUserNotFound;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isUserNotFound {
  return _tag == DBTEAMUserSelectorErrorUserNotFound;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMUserSelectorErrorUserNotFound:
    return @"DBTEAMUserSelectorErrorUserNotFound";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMUserSelectorErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMUserSelectorErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMUserSelectorErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMUserSelectorErrorUserNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUserSelectorError:other];
}

- (BOOL)isEqualToUserSelectorError:(DBTEAMUserSelectorError *)anUserSelectorError {
  if (self == anUserSelectorError) {
    return YES;
  }
  if (self.tag != anUserSelectorError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMUserSelectorErrorUserNotFound:
    return [[self tagName] isEqual:[anUserSelectorError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMUserSelectorErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMUserSelectorError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUserNotFound]) {
    jsonDict[@".tag"] = @"user_not_found";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMUserSelectorError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"user_not_found"]) {
    return [[DBTEAMUserSelectorError alloc] initWithUserNotFound];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMemberSelectorError.h"
#import "DBTEAMUserSelectorError.h"

#pragma mark - API Object

@implementation DBTEAMMemberSelectorError

#pragma mark - Constructors

- (instancetype)initWithUserNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMMemberSelectorErrorUserNotFound;
  }
  return self;
}

- (instancetype)initWithUserNotInTeam {
  self = [super init];
  if (self) {
    _tag = DBTEAMMemberSelectorErrorUserNotInTeam;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isUserNotFound {
  return _tag == DBTEAMMemberSelectorErrorUserNotFound;
}

- (BOOL)isUserNotInTeam {
  return _tag == DBTEAMMemberSelectorErrorUserNotInTeam;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMMemberSelectorErrorUserNotFound:
    return @"DBTEAMMemberSelectorErrorUserNotFound";
  case DBTEAMMemberSelectorErrorUserNotInTeam:
    return @"DBTEAMMemberSelectorErrorUserNotInTeam";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMemberSelectorErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMemberSelectorErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMemberSelectorErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMMemberSelectorErrorUserNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMemberSelectorErrorUserNotInTeam:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMemberSelectorError:other];
}

- (BOOL)isEqualToMemberSelectorError:(DBTEAMMemberSelectorError *)aMemberSelectorError {
  if (self == aMemberSelectorError) {
    return YES;
  }
  if (self.tag != aMemberSelectorError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMMemberSelectorErrorUserNotFound:
    return [[self tagName] isEqual:[aMemberSelectorError tagName]];
  case DBTEAMMemberSelectorErrorUserNotInTeam:
    return [[self tagName] isEqual:[aMemberSelectorError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMemberSelectorErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMemberSelectorError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUserNotFound]) {
    jsonDict[@".tag"] = @"user_not_found";
  } else if ([valueObj isUserNotInTeam]) {
    jsonDict[@".tag"] = @"user_not_in_team";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMemberSelectorError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"user_not_found"]) {
    return [[DBTEAMMemberSelectorError alloc] initWithUserNotFound];
  } else if ([tag isEqualToString:@"user_not_in_team"]) {
    return [[DBTEAMMemberSelectorError alloc] initWithUserNotInTeam];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMemberAddArg.h"
#import "DBTEAMMembersAddArg.h"

#pragma mark - API Object

@implementation DBTEAMMembersAddArg

#pragma mark - Constructors

- (instancetype)initWithDNewMembers:(NSArray<DBTEAMMemberAddArg *> *)dNewMembers forceAsync:(NSNumber *)forceAsync {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](dNewMembers);

  self = [super init];
  if (self) {
    _dNewMembers = dNewMembers;
    _forceAsync = forceAsync ?: @NO;
  }
  return self;
}

- (instancetype)initWithDNewMembers:(NSArray<DBTEAMMemberAddArg *> *)dNewMembers {
  return [self initWithDNewMembers:dNewMembers forceAsync:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersAddArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersAddArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersAddArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.dNewMembers hash];
  result = prime * result + [self.forceAsync hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersAddArg:other];
}

- (BOOL)isEqualToMembersAddArg:(DBTEAMMembersAddArg *)aMembersAddArg {
  if (self == aMembersAddArg) {
    return YES;
  }
  if (![self.dNewMembers isEqual:aMembersAddArg.dNewMembers]) {
    return NO;
  }
  if (![self.forceAsync isEqual:aMembersAddArg.forceAsync]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersAddArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersAddArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"new_members"] = [DBArraySerializer serialize:valueObj.dNewMembers
                                                withBlock:^id(id elem0) {
                                                  return [DBTEAMMemberAddArgSerializer serialize:elem0];
                                                }];
  jsonDict[@"force_async"] = valueObj.forceAsync;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersAddArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBTEAMMemberAddArg *> *dNewMembers =
      [DBArraySerializer deserialize:valueDict[@"new_members"]
                           withBlock:^id(id elem0) {
                             return [DBTEAMMemberAddArgSerializer deserialize:elem0];
                           }];
  NSNumber *forceAsync = valueDict[@"force_async"] ?: @NO;

  return [[DBTEAMMembersAddArg alloc] initWithDNewMembers:dNewMembers forceAsync:forceAsync];
}

@end

#import "DBASYNCPollResultBase.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMemberAddResult.h"
#import "DBTEAMMembersAddJobStatus.h"

#pragma mark - API Object

@implementation DBTEAMMembersAddJobStatus

@synthesize complete = _complete;
@synthesize failed = _failed;

#pragma mark - Constructors

- (instancetype)initWithInProgress {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersAddJobStatusInProgress;
  }
  return self;
}

- (instancetype)initWithComplete:(NSArray<DBTEAMMemberAddResult *> *)complete {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersAddJobStatusComplete;
    _complete = complete;
  }
  return self;
}

- (instancetype)initWithFailed:(NSString *)failed {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersAddJobStatusFailed;
    _failed = failed;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSArray<DBTEAMMemberAddResult *> *)complete {
  if (![self isComplete]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMMembersAddJobStatusComplete, but was %@.", [self tagName]];
  }
  return _complete;
}

- (NSString *)failed {
  if (![self isFailed]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMMembersAddJobStatusFailed, but was %@.", [self tagName]];
  }
  return _failed;
}

#pragma mark - Tag state methods

- (BOOL)isInProgress {
  return _tag == DBTEAMMembersAddJobStatusInProgress;
}

- (BOOL)isComplete {
  return _tag == DBTEAMMembersAddJobStatusComplete;
}

- (BOOL)isFailed {
  return _tag == DBTEAMMembersAddJobStatusFailed;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMMembersAddJobStatusInProgress:
    return @"DBTEAMMembersAddJobStatusInProgress";
  case DBTEAMMembersAddJobStatusComplete:
    return @"DBTEAMMembersAddJobStatusComplete";
  case DBTEAMMembersAddJobStatusFailed:
    return @"DBTEAMMembersAddJobStatusFailed";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersAddJobStatusSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersAddJobStatusSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersAddJobStatusSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMMembersAddJobStatusInProgress:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersAddJobStatusComplete:
    result = prime * result + [self.complete hash];
    break;
  case DBTEAMMembersAddJobStatusFailed:
    result = prime * result + [self.failed hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersAddJobStatus:other];
}

- (BOOL)isEqualToMembersAddJobStatus:(DBTEAMMembersAddJobStatus *)aMembersAddJobStatus {
  if (self == aMembersAddJobStatus) {
    return YES;
  }
  if (self.tag != aMembersAddJobStatus.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMMembersAddJobStatusInProgress:
    return [[self tagName] isEqual:[aMembersAddJobStatus tagName]];
  case DBTEAMMembersAddJobStatusComplete:
    return [self.complete isEqual:aMembersAddJobStatus.complete];
  case DBTEAMMembersAddJobStatusFailed:
    return [self.failed isEqual:aMembersAddJobStatus.failed];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersAddJobStatusSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersAddJobStatus *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isInProgress]) {
    jsonDict[@".tag"] = @"in_progress";
  } else if ([valueObj isComplete]) {
    jsonDict[@"complete"] = [DBArraySerializer serialize:valueObj.complete
                                               withBlock:^id(id elem0) {
                                                 return [DBTEAMMemberAddResultSerializer serialize:elem0];
                                               }];
    jsonDict[@".tag"] = @"complete";
  } else if ([valueObj isFailed]) {
    jsonDict[@"failed"] = valueObj.failed;
    jsonDict[@".tag"] = @"failed";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersAddJobStatus *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"in_progress"]) {
    return [[DBTEAMMembersAddJobStatus alloc] initWithInProgress];
  } else if ([tag isEqualToString:@"complete"]) {
    NSArray<DBTEAMMemberAddResult *> *complete =
        [DBArraySerializer deserialize:valueDict[@"complete"]
                             withBlock:^id(id elem0) {
                               return [DBTEAMMemberAddResultSerializer deserialize:elem0];
                             }];
    return [[DBTEAMMembersAddJobStatus alloc] initWithComplete:complete];
  } else if ([tag isEqualToString:@"failed"]) {
    NSString *failed = valueDict[@"failed"];
    return [[DBTEAMMembersAddJobStatus alloc] initWithFailed:failed];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBASYNCLaunchResultBase.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMemberAddResult.h"
#import "DBTEAMMembersAddLaunch.h"

#pragma mark - API Object

@implementation DBTEAMMembersAddLaunch

@synthesize asyncJobId = _asyncJobId;
@synthesize complete = _complete;

#pragma mark - Constructors

- (instancetype)initWithAsyncJobId:(NSString *)asyncJobId {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersAddLaunchAsyncJobId;
    _asyncJobId = asyncJobId;
  }
  return self;
}

- (instancetype)initWithComplete:(NSArray<DBTEAMMemberAddResult *> *)complete {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersAddLaunchComplete;
    _complete = complete;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSString *)asyncJobId {
  if (![self isAsyncJobId]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMMembersAddLaunchAsyncJobId, but was %@.", [self tagName]];
  }
  return _asyncJobId;
}

- (NSArray<DBTEAMMemberAddResult *> *)complete {
  if (![self isComplete]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMMembersAddLaunchComplete, but was %@.", [self tagName]];
  }
  return _complete;
}

#pragma mark - Tag state methods

- (BOOL)isAsyncJobId {
  return _tag == DBTEAMMembersAddLaunchAsyncJobId;
}

- (BOOL)isComplete {
  return _tag == DBTEAMMembersAddLaunchComplete;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMMembersAddLaunchAsyncJobId:
    return @"DBTEAMMembersAddLaunchAsyncJobId";
  case DBTEAMMembersAddLaunchComplete:
    return @"DBTEAMMembersAddLaunchComplete";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersAddLaunchSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersAddLaunchSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersAddLaunchSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMMembersAddLaunchAsyncJobId:
    result = prime * result + [self.asyncJobId hash];
    break;
  case DBTEAMMembersAddLaunchComplete:
    result = prime * result + [self.complete hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersAddLaunch:other];
}

- (BOOL)isEqualToMembersAddLaunch:(DBTEAMMembersAddLaunch *)aMembersAddLaunch {
  if (self == aMembersAddLaunch) {
    return YES;
  }
  if (self.tag != aMembersAddLaunch.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMMembersAddLaunchAsyncJobId:
    return [self.asyncJobId isEqual:aMembersAddLaunch.asyncJobId];
  case DBTEAMMembersAddLaunchComplete:
    return [self.complete isEqual:aMembersAddLaunch.complete];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersAddLaunchSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersAddLaunch *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAsyncJobId]) {
    jsonDict[@"async_job_id"] = valueObj.asyncJobId;
    jsonDict[@".tag"] = @"async_job_id";
  } else if ([valueObj isComplete]) {
    jsonDict[@"complete"] = [DBArraySerializer serialize:valueObj.complete
                                               withBlock:^id(id elem0) {
                                                 return [DBTEAMMemberAddResultSerializer serialize:elem0];
                                               }];
    jsonDict[@".tag"] = @"complete";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersAddLaunch *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"async_job_id"]) {
    NSString *asyncJobId = valueDict[@"async_job_id"];
    return [[DBTEAMMembersAddLaunch alloc] initWithAsyncJobId:asyncJobId];
  } else if ([tag isEqualToString:@"complete"]) {
    NSArray<DBTEAMMemberAddResult *> *complete =
        [DBArraySerializer deserialize:valueDict[@"complete"]
                             withBlock:^id(id elem0) {
                               return [DBTEAMMemberAddResultSerializer deserialize:elem0];
                             }];
    return [[DBTEAMMembersAddLaunch alloc] initWithComplete:complete];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMembersDeactivateBaseArg.h"
#import "DBTEAMUserSelectorArg.h"

#pragma mark - API Object

@implementation DBTEAMMembersDeactivateBaseArg

#pragma mark - Constructors

- (instancetype)initWithUser:(DBTEAMUserSelectorArg *)user {
  [DBStoneValidators nonnullValidator:nil](user);

  self = [super init];
  if (self) {
    _user = user;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersDeactivateBaseArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersDeactivateBaseArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersDeactivateBaseArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.user hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersDeactivateBaseArg:other];
}

- (BOOL)isEqualToMembersDeactivateBaseArg:(DBTEAMMembersDeactivateBaseArg *)aMembersDeactivateBaseArg {
  if (self == aMembersDeactivateBaseArg) {
    return YES;
  }
  if (![self.user isEqual:aMembersDeactivateBaseArg.user]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersDeactivateBaseArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersDeactivateBaseArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"user"] = [DBTEAMUserSelectorArgSerializer serialize:valueObj.user];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersDeactivateBaseArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMUserSelectorArg *user = [DBTEAMUserSelectorArgSerializer deserialize:valueDict[@"user"]];

  return [[DBTEAMMembersDeactivateBaseArg alloc] initWithUser:user];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMembersDataTransferArg.h"
#import "DBTEAMMembersDeactivateBaseArg.h"
#import "DBTEAMUserSelectorArg.h"

#pragma mark - API Object

@implementation DBTEAMMembersDataTransferArg

#pragma mark - Constructors

- (instancetype)initWithUser:(DBTEAMUserSelectorArg *)user
              transferDestId:(DBTEAMUserSelectorArg *)transferDestId
             transferAdminId:(DBTEAMUserSelectorArg *)transferAdminId {
  [DBStoneValidators nonnullValidator:nil](user);
  [DBStoneValidators nonnullValidator:nil](transferDestId);
  [DBStoneValidators nonnullValidator:nil](transferAdminId);

  self = [super initWithUser:user];
  if (self) {
    _transferDestId = transferDestId;
    _transferAdminId = transferAdminId;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersDataTransferArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersDataTransferArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersDataTransferArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.user hash];
  result = prime * result + [self.transferDestId hash];
  result = prime * result + [self.transferAdminId hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersDataTransferArg:other];
}

- (BOOL)isEqualToMembersDataTransferArg:(DBTEAMMembersDataTransferArg *)aMembersDataTransferArg {
  if (self == aMembersDataTransferArg) {
    return YES;
  }
  if (![self.user isEqual:aMembersDataTransferArg.user]) {
    return NO;
  }
  if (![self.transferDestId isEqual:aMembersDataTransferArg.transferDestId]) {
    return NO;
  }
  if (![self.transferAdminId isEqual:aMembersDataTransferArg.transferAdminId]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersDataTransferArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersDataTransferArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"user"] = [DBTEAMUserSelectorArgSerializer serialize:valueObj.user];
  jsonDict[@"transfer_dest_id"] = [DBTEAMUserSelectorArgSerializer serialize:valueObj.transferDestId];
  jsonDict[@"transfer_admin_id"] = [DBTEAMUserSelectorArgSerializer serialize:valueObj.transferAdminId];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersDataTransferArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMUserSelectorArg *user = [DBTEAMUserSelectorArgSerializer deserialize:valueDict[@"user"]];
  DBTEAMUserSelectorArg *transferDestId = [DBTEAMUserSelectorArgSerializer deserialize:valueDict[@"transfer_dest_id"]];
  DBTEAMUserSelectorArg *transferAdminId =
      [DBTEAMUserSelectorArgSerializer deserialize:valueDict[@"transfer_admin_id"]];

  return [[DBTEAMMembersDataTransferArg alloc] initWithUser:user
                                             transferDestId:transferDestId
                                            transferAdminId:transferAdminId];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMembersDeactivateArg.h"
#import "DBTEAMMembersDeactivateBaseArg.h"
#import "DBTEAMUserSelectorArg.h"

#pragma mark - API Object

@implementation DBTEAMMembersDeactivateArg

#pragma mark - Constructors

- (instancetype)initWithUser:(DBTEAMUserSelectorArg *)user wipeData:(NSNumber *)wipeData {
  [DBStoneValidators nonnullValidator:nil](user);

  self = [super initWithUser:user];
  if (self) {
    _wipeData = wipeData ?: @YES;
  }
  return self;
}

- (instancetype)initWithUser:(DBTEAMUserSelectorArg *)user {
  return [self initWithUser:user wipeData:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersDeactivateArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersDeactivateArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersDeactivateArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.user hash];
  result = prime * result + [self.wipeData hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersDeactivateArg:other];
}

- (BOOL)isEqualToMembersDeactivateArg:(DBTEAMMembersDeactivateArg *)aMembersDeactivateArg {
  if (self == aMembersDeactivateArg) {
    return YES;
  }
  if (![self.user isEqual:aMembersDeactivateArg.user]) {
    return NO;
  }
  if (![self.wipeData isEqual:aMembersDeactivateArg.wipeData]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersDeactivateArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersDeactivateArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"user"] = [DBTEAMUserSelectorArgSerializer serialize:valueObj.user];
  jsonDict[@"wipe_data"] = valueObj.wipeData;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersDeactivateArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMUserSelectorArg *user = [DBTEAMUserSelectorArgSerializer deserialize:valueDict[@"user"]];
  NSNumber *wipeData = valueDict[@"wipe_data"] ?: @YES;

  return [[DBTEAMMembersDeactivateArg alloc] initWithUser:user wipeData:wipeData];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMembersDeactivateError.h"
#import "DBTEAMUserSelectorError.h"

#pragma mark - API Object

@implementation DBTEAMMembersDeactivateError

#pragma mark - Constructors

- (instancetype)initWithUserNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersDeactivateErrorUserNotFound;
  }
  return self;
}

- (instancetype)initWithUserNotInTeam {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersDeactivateErrorUserNotInTeam;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersDeactivateErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isUserNotFound {
  return _tag == DBTEAMMembersDeactivateErrorUserNotFound;
}

- (BOOL)isUserNotInTeam {
  return _tag == DBTEAMMembersDeactivateErrorUserNotInTeam;
}

- (BOOL)isOther {
  return _tag == DBTEAMMembersDeactivateErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMMembersDeactivateErrorUserNotFound:
    return @"DBTEAMMembersDeactivateErrorUserNotFound";
  case DBTEAMMembersDeactivateErrorUserNotInTeam:
    return @"DBTEAMMembersDeactivateErrorUserNotInTeam";
  case DBTEAMMembersDeactivateErrorOther:
    return @"DBTEAMMembersDeactivateErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersDeactivateErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersDeactivateErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersDeactivateErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMMembersDeactivateErrorUserNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersDeactivateErrorUserNotInTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersDeactivateErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersDeactivateError:other];
}

- (BOOL)isEqualToMembersDeactivateError:(DBTEAMMembersDeactivateError *)aMembersDeactivateError {
  if (self == aMembersDeactivateError) {
    return YES;
  }
  if (self.tag != aMembersDeactivateError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMMembersDeactivateErrorUserNotFound:
    return [[self tagName] isEqual:[aMembersDeactivateError tagName]];
  case DBTEAMMembersDeactivateErrorUserNotInTeam:
    return [[self tagName] isEqual:[aMembersDeactivateError tagName]];
  case DBTEAMMembersDeactivateErrorOther:
    return [[self tagName] isEqual:[aMembersDeactivateError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersDeactivateErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersDeactivateError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUserNotFound]) {
    jsonDict[@".tag"] = @"user_not_found";
  } else if ([valueObj isUserNotInTeam]) {
    jsonDict[@".tag"] = @"user_not_in_team";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersDeactivateError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"user_not_found"]) {
    return [[DBTEAMMembersDeactivateError alloc] initWithUserNotFound];
  } else if ([tag isEqualToString:@"user_not_in_team"]) {
    return [[DBTEAMMembersDeactivateError alloc] initWithUserNotInTeam];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMMembersDeactivateError alloc] initWithOther];
  } else {
    return [[DBTEAMMembersDeactivateError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMembersDeleteProfilePhotoArg.h"
#import "DBTEAMUserSelectorArg.h"

#pragma mark - API Object

@implementation DBTEAMMembersDeleteProfilePhotoArg

#pragma mark - Constructors

- (instancetype)initWithUser:(DBTEAMUserSelectorArg *)user {
  [DBStoneValidators nonnullValidator:nil](user);

  self = [super init];
  if (self) {
    _user = user;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersDeleteProfilePhotoArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersDeleteProfilePhotoArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersDeleteProfilePhotoArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.user hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersDeleteProfilePhotoArg:other];
}

- (BOOL)isEqualToMembersDeleteProfilePhotoArg:(DBTEAMMembersDeleteProfilePhotoArg *)aMembersDeleteProfilePhotoArg {
  if (self == aMembersDeleteProfilePhotoArg) {
    return YES;
  }
  if (![self.user isEqual:aMembersDeleteProfilePhotoArg.user]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersDeleteProfilePhotoArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersDeleteProfilePhotoArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"user"] = [DBTEAMUserSelectorArgSerializer serialize:valueObj.user];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersDeleteProfilePhotoArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMUserSelectorArg *user = [DBTEAMUserSelectorArgSerializer deserialize:valueDict[@"user"]];

  return [[DBTEAMMembersDeleteProfilePhotoArg alloc] initWithUser:user];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMemberSelectorError.h"
#import "DBTEAMMembersDeleteProfilePhotoError.h"

#pragma mark - API Object

@implementation DBTEAMMembersDeleteProfilePhotoError

#pragma mark - Constructors

- (instancetype)initWithUserNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersDeleteProfilePhotoErrorUserNotFound;
  }
  return self;
}

- (instancetype)initWithUserNotInTeam {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersDeleteProfilePhotoErrorUserNotInTeam;
  }
  return self;
}

- (instancetype)initWithSetProfileDisallowed {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersDeleteProfilePhotoErrorSetProfileDisallowed;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersDeleteProfilePhotoErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isUserNotFound {
  return _tag == DBTEAMMembersDeleteProfilePhotoErrorUserNotFound;
}

- (BOOL)isUserNotInTeam {
  return _tag == DBTEAMMembersDeleteProfilePhotoErrorUserNotInTeam;
}

- (BOOL)isSetProfileDisallowed {
  return _tag == DBTEAMMembersDeleteProfilePhotoErrorSetProfileDisallowed;
}

- (BOOL)isOther {
  return _tag == DBTEAMMembersDeleteProfilePhotoErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMMembersDeleteProfilePhotoErrorUserNotFound:
    return @"DBTEAMMembersDeleteProfilePhotoErrorUserNotFound";
  case DBTEAMMembersDeleteProfilePhotoErrorUserNotInTeam:
    return @"DBTEAMMembersDeleteProfilePhotoErrorUserNotInTeam";
  case DBTEAMMembersDeleteProfilePhotoErrorSetProfileDisallowed:
    return @"DBTEAMMembersDeleteProfilePhotoErrorSetProfileDisallowed";
  case DBTEAMMembersDeleteProfilePhotoErrorOther:
    return @"DBTEAMMembersDeleteProfilePhotoErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersDeleteProfilePhotoErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersDeleteProfilePhotoErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersDeleteProfilePhotoErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMMembersDeleteProfilePhotoErrorUserNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersDeleteProfilePhotoErrorUserNotInTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersDeleteProfilePhotoErrorSetProfileDisallowed:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersDeleteProfilePhotoErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersDeleteProfilePhotoError:other];
}

- (BOOL)isEqualToMembersDeleteProfilePhotoError:
    (DBTEAMMembersDeleteProfilePhotoError *)aMembersDeleteProfilePhotoError {
  if (self == aMembersDeleteProfilePhotoError) {
    return YES;
  }
  if (self.tag != aMembersDeleteProfilePhotoError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMMembersDeleteProfilePhotoErrorUserNotFound:
    return [[self tagName] isEqual:[aMembersDeleteProfilePhotoError tagName]];
  case DBTEAMMembersDeleteProfilePhotoErrorUserNotInTeam:
    return [[self tagName] isEqual:[aMembersDeleteProfilePhotoError tagName]];
  case DBTEAMMembersDeleteProfilePhotoErrorSetProfileDisallowed:
    return [[self tagName] isEqual:[aMembersDeleteProfilePhotoError tagName]];
  case DBTEAMMembersDeleteProfilePhotoErrorOther:
    return [[self tagName] isEqual:[aMembersDeleteProfilePhotoError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersDeleteProfilePhotoErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersDeleteProfilePhotoError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUserNotFound]) {
    jsonDict[@".tag"] = @"user_not_found";
  } else if ([valueObj isUserNotInTeam]) {
    jsonDict[@".tag"] = @"user_not_in_team";
  } else if ([valueObj isSetProfileDisallowed]) {
    jsonDict[@".tag"] = @"set_profile_disallowed";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersDeleteProfilePhotoError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"user_not_found"]) {
    return [[DBTEAMMembersDeleteProfilePhotoError alloc] initWithUserNotFound];
  } else if ([tag isEqualToString:@"user_not_in_team"]) {
    return [[DBTEAMMembersDeleteProfilePhotoError alloc] initWithUserNotInTeam];
  } else if ([tag isEqualToString:@"set_profile_disallowed"]) {
    return [[DBTEAMMembersDeleteProfilePhotoError alloc] initWithSetProfileDisallowed];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMMembersDeleteProfilePhotoError alloc] initWithOther];
  } else {
    return [[DBTEAMMembersDeleteProfilePhotoError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMembersGetInfoArgs.h"
#import "DBTEAMUserSelectorArg.h"

#pragma mark - API Object

@implementation DBTEAMMembersGetInfoArgs

#pragma mark - Constructors

- (instancetype)initWithMembers:(NSArray<DBTEAMUserSelectorArg *> *)members {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](members);

  self = [super init];
  if (self) {
    _members = members;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersGetInfoArgsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersGetInfoArgsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersGetInfoArgsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.members hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersGetInfoArgs:other];
}

- (BOOL)isEqualToMembersGetInfoArgs:(DBTEAMMembersGetInfoArgs *)aMembersGetInfoArgs {
  if (self == aMembersGetInfoArgs) {
    return YES;
  }
  if (![self.members isEqual:aMembersGetInfoArgs.members]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersGetInfoArgsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersGetInfoArgs *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"members"] = [DBArraySerializer serialize:valueObj.members
                                            withBlock:^id(id elem0) {
                                              return [DBTEAMUserSelectorArgSerializer serialize:elem0];
                                            }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersGetInfoArgs *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBTEAMUserSelectorArg *> *members =
      [DBArraySerializer deserialize:valueDict[@"members"]
                           withBlock:^id(id elem0) {
                             return [DBTEAMUserSelectorArgSerializer deserialize:elem0];
                           }];

  return [[DBTEAMMembersGetInfoArgs alloc] initWithMembers:members];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMembersGetInfoError.h"

#pragma mark - API Object

@implementation DBTEAMMembersGetInfoError

#pragma mark - Constructors

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersGetInfoErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isOther {
  return _tag == DBTEAMMembersGetInfoErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMMembersGetInfoErrorOther:
    return @"DBTEAMMembersGetInfoErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersGetInfoErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersGetInfoErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersGetInfoErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMMembersGetInfoErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersGetInfoError:other];
}

- (BOOL)isEqualToMembersGetInfoError:(DBTEAMMembersGetInfoError *)aMembersGetInfoError {
  if (self == aMembersGetInfoError) {
    return YES;
  }
  if (self.tag != aMembersGetInfoError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMMembersGetInfoErrorOther:
    return [[self tagName] isEqual:[aMembersGetInfoError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersGetInfoErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersGetInfoError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersGetInfoError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMMembersGetInfoError alloc] initWithOther];
  } else {
    return [[DBTEAMMembersGetInfoError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMembersGetInfoItem.h"
#import "DBTEAMTeamMemberInfo.h"

#pragma mark - API Object

@implementation DBTEAMMembersGetInfoItem

@synthesize idNotFound = _idNotFound;
@synthesize memberInfo = _memberInfo;

#pragma mark - Constructors

- (instancetype)initWithIdNotFound:(NSString *)idNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersGetInfoItemIdNotFound;
    _idNotFound = idNotFound;
  }
  return self;
}

- (instancetype)initWithMemberInfo:(DBTEAMTeamMemberInfo *)memberInfo {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersGetInfoItemMemberInfo;
    _memberInfo = memberInfo;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSString *)idNotFound {
  if (![self isIdNotFound]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMMembersGetInfoItemIdNotFound, but was %@.", [self tagName]];
  }
  return _idNotFound;
}

- (DBTEAMTeamMemberInfo *)memberInfo {
  if (![self isMemberInfo]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMMembersGetInfoItemMemberInfo, but was %@.", [self tagName]];
  }
  return _memberInfo;
}

#pragma mark - Tag state methods

- (BOOL)isIdNotFound {
  return _tag == DBTEAMMembersGetInfoItemIdNotFound;
}

- (BOOL)isMemberInfo {
  return _tag == DBTEAMMembersGetInfoItemMemberInfo;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMMembersGetInfoItemIdNotFound:
    return @"DBTEAMMembersGetInfoItemIdNotFound";
  case DBTEAMMembersGetInfoItemMemberInfo:
    return @"DBTEAMMembersGetInfoItemMemberInfo";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersGetInfoItemSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersGetInfoItemSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersGetInfoItemSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMMembersGetInfoItemIdNotFound:
    result = prime * result + [self.idNotFound hash];
    break;
  case DBTEAMMembersGetInfoItemMemberInfo:
    result = prime * result + [self.memberInfo hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersGetInfoItem:other];
}

- (BOOL)isEqualToMembersGetInfoItem:(DBTEAMMembersGetInfoItem *)aMembersGetInfoItem {
  if (self == aMembersGetInfoItem) {
    return YES;
  }
  if (self.tag != aMembersGetInfoItem.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMMembersGetInfoItemIdNotFound:
    return [self.idNotFound isEqual:aMembersGetInfoItem.idNotFound];
  case DBTEAMMembersGetInfoItemMemberInfo:
    return [self.memberInfo isEqual:aMembersGetInfoItem.memberInfo];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersGetInfoItemSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersGetInfoItem *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isIdNotFound]) {
    jsonDict[@"id_not_found"] = valueObj.idNotFound;
    jsonDict[@".tag"] = @"id_not_found";
  } else if ([valueObj isMemberInfo]) {
    jsonDict = [[DBTEAMTeamMemberInfoSerializer serialize:valueObj.memberInfo] mutableCopy];
    jsonDict[@".tag"] = @"member_info";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersGetInfoItem *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"id_not_found"]) {
    NSString *idNotFound = valueDict[@"id_not_found"];
    return [[DBTEAMMembersGetInfoItem alloc] initWithIdNotFound:idNotFound];
  } else if ([tag isEqualToString:@"member_info"]) {
    DBTEAMTeamMemberInfo *memberInfo = [DBTEAMTeamMemberInfoSerializer deserialize:valueDict];
    return [[DBTEAMMembersGetInfoItem alloc] initWithMemberInfo:memberInfo];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMembersInfo.h"

#pragma mark - API Object

@implementation DBTEAMMembersInfo

#pragma mark - Constructors

- (instancetype)initWithTeamMemberIds:(NSArray<NSString *> *)teamMemberIds
              permanentlyDeletedUsers:(NSNumber *)permanentlyDeletedUsers {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](teamMemberIds);
  [DBStoneValidators nonnullValidator:nil](permanentlyDeletedUsers);

  self = [super init];
  if (self) {
    _teamMemberIds = teamMemberIds;
    _permanentlyDeletedUsers = permanentlyDeletedUsers;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersInfoSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersInfoSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersInfoSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.teamMemberIds hash];
  result = prime * result + [self.permanentlyDeletedUsers hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersInfo:other];
}

- (BOOL)isEqualToMembersInfo:(DBTEAMMembersInfo *)aMembersInfo {
  if (self == aMembersInfo) {
    return YES;
  }
  if (![self.teamMemberIds isEqual:aMembersInfo.teamMemberIds]) {
    return NO;
  }
  if (![self.permanentlyDeletedUsers isEqual:aMembersInfo.permanentlyDeletedUsers]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersInfoSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersInfo *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"team_member_ids"] = [DBArraySerializer serialize:valueObj.teamMemberIds
                                                    withBlock:^id(id elem0) {
                                                      return elem0;
                                                    }];
  jsonDict[@"permanently_deleted_users"] = valueObj.permanentlyDeletedUsers;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersInfo *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<NSString *> *teamMemberIds = [DBArraySerializer deserialize:valueDict[@"team_member_ids"]
                                                            withBlock:^id(id elem0) {
                                                              return elem0;
                                                            }];
  NSNumber *permanentlyDeletedUsers = valueDict[@"permanently_deleted_users"];

  return
      [[DBTEAMMembersInfo alloc] initWithTeamMemberIds:teamMemberIds permanentlyDeletedUsers:permanentlyDeletedUsers];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMembersListArg.h"

#pragma mark - API Object

@implementation DBTEAMMembersListArg

#pragma mark - Constructors

- (instancetype)initWithLimit:(NSNumber *)limit includeRemoved:(NSNumber *)includeRemoved {

  self = [super init];
  if (self) {
    _limit = limit ?: @(1000);
    _includeRemoved = includeRemoved ?: @NO;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithLimit:nil includeRemoved:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersListArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersListArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersListArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.limit hash];
  result = prime * result + [self.includeRemoved hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersListArg:other];
}

- (BOOL)isEqualToMembersListArg:(DBTEAMMembersListArg *)aMembersListArg {
  if (self == aMembersListArg) {
    return YES;
  }
  if (![self.limit isEqual:aMembersListArg.limit]) {
    return NO;
  }
  if (![self.includeRemoved isEqual:aMembersListArg.includeRemoved]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersListArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersListArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"limit"] = valueObj.limit;
  jsonDict[@"include_removed"] = valueObj.includeRemoved;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersListArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSNumber *limit = valueDict[@"limit"] ?: @(1000);
  NSNumber *includeRemoved = valueDict[@"include_removed"] ?: @NO;

  return [[DBTEAMMembersListArg alloc] initWithLimit:limit includeRemoved:includeRemoved];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMembersListContinueArg.h"

#pragma mark - API Object

@implementation DBTEAMMembersListContinueArg

#pragma mark - Constructors

- (instancetype)initWithCursor:(NSString *)cursor {
  [DBStoneValidators nonnullValidator:nil](cursor);

  self = [super init];
  if (self) {
    _cursor = cursor;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersListContinueArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersListContinueArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersListContinueArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.cursor hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersListContinueArg:other];
}

- (BOOL)isEqualToMembersListContinueArg:(DBTEAMMembersListContinueArg *)aMembersListContinueArg {
  if (self == aMembersListContinueArg) {
    return YES;
  }
  if (![self.cursor isEqual:aMembersListContinueArg.cursor]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersListContinueArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersListContinueArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"cursor"] = valueObj.cursor;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersListContinueArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *cursor = valueDict[@"cursor"];

  return [[DBTEAMMembersListContinueArg alloc] initWithCursor:cursor];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMembersListContinueError.h"

#pragma mark - API Object

@implementation DBTEAMMembersListContinueError

#pragma mark - Constructors

- (instancetype)initWithInvalidCursor {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersListContinueErrorInvalidCursor;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersListContinueErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isInvalidCursor {
  return _tag == DBTEAMMembersListContinueErrorInvalidCursor;
}

- (BOOL)isOther {
  return _tag == DBTEAMMembersListContinueErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMMembersListContinueErrorInvalidCursor:
    return @"DBTEAMMembersListContinueErrorInvalidCursor";
  case DBTEAMMembersListContinueErrorOther:
    return @"DBTEAMMembersListContinueErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersListContinueErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersListContinueErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersListContinueErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMMembersListContinueErrorInvalidCursor:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersListContinueErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersListContinueError:other];
}

- (BOOL)isEqualToMembersListContinueError:(DBTEAMMembersListContinueError *)aMembersListContinueError {
  if (self == aMembersListContinueError) {
    return YES;
  }
  if (self.tag != aMembersListContinueError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMMembersListContinueErrorInvalidCursor:
    return [[self tagName] isEqual:[aMembersListContinueError tagName]];
  case DBTEAMMembersListContinueErrorOther:
    return [[self tagName] isEqual:[aMembersListContinueError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersListContinueErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersListContinueError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isInvalidCursor]) {
    jsonDict[@".tag"] = @"invalid_cursor";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersListContinueError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"invalid_cursor"]) {
    return [[DBTEAMMembersListContinueError alloc] initWithInvalidCursor];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMMembersListContinueError alloc] initWithOther];
  } else {
    return [[DBTEAMMembersListContinueError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMembersListError.h"

#pragma mark - API Object

@implementation DBTEAMMembersListError

#pragma mark - Constructors

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersListErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isOther {
  return _tag == DBTEAMMembersListErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMMembersListErrorOther:
    return @"DBTEAMMembersListErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersListErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersListErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersListErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMMembersListErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersListError:other];
}

- (BOOL)isEqualToMembersListError:(DBTEAMMembersListError *)aMembersListError {
  if (self == aMembersListError) {
    return YES;
  }
  if (self.tag != aMembersListError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMMembersListErrorOther:
    return [[self tagName] isEqual:[aMembersListError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersListErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersListError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersListError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMMembersListError alloc] initWithOther];
  } else {
    return [[DBTEAMMembersListError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMembersListResult.h"
#import "DBTEAMTeamMemberInfo.h"

#pragma mark - API Object

@implementation DBTEAMMembersListResult

#pragma mark - Constructors

- (instancetype)initWithMembers:(NSArray<DBTEAMTeamMemberInfo *> *)members
                         cursor:(NSString *)cursor
                        hasMore:(NSNumber *)hasMore {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](members);
  [DBStoneValidators nonnullValidator:nil](cursor);
  [DBStoneValidators nonnullValidator:nil](hasMore);

  self = [super init];
  if (self) {
    _members = members;
    _cursor = cursor;
    _hasMore = hasMore;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersListResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersListResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersListResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.members hash];
  result = prime * result + [self.cursor hash];
  result = prime * result + [self.hasMore hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersListResult:other];
}

- (BOOL)isEqualToMembersListResult:(DBTEAMMembersListResult *)aMembersListResult {
  if (self == aMembersListResult) {
    return YES;
  }
  if (![self.members isEqual:aMembersListResult.members]) {
    return NO;
  }
  if (![self.cursor isEqual:aMembersListResult.cursor]) {
    return NO;
  }
  if (![self.hasMore isEqual:aMembersListResult.hasMore]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersListResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersListResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"members"] = [DBArraySerializer serialize:valueObj.members
                                            withBlock:^id(id elem0) {
                                              return [DBTEAMTeamMemberInfoSerializer serialize:elem0];
                                            }];
  jsonDict[@"cursor"] = valueObj.cursor;
  jsonDict[@"has_more"] = valueObj.hasMore;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersListResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBTEAMTeamMemberInfo *> *members =
      [DBArraySerializer deserialize:valueDict[@"members"]
                           withBlock:^id(id elem0) {
                             return [DBTEAMTeamMemberInfoSerializer deserialize:elem0];
                           }];
  NSString *cursor = valueDict[@"cursor"];
  NSNumber *hasMore = valueDict[@"has_more"];

  return [[DBTEAMMembersListResult alloc] initWithMembers:members cursor:cursor hasMore:hasMore];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMembersRecoverArg.h"
#import "DBTEAMUserSelectorArg.h"

#pragma mark - API Object

@implementation DBTEAMMembersRecoverArg

#pragma mark - Constructors

- (instancetype)initWithUser:(DBTEAMUserSelectorArg *)user {
  [DBStoneValidators nonnullValidator:nil](user);

  self = [super init];
  if (self) {
    _user = user;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersRecoverArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersRecoverArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersRecoverArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.user hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersRecoverArg:other];
}

- (BOOL)isEqualToMembersRecoverArg:(DBTEAMMembersRecoverArg *)aMembersRecoverArg {
  if (self == aMembersRecoverArg) {
    return YES;
  }
  if (![self.user isEqual:aMembersRecoverArg.user]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersRecoverArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersRecoverArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"user"] = [DBTEAMUserSelectorArgSerializer serialize:valueObj.user];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersRecoverArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMUserSelectorArg *user = [DBTEAMUserSelectorArgSerializer deserialize:valueDict[@"user"]];

  return [[DBTEAMMembersRecoverArg alloc] initWithUser:user];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMembersRecoverError.h"
#import "DBTEAMUserSelectorError.h"

#pragma mark - API Object

@implementation DBTEAMMembersRecoverError

#pragma mark - Constructors

- (instancetype)initWithUserNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersRecoverErrorUserNotFound;
  }
  return self;
}

- (instancetype)initWithUserUnrecoverable {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersRecoverErrorUserUnrecoverable;
  }
  return self;
}

- (instancetype)initWithUserNotInTeam {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersRecoverErrorUserNotInTeam;
  }
  return self;
}

- (instancetype)initWithTeamLicenseLimit {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersRecoverErrorTeamLicenseLimit;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersRecoverErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isUserNotFound {
  return _tag == DBTEAMMembersRecoverErrorUserNotFound;
}

- (BOOL)isUserUnrecoverable {
  return _tag == DBTEAMMembersRecoverErrorUserUnrecoverable;
}

- (BOOL)isUserNotInTeam {
  return _tag == DBTEAMMembersRecoverErrorUserNotInTeam;
}

- (BOOL)isTeamLicenseLimit {
  return _tag == DBTEAMMembersRecoverErrorTeamLicenseLimit;
}

- (BOOL)isOther {
  return _tag == DBTEAMMembersRecoverErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMMembersRecoverErrorUserNotFound:
    return @"DBTEAMMembersRecoverErrorUserNotFound";
  case DBTEAMMembersRecoverErrorUserUnrecoverable:
    return @"DBTEAMMembersRecoverErrorUserUnrecoverable";
  case DBTEAMMembersRecoverErrorUserNotInTeam:
    return @"DBTEAMMembersRecoverErrorUserNotInTeam";
  case DBTEAMMembersRecoverErrorTeamLicenseLimit:
    return @"DBTEAMMembersRecoverErrorTeamLicenseLimit";
  case DBTEAMMembersRecoverErrorOther:
    return @"DBTEAMMembersRecoverErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersRecoverErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersRecoverErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersRecoverErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMMembersRecoverErrorUserNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersRecoverErrorUserUnrecoverable:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersRecoverErrorUserNotInTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersRecoverErrorTeamLicenseLimit:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersRecoverErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersRecoverError:other];
}

- (BOOL)isEqualToMembersRecoverError:(DBTEAMMembersRecoverError *)aMembersRecoverError {
  if (self == aMembersRecoverError) {
    return YES;
  }
  if (self.tag != aMembersRecoverError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMMembersRecoverErrorUserNotFound:
    return [[self tagName] isEqual:[aMembersRecoverError tagName]];
  case DBTEAMMembersRecoverErrorUserUnrecoverable:
    return [[self tagName] isEqual:[aMembersRecoverError tagName]];
  case DBTEAMMembersRecoverErrorUserNotInTeam:
    return [[self tagName] isEqual:[aMembersRecoverError tagName]];
  case DBTEAMMembersRecoverErrorTeamLicenseLimit:
    return [[self tagName] isEqual:[aMembersRecoverError tagName]];
  case DBTEAMMembersRecoverErrorOther:
    return [[self tagName] isEqual:[aMembersRecoverError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersRecoverErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersRecoverError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUserNotFound]) {
    jsonDict[@".tag"] = @"user_not_found";
  } else if ([valueObj isUserUnrecoverable]) {
    jsonDict[@".tag"] = @"user_unrecoverable";
  } else if ([valueObj isUserNotInTeam]) {
    jsonDict[@".tag"] = @"user_not_in_team";
  } else if ([valueObj isTeamLicenseLimit]) {
    jsonDict[@".tag"] = @"team_license_limit";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersRecoverError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"user_not_found"]) {
    return [[DBTEAMMembersRecoverError alloc] initWithUserNotFound];
  } else if ([tag isEqualToString:@"user_unrecoverable"]) {
    return [[DBTEAMMembersRecoverError alloc] initWithUserUnrecoverable];
  } else if ([tag isEqualToString:@"user_not_in_team"]) {
    return [[DBTEAMMembersRecoverError alloc] initWithUserNotInTeam];
  } else if ([tag isEqualToString:@"team_license_limit"]) {
    return [[DBTEAMMembersRecoverError alloc] initWithTeamLicenseLimit];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMMembersRecoverError alloc] initWithOther];
  } else {
    return [[DBTEAMMembersRecoverError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMembersDeactivateArg.h"
#import "DBTEAMMembersRemoveArg.h"
#import "DBTEAMUserSelectorArg.h"

#pragma mark - API Object

@implementation DBTEAMMembersRemoveArg

#pragma mark - Constructors

- (instancetype)initWithUser:(DBTEAMUserSelectorArg *)user
                    wipeData:(NSNumber *)wipeData
              transferDestId:(DBTEAMUserSelectorArg *)transferDestId
             transferAdminId:(DBTEAMUserSelectorArg *)transferAdminId
                 keepAccount:(NSNumber *)keepAccount
            retainTeamShares:(NSNumber *)retainTeamShares {
  [DBStoneValidators nonnullValidator:nil](user);

  self = [super initWithUser:user wipeData:wipeData];
  if (self) {
    _transferDestId = transferDestId;
    _transferAdminId = transferAdminId;
    _keepAccount = keepAccount ?: @NO;
    _retainTeamShares = retainTeamShares ?: @NO;
  }
  return self;
}

- (instancetype)initWithUser:(DBTEAMUserSelectorArg *)user {
  return
      [self initWithUser:user wipeData:nil transferDestId:nil transferAdminId:nil keepAccount:nil retainTeamShares:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersRemoveArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersRemoveArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersRemoveArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.user hash];
  result = prime * result + [self.wipeData hash];
  if (self.transferDestId != nil) {
    result = prime * result + [self.transferDestId hash];
  }
  if (self.transferAdminId != nil) {
    result = prime * result + [self.transferAdminId hash];
  }
  result = prime * result + [self.keepAccount hash];
  result = prime * result + [self.retainTeamShares hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersRemoveArg:other];
}

- (BOOL)isEqualToMembersRemoveArg:(DBTEAMMembersRemoveArg *)aMembersRemoveArg {
  if (self == aMembersRemoveArg) {
    return YES;
  }
  if (![self.user isEqual:aMembersRemoveArg.user]) {
    return NO;
  }
  if (![self.wipeData isEqual:aMembersRemoveArg.wipeData]) {
    return NO;
  }
  if (self.transferDestId) {
    if (![self.transferDestId isEqual:aMembersRemoveArg.transferDestId]) {
      return NO;
    }
  }
  if (self.transferAdminId) {
    if (![self.transferAdminId isEqual:aMembersRemoveArg.transferAdminId]) {
      return NO;
    }
  }
  if (![self.keepAccount isEqual:aMembersRemoveArg.keepAccount]) {
    return NO;
  }
  if (![self.retainTeamShares isEqual:aMembersRemoveArg.retainTeamShares]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersRemoveArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersRemoveArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"user"] = [DBTEAMUserSelectorArgSerializer serialize:valueObj.user];
  jsonDict[@"wipe_data"] = valueObj.wipeData;
  if (valueObj.transferDestId) {
    jsonDict[@"transfer_dest_id"] = [DBTEAMUserSelectorArgSerializer serialize:valueObj.transferDestId];
  }
  if (valueObj.transferAdminId) {
    jsonDict[@"transfer_admin_id"] = [DBTEAMUserSelectorArgSerializer serialize:valueObj.transferAdminId];
  }
  jsonDict[@"keep_account"] = valueObj.keepAccount;
  jsonDict[@"retain_team_shares"] = valueObj.retainTeamShares;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersRemoveArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMUserSelectorArg *user = [DBTEAMUserSelectorArgSerializer deserialize:valueDict[@"user"]];
  NSNumber *wipeData = valueDict[@"wipe_data"] ?: @YES;
  DBTEAMUserSelectorArg *transferDestId =
      valueDict[@"transfer_dest_id"] ? [DBTEAMUserSelectorArgSerializer deserialize:valueDict[@"transfer_dest_id"]]
                                     : nil;
  DBTEAMUserSelectorArg *transferAdminId =
      valueDict[@"transfer_admin_id"] ? [DBTEAMUserSelectorArgSerializer deserialize:valueDict[@"transfer_admin_id"]]
                                      : nil;
  NSNumber *keepAccount = valueDict[@"keep_account"] ?: @NO;
  NSNumber *retainTeamShares = valueDict[@"retain_team_shares"] ?: @NO;

  return [[DBTEAMMembersRemoveArg alloc] initWithUser:user
                                             wipeData:wipeData
                                       transferDestId:transferDestId
                                      transferAdminId:transferAdminId
                                          keepAccount:keepAccount
                                     retainTeamShares:retainTeamShares];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMembersDeactivateError.h"
#import "DBTEAMMembersTransferFilesError.h"

#pragma mark - API Object

@implementation DBTEAMMembersTransferFilesError

#pragma mark - Constructors

- (instancetype)initWithUserNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersTransferFilesErrorUserNotFound;
  }
  return self;
}

- (instancetype)initWithUserNotInTeam {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersTransferFilesErrorUserNotInTeam;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersTransferFilesErrorOther;
  }
  return self;
}

- (instancetype)initWithRemovedAndTransferDestShouldDiffer {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersTransferFilesErrorRemovedAndTransferDestShouldDiffer;
  }
  return self;
}

- (instancetype)initWithRemovedAndTransferAdminShouldDiffer {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersTransferFilesErrorRemovedAndTransferAdminShouldDiffer;
  }
  return self;
}

- (instancetype)initWithTransferDestUserNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersTransferFilesErrorTransferDestUserNotFound;
  }
  return self;
}

- (instancetype)initWithTransferDestUserNotInTeam {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersTransferFilesErrorTransferDestUserNotInTeam;
  }
  return self;
}

- (instancetype)initWithTransferAdminUserNotInTeam {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersTransferFilesErrorTransferAdminUserNotInTeam;
  }
  return self;
}

- (instancetype)initWithTransferAdminUserNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersTransferFilesErrorTransferAdminUserNotFound;
  }
  return self;
}

- (instancetype)initWithUnspecifiedTransferAdminId {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersTransferFilesErrorUnspecifiedTransferAdminId;
  }
  return self;
}

- (instancetype)initWithTransferAdminIsNotAdmin {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersTransferFilesErrorTransferAdminIsNotAdmin;
  }
  return self;
}

- (instancetype)initWithRecipientNotVerified {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersTransferFilesErrorRecipientNotVerified;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isUserNotFound {
  return _tag == DBTEAMMembersTransferFilesErrorUserNotFound;
}

- (BOOL)isUserNotInTeam {
  return _tag == DBTEAMMembersTransferFilesErrorUserNotInTeam;
}

- (BOOL)isOther {
  return _tag == DBTEAMMembersTransferFilesErrorOther;
}

- (BOOL)isRemovedAndTransferDestShouldDiffer {
  return _tag == DBTEAMMembersTransferFilesErrorRemovedAndTransferDestShouldDiffer;
}

- (BOOL)isRemovedAndTransferAdminShouldDiffer {
  return _tag == DBTEAMMembersTransferFilesErrorRemovedAndTransferAdminShouldDiffer;
}

- (BOOL)isTransferDestUserNotFound {
  return _tag == DBTEAMMembersTransferFilesErrorTransferDestUserNotFound;
}

- (BOOL)isTransferDestUserNotInTeam {
  return _tag == DBTEAMMembersTransferFilesErrorTransferDestUserNotInTeam;
}

- (BOOL)isTransferAdminUserNotInTeam {
  return _tag == DBTEAMMembersTransferFilesErrorTransferAdminUserNotInTeam;
}

- (BOOL)isTransferAdminUserNotFound {
  return _tag == DBTEAMMembersTransferFilesErrorTransferAdminUserNotFound;
}

- (BOOL)isUnspecifiedTransferAdminId {
  return _tag == DBTEAMMembersTransferFilesErrorUnspecifiedTransferAdminId;
}

- (BOOL)isTransferAdminIsNotAdmin {
  return _tag == DBTEAMMembersTransferFilesErrorTransferAdminIsNotAdmin;
}

- (BOOL)isRecipientNotVerified {
  return _tag == DBTEAMMembersTransferFilesErrorRecipientNotVerified;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMMembersTransferFilesErrorUserNotFound:
    return @"DBTEAMMembersTransferFilesErrorUserNotFound";
  case DBTEAMMembersTransferFilesErrorUserNotInTeam:
    return @"DBTEAMMembersTransferFilesErrorUserNotInTeam";
  case DBTEAMMembersTransferFilesErrorOther:
    return @"DBTEAMMembersTransferFilesErrorOther";
  case DBTEAMMembersTransferFilesErrorRemovedAndTransferDestShouldDiffer:
    return @"DBTEAMMembersTransferFilesErrorRemovedAndTransferDestShouldDiffer";
  case DBTEAMMembersTransferFilesErrorRemovedAndTransferAdminShouldDiffer:
    return @"DBTEAMMembersTransferFilesErrorRemovedAndTransferAdminShouldDiffer";
  case DBTEAMMembersTransferFilesErrorTransferDestUserNotFound:
    return @"DBTEAMMembersTransferFilesErrorTransferDestUserNotFound";
  case DBTEAMMembersTransferFilesErrorTransferDestUserNotInTeam:
    return @"DBTEAMMembersTransferFilesErrorTransferDestUserNotInTeam";
  case DBTEAMMembersTransferFilesErrorTransferAdminUserNotInTeam:
    return @"DBTEAMMembersTransferFilesErrorTransferAdminUserNotInTeam";
  case DBTEAMMembersTransferFilesErrorTransferAdminUserNotFound:
    return @"DBTEAMMembersTransferFilesErrorTransferAdminUserNotFound";
  case DBTEAMMembersTransferFilesErrorUnspecifiedTransferAdminId:
    return @"DBTEAMMembersTransferFilesErrorUnspecifiedTransferAdminId";
  case DBTEAMMembersTransferFilesErrorTransferAdminIsNotAdmin:
    return @"DBTEAMMembersTransferFilesErrorTransferAdminIsNotAdmin";
  case DBTEAMMembersTransferFilesErrorRecipientNotVerified:
    return @"DBTEAMMembersTransferFilesErrorRecipientNotVerified";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersTransferFilesErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersTransferFilesErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersTransferFilesErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMMembersTransferFilesErrorUserNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersTransferFilesErrorUserNotInTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersTransferFilesErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersTransferFilesErrorRemovedAndTransferDestShouldDiffer:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersTransferFilesErrorRemovedAndTransferAdminShouldDiffer:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersTransferFilesErrorTransferDestUserNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersTransferFilesErrorTransferDestUserNotInTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersTransferFilesErrorTransferAdminUserNotInTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersTransferFilesErrorTransferAdminUserNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersTransferFilesErrorUnspecifiedTransferAdminId:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersTransferFilesErrorTransferAdminIsNotAdmin:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersTransferFilesErrorRecipientNotVerified:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersTransferFilesError:other];
}

- (BOOL)isEqualToMembersTransferFilesError:(DBTEAMMembersTransferFilesError *)aMembersTransferFilesError {
  if (self == aMembersTransferFilesError) {
    return YES;
  }
  if (self.tag != aMembersTransferFilesError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMMembersTransferFilesErrorUserNotFound:
    return [[self tagName] isEqual:[aMembersTransferFilesError tagName]];
  case DBTEAMMembersTransferFilesErrorUserNotInTeam:
    return [[self tagName] isEqual:[aMembersTransferFilesError tagName]];
  case DBTEAMMembersTransferFilesErrorOther:
    return [[self tagName] isEqual:[aMembersTransferFilesError tagName]];
  case DBTEAMMembersTransferFilesErrorRemovedAndTransferDestShouldDiffer:
    return [[self tagName] isEqual:[aMembersTransferFilesError tagName]];
  case DBTEAMMembersTransferFilesErrorRemovedAndTransferAdminShouldDiffer:
    return [[self tagName] isEqual:[aMembersTransferFilesError tagName]];
  case DBTEAMMembersTransferFilesErrorTransferDestUserNotFound:
    return [[self tagName] isEqual:[aMembersTransferFilesError tagName]];
  case DBTEAMMembersTransferFilesErrorTransferDestUserNotInTeam:
    return [[self tagName] isEqual:[aMembersTransferFilesError tagName]];
  case DBTEAMMembersTransferFilesErrorTransferAdminUserNotInTeam:
    return [[self tagName] isEqual:[aMembersTransferFilesError tagName]];
  case DBTEAMMembersTransferFilesErrorTransferAdminUserNotFound:
    return [[self tagName] isEqual:[aMembersTransferFilesError tagName]];
  case DBTEAMMembersTransferFilesErrorUnspecifiedTransferAdminId:
    return [[self tagName] isEqual:[aMembersTransferFilesError tagName]];
  case DBTEAMMembersTransferFilesErrorTransferAdminIsNotAdmin:
    return [[self tagName] isEqual:[aMembersTransferFilesError tagName]];
  case DBTEAMMembersTransferFilesErrorRecipientNotVerified:
    return [[self tagName] isEqual:[aMembersTransferFilesError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersTransferFilesErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersTransferFilesError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUserNotFound]) {
    jsonDict[@".tag"] = @"user_not_found";
  } else if ([valueObj isUserNotInTeam]) {
    jsonDict[@".tag"] = @"user_not_in_team";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isRemovedAndTransferDestShouldDiffer]) {
    jsonDict[@".tag"] = @"removed_and_transfer_dest_should_differ";
  } else if ([valueObj isRemovedAndTransferAdminShouldDiffer]) {
    jsonDict[@".tag"] = @"removed_and_transfer_admin_should_differ";
  } else if ([valueObj isTransferDestUserNotFound]) {
    jsonDict[@".tag"] = @"transfer_dest_user_not_found";
  } else if ([valueObj isTransferDestUserNotInTeam]) {
    jsonDict[@".tag"] = @"transfer_dest_user_not_in_team";
  } else if ([valueObj isTransferAdminUserNotInTeam]) {
    jsonDict[@".tag"] = @"transfer_admin_user_not_in_team";
  } else if ([valueObj isTransferAdminUserNotFound]) {
    jsonDict[@".tag"] = @"transfer_admin_user_not_found";
  } else if ([valueObj isUnspecifiedTransferAdminId]) {
    jsonDict[@".tag"] = @"unspecified_transfer_admin_id";
  } else if ([valueObj isTransferAdminIsNotAdmin]) {
    jsonDict[@".tag"] = @"transfer_admin_is_not_admin";
  } else if ([valueObj isRecipientNotVerified]) {
    jsonDict[@".tag"] = @"recipient_not_verified";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersTransferFilesError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"user_not_found"]) {
    return [[DBTEAMMembersTransferFilesError alloc] initWithUserNotFound];
  } else if ([tag isEqualToString:@"user_not_in_team"]) {
    return [[DBTEAMMembersTransferFilesError alloc] initWithUserNotInTeam];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMMembersTransferFilesError alloc] initWithOther];
  } else if ([tag isEqualToString:@"removed_and_transfer_dest_should_differ"]) {
    return [[DBTEAMMembersTransferFilesError alloc] initWithRemovedAndTransferDestShouldDiffer];
  } else if ([tag isEqualToString:@"removed_and_transfer_admin_should_differ"]) {
    return [[DBTEAMMembersTransferFilesError alloc] initWithRemovedAndTransferAdminShouldDiffer];
  } else if ([tag isEqualToString:@"transfer_dest_user_not_found"]) {
    return [[DBTEAMMembersTransferFilesError alloc] initWithTransferDestUserNotFound];
  } else if ([tag isEqualToString:@"transfer_dest_user_not_in_team"]) {
    return [[DBTEAMMembersTransferFilesError alloc] initWithTransferDestUserNotInTeam];
  } else if ([tag isEqualToString:@"transfer_admin_user_not_in_team"]) {
    return [[DBTEAMMembersTransferFilesError alloc] initWithTransferAdminUserNotInTeam];
  } else if ([tag isEqualToString:@"transfer_admin_user_not_found"]) {
    return [[DBTEAMMembersTransferFilesError alloc] initWithTransferAdminUserNotFound];
  } else if ([tag isEqualToString:@"unspecified_transfer_admin_id"]) {
    return [[DBTEAMMembersTransferFilesError alloc] initWithUnspecifiedTransferAdminId];
  } else if ([tag isEqualToString:@"transfer_admin_is_not_admin"]) {
    return [[DBTEAMMembersTransferFilesError alloc] initWithTransferAdminIsNotAdmin];
  } else if ([tag isEqualToString:@"recipient_not_verified"]) {
    return [[DBTEAMMembersTransferFilesError alloc] initWithRecipientNotVerified];
  } else {
    return [[DBTEAMMembersTransferFilesError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMembersRemoveError.h"
#import "DBTEAMMembersTransferFilesError.h"

#pragma mark - API Object

@implementation DBTEAMMembersRemoveError

#pragma mark - Constructors

- (instancetype)initWithUserNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersRemoveErrorUserNotFound;
  }
  return self;
}

- (instancetype)initWithUserNotInTeam {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersRemoveErrorUserNotInTeam;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersRemoveErrorOther;
  }
  return self;
}

- (instancetype)initWithRemovedAndTransferDestShouldDiffer {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersRemoveErrorRemovedAndTransferDestShouldDiffer;
  }
  return self;
}

- (instancetype)initWithRemovedAndTransferAdminShouldDiffer {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersRemoveErrorRemovedAndTransferAdminShouldDiffer;
  }
  return self;
}

- (instancetype)initWithTransferDestUserNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersRemoveErrorTransferDestUserNotFound;
  }
  return self;
}

- (instancetype)initWithTransferDestUserNotInTeam {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersRemoveErrorTransferDestUserNotInTeam;
  }
  return self;
}

- (instancetype)initWithTransferAdminUserNotInTeam {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersRemoveErrorTransferAdminUserNotInTeam;
  }
  return self;
}

- (instancetype)initWithTransferAdminUserNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersRemoveErrorTransferAdminUserNotFound;
  }
  return self;
}

- (instancetype)initWithUnspecifiedTransferAdminId {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersRemoveErrorUnspecifiedTransferAdminId;
  }
  return self;
}

- (instancetype)initWithTransferAdminIsNotAdmin {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersRemoveErrorTransferAdminIsNotAdmin;
  }
  return self;
}

- (instancetype)initWithRecipientNotVerified {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersRemoveErrorRecipientNotVerified;
  }
  return self;
}

- (instancetype)initWithRemoveLastAdmin {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersRemoveErrorRemoveLastAdmin;
  }
  return self;
}

- (instancetype)initWithCannotKeepAccountAndTransfer {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersRemoveErrorCannotKeepAccountAndTransfer;
  }
  return self;
}

- (instancetype)initWithCannotKeepAccountAndDeleteData {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersRemoveErrorCannotKeepAccountAndDeleteData;
  }
  return self;
}

- (instancetype)initWithEmailAddressTooLongToBeDisabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersRemoveErrorEmailAddressTooLongToBeDisabled;
  }
  return self;
}

- (instancetype)initWithCannotKeepInvitedUserAccount {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersRemoveErrorCannotKeepInvitedUserAccount;
  }
  return self;
}

- (instancetype)initWithCannotRetainSharesWhenDataWiped {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersRemoveErrorCannotRetainSharesWhenDataWiped;
  }
  return self;
}

- (instancetype)initWithCannotRetainSharesWhenNoAccountKept {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersRemoveErrorCannotRetainSharesWhenNoAccountKept;
  }
  return self;
}

- (instancetype)initWithCannotRetainSharesWhenTeamExternalSharingOff {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersRemoveErrorCannotRetainSharesWhenTeamExternalSharingOff;
  }
  return self;
}

- (instancetype)initWithCannotKeepAccount {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersRemoveErrorCannotKeepAccount;
  }
  return self;
}

- (instancetype)initWithCannotKeepAccountUnderLegalHold {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersRemoveErrorCannotKeepAccountUnderLegalHold;
  }
  return self;
}

- (instancetype)initWithCannotKeepAccountRequiredToSignTos {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersRemoveErrorCannotKeepAccountRequiredToSignTos;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isUserNotFound {
  return _tag == DBTEAMMembersRemoveErrorUserNotFound;
}

- (BOOL)isUserNotInTeam {
  return _tag == DBTEAMMembersRemoveErrorUserNotInTeam;
}

- (BOOL)isOther {
  return _tag == DBTEAMMembersRemoveErrorOther;
}

- (BOOL)isRemovedAndTransferDestShouldDiffer {
  return _tag == DBTEAMMembersRemoveErrorRemovedAndTransferDestShouldDiffer;
}

- (BOOL)isRemovedAndTransferAdminShouldDiffer {
  return _tag == DBTEAMMembersRemoveErrorRemovedAndTransferAdminShouldDiffer;
}

- (BOOL)isTransferDestUserNotFound {
  return _tag == DBTEAMMembersRemoveErrorTransferDestUserNotFound;
}

- (BOOL)isTransferDestUserNotInTeam {
  return _tag == DBTEAMMembersRemoveErrorTransferDestUserNotInTeam;
}

- (BOOL)isTransferAdminUserNotInTeam {
  return _tag == DBTEAMMembersRemoveErrorTransferAdminUserNotInTeam;
}

- (BOOL)isTransferAdminUserNotFound {
  return _tag == DBTEAMMembersRemoveErrorTransferAdminUserNotFound;
}

- (BOOL)isUnspecifiedTransferAdminId {
  return _tag == DBTEAMMembersRemoveErrorUnspecifiedTransferAdminId;
}

- (BOOL)isTransferAdminIsNotAdmin {
  return _tag == DBTEAMMembersRemoveErrorTransferAdminIsNotAdmin;
}

- (BOOL)isRecipientNotVerified {
  return _tag == DBTEAMMembersRemoveErrorRecipientNotVerified;
}

- (BOOL)isRemoveLastAdmin {
  return _tag == DBTEAMMembersRemoveErrorRemoveLastAdmin;
}

- (BOOL)isCannotKeepAccountAndTransfer {
  return _tag == DBTEAMMembersRemoveErrorCannotKeepAccountAndTransfer;
}

- (BOOL)isCannotKeepAccountAndDeleteData {
  return _tag == DBTEAMMembersRemoveErrorCannotKeepAccountAndDeleteData;
}

- (BOOL)isEmailAddressTooLongToBeDisabled {
  return _tag == DBTEAMMembersRemoveErrorEmailAddressTooLongToBeDisabled;
}

- (BOOL)isCannotKeepInvitedUserAccount {
  return _tag == DBTEAMMembersRemoveErrorCannotKeepInvitedUserAccount;
}

- (BOOL)isCannotRetainSharesWhenDataWiped {
  return _tag == DBTEAMMembersRemoveErrorCannotRetainSharesWhenDataWiped;
}

- (BOOL)isCannotRetainSharesWhenNoAccountKept {
  return _tag == DBTEAMMembersRemoveErrorCannotRetainSharesWhenNoAccountKept;
}

- (BOOL)isCannotRetainSharesWhenTeamExternalSharingOff {
  return _tag == DBTEAMMembersRemoveErrorCannotRetainSharesWhenTeamExternalSharingOff;
}

- (BOOL)isCannotKeepAccount {
  return _tag == DBTEAMMembersRemoveErrorCannotKeepAccount;
}

- (BOOL)isCannotKeepAccountUnderLegalHold {
  return _tag == DBTEAMMembersRemoveErrorCannotKeepAccountUnderLegalHold;
}

- (BOOL)isCannotKeepAccountRequiredToSignTos {
  return _tag == DBTEAMMembersRemoveErrorCannotKeepAccountRequiredToSignTos;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMMembersRemoveErrorUserNotFound:
    return @"DBTEAMMembersRemoveErrorUserNotFound";
  case DBTEAMMembersRemoveErrorUserNotInTeam:
    return @"DBTEAMMembersRemoveErrorUserNotInTeam";
  case DBTEAMMembersRemoveErrorOther:
    return @"DBTEAMMembersRemoveErrorOther";
  case DBTEAMMembersRemoveErrorRemovedAndTransferDestShouldDiffer:
    return @"DBTEAMMembersRemoveErrorRemovedAndTransferDestShouldDiffer";
  case DBTEAMMembersRemoveErrorRemovedAndTransferAdminShouldDiffer:
    return @"DBTEAMMembersRemoveErrorRemovedAndTransferAdminShouldDiffer";
  case DBTEAMMembersRemoveErrorTransferDestUserNotFound:
    return @"DBTEAMMembersRemoveErrorTransferDestUserNotFound";
  case DBTEAMMembersRemoveErrorTransferDestUserNotInTeam:
    return @"DBTEAMMembersRemoveErrorTransferDestUserNotInTeam";
  case DBTEAMMembersRemoveErrorTransferAdminUserNotInTeam:
    return @"DBTEAMMembersRemoveErrorTransferAdminUserNotInTeam";
  case DBTEAMMembersRemoveErrorTransferAdminUserNotFound:
    return @"DBTEAMMembersRemoveErrorTransferAdminUserNotFound";
  case DBTEAMMembersRemoveErrorUnspecifiedTransferAdminId:
    return @"DBTEAMMembersRemoveErrorUnspecifiedTransferAdminId";
  case DBTEAMMembersRemoveErrorTransferAdminIsNotAdmin:
    return @"DBTEAMMembersRemoveErrorTransferAdminIsNotAdmin";
  case DBTEAMMembersRemoveErrorRecipientNotVerified:
    return @"DBTEAMMembersRemoveErrorRecipientNotVerified";
  case DBTEAMMembersRemoveErrorRemoveLastAdmin:
    return @"DBTEAMMembersRemoveErrorRemoveLastAdmin";
  case DBTEAMMembersRemoveErrorCannotKeepAccountAndTransfer:
    return @"DBTEAMMembersRemoveErrorCannotKeepAccountAndTransfer";
  case DBTEAMMembersRemoveErrorCannotKeepAccountAndDeleteData:
    return @"DBTEAMMembersRemoveErrorCannotKeepAccountAndDeleteData";
  case DBTEAMMembersRemoveErrorEmailAddressTooLongToBeDisabled:
    return @"DBTEAMMembersRemoveErrorEmailAddressTooLongToBeDisabled";
  case DBTEAMMembersRemoveErrorCannotKeepInvitedUserAccount:
    return @"DBTEAMMembersRemoveErrorCannotKeepInvitedUserAccount";
  case DBTEAMMembersRemoveErrorCannotRetainSharesWhenDataWiped:
    return @"DBTEAMMembersRemoveErrorCannotRetainSharesWhenDataWiped";
  case DBTEAMMembersRemoveErrorCannotRetainSharesWhenNoAccountKept:
    return @"DBTEAMMembersRemoveErrorCannotRetainSharesWhenNoAccountKept";
  case DBTEAMMembersRemoveErrorCannotRetainSharesWhenTeamExternalSharingOff:
    return @"DBTEAMMembersRemoveErrorCannotRetainSharesWhenTeamExternalSharingOff";
  case DBTEAMMembersRemoveErrorCannotKeepAccount:
    return @"DBTEAMMembersRemoveErrorCannotKeepAccount";
  case DBTEAMMembersRemoveErrorCannotKeepAccountUnderLegalHold:
    return @"DBTEAMMembersRemoveErrorCannotKeepAccountUnderLegalHold";
  case DBTEAMMembersRemoveErrorCannotKeepAccountRequiredToSignTos:
    return @"DBTEAMMembersRemoveErrorCannotKeepAccountRequiredToSignTos";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersRemoveErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersRemoveErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersRemoveErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMMembersRemoveErrorUserNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersRemoveErrorUserNotInTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersRemoveErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersRemoveErrorRemovedAndTransferDestShouldDiffer:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersRemoveErrorRemovedAndTransferAdminShouldDiffer:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersRemoveErrorTransferDestUserNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersRemoveErrorTransferDestUserNotInTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersRemoveErrorTransferAdminUserNotInTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersRemoveErrorTransferAdminUserNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersRemoveErrorUnspecifiedTransferAdminId:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersRemoveErrorTransferAdminIsNotAdmin:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersRemoveErrorRecipientNotVerified:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersRemoveErrorRemoveLastAdmin:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersRemoveErrorCannotKeepAccountAndTransfer:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersRemoveErrorCannotKeepAccountAndDeleteData:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersRemoveErrorEmailAddressTooLongToBeDisabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersRemoveErrorCannotKeepInvitedUserAccount:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersRemoveErrorCannotRetainSharesWhenDataWiped:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersRemoveErrorCannotRetainSharesWhenNoAccountKept:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersRemoveErrorCannotRetainSharesWhenTeamExternalSharingOff:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersRemoveErrorCannotKeepAccount:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersRemoveErrorCannotKeepAccountUnderLegalHold:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersRemoveErrorCannotKeepAccountRequiredToSignTos:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersRemoveError:other];
}

- (BOOL)isEqualToMembersRemoveError:(DBTEAMMembersRemoveError *)aMembersRemoveError {
  if (self == aMembersRemoveError) {
    return YES;
  }
  if (self.tag != aMembersRemoveError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMMembersRemoveErrorUserNotFound:
    return [[self tagName] isEqual:[aMembersRemoveError tagName]];
  case DBTEAMMembersRemoveErrorUserNotInTeam:
    return [[self tagName] isEqual:[aMembersRemoveError tagName]];
  case DBTEAMMembersRemoveErrorOther:
    return [[self tagName] isEqual:[aMembersRemoveError tagName]];
  case DBTEAMMembersRemoveErrorRemovedAndTransferDestShouldDiffer:
    return [[self tagName] isEqual:[aMembersRemoveError tagName]];
  case DBTEAMMembersRemoveErrorRemovedAndTransferAdminShouldDiffer:
    return [[self tagName] isEqual:[aMembersRemoveError tagName]];
  case DBTEAMMembersRemoveErrorTransferDestUserNotFound:
    return [[self tagName] isEqual:[aMembersRemoveError tagName]];
  case DBTEAMMembersRemoveErrorTransferDestUserNotInTeam:
    return [[self tagName] isEqual:[aMembersRemoveError tagName]];
  case DBTEAMMembersRemoveErrorTransferAdminUserNotInTeam:
    return [[self tagName] isEqual:[aMembersRemoveError tagName]];
  case DBTEAMMembersRemoveErrorTransferAdminUserNotFound:
    return [[self tagName] isEqual:[aMembersRemoveError tagName]];
  case DBTEAMMembersRemoveErrorUnspecifiedTransferAdminId:
    return [[self tagName] isEqual:[aMembersRemoveError tagName]];
  case DBTEAMMembersRemoveErrorTransferAdminIsNotAdmin:
    return [[self tagName] isEqual:[aMembersRemoveError tagName]];
  case DBTEAMMembersRemoveErrorRecipientNotVerified:
    return [[self tagName] isEqual:[aMembersRemoveError tagName]];
  case DBTEAMMembersRemoveErrorRemoveLastAdmin:
    return [[self tagName] isEqual:[aMembersRemoveError tagName]];
  case DBTEAMMembersRemoveErrorCannotKeepAccountAndTransfer:
    return [[self tagName] isEqual:[aMembersRemoveError tagName]];
  case DBTEAMMembersRemoveErrorCannotKeepAccountAndDeleteData:
    return [[self tagName] isEqual:[aMembersRemoveError tagName]];
  case DBTEAMMembersRemoveErrorEmailAddressTooLongToBeDisabled:
    return [[self tagName] isEqual:[aMembersRemoveError tagName]];
  case DBTEAMMembersRemoveErrorCannotKeepInvitedUserAccount:
    return [[self tagName] isEqual:[aMembersRemoveError tagName]];
  case DBTEAMMembersRemoveErrorCannotRetainSharesWhenDataWiped:
    return [[self tagName] isEqual:[aMembersRemoveError tagName]];
  case DBTEAMMembersRemoveErrorCannotRetainSharesWhenNoAccountKept:
    return [[self tagName] isEqual:[aMembersRemoveError tagName]];
  case DBTEAMMembersRemoveErrorCannotRetainSharesWhenTeamExternalSharingOff:
    return [[self tagName] isEqual:[aMembersRemoveError tagName]];
  case DBTEAMMembersRemoveErrorCannotKeepAccount:
    return [[self tagName] isEqual:[aMembersRemoveError tagName]];
  case DBTEAMMembersRemoveErrorCannotKeepAccountUnderLegalHold:
    return [[self tagName] isEqual:[aMembersRemoveError tagName]];
  case DBTEAMMembersRemoveErrorCannotKeepAccountRequiredToSignTos:
    return [[self tagName] isEqual:[aMembersRemoveError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersRemoveErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersRemoveError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUserNotFound]) {
    jsonDict[@".tag"] = @"user_not_found";
  } else if ([valueObj isUserNotInTeam]) {
    jsonDict[@".tag"] = @"user_not_in_team";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isRemovedAndTransferDestShouldDiffer]) {
    jsonDict[@".tag"] = @"removed_and_transfer_dest_should_differ";
  } else if ([valueObj isRemovedAndTransferAdminShouldDiffer]) {
    jsonDict[@".tag"] = @"removed_and_transfer_admin_should_differ";
  } else if ([valueObj isTransferDestUserNotFound]) {
    jsonDict[@".tag"] = @"transfer_dest_user_not_found";
  } else if ([valueObj isTransferDestUserNotInTeam]) {
    jsonDict[@".tag"] = @"transfer_dest_user_not_in_team";
  } else if ([valueObj isTransferAdminUserNotInTeam]) {
    jsonDict[@".tag"] = @"transfer_admin_user_not_in_team";
  } else if ([valueObj isTransferAdminUserNotFound]) {
    jsonDict[@".tag"] = @"transfer_admin_user_not_found";
  } else if ([valueObj isUnspecifiedTransferAdminId]) {
    jsonDict[@".tag"] = @"unspecified_transfer_admin_id";
  } else if ([valueObj isTransferAdminIsNotAdmin]) {
    jsonDict[@".tag"] = @"transfer_admin_is_not_admin";
  } else if ([valueObj isRecipientNotVerified]) {
    jsonDict[@".tag"] = @"recipient_not_verified";
  } else if ([valueObj isRemoveLastAdmin]) {
    jsonDict[@".tag"] = @"remove_last_admin";
  } else if ([valueObj isCannotKeepAccountAndTransfer]) {
    jsonDict[@".tag"] = @"cannot_keep_account_and_transfer";
  } else if ([valueObj isCannotKeepAccountAndDeleteData]) {
    jsonDict[@".tag"] = @"cannot_keep_account_and_delete_data";
  } else if ([valueObj isEmailAddressTooLongToBeDisabled]) {
    jsonDict[@".tag"] = @"email_address_too_long_to_be_disabled";
  } else if ([valueObj isCannotKeepInvitedUserAccount]) {
    jsonDict[@".tag"] = @"cannot_keep_invited_user_account";
  } else if ([valueObj isCannotRetainSharesWhenDataWiped]) {
    jsonDict[@".tag"] = @"cannot_retain_shares_when_data_wiped";
  } else if ([valueObj isCannotRetainSharesWhenNoAccountKept]) {
    jsonDict[@".tag"] = @"cannot_retain_shares_when_no_account_kept";
  } else if ([valueObj isCannotRetainSharesWhenTeamExternalSharingOff]) {
    jsonDict[@".tag"] = @"cannot_retain_shares_when_team_external_sharing_off";
  } else if ([valueObj isCannotKeepAccount]) {
    jsonDict[@".tag"] = @"cannot_keep_account";
  } else if ([valueObj isCannotKeepAccountUnderLegalHold]) {
    jsonDict[@".tag"] = @"cannot_keep_account_under_legal_hold";
  } else if ([valueObj isCannotKeepAccountRequiredToSignTos]) {
    jsonDict[@".tag"] = @"cannot_keep_account_required_to_sign_tos";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersRemoveError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"user_not_found"]) {
    return [[DBTEAMMembersRemoveError alloc] initWithUserNotFound];
  } else if ([tag isEqualToString:@"user_not_in_team"]) {
    return [[DBTEAMMembersRemoveError alloc] initWithUserNotInTeam];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMMembersRemoveError alloc] initWithOther];
  } else if ([tag isEqualToString:@"removed_and_transfer_dest_should_differ"]) {
    return [[DBTEAMMembersRemoveError alloc] initWithRemovedAndTransferDestShouldDiffer];
  } else if ([tag isEqualToString:@"removed_and_transfer_admin_should_differ"]) {
    return [[DBTEAMMembersRemoveError alloc] initWithRemovedAndTransferAdminShouldDiffer];
  } else if ([tag isEqualToString:@"transfer_dest_user_not_found"]) {
    return [[DBTEAMMembersRemoveError alloc] initWithTransferDestUserNotFound];
  } else if ([tag isEqualToString:@"transfer_dest_user_not_in_team"]) {
    return [[DBTEAMMembersRemoveError alloc] initWithTransferDestUserNotInTeam];
  } else if ([tag isEqualToString:@"transfer_admin_user_not_in_team"]) {
    return [[DBTEAMMembersRemoveError alloc] initWithTransferAdminUserNotInTeam];
  } else if ([tag isEqualToString:@"transfer_admin_user_not_found"]) {
    return [[DBTEAMMembersRemoveError alloc] initWithTransferAdminUserNotFound];
  } else if ([tag isEqualToString:@"unspecified_transfer_admin_id"]) {
    return [[DBTEAMMembersRemoveError alloc] initWithUnspecifiedTransferAdminId];
  } else if ([tag isEqualToString:@"transfer_admin_is_not_admin"]) {
    return [[DBTEAMMembersRemoveError alloc] initWithTransferAdminIsNotAdmin];
  } else if ([tag isEqualToString:@"recipient_not_verified"]) {
    return [[DBTEAMMembersRemoveError alloc] initWithRecipientNotVerified];
  } else if ([tag isEqualToString:@"remove_last_admin"]) {
    return [[DBTEAMMembersRemoveError alloc] initWithRemoveLastAdmin];
  } else if ([tag isEqualToString:@"cannot_keep_account_and_transfer"]) {
    return [[DBTEAMMembersRemoveError alloc] initWithCannotKeepAccountAndTransfer];
  } else if ([tag isEqualToString:@"cannot_keep_account_and_delete_data"]) {
    return [[DBTEAMMembersRemoveError alloc] initWithCannotKeepAccountAndDeleteData];
  } else if ([tag isEqualToString:@"email_address_too_long_to_be_disabled"]) {
    return [[DBTEAMMembersRemoveError alloc] initWithEmailAddressTooLongToBeDisabled];
  } else if ([tag isEqualToString:@"cannot_keep_invited_user_account"]) {
    return [[DBTEAMMembersRemoveError alloc] initWithCannotKeepInvitedUserAccount];
  } else if ([tag isEqualToString:@"cannot_retain_shares_when_data_wiped"]) {
    return [[DBTEAMMembersRemoveError alloc] initWithCannotRetainSharesWhenDataWiped];
  } else if ([tag isEqualToString:@"cannot_retain_shares_when_no_account_kept"]) {
    return [[DBTEAMMembersRemoveError alloc] initWithCannotRetainSharesWhenNoAccountKept];
  } else if ([tag isEqualToString:@"cannot_retain_shares_when_team_external_sharing_off"]) {
    return [[DBTEAMMembersRemoveError alloc] initWithCannotRetainSharesWhenTeamExternalSharingOff];
  } else if ([tag isEqualToString:@"cannot_keep_account"]) {
    return [[DBTEAMMembersRemoveError alloc] initWithCannotKeepAccount];
  } else if ([tag isEqualToString:@"cannot_keep_account_under_legal_hold"]) {
    return [[DBTEAMMembersRemoveError alloc] initWithCannotKeepAccountUnderLegalHold];
  } else if ([tag isEqualToString:@"cannot_keep_account_required_to_sign_tos"]) {
    return [[DBTEAMMembersRemoveError alloc] initWithCannotKeepAccountRequiredToSignTos];
  } else {
    return [[DBTEAMMembersRemoveError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMemberSelectorError.h"
#import "DBTEAMMembersSendWelcomeError.h"

#pragma mark - API Object

@implementation DBTEAMMembersSendWelcomeError

#pragma mark - Constructors

- (instancetype)initWithUserNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersSendWelcomeErrorUserNotFound;
  }
  return self;
}

- (instancetype)initWithUserNotInTeam {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersSendWelcomeErrorUserNotInTeam;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersSendWelcomeErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isUserNotFound {
  return _tag == DBTEAMMembersSendWelcomeErrorUserNotFound;
}

- (BOOL)isUserNotInTeam {
  return _tag == DBTEAMMembersSendWelcomeErrorUserNotInTeam;
}

- (BOOL)isOther {
  return _tag == DBTEAMMembersSendWelcomeErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMMembersSendWelcomeErrorUserNotFound:
    return @"DBTEAMMembersSendWelcomeErrorUserNotFound";
  case DBTEAMMembersSendWelcomeErrorUserNotInTeam:
    return @"DBTEAMMembersSendWelcomeErrorUserNotInTeam";
  case DBTEAMMembersSendWelcomeErrorOther:
    return @"DBTEAMMembersSendWelcomeErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersSendWelcomeErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersSendWelcomeErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersSendWelcomeErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMMembersSendWelcomeErrorUserNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersSendWelcomeErrorUserNotInTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersSendWelcomeErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersSendWelcomeError:other];
}

- (BOOL)isEqualToMembersSendWelcomeError:(DBTEAMMembersSendWelcomeError *)aMembersSendWelcomeError {
  if (self == aMembersSendWelcomeError) {
    return YES;
  }
  if (self.tag != aMembersSendWelcomeError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMMembersSendWelcomeErrorUserNotFound:
    return [[self tagName] isEqual:[aMembersSendWelcomeError tagName]];
  case DBTEAMMembersSendWelcomeErrorUserNotInTeam:
    return [[self tagName] isEqual:[aMembersSendWelcomeError tagName]];
  case DBTEAMMembersSendWelcomeErrorOther:
    return [[self tagName] isEqual:[aMembersSendWelcomeError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersSendWelcomeErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersSendWelcomeError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUserNotFound]) {
    jsonDict[@".tag"] = @"user_not_found";
  } else if ([valueObj isUserNotInTeam]) {
    jsonDict[@".tag"] = @"user_not_in_team";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersSendWelcomeError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"user_not_found"]) {
    return [[DBTEAMMembersSendWelcomeError alloc] initWithUserNotFound];
  } else if ([tag isEqualToString:@"user_not_in_team"]) {
    return [[DBTEAMMembersSendWelcomeError alloc] initWithUserNotInTeam];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMMembersSendWelcomeError alloc] initWithOther];
  } else {
    return [[DBTEAMMembersSendWelcomeError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMAdminTier.h"
#import "DBTEAMMembersSetPermissionsArg.h"
#import "DBTEAMUserSelectorArg.h"

#pragma mark - API Object

@implementation DBTEAMMembersSetPermissionsArg

#pragma mark - Constructors

- (instancetype)initWithUser:(DBTEAMUserSelectorArg *)user dNewRole:(DBTEAMAdminTier *)dNewRole {
  [DBStoneValidators nonnullValidator:nil](user);
  [DBStoneValidators nonnullValidator:nil](dNewRole);

  self = [super init];
  if (self) {
    _user = user;
    _dNewRole = dNewRole;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersSetPermissionsArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersSetPermissionsArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersSetPermissionsArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.user hash];
  result = prime * result + [self.dNewRole hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersSetPermissionsArg:other];
}

- (BOOL)isEqualToMembersSetPermissionsArg:(DBTEAMMembersSetPermissionsArg *)aMembersSetPermissionsArg {
  if (self == aMembersSetPermissionsArg) {
    return YES;
  }
  if (![self.user isEqual:aMembersSetPermissionsArg.user]) {
    return NO;
  }
  if (![self.dNewRole isEqual:aMembersSetPermissionsArg.dNewRole]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersSetPermissionsArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersSetPermissionsArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"user"] = [DBTEAMUserSelectorArgSerializer serialize:valueObj.user];
  jsonDict[@"new_role"] = [DBTEAMAdminTierSerializer serialize:valueObj.dNewRole];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersSetPermissionsArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMUserSelectorArg *user = [DBTEAMUserSelectorArgSerializer deserialize:valueDict[@"user"]];
  DBTEAMAdminTier *dNewRole = [DBTEAMAdminTierSerializer deserialize:valueDict[@"new_role"]];

  return [[DBTEAMMembersSetPermissionsArg alloc] initWithUser:user dNewRole:dNewRole];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMembersSetPermissionsError.h"
#import "DBTEAMUserSelectorError.h"

#pragma mark - API Object

@implementation DBTEAMMembersSetPermissionsError

#pragma mark - Constructors

- (instancetype)initWithUserNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersSetPermissionsErrorUserNotFound;
  }
  return self;
}

- (instancetype)initWithLastAdmin {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersSetPermissionsErrorLastAdmin;
  }
  return self;
}

- (instancetype)initWithUserNotInTeam {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersSetPermissionsErrorUserNotInTeam;
  }
  return self;
}

- (instancetype)initWithCannotSetPermissions {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersSetPermissionsErrorCannotSetPermissions;
  }
  return self;
}

- (instancetype)initWithTeamLicenseLimit {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersSetPermissionsErrorTeamLicenseLimit;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersSetPermissionsErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isUserNotFound {
  return _tag == DBTEAMMembersSetPermissionsErrorUserNotFound;
}

- (BOOL)isLastAdmin {
  return _tag == DBTEAMMembersSetPermissionsErrorLastAdmin;
}

- (BOOL)isUserNotInTeam {
  return _tag == DBTEAMMembersSetPermissionsErrorUserNotInTeam;
}

- (BOOL)isCannotSetPermissions {
  return _tag == DBTEAMMembersSetPermissionsErrorCannotSetPermissions;
}

- (BOOL)isTeamLicenseLimit {
  return _tag == DBTEAMMembersSetPermissionsErrorTeamLicenseLimit;
}

- (BOOL)isOther {
  return _tag == DBTEAMMembersSetPermissionsErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMMembersSetPermissionsErrorUserNotFound:
    return @"DBTEAMMembersSetPermissionsErrorUserNotFound";
  case DBTEAMMembersSetPermissionsErrorLastAdmin:
    return @"DBTEAMMembersSetPermissionsErrorLastAdmin";
  case DBTEAMMembersSetPermissionsErrorUserNotInTeam:
    return @"DBTEAMMembersSetPermissionsErrorUserNotInTeam";
  case DBTEAMMembersSetPermissionsErrorCannotSetPermissions:
    return @"DBTEAMMembersSetPermissionsErrorCannotSetPermissions";
  case DBTEAMMembersSetPermissionsErrorTeamLicenseLimit:
    return @"DBTEAMMembersSetPermissionsErrorTeamLicenseLimit";
  case DBTEAMMembersSetPermissionsErrorOther:
    return @"DBTEAMMembersSetPermissionsErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersSetPermissionsErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersSetPermissionsErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersSetPermissionsErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMMembersSetPermissionsErrorUserNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersSetPermissionsErrorLastAdmin:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersSetPermissionsErrorUserNotInTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersSetPermissionsErrorCannotSetPermissions:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersSetPermissionsErrorTeamLicenseLimit:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersSetPermissionsErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersSetPermissionsError:other];
}

- (BOOL)isEqualToMembersSetPermissionsError:(DBTEAMMembersSetPermissionsError *)aMembersSetPermissionsError {
  if (self == aMembersSetPermissionsError) {
    return YES;
  }
  if (self.tag != aMembersSetPermissionsError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMMembersSetPermissionsErrorUserNotFound:
    return [[self tagName] isEqual:[aMembersSetPermissionsError tagName]];
  case DBTEAMMembersSetPermissionsErrorLastAdmin:
    return [[self tagName] isEqual:[aMembersSetPermissionsError tagName]];
  case DBTEAMMembersSetPermissionsErrorUserNotInTeam:
    return [[self tagName] isEqual:[aMembersSetPermissionsError tagName]];
  case DBTEAMMembersSetPermissionsErrorCannotSetPermissions:
    return [[self tagName] isEqual:[aMembersSetPermissionsError tagName]];
  case DBTEAMMembersSetPermissionsErrorTeamLicenseLimit:
    return [[self tagName] isEqual:[aMembersSetPermissionsError tagName]];
  case DBTEAMMembersSetPermissionsErrorOther:
    return [[self tagName] isEqual:[aMembersSetPermissionsError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersSetPermissionsErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersSetPermissionsError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUserNotFound]) {
    jsonDict[@".tag"] = @"user_not_found";
  } else if ([valueObj isLastAdmin]) {
    jsonDict[@".tag"] = @"last_admin";
  } else if ([valueObj isUserNotInTeam]) {
    jsonDict[@".tag"] = @"user_not_in_team";
  } else if ([valueObj isCannotSetPermissions]) {
    jsonDict[@".tag"] = @"cannot_set_permissions";
  } else if ([valueObj isTeamLicenseLimit]) {
    jsonDict[@".tag"] = @"team_license_limit";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersSetPermissionsError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"user_not_found"]) {
    return [[DBTEAMMembersSetPermissionsError alloc] initWithUserNotFound];
  } else if ([tag isEqualToString:@"last_admin"]) {
    return [[DBTEAMMembersSetPermissionsError alloc] initWithLastAdmin];
  } else if ([tag isEqualToString:@"user_not_in_team"]) {
    return [[DBTEAMMembersSetPermissionsError alloc] initWithUserNotInTeam];
  } else if ([tag isEqualToString:@"cannot_set_permissions"]) {
    return [[DBTEAMMembersSetPermissionsError alloc] initWithCannotSetPermissions];
  } else if ([tag isEqualToString:@"team_license_limit"]) {
    return [[DBTEAMMembersSetPermissionsError alloc] initWithTeamLicenseLimit];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMMembersSetPermissionsError alloc] initWithOther];
  } else {
    return [[DBTEAMMembersSetPermissionsError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMAdminTier.h"
#import "DBTEAMMembersSetPermissionsResult.h"

#pragma mark - API Object

@implementation DBTEAMMembersSetPermissionsResult

#pragma mark - Constructors

- (instancetype)initWithTeamMemberId:(NSString *)teamMemberId role:(DBTEAMAdminTier *)role {
  [DBStoneValidators nonnullValidator:nil](teamMemberId);
  [DBStoneValidators nonnullValidator:nil](role);

  self = [super init];
  if (self) {
    _teamMemberId = teamMemberId;
    _role = role;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersSetPermissionsResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersSetPermissionsResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersSetPermissionsResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.teamMemberId hash];
  result = prime * result + [self.role hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersSetPermissionsResult:other];
}

- (BOOL)isEqualToMembersSetPermissionsResult:(DBTEAMMembersSetPermissionsResult *)aMembersSetPermissionsResult {
  if (self == aMembersSetPermissionsResult) {
    return YES;
  }
  if (![self.teamMemberId isEqual:aMembersSetPermissionsResult.teamMemberId]) {
    return NO;
  }
  if (![self.role isEqual:aMembersSetPermissionsResult.role]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersSetPermissionsResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersSetPermissionsResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"team_member_id"] = valueObj.teamMemberId;
  jsonDict[@"role"] = [DBTEAMAdminTierSerializer serialize:valueObj.role];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersSetPermissionsResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *teamMemberId = valueDict[@"team_member_id"];
  DBTEAMAdminTier *role = [DBTEAMAdminTierSerializer deserialize:valueDict[@"role"]];

  return [[DBTEAMMembersSetPermissionsResult alloc] initWithTeamMemberId:teamMemberId role:role];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMembersSetProfileArg.h"
#import "DBTEAMUserSelectorArg.h"

#pragma mark - API Object

@implementation DBTEAMMembersSetProfileArg

#pragma mark - Constructors

- (instancetype)initWithUser:(DBTEAMUserSelectorArg *)user
                    dNewEmail:(NSString *)dNewEmail
               dNewExternalId:(NSString *)dNewExternalId
                dNewGivenName:(NSString *)dNewGivenName
                  dNewSurname:(NSString *)dNewSurname
             dNewPersistentId:(NSString *)dNewPersistentId
    dNewIsDirectoryRestricted:(NSNumber *)dNewIsDirectoryRestricted {
  [DBStoneValidators nonnullValidator:nil](user);
  [DBStoneValidators nullableValidator:[DBStoneValidators stringValidator:nil
                                                                maxLength:@(255)
                                                                  pattern:@"^['&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-"
                                                                          @"9.-]*\\.[A-Za-z]{2,15}$"]](dNewEmail);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators stringValidator:nil maxLength:@(64) pattern:nil]](dNewExternalId);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators stringValidator:nil maxLength:@(100) pattern:@"[^/:?*<>\"|]*"]](dNewGivenName);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators stringValidator:nil maxLength:@(100) pattern:@"[^/:?*<>\"|]*"]](dNewSurname);

  self = [super init];
  if (self) {
    _user = user;
    _dNewEmail = dNewEmail;
    _dNewExternalId = dNewExternalId;
    _dNewGivenName = dNewGivenName;
    _dNewSurname = dNewSurname;
    _dNewPersistentId = dNewPersistentId;
    _dNewIsDirectoryRestricted = dNewIsDirectoryRestricted;
  }
  return self;
}

- (instancetype)initWithUser:(DBTEAMUserSelectorArg *)user {
  return [self initWithUser:user
                      dNewEmail:nil
                 dNewExternalId:nil
                  dNewGivenName:nil
                    dNewSurname:nil
               dNewPersistentId:nil
      dNewIsDirectoryRestricted:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersSetProfileArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersSetProfileArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersSetProfileArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.user hash];
  if (self.dNewEmail != nil) {
    result = prime * result + [self.dNewEmail hash];
  }
  if (self.dNewExternalId != nil) {
    result = prime * result + [self.dNewExternalId hash];
  }
  if (self.dNewGivenName != nil) {
    result = prime * result + [self.dNewGivenName hash];
  }
  if (self.dNewSurname != nil) {
    result = prime * result + [self.dNewSurname hash];
  }
  if (self.dNewPersistentId != nil) {
    result = prime * result + [self.dNewPersistentId hash];
  }
  if (self.dNewIsDirectoryRestricted != nil) {
    result = prime * result + [self.dNewIsDirectoryRestricted hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersSetProfileArg:other];
}

- (BOOL)isEqualToMembersSetProfileArg:(DBTEAMMembersSetProfileArg *)aMembersSetProfileArg {
  if (self == aMembersSetProfileArg) {
    return YES;
  }
  if (![self.user isEqual:aMembersSetProfileArg.user]) {
    return NO;
  }
  if (self.dNewEmail) {
    if (![self.dNewEmail isEqual:aMembersSetProfileArg.dNewEmail]) {
      return NO;
    }
  }
  if (self.dNewExternalId) {
    if (![self.dNewExternalId isEqual:aMembersSetProfileArg.dNewExternalId]) {
      return NO;
    }
  }
  if (self.dNewGivenName) {
    if (![self.dNewGivenName isEqual:aMembersSetProfileArg.dNewGivenName]) {
      return NO;
    }
  }
  if (self.dNewSurname) {
    if (![self.dNewSurname isEqual:aMembersSetProfileArg.dNewSurname]) {
      return NO;
    }
  }
  if (self.dNewPersistentId) {
    if (![self.dNewPersistentId isEqual:aMembersSetProfileArg.dNewPersistentId]) {
      return NO;
    }
  }
  if (self.dNewIsDirectoryRestricted) {
    if (![self.dNewIsDirectoryRestricted isEqual:aMembersSetProfileArg.dNewIsDirectoryRestricted]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersSetProfileArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersSetProfileArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"user"] = [DBTEAMUserSelectorArgSerializer serialize:valueObj.user];
  if (valueObj.dNewEmail) {
    jsonDict[@"new_email"] = valueObj.dNewEmail;
  }
  if (valueObj.dNewExternalId) {
    jsonDict[@"new_external_id"] = valueObj.dNewExternalId;
  }
  if (valueObj.dNewGivenName) {
    jsonDict[@"new_given_name"] = valueObj.dNewGivenName;
  }
  if (valueObj.dNewSurname) {
    jsonDict[@"new_surname"] = valueObj.dNewSurname;
  }
  if (valueObj.dNewPersistentId) {
    jsonDict[@"new_persistent_id"] = valueObj.dNewPersistentId;
  }
  if (valueObj.dNewIsDirectoryRestricted) {
    jsonDict[@"new_is_directory_restricted"] = valueObj.dNewIsDirectoryRestricted;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersSetProfileArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMUserSelectorArg *user = [DBTEAMUserSelectorArgSerializer deserialize:valueDict[@"user"]];
  NSString *dNewEmail = valueDict[@"new_email"] ?: nil;
  NSString *dNewExternalId = valueDict[@"new_external_id"] ?: nil;
  NSString *dNewGivenName = valueDict[@"new_given_name"] ?: nil;
  NSString *dNewSurname = valueDict[@"new_surname"] ?: nil;
  NSString *dNewPersistentId = valueDict[@"new_persistent_id"] ?: nil;
  NSNumber *dNewIsDirectoryRestricted = valueDict[@"new_is_directory_restricted"] ?: nil;

  return [[DBTEAMMembersSetProfileArg alloc] initWithUser:user
                                                dNewEmail:dNewEmail
                                           dNewExternalId:dNewExternalId
                                            dNewGivenName:dNewGivenName
                                              dNewSurname:dNewSurname
                                         dNewPersistentId:dNewPersistentId
                                dNewIsDirectoryRestricted:dNewIsDirectoryRestricted];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMemberSelectorError.h"
#import "DBTEAMMembersSetProfileError.h"

#pragma mark - API Object

@implementation DBTEAMMembersSetProfileError

#pragma mark - Constructors

- (instancetype)initWithUserNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersSetProfileErrorUserNotFound;
  }
  return self;
}

- (instancetype)initWithUserNotInTeam {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersSetProfileErrorUserNotInTeam;
  }
  return self;
}

- (instancetype)initWithExternalIdAndNewExternalIdUnsafe {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersSetProfileErrorExternalIdAndNewExternalIdUnsafe;
  }
  return self;
}

- (instancetype)initWithNoNewDataSpecified {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersSetProfileErrorNoNewDataSpecified;
  }
  return self;
}

- (instancetype)initWithEmailReservedForOtherUser {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersSetProfileErrorEmailReservedForOtherUser;
  }
  return self;
}

- (instancetype)initWithExternalIdUsedByOtherUser {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersSetProfileErrorExternalIdUsedByOtherUser;
  }
  return self;
}

- (instancetype)initWithSetProfileDisallowed {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersSetProfileErrorSetProfileDisallowed;
  }
  return self;
}

- (instancetype)initWithParamCannotBeEmpty {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersSetProfileErrorParamCannotBeEmpty;
  }
  return self;
}

- (instancetype)initWithPersistentIdDisabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersSetProfileErrorPersistentIdDisabled;
  }
  return self;
}

- (instancetype)initWithPersistentIdUsedByOtherUser {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersSetProfileErrorPersistentIdUsedByOtherUser;
  }
  return self;
}

- (instancetype)initWithDirectoryRestrictedOff {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersSetProfileErrorDirectoryRestrictedOff;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersSetProfileErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isUserNotFound {
  return _tag == DBTEAMMembersSetProfileErrorUserNotFound;
}

- (BOOL)isUserNotInTeam {
  return _tag == DBTEAMMembersSetProfileErrorUserNotInTeam;
}

- (BOOL)isExternalIdAndNewExternalIdUnsafe {
  return _tag == DBTEAMMembersSetProfileErrorExternalIdAndNewExternalIdUnsafe;
}

- (BOOL)isNoNewDataSpecified {
  return _tag == DBTEAMMembersSetProfileErrorNoNewDataSpecified;
}

- (BOOL)isEmailReservedForOtherUser {
  return _tag == DBTEAMMembersSetProfileErrorEmailReservedForOtherUser;
}

- (BOOL)isExternalIdUsedByOtherUser {
  return _tag == DBTEAMMembersSetProfileErrorExternalIdUsedByOtherUser;
}

- (BOOL)isSetProfileDisallowed {
  return _tag == DBTEAMMembersSetProfileErrorSetProfileDisallowed;
}

- (BOOL)isParamCannotBeEmpty {
  return _tag == DBTEAMMembersSetProfileErrorParamCannotBeEmpty;
}

- (BOOL)isPersistentIdDisabled {
  return _tag == DBTEAMMembersSetProfileErrorPersistentIdDisabled;
}

- (BOOL)isPersistentIdUsedByOtherUser {
  return _tag == DBTEAMMembersSetProfileErrorPersistentIdUsedByOtherUser;
}

- (BOOL)isDirectoryRestrictedOff {
  return _tag == DBTEAMMembersSetProfileErrorDirectoryRestrictedOff;
}

- (BOOL)isOther {
  return _tag == DBTEAMMembersSetProfileErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMMembersSetProfileErrorUserNotFound:
    return @"DBTEAMMembersSetProfileErrorUserNotFound";
  case DBTEAMMembersSetProfileErrorUserNotInTeam:
    return @"DBTEAMMembersSetProfileErrorUserNotInTeam";
  case DBTEAMMembersSetProfileErrorExternalIdAndNewExternalIdUnsafe:
    return @"DBTEAMMembersSetProfileErrorExternalIdAndNewExternalIdUnsafe";
  case DBTEAMMembersSetProfileErrorNoNewDataSpecified:
    return @"DBTEAMMembersSetProfileErrorNoNewDataSpecified";
  case DBTEAMMembersSetProfileErrorEmailReservedForOtherUser:
    return @"DBTEAMMembersSetProfileErrorEmailReservedForOtherUser";
  case DBTEAMMembersSetProfileErrorExternalIdUsedByOtherUser:
    return @"DBTEAMMembersSetProfileErrorExternalIdUsedByOtherUser";
  case DBTEAMMembersSetProfileErrorSetProfileDisallowed:
    return @"DBTEAMMembersSetProfileErrorSetProfileDisallowed";
  case DBTEAMMembersSetProfileErrorParamCannotBeEmpty:
    return @"DBTEAMMembersSetProfileErrorParamCannotBeEmpty";
  case DBTEAMMembersSetProfileErrorPersistentIdDisabled:
    return @"DBTEAMMembersSetProfileErrorPersistentIdDisabled";
  case DBTEAMMembersSetProfileErrorPersistentIdUsedByOtherUser:
    return @"DBTEAMMembersSetProfileErrorPersistentIdUsedByOtherUser";
  case DBTEAMMembersSetProfileErrorDirectoryRestrictedOff:
    return @"DBTEAMMembersSetProfileErrorDirectoryRestrictedOff";
  case DBTEAMMembersSetProfileErrorOther:
    return @"DBTEAMMembersSetProfileErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersSetProfileErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersSetProfileErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersSetProfileErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMMembersSetProfileErrorUserNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersSetProfileErrorUserNotInTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersSetProfileErrorExternalIdAndNewExternalIdUnsafe:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersSetProfileErrorNoNewDataSpecified:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersSetProfileErrorEmailReservedForOtherUser:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersSetProfileErrorExternalIdUsedByOtherUser:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersSetProfileErrorSetProfileDisallowed:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersSetProfileErrorParamCannotBeEmpty:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersSetProfileErrorPersistentIdDisabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersSetProfileErrorPersistentIdUsedByOtherUser:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersSetProfileErrorDirectoryRestrictedOff:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersSetProfileErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersSetProfileError:other];
}

- (BOOL)isEqualToMembersSetProfileError:(DBTEAMMembersSetProfileError *)aMembersSetProfileError {
  if (self == aMembersSetProfileError) {
    return YES;
  }
  if (self.tag != aMembersSetProfileError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMMembersSetProfileErrorUserNotFound:
    return [[self tagName] isEqual:[aMembersSetProfileError tagName]];
  case DBTEAMMembersSetProfileErrorUserNotInTeam:
    return [[self tagName] isEqual:[aMembersSetProfileError tagName]];
  case DBTEAMMembersSetProfileErrorExternalIdAndNewExternalIdUnsafe:
    return [[self tagName] isEqual:[aMembersSetProfileError tagName]];
  case DBTEAMMembersSetProfileErrorNoNewDataSpecified:
    return [[self tagName] isEqual:[aMembersSetProfileError tagName]];
  case DBTEAMMembersSetProfileErrorEmailReservedForOtherUser:
    return [[self tagName] isEqual:[aMembersSetProfileError tagName]];
  case DBTEAMMembersSetProfileErrorExternalIdUsedByOtherUser:
    return [[self tagName] isEqual:[aMembersSetProfileError tagName]];
  case DBTEAMMembersSetProfileErrorSetProfileDisallowed:
    return [[self tagName] isEqual:[aMembersSetProfileError tagName]];
  case DBTEAMMembersSetProfileErrorParamCannotBeEmpty:
    return [[self tagName] isEqual:[aMembersSetProfileError tagName]];
  case DBTEAMMembersSetProfileErrorPersistentIdDisabled:
    return [[self tagName] isEqual:[aMembersSetProfileError tagName]];
  case DBTEAMMembersSetProfileErrorPersistentIdUsedByOtherUser:
    return [[self tagName] isEqual:[aMembersSetProfileError tagName]];
  case DBTEAMMembersSetProfileErrorDirectoryRestrictedOff:
    return [[self tagName] isEqual:[aMembersSetProfileError tagName]];
  case DBTEAMMembersSetProfileErrorOther:
    return [[self tagName] isEqual:[aMembersSetProfileError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersSetProfileErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersSetProfileError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUserNotFound]) {
    jsonDict[@".tag"] = @"user_not_found";
  } else if ([valueObj isUserNotInTeam]) {
    jsonDict[@".tag"] = @"user_not_in_team";
  } else if ([valueObj isExternalIdAndNewExternalIdUnsafe]) {
    jsonDict[@".tag"] = @"external_id_and_new_external_id_unsafe";
  } else if ([valueObj isNoNewDataSpecified]) {
    jsonDict[@".tag"] = @"no_new_data_specified";
  } else if ([valueObj isEmailReservedForOtherUser]) {
    jsonDict[@".tag"] = @"email_reserved_for_other_user";
  } else if ([valueObj isExternalIdUsedByOtherUser]) {
    jsonDict[@".tag"] = @"external_id_used_by_other_user";
  } else if ([valueObj isSetProfileDisallowed]) {
    jsonDict[@".tag"] = @"set_profile_disallowed";
  } else if ([valueObj isParamCannotBeEmpty]) {
    jsonDict[@".tag"] = @"param_cannot_be_empty";
  } else if ([valueObj isPersistentIdDisabled]) {
    jsonDict[@".tag"] = @"persistent_id_disabled";
  } else if ([valueObj isPersistentIdUsedByOtherUser]) {
    jsonDict[@".tag"] = @"persistent_id_used_by_other_user";
  } else if ([valueObj isDirectoryRestrictedOff]) {
    jsonDict[@".tag"] = @"directory_restricted_off";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersSetProfileError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"user_not_found"]) {
    return [[DBTEAMMembersSetProfileError alloc] initWithUserNotFound];
  } else if ([tag isEqualToString:@"user_not_in_team"]) {
    return [[DBTEAMMembersSetProfileError alloc] initWithUserNotInTeam];
  } else if ([tag isEqualToString:@"external_id_and_new_external_id_unsafe"]) {
    return [[DBTEAMMembersSetProfileError alloc] initWithExternalIdAndNewExternalIdUnsafe];
  } else if ([tag isEqualToString:@"no_new_data_specified"]) {
    return [[DBTEAMMembersSetProfileError alloc] initWithNoNewDataSpecified];
  } else if ([tag isEqualToString:@"email_reserved_for_other_user"]) {
    return [[DBTEAMMembersSetProfileError alloc] initWithEmailReservedForOtherUser];
  } else if ([tag isEqualToString:@"external_id_used_by_other_user"]) {
    return [[DBTEAMMembersSetProfileError alloc] initWithExternalIdUsedByOtherUser];
  } else if ([tag isEqualToString:@"set_profile_disallowed"]) {
    return [[DBTEAMMembersSetProfileError alloc] initWithSetProfileDisallowed];
  } else if ([tag isEqualToString:@"param_cannot_be_empty"]) {
    return [[DBTEAMMembersSetProfileError alloc] initWithParamCannotBeEmpty];
  } else if ([tag isEqualToString:@"persistent_id_disabled"]) {
    return [[DBTEAMMembersSetProfileError alloc] initWithPersistentIdDisabled];
  } else if ([tag isEqualToString:@"persistent_id_used_by_other_user"]) {
    return [[DBTEAMMembersSetProfileError alloc] initWithPersistentIdUsedByOtherUser];
  } else if ([tag isEqualToString:@"directory_restricted_off"]) {
    return [[DBTEAMMembersSetProfileError alloc] initWithDirectoryRestrictedOff];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMMembersSetProfileError alloc] initWithOther];
  } else {
    return [[DBTEAMMembersSetProfileError alloc] initWithOther];
  }
}

@end

#import "DBACCOUNTPhotoSourceArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMembersSetProfilePhotoArg.h"
#import "DBTEAMUserSelectorArg.h"

#pragma mark - API Object

@implementation DBTEAMMembersSetProfilePhotoArg

#pragma mark - Constructors

- (instancetype)initWithUser:(DBTEAMUserSelectorArg *)user photo:(DBACCOUNTPhotoSourceArg *)photo {
  [DBStoneValidators nonnullValidator:nil](user);
  [DBStoneValidators nonnullValidator:nil](photo);

  self = [super init];
  if (self) {
    _user = user;
    _photo = photo;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersSetProfilePhotoArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersSetProfilePhotoArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersSetProfilePhotoArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.user hash];
  result = prime * result + [self.photo hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersSetProfilePhotoArg:other];
}

- (BOOL)isEqualToMembersSetProfilePhotoArg:(DBTEAMMembersSetProfilePhotoArg *)aMembersSetProfilePhotoArg {
  if (self == aMembersSetProfilePhotoArg) {
    return YES;
  }
  if (![self.user isEqual:aMembersSetProfilePhotoArg.user]) {
    return NO;
  }
  if (![self.photo isEqual:aMembersSetProfilePhotoArg.photo]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersSetProfilePhotoArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersSetProfilePhotoArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"user"] = [DBTEAMUserSelectorArgSerializer serialize:valueObj.user];
  jsonDict[@"photo"] = [DBACCOUNTPhotoSourceArgSerializer serialize:valueObj.photo];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersSetProfilePhotoArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMUserSelectorArg *user = [DBTEAMUserSelectorArgSerializer deserialize:valueDict[@"user"]];
  DBACCOUNTPhotoSourceArg *photo = [DBACCOUNTPhotoSourceArgSerializer deserialize:valueDict[@"photo"]];

  return [[DBTEAMMembersSetProfilePhotoArg alloc] initWithUser:user photo:photo];
}

@end

#import "DBACCOUNTSetProfilePhotoError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMemberSelectorError.h"
#import "DBTEAMMembersSetProfilePhotoError.h"

#pragma mark - API Object

@implementation DBTEAMMembersSetProfilePhotoError

@synthesize photoError = _photoError;

#pragma mark - Constructors

- (instancetype)initWithUserNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersSetProfilePhotoErrorUserNotFound;
  }
  return self;
}

- (instancetype)initWithUserNotInTeam {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersSetProfilePhotoErrorUserNotInTeam;
  }
  return self;
}

- (instancetype)initWithSetProfileDisallowed {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersSetProfilePhotoErrorSetProfileDisallowed;
  }
  return self;
}

- (instancetype)initWithPhotoError:(DBACCOUNTSetProfilePhotoError *)photoError {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersSetProfilePhotoErrorPhotoError;
    _photoError = photoError;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersSetProfilePhotoErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBACCOUNTSetProfilePhotoError *)photoError {
  if (![self isPhotoError]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMMembersSetProfilePhotoErrorPhotoError, but was %@.", [self tagName]];
  }
  return _photoError;
}

#pragma mark - Tag state methods

- (BOOL)isUserNotFound {
  return _tag == DBTEAMMembersSetProfilePhotoErrorUserNotFound;
}

- (BOOL)isUserNotInTeam {
  return _tag == DBTEAMMembersSetProfilePhotoErrorUserNotInTeam;
}

- (BOOL)isSetProfileDisallowed {
  return _tag == DBTEAMMembersSetProfilePhotoErrorSetProfileDisallowed;
}

- (BOOL)isPhotoError {
  return _tag == DBTEAMMembersSetProfilePhotoErrorPhotoError;
}

- (BOOL)isOther {
  return _tag == DBTEAMMembersSetProfilePhotoErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMMembersSetProfilePhotoErrorUserNotFound:
    return @"DBTEAMMembersSetProfilePhotoErrorUserNotFound";
  case DBTEAMMembersSetProfilePhotoErrorUserNotInTeam:
    return @"DBTEAMMembersSetProfilePhotoErrorUserNotInTeam";
  case DBTEAMMembersSetProfilePhotoErrorSetProfileDisallowed:
    return @"DBTEAMMembersSetProfilePhotoErrorSetProfileDisallowed";
  case DBTEAMMembersSetProfilePhotoErrorPhotoError:
    return @"DBTEAMMembersSetProfilePhotoErrorPhotoError";
  case DBTEAMMembersSetProfilePhotoErrorOther:
    return @"DBTEAMMembersSetProfilePhotoErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersSetProfilePhotoErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersSetProfilePhotoErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersSetProfilePhotoErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMMembersSetProfilePhotoErrorUserNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersSetProfilePhotoErrorUserNotInTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersSetProfilePhotoErrorSetProfileDisallowed:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersSetProfilePhotoErrorPhotoError:
    result = prime * result + [self.photoError hash];
    break;
  case DBTEAMMembersSetProfilePhotoErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersSetProfilePhotoError:other];
}

- (BOOL)isEqualToMembersSetProfilePhotoError:(DBTEAMMembersSetProfilePhotoError *)aMembersSetProfilePhotoError {
  if (self == aMembersSetProfilePhotoError) {
    return YES;
  }
  if (self.tag != aMembersSetProfilePhotoError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMMembersSetProfilePhotoErrorUserNotFound:
    return [[self tagName] isEqual:[aMembersSetProfilePhotoError tagName]];
  case DBTEAMMembersSetProfilePhotoErrorUserNotInTeam:
    return [[self tagName] isEqual:[aMembersSetProfilePhotoError tagName]];
  case DBTEAMMembersSetProfilePhotoErrorSetProfileDisallowed:
    return [[self tagName] isEqual:[aMembersSetProfilePhotoError tagName]];
  case DBTEAMMembersSetProfilePhotoErrorPhotoError:
    return [self.photoError isEqual:aMembersSetProfilePhotoError.photoError];
  case DBTEAMMembersSetProfilePhotoErrorOther:
    return [[self tagName] isEqual:[aMembersSetProfilePhotoError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersSetProfilePhotoErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersSetProfilePhotoError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUserNotFound]) {
    jsonDict[@".tag"] = @"user_not_found";
  } else if ([valueObj isUserNotInTeam]) {
    jsonDict[@".tag"] = @"user_not_in_team";
  } else if ([valueObj isSetProfileDisallowed]) {
    jsonDict[@".tag"] = @"set_profile_disallowed";
  } else if ([valueObj isPhotoError]) {
    jsonDict[@"photo_error"] = [[DBACCOUNTSetProfilePhotoErrorSerializer serialize:valueObj.photoError] mutableCopy];
    jsonDict[@".tag"] = @"photo_error";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersSetProfilePhotoError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"user_not_found"]) {
    return [[DBTEAMMembersSetProfilePhotoError alloc] initWithUserNotFound];
  } else if ([tag isEqualToString:@"user_not_in_team"]) {
    return [[DBTEAMMembersSetProfilePhotoError alloc] initWithUserNotInTeam];
  } else if ([tag isEqualToString:@"set_profile_disallowed"]) {
    return [[DBTEAMMembersSetProfilePhotoError alloc] initWithSetProfileDisallowed];
  } else if ([tag isEqualToString:@"photo_error"]) {
    DBACCOUNTSetProfilePhotoError *photoError =
        [DBACCOUNTSetProfilePhotoErrorSerializer deserialize:valueDict[@"photo_error"]];
    return [[DBTEAMMembersSetProfilePhotoError alloc] initWithPhotoError:photoError];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMMembersSetProfilePhotoError alloc] initWithOther];
  } else {
    return [[DBTEAMMembersSetProfilePhotoError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMembersDeactivateError.h"
#import "DBTEAMMembersSuspendError.h"

#pragma mark - API Object

@implementation DBTEAMMembersSuspendError

#pragma mark - Constructors

- (instancetype)initWithUserNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersSuspendErrorUserNotFound;
  }
  return self;
}

- (instancetype)initWithUserNotInTeam {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersSuspendErrorUserNotInTeam;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersSuspendErrorOther;
  }
  return self;
}

- (instancetype)initWithSuspendInactiveUser {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersSuspendErrorSuspendInactiveUser;
  }
  return self;
}

- (instancetype)initWithSuspendLastAdmin {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersSuspendErrorSuspendLastAdmin;
  }
  return self;
}

- (instancetype)initWithTeamLicenseLimit {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersSuspendErrorTeamLicenseLimit;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isUserNotFound {
  return _tag == DBTEAMMembersSuspendErrorUserNotFound;
}

- (BOOL)isUserNotInTeam {
  return _tag == DBTEAMMembersSuspendErrorUserNotInTeam;
}

- (BOOL)isOther {
  return _tag == DBTEAMMembersSuspendErrorOther;
}

- (BOOL)isSuspendInactiveUser {
  return _tag == DBTEAMMembersSuspendErrorSuspendInactiveUser;
}

- (BOOL)isSuspendLastAdmin {
  return _tag == DBTEAMMembersSuspendErrorSuspendLastAdmin;
}

- (BOOL)isTeamLicenseLimit {
  return _tag == DBTEAMMembersSuspendErrorTeamLicenseLimit;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMMembersSuspendErrorUserNotFound:
    return @"DBTEAMMembersSuspendErrorUserNotFound";
  case DBTEAMMembersSuspendErrorUserNotInTeam:
    return @"DBTEAMMembersSuspendErrorUserNotInTeam";
  case DBTEAMMembersSuspendErrorOther:
    return @"DBTEAMMembersSuspendErrorOther";
  case DBTEAMMembersSuspendErrorSuspendInactiveUser:
    return @"DBTEAMMembersSuspendErrorSuspendInactiveUser";
  case DBTEAMMembersSuspendErrorSuspendLastAdmin:
    return @"DBTEAMMembersSuspendErrorSuspendLastAdmin";
  case DBTEAMMembersSuspendErrorTeamLicenseLimit:
    return @"DBTEAMMembersSuspendErrorTeamLicenseLimit";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersSuspendErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersSuspendErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersSuspendErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMMembersSuspendErrorUserNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersSuspendErrorUserNotInTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersSuspendErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersSuspendErrorSuspendInactiveUser:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersSuspendErrorSuspendLastAdmin:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersSuspendErrorTeamLicenseLimit:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersSuspendError:other];
}

- (BOOL)isEqualToMembersSuspendError:(DBTEAMMembersSuspendError *)aMembersSuspendError {
  if (self == aMembersSuspendError) {
    return YES;
  }
  if (self.tag != aMembersSuspendError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMMembersSuspendErrorUserNotFound:
    return [[self tagName] isEqual:[aMembersSuspendError tagName]];
  case DBTEAMMembersSuspendErrorUserNotInTeam:
    return [[self tagName] isEqual:[aMembersSuspendError tagName]];
  case DBTEAMMembersSuspendErrorOther:
    return [[self tagName] isEqual:[aMembersSuspendError tagName]];
  case DBTEAMMembersSuspendErrorSuspendInactiveUser:
    return [[self tagName] isEqual:[aMembersSuspendError tagName]];
  case DBTEAMMembersSuspendErrorSuspendLastAdmin:
    return [[self tagName] isEqual:[aMembersSuspendError tagName]];
  case DBTEAMMembersSuspendErrorTeamLicenseLimit:
    return [[self tagName] isEqual:[aMembersSuspendError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersSuspendErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersSuspendError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUserNotFound]) {
    jsonDict[@".tag"] = @"user_not_found";
  } else if ([valueObj isUserNotInTeam]) {
    jsonDict[@".tag"] = @"user_not_in_team";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isSuspendInactiveUser]) {
    jsonDict[@".tag"] = @"suspend_inactive_user";
  } else if ([valueObj isSuspendLastAdmin]) {
    jsonDict[@".tag"] = @"suspend_last_admin";
  } else if ([valueObj isTeamLicenseLimit]) {
    jsonDict[@".tag"] = @"team_license_limit";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersSuspendError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"user_not_found"]) {
    return [[DBTEAMMembersSuspendError alloc] initWithUserNotFound];
  } else if ([tag isEqualToString:@"user_not_in_team"]) {
    return [[DBTEAMMembersSuspendError alloc] initWithUserNotInTeam];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMMembersSuspendError alloc] initWithOther];
  } else if ([tag isEqualToString:@"suspend_inactive_user"]) {
    return [[DBTEAMMembersSuspendError alloc] initWithSuspendInactiveUser];
  } else if ([tag isEqualToString:@"suspend_last_admin"]) {
    return [[DBTEAMMembersSuspendError alloc] initWithSuspendLastAdmin];
  } else if ([tag isEqualToString:@"team_license_limit"]) {
    return [[DBTEAMMembersSuspendError alloc] initWithTeamLicenseLimit];
  } else {
    return [[DBTEAMMembersSuspendError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMembersTransferFilesError.h"
#import "DBTEAMMembersTransferFormerMembersFilesError.h"

#pragma mark - API Object

@implementation DBTEAMMembersTransferFormerMembersFilesError

#pragma mark - Constructors

- (instancetype)initWithUserNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersTransferFormerMembersFilesErrorUserNotFound;
  }
  return self;
}

- (instancetype)initWithUserNotInTeam {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersTransferFormerMembersFilesErrorUserNotInTeam;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersTransferFormerMembersFilesErrorOther;
  }
  return self;
}

- (instancetype)initWithRemovedAndTransferDestShouldDiffer {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersTransferFormerMembersFilesErrorRemovedAndTransferDestShouldDiffer;
  }
  return self;
}

- (instancetype)initWithRemovedAndTransferAdminShouldDiffer {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersTransferFormerMembersFilesErrorRemovedAndTransferAdminShouldDiffer;
  }
  return self;
}

- (instancetype)initWithTransferDestUserNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersTransferFormerMembersFilesErrorTransferDestUserNotFound;
  }
  return self;
}

- (instancetype)initWithTransferDestUserNotInTeam {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersTransferFormerMembersFilesErrorTransferDestUserNotInTeam;
  }
  return self;
}

- (instancetype)initWithTransferAdminUserNotInTeam {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersTransferFormerMembersFilesErrorTransferAdminUserNotInTeam;
  }
  return self;
}

- (instancetype)initWithTransferAdminUserNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersTransferFormerMembersFilesErrorTransferAdminUserNotFound;
  }
  return self;
}

- (instancetype)initWithUnspecifiedTransferAdminId {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersTransferFormerMembersFilesErrorUnspecifiedTransferAdminId;
  }
  return self;
}

- (instancetype)initWithTransferAdminIsNotAdmin {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersTransferFormerMembersFilesErrorTransferAdminIsNotAdmin;
  }
  return self;
}

- (instancetype)initWithRecipientNotVerified {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersTransferFormerMembersFilesErrorRecipientNotVerified;
  }
  return self;
}

- (instancetype)initWithUserDataIsBeingTransferred {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersTransferFormerMembersFilesErrorUserDataIsBeingTransferred;
  }
  return self;
}

- (instancetype)initWithUserNotRemoved {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersTransferFormerMembersFilesErrorUserNotRemoved;
  }
  return self;
}

- (instancetype)initWithUserDataCannotBeTransferred {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersTransferFormerMembersFilesErrorUserDataCannotBeTransferred;
  }
  return self;
}

- (instancetype)initWithUserDataAlreadyTransferred {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersTransferFormerMembersFilesErrorUserDataAlreadyTransferred;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isUserNotFound {
  return _tag == DBTEAMMembersTransferFormerMembersFilesErrorUserNotFound;
}

- (BOOL)isUserNotInTeam {
  return _tag == DBTEAMMembersTransferFormerMembersFilesErrorUserNotInTeam;
}

- (BOOL)isOther {
  return _tag == DBTEAMMembersTransferFormerMembersFilesErrorOther;
}

- (BOOL)isRemovedAndTransferDestShouldDiffer {
  return _tag == DBTEAMMembersTransferFormerMembersFilesErrorRemovedAndTransferDestShouldDiffer;
}

- (BOOL)isRemovedAndTransferAdminShouldDiffer {
  return _tag == DBTEAMMembersTransferFormerMembersFilesErrorRemovedAndTransferAdminShouldDiffer;
}

- (BOOL)isTransferDestUserNotFound {
  return _tag == DBTEAMMembersTransferFormerMembersFilesErrorTransferDestUserNotFound;
}

- (BOOL)isTransferDestUserNotInTeam {
  return _tag == DBTEAMMembersTransferFormerMembersFilesErrorTransferDestUserNotInTeam;
}

- (BOOL)isTransferAdminUserNotInTeam {
  return _tag == DBTEAMMembersTransferFormerMembersFilesErrorTransferAdminUserNotInTeam;
}

- (BOOL)isTransferAdminUserNotFound {
  return _tag == DBTEAMMembersTransferFormerMembersFilesErrorTransferAdminUserNotFound;
}

- (BOOL)isUnspecifiedTransferAdminId {
  return _tag == DBTEAMMembersTransferFormerMembersFilesErrorUnspecifiedTransferAdminId;
}

- (BOOL)isTransferAdminIsNotAdmin {
  return _tag == DBTEAMMembersTransferFormerMembersFilesErrorTransferAdminIsNotAdmin;
}

- (BOOL)isRecipientNotVerified {
  return _tag == DBTEAMMembersTransferFormerMembersFilesErrorRecipientNotVerified;
}

- (BOOL)isUserDataIsBeingTransferred {
  return _tag == DBTEAMMembersTransferFormerMembersFilesErrorUserDataIsBeingTransferred;
}

- (BOOL)isUserNotRemoved {
  return _tag == DBTEAMMembersTransferFormerMembersFilesErrorUserNotRemoved;
}

- (BOOL)isUserDataCannotBeTransferred {
  return _tag == DBTEAMMembersTransferFormerMembersFilesErrorUserDataCannotBeTransferred;
}

- (BOOL)isUserDataAlreadyTransferred {
  return _tag == DBTEAMMembersTransferFormerMembersFilesErrorUserDataAlreadyTransferred;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMMembersTransferFormerMembersFilesErrorUserNotFound:
    return @"DBTEAMMembersTransferFormerMembersFilesErrorUserNotFound";
  case DBTEAMMembersTransferFormerMembersFilesErrorUserNotInTeam:
    return @"DBTEAMMembersTransferFormerMembersFilesErrorUserNotInTeam";
  case DBTEAMMembersTransferFormerMembersFilesErrorOther:
    return @"DBTEAMMembersTransferFormerMembersFilesErrorOther";
  case DBTEAMMembersTransferFormerMembersFilesErrorRemovedAndTransferDestShouldDiffer:
    return @"DBTEAMMembersTransferFormerMembersFilesErrorRemovedAndTransferDestShouldDiffer";
  case DBTEAMMembersTransferFormerMembersFilesErrorRemovedAndTransferAdminShouldDiffer:
    return @"DBTEAMMembersTransferFormerMembersFilesErrorRemovedAndTransferAdminShouldDiffer";
  case DBTEAMMembersTransferFormerMembersFilesErrorTransferDestUserNotFound:
    return @"DBTEAMMembersTransferFormerMembersFilesErrorTransferDestUserNotFound";
  case DBTEAMMembersTransferFormerMembersFilesErrorTransferDestUserNotInTeam:
    return @"DBTEAMMembersTransferFormerMembersFilesErrorTransferDestUserNotInTeam";
  case DBTEAMMembersTransferFormerMembersFilesErrorTransferAdminUserNotInTeam:
    return @"DBTEAMMembersTransferFormerMembersFilesErrorTransferAdminUserNotInTeam";
  case DBTEAMMembersTransferFormerMembersFilesErrorTransferAdminUserNotFound:
    return @"DBTEAMMembersTransferFormerMembersFilesErrorTransferAdminUserNotFound";
  case DBTEAMMembersTransferFormerMembersFilesErrorUnspecifiedTransferAdminId:
    return @"DBTEAMMembersTransferFormerMembersFilesErrorUnspecifiedTransferAdminId";
  case DBTEAMMembersTransferFormerMembersFilesErrorTransferAdminIsNotAdmin:
    return @"DBTEAMMembersTransferFormerMembersFilesErrorTransferAdminIsNotAdmin";
  case DBTEAMMembersTransferFormerMembersFilesErrorRecipientNotVerified:
    return @"DBTEAMMembersTransferFormerMembersFilesErrorRecipientNotVerified";
  case DBTEAMMembersTransferFormerMembersFilesErrorUserDataIsBeingTransferred:
    return @"DBTEAMMembersTransferFormerMembersFilesErrorUserDataIsBeingTransferred";
  case DBTEAMMembersTransferFormerMembersFilesErrorUserNotRemoved:
    return @"DBTEAMMembersTransferFormerMembersFilesErrorUserNotRemoved";
  case DBTEAMMembersTransferFormerMembersFilesErrorUserDataCannotBeTransferred:
    return @"DBTEAMMembersTransferFormerMembersFilesErrorUserDataCannotBeTransferred";
  case DBTEAMMembersTransferFormerMembersFilesErrorUserDataAlreadyTransferred:
    return @"DBTEAMMembersTransferFormerMembersFilesErrorUserDataAlreadyTransferred";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersTransferFormerMembersFilesErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersTransferFormerMembersFilesErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersTransferFormerMembersFilesErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMMembersTransferFormerMembersFilesErrorUserNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersTransferFormerMembersFilesErrorUserNotInTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersTransferFormerMembersFilesErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersTransferFormerMembersFilesErrorRemovedAndTransferDestShouldDiffer:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersTransferFormerMembersFilesErrorRemovedAndTransferAdminShouldDiffer:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersTransferFormerMembersFilesErrorTransferDestUserNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersTransferFormerMembersFilesErrorTransferDestUserNotInTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersTransferFormerMembersFilesErrorTransferAdminUserNotInTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersTransferFormerMembersFilesErrorTransferAdminUserNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersTransferFormerMembersFilesErrorUnspecifiedTransferAdminId:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersTransferFormerMembersFilesErrorTransferAdminIsNotAdmin:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersTransferFormerMembersFilesErrorRecipientNotVerified:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersTransferFormerMembersFilesErrorUserDataIsBeingTransferred:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersTransferFormerMembersFilesErrorUserNotRemoved:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersTransferFormerMembersFilesErrorUserDataCannotBeTransferred:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersTransferFormerMembersFilesErrorUserDataAlreadyTransferred:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersTransferFormerMembersFilesError:other];
}

- (BOOL)isEqualToMembersTransferFormerMembersFilesError:
    (DBTEAMMembersTransferFormerMembersFilesError *)aMembersTransferFormerMembersFilesError {
  if (self == aMembersTransferFormerMembersFilesError) {
    return YES;
  }
  if (self.tag != aMembersTransferFormerMembersFilesError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMMembersTransferFormerMembersFilesErrorUserNotFound:
    return [[self tagName] isEqual:[aMembersTransferFormerMembersFilesError tagName]];
  case DBTEAMMembersTransferFormerMembersFilesErrorUserNotInTeam:
    return [[self tagName] isEqual:[aMembersTransferFormerMembersFilesError tagName]];
  case DBTEAMMembersTransferFormerMembersFilesErrorOther:
    return [[self tagName] isEqual:[aMembersTransferFormerMembersFilesError tagName]];
  case DBTEAMMembersTransferFormerMembersFilesErrorRemovedAndTransferDestShouldDiffer:
    return [[self tagName] isEqual:[aMembersTransferFormerMembersFilesError tagName]];
  case DBTEAMMembersTransferFormerMembersFilesErrorRemovedAndTransferAdminShouldDiffer:
    return [[self tagName] isEqual:[aMembersTransferFormerMembersFilesError tagName]];
  case DBTEAMMembersTransferFormerMembersFilesErrorTransferDestUserNotFound:
    return [[self tagName] isEqual:[aMembersTransferFormerMembersFilesError tagName]];
  case DBTEAMMembersTransferFormerMembersFilesErrorTransferDestUserNotInTeam:
    return [[self tagName] isEqual:[aMembersTransferFormerMembersFilesError tagName]];
  case DBTEAMMembersTransferFormerMembersFilesErrorTransferAdminUserNotInTeam:
    return [[self tagName] isEqual:[aMembersTransferFormerMembersFilesError tagName]];
  case DBTEAMMembersTransferFormerMembersFilesErrorTransferAdminUserNotFound:
    return [[self tagName] isEqual:[aMembersTransferFormerMembersFilesError tagName]];
  case DBTEAMMembersTransferFormerMembersFilesErrorUnspecifiedTransferAdminId:
    return [[self tagName] isEqual:[aMembersTransferFormerMembersFilesError tagName]];
  case DBTEAMMembersTransferFormerMembersFilesErrorTransferAdminIsNotAdmin:
    return [[self tagName] isEqual:[aMembersTransferFormerMembersFilesError tagName]];
  case DBTEAMMembersTransferFormerMembersFilesErrorRecipientNotVerified:
    return [[self tagName] isEqual:[aMembersTransferFormerMembersFilesError tagName]];
  case DBTEAMMembersTransferFormerMembersFilesErrorUserDataIsBeingTransferred:
    return [[self tagName] isEqual:[aMembersTransferFormerMembersFilesError tagName]];
  case DBTEAMMembersTransferFormerMembersFilesErrorUserNotRemoved:
    return [[self tagName] isEqual:[aMembersTransferFormerMembersFilesError tagName]];
  case DBTEAMMembersTransferFormerMembersFilesErrorUserDataCannotBeTransferred:
    return [[self tagName] isEqual:[aMembersTransferFormerMembersFilesError tagName]];
  case DBTEAMMembersTransferFormerMembersFilesErrorUserDataAlreadyTransferred:
    return [[self tagName] isEqual:[aMembersTransferFormerMembersFilesError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersTransferFormerMembersFilesErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersTransferFormerMembersFilesError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUserNotFound]) {
    jsonDict[@".tag"] = @"user_not_found";
  } else if ([valueObj isUserNotInTeam]) {
    jsonDict[@".tag"] = @"user_not_in_team";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isRemovedAndTransferDestShouldDiffer]) {
    jsonDict[@".tag"] = @"removed_and_transfer_dest_should_differ";
  } else if ([valueObj isRemovedAndTransferAdminShouldDiffer]) {
    jsonDict[@".tag"] = @"removed_and_transfer_admin_should_differ";
  } else if ([valueObj isTransferDestUserNotFound]) {
    jsonDict[@".tag"] = @"transfer_dest_user_not_found";
  } else if ([valueObj isTransferDestUserNotInTeam]) {
    jsonDict[@".tag"] = @"transfer_dest_user_not_in_team";
  } else if ([valueObj isTransferAdminUserNotInTeam]) {
    jsonDict[@".tag"] = @"transfer_admin_user_not_in_team";
  } else if ([valueObj isTransferAdminUserNotFound]) {
    jsonDict[@".tag"] = @"transfer_admin_user_not_found";
  } else if ([valueObj isUnspecifiedTransferAdminId]) {
    jsonDict[@".tag"] = @"unspecified_transfer_admin_id";
  } else if ([valueObj isTransferAdminIsNotAdmin]) {
    jsonDict[@".tag"] = @"transfer_admin_is_not_admin";
  } else if ([valueObj isRecipientNotVerified]) {
    jsonDict[@".tag"] = @"recipient_not_verified";
  } else if ([valueObj isUserDataIsBeingTransferred]) {
    jsonDict[@".tag"] = @"user_data_is_being_transferred";
  } else if ([valueObj isUserNotRemoved]) {
    jsonDict[@".tag"] = @"user_not_removed";
  } else if ([valueObj isUserDataCannotBeTransferred]) {
    jsonDict[@".tag"] = @"user_data_cannot_be_transferred";
  } else if ([valueObj isUserDataAlreadyTransferred]) {
    jsonDict[@".tag"] = @"user_data_already_transferred";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersTransferFormerMembersFilesError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"user_not_found"]) {
    return [[DBTEAMMembersTransferFormerMembersFilesError alloc] initWithUserNotFound];
  } else if ([tag isEqualToString:@"user_not_in_team"]) {
    return [[DBTEAMMembersTransferFormerMembersFilesError alloc] initWithUserNotInTeam];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMMembersTransferFormerMembersFilesError alloc] initWithOther];
  } else if ([tag isEqualToString:@"removed_and_transfer_dest_should_differ"]) {
    return [[DBTEAMMembersTransferFormerMembersFilesError alloc] initWithRemovedAndTransferDestShouldDiffer];
  } else if ([tag isEqualToString:@"removed_and_transfer_admin_should_differ"]) {
    return [[DBTEAMMembersTransferFormerMembersFilesError alloc] initWithRemovedAndTransferAdminShouldDiffer];
  } else if ([tag isEqualToString:@"transfer_dest_user_not_found"]) {
    return [[DBTEAMMembersTransferFormerMembersFilesError alloc] initWithTransferDestUserNotFound];
  } else if ([tag isEqualToString:@"transfer_dest_user_not_in_team"]) {
    return [[DBTEAMMembersTransferFormerMembersFilesError alloc] initWithTransferDestUserNotInTeam];
  } else if ([tag isEqualToString:@"transfer_admin_user_not_in_team"]) {
    return [[DBTEAMMembersTransferFormerMembersFilesError alloc] initWithTransferAdminUserNotInTeam];
  } else if ([tag isEqualToString:@"transfer_admin_user_not_found"]) {
    return [[DBTEAMMembersTransferFormerMembersFilesError alloc] initWithTransferAdminUserNotFound];
  } else if ([tag isEqualToString:@"unspecified_transfer_admin_id"]) {
    return [[DBTEAMMembersTransferFormerMembersFilesError alloc] initWithUnspecifiedTransferAdminId];
  } else if ([tag isEqualToString:@"transfer_admin_is_not_admin"]) {
    return [[DBTEAMMembersTransferFormerMembersFilesError alloc] initWithTransferAdminIsNotAdmin];
  } else if ([tag isEqualToString:@"recipient_not_verified"]) {
    return [[DBTEAMMembersTransferFormerMembersFilesError alloc] initWithRecipientNotVerified];
  } else if ([tag isEqualToString:@"user_data_is_being_transferred"]) {
    return [[DBTEAMMembersTransferFormerMembersFilesError alloc] initWithUserDataIsBeingTransferred];
  } else if ([tag isEqualToString:@"user_not_removed"]) {
    return [[DBTEAMMembersTransferFormerMembersFilesError alloc] initWithUserNotRemoved];
  } else if ([tag isEqualToString:@"user_data_cannot_be_transferred"]) {
    return [[DBTEAMMembersTransferFormerMembersFilesError alloc] initWithUserDataCannotBeTransferred];
  } else if ([tag isEqualToString:@"user_data_already_transferred"]) {
    return [[DBTEAMMembersTransferFormerMembersFilesError alloc] initWithUserDataAlreadyTransferred];
  } else {
    return [[DBTEAMMembersTransferFormerMembersFilesError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMembersUnsuspendArg.h"
#import "DBTEAMUserSelectorArg.h"

#pragma mark - API Object

@implementation DBTEAMMembersUnsuspendArg

#pragma mark - Constructors

- (instancetype)initWithUser:(DBTEAMUserSelectorArg *)user {
  [DBStoneValidators nonnullValidator:nil](user);

  self = [super init];
  if (self) {
    _user = user;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersUnsuspendArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersUnsuspendArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersUnsuspendArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.user hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersUnsuspendArg:other];
}

- (BOOL)isEqualToMembersUnsuspendArg:(DBTEAMMembersUnsuspendArg *)aMembersUnsuspendArg {
  if (self == aMembersUnsuspendArg) {
    return YES;
  }
  if (![self.user isEqual:aMembersUnsuspendArg.user]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersUnsuspendArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersUnsuspendArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"user"] = [DBTEAMUserSelectorArgSerializer serialize:valueObj.user];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersUnsuspendArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMUserSelectorArg *user = [DBTEAMUserSelectorArgSerializer deserialize:valueDict[@"user"]];

  return [[DBTEAMMembersUnsuspendArg alloc] initWithUser:user];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMembersDeactivateError.h"
#import "DBTEAMMembersUnsuspendError.h"

#pragma mark - API Object

@implementation DBTEAMMembersUnsuspendError

#pragma mark - Constructors

- (instancetype)initWithUserNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersUnsuspendErrorUserNotFound;
  }
  return self;
}

- (instancetype)initWithUserNotInTeam {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersUnsuspendErrorUserNotInTeam;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersUnsuspendErrorOther;
  }
  return self;
}

- (instancetype)initWithUnsuspendNonSuspendedMember {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersUnsuspendErrorUnsuspendNonSuspendedMember;
  }
  return self;
}

- (instancetype)initWithTeamLicenseLimit {
  self = [super init];
  if (self) {
    _tag = DBTEAMMembersUnsuspendErrorTeamLicenseLimit;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isUserNotFound {
  return _tag == DBTEAMMembersUnsuspendErrorUserNotFound;
}

- (BOOL)isUserNotInTeam {
  return _tag == DBTEAMMembersUnsuspendErrorUserNotInTeam;
}

- (BOOL)isOther {
  return _tag == DBTEAMMembersUnsuspendErrorOther;
}

- (BOOL)isUnsuspendNonSuspendedMember {
  return _tag == DBTEAMMembersUnsuspendErrorUnsuspendNonSuspendedMember;
}

- (BOOL)isTeamLicenseLimit {
  return _tag == DBTEAMMembersUnsuspendErrorTeamLicenseLimit;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMMembersUnsuspendErrorUserNotFound:
    return @"DBTEAMMembersUnsuspendErrorUserNotFound";
  case DBTEAMMembersUnsuspendErrorUserNotInTeam:
    return @"DBTEAMMembersUnsuspendErrorUserNotInTeam";
  case DBTEAMMembersUnsuspendErrorOther:
    return @"DBTEAMMembersUnsuspendErrorOther";
  case DBTEAMMembersUnsuspendErrorUnsuspendNonSuspendedMember:
    return @"DBTEAMMembersUnsuspendErrorUnsuspendNonSuspendedMember";
  case DBTEAMMembersUnsuspendErrorTeamLicenseLimit:
    return @"DBTEAMMembersUnsuspendErrorTeamLicenseLimit";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMembersUnsuspendErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMembersUnsuspendErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMembersUnsuspendErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMMembersUnsuspendErrorUserNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersUnsuspendErrorUserNotInTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersUnsuspendErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersUnsuspendErrorUnsuspendNonSuspendedMember:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMembersUnsuspendErrorTeamLicenseLimit:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembersUnsuspendError:other];
}

- (BOOL)isEqualToMembersUnsuspendError:(DBTEAMMembersUnsuspendError *)aMembersUnsuspendError {
  if (self == aMembersUnsuspendError) {
    return YES;
  }
  if (self.tag != aMembersUnsuspendError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMMembersUnsuspendErrorUserNotFound:
    return [[self tagName] isEqual:[aMembersUnsuspendError tagName]];
  case DBTEAMMembersUnsuspendErrorUserNotInTeam:
    return [[self tagName] isEqual:[aMembersUnsuspendError tagName]];
  case DBTEAMMembersUnsuspendErrorOther:
    return [[self tagName] isEqual:[aMembersUnsuspendError tagName]];
  case DBTEAMMembersUnsuspendErrorUnsuspendNonSuspendedMember:
    return [[self tagName] isEqual:[aMembersUnsuspendError tagName]];
  case DBTEAMMembersUnsuspendErrorTeamLicenseLimit:
    return [[self tagName] isEqual:[aMembersUnsuspendError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMembersUnsuspendErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersUnsuspendError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUserNotFound]) {
    jsonDict[@".tag"] = @"user_not_found";
  } else if ([valueObj isUserNotInTeam]) {
    jsonDict[@".tag"] = @"user_not_in_team";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isUnsuspendNonSuspendedMember]) {
    jsonDict[@".tag"] = @"unsuspend_non_suspended_member";
  } else if ([valueObj isTeamLicenseLimit]) {
    jsonDict[@".tag"] = @"team_license_limit";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMembersUnsuspendError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"user_not_found"]) {
    return [[DBTEAMMembersUnsuspendError alloc] initWithUserNotFound];
  } else if ([tag isEqualToString:@"user_not_in_team"]) {
    return [[DBTEAMMembersUnsuspendError alloc] initWithUserNotInTeam];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMMembersUnsuspendError alloc] initWithOther];
  } else if ([tag isEqualToString:@"unsuspend_non_suspended_member"]) {
    return [[DBTEAMMembersUnsuspendError alloc] initWithUnsuspendNonSuspendedMember];
  } else if ([tag isEqualToString:@"team_license_limit"]) {
    return [[DBTEAMMembersUnsuspendError alloc] initWithTeamLicenseLimit];
  } else {
    return [[DBTEAMMembersUnsuspendError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMMobileClientPlatform.h"

#pragma mark - API Object

@implementation DBTEAMMobileClientPlatform

#pragma mark - Constructors

- (instancetype)initWithIphone {
  self = [super init];
  if (self) {
    _tag = DBTEAMMobileClientPlatformIphone;
  }
  return self;
}

- (instancetype)initWithIpad {
  self = [super init];
  if (self) {
    _tag = DBTEAMMobileClientPlatformIpad;
  }
  return self;
}

- (instancetype)initWithAndroid {
  self = [super init];
  if (self) {
    _tag = DBTEAMMobileClientPlatformAndroid;
  }
  return self;
}

- (instancetype)initWithWindowsPhone {
  self = [super init];
  if (self) {
    _tag = DBTEAMMobileClientPlatformWindowsPhone;
  }
  return self;
}

- (instancetype)initWithBlackberry {
  self = [super init];
  if (self) {
    _tag = DBTEAMMobileClientPlatformBlackberry;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMMobileClientPlatformOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isIphone {
  return _tag == DBTEAMMobileClientPlatformIphone;
}

- (BOOL)isIpad {
  return _tag == DBTEAMMobileClientPlatformIpad;
}

- (BOOL)isAndroid {
  return _tag == DBTEAMMobileClientPlatformAndroid;
}

- (BOOL)isWindowsPhone {
  return _tag == DBTEAMMobileClientPlatformWindowsPhone;
}

- (BOOL)isBlackberry {
  return _tag == DBTEAMMobileClientPlatformBlackberry;
}

- (BOOL)isOther {
  return _tag == DBTEAMMobileClientPlatformOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMMobileClientPlatformIphone:
    return @"DBTEAMMobileClientPlatformIphone";
  case DBTEAMMobileClientPlatformIpad:
    return @"DBTEAMMobileClientPlatformIpad";
  case DBTEAMMobileClientPlatformAndroid:
    return @"DBTEAMMobileClientPlatformAndroid";
  case DBTEAMMobileClientPlatformWindowsPhone:
    return @"DBTEAMMobileClientPlatformWindowsPhone";
  case DBTEAMMobileClientPlatformBlackberry:
    return @"DBTEAMMobileClientPlatformBlackberry";
  case DBTEAMMobileClientPlatformOther:
    return @"DBTEAMMobileClientPlatformOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMobileClientPlatformSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMobileClientPlatformSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMobileClientPlatformSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMMobileClientPlatformIphone:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMobileClientPlatformIpad:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMobileClientPlatformAndroid:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMobileClientPlatformWindowsPhone:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMobileClientPlatformBlackberry:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMMobileClientPlatformOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMobileClientPlatform:other];
}

- (BOOL)isEqualToMobileClientPlatform:(DBTEAMMobileClientPlatform *)aMobileClientPlatform {
  if (self == aMobileClientPlatform) {
    return YES;
  }
  if (self.tag != aMobileClientPlatform.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMMobileClientPlatformIphone:
    return [[self tagName] isEqual:[aMobileClientPlatform tagName]];
  case DBTEAMMobileClientPlatformIpad:
    return [[self tagName] isEqual:[aMobileClientPlatform tagName]];
  case DBTEAMMobileClientPlatformAndroid:
    return [[self tagName] isEqual:[aMobileClientPlatform tagName]];
  case DBTEAMMobileClientPlatformWindowsPhone:
    return [[self tagName] isEqual:[aMobileClientPlatform tagName]];
  case DBTEAMMobileClientPlatformBlackberry:
    return [[self tagName] isEqual:[aMobileClientPlatform tagName]];
  case DBTEAMMobileClientPlatformOther:
    return [[self tagName] isEqual:[aMobileClientPlatform tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMobileClientPlatformSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMobileClientPlatform *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isIphone]) {
    jsonDict[@".tag"] = @"iphone";
  } else if ([valueObj isIpad]) {
    jsonDict[@".tag"] = @"ipad";
  } else if ([valueObj isAndroid]) {
    jsonDict[@".tag"] = @"android";
  } else if ([valueObj isWindowsPhone]) {
    jsonDict[@".tag"] = @"windows_phone";
  } else if ([valueObj isBlackberry]) {
    jsonDict[@".tag"] = @"blackberry";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMobileClientPlatform *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"iphone"]) {
    return [[DBTEAMMobileClientPlatform alloc] initWithIphone];
  } else if ([tag isEqualToString:@"ipad"]) {
    return [[DBTEAMMobileClientPlatform alloc] initWithIpad];
  } else if ([tag isEqualToString:@"android"]) {
    return [[DBTEAMMobileClientPlatform alloc] initWithAndroid];
  } else if ([tag isEqualToString:@"windows_phone"]) {
    return [[DBTEAMMobileClientPlatform alloc] initWithWindowsPhone];
  } else if ([tag isEqualToString:@"blackberry"]) {
    return [[DBTEAMMobileClientPlatform alloc] initWithBlackberry];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMMobileClientPlatform alloc] initWithOther];
  } else {
    return [[DBTEAMMobileClientPlatform alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMDeviceSession.h"
#import "DBTEAMMobileClientPlatform.h"
#import "DBTEAMMobileClientSession.h"

#pragma mark - API Object

@implementation DBTEAMMobileClientSession

#pragma mark - Constructors

- (instancetype)initWithSessionId:(NSString *)sessionId
                       deviceName:(NSString *)deviceName
                       clientType:(DBTEAMMobileClientPlatform *)clientType
                        ipAddress:(NSString *)ipAddress
                          country:(NSString *)country
                          created:(NSDate *)created
                          updated:(NSDate *)updated
                    clientVersion:(NSString *)clientVersion
                        osVersion:(NSString *)osVersion
                      lastCarrier:(NSString *)lastCarrier {
  [DBStoneValidators nonnullValidator:nil](sessionId);
  [DBStoneValidators nonnullValidator:nil](deviceName);
  [DBStoneValidators nonnullValidator:nil](clientType);

  self = [super initWithSessionId:sessionId ipAddress:ipAddress country:country created:created updated:updated];
  if (self) {
    _deviceName = deviceName;
    _clientType = clientType;
    _clientVersion = clientVersion;
    _osVersion = osVersion;
    _lastCarrier = lastCarrier;
  }
  return self;
}

- (instancetype)initWithSessionId:(NSString *)sessionId
                       deviceName:(NSString *)deviceName
                       clientType:(DBTEAMMobileClientPlatform *)clientType {
  return [self initWithSessionId:sessionId
                      deviceName:deviceName
                      clientType:clientType
                       ipAddress:nil
                         country:nil
                         created:nil
                         updated:nil
                   clientVersion:nil
                       osVersion:nil
                     lastCarrier:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMMobileClientSessionSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMMobileClientSessionSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMMobileClientSessionSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.sessionId hash];
  result = prime * result + [self.deviceName hash];
  result = prime * result + [self.clientType hash];
  if (self.ipAddress != nil) {
    result = prime * result + [self.ipAddress hash];
  }
  if (self.country != nil) {
    result = prime * result + [self.country hash];
  }
  if (self.created != nil) {
    result = prime * result + [self.created hash];
  }
  if (self.updated != nil) {
    result = prime * result + [self.updated hash];
  }
  if (self.clientVersion != nil) {
    result = prime * result + [self.clientVersion hash];
  }
  if (self.osVersion != nil) {
    result = prime * result + [self.osVersion hash];
  }
  if (self.lastCarrier != nil) {
    result = prime * result + [self.lastCarrier hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMobileClientSession:other];
}

- (BOOL)isEqualToMobileClientSession:(DBTEAMMobileClientSession *)aMobileClientSession {
  if (self == aMobileClientSession) {
    return YES;
  }
  if (![self.sessionId isEqual:aMobileClientSession.sessionId]) {
    return NO;
  }
  if (![self.deviceName isEqual:aMobileClientSession.deviceName]) {
    return NO;
  }
  if (![self.clientType isEqual:aMobileClientSession.clientType]) {
    return NO;
  }
  if (self.ipAddress) {
    if (![self.ipAddress isEqual:aMobileClientSession.ipAddress]) {
      return NO;
    }
  }
  if (self.country) {
    if (![self.country isEqual:aMobileClientSession.country]) {
      return NO;
    }
  }
  if (self.created) {
    if (![self.created isEqual:aMobileClientSession.created]) {
      return NO;
    }
  }
  if (self.updated) {
    if (![self.updated isEqual:aMobileClientSession.updated]) {
      return NO;
    }
  }
  if (self.clientVersion) {
    if (![self.clientVersion isEqual:aMobileClientSession.clientVersion]) {
      return NO;
    }
  }
  if (self.osVersion) {
    if (![self.osVersion isEqual:aMobileClientSession.osVersion]) {
      return NO;
    }
  }
  if (self.lastCarrier) {
    if (![self.lastCarrier isEqual:aMobileClientSession.lastCarrier]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMMobileClientSessionSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMMobileClientSession *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"session_id"] = valueObj.sessionId;
  jsonDict[@"device_name"] = valueObj.deviceName;
  jsonDict[@"client_type"] = [DBTEAMMobileClientPlatformSerializer serialize:valueObj.clientType];
  if (valueObj.ipAddress) {
    jsonDict[@"ip_address"] = valueObj.ipAddress;
  }
  if (valueObj.country) {
    jsonDict[@"country"] = valueObj.country;
  }
  if (valueObj.created) {
    jsonDict[@"created"] = [DBNSDateSerializer serialize:valueObj.created dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }
  if (valueObj.updated) {
    jsonDict[@"updated"] = [DBNSDateSerializer serialize:valueObj.updated dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }
  if (valueObj.clientVersion) {
    jsonDict[@"client_version"] = valueObj.clientVersion;
  }
  if (valueObj.osVersion) {
    jsonDict[@"os_version"] = valueObj.osVersion;
  }
  if (valueObj.lastCarrier) {
    jsonDict[@"last_carrier"] = valueObj.lastCarrier;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMMobileClientSession *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *sessionId = valueDict[@"session_id"];
  NSString *deviceName = valueDict[@"device_name"];
  DBTEAMMobileClientPlatform *clientType = [DBTEAMMobileClientPlatformSerializer deserialize:valueDict[@"client_type"]];
  NSString *ipAddress = valueDict[@"ip_address"] ?: nil;
  NSString *country = valueDict[@"country"] ?: nil;
  NSDate *created = valueDict[@"created"]
                        ? [DBNSDateSerializer deserialize:valueDict[@"created"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                        : nil;
  NSDate *updated = valueDict[@"updated"]
                        ? [DBNSDateSerializer deserialize:valueDict[@"updated"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                        : nil;
  NSString *clientVersion = valueDict[@"client_version"] ?: nil;
  NSString *osVersion = valueDict[@"os_version"] ?: nil;
  NSString *lastCarrier = valueDict[@"last_carrier"] ?: nil;

  return [[DBTEAMMobileClientSession alloc] initWithSessionId:sessionId
                                                   deviceName:deviceName
                                                   clientType:clientType
                                                    ipAddress:ipAddress
                                                      country:country
                                                      created:created
                                                      updated:updated
                                                clientVersion:clientVersion
                                                    osVersion:osVersion
                                                  lastCarrier:lastCarrier];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMNamespaceMetadata.h"
#import "DBTEAMNamespaceType.h"

#pragma mark - API Object

@implementation DBTEAMNamespaceMetadata

#pragma mark - Constructors

- (instancetype)initWithName:(NSString *)name
                 namespaceId:(NSString *)namespaceId
               namespaceType:(DBTEAMNamespaceType *)namespaceType
                teamMemberId:(NSString *)teamMemberId {
  [DBStoneValidators nonnullValidator:nil](name);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"[-_0-9a-zA-Z:]+"]](namespaceId);
  [DBStoneValidators nonnullValidator:nil](namespaceType);

  self = [super init];
  if (self) {
    _name = name;
    _namespaceId = namespaceId;
    _namespaceType = namespaceType;
    _teamMemberId = teamMemberId;
  }
  return self;
}

- (instancetype)initWithName:(NSString *)name
                 namespaceId:(NSString *)namespaceId
               namespaceType:(DBTEAMNamespaceType *)namespaceType {
  return [self initWithName:name namespaceId:namespaceId namespaceType:namespaceType teamMemberId:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMNamespaceMetadataSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMNamespaceMetadataSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMNamespaceMetadataSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.name hash];
  result = prime * result + [self.namespaceId hash];
  result = prime * result + [self.namespaceType hash];
  if (self.teamMemberId != nil) {
    result = prime * result + [self.teamMemberId hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToNamespaceMetadata:other];
}

- (BOOL)isEqualToNamespaceMetadata:(DBTEAMNamespaceMetadata *)aNamespaceMetadata {
  if (self == aNamespaceMetadata) {
    return YES;
  }
  if (![self.name isEqual:aNamespaceMetadata.name]) {
    return NO;
  }
  if (![self.namespaceId isEqual:aNamespaceMetadata.namespaceId]) {
    return NO;
  }
  if (![self.namespaceType isEqual:aNamespaceMetadata.namespaceType]) {
    return NO;
  }
  if (self.teamMemberId) {
    if (![self.teamMemberId isEqual:aNamespaceMetadata.teamMemberId]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMNamespaceMetadataSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMNamespaceMetadata *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"name"] = valueObj.name;
  jsonDict[@"namespace_id"] = valueObj.namespaceId;
  jsonDict[@"namespace_type"] = [DBTEAMNamespaceTypeSerializer serialize:valueObj.namespaceType];
  if (valueObj.teamMemberId) {
    jsonDict[@"team_member_id"] = valueObj.teamMemberId;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMNamespaceMetadata *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *name = valueDict[@"name"];
  NSString *namespaceId = valueDict[@"namespace_id"];
  DBTEAMNamespaceType *namespaceType = [DBTEAMNamespaceTypeSerializer deserialize:valueDict[@"namespace_type"]];
  NSString *teamMemberId = valueDict[@"team_member_id"] ?: nil;

  return [[DBTEAMNamespaceMetadata alloc] initWithName:name
                                           namespaceId:namespaceId
                                         namespaceType:namespaceType
                                          teamMemberId:teamMemberId];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMNamespaceType.h"

#pragma mark - API Object

@implementation DBTEAMNamespaceType

#pragma mark - Constructors

- (instancetype)initWithAppFolder {
  self = [super init];
  if (self) {
    _tag = DBTEAMNamespaceTypeAppFolder;
  }
  return self;
}

- (instancetype)initWithSharedFolder {
  self = [super init];
  if (self) {
    _tag = DBTEAMNamespaceTypeSharedFolder;
  }
  return self;
}

- (instancetype)initWithTeamFolder {
  self = [super init];
  if (self) {
    _tag = DBTEAMNamespaceTypeTeamFolder;
  }
  return self;
}

- (instancetype)initWithTeamMemberFolder {
  self = [super init];
  if (self) {
    _tag = DBTEAMNamespaceTypeTeamMemberFolder;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMNamespaceTypeOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isAppFolder {
  return _tag == DBTEAMNamespaceTypeAppFolder;
}

- (BOOL)isSharedFolder {
  return _tag == DBTEAMNamespaceTypeSharedFolder;
}

- (BOOL)isTeamFolder {
  return _tag == DBTEAMNamespaceTypeTeamFolder;
}

- (BOOL)isTeamMemberFolder {
  return _tag == DBTEAMNamespaceTypeTeamMemberFolder;
}

- (BOOL)isOther {
  return _tag == DBTEAMNamespaceTypeOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMNamespaceTypeAppFolder:
    return @"DBTEAMNamespaceTypeAppFolder";
  case DBTEAMNamespaceTypeSharedFolder:
    return @"DBTEAMNamespaceTypeSharedFolder";
  case DBTEAMNamespaceTypeTeamFolder:
    return @"DBTEAMNamespaceTypeTeamFolder";
  case DBTEAMNamespaceTypeTeamMemberFolder:
    return @"DBTEAMNamespaceTypeTeamMemberFolder";
  case DBTEAMNamespaceTypeOther:
    return @"DBTEAMNamespaceTypeOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMNamespaceTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMNamespaceTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMNamespaceTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMNamespaceTypeAppFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMNamespaceTypeSharedFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMNamespaceTypeTeamFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMNamespaceTypeTeamMemberFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMNamespaceTypeOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToNamespaceType:other];
}

- (BOOL)isEqualToNamespaceType:(DBTEAMNamespaceType *)aNamespaceType {
  if (self == aNamespaceType) {
    return YES;
  }
  if (self.tag != aNamespaceType.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMNamespaceTypeAppFolder:
    return [[self tagName] isEqual:[aNamespaceType tagName]];
  case DBTEAMNamespaceTypeSharedFolder:
    return [[self tagName] isEqual:[aNamespaceType tagName]];
  case DBTEAMNamespaceTypeTeamFolder:
    return [[self tagName] isEqual:[aNamespaceType tagName]];
  case DBTEAMNamespaceTypeTeamMemberFolder:
    return [[self tagName] isEqual:[aNamespaceType tagName]];
  case DBTEAMNamespaceTypeOther:
    return [[self tagName] isEqual:[aNamespaceType tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMNamespaceTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMNamespaceType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAppFolder]) {
    jsonDict[@".tag"] = @"app_folder";
  } else if ([valueObj isSharedFolder]) {
    jsonDict[@".tag"] = @"shared_folder";
  } else if ([valueObj isTeamFolder]) {
    jsonDict[@".tag"] = @"team_folder";
  } else if ([valueObj isTeamMemberFolder]) {
    jsonDict[@".tag"] = @"team_member_folder";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMNamespaceType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"app_folder"]) {
    return [[DBTEAMNamespaceType alloc] initWithAppFolder];
  } else if ([tag isEqualToString:@"shared_folder"]) {
    return [[DBTEAMNamespaceType alloc] initWithSharedFolder];
  } else if ([tag isEqualToString:@"team_folder"]) {
    return [[DBTEAMNamespaceType alloc] initWithTeamFolder];
  } else if ([tag isEqualToString:@"team_member_folder"]) {
    return [[DBTEAMNamespaceType alloc] initWithTeamMemberFolder];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMNamespaceType alloc] initWithOther];
  } else {
    return [[DBTEAMNamespaceType alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMRemoveCustomQuotaResult.h"
#import "DBTEAMUserSelectorArg.h"

#pragma mark - API Object

@implementation DBTEAMRemoveCustomQuotaResult

@synthesize success = _success;
@synthesize invalidUser = _invalidUser;

#pragma mark - Constructors

- (instancetype)initWithSuccess:(DBTEAMUserSelectorArg *)success {
  self = [super init];
  if (self) {
    _tag = DBTEAMRemoveCustomQuotaResultSuccess;
    _success = success;
  }
  return self;
}

- (instancetype)initWithInvalidUser:(DBTEAMUserSelectorArg *)invalidUser {
  self = [super init];
  if (self) {
    _tag = DBTEAMRemoveCustomQuotaResultInvalidUser;
    _invalidUser = invalidUser;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMRemoveCustomQuotaResultOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBTEAMUserSelectorArg *)success {
  if (![self isSuccess]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMRemoveCustomQuotaResultSuccess, but was %@.", [self tagName]];
  }
  return _success;
}

- (DBTEAMUserSelectorArg *)invalidUser {
  if (![self isInvalidUser]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMRemoveCustomQuotaResultInvalidUser, but was %@.", [self tagName]];
  }
  return _invalidUser;
}

#pragma mark - Tag state methods

- (BOOL)isSuccess {
  return _tag == DBTEAMRemoveCustomQuotaResultSuccess;
}

- (BOOL)isInvalidUser {
  return _tag == DBTEAMRemoveCustomQuotaResultInvalidUser;
}

- (BOOL)isOther {
  return _tag == DBTEAMRemoveCustomQuotaResultOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMRemoveCustomQuotaResultSuccess:
    return @"DBTEAMRemoveCustomQuotaResultSuccess";
  case DBTEAMRemoveCustomQuotaResultInvalidUser:
    return @"DBTEAMRemoveCustomQuotaResultInvalidUser";
  case DBTEAMRemoveCustomQuotaResultOther:
    return @"DBTEAMRemoveCustomQuotaResultOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMRemoveCustomQuotaResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMRemoveCustomQuotaResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMRemoveCustomQuotaResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMRemoveCustomQuotaResultSuccess:
    result = prime * result + [self.success hash];
    break;
  case DBTEAMRemoveCustomQuotaResultInvalidUser:
    result = prime * result + [self.invalidUser hash];
    break;
  case DBTEAMRemoveCustomQuotaResultOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRemoveCustomQuotaResult:other];
}

- (BOOL)isEqualToRemoveCustomQuotaResult:(DBTEAMRemoveCustomQuotaResult *)aRemoveCustomQuotaResult {
  if (self == aRemoveCustomQuotaResult) {
    return YES;
  }
  if (self.tag != aRemoveCustomQuotaResult.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMRemoveCustomQuotaResultSuccess:
    return [self.success isEqual:aRemoveCustomQuotaResult.success];
  case DBTEAMRemoveCustomQuotaResultInvalidUser:
    return [self.invalidUser isEqual:aRemoveCustomQuotaResult.invalidUser];
  case DBTEAMRemoveCustomQuotaResultOther:
    return [[self tagName] isEqual:[aRemoveCustomQuotaResult tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMRemoveCustomQuotaResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMRemoveCustomQuotaResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isSuccess]) {
    jsonDict[@"success"] = [[DBTEAMUserSelectorArgSerializer serialize:valueObj.success] mutableCopy];
    jsonDict[@".tag"] = @"success";
  } else if ([valueObj isInvalidUser]) {
    jsonDict[@"invalid_user"] = [[DBTEAMUserSelectorArgSerializer serialize:valueObj.invalidUser] mutableCopy];
    jsonDict[@".tag"] = @"invalid_user";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMRemoveCustomQuotaResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"success"]) {
    DBTEAMUserSelectorArg *success = [DBTEAMUserSelectorArgSerializer deserialize:valueDict[@"success"]];
    return [[DBTEAMRemoveCustomQuotaResult alloc] initWithSuccess:success];
  } else if ([tag isEqualToString:@"invalid_user"]) {
    DBTEAMUserSelectorArg *invalidUser = [DBTEAMUserSelectorArgSerializer deserialize:valueDict[@"invalid_user"]];
    return [[DBTEAMRemoveCustomQuotaResult alloc] initWithInvalidUser:invalidUser];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMRemoveCustomQuotaResult alloc] initWithOther];
  } else {
    return [[DBTEAMRemoveCustomQuotaResult alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMRemovedStatus.h"

#pragma mark - API Object

@implementation DBTEAMRemovedStatus

#pragma mark - Constructors

- (instancetype)initWithIsRecoverable:(NSNumber *)isRecoverable isDisconnected:(NSNumber *)isDisconnected {
  [DBStoneValidators nonnullValidator:nil](isRecoverable);
  [DBStoneValidators nonnullValidator:nil](isDisconnected);

  self = [super init];
  if (self) {
    _isRecoverable = isRecoverable;
    _isDisconnected = isDisconnected;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMRemovedStatusSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMRemovedStatusSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMRemovedStatusSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.isRecoverable hash];
  result = prime * result + [self.isDisconnected hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRemovedStatus:other];
}

- (BOOL)isEqualToRemovedStatus:(DBTEAMRemovedStatus *)aRemovedStatus {
  if (self == aRemovedStatus) {
    return YES;
  }
  if (![self.isRecoverable isEqual:aRemovedStatus.isRecoverable]) {
    return NO;
  }
  if (![self.isDisconnected isEqual:aRemovedStatus.isDisconnected]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMRemovedStatusSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMRemovedStatus *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"is_recoverable"] = valueObj.isRecoverable;
  jsonDict[@"is_disconnected"] = valueObj.isDisconnected;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMRemovedStatus *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSNumber *isRecoverable = valueDict[@"is_recoverable"];
  NSNumber *isDisconnected = valueDict[@"is_disconnected"];

  return [[DBTEAMRemovedStatus alloc] initWithIsRecoverable:isRecoverable isDisconnected:isDisconnected];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMResendSecondaryEmailResult.h"

#pragma mark - API Object

@implementation DBTEAMResendSecondaryEmailResult

@synthesize success = _success;
@synthesize notPending = _notPending;
@synthesize rateLimited = _rateLimited;

#pragma mark - Constructors

- (instancetype)initWithSuccess:(NSString *)success {
  self = [super init];
  if (self) {
    _tag = DBTEAMResendSecondaryEmailResultSuccess;
    _success = success;
  }
  return self;
}

- (instancetype)initWithNotPending:(NSString *)notPending {
  self = [super init];
  if (self) {
    _tag = DBTEAMResendSecondaryEmailResultNotPending;
    _notPending = notPending;
  }
  return self;
}

- (instancetype)initWithRateLimited:(NSString *)rateLimited {
  self = [super init];
  if (self) {
    _tag = DBTEAMResendSecondaryEmailResultRateLimited;
    _rateLimited = rateLimited;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMResendSecondaryEmailResultOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSString *)success {
  if (![self isSuccess]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMResendSecondaryEmailResultSuccess, but was %@.", [self tagName]];
  }
  return _success;
}

- (NSString *)notPending {
  if (![self isNotPending]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMResendSecondaryEmailResultNotPending, but was %@.", [self tagName]];
  }
  return _notPending;
}

- (NSString *)rateLimited {
  if (![self isRateLimited]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMResendSecondaryEmailResultRateLimited, but was %@.", [self tagName]];
  }
  return _rateLimited;
}

#pragma mark - Tag state methods

- (BOOL)isSuccess {
  return _tag == DBTEAMResendSecondaryEmailResultSuccess;
}

- (BOOL)isNotPending {
  return _tag == DBTEAMResendSecondaryEmailResultNotPending;
}

- (BOOL)isRateLimited {
  return _tag == DBTEAMResendSecondaryEmailResultRateLimited;
}

- (BOOL)isOther {
  return _tag == DBTEAMResendSecondaryEmailResultOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMResendSecondaryEmailResultSuccess:
    return @"DBTEAMResendSecondaryEmailResultSuccess";
  case DBTEAMResendSecondaryEmailResultNotPending:
    return @"DBTEAMResendSecondaryEmailResultNotPending";
  case DBTEAMResendSecondaryEmailResultRateLimited:
    return @"DBTEAMResendSecondaryEmailResultRateLimited";
  case DBTEAMResendSecondaryEmailResultOther:
    return @"DBTEAMResendSecondaryEmailResultOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMResendSecondaryEmailResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMResendSecondaryEmailResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMResendSecondaryEmailResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMResendSecondaryEmailResultSuccess:
    result = prime * result + [self.success hash];
    break;
  case DBTEAMResendSecondaryEmailResultNotPending:
    result = prime * result + [self.notPending hash];
    break;
  case DBTEAMResendSecondaryEmailResultRateLimited:
    result = prime * result + [self.rateLimited hash];
    break;
  case DBTEAMResendSecondaryEmailResultOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToResendSecondaryEmailResult:other];
}

- (BOOL)isEqualToResendSecondaryEmailResult:(DBTEAMResendSecondaryEmailResult *)aResendSecondaryEmailResult {
  if (self == aResendSecondaryEmailResult) {
    return YES;
  }
  if (self.tag != aResendSecondaryEmailResult.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMResendSecondaryEmailResultSuccess:
    return [self.success isEqual:aResendSecondaryEmailResult.success];
  case DBTEAMResendSecondaryEmailResultNotPending:
    return [self.notPending isEqual:aResendSecondaryEmailResult.notPending];
  case DBTEAMResendSecondaryEmailResultRateLimited:
    return [self.rateLimited isEqual:aResendSecondaryEmailResult.rateLimited];
  case DBTEAMResendSecondaryEmailResultOther:
    return [[self tagName] isEqual:[aResendSecondaryEmailResult tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMResendSecondaryEmailResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMResendSecondaryEmailResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isSuccess]) {
    jsonDict[@"success"] = valueObj.success;
    jsonDict[@".tag"] = @"success";
  } else if ([valueObj isNotPending]) {
    jsonDict[@"not_pending"] = valueObj.notPending;
    jsonDict[@".tag"] = @"not_pending";
  } else if ([valueObj isRateLimited]) {
    jsonDict[@"rate_limited"] = valueObj.rateLimited;
    jsonDict[@".tag"] = @"rate_limited";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMResendSecondaryEmailResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"success"]) {
    NSString *success = valueDict[@"success"];
    return [[DBTEAMResendSecondaryEmailResult alloc] initWithSuccess:success];
  } else if ([tag isEqualToString:@"not_pending"]) {
    NSString *notPending = valueDict[@"not_pending"];
    return [[DBTEAMResendSecondaryEmailResult alloc] initWithNotPending:notPending];
  } else if ([tag isEqualToString:@"rate_limited"]) {
    NSString *rateLimited = valueDict[@"rate_limited"];
    return [[DBTEAMResendSecondaryEmailResult alloc] initWithRateLimited:rateLimited];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMResendSecondaryEmailResult alloc] initWithOther];
  } else {
    return [[DBTEAMResendSecondaryEmailResult alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMResendVerificationEmailArg.h"
#import "DBTEAMUserSecondaryEmailsArg.h"

#pragma mark - API Object

@implementation DBTEAMResendVerificationEmailArg

#pragma mark - Constructors

- (instancetype)initWithEmailsToResend:(NSArray<DBTEAMUserSecondaryEmailsArg *> *)emailsToResend {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](emailsToResend);

  self = [super init];
  if (self) {
    _emailsToResend = emailsToResend;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMResendVerificationEmailArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMResendVerificationEmailArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMResendVerificationEmailArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.emailsToResend hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToResendVerificationEmailArg:other];
}

- (BOOL)isEqualToResendVerificationEmailArg:(DBTEAMResendVerificationEmailArg *)aResendVerificationEmailArg {
  if (self == aResendVerificationEmailArg) {
    return YES;
  }
  if (![self.emailsToResend isEqual:aResendVerificationEmailArg.emailsToResend]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMResendVerificationEmailArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMResendVerificationEmailArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"emails_to_resend"] = [DBArraySerializer serialize:valueObj.emailsToResend
                                                     withBlock:^id(id elem0) {
                                                       return [DBTEAMUserSecondaryEmailsArgSerializer serialize:elem0];
                                                     }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMResendVerificationEmailArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBTEAMUserSecondaryEmailsArg *> *emailsToResend =
      [DBArraySerializer deserialize:valueDict[@"emails_to_resend"]
                           withBlock:^id(id elem0) {
                             return [DBTEAMUserSecondaryEmailsArgSerializer deserialize:elem0];
                           }];

  return [[DBTEAMResendVerificationEmailArg alloc] initWithEmailsToResend:emailsToResend];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMResendVerificationEmailResult.h"
#import "DBTEAMUserResendResult.h"

#pragma mark - API Object

@implementation DBTEAMResendVerificationEmailResult

#pragma mark - Constructors

- (instancetype)initWithResults:(NSArray<DBTEAMUserResendResult *> *)results {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](results);

  self = [super init];
  if (self) {
    _results = results;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMResendVerificationEmailResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMResendVerificationEmailResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMResendVerificationEmailResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.results hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToResendVerificationEmailResult:other];
}

- (BOOL)isEqualToResendVerificationEmailResult:(DBTEAMResendVerificationEmailResult *)aResendVerificationEmailResult {
  if (self == aResendVerificationEmailResult) {
    return YES;
  }
  if (![self.results isEqual:aResendVerificationEmailResult.results]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMResendVerificationEmailResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMResendVerificationEmailResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"results"] = [DBArraySerializer serialize:valueObj.results
                                            withBlock:^id(id elem0) {
                                              return [DBTEAMUserResendResultSerializer serialize:elem0];
                                            }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMResendVerificationEmailResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBTEAMUserResendResult *> *results =
      [DBArraySerializer deserialize:valueDict[@"results"]
                           withBlock:^id(id elem0) {
                             return [DBTEAMUserResendResultSerializer deserialize:elem0];
                           }];

  return [[DBTEAMResendVerificationEmailResult alloc] initWithResults:results];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMDeviceSessionArg.h"
#import "DBTEAMRevokeDesktopClientArg.h"

#pragma mark - API Object

@implementation DBTEAMRevokeDesktopClientArg

#pragma mark - Constructors

- (instancetype)initWithSessionId:(NSString *)sessionId
                     teamMemberId:(NSString *)teamMemberId
                   deleteOnUnlink:(NSNumber *)deleteOnUnlink {
  [DBStoneValidators nonnullValidator:nil](sessionId);
  [DBStoneValidators nonnullValidator:nil](teamMemberId);

  self = [super initWithSessionId:sessionId teamMemberId:teamMemberId];
  if (self) {
    _deleteOnUnlink = deleteOnUnlink ?: @NO;
  }
  return self;
}

- (instancetype)initWithSessionId:(NSString *)sessionId teamMemberId:(NSString *)teamMemberId {
  return [self initWithSessionId:sessionId teamMemberId:teamMemberId deleteOnUnlink:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMRevokeDesktopClientArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMRevokeDesktopClientArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMRevokeDesktopClientArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.sessionId hash];
  result = prime * result + [self.teamMemberId hash];
  result = prime * result + [self.deleteOnUnlink hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRevokeDesktopClientArg:other];
}

- (BOOL)isEqualToRevokeDesktopClientArg:(DBTEAMRevokeDesktopClientArg *)aRevokeDesktopClientArg {
  if (self == aRevokeDesktopClientArg) {
    return YES;
  }
  if (![self.sessionId isEqual:aRevokeDesktopClientArg.sessionId]) {
    return NO;
  }
  if (![self.teamMemberId isEqual:aRevokeDesktopClientArg.teamMemberId]) {
    return NO;
  }
  if (![self.deleteOnUnlink isEqual:aRevokeDesktopClientArg.deleteOnUnlink]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMRevokeDesktopClientArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMRevokeDesktopClientArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"session_id"] = valueObj.sessionId;
  jsonDict[@"team_member_id"] = valueObj.teamMemberId;
  jsonDict[@"delete_on_unlink"] = valueObj.deleteOnUnlink;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMRevokeDesktopClientArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *sessionId = valueDict[@"session_id"];
  NSString *teamMemberId = valueDict[@"team_member_id"];
  NSNumber *deleteOnUnlink = valueDict[@"delete_on_unlink"] ?: @NO;

  return [[DBTEAMRevokeDesktopClientArg alloc] initWithSessionId:sessionId
                                                    teamMemberId:teamMemberId
                                                  deleteOnUnlink:deleteOnUnlink];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMDeviceSessionArg.h"
#import "DBTEAMRevokeDesktopClientArg.h"
#import "DBTEAMRevokeDeviceSessionArg.h"

#pragma mark - API Object

@implementation DBTEAMRevokeDeviceSessionArg

@synthesize webSession = _webSession;
@synthesize desktopClient = _desktopClient;
@synthesize mobileClient = _mobileClient;

#pragma mark - Constructors

- (instancetype)initWithWebSession:(DBTEAMDeviceSessionArg *)webSession {
  self = [super init];
  if (self) {
    _tag = DBTEAMRevokeDeviceSessionArgWebSession;
    _webSession = webSession;
  }
  return self;
}

- (instancetype)initWithDesktopClient:(DBTEAMRevokeDesktopClientArg *)desktopClient {
  self = [super init];
  if (self) {
    _tag = DBTEAMRevokeDeviceSessionArgDesktopClient;
    _desktopClient = desktopClient;
  }
  return self;
}

- (instancetype)initWithMobileClient:(DBTEAMDeviceSessionArg *)mobileClient {
  self = [super init];
  if (self) {
    _tag = DBTEAMRevokeDeviceSessionArgMobileClient;
    _mobileClient = mobileClient;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBTEAMDeviceSessionArg *)webSession {
  if (![self isWebSession]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMRevokeDeviceSessionArgWebSession, but was %@.", [self tagName]];
  }
  return _webSession;
}

- (DBTEAMRevokeDesktopClientArg *)desktopClient {
  if (![self isDesktopClient]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMRevokeDeviceSessionArgDesktopClient, but was %@.", [self tagName]];
  }
  return _desktopClient;
}

- (DBTEAMDeviceSessionArg *)mobileClient {
  if (![self isMobileClient]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMRevokeDeviceSessionArgMobileClient, but was %@.", [self tagName]];
  }
  return _mobileClient;
}

#pragma mark - Tag state methods

- (BOOL)isWebSession {
  return _tag == DBTEAMRevokeDeviceSessionArgWebSession;
}

- (BOOL)isDesktopClient {
  return _tag == DBTEAMRevokeDeviceSessionArgDesktopClient;
}

- (BOOL)isMobileClient {
  return _tag == DBTEAMRevokeDeviceSessionArgMobileClient;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMRevokeDeviceSessionArgWebSession:
    return @"DBTEAMRevokeDeviceSessionArgWebSession";
  case DBTEAMRevokeDeviceSessionArgDesktopClient:
    return @"DBTEAMRevokeDeviceSessionArgDesktopClient";
  case DBTEAMRevokeDeviceSessionArgMobileClient:
    return @"DBTEAMRevokeDeviceSessionArgMobileClient";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMRevokeDeviceSessionArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMRevokeDeviceSessionArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMRevokeDeviceSessionArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMRevokeDeviceSessionArgWebSession:
    result = prime * result + [self.webSession hash];
    break;
  case DBTEAMRevokeDeviceSessionArgDesktopClient:
    result = prime * result + [self.desktopClient hash];
    break;
  case DBTEAMRevokeDeviceSessionArgMobileClient:
    result = prime * result + [self.mobileClient hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRevokeDeviceSessionArg:other];
}

- (BOOL)isEqualToRevokeDeviceSessionArg:(DBTEAMRevokeDeviceSessionArg *)aRevokeDeviceSessionArg {
  if (self == aRevokeDeviceSessionArg) {
    return YES;
  }
  if (self.tag != aRevokeDeviceSessionArg.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMRevokeDeviceSessionArgWebSession:
    return [self.webSession isEqual:aRevokeDeviceSessionArg.webSession];
  case DBTEAMRevokeDeviceSessionArgDesktopClient:
    return [self.desktopClient isEqual:aRevokeDeviceSessionArg.desktopClient];
  case DBTEAMRevokeDeviceSessionArgMobileClient:
    return [self.mobileClient isEqual:aRevokeDeviceSessionArg.mobileClient];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMRevokeDeviceSessionArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMRevokeDeviceSessionArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isWebSession]) {
    jsonDict = [[DBTEAMDeviceSessionArgSerializer serialize:valueObj.webSession] mutableCopy];
    jsonDict[@".tag"] = @"web_session";
  } else if ([valueObj isDesktopClient]) {
    jsonDict = [[DBTEAMRevokeDesktopClientArgSerializer serialize:valueObj.desktopClient] mutableCopy];
    jsonDict[@".tag"] = @"desktop_client";
  } else if ([valueObj isMobileClient]) {
    jsonDict = [[DBTEAMDeviceSessionArgSerializer serialize:valueObj.mobileClient] mutableCopy];
    jsonDict[@".tag"] = @"mobile_client";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMRevokeDeviceSessionArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"web_session"]) {
    DBTEAMDeviceSessionArg *webSession = [DBTEAMDeviceSessionArgSerializer deserialize:valueDict];
    return [[DBTEAMRevokeDeviceSessionArg alloc] initWithWebSession:webSession];
  } else if ([tag isEqualToString:@"desktop_client"]) {
    DBTEAMRevokeDesktopClientArg *desktopClient = [DBTEAMRevokeDesktopClientArgSerializer deserialize:valueDict];
    return [[DBTEAMRevokeDeviceSessionArg alloc] initWithDesktopClient:desktopClient];
  } else if ([tag isEqualToString:@"mobile_client"]) {
    DBTEAMDeviceSessionArg *mobileClient = [DBTEAMDeviceSessionArgSerializer deserialize:valueDict];
    return [[DBTEAMRevokeDeviceSessionArg alloc] initWithMobileClient:mobileClient];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMRevokeDeviceSessionArg.h"
#import "DBTEAMRevokeDeviceSessionBatchArg.h"

#pragma mark - API Object

@implementation DBTEAMRevokeDeviceSessionBatchArg

#pragma mark - Constructors

- (instancetype)initWithRevokeDevices:(NSArray<DBTEAMRevokeDeviceSessionArg *> *)revokeDevices {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](revokeDevices);

  self = [super init];
  if (self) {
    _revokeDevices = revokeDevices;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMRevokeDeviceSessionBatchArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMRevokeDeviceSessionBatchArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMRevokeDeviceSessionBatchArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.revokeDevices hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRevokeDeviceSessionBatchArg:other];
}

- (BOOL)isEqualToRevokeDeviceSessionBatchArg:(DBTEAMRevokeDeviceSessionBatchArg *)aRevokeDeviceSessionBatchArg {
  if (self == aRevokeDeviceSessionBatchArg) {
    return YES;
  }
  if (![self.revokeDevices isEqual:aRevokeDeviceSessionBatchArg.revokeDevices]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMRevokeDeviceSessionBatchArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMRevokeDeviceSessionBatchArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"revoke_devices"] = [DBArraySerializer serialize:valueObj.revokeDevices
                                                   withBlock:^id(id elem0) {
                                                     return [DBTEAMRevokeDeviceSessionArgSerializer serialize:elem0];
                                                   }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMRevokeDeviceSessionBatchArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBTEAMRevokeDeviceSessionArg *> *revokeDevices =
      [DBArraySerializer deserialize:valueDict[@"revoke_devices"]
                           withBlock:^id(id elem0) {
                             return [DBTEAMRevokeDeviceSessionArgSerializer deserialize:elem0];
                           }];

  return [[DBTEAMRevokeDeviceSessionBatchArg alloc] initWithRevokeDevices:revokeDevices];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMRevokeDeviceSessionBatchError.h"

#pragma mark - API Object

@implementation DBTEAMRevokeDeviceSessionBatchError

#pragma mark - Constructors

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMRevokeDeviceSessionBatchErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isOther {
  return _tag == DBTEAMRevokeDeviceSessionBatchErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMRevokeDeviceSessionBatchErrorOther:
    return @"DBTEAMRevokeDeviceSessionBatchErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMRevokeDeviceSessionBatchErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMRevokeDeviceSessionBatchErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMRevokeDeviceSessionBatchErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMRevokeDeviceSessionBatchErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRevokeDeviceSessionBatchError:other];
}

- (BOOL)isEqualToRevokeDeviceSessionBatchError:(DBTEAMRevokeDeviceSessionBatchError *)aRevokeDeviceSessionBatchError {
  if (self == aRevokeDeviceSessionBatchError) {
    return YES;
  }
  if (self.tag != aRevokeDeviceSessionBatchError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMRevokeDeviceSessionBatchErrorOther:
    return [[self tagName] isEqual:[aRevokeDeviceSessionBatchError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMRevokeDeviceSessionBatchErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMRevokeDeviceSessionBatchError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMRevokeDeviceSessionBatchError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMRevokeDeviceSessionBatchError alloc] initWithOther];
  } else {
    return [[DBTEAMRevokeDeviceSessionBatchError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMRevokeDeviceSessionBatchResult.h"
#import "DBTEAMRevokeDeviceSessionStatus.h"

#pragma mark - API Object

@implementation DBTEAMRevokeDeviceSessionBatchResult

#pragma mark - Constructors

- (instancetype)initWithRevokeDevicesStatus:(NSArray<DBTEAMRevokeDeviceSessionStatus *> *)revokeDevicesStatus {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](revokeDevicesStatus);

  self = [super init];
  if (self) {
    _revokeDevicesStatus = revokeDevicesStatus;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMRevokeDeviceSessionBatchResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMRevokeDeviceSessionBatchResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMRevokeDeviceSessionBatchResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.revokeDevicesStatus hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRevokeDeviceSessionBatchResult:other];
}

- (BOOL)isEqualToRevokeDeviceSessionBatchResult:
    (DBTEAMRevokeDeviceSessionBatchResult *)aRevokeDeviceSessionBatchResult {
  if (self == aRevokeDeviceSessionBatchResult) {
    return YES;
  }
  if (![self.revokeDevicesStatus isEqual:aRevokeDeviceSessionBatchResult.revokeDevicesStatus]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMRevokeDeviceSessionBatchResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMRevokeDeviceSessionBatchResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"revoke_devices_status"] =
      [DBArraySerializer serialize:valueObj.revokeDevicesStatus
                         withBlock:^id(id elem0) {
                           return [DBTEAMRevokeDeviceSessionStatusSerializer serialize:elem0];
                         }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMRevokeDeviceSessionBatchResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBTEAMRevokeDeviceSessionStatus *> *revokeDevicesStatus =
      [DBArraySerializer deserialize:valueDict[@"revoke_devices_status"]
                           withBlock:^id(id elem0) {
                             return [DBTEAMRevokeDeviceSessionStatusSerializer deserialize:elem0];
                           }];

  return [[DBTEAMRevokeDeviceSessionBatchResult alloc] initWithRevokeDevicesStatus:revokeDevicesStatus];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMRevokeDeviceSessionError.h"

#pragma mark - API Object

@implementation DBTEAMRevokeDeviceSessionError

#pragma mark - Constructors

- (instancetype)initWithDeviceSessionNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMRevokeDeviceSessionErrorDeviceSessionNotFound;
  }
  return self;
}

- (instancetype)initWithMemberNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMRevokeDeviceSessionErrorMemberNotFound;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMRevokeDeviceSessionErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDeviceSessionNotFound {
  return _tag == DBTEAMRevokeDeviceSessionErrorDeviceSessionNotFound;
}

- (BOOL)isMemberNotFound {
  return _tag == DBTEAMRevokeDeviceSessionErrorMemberNotFound;
}

- (BOOL)isOther {
  return _tag == DBTEAMRevokeDeviceSessionErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMRevokeDeviceSessionErrorDeviceSessionNotFound:
    return @"DBTEAMRevokeDeviceSessionErrorDeviceSessionNotFound";
  case DBTEAMRevokeDeviceSessionErrorMemberNotFound:
    return @"DBTEAMRevokeDeviceSessionErrorMemberNotFound";
  case DBTEAMRevokeDeviceSessionErrorOther:
    return @"DBTEAMRevokeDeviceSessionErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMRevokeDeviceSessionErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMRevokeDeviceSessionErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMRevokeDeviceSessionErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMRevokeDeviceSessionErrorDeviceSessionNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMRevokeDeviceSessionErrorMemberNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMRevokeDeviceSessionErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRevokeDeviceSessionError:other];
}

- (BOOL)isEqualToRevokeDeviceSessionError:(DBTEAMRevokeDeviceSessionError *)aRevokeDeviceSessionError {
  if (self == aRevokeDeviceSessionError) {
    return YES;
  }
  if (self.tag != aRevokeDeviceSessionError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMRevokeDeviceSessionErrorDeviceSessionNotFound:
    return [[self tagName] isEqual:[aRevokeDeviceSessionError tagName]];
  case DBTEAMRevokeDeviceSessionErrorMemberNotFound:
    return [[self tagName] isEqual:[aRevokeDeviceSessionError tagName]];
  case DBTEAMRevokeDeviceSessionErrorOther:
    return [[self tagName] isEqual:[aRevokeDeviceSessionError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMRevokeDeviceSessionErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMRevokeDeviceSessionError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDeviceSessionNotFound]) {
    jsonDict[@".tag"] = @"device_session_not_found";
  } else if ([valueObj isMemberNotFound]) {
    jsonDict[@".tag"] = @"member_not_found";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMRevokeDeviceSessionError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"device_session_not_found"]) {
    return [[DBTEAMRevokeDeviceSessionError alloc] initWithDeviceSessionNotFound];
  } else if ([tag isEqualToString:@"member_not_found"]) {
    return [[DBTEAMRevokeDeviceSessionError alloc] initWithMemberNotFound];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMRevokeDeviceSessionError alloc] initWithOther];
  } else {
    return [[DBTEAMRevokeDeviceSessionError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMRevokeDeviceSessionError.h"
#import "DBTEAMRevokeDeviceSessionStatus.h"

#pragma mark - API Object

@implementation DBTEAMRevokeDeviceSessionStatus

#pragma mark - Constructors

- (instancetype)initWithSuccess:(NSNumber *)success errorType:(DBTEAMRevokeDeviceSessionError *)errorType {
  [DBStoneValidators nonnullValidator:nil](success);

  self = [super init];
  if (self) {
    _success = success;
    _errorType = errorType;
  }
  return self;
}

- (instancetype)initWithSuccess:(NSNumber *)success {
  return [self initWithSuccess:success errorType:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMRevokeDeviceSessionStatusSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMRevokeDeviceSessionStatusSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMRevokeDeviceSessionStatusSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.success hash];
  if (self.errorType != nil) {
    result = prime * result + [self.errorType hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRevokeDeviceSessionStatus:other];
}

- (BOOL)isEqualToRevokeDeviceSessionStatus:(DBTEAMRevokeDeviceSessionStatus *)aRevokeDeviceSessionStatus {
  if (self == aRevokeDeviceSessionStatus) {
    return YES;
  }
  if (![self.success isEqual:aRevokeDeviceSessionStatus.success]) {
    return NO;
  }
  if (self.errorType) {
    if (![self.errorType isEqual:aRevokeDeviceSessionStatus.errorType]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMRevokeDeviceSessionStatusSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMRevokeDeviceSessionStatus *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"success"] = valueObj.success;
  if (valueObj.errorType) {
    jsonDict[@"error_type"] = [DBTEAMRevokeDeviceSessionErrorSerializer serialize:valueObj.errorType];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMRevokeDeviceSessionStatus *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSNumber *success = valueDict[@"success"];
  DBTEAMRevokeDeviceSessionError *errorType =
      valueDict[@"error_type"] ? [DBTEAMRevokeDeviceSessionErrorSerializer deserialize:valueDict[@"error_type"]] : nil;

  return [[DBTEAMRevokeDeviceSessionStatus alloc] initWithSuccess:success errorType:errorType];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMRevokeLinkedApiAppArg.h"

#pragma mark - API Object

@implementation DBTEAMRevokeLinkedApiAppArg

#pragma mark - Constructors

- (instancetype)initWithAppId:(NSString *)appId
                 teamMemberId:(NSString *)teamMemberId
                keepAppFolder:(NSNumber *)keepAppFolder {
  [DBStoneValidators nonnullValidator:nil](appId);
  [DBStoneValidators nonnullValidator:nil](teamMemberId);

  self = [super init];
  if (self) {
    _appId = appId;
    _teamMemberId = teamMemberId;
    _keepAppFolder = keepAppFolder ?: @YES;
  }
  return self;
}

- (instancetype)initWithAppId:(NSString *)appId teamMemberId:(NSString *)teamMemberId {
  return [self initWithAppId:appId teamMemberId:teamMemberId keepAppFolder:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMRevokeLinkedApiAppArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMRevokeLinkedApiAppArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMRevokeLinkedApiAppArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.appId hash];
  result = prime * result + [self.teamMemberId hash];
  result = prime * result + [self.keepAppFolder hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRevokeLinkedApiAppArg:other];
}

- (BOOL)isEqualToRevokeLinkedApiAppArg:(DBTEAMRevokeLinkedApiAppArg *)aRevokeLinkedApiAppArg {
  if (self == aRevokeLinkedApiAppArg) {
    return YES;
  }
  if (![self.appId isEqual:aRevokeLinkedApiAppArg.appId]) {
    return NO;
  }
  if (![self.teamMemberId isEqual:aRevokeLinkedApiAppArg.teamMemberId]) {
    return NO;
  }
  if (![self.keepAppFolder isEqual:aRevokeLinkedApiAppArg.keepAppFolder]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMRevokeLinkedApiAppArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMRevokeLinkedApiAppArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"app_id"] = valueObj.appId;
  jsonDict[@"team_member_id"] = valueObj.teamMemberId;
  jsonDict[@"keep_app_folder"] = valueObj.keepAppFolder;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMRevokeLinkedApiAppArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *appId = valueDict[@"app_id"];
  NSString *teamMemberId = valueDict[@"team_member_id"];
  NSNumber *keepAppFolder = valueDict[@"keep_app_folder"] ?: @YES;

  return
      [[DBTEAMRevokeLinkedApiAppArg alloc] initWithAppId:appId teamMemberId:teamMemberId keepAppFolder:keepAppFolder];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMRevokeLinkedApiAppArg.h"
#import "DBTEAMRevokeLinkedApiAppBatchArg.h"

#pragma mark - API Object

@implementation DBTEAMRevokeLinkedApiAppBatchArg

#pragma mark - Constructors

- (instancetype)initWithRevokeLinkedApp:(NSArray<DBTEAMRevokeLinkedApiAppArg *> *)revokeLinkedApp {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](revokeLinkedApp);

  self = [super init];
  if (self) {
    _revokeLinkedApp = revokeLinkedApp;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMRevokeLinkedApiAppBatchArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMRevokeLinkedApiAppBatchArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMRevokeLinkedApiAppBatchArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.revokeLinkedApp hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRevokeLinkedApiAppBatchArg:other];
}

- (BOOL)isEqualToRevokeLinkedApiAppBatchArg:(DBTEAMRevokeLinkedApiAppBatchArg *)aRevokeLinkedApiAppBatchArg {
  if (self == aRevokeLinkedApiAppBatchArg) {
    return YES;
  }
  if (![self.revokeLinkedApp isEqual:aRevokeLinkedApiAppBatchArg.revokeLinkedApp]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMRevokeLinkedApiAppBatchArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMRevokeLinkedApiAppBatchArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"revoke_linked_app"] = [DBArraySerializer serialize:valueObj.revokeLinkedApp
                                                      withBlock:^id(id elem0) {
                                                        return [DBTEAMRevokeLinkedApiAppArgSerializer serialize:elem0];
                                                      }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMRevokeLinkedApiAppBatchArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBTEAMRevokeLinkedApiAppArg *> *revokeLinkedApp =
      [DBArraySerializer deserialize:valueDict[@"revoke_linked_app"]
                           withBlock:^id(id elem0) {
                             return [DBTEAMRevokeLinkedApiAppArgSerializer deserialize:elem0];
                           }];

  return [[DBTEAMRevokeLinkedApiAppBatchArg alloc] initWithRevokeLinkedApp:revokeLinkedApp];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMRevokeLinkedAppBatchError.h"

#pragma mark - API Object

@implementation DBTEAMRevokeLinkedAppBatchError

#pragma mark - Constructors

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMRevokeLinkedAppBatchErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isOther {
  return _tag == DBTEAMRevokeLinkedAppBatchErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMRevokeLinkedAppBatchErrorOther:
    return @"DBTEAMRevokeLinkedAppBatchErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMRevokeLinkedAppBatchErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMRevokeLinkedAppBatchErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMRevokeLinkedAppBatchErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMRevokeLinkedAppBatchErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRevokeLinkedAppBatchError:other];
}

- (BOOL)isEqualToRevokeLinkedAppBatchError:(DBTEAMRevokeLinkedAppBatchError *)aRevokeLinkedAppBatchError {
  if (self == aRevokeLinkedAppBatchError) {
    return YES;
  }
  if (self.tag != aRevokeLinkedAppBatchError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMRevokeLinkedAppBatchErrorOther:
    return [[self tagName] isEqual:[aRevokeLinkedAppBatchError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMRevokeLinkedAppBatchErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMRevokeLinkedAppBatchError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMRevokeLinkedAppBatchError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMRevokeLinkedAppBatchError alloc] initWithOther];
  } else {
    return [[DBTEAMRevokeLinkedAppBatchError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMRevokeLinkedAppBatchResult.h"
#import "DBTEAMRevokeLinkedAppStatus.h"

#pragma mark - API Object

@implementation DBTEAMRevokeLinkedAppBatchResult

#pragma mark - Constructors

- (instancetype)initWithRevokeLinkedAppStatus:(NSArray<DBTEAMRevokeLinkedAppStatus *> *)revokeLinkedAppStatus {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](revokeLinkedAppStatus);

  self = [super init];
  if (self) {
    _revokeLinkedAppStatus = revokeLinkedAppStatus;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMRevokeLinkedAppBatchResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMRevokeLinkedAppBatchResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMRevokeLinkedAppBatchResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.revokeLinkedAppStatus hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRevokeLinkedAppBatchResult:other];
}

- (BOOL)isEqualToRevokeLinkedAppBatchResult:(DBTEAMRevokeLinkedAppBatchResult *)aRevokeLinkedAppBatchResult {
  if (self == aRevokeLinkedAppBatchResult) {
    return YES;
  }
  if (![self.revokeLinkedAppStatus isEqual:aRevokeLinkedAppBatchResult.revokeLinkedAppStatus]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMRevokeLinkedAppBatchResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMRevokeLinkedAppBatchResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"revoke_linked_app_status"] =
      [DBArraySerializer serialize:valueObj.revokeLinkedAppStatus
                         withBlock:^id(id elem0) {
                           return [DBTEAMRevokeLinkedAppStatusSerializer serialize:elem0];
                         }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMRevokeLinkedAppBatchResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBTEAMRevokeLinkedAppStatus *> *revokeLinkedAppStatus =
      [DBArraySerializer deserialize:valueDict[@"revoke_linked_app_status"]
                           withBlock:^id(id elem0) {
                             return [DBTEAMRevokeLinkedAppStatusSerializer deserialize:elem0];
                           }];

  return [[DBTEAMRevokeLinkedAppBatchResult alloc] initWithRevokeLinkedAppStatus:revokeLinkedAppStatus];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMRevokeLinkedAppError.h"

#pragma mark - API Object

@implementation DBTEAMRevokeLinkedAppError

#pragma mark - Constructors

- (instancetype)initWithAppNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMRevokeLinkedAppErrorAppNotFound;
  }
  return self;
}

- (instancetype)initWithMemberNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMRevokeLinkedAppErrorMemberNotFound;
  }
  return self;
}

- (instancetype)initWithAppFolderRemovalNotSupported {
  self = [super init];
  if (self) {
    _tag = DBTEAMRevokeLinkedAppErrorAppFolderRemovalNotSupported;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMRevokeLinkedAppErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isAppNotFound {
  return _tag == DBTEAMRevokeLinkedAppErrorAppNotFound;
}

- (BOOL)isMemberNotFound {
  return _tag == DBTEAMRevokeLinkedAppErrorMemberNotFound;
}

- (BOOL)isAppFolderRemovalNotSupported {
  return _tag == DBTEAMRevokeLinkedAppErrorAppFolderRemovalNotSupported;
}

- (BOOL)isOther {
  return _tag == DBTEAMRevokeLinkedAppErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMRevokeLinkedAppErrorAppNotFound:
    return @"DBTEAMRevokeLinkedAppErrorAppNotFound";
  case DBTEAMRevokeLinkedAppErrorMemberNotFound:
    return @"DBTEAMRevokeLinkedAppErrorMemberNotFound";
  case DBTEAMRevokeLinkedAppErrorAppFolderRemovalNotSupported:
    return @"DBTEAMRevokeLinkedAppErrorAppFolderRemovalNotSupported";
  case DBTEAMRevokeLinkedAppErrorOther:
    return @"DBTEAMRevokeLinkedAppErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMRevokeLinkedAppErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMRevokeLinkedAppErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMRevokeLinkedAppErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMRevokeLinkedAppErrorAppNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMRevokeLinkedAppErrorMemberNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMRevokeLinkedAppErrorAppFolderRemovalNotSupported:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMRevokeLinkedAppErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRevokeLinkedAppError:other];
}

- (BOOL)isEqualToRevokeLinkedAppError:(DBTEAMRevokeLinkedAppError *)aRevokeLinkedAppError {
  if (self == aRevokeLinkedAppError) {
    return YES;
  }
  if (self.tag != aRevokeLinkedAppError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMRevokeLinkedAppErrorAppNotFound:
    return [[self tagName] isEqual:[aRevokeLinkedAppError tagName]];
  case DBTEAMRevokeLinkedAppErrorMemberNotFound:
    return [[self tagName] isEqual:[aRevokeLinkedAppError tagName]];
  case DBTEAMRevokeLinkedAppErrorAppFolderRemovalNotSupported:
    return [[self tagName] isEqual:[aRevokeLinkedAppError tagName]];
  case DBTEAMRevokeLinkedAppErrorOther:
    return [[self tagName] isEqual:[aRevokeLinkedAppError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMRevokeLinkedAppErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMRevokeLinkedAppError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAppNotFound]) {
    jsonDict[@".tag"] = @"app_not_found";
  } else if ([valueObj isMemberNotFound]) {
    jsonDict[@".tag"] = @"member_not_found";
  } else if ([valueObj isAppFolderRemovalNotSupported]) {
    jsonDict[@".tag"] = @"app_folder_removal_not_supported";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMRevokeLinkedAppError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"app_not_found"]) {
    return [[DBTEAMRevokeLinkedAppError alloc] initWithAppNotFound];
  } else if ([tag isEqualToString:@"member_not_found"]) {
    return [[DBTEAMRevokeLinkedAppError alloc] initWithMemberNotFound];
  } else if ([tag isEqualToString:@"app_folder_removal_not_supported"]) {
    return [[DBTEAMRevokeLinkedAppError alloc] initWithAppFolderRemovalNotSupported];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMRevokeLinkedAppError alloc] initWithOther];
  } else {
    return [[DBTEAMRevokeLinkedAppError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMRevokeLinkedAppError.h"
#import "DBTEAMRevokeLinkedAppStatus.h"

#pragma mark - API Object

@implementation DBTEAMRevokeLinkedAppStatus

#pragma mark - Constructors

- (instancetype)initWithSuccess:(NSNumber *)success errorType:(DBTEAMRevokeLinkedAppError *)errorType {
  [DBStoneValidators nonnullValidator:nil](success);

  self = [super init];
  if (self) {
    _success = success;
    _errorType = errorType;
  }
  return self;
}

- (instancetype)initWithSuccess:(NSNumber *)success {
  return [self initWithSuccess:success errorType:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMRevokeLinkedAppStatusSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMRevokeLinkedAppStatusSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMRevokeLinkedAppStatusSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.success hash];
  if (self.errorType != nil) {
    result = prime * result + [self.errorType hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRevokeLinkedAppStatus:other];
}

- (BOOL)isEqualToRevokeLinkedAppStatus:(DBTEAMRevokeLinkedAppStatus *)aRevokeLinkedAppStatus {
  if (self == aRevokeLinkedAppStatus) {
    return YES;
  }
  if (![self.success isEqual:aRevokeLinkedAppStatus.success]) {
    return NO;
  }
  if (self.errorType) {
    if (![self.errorType isEqual:aRevokeLinkedAppStatus.errorType]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMRevokeLinkedAppStatusSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMRevokeLinkedAppStatus *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"success"] = valueObj.success;
  if (valueObj.errorType) {
    jsonDict[@"error_type"] = [DBTEAMRevokeLinkedAppErrorSerializer serialize:valueObj.errorType];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMRevokeLinkedAppStatus *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSNumber *success = valueDict[@"success"];
  DBTEAMRevokeLinkedAppError *errorType =
      valueDict[@"error_type"] ? [DBTEAMRevokeLinkedAppErrorSerializer deserialize:valueDict[@"error_type"]] : nil;

  return [[DBTEAMRevokeLinkedAppStatus alloc] initWithSuccess:success errorType:errorType];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMSetCustomQuotaArg.h"
#import "DBTEAMUserCustomQuotaArg.h"

#pragma mark - API Object

@implementation DBTEAMSetCustomQuotaArg

#pragma mark - Constructors

- (instancetype)initWithUsersAndQuotas:(NSArray<DBTEAMUserCustomQuotaArg *> *)usersAndQuotas {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](usersAndQuotas);

  self = [super init];
  if (self) {
    _usersAndQuotas = usersAndQuotas;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMSetCustomQuotaArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMSetCustomQuotaArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMSetCustomQuotaArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.usersAndQuotas hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSetCustomQuotaArg:other];
}

- (BOOL)isEqualToSetCustomQuotaArg:(DBTEAMSetCustomQuotaArg *)aSetCustomQuotaArg {
  if (self == aSetCustomQuotaArg) {
    return YES;
  }
  if (![self.usersAndQuotas isEqual:aSetCustomQuotaArg.usersAndQuotas]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMSetCustomQuotaArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMSetCustomQuotaArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"users_and_quotas"] = [DBArraySerializer serialize:valueObj.usersAndQuotas
                                                     withBlock:^id(id elem0) {
                                                       return [DBTEAMUserCustomQuotaArgSerializer serialize:elem0];
                                                     }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMSetCustomQuotaArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBTEAMUserCustomQuotaArg *> *usersAndQuotas =
      [DBArraySerializer deserialize:valueDict[@"users_and_quotas"]
                           withBlock:^id(id elem0) {
                             return [DBTEAMUserCustomQuotaArgSerializer deserialize:elem0];
                           }];

  return [[DBTEAMSetCustomQuotaArg alloc] initWithUsersAndQuotas:usersAndQuotas];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMCustomQuotaError.h"
#import "DBTEAMSetCustomQuotaError.h"

#pragma mark - API Object

@implementation DBTEAMSetCustomQuotaError

#pragma mark - Constructors

- (instancetype)initWithTooManyUsers {
  self = [super init];
  if (self) {
    _tag = DBTEAMSetCustomQuotaErrorTooManyUsers;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMSetCustomQuotaErrorOther;
  }
  return self;
}

- (instancetype)initWithSomeUsersAreExcluded {
  self = [super init];
  if (self) {
    _tag = DBTEAMSetCustomQuotaErrorSomeUsersAreExcluded;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isTooManyUsers {
  return _tag == DBTEAMSetCustomQuotaErrorTooManyUsers;
}

- (BOOL)isOther {
  return _tag == DBTEAMSetCustomQuotaErrorOther;
}

- (BOOL)isSomeUsersAreExcluded {
  return _tag == DBTEAMSetCustomQuotaErrorSomeUsersAreExcluded;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMSetCustomQuotaErrorTooManyUsers:
    return @"DBTEAMSetCustomQuotaErrorTooManyUsers";
  case DBTEAMSetCustomQuotaErrorOther:
    return @"DBTEAMSetCustomQuotaErrorOther";
  case DBTEAMSetCustomQuotaErrorSomeUsersAreExcluded:
    return @"DBTEAMSetCustomQuotaErrorSomeUsersAreExcluded";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMSetCustomQuotaErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMSetCustomQuotaErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMSetCustomQuotaErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMSetCustomQuotaErrorTooManyUsers:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMSetCustomQuotaErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMSetCustomQuotaErrorSomeUsersAreExcluded:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSetCustomQuotaError:other];
}

- (BOOL)isEqualToSetCustomQuotaError:(DBTEAMSetCustomQuotaError *)aSetCustomQuotaError {
  if (self == aSetCustomQuotaError) {
    return YES;
  }
  if (self.tag != aSetCustomQuotaError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMSetCustomQuotaErrorTooManyUsers:
    return [[self tagName] isEqual:[aSetCustomQuotaError tagName]];
  case DBTEAMSetCustomQuotaErrorOther:
    return [[self tagName] isEqual:[aSetCustomQuotaError tagName]];
  case DBTEAMSetCustomQuotaErrorSomeUsersAreExcluded:
    return [[self tagName] isEqual:[aSetCustomQuotaError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMSetCustomQuotaErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMSetCustomQuotaError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isTooManyUsers]) {
    jsonDict[@".tag"] = @"too_many_users";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isSomeUsersAreExcluded]) {
    jsonDict[@".tag"] = @"some_users_are_excluded";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMSetCustomQuotaError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"too_many_users"]) {
    return [[DBTEAMSetCustomQuotaError alloc] initWithTooManyUsers];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMSetCustomQuotaError alloc] initWithOther];
  } else if ([tag isEqualToString:@"some_users_are_excluded"]) {
    return [[DBTEAMSetCustomQuotaError alloc] initWithSomeUsersAreExcluded];
  } else {
    return [[DBTEAMSetCustomQuotaError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMStorageBucket.h"

#pragma mark - API Object

@implementation DBTEAMStorageBucket

#pragma mark - Constructors

- (instancetype)initWithBucket:(NSString *)bucket users:(NSNumber *)users {
  [DBStoneValidators nonnullValidator:nil](bucket);
  [DBStoneValidators nonnullValidator:nil](users);

  self = [super init];
  if (self) {
    _bucket = bucket;
    _users = users;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMStorageBucketSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMStorageBucketSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMStorageBucketSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.bucket hash];
  result = prime * result + [self.users hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToStorageBucket:other];
}

- (BOOL)isEqualToStorageBucket:(DBTEAMStorageBucket *)aStorageBucket {
  if (self == aStorageBucket) {
    return YES;
  }
  if (![self.bucket isEqual:aStorageBucket.bucket]) {
    return NO;
  }
  if (![self.users isEqual:aStorageBucket.users]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMStorageBucketSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMStorageBucket *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"bucket"] = valueObj.bucket;
  jsonDict[@"users"] = valueObj.users;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMStorageBucket *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *bucket = valueDict[@"bucket"];
  NSNumber *users = valueDict[@"users"];

  return [[DBTEAMStorageBucket alloc] initWithBucket:bucket users:users];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMTeamFolderAccessError.h"

#pragma mark - API Object

@implementation DBTEAMTeamFolderAccessError

#pragma mark - Constructors

- (instancetype)initWithInvalidTeamFolderId {
  self = [super init];
  if (self) {
    _tag = DBTEAMTeamFolderAccessErrorInvalidTeamFolderId;
  }
  return self;
}

- (instancetype)initWithNoAccess {
  self = [super init];
  if (self) {
    _tag = DBTEAMTeamFolderAccessErrorNoAccess;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMTeamFolderAccessErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isInvalidTeamFolderId {
  return _tag == DBTEAMTeamFolderAccessErrorInvalidTeamFolderId;
}

- (BOOL)isNoAccess {
  return _tag == DBTEAMTeamFolderAccessErrorNoAccess;
}

- (BOOL)isOther {
  return _tag == DBTEAMTeamFolderAccessErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMTeamFolderAccessErrorInvalidTeamFolderId:
    return @"DBTEAMTeamFolderAccessErrorInvalidTeamFolderId";
  case DBTEAMTeamFolderAccessErrorNoAccess:
    return @"DBTEAMTeamFolderAccessErrorNoAccess";
  case DBTEAMTeamFolderAccessErrorOther:
    return @"DBTEAMTeamFolderAccessErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMTeamFolderAccessErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMTeamFolderAccessErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMTeamFolderAccessErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMTeamFolderAccessErrorInvalidTeamFolderId:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMTeamFolderAccessErrorNoAccess:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMTeamFolderAccessErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToTeamFolderAccessError:other];
}

- (BOOL)isEqualToTeamFolderAccessError:(DBTEAMTeamFolderAccessError *)aTeamFolderAccessError {
  if (self == aTeamFolderAccessError) {
    return YES;
  }
  if (self.tag != aTeamFolderAccessError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMTeamFolderAccessErrorInvalidTeamFolderId:
    return [[self tagName] isEqual:[aTeamFolderAccessError tagName]];
  case DBTEAMTeamFolderAccessErrorNoAccess:
    return [[self tagName] isEqual:[aTeamFolderAccessError tagName]];
  case DBTEAMTeamFolderAccessErrorOther:
    return [[self tagName] isEqual:[aTeamFolderAccessError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMTeamFolderAccessErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMTeamFolderAccessError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isInvalidTeamFolderId]) {
    jsonDict[@".tag"] = @"invalid_team_folder_id";
  } else if ([valueObj isNoAccess]) {
    jsonDict[@".tag"] = @"no_access";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMTeamFolderAccessError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"invalid_team_folder_id"]) {
    return [[DBTEAMTeamFolderAccessError alloc] initWithInvalidTeamFolderId];
  } else if ([tag isEqualToString:@"no_access"]) {
    return [[DBTEAMTeamFolderAccessError alloc] initWithNoAccess];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMTeamFolderAccessError alloc] initWithOther];
  } else {
    return [[DBTEAMTeamFolderAccessError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMBaseTeamFolderError.h"
#import "DBTEAMTeamFolderAccessError.h"
#import "DBTEAMTeamFolderActivateError.h"
#import "DBTEAMTeamFolderInvalidStatusError.h"
#import "DBTEAMTeamFolderTeamSharedDropboxError.h"

#pragma mark - API Object

@implementation DBTEAMTeamFolderActivateError

@synthesize accessError = _accessError;
@synthesize statusError = _statusError;
@synthesize teamSharedDropboxError = _teamSharedDropboxError;

#pragma mark - Constructors

- (instancetype)initWithAccessError:(DBTEAMTeamFolderAccessError *)accessError {
  self = [super init];
  if (self) {
    _tag = DBTEAMTeamFolderActivateErrorAccessError;
    _accessError = accessError;
  }
  return self;
}

- (instancetype)initWithStatusError:(DBTEAMTeamFolderInvalidStatusError *)statusError {
  self = [super init];
  if (self) {
    _tag = DBTEAMTeamFolderActivateErrorStatusError;
    _statusError = statusError;
  }
  return self;
}

- (instancetype)initWithTeamSharedDropboxError:(DBTEAMTeamFolderTeamSharedDropboxError *)teamSharedDropboxError {
  self = [super init];
  if (self) {
    _tag = DBTEAMTeamFolderActivateErrorTeamSharedDropboxError;
    _teamSharedDropboxError = teamSharedDropboxError;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMTeamFolderActivateErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBTEAMTeamFolderAccessError *)accessError {
  if (![self isAccessError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMTeamFolderActivateErrorAccessError, but was %@.", [self tagName]];
  }
  return _accessError;
}

- (DBTEAMTeamFolderInvalidStatusError *)statusError {
  if (![self isStatusError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMTeamFolderActivateErrorStatusError, but was %@.", [self tagName]];
  }
  return _statusError;
}

- (DBTEAMTeamFolderTeamSharedDropboxError *)teamSharedDropboxError {
  if (![self isTeamSharedDropboxError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMTeamFolderActivateErrorTeamSharedDropboxError, but was %@.",
                       [self tagName]];
  }
  return _teamSharedDropboxError;
}

#pragma mark - Tag state methods

- (BOOL)isAccessError {
  return _tag == DBTEAMTeamFolderActivateErrorAccessError;
}

- (BOOL)isStatusError {
  return _tag == DBTEAMTeamFolderActivateErrorStatusError;
}

- (BOOL)isTeamSharedDropboxError {
  return _tag == DBTEAMTeamFolderActivateErrorTeamSharedDropboxError;
}

- (BOOL)isOther {
  return _tag == DBTEAMTeamFolderActivateErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMTeamFolderActivateErrorAccessError:
    return @"DBTEAMTeamFolderActivateErrorAccessError";
  case DBTEAMTeamFolderActivateErrorStatusError:
    return @"DBTEAMTeamFolderActivateErrorStatusError";
  case DBTEAMTeamFolderActivateErrorTeamSharedDropboxError:
    return @"DBTEAMTeamFolderActivateErrorTeamSharedDropboxError";
  case DBTEAMTeamFolderActivateErrorOther:
    return @"DBTEAMTeamFolderActivateErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMTeamFolderActivateErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMTeamFolderActivateErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMTeamFolderActivateErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMTeamFolderActivateErrorAccessError:
    result = prime * result + [self.accessError hash];
    break;
  case DBTEAMTeamFolderActivateErrorStatusError:
    result = prime * result + [self.statusError hash];
    break;
  case DBTEAMTeamFolderActivateErrorTeamSharedDropboxError:
    result = prime * result + [self.teamSharedDropboxError hash];
    break;
  case DBTEAMTeamFolderActivateErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToTeamFolderActivateError:other];
}

- (BOOL)isEqualToTeamFolderActivateError:(DBTEAMTeamFolderActivateError *)aTeamFolderActivateError {
  if (self == aTeamFolderActivateError) {
    return YES;
  }
  if (self.tag != aTeamFolderActivateError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMTeamFolderActivateErrorAccessError:
    return [self.accessError isEqual:aTeamFolderActivateError.accessError];
  case DBTEAMTeamFolderActivateErrorStatusError:
    return [self.statusError isEqual:aTeamFolderActivateError.statusError];
  case DBTEAMTeamFolderActivateErrorTeamSharedDropboxError:
    return [self.teamSharedDropboxError isEqual:aTeamFolderActivateError.teamSharedDropboxError];
  case DBTEAMTeamFolderActivateErrorOther:
    return [[self tagName] isEqual:[aTeamFolderActivateError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMTeamFolderActivateErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMTeamFolderActivateError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAccessError]) {
    jsonDict[@"access_error"] = [[DBTEAMTeamFolderAccessErrorSerializer serialize:valueObj.accessError] mutableCopy];
    jsonDict[@".tag"] = @"access_error";
  } else if ([valueObj isStatusError]) {
    jsonDict[@"status_error"] =
        [[DBTEAMTeamFolderInvalidStatusErrorSerializer serialize:valueObj.statusError] mutableCopy];
    jsonDict[@".tag"] = @"status_error";
  } else if ([valueObj isTeamSharedDropboxError]) {
    jsonDict[@"team_shared_dropbox_error"] =
        [[DBTEAMTeamFolderTeamSharedDropboxErrorSerializer serialize:valueObj.teamSharedDropboxError] mutableCopy];
    jsonDict[@".tag"] = @"team_shared_dropbox_error";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMTeamFolderActivateError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"access_error"]) {
    DBTEAMTeamFolderAccessError *accessError =
        [DBTEAMTeamFolderAccessErrorSerializer deserialize:valueDict[@"access_error"]];
    return [[DBTEAMTeamFolderActivateError alloc] initWithAccessError:accessError];
  } else if ([tag isEqualToString:@"status_error"]) {
    DBTEAMTeamFolderInvalidStatusError *statusError =
        [DBTEAMTeamFolderInvalidStatusErrorSerializer deserialize:valueDict[@"status_error"]];
    return [[DBTEAMTeamFolderActivateError alloc] initWithStatusError:statusError];
  } else if ([tag isEqualToString:@"team_shared_dropbox_error"]) {
    DBTEAMTeamFolderTeamSharedDropboxError *teamSharedDropboxError =
        [DBTEAMTeamFolderTeamSharedDropboxErrorSerializer deserialize:valueDict[@"team_shared_dropbox_error"]];
    return [[DBTEAMTeamFolderActivateError alloc] initWithTeamSharedDropboxError:teamSharedDropboxError];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMTeamFolderActivateError alloc] initWithOther];
  } else {
    return [[DBTEAMTeamFolderActivateError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMTeamFolderIdArg.h"

#pragma mark - API Object

@implementation DBTEAMTeamFolderIdArg

#pragma mark - Constructors

- (instancetype)initWithTeamFolderId:(NSString *)teamFolderId {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"[-_0-9a-zA-Z:]+"]](teamFolderId);

  self = [super init];
  if (self) {
    _teamFolderId = teamFolderId;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMTeamFolderIdArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMTeamFolderIdArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMTeamFolderIdArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.teamFolderId hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToTeamFolderIdArg:other];
}

- (BOOL)isEqualToTeamFolderIdArg:(DBTEAMTeamFolderIdArg *)aTeamFolderIdArg {
  if (self == aTeamFolderIdArg) {
    return YES;
  }
  if (![self.teamFolderId isEqual:aTeamFolderIdArg.teamFolderId]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMTeamFolderIdArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMTeamFolderIdArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"team_folder_id"] = valueObj.teamFolderId;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMTeamFolderIdArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *teamFolderId = valueDict[@"team_folder_id"];

  return [[DBTEAMTeamFolderIdArg alloc] initWithTeamFolderId:teamFolderId];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMTeamFolderArchiveArg.h"
#import "DBTEAMTeamFolderIdArg.h"

#pragma mark - API Object

@implementation DBTEAMTeamFolderArchiveArg

#pragma mark - Constructors

- (instancetype)initWithTeamFolderId:(NSString *)teamFolderId forceAsyncOff:(NSNumber *)forceAsyncOff {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"[-_0-9a-zA-Z:]+"]](teamFolderId);

  self = [super initWithTeamFolderId:teamFolderId];
  if (self) {
    _forceAsyncOff = forceAsyncOff ?: @NO;
  }
  return self;
}

- (instancetype)initWithTeamFolderId:(NSString *)teamFolderId {
  return [self initWithTeamFolderId:teamFolderId forceAsyncOff:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMTeamFolderArchiveArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMTeamFolderArchiveArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMTeamFolderArchiveArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.teamFolderId hash];
  result = prime * result + [self.forceAsyncOff hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToTeamFolderArchiveArg:other];
}

- (BOOL)isEqualToTeamFolderArchiveArg:(DBTEAMTeamFolderArchiveArg *)aTeamFolderArchiveArg {
  if (self == aTeamFolderArchiveArg) {
    return YES;
  }
  if (![self.teamFolderId isEqual:aTeamFolderArchiveArg.teamFolderId]) {
    return NO;
  }
  if (![self.forceAsyncOff isEqual:aTeamFolderArchiveArg.forceAsyncOff]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMTeamFolderArchiveArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMTeamFolderArchiveArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"team_folder_id"] = valueObj.teamFolderId;
  jsonDict[@"force_async_off"] = valueObj.forceAsyncOff;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMTeamFolderArchiveArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *teamFolderId = valueDict[@"team_folder_id"];
  NSNumber *forceAsyncOff = valueDict[@"force_async_off"] ?: @NO;

  return [[DBTEAMTeamFolderArchiveArg alloc] initWithTeamFolderId:teamFolderId forceAsyncOff:forceAsyncOff];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMBaseTeamFolderError.h"
#import "DBTEAMTeamFolderAccessError.h"
#import "DBTEAMTeamFolderArchiveError.h"
#import "DBTEAMTeamFolderInvalidStatusError.h"
#import "DBTEAMTeamFolderTeamSharedDropboxError.h"

#pragma mark - API Object

@implementation DBTEAMTeamFolderArchiveError

@synthesize accessError = _accessError;
@synthesize statusError = _statusError;
@synthesize teamSharedDropboxError = _teamSharedDropboxError;

#pragma mark - Constructors

- (instancetype)initWithAccessError:(DBTEAMTeamFolderAccessError *)accessError {
  self = [super init];
  if (self) {
    _tag = DBTEAMTeamFolderArchiveErrorAccessError;
    _accessError = accessError;
  }
  return self;
}

- (instancetype)initWithStatusError:(DBTEAMTeamFolderInvalidStatusError *)statusError {
  self = [super init];
  if (self) {
    _tag = DBTEAMTeamFolderArchiveErrorStatusError;
    _statusError = statusError;
  }
  return self;
}

- (instancetype)initWithTeamSharedDropboxError:(DBTEAMTeamFolderTeamSharedDropboxError *)teamSharedDropboxError {
  self = [super init];
  if (self) {
    _tag = DBTEAMTeamFolderArchiveErrorTeamSharedDropboxError;
    _teamSharedDropboxError = teamSharedDropboxError;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMTeamFolderArchiveErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBTEAMTeamFolderAccessError *)accessError {
  if (![self isAccessError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMTeamFolderArchiveErrorAccessError, but was %@.", [self tagName]];
  }
  return _accessError;
}

- (DBTEAMTeamFolderInvalidStatusError *)statusError {
  if (![self isStatusError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMTeamFolderArchiveErrorStatusError, but was %@.", [self tagName]];
  }
  return _statusError;
}

- (DBTEAMTeamFolderTeamSharedDropboxError *)teamSharedDropboxError {
  if (![self isTeamSharedDropboxError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMTeamFolderArchiveErrorTeamSharedDropboxError, but was %@.",
                       [self tagName]];
  }
  return _teamSharedDropboxError;
}

#pragma mark - Tag state methods

- (BOOL)isAccessError {
  return _tag == DBTEAMTeamFolderArchiveErrorAccessError;
}

- (BOOL)isStatusError {
  return _tag == DBTEAMTeamFolderArchiveErrorStatusError;
}

- (BOOL)isTeamSharedDropboxError {
  return _tag == DBTEAMTeamFolderArchiveErrorTeamSharedDropboxError;
}

- (BOOL)isOther {
  return _tag == DBTEAMTeamFolderArchiveErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMTeamFolderArchiveErrorAccessError:
    return @"DBTEAMTeamFolderArchiveErrorAccessError";
  case DBTEAMTeamFolderArchiveErrorStatusError:
    return @"DBTEAMTeamFolderArchiveErrorStatusError";
  case DBTEAMTeamFolderArchiveErrorTeamSharedDropboxError:
    return @"DBTEAMTeamFolderArchiveErrorTeamSharedDropboxError";
  case DBTEAMTeamFolderArchiveErrorOther:
    return @"DBTEAMTeamFolderArchiveErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMTeamFolderArchiveErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMTeamFolderArchiveErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMTeamFolderArchiveErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMTeamFolderArchiveErrorAccessError:
    result = prime * result + [self.accessError hash];
    break;
  case DBTEAMTeamFolderArchiveErrorStatusError:
    result = prime * result + [self.statusError hash];
    break;
  case DBTEAMTeamFolderArchiveErrorTeamSharedDropboxError:
    result = prime * result + [self.teamSharedDropboxError hash];
    break;
  case DBTEAMTeamFolderArchiveErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToTeamFolderArchiveError:other];
}

- (BOOL)isEqualToTeamFolderArchiveError:(DBTEAMTeamFolderArchiveError *)aTeamFolderArchiveError {
  if (self == aTeamFolderArchiveError) {
    return YES;
  }
  if (self.tag != aTeamFolderArchiveError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMTeamFolderArchiveErrorAccessError:
    return [self.accessError isEqual:aTeamFolderArchiveError.accessError];
  case DBTEAMTeamFolderArchiveErrorStatusError:
    return [self.statusError isEqual:aTeamFolderArchiveError.statusError];
  case DBTEAMTeamFolderArchiveErrorTeamSharedDropboxError:
    return [self.teamSharedDropboxError isEqual:aTeamFolderArchiveError.teamSharedDropboxError];
  case DBTEAMTeamFolderArchiveErrorOther:
    return [[self tagName] isEqual:[aTeamFolderArchiveError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMTeamFolderArchiveErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMTeamFolderArchiveError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAccessError]) {
    jsonDict[@"access_error"] = [[DBTEAMTeamFolderAccessErrorSerializer serialize:valueObj.accessError] mutableCopy];
    jsonDict[@".tag"] = @"access_error";
  } else if ([valueObj isStatusError]) {
    jsonDict[@"status_error"] =
        [[DBTEAMTeamFolderInvalidStatusErrorSerializer serialize:valueObj.statusError] mutableCopy];
    jsonDict[@".tag"] = @"status_error";
  } else if ([valueObj isTeamSharedDropboxError]) {
    jsonDict[@"team_shared_dropbox_error"] =
        [[DBTEAMTeamFolderTeamSharedDropboxErrorSerializer serialize:valueObj.teamSharedDropboxError] mutableCopy];
    jsonDict[@".tag"] = @"team_shared_dropbox_error";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMTeamFolderArchiveError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"access_error"]) {
    DBTEAMTeamFolderAccessError *accessError =
        [DBTEAMTeamFolderAccessErrorSerializer deserialize:valueDict[@"access_error"]];
    return [[DBTEAMTeamFolderArchiveError alloc] initWithAccessError:accessError];
  } else if ([tag isEqualToString:@"status_error"]) {
    DBTEAMTeamFolderInvalidStatusError *statusError =
        [DBTEAMTeamFolderInvalidStatusErrorSerializer deserialize:valueDict[@"status_error"]];
    return [[DBTEAMTeamFolderArchiveError alloc] initWithStatusError:statusError];
  } else if ([tag isEqualToString:@"team_shared_dropbox_error"]) {
    DBTEAMTeamFolderTeamSharedDropboxError *teamSharedDropboxError =
        [DBTEAMTeamFolderTeamSharedDropboxErrorSerializer deserialize:valueDict[@"team_shared_dropbox_error"]];
    return [[DBTEAMTeamFolderArchiveError alloc] initWithTeamSharedDropboxError:teamSharedDropboxError];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMTeamFolderArchiveError alloc] initWithOther];
  } else {
    return [[DBTEAMTeamFolderArchiveError alloc] initWithOther];
  }
}

@end

#import "DBASYNCPollResultBase.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMTeamFolderArchiveError.h"
#import "DBTEAMTeamFolderArchiveJobStatus.h"
#import "DBTEAMTeamFolderMetadata.h"

#pragma mark - API Object

@implementation DBTEAMTeamFolderArchiveJobStatus

@synthesize complete = _complete;
@synthesize failed = _failed;

#pragma mark - Constructors

- (instancetype)initWithInProgress {
  self = [super init];
  if (self) {
    _tag = DBTEAMTeamFolderArchiveJobStatusInProgress;
  }
  return self;
}

- (instancetype)initWithComplete:(DBTEAMTeamFolderMetadata *)complete {
  self = [super init];
  if (self) {
    _tag = DBTEAMTeamFolderArchiveJobStatusComplete;
    _complete = complete;
  }
  return self;
}

- (instancetype)initWithFailed:(DBTEAMTeamFolderArchiveError *)failed {
  self = [super init];
  if (self) {
    _tag = DBTEAMTeamFolderArchiveJobStatusFailed;
    _failed = failed;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBTEAMTeamFolderMetadata *)complete {
  if (![self isComplete]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMTeamFolderArchiveJobStatusComplete, but was %@.", [self tagName]];
  }
  return _complete;
}

- (DBTEAMTeamFolderArchiveError *)failed {
  if (![self isFailed]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMTeamFolderArchiveJobStatusFailed, but was %@.", [self tagName]];
  }
  return _failed;
}

#pragma mark - Tag state methods

- (BOOL)isInProgress {
  return _tag == DBTEAMTeamFolderArchiveJobStatusInProgress;
}

- (BOOL)isComplete {
  return _tag == DBTEAMTeamFolderArchiveJobStatusComplete;
}

- (BOOL)isFailed {
  return _tag == DBTEAMTeamFolderArchiveJobStatusFailed;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMTeamFolderArchiveJobStatusInProgress:
    return @"DBTEAMTeamFolderArchiveJobStatusInProgress";
  case DBTEAMTeamFolderArchiveJobStatusComplete:
    return @"DBTEAMTeamFolderArchiveJobStatusComplete";
  case DBTEAMTeamFolderArchiveJobStatusFailed:
    return @"DBTEAMTeamFolderArchiveJobStatusFailed";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMTeamFolderArchiveJobStatusSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMTeamFolderArchiveJobStatusSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMTeamFolderArchiveJobStatusSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMTeamFolderArchiveJobStatusInProgress:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMTeamFolderArchiveJobStatusComplete:
    result = prime * result + [self.complete hash];
    break;
  case DBTEAMTeamFolderArchiveJobStatusFailed:
    result = prime * result + [self.failed hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToTeamFolderArchiveJobStatus:other];
}

- (BOOL)isEqualToTeamFolderArchiveJobStatus:(DBTEAMTeamFolderArchiveJobStatus *)aTeamFolderArchiveJobStatus {
  if (self == aTeamFolderArchiveJobStatus) {
    return YES;
  }
  if (self.tag != aTeamFolderArchiveJobStatus.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMTeamFolderArchiveJobStatusInProgress:
    return [[self tagName] isEqual:[aTeamFolderArchiveJobStatus tagName]];
  case DBTEAMTeamFolderArchiveJobStatusComplete:
    return [self.complete isEqual:aTeamFolderArchiveJobStatus.complete];
  case DBTEAMTeamFolderArchiveJobStatusFailed:
    return [self.failed isEqual:aTeamFolderArchiveJobStatus.failed];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMTeamFolderArchiveJobStatusSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMTeamFolderArchiveJobStatus *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isInProgress]) {
    jsonDict[@".tag"] = @"in_progress";
  } else if ([valueObj isComplete]) {
    jsonDict = [[DBTEAMTeamFolderMetadataSerializer serialize:valueObj.complete] mutableCopy];
    jsonDict[@".tag"] = @"complete";
  } else if ([valueObj isFailed]) {
    jsonDict[@"failed"] = [[DBTEAMTeamFolderArchiveErrorSerializer serialize:valueObj.failed] mutableCopy];
    jsonDict[@".tag"] = @"failed";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMTeamFolderArchiveJobStatus *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"in_progress"]) {
    return [[DBTEAMTeamFolderArchiveJobStatus alloc] initWithInProgress];
  } else if ([tag isEqualToString:@"complete"]) {
    DBTEAMTeamFolderMetadata *complete = [DBTEAMTeamFolderMetadataSerializer deserialize:valueDict];
    return [[DBTEAMTeamFolderArchiveJobStatus alloc] initWithComplete:complete];
  } else if ([tag isEqualToString:@"failed"]) {
    DBTEAMTeamFolderArchiveError *failed = [DBTEAMTeamFolderArchiveErrorSerializer deserialize:valueDict[@"failed"]];
    return [[DBTEAMTeamFolderArchiveJobStatus alloc] initWithFailed:failed];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBASYNCLaunchResultBase.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMTeamFolderArchiveLaunch.h"
#import "DBTEAMTeamFolderMetadata.h"

#pragma mark - API Object

@implementation DBTEAMTeamFolderArchiveLaunch

@synthesize asyncJobId = _asyncJobId;
@synthesize complete = _complete;

#pragma mark - Constructors

- (instancetype)initWithAsyncJobId:(NSString *)asyncJobId {
  self = [super init];
  if (self) {
    _tag = DBTEAMTeamFolderArchiveLaunchAsyncJobId;
    _asyncJobId = asyncJobId;
  }
  return self;
}

- (instancetype)initWithComplete:(DBTEAMTeamFolderMetadata *)complete {
  self = [super init];
  if (self) {
    _tag = DBTEAMTeamFolderArchiveLaunchComplete;
    _complete = complete;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSString *)asyncJobId {
  if (![self isAsyncJobId]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMTeamFolderArchiveLaunchAsyncJobId, but was %@.", [self tagName]];
  }
  return _asyncJobId;
}

- (DBTEAMTeamFolderMetadata *)complete {
  if (![self isComplete]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMTeamFolderArchiveLaunchComplete, but was %@.", [self tagName]];
  }
  return _complete;
}

#pragma mark - Tag state methods

- (BOOL)isAsyncJobId {
  return _tag == DBTEAMTeamFolderArchiveLaunchAsyncJobId;
}

- (BOOL)isComplete {
  return _tag == DBTEAMTeamFolderArchiveLaunchComplete;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMTeamFolderArchiveLaunchAsyncJobId:
    return @"DBTEAMTeamFolderArchiveLaunchAsyncJobId";
  case DBTEAMTeamFolderArchiveLaunchComplete:
    return @"DBTEAMTeamFolderArchiveLaunchComplete";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMTeamFolderArchiveLaunchSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMTeamFolderArchiveLaunchSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMTeamFolderArchiveLaunchSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMTeamFolderArchiveLaunchAsyncJobId:
    result = prime * result + [self.asyncJobId hash];
    break;
  case DBTEAMTeamFolderArchiveLaunchComplete:
    result = prime * result + [self.complete hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToTeamFolderArchiveLaunch:other];
}

- (BOOL)isEqualToTeamFolderArchiveLaunch:(DBTEAMTeamFolderArchiveLaunch *)aTeamFolderArchiveLaunch {
  if (self == aTeamFolderArchiveLaunch) {
    return YES;
  }
  if (self.tag != aTeamFolderArchiveLaunch.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMTeamFolderArchiveLaunchAsyncJobId:
    return [self.asyncJobId isEqual:aTeamFolderArchiveLaunch.asyncJobId];
  case DBTEAMTeamFolderArchiveLaunchComplete:
    return [self.complete isEqual:aTeamFolderArchiveLaunch.complete];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMTeamFolderArchiveLaunchSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMTeamFolderArchiveLaunch *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAsyncJobId]) {
    jsonDict[@"async_job_id"] = valueObj.asyncJobId;
    jsonDict[@".tag"] = @"async_job_id";
  } else if ([valueObj isComplete]) {
    jsonDict = [[DBTEAMTeamFolderMetadataSerializer serialize:valueObj.complete] mutableCopy];
    jsonDict[@".tag"] = @"complete";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMTeamFolderArchiveLaunch *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"async_job_id"]) {
    NSString *asyncJobId = valueDict[@"async_job_id"];
    return [[DBTEAMTeamFolderArchiveLaunch alloc] initWithAsyncJobId:asyncJobId];
  } else if ([tag isEqualToString:@"complete"]) {
    DBTEAMTeamFolderMetadata *complete = [DBTEAMTeamFolderMetadataSerializer deserialize:valueDict];
    return [[DBTEAMTeamFolderArchiveLaunch alloc] initWithComplete:complete];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBFILESSyncSettingArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMTeamFolderCreateArg.h"

#pragma mark - API Object

@implementation DBTEAMTeamFolderCreateArg

#pragma mark - Constructors

- (instancetype)initWithName:(NSString *)name syncSetting:(DBFILESSyncSettingArg *)syncSetting {
  [DBStoneValidators nonnullValidator:nil](name);

  self = [super init];
  if (self) {
    _name = name;
    _syncSetting = syncSetting;
  }
  return self;
}

- (instancetype)initWithName:(NSString *)name {
  return [self initWithName:name syncSetting:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMTeamFolderCreateArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMTeamFolderCreateArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMTeamFolderCreateArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.name hash];
  if (self.syncSetting != nil) {
    result = prime * result + [self.syncSetting hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToTeamFolderCreateArg:other];
}

- (BOOL)isEqualToTeamFolderCreateArg:(DBTEAMTeamFolderCreateArg *)aTeamFolderCreateArg {
  if (self == aTeamFolderCreateArg) {
    return YES;
  }
  if (![self.name isEqual:aTeamFolderCreateArg.name]) {
    return NO;
  }
  if (self.syncSetting) {
    if (![self.syncSetting isEqual:aTeamFolderCreateArg.syncSetting]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMTeamFolderCreateArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMTeamFolderCreateArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"name"] = valueObj.name;
  if (valueObj.syncSetting) {
    jsonDict[@"sync_setting"] = [DBFILESSyncSettingArgSerializer serialize:valueObj.syncSetting];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMTeamFolderCreateArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *name = valueDict[@"name"];
  DBFILESSyncSettingArg *syncSetting =
      valueDict[@"sync_setting"] ? [DBFILESSyncSettingArgSerializer deserialize:valueDict[@"sync_setting"]] : nil;

  return [[DBTEAMTeamFolderCreateArg alloc] initWithName:name syncSetting:syncSetting];
}

@end

#import "DBFILESSyncSettingsError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMTeamFolderCreateError.h"

#pragma mark - API Object

@implementation DBTEAMTeamFolderCreateError

@synthesize syncSettingsError = _syncSettingsError;

#pragma mark - Constructors

- (instancetype)initWithInvalidFolderName {
  self = [super init];
  if (self) {
    _tag = DBTEAMTeamFolderCreateErrorInvalidFolderName;
  }
  return self;
}

- (instancetype)initWithFolderNameAlreadyUsed {
  self = [super init];
  if (self) {
    _tag = DBTEAMTeamFolderCreateErrorFolderNameAlreadyUsed;
  }
  return self;
}

- (instancetype)initWithFolderNameReserved {
  self = [super init];
  if (self) {
    _tag = DBTEAMTeamFolderCreateErrorFolderNameReserved;
  }
  return self;
}

- (instancetype)initWithSyncSettingsError:(DBFILESSyncSettingsError *)syncSettingsError {
  self = [super init];
  if (self) {
    _tag = DBTEAMTeamFolderCreateErrorSyncSettingsError;
    _syncSettingsError = syncSettingsError;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMTeamFolderCreateErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESSyncSettingsError *)syncSettingsError {
  if (![self isSyncSettingsError]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMTeamFolderCreateErrorSyncSettingsError, but was %@.", [self tagName]];
  }
  return _syncSettingsError;
}

#pragma mark - Tag state methods

- (BOOL)isInvalidFolderName {
  return _tag == DBTEAMTeamFolderCreateErrorInvalidFolderName;
}

- (BOOL)isFolderNameAlreadyUsed {
  return _tag == DBTEAMTeamFolderCreateErrorFolderNameAlreadyUsed;
}

- (BOOL)isFolderNameReserved {
  return _tag == DBTEAMTeamFolderCreateErrorFolderNameReserved;
}

- (BOOL)isSyncSettingsError {
  return _tag == DBTEAMTeamFolderCreateErrorSyncSettingsError;
}

- (BOOL)isOther {
  return _tag == DBTEAMTeamFolderCreateErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMTeamFolderCreateErrorInvalidFolderName:
    return @"DBTEAMTeamFolderCreateErrorInvalidFolderName";
  case DBTEAMTeamFolderCreateErrorFolderNameAlreadyUsed:
    return @"DBTEAMTeamFolderCreateErrorFolderNameAlreadyUsed";
  case DBTEAMTeamFolderCreateErrorFolderNameReserved:
    return @"DBTEAMTeamFolderCreateErrorFolderNameReserved";
  case DBTEAMTeamFolderCreateErrorSyncSettingsError:
    return @"DBTEAMTeamFolderCreateErrorSyncSettingsError";
  case DBTEAMTeamFolderCreateErrorOther:
    return @"DBTEAMTeamFolderCreateErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMTeamFolderCreateErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMTeamFolderCreateErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMTeamFolderCreateErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMTeamFolderCreateErrorInvalidFolderName:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMTeamFolderCreateErrorFolderNameAlreadyUsed:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMTeamFolderCreateErrorFolderNameReserved:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMTeamFolderCreateErrorSyncSettingsError:
    result = prime * result + [self.syncSettingsError hash];
    break;
  case DBTEAMTeamFolderCreateErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToTeamFolderCreateError:other];
}

- (BOOL)isEqualToTeamFolderCreateError:(DBTEAMTeamFolderCreateError *)aTeamFolderCreateError {
  if (self == aTeamFolderCreateError) {
    return YES;
  }
  if (self.tag != aTeamFolderCreateError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMTeamFolderCreateErrorInvalidFolderName:
    return [[self tagName] isEqual:[aTeamFolderCreateError tagName]];
  case DBTEAMTeamFolderCreateErrorFolderNameAlreadyUsed:
    return [[self tagName] isEqual:[aTeamFolderCreateError tagName]];
  case DBTEAMTeamFolderCreateErrorFolderNameReserved:
    return [[self tagName] isEqual:[aTeamFolderCreateError tagName]];
  case DBTEAMTeamFolderCreateErrorSyncSettingsError:
    return [self.syncSettingsError isEqual:aTeamFolderCreateError.syncSettingsError];
  case DBTEAMTeamFolderCreateErrorOther:
    return [[self tagName] isEqual:[aTeamFolderCreateError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMTeamFolderCreateErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMTeamFolderCreateError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isInvalidFolderName]) {
    jsonDict[@".tag"] = @"invalid_folder_name";
  } else if ([valueObj isFolderNameAlreadyUsed]) {
    jsonDict[@".tag"] = @"folder_name_already_used";
  } else if ([valueObj isFolderNameReserved]) {
    jsonDict[@".tag"] = @"folder_name_reserved";
  } else if ([valueObj isSyncSettingsError]) {
    jsonDict[@"sync_settings_error"] =
        [[DBFILESSyncSettingsErrorSerializer serialize:valueObj.syncSettingsError] mutableCopy];
    jsonDict[@".tag"] = @"sync_settings_error";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMTeamFolderCreateError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"invalid_folder_name"]) {
    return [[DBTEAMTeamFolderCreateError alloc] initWithInvalidFolderName];
  } else if ([tag isEqualToString:@"folder_name_already_used"]) {
    return [[DBTEAMTeamFolderCreateError alloc] initWithFolderNameAlreadyUsed];
  } else if ([tag isEqualToString:@"folder_name_reserved"]) {
    return [[DBTEAMTeamFolderCreateError alloc] initWithFolderNameReserved];
  } else if ([tag isEqualToString:@"sync_settings_error"]) {
    DBFILESSyncSettingsError *syncSettingsError =
        [DBFILESSyncSettingsErrorSerializer deserialize:valueDict[@"sync_settings_error"]];
    return [[DBTEAMTeamFolderCreateError alloc] initWithSyncSettingsError:syncSettingsError];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMTeamFolderCreateError alloc] initWithOther];
  } else {
    return [[DBTEAMTeamFolderCreateError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMTeamFolderGetInfoItem.h"
#import "DBTEAMTeamFolderMetadata.h"

#pragma mark - API Object

@implementation DBTEAMTeamFolderGetInfoItem

@synthesize idNotFound = _idNotFound;
@synthesize teamFolderMetadata = _teamFolderMetadata;

#pragma mark - Constructors

- (instancetype)initWithIdNotFound:(NSString *)idNotFound {
  self = [super init];
  if (self) {
    _tag = DBTEAMTeamFolderGetInfoItemIdNotFound;
    _idNotFound = idNotFound;
  }
  return self;
}

- (instancetype)initWithTeamFolderMetadata:(DBTEAMTeamFolderMetadata *)teamFolderMetadata {
  self = [super init];
  if (self) {
    _tag = DBTEAMTeamFolderGetInfoItemTeamFolderMetadata;
    _teamFolderMetadata = teamFolderMetadata;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSString *)idNotFound {
  if (![self isIdNotFound]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMTeamFolderGetInfoItemIdNotFound, but was %@.", [self tagName]];
  }
  return _idNotFound;
}

- (DBTEAMTeamFolderMetadata *)teamFolderMetadata {
  if (![self isTeamFolderMetadata]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMTeamFolderGetInfoItemTeamFolderMetadata, but was %@.", [self tagName]];
  }
  return _teamFolderMetadata;
}

#pragma mark - Tag state methods

- (BOOL)isIdNotFound {
  return _tag == DBTEAMTeamFolderGetInfoItemIdNotFound;
}

- (BOOL)isTeamFolderMetadata {
  return _tag == DBTEAMTeamFolderGetInfoItemTeamFolderMetadata;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMTeamFolderGetInfoItemIdNotFound:
    return @"DBTEAMTeamFolderGetInfoItemIdNotFound";
  case DBTEAMTeamFolderGetInfoItemTeamFolderMetadata:
    return @"DBTEAMTeamFolderGetInfoItemTeamFolderMetadata";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMTeamFolderGetInfoItemSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMTeamFolderGetInfoItemSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMTeamFolderGetInfoItemSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMTeamFolderGetInfoItemIdNotFound:
    result = prime * result + [self.idNotFound hash];
    break;
  case DBTEAMTeamFolderGetInfoItemTeamFolderMetadata:
    result = prime * result + [self.teamFolderMetadata hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToTeamFolderGetInfoItem:other];
}

- (BOOL)isEqualToTeamFolderGetInfoItem:(DBTEAMTeamFolderGetInfoItem *)aTeamFolderGetInfoItem {
  if (self == aTeamFolderGetInfoItem) {
    return YES;
  }
  if (self.tag != aTeamFolderGetInfoItem.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMTeamFolderGetInfoItemIdNotFound:
    return [self.idNotFound isEqual:aTeamFolderGetInfoItem.idNotFound];
  case DBTEAMTeamFolderGetInfoItemTeamFolderMetadata:
    return [self.teamFolderMetadata isEqual:aTeamFolderGetInfoItem.teamFolderMetadata];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMTeamFolderGetInfoItemSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMTeamFolderGetInfoItem *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isIdNotFound]) {
    jsonDict[@"id_not_found"] = valueObj.idNotFound;
    jsonDict[@".tag"] = @"id_not_found";
  } else if ([valueObj isTeamFolderMetadata]) {
    jsonDict = [[DBTEAMTeamFolderMetadataSerializer serialize:valueObj.teamFolderMetadata] mutableCopy];
    jsonDict[@".tag"] = @"team_folder_metadata";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMTeamFolderGetInfoItem *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"id_not_found"]) {
    NSString *idNotFound = valueDict[@"id_not_found"];
    return [[DBTEAMTeamFolderGetInfoItem alloc] initWithIdNotFound:idNotFound];
  } else if ([tag isEqualToString:@"team_folder_metadata"]) {
    DBTEAMTeamFolderMetadata *teamFolderMetadata = [DBTEAMTeamFolderMetadataSerializer deserialize:valueDict];
    return [[DBTEAMTeamFolderGetInfoItem alloc] initWithTeamFolderMetadata:teamFolderMetadata];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMTeamFolderIdListArg.h"

#pragma mark - API Object

@implementation DBTEAMTeamFolderIdListArg

#pragma mark - Constructors

- (instancetype)initWithTeamFolderIds:(NSArray<NSString *> *)teamFolderIds {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators
                        arrayValidator:@(1)
                              maxItems:nil
                         itemValidator:[DBStoneValidators
                                           nonnullValidator:[DBStoneValidators stringValidator:nil
                                                                                     maxLength:nil
                                                                                       pattern:@"[-_0-9a-zA-Z:]+"]]]](
      teamFolderIds);

  self = [super init];
  if (self) {
    _teamFolderIds = teamFolderIds;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMTeamFolderIdListArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMTeamFolderIdListArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMTeamFolderIdListArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.teamFolderIds hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToTeamFolderIdListArg:other];
}

- (BOOL)isEqualToTeamFolderIdListArg:(DBTEAMTeamFolderIdListArg *)aTeamFolderIdListArg {
  if (self == aTeamFolderIdListArg) {
    return YES;
  }
  if (![self.teamFolderIds isEqual:aTeamFolderIdListArg.teamFolderIds]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMTeamFolderIdListArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMTeamFolderIdListArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"team_folder_ids"] = [DBArraySerializer serialize:valueObj.teamFolderIds
                                                    withBlock:^id(id elem0) {
                                                      return elem0;
                                                    }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMTeamFolderIdListArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<NSString *> *teamFolderIds = [DBArraySerializer deserialize:valueDict[@"team_folder_ids"]
                                                            withBlock:^id(id elem0) {
                                                              return elem0;
                                                            }];

  return [[DBTEAMTeamFolderIdListArg alloc] initWithTeamFolderIds:teamFolderIds];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMTeamFolderInvalidStatusError.h"

#pragma mark - API Object

@implementation DBTEAMTeamFolderInvalidStatusError

#pragma mark - Constructors

- (instancetype)initWithActive {
  self = [super init];
  if (self) {
    _tag = DBTEAMTeamFolderInvalidStatusErrorActive;
  }
  return self;
}

- (instancetype)initWithArchived {
  self = [super init];
  if (self) {
    _tag = DBTEAMTeamFolderInvalidStatusErrorArchived;
  }
  return self;
}

- (instancetype)initWithArchiveInProgress {
  self = [super init];
  if (self) {
    _tag = DBTEAMTeamFolderInvalidStatusErrorArchiveInProgress;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMTeamFolderInvalidStatusErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isActive {
  return _tag == DBTEAMTeamFolderInvalidStatusErrorActive;
}

- (BOOL)isArchived {
  return _tag == DBTEAMTeamFolderInvalidStatusErrorArchived;
}

- (BOOL)isArchiveInProgress {
  return _tag == DBTEAMTeamFolderInvalidStatusErrorArchiveInProgress;
}

- (BOOL)isOther {
  return _tag == DBTEAMTeamFolderInvalidStatusErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMTeamFolderInvalidStatusErrorActive:
    return @"DBTEAMTeamFolderInvalidStatusErrorActive";
  case DBTEAMTeamFolderInvalidStatusErrorArchived:
    return @"DBTEAMTeamFolderInvalidStatusErrorArchived";
  case DBTEAMTeamFolderInvalidStatusErrorArchiveInProgress:
    return @"DBTEAMTeamFolderInvalidStatusErrorArchiveInProgress";
  case DBTEAMTeamFolderInvalidStatusErrorOther:
    return @"DBTEAMTeamFolderInvalidStatusErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMTeamFolderInvalidStatusErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMTeamFolderInvalidStatusErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMTeamFolderInvalidStatusErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMTeamFolderInvalidStatusErrorActive:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMTeamFolderInvalidStatusErrorArchived:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMTeamFolderInvalidStatusErrorArchiveInProgress:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMTeamFolderInvalidStatusErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToTeamFolderInvalidStatusError:other];
}

- (BOOL)isEqualToTeamFolderInvalidStatusError:(DBTEAMTeamFolderInvalidStatusError *)aTeamFolderInvalidStatusError {
  if (self == aTeamFolderInvalidStatusError) {
    return YES;
  }
  if (self.tag != aTeamFolderInvalidStatusError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMTeamFolderInvalidStatusErrorActive:
    return [[self tagName] isEqual:[aTeamFolderInvalidStatusError tagName]];
  case DBTEAMTeamFolderInvalidStatusErrorArchived:
    return [[self tagName] isEqual:[aTeamFolderInvalidStatusError tagName]];
  case DBTEAMTeamFolderInvalidStatusErrorArchiveInProgress:
    return [[self tagName] isEqual:[aTeamFolderInvalidStatusError tagName]];
  case DBTEAMTeamFolderInvalidStatusErrorOther:
    return [[self tagName] isEqual:[aTeamFolderInvalidStatusError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMTeamFolderInvalidStatusErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMTeamFolderInvalidStatusError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isActive]) {
    jsonDict[@".tag"] = @"active";
  } else if ([valueObj isArchived]) {
    jsonDict[@".tag"] = @"archived";
  } else if ([valueObj isArchiveInProgress]) {
    jsonDict[@".tag"] = @"archive_in_progress";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMTeamFolderInvalidStatusError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"active"]) {
    return [[DBTEAMTeamFolderInvalidStatusError alloc] initWithActive];
  } else if ([tag isEqualToString:@"archived"]) {
    return [[DBTEAMTeamFolderInvalidStatusError alloc] initWithArchived];
  } else if ([tag isEqualToString:@"archive_in_progress"]) {
    return [[DBTEAMTeamFolderInvalidStatusError alloc] initWithArchiveInProgress];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMTeamFolderInvalidStatusError alloc] initWithOther];
  } else {
    return [[DBTEAMTeamFolderInvalidStatusError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMTeamFolderListArg.h"

#pragma mark - API Object

@implementation DBTEAMTeamFolderListArg

#pragma mark - Constructors

- (instancetype)initWithLimit:(NSNumber *)limit {

  self = [super init];
  if (self) {
    _limit = limit ?: @(1000);
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithLimit:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMTeamFolderListArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMTeamFolderListArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMTeamFolderListArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.limit hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToTeamFolderListArg:other];
}

- (BOOL)isEqualToTeamFolderListArg:(DBTEAMTeamFolderListArg *)aTeamFolderListArg {
  if (self == aTeamFolderListArg) {
    return YES;
  }
  if (![self.limit isEqual:aTeamFolderListArg.limit]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMTeamFolderListArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMTeamFolderListArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"limit"] = valueObj.limit;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMTeamFolderListArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSNumber *limit = valueDict[@"limit"] ?: @(1000);

  return [[DBTEAMTeamFolderListArg alloc] initWithLimit:limit];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMTeamFolderListContinueArg.h"

#pragma mark - API Object

@implementation DBTEAMTeamFolderListContinueArg

#pragma mark - Constructors

- (instancetype)initWithCursor:(NSString *)cursor {
  [DBStoneValidators nonnullValidator:nil](cursor);

  self = [super init];
  if (self) {
    _cursor = cursor;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMTeamFolderListContinueArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMTeamFolderListContinueArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMTeamFolderListContinueArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.cursor hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToTeamFolderListContinueArg:other];
}

- (BOOL)isEqualToTeamFolderListContinueArg:(DBTEAMTeamFolderListContinueArg *)aTeamFolderListContinueArg {
  if (self == aTeamFolderListContinueArg) {
    return YES;
  }
  if (![self.cursor isEqual:aTeamFolderListContinueArg.cursor]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMTeamFolderListContinueArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMTeamFolderListContinueArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"cursor"] = valueObj.cursor;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMTeamFolderListContinueArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *cursor = valueDict[@"cursor"];

  return [[DBTEAMTeamFolderListContinueArg alloc] initWithCursor:cursor];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMTeamFolderListContinueError.h"

#pragma mark - API Object

@implementation DBTEAMTeamFolderListContinueError

#pragma mark - Constructors

- (instancetype)initWithInvalidCursor {
  self = [super init];
  if (self) {
    _tag = DBTEAMTeamFolderListContinueErrorInvalidCursor;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMTeamFolderListContinueErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isInvalidCursor {
  return _tag == DBTEAMTeamFolderListContinueErrorInvalidCursor;
}

- (BOOL)isOther {
  return _tag == DBTEAMTeamFolderListContinueErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMTeamFolderListContinueErrorInvalidCursor:
    return @"DBTEAMTeamFolderListContinueErrorInvalidCursor";
  case DBTEAMTeamFolderListContinueErrorOther:
    return @"DBTEAMTeamFolderListContinueErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMTeamFolderListContinueErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMTeamFolderListContinueErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMTeamFolderListContinueErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMTeamFolderListContinueErrorInvalidCursor:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMTeamFolderListContinueErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToTeamFolderListContinueError:other];
}

- (BOOL)isEqualToTeamFolderListContinueError:(DBTEAMTeamFolderListContinueError *)aTeamFolderListContinueError {
  if (self == aTeamFolderListContinueError) {
    return YES;
  }
  if (self.tag != aTeamFolderListContinueError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMTeamFolderListContinueErrorInvalidCursor:
    return [[self tagName] isEqual:[aTeamFolderListContinueError tagName]];
  case DBTEAMTeamFolderListContinueErrorOther:
    return [[self tagName] isEqual:[aTeamFolderListContinueError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMTeamFolderListContinueErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMTeamFolderListContinueError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isInvalidCursor]) {
    jsonDict[@".tag"] = @"invalid_cursor";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMTeamFolderListContinueError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"invalid_cursor"]) {
    return [[DBTEAMTeamFolderListContinueError alloc] initWithInvalidCursor];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMTeamFolderListContinueError alloc] initWithOther];
  } else {
    return [[DBTEAMTeamFolderListContinueError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMTeamFolderAccessError.h"
#import "DBTEAMTeamFolderListError.h"

#pragma mark - API Object

@implementation DBTEAMTeamFolderListError

#pragma mark - Constructors

- (instancetype)initWithAccessError:(DBTEAMTeamFolderAccessError *)accessError {
  [DBStoneValidators nonnullValidator:nil](accessError);

  self = [super init];
  if (self) {
    _accessError = accessError;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMTeamFolderListErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMTeamFolderListErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMTeamFolderListErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.accessError hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToTeamFolderListError:other];
}

- (BOOL)isEqualToTeamFolderListError:(DBTEAMTeamFolderListError *)aTeamFolderListError {
  if (self == aTeamFolderListError) {
    return YES;
  }
  if (![self.accessError isEqual:aTeamFolderListError.accessError]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMTeamFolderListErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMTeamFolderListError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"access_error"] = [DBTEAMTeamFolderAccessErrorSerializer serialize:valueObj.accessError];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMTeamFolderListError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMTeamFolderAccessError *accessError =
      [DBTEAMTeamFolderAccessErrorSerializer deserialize:valueDict[@"access_error"]];

  return [[DBTEAMTeamFolderListError alloc] initWithAccessError:accessError];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMTeamFolderListResult.h"
#import "DBTEAMTeamFolderMetadata.h"

#pragma mark - API Object

@implementation DBTEAMTeamFolderListResult

#pragma mark - Constructors

- (instancetype)initWithTeamFolders:(NSArray<DBTEAMTeamFolderMetadata *> *)teamFolders
                             cursor:(NSString *)cursor
                            hasMore:(NSNumber *)hasMore {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](teamFolders);
  [DBStoneValidators nonnullValidator:nil](cursor);
  [DBStoneValidators nonnullValidator:nil](hasMore);

  self = [super init];
  if (self) {
    _teamFolders = teamFolders;
    _cursor = cursor;
    _hasMore = hasMore;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMTeamFolderListResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMTeamFolderListResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMTeamFolderListResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.teamFolders hash];
  result = prime * result + [self.cursor hash];
  result = prime * result + [self.hasMore hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToTeamFolderListResult:other];
}

- (BOOL)isEqualToTeamFolderListResult:(DBTEAMTeamFolderListResult *)aTeamFolderListResult {
  if (self == aTeamFolderListResult) {
    return YES;
  }
  if (![self.teamFolders isEqual:aTeamFolderListResult.teamFolders]) {
    return NO;
  }
  if (![self.cursor isEqual:aTeamFolderListResult.cursor]) {
    return NO;
  }
  if (![self.hasMore isEqual:aTeamFolderListResult.hasMore]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMTeamFolderListResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMTeamFolderListResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"team_folders"] = [DBArraySerializer serialize:valueObj.teamFolders
                                                 withBlock:^id(id elem0) {
                                                   