///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBSHARINGMemberSelector;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `MemberSelector` union.
///
/// Includes different ways to identify a member of a shared folder.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBSHARINGMemberSelector : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBSHARINGMemberSelectorTag` enum type represents the possible tag
/// states with which the `DBSHARINGMemberSelector` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBSHARINGMemberSelectorTag){
    /// Dropbox account, team member, or group ID of member.
    DBSHARINGMemberSelectorDropboxId,

    /// Email address of member.
    DBSHARINGMemberSelectorEmail,

    /// (no description).
    DBSHARINGMemberSelectorOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBSHARINGMemberSelectorTag tag;

/// Dropbox account, team member, or group ID of member. @note Ensure the
/// `isDropboxId` method returns true before accessing, otherwise a runtime
/// exception will be raised.
@property (nonatomic, readonly, copy) NSString *dropboxId;

/// Email address of member. @note Ensure the `isEmail` method returns true
/// before accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly, copy) NSString *email;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "dropbox_id".
///
/// Description of the "dropbox_id" tag state: Dropbox account, team member, or
/// group ID of member.
///
/// @param dropboxId Dropbox account, team member, or group ID of member.
///
/// @return An initialized instance.
///
- (instancetype)initWithDropboxId:(NSString *)dropboxId;

///
/// Initializes union class with tag state of "email".
///
/// Description of the "email" tag state: Email address of member.
///
/// @param email Email address of member.
///
/// @return An initialized instance.
///
- (instancetype)initWithEmail:(NSString *)email;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "dropbox_id".
///
/// @note Call this method and ensure it returns true before accessing the
/// `dropboxId` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "dropbox_id".
///
- (BOOL)isDropboxId;

///
/// Retrieves whether the union's current tag state has value "email".
///
/// @note Call this method and ensure it returns true before accessing the
/// `email` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "email".
///
- (BOOL)isEmail;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBSHARINGMemberSelector` union.
///
@interface DBSHARINGMemberSelectorSerializer : NSObject

///
/// Serializes `DBSHARINGMemberSelector` instances.
///
/// @param instance An instance of the `DBSHARINGMemberSelector` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBSHARINGMemberSelector` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBSHARINGMemberSelector *)instance;

///
/// Deserializes `DBSHARINGMemberSelector` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBSHARINGMemberSelector` API object.
///
/// @return An instantiation of the `DBSHARINGMemberSelector` object.
///
+ (DBSHARINGMemberSelector *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
