///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESSharedLinkFileInfo;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `SharedLinkFileInfo` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESSharedLinkFileInfo : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The shared link corresponding to either a file or shared link to a folder.
/// If it is for a folder shared link, we use the path param to determine for
/// which file in the folder the view is for.
@property (nonatomic, readonly, copy) NSString *url;

/// The path corresponding to a file in a shared link to a folder. Required for
/// shared links to folders.
@property (nonatomic, readonly, copy, nullable) NSString *path;

/// Password for the shared link. Required for password-protected shared links
/// to files  unless it can be read from a cookie.
@property (nonatomic, readonly, copy, nullable) NSString *password;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param url The shared link corresponding to either a file or shared link to
/// a folder. If it is for a folder shared link, we use the path param to
/// determine for which file in the folder the view is for.
/// @param path The path corresponding to a file in a shared link to a folder.
/// Required for shared links to folders.
/// @param password Password for the shared link. Required for
/// password-protected shared links to files  unless it can be read from a
/// cookie.
///
/// @return An initialized instance.
///
- (instancetype)initWithUrl:(NSString *)url path:(nullable NSString *)path password:(nullable NSString *)password;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param url The shared link corresponding to either a file or shared link to
/// a folder. If it is for a folder shared link, we use the path param to
/// determine for which file in the folder the view is for.
///
/// @return An initialized instance.
///
- (instancetype)initWithUrl:(NSString *)url;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `SharedLinkFileInfo` struct.
///
@interface DBFILESSharedLinkFileInfoSerializer : NSObject

///
/// Serializes `DBFILESSharedLinkFileInfo` instances.
///
/// @param instance An instance of the `DBFILESSharedLinkFileInfo` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESSharedLinkFileInfo` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESSharedLinkFileInfo *)instance;

///
/// Deserializes `DBFILESSharedLinkFileInfo` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESSharedLinkFileInfo` API object.
///
/// @return An instantiation of the `DBFILESSharedLinkFileInfo` object.
///
+ (DBFILESSharedLinkFileInfo *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
