///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESImportFormat;
@class DBFILESPaperDocUpdatePolicy;
@class DBFILESPaperUpdateArg;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `PaperUpdateArg` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESPaperUpdateArg : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Path in the user's Dropbox to update. The path must correspond to a Paper
/// doc or an error will be returned.
@property (nonatomic, readonly, copy) NSString *path;

/// The format of the provided data.
@property (nonatomic, readonly) DBFILESImportFormat *importFormat;

/// How the provided content should be applied to the doc.
@property (nonatomic, readonly) DBFILESPaperDocUpdatePolicy *docUpdatePolicy;

/// The latest doc revision. Required when doc_update_policy is update. This
/// value must match the current revision of the doc or error revision_mismatch
/// will be returned.
@property (nonatomic, readonly, nullable) NSNumber *paperRevision;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param path Path in the user's Dropbox to update. The path must correspond
/// to a Paper doc or an error will be returned.
/// @param importFormat The format of the provided data.
/// @param docUpdatePolicy How the provided content should be applied to the
/// doc.
/// @param paperRevision The latest doc revision. Required when
/// doc_update_policy is update. This value must match the current revision of
/// the doc or error revision_mismatch will be returned.
///
/// @return An initialized instance.
///
- (instancetype)initWithPath:(NSString *)path
                importFormat:(DBFILESImportFormat *)importFormat
             docUpdatePolicy:(DBFILESPaperDocUpdatePolicy *)docUpdatePolicy
               paperRevision:(nullable NSNumber *)paperRevision;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param path Path in the user's Dropbox to update. The path must correspond
/// to a Paper doc or an error will be returned.
/// @param importFormat The format of the provided data.
/// @param docUpdatePolicy How the provided content should be applied to the
/// doc.
///
/// @return An initialized instance.
///
- (instancetype)initWithPath:(NSString *)path
                importFormat:(DBFILESImportFormat *)importFormat
             docUpdatePolicy:(DBFILESPaperDocUpdatePolicy *)docUpdatePolicy;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `PaperUpdateArg` struct.
///
@interface DBFILESPaperUpdateArgSerializer : NSObject

///
/// Serializes `DBFILESPaperUpdateArg` instances.
///
/// @param instance An instance of the `DBFILESPaperUpdateArg` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESPaperUpdateArg` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESPaperUpdateArg *)instance;

///
/// Deserializes `DBFILESPaperUpdateArg` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESPaperUpdateArg` API object.
///
/// @return An instantiation of the `DBFILESPaperUpdateArg` object.
///
+ (DBFILESPaperUpdateArg *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
