///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESMoveIntoVaultError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `MoveIntoVaultError` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESMoveIntoVaultError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBFILESMoveIntoVaultErrorTag` enum type represents the possible tag
/// states with which the `DBFILESMoveIntoVaultError` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBFILESMoveIntoVaultErrorTag){
    /// Moving shared folder into Vault is not allowed.
    DBFILESMoveIntoVaultErrorIsSharedFolder,

    /// (no description).
    DBFILESMoveIntoVaultErrorOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBFILESMoveIntoVaultErrorTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "is_shared_folder".
///
/// Description of the "is_shared_folder" tag state: Moving shared folder into
/// Vault is not allowed.
///
/// @return An initialized instance.
///
- (instancetype)initWithIsSharedFolder;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value
/// "is_shared_folder".
///
/// @return Whether the union's current tag state has value "is_shared_folder".
///
- (BOOL)isIsSharedFolder;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBFILESMoveIntoVaultError` union.
///
@interface DBFILESMoveIntoVaultErrorSerializer : NSObject

///
/// Serializes `DBFILESMoveIntoVaultError` instances.
///
/// @param instance An instance of the `DBFILESMoveIntoVaultError` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESMoveIntoVaultError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESMoveIntoVaultError *)instance;

///
/// Deserializes `DBFILESMoveIntoVaultError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESMoveIntoVaultError` API object.
///
/// @return An instantiation of the `DBFILESMoveIntoVaultError` object.
///
+ (DBFILESMoveIntoVaultError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
