///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESCreateFolderBatchError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `CreateFolderBatchError` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESCreateFolderBatchError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBFILESCreateFolderBatchErrorTag` enum type represents the possible tag
/// states with which the `DBFILESCreateFolderBatchError` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBFILESCreateFolderBatchErrorTag){
    /// The operation would involve too many files or folders.
    DBFILESCreateFolderBatchErrorTooManyFiles,

    /// (no description).
    DBFILESCreateFolderBatchErrorOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBFILESCreateFolderBatchErrorTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "too_many_files".
///
/// Description of the "too_many_files" tag state: The operation would involve
/// too many files or folders.
///
/// @return An initialized instance.
///
- (instancetype)initWithTooManyFiles;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "too_many_files".
///
/// @return Whether the union's current tag state has value "too_many_files".
///
- (BOOL)isTooManyFiles;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBFILESCreateFolderBatchError` union.
///
@interface DBFILESCreateFolderBatchErrorSerializer : NSObject

///
/// Serializes `DBFILESCreateFolderBatchError` instances.
///
/// @param instance An instance of the `DBFILESCreateFolderBatchError` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESCreateFolderBatchError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESCreateFolderBatchError *)instance;

///
/// Deserializes `DBFILESCreateFolderBatchError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESCreateFolderBatchError` API object.
///
/// @return An instantiation of the `DBFILESCreateFolderBatchError` object.
///
+ (DBFILESCreateFolderBatchError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
