///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILEREQUESTSFileRequest;
@class DBFILEREQUESTSFileRequestDeadline;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `FileRequest` struct.
///
/// A file request https://www.dropbox.com/help/9090 for receiving files into
/// the user's Dropbox account.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILEREQUESTSFileRequest : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The ID of the file request.
@property (nonatomic, readonly, copy) NSString *id_;

/// The URL of the file request.
@property (nonatomic, readonly, copy) NSString *url;

/// The title of the file request.
@property (nonatomic, readonly, copy) NSString *title;

/// The path of the folder in the Dropbox where uploaded files will be sent.
/// This can be null if the destination was removed. For apps with the app
/// folder permission, this will be relative to the app folder.
@property (nonatomic, readonly, copy, nullable) NSString *destination;

/// When this file request was created.
@property (nonatomic, readonly) NSDate *created;

/// The deadline for this file request. Only set if the request has a deadline.
@property (nonatomic, readonly, nullable) DBFILEREQUESTSFileRequestDeadline *deadline;

/// Whether or not the file request is open. If the file request is closed, it
/// will not accept any more file submissions.
@property (nonatomic, readonly) NSNumber *isOpen;

/// The number of files this file request has received.
@property (nonatomic, readonly) NSNumber *fileCount;

/// A description of the file request.
@property (nonatomic, readonly, copy, nullable) NSString *description_;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param id_ The ID of the file request.
/// @param url The URL of the file request.
/// @param title The title of the file request.
/// @param created When this file request was created.
/// @param isOpen Whether or not the file request is open. If the file request
/// is closed, it will not accept any more file submissions.
/// @param fileCount The number of files this file request has received.
/// @param destination The path of the folder in the Dropbox where uploaded
/// files will be sent. This can be null if the destination was removed. For
/// apps with the app folder permission, this will be relative to the app
/// folder.
/// @param deadline The deadline for this file request. Only set if the request
/// has a deadline.
/// @param description_ A description of the file request.
///
/// @return An initialized instance.
///
- (instancetype)initWithId_:(NSString *)id_
                        url:(NSString *)url
                      title:(NSString *)title
                    created:(NSDate *)created
                     isOpen:(NSNumber *)isOpen
                  fileCount:(NSNumber *)fileCount
                destination:(nullable NSString *)destination
                   deadline:(nullable DBFILEREQUESTSFileRequestDeadline *)deadline
               description_:(nullable NSString *)description_;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param id_ The ID of the file request.
/// @param url The URL of the file request.
/// @param title The title of the file request.
/// @param created When this file request was created.
/// @param isOpen Whether or not the file request is open. If the file request
/// is closed, it will not accept any more file submissions.
/// @param fileCount The number of files this file request has received.
///
/// @return An initialized instance.
///
- (instancetype)initWithId_:(NSString *)id_
                        url:(NSString *)url
                      title:(NSString *)title
                    created:(NSDate *)created
                     isOpen:(NSNumber *)isOpen
                  fileCount:(NSNumber *)fileCount;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `FileRequest` struct.
///
@interface DBFILEREQUESTSFileRequestSerializer : NSObject

///
/// Serializes `DBFILEREQUESTSFileRequest` instances.
///
/// @param instance An instance of the `DBFILEREQUESTSFileRequest` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILEREQUESTSFileRequest` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILEREQUESTSFileRequest *)instance;

///
/// Deserializes `DBFILEREQUESTSFileRequest` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILEREQUESTSFileRequest` API object.
///
/// @return An instantiation of the `DBFILEREQUESTSFileRequest` object.
///
+ (DBFILEREQUESTSFileRequest *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
