///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILEPROPERTIESTemplateOwnerType;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `TemplateOwnerType` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILEPROPERTIESTemplateOwnerType : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBFILEPROPERTIESTemplateOwnerTypeTag` enum type represents the possible
/// tag states with which the `DBFILEPROPERTIESTemplateOwnerType` union can
/// exist.
typedef NS_CLOSED_ENUM(NSInteger, DBFILEPROPERTIESTemplateOwnerTypeTag){
    /// Template will be associated with a user.
    DBFILEPROPERTIESTemplateOwnerTypeUser,

    /// Template will be associated with a team.
    DBFILEPROPERTIESTemplateOwnerTypeTeam,

    /// (no description).
    DBFILEPROPERTIESTemplateOwnerTypeOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBFILEPROPERTIESTemplateOwnerTypeTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "user".
///
/// Description of the "user" tag state: Template will be associated with a
/// user.
///
/// @return An initialized instance.
///
- (instancetype)initWithUser;

///
/// Initializes union class with tag state of "team".
///
/// Description of the "team" tag state: Template will be associated with a
/// team.
///
/// @return An initialized instance.
///
- (instancetype)initWithTeam;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "user".
///
/// @return Whether the union's current tag state has value "user".
///
- (BOOL)isUser;

///
/// Retrieves whether the union's current tag state has value "team".
///
/// @return Whether the union's current tag state has value "team".
///
- (BOOL)isTeam;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBFILEPROPERTIESTemplateOwnerType` union.
///
@interface DBFILEPROPERTIESTemplateOwnerTypeSerializer : NSObject

///
/// Serializes `DBFILEPROPERTIESTemplateOwnerType` instances.
///
/// @param instance An instance of the `DBFILEPROPERTIESTemplateOwnerType` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILEPROPERTIESTemplateOwnerType` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILEPROPERTIESTemplateOwnerType *)instance;

///
/// Deserializes `DBFILEPROPERTIESTemplateOwnerType` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILEPROPERTIESTemplateOwnerType` API object.
///
/// @return An instantiation of the `DBFILEPROPERTIESTemplateOwnerType` object.
///
+ (DBFILEPROPERTIESTemplateOwnerType *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
