///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

/// Arguments, results, and errors for the `Check` namespace.

#import "DBCHECKEchoArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBCHECKEchoArg

#pragma mark - Constructors

- (instancetype)initWithQuery:(NSString *)query {

  self = [super init];
  if (self) {
    _query = query ?: @"";
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithQuery:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBCHECKEchoArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBCHECKEchoArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBCHECKEchoArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.query hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToEchoArg:other];
}

- (BOOL)isEqualToEchoArg:(DBCHECKEchoArg *)anEchoArg {
  if (self == anEchoArg) {
    return YES;
  }
  if (![self.query isEqual:anEchoArg.query]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBCHECKEchoArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBCHECKEchoArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"query"] = valueObj.query;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBCHECKEchoArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *query = valueDict[@"query"] ?: @"";

  return [[DBCHECKEchoArg alloc] initWithQuery:query];
}

@end

#import "DBCHECKEchoResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBCHECKEchoResult

#pragma mark - Constructors

- (instancetype)initWithResult:(NSString *)result {

  self = [super init];
  if (self) {
    _result = result ?: @"";
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithResult:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBCHECKEchoResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBCHECKEchoResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBCHECKEchoResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.result hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToEchoResult:other];
}

- (BOOL)isEqualToEchoResult:(DBCHECKEchoResult *)anEchoResult {
  if (self == anEchoResult) {
    return YES;
  }
  if (![self.result isEqual:anEchoResult.result]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBCHECKEchoResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBCHECKEchoResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"result"] = valueObj.result;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBCHECKEchoResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *result = valueDict[@"result"] ?: @"";

  return [[DBCHECKEchoResult alloc] initWithResult:result];
}

@end
