//
//  WCTRestObject+ParameterDefine.h
//  
//
//  Created by Howard on 2016/3/16.
//
//

#ifndef WCTRestObject_ParameterDefine_h
#define WCTRestObject_ParameterDefine_h

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 帳號種類定義

static NSString *const WCTRC_AccountType_Local = @"LOCAL";
static NSString *const WCTRC_AccountType_AD = @"AD";


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 帳號類型定義

static NSString *const WCTRC_Role_NormalUser = @"NORMAL_USER";
static NSString *const WCTRC_Role_ReadOnlyUser = @"READ_ONLY_USER";
static NSString *const WCTRC_Role_Admin = @"ADMIN";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 帳號狀態定義

static NSString *const WCTRC_Status_Resigned = @"RESIGNED";
static NSString *const WCTRC_Status_InActive = @"INACTIVE";
static NSString *const WCTRC_Status_Active = @"ACTIVE";
static NSString *const WCTRC_Status_Deleted = @"DELETED";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 帳號訂閱狀態定義

static NSString *const WCTRC_AccountSubscriptionStatus_InSubcription = @"IN_SUBSCRIPTION";
static NSString *const WCTRC_AccountSubscriptionStatus_TemplateInvalidate = @"TEMPLATE_INVALIDATE";


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 帳號繼承狀態

static NSString *const WCTRC_inheritanceStatus_Inherited = @"INHERITED";
static NSString *const WCTRC_inheritanceStatus_Inheriting = @"INHERITING";
static NSString *const WCTRC_inheritanceStatus_Failed = @"FAILED";


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - 帳號鎖定狀態
static NSString *const WCTRC_LockedIssue_None = @"NO_ISSUE";
static NSString *const WCTRC_LockedIssue_LoginFailed = @"LOGIN_FAIL";
static NSString *const WCTRC_LockedIssue_AccountNotActiveExpired= @"ACCOUNT_NOT_ACTIVE_EXPIRED";
static NSString *const WCTRC_LockedIssue_SubscriptionTemplateInvalidate = @"SUBSCRIPTION_TEMPLATE_INVALIDATE";


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 登入平台定義

static NSString *const WCTRC_Platform_Web = @"WEB";
static NSString *const WCTRC_Platform_PC = @"PC";
static NSString *const WCTRC_Platform_Android = @"ANDROID";
static NSString *const WCTRC_Platform_AndroidTablet = @"ANDROID_TABLET";
static NSString *const WCTRC_Platform_IOS = @"IOS";
static NSString *const WCTRC_Platform_IPAD = @"IPAD";
static NSString *const WCTRC_Platform_MACOS = @"MAC";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 登入平台類型定義

static NSString *const WCTRC_PlatformCategory_Web = @"WEB";
static NSString *const WCTRC_PlatformCategory_PC = @"PC";
static NSString *const WCTRC_PlatformCategory_MobilePhones = @"MOBILE_PHONES";
static NSString *const WCTRC_PlatformCategory_MobilePads = @"TABLET_IPADS";


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 登入的授權模式
static NSString *const WCTRC_LicenseMode_None = @"None";
static NSString *const WCTRC_LicenseMode_BuyOut = @"BUYOUT";
static NSString *const WCTRC_LicenseMode_Subscription = @"SUBSCRIPTION";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 伺服器訂閱狀態

static NSString *const WCTRC_SubscriptionState_BuyOut = @"BUYOUT";
static NSString *const WCTRC_SubscriptionState_Trial = @"TRIAL";
static NSString *const WCTRC_SubscriptionState_TrialLeft2Week = @"TRIAL_LEFT_2_WEEK";
static NSString *const WCTRC_SubscriptionState_TrialOutOfDate = @"OUT_OF_TRIAL";
static NSString *const WCTRC_SubscriptionState_Subscription = @"SUBSCRIPTION";
static NSString *const WCTRC_SubscriptionState_SubscriptionLeft2Week = @"SUBSCRIPTION_LEFT_2_WEEK";
static NSString *const WCTRC_SubscriptionState_SubscriptionOutOfDate = @"OUT_OF_SUBSCRIPTION";
static NSString *const WCTRC_SubscriptionState_Lock = @"LOCK";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 伺服器授權檢查狀態
static NSString *const WCTRC_IssueState_Ok = @"OK";
static NSString *const WCTRC_IssueState_PreWarning = @"PRE_WARNING";
static NSString *const WCTRC_IssueState_Warning = @"WARNING";
static NSString *const WCTRC_IssueState_Locked = @"LOCKED";
static NSString *const WCTRC_IssueState_Uncheck = @"UNCHECK";


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 伺服器狀態定義
static NSString *const WCTRC_ServerNotActived  = @"NOT_ACTIVED";
static NSString *const WCTRC_ServerNeedReinstall  = @"NEED_REINITIAL";
static NSString *const WCTRC_ServerTrialExpired  = @"TRIAL_EXPIRED";
static NSString *const WCTRC_ServerTrialUse  = @"TRIAL_USE";
static NSString *const WCTRC_ServerActived  = @"ACTIVED";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 分享型態定義

static NSString *const WCTRC_ShareItem_Contact = @"CONTACT";
static NSString *const WCTRC_ShareItem_Activity = @"ACTIVITY";
static NSString *const WCTRC_ShareItem_Task = @"TASK";


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 姓名順序

static NSString *const WCTRC_NameOrder_FirstNameLastName = @"FIRSTNAME_LASTNAME";
static NSString *const WCTRC_NameOrder_LastNameFirstName = @"LASTNAME_FIRSTNAME";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 中文辨識結果

static NSString *const WCTRC_ChineseRecognizeOutput_ContactContent = @"CONTACT_CONTENT";
static NSString *const WCTRC_ChineseRecognizeOutput_CHT = @"BIG5";
static NSString *const WCTRC_ChineseRecognizeOutput_CHS = @"GB";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 依欄位排序

static NSString *const WCTRC_SortByField_Name = @"NAME";
static NSString *const WCTRC_SortByField_Company = @"COMPANY";
static NSString *const WCTRC_SortByField_CreateTime = @"CREATE_TIME";
static NSString *const WCTRC_SortByField_ModifiedTime = @"MODIFY_TIME";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 全域共享設定

static NSString *const WCTRC_GlobalShareRole_All = @"ALL";
static NSString *const WCTRC_GlobalShareRole_BySetting = @"BY_SETTING";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 地圖預設值

static NSString *const WCTRC_MapEngine_Auto = @"AUTO";
static NSString *const WCTRC_MapEngine_Google = @"GOOGLE";
static NSString *const WCTRC_MapEngine_Baidu = @"BAIDU";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 匯出設定 (公司CRM/公司通訊錄共用)

static NSString *const WCTRC_ExportMode_ContactSyncAuto = @"AUTO_SYNC_CONTACT";
static NSString *const WCTRC_ExportMode_Manual = @"MANUAL_EXPORT";
static NSString *const WCTRC_ExportMode_Auto = @"AUTO_EXPORT";

// 只有台積電版本有
static NSString *const WCTRC_ExportMode_AutoExportToContact = @"AUTO_EXPORT_TO_CONTACT";
static NSString *const WCTRC_ExportMode_AutoExportToLead = @"AUTO_EXPORT_TO_LEAD";

static NSString *const WCTRC_ExportType_Salesforce = @"SALESFORCE";
static NSString *const WCTRC_ExportType_SugarCRM = @"SUGAR_CRM";
static NSString *const WCTRC_ExportType_Exchange = @"EXCHANGE";
static NSString *const WCTRC_ExportType_Office365 = @"OFFICE365";
static NSString *const WCTRC_ExportType_Qcontactz = @"QCONTACTZ";
static NSString *const WCTRC_ExportType_Google = @"GOOGLE";
static NSString *const WCTRC_ExportType_None = @"NONE";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - CRM匯出設定

static NSString *const WCTRC_CRMExportMode_ContactSyncAuto = @"AUTO_SYNC_CONTACT";
static NSString *const WCTRC_CRMExportMode_Manual = @"MANUAL_EXPORT";


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - CRM公司匯出設定

static NSString *const WCTRC_CRMCompanyAssignmentOption_Manual = @"MANUAL";
static NSString *const WCTRC_CRMCompanyAssignmentOption_Auto = @"AUTO";
static NSString *const WCTRC_CRMCompanyAssignmentOption_None = @"NONE";


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - CRM種類設定

static NSString *const WCTRC_CRMType_None = @"No system CRM setting found.";
static NSString *const WCTRC_CRMType_Salesforce = @"SALESFORCE";
static NSString *const WCTRC_CRMType_SugarCRM = @"SUGAR_CRM";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Salesforce匯出標的

static NSString *const WCTRC_SalesforceTarget_Contact = @"SALESFORCE_CONTACT";      // 聯絡人
static NSString *const WCTRC_SalesforceTarget_Lead = @"SALESFORCE_LEAD";         // 商機


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 自訂欄位設定

static NSString *const WCTRC_CustomField_Attributes_Number = @"NUMBER";         // 數字
static NSString *const WCTRC_CustomField_Attributes_Float = @"FLOAT";           // 浮點數
static NSString *const WCTRC_CustomField_Attributes_Text = @"TEXT";             // 文字
static NSString *const WCTRC_CustomField_Attributes_URL = @"URL";             // 網址
static NSString *const WCTRC_CustomField_Attributes_Picklist = @"PICKLIST";     // 選單
static NSString *const WCTRC_CustomField_Attributes_Email = @"EMAIL";           // 電子郵件
static NSString *const WCTRC_CustomField_Attributes_Date = @"DATE";             // 日期
static NSString *const WCTRC_CustomField_Attributes_DateTime = @"DATE_TIME";   // 日期時間

// 自訂欄位類別
static NSString *const WCTRC_CustomField_Category_Contact = @"CONTACT";         // 聯絡人自訂欄位
static NSString *const WCTRC_CustomField_Category_Task = @"TASK";               // 工作自訂欄位
static NSString *const WCTRC_CustomField_Category_Activity = @"ACTIVITY";       // 活動自訂欄位

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Get system property

static NSString *const WCTRC_SystemProperty_MaxPrivateContactsCount = @"MAX_CONTACT_COUNT_IN_PRIVATE";     // 最大可同步聯絡人數量 (私有區)
static NSString *const WCTRC_SystemProperty_MaxPublicContactsCount = @"MAX_CONTACT_COUNT_IN_PUBLIC";       // 最大可同步聯絡人數量 (公有區)
static NSString *const WCTRC_SystemProperty_MaxServerContactsCount = @"MAX_CONTACT_COUNT_IN_SERVER";       // 最大可同步聯絡人數量 (總筆數)


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 類別型態定義

static NSString *const WCTRC_CategoryType_All = @"ALL";
static NSString *const WCTRC_CategoryType_Favorite = @"FAVORITE";
static NSString *const WCTRC_CategoryType_Normal = @"NORMAL";
static NSString *const WCTRC_CategoryType_Other = @"OTHER";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 圖片副檔名定義

static NSString *const WCTRC_MineType_JPG = @"image/jpg";
static NSString *const WCTRC_MineType_PNG = @"image/png";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 圖片類型定義

static NSString *const WCTRC_ImageType_Front = @"FRONT";
static NSString *const WCTRC_ImageType_Rear = @"REAR";
static NSString *const WCTRC_ImageType_Logo = @"LOGO";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 資料操作行為定義

static NSString *const WCTRC_Action_Delete = @"AT_DEL";
static NSString *const WCTRC_Action_Add = @"AT_ADD";
static NSString *const WCTRC_Action_Modify = @"AT_MODIFY";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 同步更新行為定義

static NSString *const WCTRC_UpdateAction_AddServer = @"ADD_SERVER";
static NSString *const WCTRC_UpdateAction_AddOrUpdateClient = @"ADD_OR_UPDATE_CLIENT";
static NSString *const WCTRC_UpdateAction_UpdateServer = @"UPDATE_SERVER";
static NSString *const WCTRC_UpdateAction_UpdateClient = @"UPDATE_CLIENT";
static NSString *const WCTRC_UpdateAction_DeleteServer = @"DEL_SERVER";
static NSString *const WCTRC_UpdateAction_DeleteClient = @"DEL_CLIENT";
static NSString *const WCTRC_UpdateAction_Unckeck = @"UNCHECK";
static NSString *const WCTRC_UpdateAction_DoNothing = @"DO_NOTHING";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 同步更新Component定義

static NSString *const WCTRC_UpdateComponent_Content = @"UC_CONTENT";
static NSString *const WCTRC_UpdateComponent_FrontImage = @"UC_FRONT_IMAGE";
static NSString *const WCTRC_UpdateComponent_BackImage = @"UC_BACK_IMAGE";
static NSString *const WCTRC_UpdateComponent_Logo = @"UC_LOGO";
static NSString *const WCTRC_UpdateComponent_Category = @"UC_CATEGORY";
static NSString *const WCTRC_UpdateComponent_ShareAccount = @"UC_SHARE_ACCOUNT";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 同步contactStatus定義

static NSString *const WCTRC_ContactStatus_SERVER_IS_NEWER = @"SERVER_IS_NEWER";
static NSString *const WCTRC_ContactStatus_CLIENT_IS_NEWER = @"CLIENT_IS_NEWER";
static NSString *const WCTRC_ContactStatus_CONTACT_NO_EXIST = @"CONTACT_NO_EXIST";
static NSString *const WCTRC_ContactStatus_SAME_WITH_SERVER = @"SAME_WITH_SERVER";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - SHA1定義

static NSString *const WCTRC_SHA1_Empty = @"empty";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Contact欄位名稱定義

static NSString *const WCTRC_ContactInfoType_Phone_HomeTel = @"HOME_TEL";
static NSString *const WCTRC_ContactInfoType_Phone_WorkTel = @"BUSINESS_TEL";
static NSString *const WCTRC_ContactInfoType_Phone_OtherTel = @"OTHER_TEL";
static NSString *const WCTRC_ContactInfoType_Phone_HomeFax = @"HOME_FAX";
static NSString *const WCTRC_ContactInfoType_Phone_WorkFax = @"BUSINESS_FAX";
static NSString *const WCTRC_ContactInfoType_Phone_OtherFax = @"OTHER_FAX";
static NSString *const WCTRC_ContactInfoType_Phone_Mobile = @"CELL";
static NSString *const WCTRC_ContactInfoType_Phone_Main = @"MAIN";
static NSString *const WCTRC_ContactInfoType_Phone_Pager = @"BBCALL";
static NSString *const WCTRC_ContactInfoType_Phone_GoogleVoice = @"GOOGLE_VOICE";
static NSString *const WCTRC_ContactInfoType_Phone_iPhone = @"IPHONE";

static NSString *const WCTRC_ContactInfoType_Address_Home = @"HOME";
static NSString *const WCTRC_ContactInfoType_Address_Work = @"BUSINESS";
static NSString *const WCTRC_ContactInfoType_Address_Other = @"OTHER";

static NSString *const WCTRC_ContactInfoType_Date_Celebration = @"CELEBRATION";
static NSString *const WCTRC_ContactInfoType_Date_Other = @"OTHER";

static NSString *const WCTRC_ContactInfoType_Mail_Home = @"HOME";
static NSString *const WCTRC_ContactInfoType_Mail_Work = @"BUSINESS";
static NSString *const WCTRC_ContactInfoType_Mail_Other = @"OTHER";

static NSString *const WCTRC_ContactInfoType_IM_Msn = @"MSN";
static NSString *const WCTRC_ContactInfoType_IM_Skype = @"SKYPE";
static NSString *const WCTRC_ContactInfoType_IM_QQ = @"QQ";
static NSString *const WCTRC_ContactInfoType_IM_Yahoo = @"YAHOO";
static NSString *const WCTRC_ContactInfoType_IM_Icq = @"ICQ";
static NSString *const WCTRC_ContactInfoType_IM_GoogleTalk = @"GOOGLE_TALK";
static NSString *const WCTRC_ContactInfoType_IM_Jabber = @"JABBER";
static NSString *const WCTRC_ContactInfoType_IM_Aim = @"AIM";
static NSString *const WCTRC_ContactInfoType_IM_Gadu = @"GADU_GADU";
static NSString *const WCTRC_ContactInfoType_IM_Other = @"OTHER";

static NSString *const WCTRC_ContactInfoType_Social_Twitter = @"TWITTER";
static NSString *const WCTRC_ContactInfoType_Social_Facebook = @"FACEBOOK";
static NSString *const WCTRC_ContactInfoType_Social_Flicker = @"FLICKER";
static NSString *const WCTRC_ContactInfoType_Social_Linkedin = @"LINKEDIN";
static NSString *const WCTRC_ContactInfoType_Social_MySpace = @"MYSPACE";
static NSString *const WCTRC_ContactInfoType_Social_Weibo = @"WEIBO";
static NSString *const WCTRC_ContactInfoType_Social_Other = @"OTHER";

static NSString *const WCTRC_ContactInfoType_Url_Main = @"MAIN";
static NSString *const WCTRC_ContactInfoType_Url_Home = @"HOME";
static NSString *const WCTRC_ContactInfoType_Url_Business = @"BUSINESS";
static NSString *const WCTRC_ContactInfoType_Url_Personal = @"PERSONAL";
static NSString *const WCTRC_ContactInfoType_Url_Blog = @"BLOG";
static NSString *const WCTRC_ContactInfoType_Url_Other = @"OTHER";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 操作定義

static NSString *const WCTRC_Behavior_Add = @"ADD";
static NSString *const WCTRC_Behavior_Overwrite = @"OVERWRITE";
static NSString *const WCTRC_Behavior_Remove = @"REMOVE";
static NSString *const WCTRC_Behavior_RemoveAll = @"REMOVE_ALL";


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 名片排序欄位定義

static NSString *const WCTRC_ContactSortField_Name = @"NAME";
static NSString *const WCTRC_ContactSortField_Company = @"COMPANY";
static NSString *const WCTRC_ContactSortField_Department = @"DEPARTMENT";
static NSString *const WCTRC_ContactSortField_Jobtitle = @"JOBTITLE";
static NSString *const WCTRC_ContactSortField_CreatedTime = @"CREATED_TIME";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Contact欄位來源定義

static NSString *const WCTRC_ContactRecogSourceField_FrontCard = @"FRONT_CARD";
static NSString *const WCTRC_ContactRecogSourceField_BackCard = @"BACK_CARD";
static NSString *const WCTRC_ContactRecogSourceField_Manual = @"MANUAL";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Contact清單順序

static NSString *const WCTRC_ContactSortDirection_Ascending = @"ASC";
static NSString *const WCTRC_ContactSortDirection_Descending = @"DESC";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 通知的分類

static NSString *const WCTRC_NoticeCategory_All = @"ALL";
static NSString *const WCTRC_NoticeCategory_Contact = @"CONTACT";
static NSString *const WCTRC_NoticeCategory_Activity = @"ACTIVITY";
static NSString *const WCTRC_NoticeCategory_Task = @"TASK";
static NSString *const WCTRC_NoticeCategory_System = @"SYSTEM";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 通知的類型

static NSString *const WCTRC_NoticeType_AccountBossChanged = @"ACCOUNT_BOSS_CHANGED";
static NSString *const WCTRC_NoticeType_AccountExportAbilityChanged = @"ACCOUNT_EXPORT_ABILITY_CHANGED";
static NSString *const WCTRC_NoticeType_AccountPrintAbilityChanged = @"ACCOUNT_PRINT_ABILITY_CHANGED";
static NSString *const WCTRC_NoticeType_AccountSecretaryAbilityChanged = @"ACCOUNT_SECRETARY_ABILITY_CHANGED";
static NSString *const WCTRC_NoticeType_AccountSetInheritor = @"ACCOUNT_SET_INHERITOR";
static NSString *const WCTRC_NoticeType_AccountSetToResigned = @"ACCOUNT_SET_TO_RESIGNED";
static NSString *const WCTRC_NoticeType_AccountSubordinateChanged = @"ACCOUNT_SUBORDINATE_CHANGED";
static NSString *const WCTRC_NoticeType_AccountUserRoleChange = @"ACCOUNT_USER_ROLE_CHANGE";
static NSString *const WCTRC_NoticeType_ContactCreateFromSomeone = @"CONTACT_CREATED_FROM_SOMEONE";              // 其他人幫忙掃描的通知
static NSString *const WCTRC_NoticeType_ContactBeShared = @"CONTACT_BESHARED";              // 手動分享
static NSString *const WCTRC_NoticeType_ContactExported = @"CONTACT_EXPORTED";              // 匯出CRM的結果通知
static NSString *const WCTRC_NoticeType_ContactSyncWithCRM = @"CONTACT_SYNC_WITH_CRM";      // 連絡人同步CRM結果
static NSString *const WCTRC_NoticeType_GetCRMTokenFailed = @"GET_CRM_TOKEN_FAILED";        // 取得CRM憑證失敗
static NSString *const WCTRC_NoticeType_ContactExportCanceled = @"CONTACT_EXPORTED_CANCELED";
static NSString *const WCTRC_NoticeType_ContactSyncDone = @"CONTACT_SYNC_DONE";
static NSString *const WCTRC_NoticeType_FileSystemReadOnly = @"FILESYSTEM_READ_ONLY";
static NSString *const WCTRC_NoticeType_GlobalShareRuleChange = @"GLOBAL_SHARE_RULE_CHANGE";
static NSString *const WCTRC_NoticeType_NewAccountCreated = @"NEW_ACCOUNT_CREATED";
static NSString *const WCTRC_NoticeType_LowStorageSpace = @"LOW_STORAGE_SPACE";
static NSString *const WCTRC_NoticeType_AccountAbilityChanged = @"ACCOUNT_MULTIPLE_ABILITIES_CHANGED";
static NSString *const WCTRC_NoticeType_CRMSettingsChanged = @"SYSTEM_CRM_SETTINGS_CHANGED";
static NSString *const WCTRC_NoticeType_CRMSettingsRemoved = @"SYSTEM_CRM_SETTINGS_REMOVED";

// 1.3 added
static NSString *const WCTRC_NoticeType_SystemMaintenance = @"SYSTEM_MAINTENANCE";
static NSString *const WCTRC_NoticeType_LoginWithUnbindingDevice = @"LOGIN_WITH_UNBINDING_DEVICE";
static NSString *const WCTRC_NoticeType_BackupFinished = @"BACKUP_FINISHED";
static NSString *const WCTRC_NoticeType_BackupFailed = @"BACKUP_FAILED";
static NSString *const WCTRC_NoticeType_SearchEngineDiskInfo = @"SEARCH_ENGINE_DISK_SPACE_INFO_CHANGED";

// 1.4 added
static NSString *const WCTRC_NoticeType_SubscriptionDuplicateService = @"SUBSCRIPTION_DUPLICATE_SERVICE";
static NSString *const WCTRC_NoticeType_SubscriptionLostCheck = @"SUBSCRIPTION_LOST_CHECK";

static NSString *const WCTRC_NoticeType_AccountTemplateInvalidate = @"ACCOUNT_TEMPLATE_INVALIDATE";

// 1.6 added
static NSString *const WCTRC_NoticeType_AccountLockedByUnactive = @"ACCOUNT_LOCKBY_UNACTIVE";
static NSString *const WCTRC_NoticeType_AccountLockedByLoginFailed = @"ACCOUNT_LOCKBY_LOGIN_FAILURE";

// 1.7 added exchange server
static NSString *const WCTRC_NoticeType_ExchangeServerSettingsChanged = @"SYSTEM_CONTACT_SERVER_SETTINGS_CHANGED";
static NSString *const WCTRC_NoticeType_ExchangeServerSettingsRemoved = @"SYSTEM_CONTACT_SERVER_SETTINGS_REMOVED";
static NSString *const WCTRC_NoticeType_GoogleTokenFailed = @"GET_GOOGLE_TOKEN_FAILED";
static NSString *const WCTRC_NoticeType_ContactSyncWithExchangeServer = @"CONTACT_SYNC_WITH_CONTACT_SERVER";

static NSString *const WCTRC_NoticeType_LDAPSyncFailed = @"LDAP_SYNC_FAIL";
static NSString *const WCTRC_NoticeType_LDAPSyncAuthFailed = @"LDAP_SYNC_AUTH_FAIL";

// MyCard
static NSString *const WCTRC_NoticeType_SystemDomainChanged = @"SYSTEM_DOMAIN_CHANGED";
static NSString *const WCTRC_NoticeType_SystemDomainRemoved = @"SYSTEM_DOMAIN_REMOVED";

// 2.1.0 新增
static NSString *const WCTRC_NoticeType_ExportedToExchangeServer = @"CONTACT_EXPORTED_TO_CONTACT_SERVER";
static NSString *const WCTRC_NoticeType_GoogleContactOverflow = @"GOOGLE_CONTACT_OVERFLOW";




// 活動與工作還沒實作
static NSString *const WCTRC_NoticeType_SharedAcitvityInfo = @"SHARED_ACTIVITY_INFO";
static NSString *const WCTRC_NoticeType_SharedTaskInfo = @"SHARED_TASK_INFO";
static NSString *const WCTRC_NoticeType_TaskAssigned = @"TASK_ASSIGNED";
static NSString *const WCTRC_NoticeType_TaskFinished = @"TASK_FINISHED";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 通知的閱讀狀態

static NSString *const WCTRC_NoticeReadStatus_All = @"ALL";
static NSString *const WCTRC_NoticeReadStatus_Viewed = @"VIEWED";
static NSString *const WCTRC_NoticeReadStatus_Unviewed = @"UNVIEWED";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 通知的排序

static NSString *const WCTRC_NoticeSortField_Type = @"notifytype";
static NSString *const WCTRC_NoticeSortField_Category = @"notifycategory";
static NSString *const WCTRC_NoticeSortField_Time = @"notifytime";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 通知的排序方向
static NSString *const WCTRC_NoticeSortDirection_ASC = @"ASC";
static NSString *const WCTRC_NoticeSortDirection_DESC = @"DESC";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 時間格式定義
static NSString *const WCTRC_IntervalFilterDataFormat = @"yyyy-MM-dd HH:mm:ss.sss";


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 進階搜尋範圍定義

static NSString *const WCTRC_AdvancedSearchRange_Public  = @"PUBLIC";
static NSString *const WCTRC_AdvancedSearchRange_Private  = @"PRIVATE";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 進階搜尋運算子

static NSString *const WCTRC_AdvancedSearchOperator_And  = @"AND";
static NSString *const WCTRC_AdvancedSearchOperator_Or  = @"OR";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 進階搜尋聯絡人欄位
static NSString * const WCTRC_ContactSearchField_Fullname = @"FULLNAME";
static NSString * const WCTRC_ContactSearchField_Company = @"COMPANY";
static NSString * const WCTRC_ContactSearchField_Department = @"DEPARTMENT";
static NSString * const WCTRC_ContactSearchField_Jobtitle = @"JOBTITLE";
static NSString * const WCTRC_ContactSearchField_PhoneNumber = @"PHONE_NUMBER";
static NSString * const WCTRC_ContactSearchField_Address = @"FULL_ADDRESS";
static NSString * const WCTRC_ContactSearchField_Email = @"EMAIL";
static NSString * const WCTRC_ContactSearchField_URL = @"URL";
static NSString * const WCTRC_ContactSearchField_InstantMessage = @"INSTANT_MESSAGE";
static NSString * const WCTRC_ContactSearchField_SocialNetwork = @"SOCIAL_NETWORK";
static NSString * const WCTRC_ContactSearchField_Note = @"NOTE";
static NSString * const WCTRC_ContactSearchField_UniformNumber = @"UNIFORM_NUMBER";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 進階搜尋時間欄位
static NSString * const WCTRC_TimeSearchField_CreateTime = @"CREATE_TIME";
static NSString * const WCTRC_TimeSearchField_ModifyTime = @"MODIFY_TIME";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 進階搜尋時間欄位
static NSString * const WCTRC_AccountSearchField_Creator = @"CREATOR";
static NSString * const WCTRC_AccountSearchField_Editor = @"EDITOR";
static NSString * const WCTRC_AccountSearchField_Owner = @"OWNER";





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - 訂閱類型

static NSString *  const WCTRC_Subscription_Trial  = @"TRIAL";
static NSString *  const WCTRC_Subscription_Subscription  = @"SUBSCRIPTION";





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - QContact 相關設定

static NSString *  const WCTRCQContactzAuthTokenVo_SecurityType_User  = @"USER";
static NSString *  const WCTRCQContactzAuthTokenVo_SecurityType_Phone  = @"PHONE";
static NSString *  const WCTRCQContactzAuthTokenVo_SecurityType_Email  = @"EMAIL";
static NSString *  const WCTRCQContactzAuthTokenVo_SecurityType_Question  = @"QUESTION";


static NSString *  const WCTRCQContactzSecurityInfo_AnotherVerifiCation_Question  = @"QUESTION";

static NSString *  const WCTRCQContactzSecurityInfo_AnotherVerifiCation_Email  = @"EMAIL";


#endif /* WCTRestObject_ParameterDefine_h */
