//
//  WCTRestClient+System.h
//
//
//  Created by Howard on 2016/9/5.
//
//

#import "WCTRestClient.h"

// Model
#import "WCTRCServerIsAliveResponseResult.h"
#import "WCTRCVersionInfoResponseResult.h"
#import "WCTRCServiceStatusResponseResult.h"
#import "WCTRCServerIsActivedResult.h"
#import "WCTRCServerNeedBeActivedResult.h"
#import "WCTRCDNSNameResponseResult.h"
#import "WCTRCServerRegisterStatusResponseResult.h"
#import "WCTRCDateTimeResponseResult.h"
#import "WCTRCServerLicenseResponseResult.h"
#import "WCTRCApplyAccountInfo.h"
#import "WCTRCUIDisplayOptionResponseResult.h"

@interface WCTRestClient (System)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance System Method

- (RKObjectRequestOperation *)serverIsAliveWithSuccess:(void (^)(WCTRCServerIsAliveResponseResult *serverIsAliveResponseResult))success
                                               failure:(void (^)(NSError *error))failure;

- (RKObjectRequestOperation *)serverVersionWithSuccess:(void (^)(WCTRCVersionInfoResponseResult *versionInfoResponseResult))success
                                               failure:(void (^)(NSError *error))failure;

- (RKObjectRequestOperation *)serviceStatusWithSuccess:(void (^)(WCTRCServiceStatusResponseResult *serviceStatusResponseResult))success
                                               failure:(void (^)(NSError *error))failure;

- (RKObjectRequestOperation *)serviceIsActivedWithSuccess:(void (^)(WCTRCServerIsActivedResult *serverIsActivedResult))success
                                                  failure:(void (^)(NSError *error))failure;

- (RKObjectRequestOperation *)serviceNeedBeActivedWithSuccess:(void (^)(WCTRCServerNeedBeActivedResult *serverNeedBeActivedResult))success
                                                      failure:(void (^)(NSError *error))failure;

- (RKObjectRequestOperation *)serverDnsNameWithSuccess:(void (^)(WCTRCDNSNameResponseResult *serverDnsNameResponseResult))success
                                               failure:(void (^)(NSError *error))failure;

- (RKObjectRequestOperation *)serverRegisterStatusWithSuccess:(void (^)(WCTRCServerRegisterStatusResponseResult *serverRegisterStatusResponseResult))success
                                                      failure:(void (^)(NSError *error))failure;

- (RKObjectRequestOperation *)serverDBBuildTimeWithSuccess:(void (^)(WCTRCDateTimeResponseResult *serverDBBuildTimeResponseResult))success
                                                   failure:(void (^)(NSError *error))failure;

- (RKObjectRequestOperation *)serverLicenseWithSuccess:(void (^)(WCTRCServerLicenseResponseResult *serverLicenseResponseResult))success
                                                   failure:(void (^)(NSError *error))failure;

- (RKObjectRequestOperation *)getIsMultiCompanyWithSuccess:(void (^)(WCTRCBooleanResponseResult *isMultiCompanyResponseResult))success
                                               failure:(void (^)(NSError *error))failure;

- (RKObjectRequestOperation *)getIsSimplifyUIWithSuccess:(void (^)(WCTRCBooleanResponseResult *isSimplifyUIResponseResult))success
                                               failure:(void (^)(NSError *error))failure;

- (RKObjectRequestOperation *)applyAccountWithAccountInfo:(WCTRCApplyAccountInfo *)accountInfo
                                                   success:(void (^)(WCTRCMessageResponseResult *responseResult))success
                                                   failure:(void (^)(NSError *error))failure;

- (RKObjectRequestOperation *)displayOptionWithSuccess:(void (^)(WCTRCUIDisplayOptionResponseResult *responseResult))success
                                                  failure:(void (^)(NSError *error))failure;
@end
