//
//  WCTRestClient+Contact.h
//  
//
//  Created by Howard on 2017/2/3.
//
//

#import "WCTRestClient.h"

// Model
#import "WCTRCListRequest.h"
#import "WCTRCMessageResponseResult.h"

@interface WCTRestClient (Contact)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method


/**
 匯出指定的Contact至Salesforce
 
 *  @param loginToken          登入token
 *  @param contactList        名片guids
 *  @param target        contact or lead
 *  @param salesforceAccountId guid
 *  @param success      成功 回傳
 *  @param failure      失敗 回傳
 *
 *  @return nil, 代表需求沒透過網路傳送出
 */
- (RKObjectRequestOperation *)exportToSalesforceWithLoginToken:(NSString *)loginToken
                                                   contactList:(WCTRCListRequest *)contactList
                                                        target:(NSString*)target
salesforceAccountId:(NSString *)salesforceAccountId
                                                       success:(void (^)(WCTRCMessageResponseResult *exportToSalesforceResponseResult))success
                                                       failure:(void (^)(NSError *error))failure;

/**
匯出指定的Contact至MS Exchange contacts

*  @param loginToken          登入token
*  @param contactList        名片guids
*  @param success      成功 回傳
*  @param failure      失敗 回傳
*
*  @return nil, 代表需求沒透過網路傳送出
*/
- (RKObjectRequestOperation *)exportToExchangeServerWithLoginToken:(NSString *)loginToken
                                                      contactList:(WCTRCListRequest *)contactList
                                                          success:(void (^)(WCTRCMessageResponseResult *exportToContactServerResponseResult))success
                                                          failure:(void (^)(NSError *error))failure;

@end
