//
//  WCTLoginViewController.h
//  
//
//  Created by Howard on 16/3/28.
//  Copyright (c) 2016年 penpower. All rights reserved.
//

// Define
#import "WCTLoginViewController+ParameterDefine.h"
#import "WCTLoginViewController+ResourceDefine.h"
#import "WCTLoginViewController+SettingsKey.h"
#import "WCTLoginViewControllerDelegate.h"

// Controller
#import "PPEditableTableViewController.h"
#import "PPSectionController.h"

// View
#import "PPButton.h"
#import "PPTextFieldTableViewCell.h"

// Cateogry
#import "UIViewController+ShareApplication.h"
#import "NSError+Custom.h"
#import "UIView+Appearance.h"

typedef void(^TripleClickBlock)(UIView *view);
////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCTLoginViewController : PPEditableTableViewController
<
PPButtonDelegate,
PPTextFieldTableViewCellDelegate,
UIAlertViewDelegate,
UIActionSheetDelegate,
UITableViewDataSource,
UITableViewDelegate
>

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property(nonatomic,assign)          id<WCTLoginViewControllerDelegate>  delegate;
@property(nonatomic,assign)          BOOL                             autoLoginAccount;
@property(nonatomic,readonly)        UIImageView                      *logoImageView;
@property(nonatomic,retain)          NSString                      *versionString;

@property(nonatomic,retain,readonly)           UIView                  *tableFooterView;
@property(nonatomic,retain,readonly)           PPButton                *ppButtonLogin;
@property(nonatomic,retain,readonly)           PPButton                *ppButtonHelp;
@property(nonatomic,retain,readonly)           PPButton                *ppButtonForgetPassword;
@property(nonatomic,retain,readonly)           PPButton                *ppButtonDeviceID;


@property(nonatomic,retain,readonly)         PPSectionController     *ppSectionController;
@property(nonatomic,retain)           NSString                *displayServerURLAddress;
@property(nonatomic,retain, readonly)           NSString                *accountUser;


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

+ (BOOL)loginViewControllerIsVisible;

// 外部可驅動自動登入
- (void)autologin;


//  回傳登入URL，不包含@"/WorldCardTeam"
- (NSString *)loginURLString;

// row model access
- (NSIndexPath *)indexPathWithRow:(NSInteger)row;
- (PPRowModel *)serverRowModel;
- (PPRowModel *)protocolAndPortRowModel;

#pragma mark - Gesture Method
- (void)enableTripleTapToView:(UIView*)view blockHandler:(TripleClickBlock)blockHandler;
- (void)disableTripleTapToView:(UIView*)view;
@end
