//
//  WCTAccountRelationModel.h
//  Pods
//
//  Created by AndrewLai on 2016/4/26.
//
//

#import <Foundation/Foundation.h>

////////////////////////////////////////////////////////////////////////////////////////////////////
typedef NS_ENUM(NSUInteger, WCTAccountRelationModel_Relation)
{
    WCTAccountRelationModel_Relation_None = 0,
    WCTAccountRelationModel_Relation_Account,
    WCTAccountRelationModel_Relation_Boss,
    WCTAccountRelationModel_Relation_Subordinate
};

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - WCTAccountRelationModel Interface

@interface WCTAccountRelationModel : NSObject

@property (nonatomic, retain) NSString *guid;
@property (nonatomic, retain) NSString *name;
@property (nonatomic, retain) NSString *email;
@property (nonatomic, assign) NSUInteger shareContactCount;
@property (nonatomic, assign) WCTAccountRelationModel_Relation relation;
@property (nonatomic, assign) BOOL isOutgoingEmployee;      //是否為離職員工
@property (nonatomic, assign) BOOL isLimitedAccount;      //是否為暫停使用用戶

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - Class Method

+ (WCTAccountRelationModel *)accountRelationModelWithGuid:(NSString *)guid
                                                     name:(NSString *)name
                                                    email:(NSString *)email
                                        shareContactCount:(NSUInteger)shareContactCount
                                                 relation:(WCTAccountRelationModel_Relation)relation;


+ (WCTAccountRelationModel *)accountRelationModelWithGuid:(NSString *)guid
                                                     name:(NSString *)name
                                                    email:(NSString *)email
                                        shareContactCount:(NSUInteger)shareContactCount
                                                 relation:(WCTAccountRelationModel_Relation)relation
                                       isOutgoingEmployee:(BOOL)isOutgoingEmployee;

+ (WCTAccountRelationModel *)accountRelationModelWithGuid:(NSString *)guid
                                                     name:(NSString *)name
                                                    email:(NSString *)email
                                        shareContactCount:(NSUInteger)shareContactCount
                                                 relation:(WCTAccountRelationModel_Relation)relation
                                       isOutgoingEmployee:(BOOL)isOutgoingEmployee
                                         isLimitedAccount:(BOOL)isLimitedAccount;

@end
