//
//  WCShareFlowController.h
//  Example
//
//  Created by Andrew on 2015/8/3.
//  Copyright (c) 2015年 Eddie. All rights reserved.
//

#import "PPViewController.h"

// Model
#import "WCCardModel.h"
#import "WCImageDefine.h"
#import "WCDisplayNameDefine.h"

// View
#import "WCFileTypeSelectView.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, WCShareFlow_Error)
{
    WCShareFlow_Error_Unknown = 0,
    WCShareFlow_Error_CancelActivityAction,   // 取消系統的ActivityViewController(無完成分享動作)
    WCShareFlow_Error_NoSettingEMail,         // 沒有設定email, 卻選擇使用email分享
};

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCShareFlowController Protocol

@class WCShareFlowController;
@protocol WCShareFlowControllerDelegate <NSObject>

- (WCDisplayNameOrder)contactNameEastOrderInShareFlowController:(WCShareFlowController *)shareFlowController;
- (WCDisplayNameOrder)contactNameWestOrderInShareFlowController:(WCShareFlowController *)shareFlowController;

/**
 * Request field data to write
 *
 * @param shareFlowController - Data Share controller instance
 * @param cardID - Card that need get field data
 * @return WCCardModel with field data of card
 */
- (WCCardModel *)shareFlowController:(WCShareFlowController *)shareFlowController cardModelToWriteWithCardID:(NSString *)cardID;


/**
 * Request group name to write
 *
 * @param shareFlowController - Data Share controller instance
 * @param groupID - Group ID that need get name
 * @return Group name
 */
- (NSString *)shareFlowController:(WCShareFlowController *)shareFlowController groupNameToWriteWithGroupID:(WC_GroupID)groupID;


/**
 * Request image data to write
 *
 * @param shareFlowController - Data Share controller instance
 * @param cardID - Card that need get image data
 * @param imageType - Needed image type
 * @return Image data of card
 */
- (NSData *)shareFlowController:(WCShareFlowController *)shareFlowController imageDataToWriteWithCardID:(NSString *)cardID imageType:(WC_ImageType)imageType;


/**
 * Notify one card is write finish
 *
 * @param shareFlowController - Data Share controller instance
 * @param index - Write card index
 * @param totalCount - Total count
 */
- (void)shareFlowController:(WCShareFlowController *)shareFlowController didWriteCardWithIndex:(NSInteger)index totalCount:(NSInteger)totalCount;

@optional

/**
 *  分享流程結束，發布通知
 *
 *  @param shareFlowController - Data Share controller instance
 *  @param error - NSError
 */
- (void)shareFlowController:(WCShareFlowController *)shareFlowController didFinishWithError:(NSError *)error;

@end





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCShareFlowController Interface

@interface WCShareFlowController : PPViewController

@property (nonatomic, assign) id<WCShareFlowControllerDelegate> delegate;
@property (nonatomic, retain) NSArray *contactIdentifierArray; //已勾選的聯絡人Identifier字串陣列





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

- (void)showFromSuperViewController:(UIViewController *)superViewController fileTypeOrderSource:(NSArray *)fileTypeOrderSource;

- (void)dismissShareViewControllerWithCompletion:(void(^)(void))completion;

@end
