//
//  WCRecognitionFieldDefine.h
//
//
//  Created by Howard.Lin on 13/12/10.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#ifndef CloudEditViewControllerDemo_WCRecognitionFieldDefine_h
#define CloudEditViewControllerDemo_WCRecognitionFieldDefine_h

////////////////////////////////////////////////////////////////////////////////////////////////////

static NSUInteger const WCRecognitionFieldDistance = 1000;

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger,WCRecognitionFieldMainTypeMaxCount)
{
    WCRecognitionFieldMainTypeMaxCount_Address               = 6,
    WCRecognitionFieldMainTypeMaxCount_BirthDay              = 1,
    WCRecognitionFieldMainTypeMaxCount_Company               = 6,
    WCRecognitionFieldMainTypeMaxCount_Date                  = 4,
    WCRecognitionFieldMainTypeMaxCount_Email                 = 6,
    WCRecognitionFieldMainTypeMaxCount_InstantMessage        = 10,
    WCRecognitionFieldMainTypeMaxCount_Name                  = 4,
    WCRecognitionFieldMainTypeMaxCount_NickName              = 4,
    WCRecognitionFieldMainTypeMaxCount_Note                  = 1,
    WCRecognitionFieldMainTypeMaxCount_Phone                 = 16,
    WCRecognitionFieldMainTypeMaxCount_PublicNote            = 1,
    WCRecognitionFieldMainTypeMaxCount_UnifiedBusinessNumber = 1,
    WCRecognitionFieldMainTypeMaxCount_URL                   = 6,
    WCRecognitionFieldMainTypeMaxCount_UserDefine            = NSUIntegerMax,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM (NSUInteger,WCRecognitionFieldMainType)
{
    WCRecognitionFieldMainType_None,
	WCRecognitionFieldMainType_Name,     // 1 : has value combined type
	WCRecognitionFieldMainType_Company,  // 2 : has value combined type
	WCRecognitionFieldMainType_Address,  // 3 : has value combined type
	WCRecognitionFieldMainType_Phone,
	WCRecognitionFieldMainType_Email,
	WCRecognitionFieldMainType_URL,
	WCRecognitionFieldMainType_InstantMessage,
	WCRecognitionFieldMainType_Date,
	WCRecognitionFieldMainType_Note,
	WCRecognitionFieldMainType_Nickname,
    WCRecognitionFieldMainType_UnifiedBusinessNumber,  //統一編號，中文版才有用
};

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, WCRecognitionFieldLabelType)
{
	WCRecognitionFieldLabelType_None = 0,
    
	WCRecognitionFieldLabelType_Address_Work = WCRecognitionFieldMainType_Address*WCRecognitionFieldDistance,
	WCRecognitionFieldLabelType_Address_Home,
	WCRecognitionFieldLabelType_Address_Other,
    
	WCRecognitionFieldLabelType_Phone_Work = WCRecognitionFieldMainType_Phone*WCRecognitionFieldDistance,
	WCRecognitionFieldLabelType_Phone_Home,
	WCRecognitionFieldLabelType_Phone_Mobile,
	WCRecognitionFieldLabelType_Phone_Main,
	WCRecognitionFieldLabelType_Phone_WorkFax,
	WCRecognitionFieldLabelType_Phone_HomeFax,
	WCRecognitionFieldLabelType_Phone_Pager,
    WCRecognitionFieldLabelType_Phone_GoogleVoice,
    WCRecognitionFieldLabelType_Phone_iPhone,
	WCRecognitionFieldLabelType_Phone_Other,
    
	WCRecognitionFieldLabelType_Email_Work = WCRecognitionFieldMainType_Email*WCRecognitionFieldDistance,
	WCRecognitionFieldLabelType_Email_Home,
	WCRecognitionFieldLabelType_Email_Other,
    
	WCRecognitionFieldLabelType_URL_HomePage = WCRecognitionFieldMainType_URL*WCRecognitionFieldDistance,
	WCRecognitionFieldLabelType_URL_Work,
	WCRecognitionFieldLabelType_URL_Home,
    WCRecognitionFieldLabelType_URL_Profile,
    WCRecognitionFieldLabelType_URL_Blog,
	WCRecognitionFieldLabelType_URL_Other,
    
	WCRecognitionFieldLabelType_IM_MSN = WCRecognitionFieldMainType_InstantMessage*WCRecognitionFieldDistance,
	WCRecognitionFieldLabelType_IM_Skype,
	WCRecognitionFieldLabelType_IM_QQ,
	WCRecognitionFieldLabelType_IM_Yahoo,
	WCRecognitionFieldLabelType_IM_ICQ,
	WCRecognitionFieldLabelType_IM_GoogleTalk,
	WCRecognitionFieldLabelType_IM_Jabber,
	WCRecognitionFieldLabelType_IM_AIM,
    WCRecognitionFieldLabelType_IM_Other,

	WCRecognitionFieldLabelType_Birthday = WCRecognitionFieldMainType_Date*WCRecognitionFieldDistance,
	WCRecognitionFieldLabelType_Date_Anniversary,
	WCRecognitionFieldLabelType_Date_Other,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, WCRecognitionFieldSubType)
{
	WCRecognitionFieldSubType_None = 0,
	WCRecognitionFieldSubType_SearchOnly,
    WCRecognitionFieldSubType_DontCare,
    
	WCRecognitionFieldSubType_Name_FirstName = WCRecognitionFieldMainType_Name*(WCRecognitionFieldDistance/2),
	WCRecognitionFieldSubType_Name_FirstNamePhonetic,
	WCRecognitionFieldSubType_Name_LastName,
	WCRecognitionFieldSubType_Name_LastNamePhonetic,
	WCRecognitionFieldSubType_Name_MiddleName,
    WCRecognitionFieldSubType_Name_Prefix,
    WCRecognitionFieldSubType_Name_Suffix,
    
	WCRecognitionFieldSubType_Company_Name = WCRecognitionFieldMainType_Company*(WCRecognitionFieldDistance/2),
	WCRecognitionFieldSubType_Company_Phonetic,
	WCRecognitionFieldSubType_Company_Department,
	WCRecognitionFieldSubType_Company_JobTitle,
    
	WCRecognitionFieldSubType_Address_Street = WCRecognitionFieldMainType_Address*(WCRecognitionFieldDistance/2),
	WCRecognitionFieldSubType_Address_City,
	WCRecognitionFieldSubType_Address_State,
	WCRecognitionFieldSubType_Address_Zip,
	WCRecognitionFieldSubType_Address_Country,
	WCRecognitionFieldSubType_Address_CountryCode,
	WCRecognitionFieldSubType_Address_Format,
	WCRecognitionFieldSubType_Address_GPS,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, WCRecognitionFieldSource)
{
    WCRecognitionFieldSource_UserCreate = 0,	// 手動建立
	WCRecognitionFieldSource_FrontRecog,		// 正面辨識
	WCRecognitionFieldSource_BackRecog			// 反面辨識
};

#endif
