//
//  WCNewCardFlowController.h
//
//  NOTE
//  --------------------------------------------------
//  1. 可限制新增數量
//  2. 各自有獨立的flowController
//  3. 所有使用到的字串及影像檔統一定義在 WCNewCardFlowController+ResourceDefine.h
//  3. 所有設定值的key統一定義在 WCNewCardFlowController+SettignsKey.h
//  4. 辨識動作透過WCNewCardFlowDelegate在外部執行（因WCM的BCR核心有分版本，所以辨識不能包含在此元件中。）
//  5. 資料庫操作透過WCNewCardFlowDelegate在外部執行（WCM/WCE dataController不同）
//  6. Alert顯示及WCNewCardFlow關閉流程請搜尋showAlertWithError
//  7. 單張進編輯元件，多張的話直接將多張名片結果回傳
//  8. newCardFlowDidFinishWithError: 回傳的錯誤，如果是訂閱，要開啟訂閱畫面

#import <Foundation/Foundation.h>
#import "WCCardModel.h"
#import "WCRecogSourceModel.h"
#import "WCNewCardFlowDatasource.h"
#import "WCNewCardFlowDelegate.h"
#import "WCNewCardFlowController+ParameterDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

/// 無限制新增數量定義值
extern NSInteger const WCNewCardFlowController_UnlimitedCount;


////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCNewCardFlowController : NSObject

#pragma mark - property


/// WCNewCardFlowDatasource 
@property (nonatomic, assign) id<WCNewCardFlowDatasource> datasource;

/// WCNewCardFlowControllerDelegate
@property (nonatomic, assign) id<WCNewCardFlowDelegate> delegate;

/// 最多可新增數量，WCNewCardFlowController_UnlimitedCount 代表無限制。
@property (nonatomic, assign) NSInteger maxNewCardCount;

/// 最多可匯入數量，WCNewCardFlowController_UnlimitedCount 代表無限制。
@property (nonatomic, assign) NSInteger maxImportCardCount;


/// 幫同事掃描的對象，只有在mode是WCNewCardFlowController_Mode_HelpScan時才用得到
@property (nonatomic, retain) NSString *helpScanTargetAccountName;

//////////////////////////////////////////////////
#pragma mark - method

/**
 * Initialize
 *
 * @return WCNewCardFlowController object
 */
- (id)init;


/**
 * Start new card flow
 *
 * @param mode - One of WCNewCardFlowController_Mode
 * @param superViewController - super view controller
 * @param cloudKeyDictionary - 第三方空間設定值 see PPCloud ，WCNewCardFlowController_Mode_Import時需要此設定
 */
- (void)newCardWithMode:(WCNewCardFlowController_Mode)mode superViewController:(UIViewController *)superViewController cloudKeyDictionary:(NSDictionary *)cloudKeyDictionary;


/**
 *  暫停辨識動作，並等待結束
 */
+ (void)suspendRecogOperation;


/**
 *  繼續上次的辨識
 */
+ (void)resumeRecogOperation;


/**
 取消辨識動作，移除所有暫存資料
 */
+ (void)cancelRecogOperation;

@end
