//
//  PPSignatureNavigationBarView.h
//
//
//  Created by Howard.Lin on 14/1/14.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import "PPNavigationBarView.h"
#import "PPButton.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, PPSignatureNavigationBarViewButtonTag)
{
    PPSignatureNavigationBarViewButtonTag_Back,
    PPSignatureNavigationBarViewButtonTag_Recognition,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@class PPSignatureNavigationBarView;

@protocol PPSignatureNavigationBarViewDelegate <NSObject>

@required
 - (void)ppSignatureNavigationBarView:(PPSignatureNavigationBarView *)ppSignatureNavigationBarView
                             ppButton:(PPButton *)ppButton
                         controlEvent:(UIControlEvents)controlEvent;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPSignatureNavigationBarView : PPNavigationBarView <PPButtonDelegate>

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,assign)   id<PPSignatureNavigationBarViewDelegate> delegate;
@property (nonatomic,readonly) PPButton *backButton;
@property (nonatomic,readonly) PPButton *recognitionButton;
@end
