//
//  WCMapAnnotation.h
//  
//
//  Created by Howard on 2015/12/30.
//
//

#import <Foundation/Foundation.h>
#import <MapKit/MapKit.h>

@interface WCMapAnnotation : NSObject <MKAnnotation>

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic, readonly) CLLocationCoordinate2D coordinate;
@property (nonatomic, retain) CLLocation *centerLocation;
@property (nonatomic, readonly) NSMutableArray *cardModels;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

- (BOOL)multiCardIDs;
- (NSInteger)isCardIDExist:(NSString *)cardID;
- (void)bringFirstWithCardID:(NSString *)cardID;

- (BOOL)sameCompare:(WCMapAnnotation *)mapAnnotation;
- (void)updateContentWithAnnotaiton:(WCMapAnnotation *)mapAnnotation;
- (NSString *)currentCardID;
- (NSMutableDictionary *)displayTitlesDictionary;

@end
