//
//  WCExportFlowController.h
//  Example
//
//  Created by Andrew on 2015/8/3.
//  Copyright (c) 2015年 Eddie. All rights reserved.
//

#import "PPViewController.h"

// Model
#import "WCImageDefine.h"
#import "WCDisplayNameDefine.h"

// View
#import "WCFileTypeSelectView.h"

// Controller
#import "WCABDataController.h"
#import "PPStorageSpaceSelectViewController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCExportFlowController Protocol

@class WCExportFlowController;
@protocol WCExportFlowControllerDelegate <NSObject>

@required

- (WCDisplayNameOrder)contactNameEastOrderInExportFlowController:(WCExportFlowController *)exportFlowController;
- (WCDisplayNameOrder)contactNameWestOrderInExportFlowController:(WCExportFlowController *)exportFlowController;


/**
 *  要求該cardID聯絡人資訊，自動依據內部abPersonID判斷是新增或更新手機聯絡人
 *
 *  @param exportFlowController - Data Export controller instance
 *  @param cardID               - Card that need get field data
 *
 *  @return WCABCardModel with field data of card
 */
- (WCABCardModel *)exportFlowController:(WCExportFlowController *)exportFlowController addressBookCardModelWithCardID:(NSString *)cardID;


/**
 *  完成匯出手機聯絡人，提供cardID對應已加入系統的WCABCardModel(系統聯絡人紀錄)
 *
 *  @param exportFlowController - Data Export controller instance
 *  @param abCardModel          - 加入系統更新後的abCardModel(系統聯絡人紀錄)
 *  @param cardID               - 當前加入的聯絡人ID
 */
- (void)exportFlowController:(WCExportFlowController *)exportFlowController exportOneAddressBookCardModel:(WCABCardModel *)abCardModel withCardID:(NSString *)cardID;


/**
 * Request field data to write
 *
 * @param exportFlowController - Data Export controller instance
 * @param cardID - Card that need get field data
 * @return WCCardModel with field data of card
 */
- (WCCardModel *)exportFlowController:(WCExportFlowController *)exportFlowController cardModelToWriteWithCardID:(NSString *)cardID;


/**
 * Request group name to write
 *
 * @param exportFlowController - Data Export controller instance
 * @param groupID - Group ID that need get name
 * @return Group name
 */
- (NSString *)exportFlowController:(WCExportFlowController *)exportFlowController groupNameToWriteWithGroupID:(WC_GroupID)groupID;


/**
 * Request image data to write
 *
 * @param exportFlowController - Data Export controller instance
 * @param cardID - Card that need get image data
 * @param imageType - Needed image type
 * @return Image data of card
 */
- (NSData *)exportFlowController:(WCExportFlowController *)exportFlowController imageDataToWriteWithCardID:(NSString *)cardID imageType:(WC_ImageType)imageType;


@optional

/**
 * 取得客制化錯誤訊息
 *
 * @param exportFlowController - Data Export controller instance
 * @param error 要客制化的錯誤
 * @return 客制化的錯誤訊息
 */
- (NSString *)exportFlowController:(WCExportFlowController *)exportFlowController requestErrorMessageWithError:(NSError*)error;

/**
 * Notify one card is write finish
 *
 * @param exportFlowController - Data Export controller instance
 * @param index - Write card index
 * @param totalCount - Total count
 */
- (void)exportFlowController:(WCExportFlowController *)exportFlowController didWriteCardWithIndex:(NSInteger)index totalCount:(NSInteger)totalCount;


/**
 *  匯出流程結束，發布通知
 *
 *  @param exportFlowController - Data Export controller instance
 *  @param error - NSError
 */
- (void)exportFlowController:(WCExportFlowController *)exportFlowController didFinishWithError:(NSError *)error;


/**
 *  詢問是否有同步過，只要有一筆沒同步過就回傳NO
 *
 *  @param exportFlowController - Data Export controller instance
 *  @param guids contact guids
 *
 *  @return BOOL YES, if all contacts were synced, otherwise NO
 */
- (BOOL)exportFlowController:(WCExportFlowController *)exportFlowController checkIfSyncWithContactGuids:(NSArray *)guids;

@end





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCExportFlowController Interface

@interface WCExportFlowController : PPViewController

@property (nonatomic, assign) id<WCExportFlowControllerDelegate> delegate;
@property (nonatomic, retain) NSArray *contactIdentifierArray; //已勾選的聯絡人Identifier字串陣列
@property (nonatomic, retain) NSString *defaultFilePath;
@property (nonatomic, retain) NSString *syncAccountName;
@property (nonatomic, assign) BOOL enableCRM;       // 是否可用CRM，預設NO
@property (nonatomic, assign) BOOL enableExchangeServer;       // 是否可用ExchangeServer，預設NO
@property (nonatomic, retain) NSString *exchangeName;       // exchange server 名稱

@property (nonatomic, retain) NSArray *fileTypeOrderSource; //WCFileTypeSelectView_ContactFileType Number Array





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

/**
 *  顯示空間選擇視圖
 *
 *  @param cloudKeyDictionary  空間設定鍵值辭典
 *  @param spaceTypeArray      空間選擇陣列 The array of PPStorageSpaceSelectControllerSpaceType
 *  @param superViewController 來源視圖
 *
 *  @return YES 成功顯示
 */
- (BOOL)showFromSuperViewController:(UIViewController *)superViewController
             withCloudKeyDictionary:(NSDictionary *)cloudKeyDictionary
                     spaceTypeArray:(NSArray *)spaceTypeArray;


/**
 *  將選擇的聯絡人(contactIdentifierArray)直接匯出至系統聯絡人
 *
 *  @param superViewController superViewController
 *
 *  @return YES 成功匯出
 */
- (BOOL)exportAddressBookCardsFromSuperViewController:(UIViewController *)superViewController;

@end
