//
//  WCFieldModel.m
//  WorldCard series
//
//  Created by  Eddie on 2012/3/22.
//  Copyright 2011 Penpower. All rights reserved.
//

#import "WCFieldDefine.h"
#import "WCCustomFieldDefine.h"
#import "WCUserDefinedFieldValueModel.h"
#import "PPURLController.h"


@interface WCFieldModel : NSObject <NSCopying>
{
    NSInteger           ID_;
    NSInteger           order_;
    WC_FieldSource      source_;
    WC_FieldType        type_;
    WC_FieldSubType1    subType1_;
    WC_FieldSubType2    subType2_;
    id                  value_;
    CGRect              recogRect_;
    BOOL                isCJKStringValue_; //資料內容為中、日、韓字串
}


@property (nonatomic, assign) NSInteger			ID;
@property (nonatomic, assign) NSInteger			order;
@property (nonatomic, assign) WC_FieldSource	source;
@property (nonatomic, assign) WC_FieldType      type;
@property (nonatomic, assign) WC_FieldSubType1  subType1;
@property (nonatomic, assign) WC_FieldSubType2	subType2;
@property (nonatomic, retain) id                value;
@property (nonatomic, assign) CGRect			recogRect;
@property (nonatomic, assign) BOOL				isCJKStringValue;

//////////////////////////////////////////////////
// for WorldCardTeam

@property (nonatomic, retain) NSString *guid;
@property (nonatomic, retain) NSString *customFieldInfoGuid;
@property (nonatomic, assign) WCCustomFieldContentType customFieldContentType;

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance methods

- (BOOL)isEmpty;

#pragma mark - display string
- (NSString *)stringDisplayCompany;
- (NSString *)stringDisplayCompanyPhonetic;
- (NSString *)stringDisplayGPS;

- (NSInteger)addressFormatWithBCRLanguage:(NSInteger)bcrLanguage;
- (PPURLControllerType)addressURLTypeWithBCRLanguage:(NSInteger)bcrLanguage;
- (NSString *)stringDisplayCountryWithBCRLanguage:(NSInteger)bcrLanguage;
- (NSString *)stringDisplayAddressWithBCRLanguage:(NSInteger)bcrLanguage;
- (NSString *)stringGoogleAddressWithBCRLanguage:(NSInteger)bcrLanguage;


#pragma mark - handle subType2 field (use in subType1 field)
- (void)setSubType2Field:(WCFieldModel *)fieldModel;
- (void)setSubType2FieldWithValue:(id)value recogRect:(CGRect)recogRect subType2:(WC_FieldSubType2)fieldSubType2;
- (WCFieldModel *)fieldWithSubType2:(WC_FieldSubType2)fieldSubType2;
- (id)valueWithSubType2:(WC_FieldSubType2)fieldSubType2;
- (BOOL)hasFieldWithSubType2:(WC_FieldSubType2)fieldSubType2;
- (void)removeFieldWithWithSubType2:(WC_FieldSubType2)fieldSubType2;
- (BOOL)hasSameValue:(WCFieldModel *)fieldModel;
- (WC_ValueType)valueTypeWithValue:(id)value;

#pragma mark - Class methods

/// 建立欄位model
+ (instancetype)newFieldModel;

@end
