//
//  WCContactInfoScrollViewController.h
//  WCMContactInfoViewController
//
//  Created by Andrew on 2015/6/1.
//  Copyright (c) 2015年 Andrew.Lai. All rights reserved.
//
//!! 橫式雙面名片樣式轉直式單面名片樣式會造成滾動異常(同頁面切換旋轉後)  

// Base
#import "PPViewController.h"

// Controller
#import "ContactInfoViewController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCContactInfoScrollViewController DataExchangeProtocol

@class WCContactInfoScrollViewController;
@protocol WCContactInfoScrollViewControllerDataExchangeProtocol <NSObject>

/**
 *  fetch Contact Favorite BOOL Value
 *
 *  @param contactInfoScrollViewController contactInfoScrollViewController
 *  @param contactIdentifier               contactIdentifier
 *
 *  @return Contact Favorite BOOL Value
 */
- (BOOL)contactInfoScrollViewController:(WCContactInfoScrollViewController *)contactInfoScrollViewController
          favoriteWithcontactIdentifier:(NSString *)contactIdentifier;

/**
 *  fetch Contact Images Information
 *
 *  @param contactInfoScrollViewController contactInfoScrollViewController
 *  @param contactIdentifier               contactIdentifier
 *  @param contactMainType                 contactMainType
 *  @param contactSubType                  contactSubType
 *
 *  @return Contact Image with contactIdentifier & contactMainType & contactSubType
 */
- (UIImage *)contactInfoScrollViewController:(WCContactInfoScrollViewController *)contactInfoScrollViewController
                           contactIdentifier:(NSString *)contactIdentifier
                   imageForPPContactMainType:(PPContactMainType)contactMainType
                            ppContactSubType:(PPContactSubType)contactSubType;

/**
 *  fetch Contact Characters Information
 *
 *  @param contactInfoScrollViewController contactInfoScrollViewController
 *  @param contactIdentifier               contactIdentifier
 *  @param contactMainTypeArray            contactMainTypeArray
 *
 *  @return Contact Characters Information Dictionary
 */
- (NSDictionary *)contactInfoScrollViewController:(WCContactInfoScrollViewController *)contactInfoScrollViewController
                                contactIdentifier:(NSString *)contactIdentifier
         fieldDictionaryforPPContactMainTypeArray:(NSArray *)contactMainTypeArray;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCContactInfoScrollViewController DataSource

@protocol WCContactInfoScrollViewControllerDataSource <NSObject>

- (BOOL)shouldShowPhoneticOnContactInfoScrollViewController:(WCContactInfoScrollViewController *)contactInfoScrollViewController;

- (WCDisplayNameOrder)contactNameEastOrderInContactInfoScrollViewController:(WCContactInfoScrollViewController *)contactInfoScrollViewController;
- (WCDisplayNameOrder)contactNameWestOrderInContactInfoScrollViewController:(WCContactInfoScrollViewController *)contactInfoScrollViewController;

- (NSMutableArray *)ppContactMainTypeArrayFetchingDataForContactInfoScrollViewController:(WCContactInfoScrollViewController *)contactInfoScrollViewController contactIdentifier:(NSString *)contactIdentifier;
- (NSArray *)translateLanguageArrayInContactInfoScrollViewController:(WCContactInfoScrollViewController *)contactInfoScrollViewController translateLocation:(ContactInfoViewControllerTranslateLocation)translateLocation;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCContactInfoScrollViewController Delegate

@protocol WCContactInfoScrollViewControllerDelegate <NSObject>

- (void)contactInfoScrollViewController:(WCContactInfoScrollViewController *)contactInfoScrollViewController
                      contactIdentifier:(NSString *)contactIdentifier
                                 action:(ContactInfoViewControllerAction)action;

- (void)contactInfoScrollViewController:(WCContactInfoScrollViewController *)contactInfoScrollViewController
                      contactIdentifier:(NSString *)contactIdentifier
               didSelectValueDictionary:(NSDictionary *)valueDictionary;

- (void)contactInfoScrollViewController:(WCContactInfoScrollViewController *)contactInfoScrollViewController
                      contactIdentifier:(NSString *)contactIdentifier
                   didSelectPhoneNumber:(NSString *)phoneNumber;

/**
 *  通知將contactMainType內某個Cell欄位(fieldIndex)資料設為第一優先
 */
- (void)contactInfoScrollViewController:(WCContactInfoScrollViewController *)contactInfoScrollViewController
                      contactIdentifier:(NSString *)contactIdentifier
                          setFieldIndex:(NSUInteger)fieldIndex
                  toDefaultWithMainType:(PPContactMainType)contactMainType;

/**
 * 翻譯完畢後，請使用reloadContactInformationInCurrentPageWithCardID:Completed:更新翻譯結果
 */
- (void)contactInfoScrollViewController:(WCContactInfoScrollViewController *)contactInfoScrollViewController
                      contactIdentifier:(NSString *)contactIdentifier
                  translateFromLanguage:(NSString *)fromLanguage
                             toLanguage:(NSString *)toLanguage;

/**
 * 因為當前ContactIdentifier的聯絡人無前後名片圖，要求外部給予假名片圖
 */
- (UIImage *)contactInfoScrollViewController:(WCContactInfoScrollViewController *)contactInfoScrollViewController
        defaultCardImageForContactIdentifier:(NSString *)contactIdentifier;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WCContactInfoScrollViewController Interface

@interface WCContactInfoScrollViewController : PPViewController
@property (nonatomic, assign)   id<WCContactInfoScrollViewControllerDataExchangeProtocol> dataExchangeProtocol;
@property (nonatomic, assign)   id<WCContactInfoScrollViewControllerDataSource>           dataSource;
@property (nonatomic, assign)   id<WCContactInfoScrollViewControllerDelegate>             delegate;
@property (nonatomic, readonly) ContactInfoViewControllerInterfaceStyle                   interfaceStyle;
@property (nonatomic, assign)   ContactInfoViewControllerUserInterfaceIdom                interfaceIdom;
@property (nonatomic, assign)   BOOL                                                      isBackButtonShowed; //Default is YES, This must be set to NO in iPad.


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Initial Method

/**
 *  初始化相關參數，當前聯絡人索引 與 所有聯絡人的Identifier
 *
 *  @param currentContactIndex 當前要顯示的聯絡人索引
 *  @param identifierArray     所有聯絡人的identifier (NSString Array)
 *
 *  @return 當前物件
 */
- (id)initWithCurrentContactIndex:(NSInteger)currentContactIndex contactIdentifierArray:(NSArray *)identifierArray interfaceStyle:(ContactInfoViewControllerInterfaceStyle)interfaceStyle;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

/**
 * 取得當前聯絡人是否呈現的名片圖是前名片圖
 */
- (BOOL)isShowFrontCardInCurrentContactPage;


/**
 *  對當前頁面抓取更新後的資料
 *
 *  @param cardID    若傳入nil，即為原始聯絡人資料進行更新;若傳入非nil即切換聯絡人
 *  @param completed 完成通知
 */
- (void)reloadContactInformationInCurrentPageWithCardID:(NSString *)cardID Completed:(void (^)(void))completed;


/**
 *  對當前頁面進行清除資料(不在畫面上時)
 */
- (void)clearContactInformationInCurrentPage;


/**
 *  在當前頁面呈現導覽，主要是給予iPad使用(因為iPad僅呈現於右側，會與左側導覽衝突)
 */
- (void)showGuideInCurrentPage;

/**
 *  取得當前頁面的ID
 */
- (NSString *)contactIDInCurrentPage;

/**
 *  取得當前頁面的名片圖背面
 */
- (UIImage *)contactBackCardImageInCurrentPage;


/**
 *  取得當前頁面的名片圖前面
 */
- (UIImage *)contactFrontCardImageInCurrentPage;

@end
