//
//  WCContactEditViewControllerDataSource.h
//  
//
//  Created by Howard on 2015/9/17.
//
//

#import <Foundation/Foundation.h>

// Define
#import "PPContactMainTypeDefine.h"
#import "PPContactSubTypeDefine.h"
#import "PPContactLabelTypeDefine.h"

@class WCContactEditViewController;

@protocol WCContactEditViewControllerDataSource <NSObject>

@required

/**
 *  文字資訊欄位陣列，用來取欄位的ContactMainType
 *
 *  @param contactEditViewController 委托者
 *
 *  @return 文字資訊欄位陣列
 */
- (NSMutableArray *)ppContactMainTypeArrayFetchingDataForWCContactEditViewController:(WCContactEditViewController *)contactEditViewController;

/**
 *  新增欄位視圖的欄位資訊
 *
 *  @param contactEditViewController 委托者
 *
 *  @return 新增欄位的資訊陣列
 */
- (NSMutableArray *)ppContactMainTypeArrayFetchingNewSectionFieldDataForWCContactEditViewController:(WCContactEditViewController *)contactEditViewController;

/**
 *  欄位長度上限
 *
 *  @param contactEditViewController 委托者
 *  @param contactMainType           欄位型態
 *  @param contactSubType            子欄位型態
 *
 *  @return 欄位長度上限
 */
- (NSUInteger)contactEditTableViewCellTextMaxLengthInWCContactEditViewController:(WCContactEditViewController *)contactEditViewController
                                                               ppContactMainType:(PPContactMainType)contactMainType
                                                                  contactSubType:(PPContactSubType)contactSubType
                                                                contactLabelType:(PPContactLabelType)contactLabelType;

/**
 *  是否顯示發音欄位
 *
 *  @param contactEditViewController 委托者
 *
 *  @return YES 顯示發音欄位, NO 不顯示
 */
- (BOOL)shouldShowPhoneticOnWCContactEditViewController:(WCContactEditViewController *)contactEditViewController
                                        contactMainType:(PPContactMainType)contactMainType;

/**
 *  是否顯示發音選單
 *
 *  @param contactEditViewController 委托者
 *
 *  @return YES 顯示發音欄位, NO 不顯示
 */
- (BOOL)shouldShowSelectPhoneticMenuOnWCContactEditViewController:(WCContactEditViewController *)contactEditViewController;


/**
 *  發音欄位內容 @[NSString, NSString, ...];
 *
 *  @param contactEditViewController 委托者
 *  @param phonetic                  目前發音
 *  @param sourceValue               發音的來源字串
 *  @param contactSubtype            ContactSubType
 *
 *  @return 發音欄位內容
 */
- (NSMutableArray *)phoneticArrayWithWCContactEditViewController:(WCContactEditViewController *)contactEditViewController
                                                 clickedPhonetic:(NSString *)phonetic
                                                     sourceValue:(NSString *)sourceValue
                                                ppContactSubType:(PPContactSubType)contactSubtype;


/**
 *  詢問名片是否存在(用來顯示目前上方工具列的排版, 請直接在 main thread回)
 *
 *  @param contactEditViewController 委托者
 *  @param contactMaintype           名片類型
 *
 *  @return <#return value description#>
 */
- (BOOL)imageExistWithWCContactEditViewController:(WCContactEditViewController *)contactEditViewController
                                ppContactMainType:(PPContactMainType)contactMaintype;

@optional

/**
 *  編輯下方視圖高度
 *
 *  @param contactEditViewController 委托者
 *
 *  @return 高度
 */
- (CGFloat)contactEditTableFootViewHeightInWCContactEditViewController:(WCContactEditViewController *)contactEditViewController;

/**
 *  下方視圖所需要文字資訊陣列
 *
 *  @param ppContactMainType one parameter of PPContactMainType
 *  @param contactEditViewController 委托者
 *
 *  @return 文字資訊的陣列
 */
- (NSMutableArray *)ppContactSubTypeArrayForSortingSectionRowWithPPContactMainType:(PPContactMainType)ppContactMainType
                                                       ppContactEditViewController:(WCContactEditViewController *)contactEditViewController;

@end
