
//
//  Created by Howard on 2015/7/2.
//
//

#import <UIKit/UIKit.h>

// View
#import "PPButton.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ButtonTag Define

typedef NS_ENUM(NSUInteger, ContactKeyboardToolBarViewButtonTag)
{
    ContactKeyboardToolBarViewButtonTag_HideKeyboard,
    ContactKeyboardToolBarViewButtonTag_SwitchInput,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ContactEditkeyboardToolBarView Delegate

@class ContactKeyboardToolBarView;

////////////////////////////////////////////////////////////////////////////////////////////////////


@protocol ContactKeyboardToolBarViewDelegate <NSObject>

- (void)contactEditKeyboardToolBarView:(ContactKeyboardToolBarView *)contactEditKeyboardToolBarView
                              ppButton:(PPButton *)ppButton
                          controlEvent:(UIControlEvents)controlEvent;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////


@interface ContactKeyboardToolBarView : UIToolbar

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,assign)   id<ContactKeyboardToolBarViewDelegate> contactKeyboardToolBarViewDelegate;
@property (nonatomic,readonly) PPButton                               *hiddenKeyboardButton;
@property (nonatomic,readonly) PPButton                               *switchInputButton;


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

- (void)updatePortraitConstraints;
- (void)updateLandscapeConstraints;
- (void)brintSubViewToFront;

@end
