//
//  ContactInfoNavigationBarView.h
//
//  Created by Howard.Lin on 13/12/24.
//  Modified by Andrew.Lai on 15/05/25.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPNavigationBarView.h"
#import "PPButton+Factory.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

extern CGFloat ContactInfoNavigationBarView_ContactNameShortPressDuration;

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, ContactInfoNavigationBarViewMode)
{
    ContactInfoNavigationBarViewMode_Normal = 0,
    ContactInfoNavigationBarViewMode_Duplicate,
    ContactInfoNavigationBarViewMode_Company,
    ContactInfoNavigationBarViewMode_Nearby,
    ContactInfoNavigationBarViewMode_Salesforce
};

typedef NS_ENUM(NSUInteger, ContactInfoNavigationBarViewButtonTag)
{
    ContactInfoNavigationBarViewButtonTag_Back = 1,
    ContactInfoNavigationBarViewButtonTag_Favorite,
    ContactInfoNavigationBarViewButtonTag_Note,
    ContactInfoNavigationBarViewButtonTag_Other
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@class ContactInfoNavigationBarView;
@protocol ContactInfoNavigationBarViewDelegate <NSObject>

@required
 - (void)contactInfoNavigationBarView:(ContactInfoNavigationBarView *)contactInfoNavigationBarView
                             ppButton:(PPButton *)button
                     withControlEvent:(UIControlEvents)event;

@optional
- (void)contactInfoNavigationBarViewDidShortPressContactName:(ContactInfoNavigationBarView *)contactInfoNavigationBarView;
@end


////////////////////////////////////////////////////////////////////////////////////////////////////

@interface ContactInfoNavigationBarView : PPNavigationBarView <PPButtonDelegate>

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic, assign)   id<ContactInfoNavigationBarViewDelegate> delegate;
@property (nonatomic, readonly) PPButton                                 *backButton;
@property (nonatomic, readonly) PPButton                                 *favoriteButton;
@property (nonatomic, readonly) PPButton                                 *noteButton;
@property (nonatomic, readonly) PPButton                                 *otherButton;

- (id)initWithFrame:(CGRect)frame navigationBarMode:(ContactInfoNavigationBarViewMode)mode isBackButtonShowed:(BOOL)isBackShowed;

- (void)setContactFavorite:(BOOL)isFavorite;
@end
