//
//  ContactInfoHeaderView.h
//  WCMContactInfoViewController
//
//  Created by Andrew on 2015/5/21.
//  Copyright (c) 2015年 Andrew.Lai. All rights reserved.
//

#import <UIKit/UIKit.h>

#import "WCContactViewController+PrivateParameterDefine.h"
#import "WCContactViewController+ResourceDefine.h"
#import "UIView+PPGuideController.h"

#import "ContactImageProtocol.h"
#import "PPButton.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

extern CGFloat ContactInfoHeaderView_ContactNameShortPressDuration;

////////////////////////////////////////////////////////////////////////////////////////////////////

#define ContactInfoHeaderView_ContactNameLabelMaxFont 26
#define ContactInfoHeaderView_SaveAsLabelMaxFont 16
#define ContactInfoHeaderView_EmptyErrorLabelFontSize 20
#define ContactInfoHeaderView_ErrorLabelMargin        20 //空資料錯誤的Label Margin
#define ContactInfoHeaderView_ContactInfoHeight       96 //大頭照和姓名區間高度
#define ContactInfoHeaderView_SaveAsInfoHeight       35 //儲存至的高度

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ENUM

typedef NS_ENUM(NSUInteger, ContactInfoHeaderViewButtonTag)
{
    ContactInfoHeaderViewButtonTag_CardImage = 0,
    ContactInfoHeaderViewButtonTag_HeadImage,
    ContactInfoHeaderViewButtonTag_SwitchCard
};

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Protocol

@class ContactInfoHeaderView;

@protocol ContactInfoHeaderViewDelegate <NSObject>

@required
/**
 *  To notify delegate that button of contactInfoHeaderView does controlEvents
 *
 *  @param contactInfoHeaderView contactInfoHeaderView
 *  @param button                button
 *  @param controlEvents         controlEvents
 */
- (void)contactInfoHeaderView:(ContactInfoHeaderView *)contactInfoHeaderView ppButton:(PPButton *)button didControlEvents:(UIControlEvents)controlEvents;

@optional
/**
 *  通知長按聯絡人名稱
 *
 *  @param contactInfoHeaderView contactInfoHeaderView
 */
- (void)contactInfoHeaderViewDidShortPressContactName:(ContactInfoHeaderView *)contactInfoHeaderView;

@end





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ContactInfoHeaderView Interface

@interface ContactInfoHeaderView : UIView <ContactImageProtocol, PPButtonDelegate>

@property (nonatomic, assign) id<ContactInfoHeaderViewDelegate> delegate;
@property (nonatomic, assign) BOOL      contactCardSwitchButtonVisible; //預設為NO, 必須有背後名片圖才可以設定為YES

@property (nonatomic, retain) PPButton *contactCardImageButton; //若為雙面呈現樣式，該按鈕顯示前名片圖
@property (nonatomic, retain) PPButton *contactHeadImageButton;
@property (nonatomic, retain) PPButton *contactCardSwitchButton;
@property (nonatomic, retain) UILabel  *contactNameLabel;

@property (nonatomic, retain) UILabel  *emptyErrorLabel;

#pragma mark - for salesforce
@property (nonatomic, assign) BOOL     showSaveAsLabel; //預設為NO, salesforce介面才有這個欄位
@property (nonatomic, retain) UIView   *separatorView;
@property (nonatomic, retain) UILabel  *saveAsLabel;




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

/**
 *  設定CardImage的origin Y
 *
 *  @param positionY origion Y of contactCardImageButton
 */
- (void)setCardImagePositionY:(CGFloat)positionY;

/**
 *  是否呈現名片影像loading畫面
 *
 *  @param visible YES->呈現
 */
- (void)cardImageIndicatorViewVisible:(BOOL)visible;

/**
 *  是否呈現大頭照影像loading畫面
 *
 *  @param visible YES->呈現
 */
- (void)headImageIndicatorViewVisible:(BOOL)visible;

/**
 *  是否呈現空資料錯誤訊息於名片圖上方
 *
 *  @param visible YES->呈現
 */
- (void)emptyErrorMessageLabelVisible:(BOOL)visible;

/**
 * To show default Head image
 */
- (void)showDefaultHeadImage;

/**
 * 設定前名片圖
 */
- (void)setContactFrontCardImage:(UIImage *)contactFrontCardImage;

/**
 *  設定後名片圖
 */
- (void)setContactRearCardImage:(UIImage *)contactRearCardImage;

/**
 *  設定需顯示的聯絡人名稱
 *
 *  @param contactName 聯絡人名稱
 */
- (void)setContactName:(NSString *)contactName;


/**
 *  設定遮罩的透明度，並進行額外的設定
 *
 *  @param colorAlpha 遮罩頁面的透明度
 */
- (void)setContactCardMaskAlpha:(CGFloat)colorAlpha  switchButtonHidden:(BOOL)isHidden;


/**
 *  重新LayoutHeaderView的SubView
 */
- (void)layoutInfoHeaderSubViews;

@end
