//
//  WCCardImageFlowController.h
//  WorldCardMobile7
//
//  Created by sanhue on 2015/7/20.
//  Copyright (c) 2015年 penpower. All rights reserved.
//

#import <Foundation/Foundation.h>


////////////////////////////////////////////////////////////////////////////////////////////////////
@class WCCardImageFlowController;

@protocol WCCardImageFlowControllerDelegate <NSObject>

/**
 * 檢查名片是否還存在
 * @param cardID 目前處理的影像的cardID
 * @return BOOL 名片是否存在
 */

- (BOOL)isCardExist:(NSString *)cardID;

/**
 * 取得名片圖
 * @param cardID 要取得的名片ID
 * @return UIImage 名片圖
 */
- (UIImage *)copyDefaultCardImageWithCardID:(NSString *)cardID;
- (UIImage *)copyFrontCardImageWithCardID:(NSString *)cardID;
- (UIImage *)copyBackCardImageWithCardID:(NSString *)cardID;

/**
 * 按確定，結束card image
 * @param cardID 目前處理的影像的cardID
 * @param frontCardImage 處理後的前名片圖
 * @param isFrontCardChanged 正面名片是否有改變
 * @param backCardImage 處理後的後名片圖
 * @param isBackCardChanged 反面名片是否有改變
 * @param isBackBecomeFront 是否有反面變正面的情況發生，這個要先處理
 * @return BOOL YES:可以結束頁面，else NO，default YES
 */
- (BOOL)didFinishWithCardID:(NSString *)cardID
             frontCardImage:(UIImage*)frontCardImage
         isFrontCardChanged:(BOOL)isFrontCardChanged
              backCardImage:(UIImage *)backCardImage
          isBackCardChanged:(BOOL)isBackCardChanged
          isBackBecomeFront:(BOOL)isBackBecomeFront;

/**
 * 按返回，結束card image
 * @param cardImageFlowController 委託者
 */
- (void)didFinishWithCardImageFlowController:(WCCardImageFlowController *)cardImageFlowController;
@end


////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCCardImageFlowController : NSObject

@property (nonatomic, retain) id userInfo;

/**
 * 初始化
 * @param delegate delegate處理對象
 * @return instancetype 回傳WCCardImageFlowController的實體
 */
- (instancetype)initWithDelegate:(id<WCCardImageFlowControllerDelegate>)delegate;

/**
 * 顯示聯絡人名片編輯
 * @param viewController 從哪個頁面開始顯示
 * @param cardID 要顯示的聯絡人ID
 * @param showBackCardImage 一開始顯示正面或反面
 * @return BOOL YES:顯示成功，else NO
 */
- (BOOL)showFromViewController:(UIViewController *)viewController
                        cardID:(NSString *)cardID
             showBackCardImage:(BOOL)showBackCardImage;
@end
