//
//  PPWorldcardAddressController.h
//  
//
//  Created by Mike on 13/12/25.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import <Foundation/Foundation.h>
#include "worldcard_address.h"


/// !! 參考WorldCard_Address.doc
typedef NS_ENUM(NSUInteger, PPWorldcardAddressControllerSystemLanguage)
{
    PPWorldcardAddressControllerSystemLanguage_SimplifiedChinese    = 0x0404, //繁體中
    PPWorldcardAddressControllerSystemLanguage_TraditionalChinese   = 0x0804, //簡體中
    PPWorldcardAddressControllerSystemLanguage_ChineseAuto          = 0x0004, //中自動
    PPWorldcardAddressControllerSystemLanguage_English              = 0x0409, //英
    PPWorldcardAddressControllerSystemLanguage_German               = 0x0407, //德
    PPWorldcardAddressControllerSystemLanguage_French               = 0x040C, //法
    PPWorldcardAddressControllerSystemLanguage_Italy                = 0x0410, //義大利
    PPWorldcardAddressControllerSystemLanguage_Spanish              = 0x040A, //西班牙
    PPWorldcardAddressControllerSystemLanguage_Norwegian            = 0x0414, //挪威
    PPWorldcardAddressControllerSystemLanguage_Hungarian            = 0x040E, //匈牙利
    PPWorldcardAddressControllerSystemLanguage_Polish               = 0x0415, //波蘭
    PPWorldcardAddressControllerSystemLanguage_Swedish              = 0x041D, //瑞典
    PPWorldcardAddressControllerSystemLanguage_Dutch                = 0x0413, //荷蘭
    PPWorldcardAddressControllerSystemLanguage_Turkish              = 0x041F, //土耳其
    PPWorldcardAddressControllerSystemLanguage_Russian              = 0x0419, //俄羅斯
    PPWorldcardAddressControllerSystemLanguage_Japan                = 0x0411, //日
    PPWorldcardAddressControllerSystemLanguage_Korea                = 0x0412, //韓
    PPWorldcardAddressControllerSystemLanguage_Danish               = 0x0406, //丹麥
    PPWorldcardAddressControllerSystemLanguage_Finnish              = 0x040B, //芬蘭
    PPWorldcardAddressControllerSystemLanguage_Portuguese           = 0x0816, //葡萄牙
    PPWorldcardAddressControllerSystemLanguage_Greek                = 0x0408, //希臘
    PPWorldcardAddressControllerSystemLanguage_Brazil               = 0x0416, //巴西
    PPWorldcardAddressControllerSystemLanguage_Czech                = 0x0405, //捷克
    PPWorldcardAddressControllerSystemLanguage_Slovak               = 0x041B, //斯洛伐克
    PPWorldcardAddressControllerSystemLanguage_Ukrainian            = 0x0422, //烏克蘭
    PPWorldcardAddressControllerSystemLanguage_Arabic               = 0x0401, //阿拉伯
    PPWorldcardAddressControllerSystemLanguage_Croatian             = 0x041A, //克羅埃西亞
    PPWorldcardAddressControllerSystemLanguage_Hebrew               = 0x040D, //希伯來
    PPWorldcardAddressControllerSystemLanguage_Romanian             = 0x0418, //羅馬尼亞
    PPWorldcardAddressControllerSystemLanguage_Thai                 = 0x041E, //泰
    PPWorldcardAddressControllerSystemLanguage_Indonesian           = 0x0421, //印尼
    PPWorldcardAddressControllerSystemLanguage_Catalonia            = 0x0403, //加泰羅尼亞
    PPWorldcardAddressControllerSystemLanguage_Vietnamese           = 0x042A, //越南
    PPWorldcardAddressControllerSystemLanguage_SouthAfrica          = 0x0436, //南非
    PPWorldcardAddressControllerSystemLanguage_Albania              = 0x041C, //阿爾巴尼亞
    PPWorldcardAddressControllerSystemLanguage_Armenian             = 0x042B, //亞美尼亞
    PPWorldcardAddressControllerSystemLanguage_Azerbaijani          = 0x042C, //亞塞拜然
    PPWorldcardAddressControllerSystemLanguage_Basque               = 0x042D, //巴斯克
    PPWorldcardAddressControllerSystemLanguage_Belarusian           = 0x0423, //白俄羅斯
    PPWorldcardAddressControllerSystemLanguage_Bulgarian            = 0x0402, //保加利亞
    PPWorldcardAddressControllerSystemLanguage_Estonian             = 0x0409, //愛沙尼亞
    PPWorldcardAddressControllerSystemLanguage_Faroese              = 0x0438, //法羅
    PPWorldcardAddressControllerSystemLanguage_Persian              = 0x0429, //波斯
    PPWorldcardAddressControllerSystemLanguage_Georgia              = 0x0437, //喬治亞
    PPWorldcardAddressControllerSystemLanguage_Hindi                = 0x0439, //印地
    PPWorldcardAddressControllerSystemLanguage_Icelandic            = 0x040F, //冰島
    PPWorldcardAddressControllerSystemLanguage_Kazakh               = 0x043F, //哈薩克
    PPWorldcardAddressControllerSystemLanguage_Kongkani             = 0x0457, //孔卡尼
    PPWorldcardAddressControllerSystemLanguage_Latvia               = 0x0426, //拉脫維亞
    PPWorldcardAddressControllerSystemLanguage_Lithuanian           = 0x0427, //立陶宛
    PPWorldcardAddressControllerSystemLanguage_Macedonian           = 0x042F, //馬其頓
    PPWorldcardAddressControllerSystemLanguage_Malay                = 0x043E, //馬來
    PPWorldcardAddressControllerSystemLanguage_Marathi              = 0x044E, //馬拉提
    PPWorldcardAddressControllerSystemLanguage_Sanskrit             = 0x081A, //梵
    PPWorldcardAddressControllerSystemLanguage_Serbian              = 0x081A, //塞爾維亞
    PPWorldcardAddressControllerSystemLanguage_Slovenian            = 0x0424, //斯洛維尼亞
    PPWorldcardAddressControllerSystemLanguage_Swahili              = 0x0441, //斯瓦西里
    PPWorldcardAddressControllerSystemLanguage_Tamil                = 0x0449, //坦米爾
    PPWorldcardAddressControllerSystemLanguage_Tatar                = 0x0444, //韃靼
    PPWorldcardAddressControllerSystemLanguage_Urdu                 = 0x0420, //烏爾都
    PPWorldcardAddressControllerSystemLanguage_Uzbek                = 0x0443, //烏茲別克
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPWorldcardAddressController : NSObject

+ (NSUInteger)addressSystemLanguage;

+ (NSInteger)formatFromStreet:(NSString *)street
                         city:(NSString *)city
                     province:(NSString *)province
                   postalCode:(NSString *)postalCode
                  countryName:(NSMutableString *)countryName
                       format:(NSInteger)format
                  countryCode:(NSMutableString *)countryCode
                  bcrLanguage:(NSInteger)bcrLanguage
               systemLanguage:(NSInteger)systemLanguage;

+ (NSString *)addressFromStreet:(NSString *)street
                           city:(NSString *)city
                       province:(NSString *)province
                     postalCode:(NSString *)postalCode
                    countryName:(NSString *)countryName
                         format:(NSInteger)format;

+ (NSString *)googleMapAddressFromStreet:(NSString *)street
                                    city:(NSString *)city
                                province:(NSString *)province
                              postalCode:(NSString *)postalCode
                             countryCode:(NSString *)countryCode;

@end
